package waf_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainRuleGroup invokes the waf_openapi.DescribeDomainRuleGroup API synchronously
func (client *Client) DescribeDomainRuleGroup(request *DescribeDomainRuleGroupRequest) (response *DescribeDomainRuleGroupResponse, err error) {
	response = CreateDescribeDomainRuleGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainRuleGroupWithChan invokes the waf_openapi.DescribeDomainRuleGroup API asynchronously
func (client *Client) DescribeDomainRuleGroupWithChan(request *DescribeDomainRuleGroupRequest) (<-chan *DescribeDomainRuleGroupResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainRuleGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainRuleGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainRuleGroupWithCallback invokes the waf_openapi.DescribeDomainRuleGroup API asynchronously
func (client *Client) DescribeDomainRuleGroupWithCallback(request *DescribeDomainRuleGroupRequest, callback func(response *DescribeDomainRuleGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainRuleGroupResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainRuleGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainRuleGroupRequest is the request struct for api DescribeDomainRuleGroup
type DescribeDomainRuleGroupRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	Domain     string `position:"Query" name:"Domain"`
	Lang       string `position:"Query" name:"Lang"`
}

// DescribeDomainRuleGroupResponse is the response struct for api DescribeDomainRuleGroup
type DescribeDomainRuleGroupResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	RuleGroupId int64  `json:"RuleGroupId" xml:"RuleGroupId"`
}

// CreateDescribeDomainRuleGroupRequest creates a request to invoke DescribeDomainRuleGroup API
func CreateDescribeDomainRuleGroupRequest() (request *DescribeDomainRuleGroupRequest) {
	request = &DescribeDomainRuleGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("waf-openapi", "2019-09-10", "DescribeDomainRuleGroup", "waf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainRuleGroupResponse creates a response to parse from DescribeDomainRuleGroup response
func CreateDescribeDomainRuleGroupResponse() (response *DescribeDomainRuleGroupResponse) {
	response = &DescribeDomainRuleGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
