# IBM Cloud Provider Examples

This directory contains a set of examples of using various IBM Cloud services with
Terraform. The examples each have their own README containing more details
on what the example does.

To run any example, clone the repository and run `terraform apply` within
the example's own directory.

For example:

```
$ git clone git@github.com:IBM-Cloud/terraform-provider-ibm.git
$ cd terraform-provider-ibm/examples/ibm-vsi
$ terraform apply
...
```

## Related links

[IBM Cloud Terraform Templates](https://github.com/Cloud-Schematics/)

[IBM Cloud Architecture Center public cloud reference archiectures and terraform code patterns](https://www.ibm.com/cloud/garage/architectures/public-cloud)

[IBM Cloud docs](https://cloud.ibm.com/docs/terraform?topic=terraform-getting-started)

[Deploying Red Hat OpenShift Container Platform on IBM Cloud](https://github.com/IBM-Cloud/terraform-ibm-openshift)

[Set up an automated Secure Perimeter in IBM Cloud](https://developer.ibm.com/dwblog/2018/set-automated-secure-perimeter-ibm-cloud/)

[Implementing a Dedicated Solution Pattern](https://developer.ibm.com/dwblog/2018/ibm-cloud-dedicated-cloud-solution-patterns/)

[Plan, create and update deployment environments with IBM Cloud CLI and Terraform](https://cloud.ibm.com/docs/tutorials/plan-create-update-deployments.html?cm_mc_uid=19581587337515153907719&cm_mc_sid_50200000=78994781543468126114&cm_mc_sid_52640000=70446141542694902477)
