package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePublishedRouteEntries invokes the cbn.DescribePublishedRouteEntries API synchronously
func (client *Client) DescribePublishedRouteEntries(request *DescribePublishedRouteEntriesRequest) (response *DescribePublishedRouteEntriesResponse, err error) {
	response = CreateDescribePublishedRouteEntriesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePublishedRouteEntriesWithChan invokes the cbn.DescribePublishedRouteEntries API asynchronously
func (client *Client) DescribePublishedRouteEntriesWithChan(request *DescribePublishedRouteEntriesRequest) (<-chan *DescribePublishedRouteEntriesResponse, <-chan error) {
	responseChan := make(chan *DescribePublishedRouteEntriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePublishedRouteEntries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePublishedRouteEntriesWithCallback invokes the cbn.DescribePublishedRouteEntries API asynchronously
func (client *Client) DescribePublishedRouteEntriesWithCallback(request *DescribePublishedRouteEntriesRequest, callback func(response *DescribePublishedRouteEntriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePublishedRouteEntriesResponse
		var err error
		defer close(result)
		response, err = client.DescribePublishedRouteEntries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePublishedRouteEntriesRequest is the request struct for api DescribePublishedRouteEntries
type DescribePublishedRouteEntriesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId           requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CenId                     string           `position:"Query" name:"CenId"`
	PageNumber                requests.Integer `position:"Query" name:"PageNumber"`
	PageSize                  requests.Integer `position:"Query" name:"PageSize"`
	ChildInstanceRegionId     string           `position:"Query" name:"ChildInstanceRegionId"`
	ResourceOwnerAccount      string           `position:"Query" name:"ResourceOwnerAccount"`
	DestinationCidrBlock      string           `position:"Query" name:"DestinationCidrBlock"`
	ChildInstanceType         string           `position:"Query" name:"ChildInstanceType"`
	ChildInstanceId           string           `position:"Query" name:"ChildInstanceId"`
	ChildInstanceRouteTableId string           `position:"Query" name:"ChildInstanceRouteTableId"`
}

// DescribePublishedRouteEntriesResponse is the response struct for api DescribePublishedRouteEntries
type DescribePublishedRouteEntriesResponse struct {
	*responses.BaseResponse
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	PageNumber            int                   `json:"PageNumber" xml:"PageNumber"`
	TotalCount            int                   `json:"TotalCount" xml:"TotalCount"`
	PageSize              int                   `json:"PageSize" xml:"PageSize"`
	PublishedRouteEntries PublishedRouteEntries `json:"PublishedRouteEntries" xml:"PublishedRouteEntries"`
}

// CreateDescribePublishedRouteEntriesRequest creates a request to invoke DescribePublishedRouteEntries API
func CreateDescribePublishedRouteEntriesRequest() (request *DescribePublishedRouteEntriesRequest) {
	request = &DescribePublishedRouteEntriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DescribePublishedRouteEntries", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePublishedRouteEntriesResponse creates a response to parse from DescribePublishedRouteEntries response
func CreateDescribePublishedRouteEntriesResponse() (response *DescribePublishedRouteEntriesResponse) {
	response = &DescribePublishedRouteEntriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
