package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListScalingConfigItemV2 invokes the emr.ListScalingConfigItemV2 API synchronously
func (client *Client) ListScalingConfigItemV2(request *ListScalingConfigItemV2Request) (response *ListScalingConfigItemV2Response, err error) {
	response = CreateListScalingConfigItemV2Response()
	err = client.DoAction(request, response)
	return
}

// ListScalingConfigItemV2WithChan invokes the emr.ListScalingConfigItemV2 API asynchronously
func (client *Client) ListScalingConfigItemV2WithChan(request *ListScalingConfigItemV2Request) (<-chan *ListScalingConfigItemV2Response, <-chan error) {
	responseChan := make(chan *ListScalingConfigItemV2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListScalingConfigItemV2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListScalingConfigItemV2WithCallback invokes the emr.ListScalingConfigItemV2 API asynchronously
func (client *Client) ListScalingConfigItemV2WithCallback(request *ListScalingConfigItemV2Request, callback func(response *ListScalingConfigItemV2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListScalingConfigItemV2Response
		var err error
		defer close(result)
		response, err = client.ListScalingConfigItemV2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListScalingConfigItemV2Request is the request struct for api ListScalingConfigItemV2
type ListScalingConfigItemV2Request struct {
	*requests.RpcRequest
	ResourceOwnerId   requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageCount         requests.Integer `position:"Query" name:"PageCount"`
	OrderMode         string           `position:"Query" name:"OrderMode"`
	PageNumber        requests.Integer `position:"Query" name:"PageNumber"`
	ScalingGroupBizId string           `position:"Query" name:"ScalingGroupBizId"`
	ResourceGroupId   string           `position:"Query" name:"ResourceGroupId"`
	Limit             requests.Integer `position:"Query" name:"Limit"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	CurrentSize       requests.Integer `position:"Query" name:"CurrentSize"`
	OrderField        string           `position:"Query" name:"OrderField"`
	ConfigItemType    string           `position:"Query" name:"ConfigItemType"`
}

// ListScalingConfigItemV2Response is the response struct for api ListScalingConfigItemV2
type ListScalingConfigItemV2Response struct {
	*responses.BaseResponse
	RequestId  string                         `json:"RequestId" xml:"RequestId"`
	PageNumber int                            `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                            `json:"PageSize" xml:"PageSize"`
	TotalCount int                            `json:"TotalCount" xml:"TotalCount"`
	NextToken  string                         `json:"NextToken" xml:"NextToken"`
	Items      ItemsInListScalingConfigItemV2 `json:"Items" xml:"Items"`
}

// CreateListScalingConfigItemV2Request creates a request to invoke ListScalingConfigItemV2 API
func CreateListScalingConfigItemV2Request() (request *ListScalingConfigItemV2Request) {
	request = &ListScalingConfigItemV2Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListScalingConfigItemV2", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListScalingConfigItemV2Response creates a response to parse from ListScalingConfigItemV2 response
func CreateListScalingConfigItemV2Response() (response *ListScalingConfigItemV2Response) {
	response = &ListScalingConfigItemV2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
