package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyClusterBootstrapAction invokes the emr.ModifyClusterBootstrapAction API synchronously
func (client *Client) ModifyClusterBootstrapAction(request *ModifyClusterBootstrapActionRequest) (response *ModifyClusterBootstrapActionResponse, err error) {
	response = CreateModifyClusterBootstrapActionResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyClusterBootstrapActionWithChan invokes the emr.ModifyClusterBootstrapAction API asynchronously
func (client *Client) ModifyClusterBootstrapActionWithChan(request *ModifyClusterBootstrapActionRequest) (<-chan *ModifyClusterBootstrapActionResponse, <-chan error) {
	responseChan := make(chan *ModifyClusterBootstrapActionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyClusterBootstrapAction(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyClusterBootstrapActionWithCallback invokes the emr.ModifyClusterBootstrapAction API asynchronously
func (client *Client) ModifyClusterBootstrapActionWithCallback(request *ModifyClusterBootstrapActionRequest, callback func(response *ModifyClusterBootstrapActionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyClusterBootstrapActionResponse
		var err error
		defer close(result)
		response, err = client.ModifyClusterBootstrapAction(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyClusterBootstrapActionRequest is the request struct for api ModifyClusterBootstrapAction
type ModifyClusterBootstrapActionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer                               `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string                                         `position:"Query" name:"ClusterId"`
	BootstrapAction *[]ModifyClusterBootstrapActionBootstrapAction `position:"Query" name:"BootstrapAction"  type:"Repeated"`
	Id              string                                         `position:"Query" name:"Id"`
}

// ModifyClusterBootstrapActionBootstrapAction is a repeated param struct in ModifyClusterBootstrapActionRequest
type ModifyClusterBootstrapActionBootstrapAction struct {
	Path                  string `name:"Path"`
	ExecutionTarget       string `name:"ExecutionTarget"`
	ExecutionMoment       string `name:"ExecutionMoment"`
	Arg                   string `name:"Arg"`
	Name                  string `name:"Name"`
	ExecutionFailStrategy string `name:"ExecutionFailStrategy"`
}

// ModifyClusterBootstrapActionResponse is the response struct for api ModifyClusterBootstrapAction
type ModifyClusterBootstrapActionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyClusterBootstrapActionRequest creates a request to invoke ModifyClusterBootstrapAction API
func CreateModifyClusterBootstrapActionRequest() (request *ModifyClusterBootstrapActionRequest) {
	request = &ModifyClusterBootstrapActionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyClusterBootstrapAction", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyClusterBootstrapActionResponse creates a response to parse from ModifyClusterBootstrapAction response
func CreateModifyClusterBootstrapActionResponse() (response *ModifyClusterBootstrapActionResponse) {
	response = &ModifyClusterBootstrapActionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
