package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEnterpriseCode invokes the smartag.DeleteEnterpriseCode API synchronously
func (client *Client) DeleteEnterpriseCode(request *DeleteEnterpriseCodeRequest) (response *DeleteEnterpriseCodeResponse, err error) {
	response = CreateDeleteEnterpriseCodeResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEnterpriseCodeWithChan invokes the smartag.DeleteEnterpriseCode API asynchronously
func (client *Client) DeleteEnterpriseCodeWithChan(request *DeleteEnterpriseCodeRequest) (<-chan *DeleteEnterpriseCodeResponse, <-chan error) {
	responseChan := make(chan *DeleteEnterpriseCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEnterpriseCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEnterpriseCodeWithCallback invokes the smartag.DeleteEnterpriseCode API asynchronously
func (client *Client) DeleteEnterpriseCodeWithCallback(request *DeleteEnterpriseCodeRequest, callback func(response *DeleteEnterpriseCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEnterpriseCodeResponse
		var err error
		defer close(result)
		response, err = client.DeleteEnterpriseCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEnterpriseCodeRequest is the request struct for api DeleteEnterpriseCode
type DeleteEnterpriseCodeRequest struct {
	*requests.RpcRequest
	ClientToken    string           `position:"Query" name:"ClientToken"`
	EnterpriseCode string           `position:"Query" name:"EnterpriseCode"`
	DryRun         requests.Boolean `position:"Query" name:"DryRun"`
}

// DeleteEnterpriseCodeResponse is the response struct for api DeleteEnterpriseCode
type DeleteEnterpriseCodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteEnterpriseCodeRequest creates a request to invoke DeleteEnterpriseCode API
func CreateDeleteEnterpriseCodeRequest() (request *DeleteEnterpriseCodeRequest) {
	request = &DeleteEnterpriseCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DeleteEnterpriseCode", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteEnterpriseCodeResponse creates a response to parse from DeleteEnterpriseCode response
func CreateDeleteEnterpriseCodeResponse() (response *DeleteEnterpriseCodeResponse) {
	response = &DeleteEnterpriseCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
