package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSagDropTopN invokes the smartag.DescribeSagDropTopN API synchronously
func (client *Client) DescribeSagDropTopN(request *DescribeSagDropTopNRequest) (response *DescribeSagDropTopNResponse, err error) {
	response = CreateDescribeSagDropTopNResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSagDropTopNWithChan invokes the smartag.DescribeSagDropTopN API asynchronously
func (client *Client) DescribeSagDropTopNWithChan(request *DescribeSagDropTopNRequest) (<-chan *DescribeSagDropTopNResponse, <-chan error) {
	responseChan := make(chan *DescribeSagDropTopNResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSagDropTopN(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSagDropTopNWithCallback invokes the smartag.DescribeSagDropTopN API asynchronously
func (client *Client) DescribeSagDropTopNWithCallback(request *DescribeSagDropTopNRequest, callback func(response *DescribeSagDropTopNResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSagDropTopNResponse
		var err error
		defer close(result)
		response, err = client.DescribeSagDropTopN(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSagDropTopNRequest is the request struct for api DescribeSagDropTopN
type DescribeSagDropTopNRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Size                 requests.Integer `position:"Query" name:"Size"`
}

// DescribeSagDropTopNResponse is the response struct for api DescribeSagDropTopN
type DescribeSagDropTopNResponse struct {
	*responses.BaseResponse
	RequestId string         `json:"RequestId" xml:"RequestId"`
	DropTopN  []DropTopNItem `json:"DropTopN" xml:"DropTopN"`
}

// CreateDescribeSagDropTopNRequest creates a request to invoke DescribeSagDropTopN API
func CreateDescribeSagDropTopNRequest() (request *DescribeSagDropTopNRequest) {
	request = &DescribeSagDropTopNRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeSagDropTopN", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSagDropTopNResponse creates a response to parse from DescribeSagDropTopN response
func CreateDescribeSagDropTopNResponse() (response *DescribeSagDropTopNResponse) {
	response = &DescribeSagDropTopNResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
