package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSagVbrRelations invokes the smartag.DescribeSagVbrRelations API synchronously
func (client *Client) DescribeSagVbrRelations(request *DescribeSagVbrRelationsRequest) (response *DescribeSagVbrRelationsResponse, err error) {
	response = CreateDescribeSagVbrRelationsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSagVbrRelationsWithChan invokes the smartag.DescribeSagVbrRelations API asynchronously
func (client *Client) DescribeSagVbrRelationsWithChan(request *DescribeSagVbrRelationsRequest) (<-chan *DescribeSagVbrRelationsResponse, <-chan error) {
	responseChan := make(chan *DescribeSagVbrRelationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSagVbrRelations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSagVbrRelationsWithCallback invokes the smartag.DescribeSagVbrRelations API asynchronously
func (client *Client) DescribeSagVbrRelationsWithCallback(request *DescribeSagVbrRelationsRequest, callback func(response *DescribeSagVbrRelationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSagVbrRelationsResponse
		var err error
		defer close(result)
		response, err = client.DescribeSagVbrRelations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSagVbrRelationsRequest is the request struct for api DescribeSagVbrRelations
type DescribeSagVbrRelationsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	VbrInstanceIds       *[]string        `position:"Query" name:"VbrInstanceIds"  type:"Repeated"`
	VbrRegionId          string           `position:"Query" name:"VbrRegionId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeSagVbrRelationsResponse is the response struct for api DescribeSagVbrRelations
type DescribeSagVbrRelationsResponse struct {
	*responses.BaseResponse
	RequestId       string           `json:"RequestId" xml:"RequestId"`
	SagVbrRelations []SagVbrRelation `json:"SagVbrRelations" xml:"SagVbrRelations"`
}

// CreateDescribeSagVbrRelationsRequest creates a request to invoke DescribeSagVbrRelations API
func CreateDescribeSagVbrRelationsRequest() (request *DescribeSagVbrRelationsRequest) {
	request = &DescribeSagVbrRelationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeSagVbrRelations", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSagVbrRelationsResponse creates a response to parse from DescribeSagVbrRelations response
func CreateDescribeSagVbrRelationsResponse() (response *DescribeSagVbrRelationsResponse) {
	response = &DescribeSagVbrRelationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
