package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTrafficMirrorServiceStatus invokes the vpc.GetTrafficMirrorServiceStatus API synchronously
func (client *Client) GetTrafficMirrorServiceStatus(request *GetTrafficMirrorServiceStatusRequest) (response *GetTrafficMirrorServiceStatusResponse, err error) {
	response = CreateGetTrafficMirrorServiceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetTrafficMirrorServiceStatusWithChan invokes the vpc.GetTrafficMirrorServiceStatus API asynchronously
func (client *Client) GetTrafficMirrorServiceStatusWithChan(request *GetTrafficMirrorServiceStatusRequest) (<-chan *GetTrafficMirrorServiceStatusResponse, <-chan error) {
	responseChan := make(chan *GetTrafficMirrorServiceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTrafficMirrorServiceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTrafficMirrorServiceStatusWithCallback invokes the vpc.GetTrafficMirrorServiceStatus API asynchronously
func (client *Client) GetTrafficMirrorServiceStatusWithCallback(request *GetTrafficMirrorServiceStatusRequest, callback func(response *GetTrafficMirrorServiceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTrafficMirrorServiceStatusResponse
		var err error
		defer close(result)
		response, err = client.GetTrafficMirrorServiceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTrafficMirrorServiceStatusRequest is the request struct for api GetTrafficMirrorServiceStatus
type GetTrafficMirrorServiceStatusRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// GetTrafficMirrorServiceStatusResponse is the response struct for api GetTrafficMirrorServiceStatus
type GetTrafficMirrorServiceStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Enabled   bool   `json:"Enabled" xml:"Enabled"`
}

// CreateGetTrafficMirrorServiceStatusRequest creates a request to invoke GetTrafficMirrorServiceStatus API
func CreateGetTrafficMirrorServiceStatusRequest() (request *GetTrafficMirrorServiceStatusRequest) {
	request = &GetTrafficMirrorServiceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "GetTrafficMirrorServiceStatus", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetTrafficMirrorServiceStatusResponse creates a response to parse from GetTrafficMirrorServiceStatus response
func CreateGetTrafficMirrorServiceStatusResponse() (response *GetTrafficMirrorServiceStatusResponse) {
	response = &GetTrafficMirrorServiceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
