package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVpnCertificateAssociations invokes the vpc.ListVpnCertificateAssociations API synchronously
func (client *Client) ListVpnCertificateAssociations(request *ListVpnCertificateAssociationsRequest) (response *ListVpnCertificateAssociationsResponse, err error) {
	response = CreateListVpnCertificateAssociationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListVpnCertificateAssociationsWithChan invokes the vpc.ListVpnCertificateAssociations API asynchronously
func (client *Client) ListVpnCertificateAssociationsWithChan(request *ListVpnCertificateAssociationsRequest) (<-chan *ListVpnCertificateAssociationsResponse, <-chan error) {
	responseChan := make(chan *ListVpnCertificateAssociationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVpnCertificateAssociations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVpnCertificateAssociationsWithCallback invokes the vpc.ListVpnCertificateAssociations API asynchronously
func (client *Client) ListVpnCertificateAssociationsWithCallback(request *ListVpnCertificateAssociationsRequest, callback func(response *ListVpnCertificateAssociationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVpnCertificateAssociationsResponse
		var err error
		defer close(result)
		response, err = client.ListVpnCertificateAssociations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVpnCertificateAssociationsRequest is the request struct for api ListVpnCertificateAssociations
type ListVpnCertificateAssociationsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CertificateId   *[]string        `position:"Query" name:"CertificateId"  type:"Repeated"`
	VpnGatewayId    *[]string        `position:"Query" name:"VpnGatewayId"  type:"Repeated"`
	CallerBid       string           `position:"Query" name:"callerBid"`
	CertificateType string           `position:"Query" name:"CertificateType"`
	NextToken       string           `position:"Query" name:"NextToken"`
	MaxResults      requests.Integer `position:"Query" name:"MaxResults"`
}

// ListVpnCertificateAssociationsResponse is the response struct for api ListVpnCertificateAssociations
type ListVpnCertificateAssociationsResponse struct {
	*responses.BaseResponse
	RequestId               string                   `json:"RequestId" xml:"RequestId"`
	NextToken               string                   `json:"NextToken" xml:"NextToken"`
	MaxResults              int                      `json:"MaxResults" xml:"MaxResults"`
	TotalCount              int                      `json:"TotalCount" xml:"TotalCount"`
	VpnCertificateRelations []VpnCertificateRelation `json:"VpnCertificateRelations" xml:"VpnCertificateRelations"`
}

// CreateListVpnCertificateAssociationsRequest creates a request to invoke ListVpnCertificateAssociations API
func CreateListVpnCertificateAssociationsRequest() (request *ListVpnCertificateAssociationsRequest) {
	request = &ListVpnCertificateAssociationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ListVpnCertificateAssociations", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListVpnCertificateAssociationsResponse creates a response to parse from ListVpnCertificateAssociations response
func CreateListVpnCertificateAssociationsResponse() (response *ListVpnCertificateAssociationsResponse) {
	response = &ListVpnCertificateAssociationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
