package compute

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// OperationalizationClustersClient is the these APIs allow end users to operate on Azure Machine Learning Compute
// resources. They support the following operations:<ul><li>Create or update a cluster</li><li>Get a
// cluster</li><li>Patch a cluster</li><li>Delete a cluster</li><li>Get keys for a cluster</li><li>Check if updates are
// available for system services in a cluster</li><li>Update system services in a cluster</li><li>Get all clusters in a
// resource group</li><li>Get all clusters in a subscription</li></ul>
type OperationalizationClustersClient struct {
	BaseClient
}

// NewOperationalizationClustersClient creates an instance of the OperationalizationClustersClient client.
func NewOperationalizationClustersClient(subscriptionID string) OperationalizationClustersClient {
	return NewOperationalizationClustersClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewOperationalizationClustersClientWithBaseURI creates an instance of the OperationalizationClustersClient client
// using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign
// clouds, Azure stack).
func NewOperationalizationClustersClientWithBaseURI(baseURI string, subscriptionID string) OperationalizationClustersClient {
	return OperationalizationClustersClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CheckSystemServicesUpdatesAvailable checks if updates are available for system services in the cluster.
// Parameters:
// resourceGroupName - name of the resource group in which the cluster is located.
// clusterName - the name of the cluster.
func (client OperationalizationClustersClient) CheckSystemServicesUpdatesAvailable(ctx context.Context, resourceGroupName string, clusterName string) (result CheckSystemServicesUpdatesAvailableResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationalizationClustersClient.CheckSystemServicesUpdatesAvailable")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: clusterName,
			Constraints: []validation.Constraint{{Target: "clusterName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "clusterName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "clusterName", Name: validation.Pattern, Rule: `^[a-zA-Z][-\w\._\(\)]+[a-zA-Z0-9]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("compute.OperationalizationClustersClient", "CheckSystemServicesUpdatesAvailable", err.Error())
	}

	req, err := client.CheckSystemServicesUpdatesAvailablePreparer(ctx, resourceGroupName, clusterName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "CheckSystemServicesUpdatesAvailable", nil, "Failure preparing request")
		return
	}

	resp, err := client.CheckSystemServicesUpdatesAvailableSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "CheckSystemServicesUpdatesAvailable", resp, "Failure sending request")
		return
	}

	result, err = client.CheckSystemServicesUpdatesAvailableResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "CheckSystemServicesUpdatesAvailable", resp, "Failure responding to request")
		return
	}

	return
}

// CheckSystemServicesUpdatesAvailablePreparer prepares the CheckSystemServicesUpdatesAvailable request.
func (client OperationalizationClustersClient) CheckSystemServicesUpdatesAvailablePreparer(ctx context.Context, resourceGroupName string, clusterName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}/checkSystemServicesUpdatesAvailable", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CheckSystemServicesUpdatesAvailableSender sends the CheckSystemServicesUpdatesAvailable request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) CheckSystemServicesUpdatesAvailableSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CheckSystemServicesUpdatesAvailableResponder handles the response to the CheckSystemServicesUpdatesAvailable request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) CheckSystemServicesUpdatesAvailableResponder(resp *http.Response) (result CheckSystemServicesUpdatesAvailableResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdate create or update an operationalization cluster.
// Parameters:
// resourceGroupName - name of the resource group in which the cluster is located.
// clusterName - the name of the cluster.
// parameters - parameters supplied to create or update an Operationalization cluster.
func (client OperationalizationClustersClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, clusterName string, parameters OperationalizationCluster) (result OperationalizationClustersCreateOrUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationalizationClustersClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: clusterName,
			Constraints: []validation.Constraint{{Target: "clusterName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "clusterName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "clusterName", Name: validation.Pattern, Rule: `^[a-zA-Z][-\w\._\(\)]+[a-zA-Z0-9]$`, Chain: nil}}},
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.ContainerService", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.ContainerService.OrchestratorProperties", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.ContainerService.OrchestratorProperties.ServicePrincipal", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.ContainerService.OrchestratorProperties.ServicePrincipal.ClientID", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "parameters.OperationalizationClusterProperties.ContainerService.OrchestratorProperties.ServicePrincipal.Secret", Name: validation.Null, Rule: true, Chain: nil},
							}},
						}},
						{Target: "parameters.OperationalizationClusterProperties.ContainerService.MasterCount", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.ContainerService.MasterCount", Name: validation.InclusiveMaximum, Rule: int64(5), Chain: nil},
								{Target: "parameters.OperationalizationClusterProperties.ContainerService.MasterCount", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil},
							}},
						{Target: "parameters.OperationalizationClusterProperties.ContainerService.AgentCount", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.ContainerService.AgentCount", Name: validation.InclusiveMaximum, Rule: int64(100), Chain: nil},
								{Target: "parameters.OperationalizationClusterProperties.ContainerService.AgentCount", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil},
							}},
					}},
					{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration.ServiceAuth", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration.ServiceAuth.PrimaryAuthKeyHash", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration.ServiceAuth.SecondaryAuthKeyHash", Name: validation.Null, Rule: true, Chain: nil},
							}},
							{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration.AutoScale", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration.AutoScale.MinReplicas", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration.AutoScale.MinReplicas", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}},
									{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration.AutoScale.MaxReplicas", Name: validation.Null, Rule: false,
										Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration.AutoScale.MaxReplicas", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}},
								}},
						}},
				}}}}}); err != nil {
		return result, validation.NewError("compute.OperationalizationClustersClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, clusterName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "CreateOrUpdate", nil, "Failure sending request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client OperationalizationClustersClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, clusterName string, parameters OperationalizationCluster) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) CreateOrUpdateSender(req *http.Request) (future OperationalizationClustersCreateOrUpdateFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client OperationalizationClustersClient) (oc OperationalizationCluster, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("compute.OperationalizationClustersCreateOrUpdateFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		oc.Response.Response, err = future.GetResult(sender)
		if oc.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersCreateOrUpdateFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && oc.Response.Response.StatusCode != http.StatusNoContent {
			oc, err = client.CreateOrUpdateResponder(oc.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersCreateOrUpdateFuture", "Result", oc.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) CreateOrUpdateResponder(resp *http.Response) (result OperationalizationCluster, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes the specified cluster.
// Parameters:
// resourceGroupName - name of the resource group in which the cluster is located.
// clusterName - the name of the cluster.
// deleteAll - if true, deletes all resources associated with this cluster.
func (client OperationalizationClustersClient) Delete(ctx context.Context, resourceGroupName string, clusterName string, deleteAll *bool) (result OperationalizationClustersDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationalizationClustersClient.Delete")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: clusterName,
			Constraints: []validation.Constraint{{Target: "clusterName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "clusterName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "clusterName", Name: validation.Pattern, Rule: `^[a-zA-Z][-\w\._\(\)]+[a-zA-Z0-9]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("compute.OperationalizationClustersClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, clusterName, deleteAll)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "Delete", nil, "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client OperationalizationClustersClient) DeletePreparer(ctx context.Context, resourceGroupName string, clusterName string, deleteAll *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if deleteAll != nil {
		queryParameters["deleteAll"] = autorest.Encode("query", *deleteAll)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) DeleteSender(req *http.Request) (future OperationalizationClustersDeleteFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client OperationalizationClustersClient) (ar autorest.Response, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersDeleteFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("compute.OperationalizationClustersDeleteFuture")
			return
		}
		ar.Response = future.Response()
		return
	}
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets the operationalization cluster resource view. Note that the credentials are not returned by this call. Call
// ListKeys to get them.
// Parameters:
// resourceGroupName - name of the resource group in which the cluster is located.
// clusterName - the name of the cluster.
func (client OperationalizationClustersClient) Get(ctx context.Context, resourceGroupName string, clusterName string) (result OperationalizationCluster, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationalizationClustersClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: clusterName,
			Constraints: []validation.Constraint{{Target: "clusterName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "clusterName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "clusterName", Name: validation.Pattern, Rule: `^[a-zA-Z][-\w\._\(\)]+[a-zA-Z0-9]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("compute.OperationalizationClustersClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, clusterName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client OperationalizationClustersClient) GetPreparer(ctx context.Context, resourceGroupName string, clusterName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) GetResponder(resp *http.Response) (result OperationalizationCluster, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroup gets the clusters in the specified resource group.
// Parameters:
// resourceGroupName - name of the resource group in which the cluster is located.
// skiptoken - continuation token for pagination.
func (client OperationalizationClustersClient) ListByResourceGroup(ctx context.Context, resourceGroupName string, skiptoken string) (result PaginatedOperationalizationClustersListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationalizationClustersClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.pocl.Response.Response != nil {
				sc = result.pocl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("compute.OperationalizationClustersClient", "ListByResourceGroup", err.Error())
	}

	result.fn = client.listByResourceGroupNextResults
	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName, skiptoken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.pocl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result.pocl, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "ListByResourceGroup", resp, "Failure responding to request")
		return
	}
	if result.pocl.hasNextLink() && result.pocl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client OperationalizationClustersClient) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string, skiptoken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skiptoken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skiptoken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) ListByResourceGroupResponder(resp *http.Response) (result PaginatedOperationalizationClustersList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNextResults retrieves the next set of results, if any.
func (client OperationalizationClustersClient) listByResourceGroupNextResults(ctx context.Context, lastResults PaginatedOperationalizationClustersList) (result PaginatedOperationalizationClustersList, err error) {
	req, err := lastResults.paginatedOperationalizationClustersListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "listByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "listByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "listByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client OperationalizationClustersClient) ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, skiptoken string) (result PaginatedOperationalizationClustersListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationalizationClustersClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroup(ctx, resourceGroupName, skiptoken)
	return
}

// ListBySubscriptionID gets the operationalization clusters in the specified subscription.
// Parameters:
// skiptoken - continuation token for pagination.
func (client OperationalizationClustersClient) ListBySubscriptionID(ctx context.Context, skiptoken string) (result PaginatedOperationalizationClustersListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationalizationClustersClient.ListBySubscriptionID")
		defer func() {
			sc := -1
			if result.pocl.Response.Response != nil {
				sc = result.pocl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listBySubscriptionIDNextResults
	req, err := client.ListBySubscriptionIDPreparer(ctx, skiptoken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "ListBySubscriptionID", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBySubscriptionIDSender(req)
	if err != nil {
		result.pocl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "ListBySubscriptionID", resp, "Failure sending request")
		return
	}

	result.pocl, err = client.ListBySubscriptionIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "ListBySubscriptionID", resp, "Failure responding to request")
		return
	}
	if result.pocl.hasNextLink() && result.pocl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListBySubscriptionIDPreparer prepares the ListBySubscriptionID request.
func (client OperationalizationClustersClient) ListBySubscriptionIDPreparer(ctx context.Context, skiptoken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skiptoken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skiptoken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.MachineLearningCompute/operationalizationClusters", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBySubscriptionIDSender sends the ListBySubscriptionID request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) ListBySubscriptionIDSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBySubscriptionIDResponder handles the response to the ListBySubscriptionID request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) ListBySubscriptionIDResponder(resp *http.Response) (result PaginatedOperationalizationClustersList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listBySubscriptionIDNextResults retrieves the next set of results, if any.
func (client OperationalizationClustersClient) listBySubscriptionIDNextResults(ctx context.Context, lastResults PaginatedOperationalizationClustersList) (result PaginatedOperationalizationClustersList, err error) {
	req, err := lastResults.paginatedOperationalizationClustersListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "listBySubscriptionIDNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListBySubscriptionIDSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "listBySubscriptionIDNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListBySubscriptionIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "listBySubscriptionIDNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListBySubscriptionIDComplete enumerates all values, automatically crossing page boundaries as required.
func (client OperationalizationClustersClient) ListBySubscriptionIDComplete(ctx context.Context, skiptoken string) (result PaginatedOperationalizationClustersListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationalizationClustersClient.ListBySubscriptionID")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListBySubscriptionID(ctx, skiptoken)
	return
}

// ListKeys gets the credentials for the specified cluster such as Storage, ACR and ACS credentials. This is a long
// running operation because it fetches keys from dependencies.
// Parameters:
// resourceGroupName - name of the resource group in which the cluster is located.
// clusterName - the name of the cluster.
func (client OperationalizationClustersClient) ListKeys(ctx context.Context, resourceGroupName string, clusterName string) (result OperationalizationClusterCredentials, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationalizationClustersClient.ListKeys")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: clusterName,
			Constraints: []validation.Constraint{{Target: "clusterName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "clusterName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "clusterName", Name: validation.Pattern, Rule: `^[a-zA-Z][-\w\._\(\)]+[a-zA-Z0-9]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("compute.OperationalizationClustersClient", "ListKeys", err.Error())
	}

	req, err := client.ListKeysPreparer(ctx, resourceGroupName, clusterName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "ListKeys", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "ListKeys", resp, "Failure sending request")
		return
	}

	result, err = client.ListKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "ListKeys", resp, "Failure responding to request")
		return
	}

	return
}

// ListKeysPreparer prepares the ListKeys request.
func (client OperationalizationClustersClient) ListKeysPreparer(ctx context.Context, resourceGroupName string, clusterName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}/listKeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListKeysSender sends the ListKeys request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) ListKeysSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListKeysResponder handles the response to the ListKeys request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) ListKeysResponder(resp *http.Response) (result OperationalizationClusterCredentials, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Update the PATCH operation can be used to update only the tags for a cluster. Use PUT operation to update other
// properties.
// Parameters:
// resourceGroupName - name of the resource group in which the cluster is located.
// clusterName - the name of the cluster.
// parameters - the parameters supplied to patch the cluster.
func (client OperationalizationClustersClient) Update(ctx context.Context, resourceGroupName string, clusterName string, parameters OperationalizationClusterUpdateParameters) (result OperationalizationCluster, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationalizationClustersClient.Update")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: clusterName,
			Constraints: []validation.Constraint{{Target: "clusterName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "clusterName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "clusterName", Name: validation.Pattern, Rule: `^[a-zA-Z][-\w\._\(\)]+[a-zA-Z0-9]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("compute.OperationalizationClustersClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, resourceGroupName, clusterName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "Update", resp, "Failure responding to request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client OperationalizationClustersClient) UpdatePreparer(ctx context.Context, resourceGroupName string, clusterName string, parameters OperationalizationClusterUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) UpdateResponder(resp *http.Response) (result OperationalizationCluster, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSystemServices updates system services in a cluster.
// Parameters:
// resourceGroupName - name of the resource group in which the cluster is located.
// clusterName - the name of the cluster.
func (client OperationalizationClustersClient) UpdateSystemServices(ctx context.Context, resourceGroupName string, clusterName string) (result OperationalizationClustersUpdateSystemServicesFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationalizationClustersClient.UpdateSystemServices")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: clusterName,
			Constraints: []validation.Constraint{{Target: "clusterName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "clusterName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "clusterName", Name: validation.Pattern, Rule: `^[a-zA-Z][-\w\._\(\)]+[a-zA-Z0-9]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("compute.OperationalizationClustersClient", "UpdateSystemServices", err.Error())
	}

	req, err := client.UpdateSystemServicesPreparer(ctx, resourceGroupName, clusterName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "UpdateSystemServices", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateSystemServicesSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "UpdateSystemServices", nil, "Failure sending request")
		return
	}

	return
}

// UpdateSystemServicesPreparer prepares the UpdateSystemServices request.
func (client OperationalizationClustersClient) UpdateSystemServicesPreparer(ctx context.Context, resourceGroupName string, clusterName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}/updateSystemServices", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSystemServicesSender sends the UpdateSystemServices request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) UpdateSystemServicesSender(req *http.Request) (future OperationalizationClustersUpdateSystemServicesFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client OperationalizationClustersClient) (ussr UpdateSystemServicesResponse, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersUpdateSystemServicesFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("compute.OperationalizationClustersUpdateSystemServicesFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		ussr.Response.Response, err = future.GetResult(sender)
		if ussr.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersUpdateSystemServicesFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && ussr.Response.Response.StatusCode != http.StatusNoContent {
			ussr, err = client.UpdateSystemServicesResponder(ussr.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersUpdateSystemServicesFuture", "Result", ussr.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// UpdateSystemServicesResponder handles the response to the UpdateSystemServices request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) UpdateSystemServicesResponder(resp *http.Response) (result UpdateSystemServicesResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
