// Package storagetables implements the Azure ARM Storagetables service API version 2019-02-02.
//
//
package storagetables

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

const (
	// DefaultVersion is the default value for version
	DefaultVersion = "2019-02-02"
)

// BaseClient is the base client for Storagetables.
type BaseClient struct {
	autorest.Client
	URL     string
	Version string
}

// New creates an instance of the BaseClient client.
func New(URL string) BaseClient {
	return NewWithoutDefaults(URL, DefaultVersion)
}

// NewWithoutDefaults creates an instance of the BaseClient client.
func NewWithoutDefaults(URL string, version string) BaseClient {
	return BaseClient{
		Client:  autorest.NewClientWithUserAgent(UserAgent()),
		URL:     URL,
		Version: version,
	}
}
