package security

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// AlertsSuppressionRulesClient is the API spec for Microsoft.Security (Azure Security Center) resource provider
type AlertsSuppressionRulesClient struct {
	BaseClient
}

// NewAlertsSuppressionRulesClient creates an instance of the AlertsSuppressionRulesClient client.
func NewAlertsSuppressionRulesClient(subscriptionID string, ascLocation string) AlertsSuppressionRulesClient {
	return NewAlertsSuppressionRulesClientWithBaseURI(DefaultBaseURI, subscriptionID, ascLocation)
}

// NewAlertsSuppressionRulesClientWithBaseURI creates an instance of the AlertsSuppressionRulesClient client using a
// custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds,
// Azure stack).
func NewAlertsSuppressionRulesClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) AlertsSuppressionRulesClient {
	return AlertsSuppressionRulesClient{NewWithBaseURI(baseURI, subscriptionID, ascLocation)}
}

// Delete delete dismiss alert rule for this subscription.
// Parameters:
// alertsSuppressionRuleName - the unique name of the suppression alert rule
func (client AlertsSuppressionRulesClient) Delete(ctx context.Context, alertsSuppressionRuleName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsSuppressionRulesClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.AlertsSuppressionRulesClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, alertsSuppressionRuleName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsSuppressionRulesClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "security.AlertsSuppressionRulesClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsSuppressionRulesClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client AlertsSuppressionRulesClient) DeletePreparer(ctx context.Context, alertsSuppressionRuleName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertsSuppressionRuleName": autorest.Encode("path", alertsSuppressionRuleName),
		"subscriptionId":            autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Security/alertsSuppressionRules/{alertsSuppressionRuleName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsSuppressionRulesClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client AlertsSuppressionRulesClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get get dismiss rule, with name: {alertsSuppressionRuleName}, for the given subscription
// Parameters:
// alertsSuppressionRuleName - the unique name of the suppression alert rule
func (client AlertsSuppressionRulesClient) Get(ctx context.Context, alertsSuppressionRuleName string) (result AlertsSuppressionRule, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsSuppressionRulesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.AlertsSuppressionRulesClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, alertsSuppressionRuleName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsSuppressionRulesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.AlertsSuppressionRulesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsSuppressionRulesClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client AlertsSuppressionRulesClient) GetPreparer(ctx context.Context, alertsSuppressionRuleName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertsSuppressionRuleName": autorest.Encode("path", alertsSuppressionRuleName),
		"subscriptionId":            autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Security/alertsSuppressionRules/{alertsSuppressionRuleName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsSuppressionRulesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client AlertsSuppressionRulesClient) GetResponder(resp *http.Response) (result AlertsSuppressionRule, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List list of all the dismiss rules for the given subscription
// Parameters:
// alertType - type of the alert to get rules for
func (client AlertsSuppressionRulesClient) List(ctx context.Context, alertType string) (result AlertsSuppressionRulesListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsSuppressionRulesClient.List")
		defer func() {
			sc := -1
			if result.asrl.Response.Response != nil {
				sc = result.asrl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.AlertsSuppressionRulesClient", "List", err.Error())
	}

	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, alertType)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsSuppressionRulesClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.asrl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.AlertsSuppressionRulesClient", "List", resp, "Failure sending request")
		return
	}

	result.asrl, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsSuppressionRulesClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client AlertsSuppressionRulesClient) ListPreparer(ctx context.Context, alertType string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(alertType) > 0 {
		queryParameters["AlertType"] = autorest.Encode("query", alertType)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Security/alertsSuppressionRules", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsSuppressionRulesClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client AlertsSuppressionRulesClient) ListResponder(resp *http.Response) (result AlertsSuppressionRulesList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client AlertsSuppressionRulesClient) listNextResults(ctx context.Context, lastResults AlertsSuppressionRulesList) (result AlertsSuppressionRulesList, err error) {
	req, err := lastResults.alertsSuppressionRulesListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "security.AlertsSuppressionRulesClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "security.AlertsSuppressionRulesClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsSuppressionRulesClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client AlertsSuppressionRulesClient) ListComplete(ctx context.Context, alertType string) (result AlertsSuppressionRulesListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsSuppressionRulesClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, alertType)
	return
}

// Update update existing rule or create new rule if it doesn't exist
// Parameters:
// alertsSuppressionRuleName - the unique name of the suppression alert rule
// alertsSuppressionRule - suppression rule object
func (client AlertsSuppressionRulesClient) Update(ctx context.Context, alertsSuppressionRuleName string, alertsSuppressionRule AlertsSuppressionRule) (result AlertsSuppressionRule, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsSuppressionRulesClient.Update")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}},
		{TargetValue: alertsSuppressionRule,
			Constraints: []validation.Constraint{{Target: "alertsSuppressionRule.AlertsSuppressionRuleProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "alertsSuppressionRule.AlertsSuppressionRuleProperties.AlertType", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "alertsSuppressionRule.AlertsSuppressionRuleProperties.Reason", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "alertsSuppressionRule.AlertsSuppressionRuleProperties.SuppressionAlertsScope", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "alertsSuppressionRule.AlertsSuppressionRuleProperties.SuppressionAlertsScope.AllOf", Name: validation.Null, Rule: true, Chain: nil}}},
				}}}}}); err != nil {
		return result, validation.NewError("security.AlertsSuppressionRulesClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, alertsSuppressionRuleName, alertsSuppressionRule)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsSuppressionRulesClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.AlertsSuppressionRulesClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsSuppressionRulesClient", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client AlertsSuppressionRulesClient) UpdatePreparer(ctx context.Context, alertsSuppressionRuleName string, alertsSuppressionRule AlertsSuppressionRule) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"alertsSuppressionRuleName": autorest.Encode("path", alertsSuppressionRuleName),
		"subscriptionId":            autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Security/alertsSuppressionRules/{alertsSuppressionRuleName}", pathParameters),
		autorest.WithJSON(alertsSuppressionRule),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsSuppressionRulesClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client AlertsSuppressionRulesClient) UpdateResponder(resp *http.Response) (result AlertsSuppressionRule, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
