/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Code generated by go-bindata.
// sources:
// wski18n/resources/de_DE.all.json
// wski18n/resources/en_US.all.json
// wski18n/resources/es_ES.all.json
// wski18n/resources/fr_FR.all.json
// wski18n/resources/it_IT.all.json
// wski18n/resources/ja_JA.all.json
// wski18n/resources/ko_KR.all.json
// wski18n/resources/pt_BR.all.json
// wski18n/resources/zh_Hans.all.json
// wski18n/resources/zh_Hant.all.json
// DO NOT EDIT!

package wski18n

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _wski18nResourcesDe_deAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x01\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00")

func wski18nResourcesDe_deAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesDe_deAllJson,
		"wski18n/resources/de_DE.all.json",
	)
}

func wski18nResourcesDe_deAllJson() (*asset, error) {
	bytes, err := wski18nResourcesDe_deAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/de_DE.all.json", size: 0, mode: os.FileMode(420), modTime: time.Unix(1510603210, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesEn_usAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xcc\x58\x5f\x6f\xdb\x36\x10\x7f\xf7\xa7\x38\xf8\xc5\x19\xe0\x0a\x7b\xd9\xc3\xba\xa7\xa0\x33\xe6\xa0\x5d\x63\xac\xce\x3a\x60\x19\x06\x46\x3c\x5b\x87\xc8\xa4\x7a\xa4\x9c\xb9\x86\xbe\xfb\x40\xca\x72\xd2\xc4\xb4\xfe\x58\x49\xf3\x64\x81\xe6\xfd\xee\xc7\xbb\xe3\xfd\xe1\xdf\x03\x80\xed\x00\x00\x60\x48\x72\xf8\x16\x86\x57\x4a\xdc\xa4\x08\x56\x83\x90\x12\x58\xe7\x16\x41\x67\x96\xb4\x32\x30\xda\x6e\xa3\xdd\x77\x51\x8c\x86\xe3\x52\xce\xb2\x50\x26\x15\x6e\xb9\x06\xe0\x2d\x3c\x04\x18\x0e\x00\x8a\x71\x58\x7f\xcc\x28\x2c\xc2\x74\x3e\x9f\x01\xe3\x97\x1c\x8d\x85\x85\x66\x98\x5d\xcd\x3d\x13\x0f\x5d\x14\x23\x8f\x8a\xcc\x45\x51\xcb\xa8\x03\x64\x47\x92\xbf\x4d\x7a\x27\x79\x04\xb2\x23\xc9\x5f\x27\x1f\x26\xf3\x49\xdf\x3c\x8f\xa3\x76\x75\xfa\xe5\xa7\xfe\xbd\x7e\x04\xb3\x86\xa6\xc8\x32\x54\x32\x70\x31\xdc\x86\xab\x3f\x3e\xec\x62\xbf\x23\xe9\xd3\x35\x34\xb3\x74\x65\x10\x07\xe7\x80\x72\x4e\x3b\x59\xb7\x16\xe7\x20\x9d\x0b\xb5\x16\x29\xc9\xae\x2c\x1a\x8b\x1f\x54\x3e\x61\xd6\x0c\xa8\x62\x2d\x49\x2d\xf7\x20\x37\x5a\x6e\x6a\x35\x37\x93\x3d\xa2\x96\x14\x59\x12\x29\x7d\x7d\x20\xde\x50\x6b\x8d\x68\x5d\xe8\x4a\x09\x36\xd9\x5d\x07\x91\xdb\x04\x95\xa5\xd8\xab\x80\x04\x85\x44\x6e\x13\xa5\x6d\xc0\x0e\x12\x3b\xcf\x6d\xa2\x99\xbe\x96\x32\xb7\xb8\x01\x32\xa0\xb4\x85\x58\xab\x05\x2d\x73\x46\x09\x67\x6f\xde\x38\x6c\xf7\x8f\x3b\x2e\x31\xca\x1f\x02\xd4\x3a\xc3\x1d\x26\xa7\xe0\x7c\x76\x01\x89\x36\x16\x56\xb9\xf3\x2f\x42\xc6\x7a\x4d\x12\x65\x74\xad\x42\x1c\x6a\xa4\x1a\x38\xe8\xe5\xeb\xee\x3b\xbd\x5a\x09\x25\x61\x21\x28\x45\x09\x32\x2f\xa1\x54\xe9\x5a\xb7\x9a\x33\x06\x54\x37\x93\x3d\xa8\xf6\xa3\x06\x52\x16\x79\x21\xe2\x7b\x23\xfd\x02\x4a\x57\xe9\xda\x64\x5a\x19\xf4\x17\x0b\xf0\xbf\x0c\x63\x8b\x32\x40\xa3\x1b\x56\x3b\x6b\x78\x05\x4a\xa4\x5d\x2d\xf2\x44\xfe\xa0\xfa\x79\x82\xb0\xd0\x69\xaa\xef\xdc\x15\x17\x59\x96\x56\x97\x0a\x7d\x06\xb8\x13\x2e\x74\x63\xa4\x35\xca\xda\xdb\xda\x11\xec\xf5\xe5\xeb\x57\x9b\xc3\xee\xb1\xdc\x81\x32\xc1\xa6\x2c\xca\x6b\x64\x43\x5a\xb5\xab\xa7\x0d\x20\x4e\xec\x49\xbb\x96\xf8\xe6\x80\xdd\x09\xf6\xc3\xaa\x39\x95\x9b\x9c\xd2\x6f\xe2\xb1\x05\x81\x63\xb2\xcd\x2c\xe0\x0c\xf8\x84\xff\x69\x5d\x6e\x1b\xc8\x66\x24\xdd\x70\xd4\x33\xc9\x36\x90\xcd\x48\xee\x86\x8e\x9e\x79\xb6\x44\x6d\x68\x4f\x37\x76\xf4\x6d\xd0\x36\x98\x81\xcc\xbe\x2b\x4c\xbe\x28\x44\x50\xa5\x6a\x63\xc5\xbe\x91\xf0\x80\x7e\xa1\x28\x46\x11\xfc\xe9\x37\x54\x4d\x8a\x60\x84\xeb\xa1\x88\x2d\xad\xf1\x7a\x08\xae\xfa\x5d\x0f\x49\x55\x0b\x51\xb0\x24\x3c\xb7\xde\x1a\xaf\x94\xb9\xb6\xaa\x44\x1d\x5c\x50\x0b\x50\x47\x80\x75\x8c\xc6\x78\x84\x2f\x39\xf2\x26\xd0\xf7\xb5\xa1\xd4\x1e\xf2\x20\xc9\xed\x36\x5a\x99\x65\x51\xc0\x59\xac\x25\xba\xcd\xee\xb7\x28\x42\xdd\x77\x78\x7f\xb0\xcd\x89\xb5\x52\x18\x7b\x2f\x97\xcd\xd2\x18\x34\x83\xa5\x15\x4a\xd0\xb9\x8d\xe0\xcc\x87\xb5\xf3\x7e\x6e\xa0\x19\x8d\xd3\x71\x5b\xcf\xce\x63\xb8\xc1\x58\xe4\x06\xe1\x32\x43\xf5\x39\x21\x73\x7b\x3f\x04\x90\x81\x15\x19\x43\x6a\xd9\x61\x9a\x6e\x8a\x7c\x02\x65\xd7\xfd\x88\x8c\x4a\x48\x17\x21\xee\xa3\x28\x46\x0e\x9e\xca\xfb\x78\xd2\x83\x40\x57\x4d\x07\x8f\x74\xd4\x0a\x70\x36\x4b\x51\x18\xbc\x1f\xf7\xe0\xf3\xf4\xe2\xd3\xfb\x7f\xcf\x67\x17\x53\x97\x23\x49\x41\x74\x67\x6e\x33\xd6\x99\x81\x5c\x49\x64\xcf\xc9\x6c\x8c\xc5\x15\x4c\x2f\x7f\x9f\x80\x24\xc6\xd8\x6a\xde\x44\xa1\xf8\x7a\x51\x0a\xbd\x18\xe1\xce\xed\x8d\x44\x46\xde\xe0\x51\xc6\xda\xea\xf1\xe3\x55\x25\x56\xe8\xf3\xe7\xe3\xdd\x9a\xad\x63\x5d\x2e\x3b\xde\xc8\x96\xf0\x21\xf9\xcb\xd9\xe4\x63\x79\xca\x67\x32\xe1\x77\x3c\x40\xf0\xd9\xe2\xc1\x9c\xb0\x7b\x68\x08\xf3\x3f\xbf\x9a\x4f\xfb\x09\xbe\x97\xd0\xdc\xcb\x91\x2d\x1a\x4b\x6a\x19\xf9\xb7\x16\x61\xbc\xc2\x4c\xd8\x04\xf4\xa2\xcc\x03\x4f\xf1\x16\x94\x62\xdf\x91\xf6\xea\x69\xd7\x24\xee\x54\x8b\x72\x3e\xfd\xeb\xa7\x1f\x7f\xf6\xea\x32\x41\x5c\x3d\x29\xd8\x6f\x86\x7b\x46\x61\xb4\x6a\x91\xab\x4f\x02\x0f\xd6\xf4\x77\xc8\x76\x67\x94\xc7\x8f\x6f\x11\x3c\x35\x78\x82\x7b\x77\xec\x25\xc3\xaf\x6b\x3d\x2a\x08\x1e\xe0\xfd\xde\xa9\x2d\xe1\x2b\xc1\xe3\xf4\x7b\x81\x77\xe4\x07\xff\x0c\xfe\x0f\x00\x00\xff\xff\xab\x99\xa5\xc1\xc1\x1b\x00\x00")

func wski18nResourcesEn_usAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesEn_usAllJson,
		"wski18n/resources/en_US.all.json",
	)
}

func wski18nResourcesEn_usAllJson() (*asset, error) {
	bytes, err := wski18nResourcesEn_usAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/en_US.all.json", size: 7105, mode: os.FileMode(420), modTime: time.Unix(1510603813, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesEs_esAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x01\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00")

func wski18nResourcesEs_esAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesEs_esAllJson,
		"wski18n/resources/es_ES.all.json",
	)
}

func wski18nResourcesEs_esAllJson() (*asset, error) {
	bytes, err := wski18nResourcesEs_esAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/es_ES.all.json", size: 0, mode: os.FileMode(420), modTime: time.Unix(1510603210, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesFr_frAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x01\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00")

func wski18nResourcesFr_frAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesFr_frAllJson,
		"wski18n/resources/fr_FR.all.json",
	)
}

func wski18nResourcesFr_frAllJson() (*asset, error) {
	bytes, err := wski18nResourcesFr_frAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/fr_FR.all.json", size: 0, mode: os.FileMode(420), modTime: time.Unix(1510603210, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesIt_itAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x01\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00")

func wski18nResourcesIt_itAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesIt_itAllJson,
		"wski18n/resources/it_IT.all.json",
	)
}

func wski18nResourcesIt_itAllJson() (*asset, error) {
	bytes, err := wski18nResourcesIt_itAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/it_IT.all.json", size: 0, mode: os.FileMode(420), modTime: time.Unix(1510603210, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesJa_jaAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x01\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00")

func wski18nResourcesJa_jaAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesJa_jaAllJson,
		"wski18n/resources/ja_JA.all.json",
	)
}

func wski18nResourcesJa_jaAllJson() (*asset, error) {
	bytes, err := wski18nResourcesJa_jaAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/ja_JA.all.json", size: 0, mode: os.FileMode(420), modTime: time.Unix(1510603210, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesKo_krAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x01\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00")

func wski18nResourcesKo_krAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesKo_krAllJson,
		"wski18n/resources/ko_KR.all.json",
	)
}

func wski18nResourcesKo_krAllJson() (*asset, error) {
	bytes, err := wski18nResourcesKo_krAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/ko_KR.all.json", size: 0, mode: os.FileMode(420), modTime: time.Unix(1510603210, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesPt_brAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x01\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00")

func wski18nResourcesPt_brAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesPt_brAllJson,
		"wski18n/resources/pt_BR.all.json",
	)
}

func wski18nResourcesPt_brAllJson() (*asset, error) {
	bytes, err := wski18nResourcesPt_brAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/pt_BR.all.json", size: 0, mode: os.FileMode(420), modTime: time.Unix(1510603210, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesZh_hansAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x01\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00")

func wski18nResourcesZh_hansAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesZh_hansAllJson,
		"wski18n/resources/zh_Hans.all.json",
	)
}

func wski18nResourcesZh_hansAllJson() (*asset, error) {
	bytes, err := wski18nResourcesZh_hansAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/zh_Hans.all.json", size: 0, mode: os.FileMode(420), modTime: time.Unix(1510603210, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesZh_hantAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x01\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00")

func wski18nResourcesZh_hantAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesZh_hantAllJson,
		"wski18n/resources/zh_Hant.all.json",
	)
}

func wski18nResourcesZh_hantAllJson() (*asset, error) {
	bytes, err := wski18nResourcesZh_hantAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/zh_Hant.all.json", size: 0, mode: os.FileMode(420), modTime: time.Unix(1510603210, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"wski18n/resources/de_DE.all.json":   wski18nResourcesDe_deAllJson,
	"wski18n/resources/en_US.all.json":   wski18nResourcesEn_usAllJson,
	"wski18n/resources/es_ES.all.json":   wski18nResourcesEs_esAllJson,
	"wski18n/resources/fr_FR.all.json":   wski18nResourcesFr_frAllJson,
	"wski18n/resources/it_IT.all.json":   wski18nResourcesIt_itAllJson,
	"wski18n/resources/ja_JA.all.json":   wski18nResourcesJa_jaAllJson,
	"wski18n/resources/ko_KR.all.json":   wski18nResourcesKo_krAllJson,
	"wski18n/resources/pt_BR.all.json":   wski18nResourcesPt_brAllJson,
	"wski18n/resources/zh_Hans.all.json": wski18nResourcesZh_hansAllJson,
	"wski18n/resources/zh_Hant.all.json": wski18nResourcesZh_hantAllJson,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"wski18n": {nil, map[string]*bintree{
		"resources": {nil, map[string]*bintree{
			"de_DE.all.json":   {wski18nResourcesDe_deAllJson, map[string]*bintree{}},
			"en_US.all.json":   {wski18nResourcesEn_usAllJson, map[string]*bintree{}},
			"es_ES.all.json":   {wski18nResourcesEs_esAllJson, map[string]*bintree{}},
			"fr_FR.all.json":   {wski18nResourcesFr_frAllJson, map[string]*bintree{}},
			"it_IT.all.json":   {wski18nResourcesIt_itAllJson, map[string]*bintree{}},
			"ja_JA.all.json":   {wski18nResourcesJa_jaAllJson, map[string]*bintree{}},
			"ko_KR.all.json":   {wski18nResourcesKo_krAllJson, map[string]*bintree{}},
			"pt_BR.all.json":   {wski18nResourcesPt_brAllJson, map[string]*bintree{}},
			"zh_Hans.all.json": {wski18nResourcesZh_hansAllJson, map[string]*bintree{}},
			"zh_Hant.all.json": {wski18nResourcesZh_hantAllJson, map[string]*bintree{}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
