// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
)

// CloudConnectionEndpointVPC cloud connection endpoint v p c
// swagger:model CloudConnectionEndpointVPC
type CloudConnectionEndpointVPC struct {

	// enable vpc for this cloud connection (default=false)
	Enabled bool `json:"enabled"`

	// vpc connections
	Vpcs []*CloudConnectionVPC `json:"vpcs,omitempty"`
}

// Validate validates this cloud connection endpoint v p c
func (m *CloudConnectionEndpointVPC) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateVpcs(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudConnectionEndpointVPC) validateVpcs(formats strfmt.Registry) error {

	if swag.IsZero(m.Vpcs) { // not required
		return nil
	}

	for i := 0; i < len(m.Vpcs); i++ {
		if swag.IsZero(m.Vpcs[i]) { // not required
			continue
		}

		if m.Vpcs[i] != nil {
			if err := m.Vpcs[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("vpcs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *CloudConnectionEndpointVPC) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloudConnectionEndpointVPC) UnmarshalBinary(b []byte) error {
	var res CloudConnectionEndpointVPC
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
