// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mturk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateAdditionalAssignmentsForHITInput struct {
	_ struct{} `type:"structure"`

	// The ID of the HIT to extend.
	//
	// HITId is a required field
	HITId *string `min:"1" type:"string" required:"true"`

	// The number of additional assignments to request for this HIT.
	//
	// NumberOfAdditionalAssignments is a required field
	NumberOfAdditionalAssignments *int64 `type:"integer" required:"true"`

	// A unique identifier for this request, which allows you to retry the call
	// on error without extending the HIT multiple times. This is useful in cases
	// such as network timeouts where it is unclear whether or not the call succeeded
	// on the server. If the extend HIT already exists in the system from a previous
	// call using the same UniqueRequestToken, subsequent calls will return an error
	// with a message containing the request ID.
	UniqueRequestToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateAdditionalAssignmentsForHITInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAdditionalAssignmentsForHITInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAdditionalAssignmentsForHITInput"}

	if s.HITId == nil {
		invalidParams.Add(aws.NewErrParamRequired("HITId"))
	}
	if s.HITId != nil && len(*s.HITId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HITId", 1))
	}

	if s.NumberOfAdditionalAssignments == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfAdditionalAssignments"))
	}
	if s.UniqueRequestToken != nil && len(*s.UniqueRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UniqueRequestToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateAdditionalAssignmentsForHITOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateAdditionalAssignmentsForHITOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateAdditionalAssignmentsForHIT = "CreateAdditionalAssignmentsForHIT"

// CreateAdditionalAssignmentsForHITRequest returns a request value for making API operation for
// Amazon Mechanical Turk.
//
// The CreateAdditionalAssignmentsForHIT operation increases the maximum number
// of assignments of an existing HIT.
//
// To extend the maximum number of assignments, specify the number of additional
// assignments.
//
//    * HITs created with fewer than 10 assignments cannot be extended to have
//    10 or more assignments. Attempting to add assignments in a way that brings
//    the total number of assignments for a HIT from fewer than 10 assignments
//    to 10 or more assignments will result in an AWS.MechanicalTurk.InvalidMaximumAssignmentsIncrease
//    exception.
//
//    * HITs that were created before July 22, 2015 cannot be extended. Attempting
//    to extend HITs that were created before July 22, 2015 will result in an
//    AWS.MechanicalTurk.HITTooOldForExtension exception.
//
//    // Example sending a request using CreateAdditionalAssignmentsForHITRequest.
//    req := client.CreateAdditionalAssignmentsForHITRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateAdditionalAssignmentsForHIT
func (c *Client) CreateAdditionalAssignmentsForHITRequest(input *CreateAdditionalAssignmentsForHITInput) CreateAdditionalAssignmentsForHITRequest {
	op := &aws.Operation{
		Name:       opCreateAdditionalAssignmentsForHIT,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAdditionalAssignmentsForHITInput{}
	}

	req := c.newRequest(op, input, &CreateAdditionalAssignmentsForHITOutput{})
	return CreateAdditionalAssignmentsForHITRequest{Request: req, Input: input, Copy: c.CreateAdditionalAssignmentsForHITRequest}
}

// CreateAdditionalAssignmentsForHITRequest is the request type for the
// CreateAdditionalAssignmentsForHIT API operation.
type CreateAdditionalAssignmentsForHITRequest struct {
	*aws.Request
	Input *CreateAdditionalAssignmentsForHITInput
	Copy  func(*CreateAdditionalAssignmentsForHITInput) CreateAdditionalAssignmentsForHITRequest
}

// Send marshals and sends the CreateAdditionalAssignmentsForHIT API request.
func (r CreateAdditionalAssignmentsForHITRequest) Send(ctx context.Context) (*CreateAdditionalAssignmentsForHITResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateAdditionalAssignmentsForHITResponse{
		CreateAdditionalAssignmentsForHITOutput: r.Request.Data.(*CreateAdditionalAssignmentsForHITOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateAdditionalAssignmentsForHITResponse is the response type for the
// CreateAdditionalAssignmentsForHIT API operation.
type CreateAdditionalAssignmentsForHITResponse struct {
	*CreateAdditionalAssignmentsForHITOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateAdditionalAssignmentsForHIT request.
func (r *CreateAdditionalAssignmentsForHITResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
