package names

import (
	"github.com/spiegel-im-spiegel/go-cvss/v3/metric"
	"golang.org/x/text/language"
)

var (
	eTitleMap = langNameMap{
		language.English:  "Exploit Code Maturity",
		language.Japanese: "攻撃される可能性",
	}
	eNamesMap = map[metric.Exploitability]langNameMap{
		metric.ExploitabilityNotDefined: langNameMap{
			language.English:  "Not Defined",
			language.Japanese: "未評価",
		},
		metric.ExploitabilityUnproven: langNameMap{
			language.English:  "Unproven",
			language.Japanese: "未実証",
		},
		metric.ExploitabilityProofOfConcept: langNameMap{
			language.English:  "Proof-of-Concept",
			language.Japanese: "実証可能",
		},
		metric.ExploitabilityFunctional: langNameMap{
			language.English:  "Functional",
			language.Japanese: "攻撃可能",
		},
		metric.ExploitabilityHigh: langNameMap{
			language.English:  "High",
			language.Japanese: "容易に攻撃可能",
		},
	}
)

//Exploitability returns string instance name for display
func Exploitability(lang language.Tag) string {
	return eTitleMap.getNameInLang(lang)
}

//EValueOf returns string name of value for display
func EValueOf(e metric.Exploitability, lang language.Tag) string {
	if m, ok := eNamesMap[e]; ok {
		return m.getNameInLang(lang)
	}
	return unknownValueNameMap.getNameInLang(lang)
}

/* Copyright 2020 Spiegel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
