/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package anagofakes

import (
	"sync"

	"github.com/blang/semver"
	"github.com/in-toto/in-toto-golang/in_toto"
	"k8s.io/release/pkg/anago"
	"k8s.io/release/pkg/build"
	"k8s.io/release/pkg/changelog"
	"k8s.io/release/pkg/gcp/gcb"
	"k8s.io/release/pkg/provenance"
	"k8s.io/release/pkg/release"
	"k8s.io/release/pkg/spdx"
	"sigs.k8s.io/release-sdk/git"
)

type FakeStageImpl struct {
	AddBinariesToSBOMStub        func(*spdx.Document, string) error
	addBinariesToSBOMMutex       sync.RWMutex
	addBinariesToSBOMArgsForCall []struct {
		arg1 *spdx.Document
		arg2 string
	}
	addBinariesToSBOMReturns struct {
		result1 error
	}
	addBinariesToSBOMReturnsOnCall map[int]struct {
		result1 error
	}
	AddTarfilesToSBOMStub        func(*spdx.Document, string) error
	addTarfilesToSBOMMutex       sync.RWMutex
	addTarfilesToSBOMArgsForCall []struct {
		arg1 *spdx.Document
		arg2 string
	}
	addTarfilesToSBOMReturns struct {
		result1 error
	}
	addTarfilesToSBOMReturnsOnCall map[int]struct {
		result1 error
	}
	BranchNeedsCreationStub        func(string, string, semver.Version) (bool, error)
	branchNeedsCreationMutex       sync.RWMutex
	branchNeedsCreationArgsForCall []struct {
		arg1 string
		arg2 string
		arg3 semver.Version
	}
	branchNeedsCreationReturns struct {
		result1 bool
		result2 error
	}
	branchNeedsCreationReturnsOnCall map[int]struct {
		result1 bool
		result2 error
	}
	BuildBaseArtifactsSBOMStub        func(*spdx.DocGenerateOptions) (*spdx.Document, error)
	buildBaseArtifactsSBOMMutex       sync.RWMutex
	buildBaseArtifactsSBOMArgsForCall []struct {
		arg1 *spdx.DocGenerateOptions
	}
	buildBaseArtifactsSBOMReturns struct {
		result1 *spdx.Document
		result2 error
	}
	buildBaseArtifactsSBOMReturnsOnCall map[int]struct {
		result1 *spdx.Document
		result2 error
	}
	CheckPrerequisitesStub        func() error
	checkPrerequisitesMutex       sync.RWMutex
	checkPrerequisitesArgsForCall []struct {
	}
	checkPrerequisitesReturns struct {
		result1 error
	}
	checkPrerequisitesReturnsOnCall map[int]struct {
		result1 error
	}
	CheckReleaseBucketStub        func(*build.Options) error
	checkReleaseBucketMutex       sync.RWMutex
	checkReleaseBucketArgsForCall []struct {
		arg1 *build.Options
	}
	checkReleaseBucketReturns struct {
		result1 error
	}
	checkReleaseBucketReturnsOnCall map[int]struct {
		result1 error
	}
	CheckoutStub        func(*git.Repo, string, ...string) error
	checkoutMutex       sync.RWMutex
	checkoutArgsForCall []struct {
		arg1 *git.Repo
		arg2 string
		arg3 []string
	}
	checkoutReturns struct {
		result1 error
	}
	checkoutReturnsOnCall map[int]struct {
		result1 error
	}
	CommitEmptyStub        func(*git.Repo, string) error
	commitEmptyMutex       sync.RWMutex
	commitEmptyArgsForCall []struct {
		arg1 *git.Repo
		arg2 string
	}
	commitEmptyReturns struct {
		result1 error
	}
	commitEmptyReturnsOnCall map[int]struct {
		result1 error
	}
	CurrentBranchStub        func(*git.Repo) (string, error)
	currentBranchMutex       sync.RWMutex
	currentBranchArgsForCall []struct {
		arg1 *git.Repo
	}
	currentBranchReturns struct {
		result1 string
		result2 error
	}
	currentBranchReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	DeleteLocalSourceTarballStub        func(*build.Options, string) error
	deleteLocalSourceTarballMutex       sync.RWMutex
	deleteLocalSourceTarballArgsForCall []struct {
		arg1 *build.Options
		arg2 string
	}
	deleteLocalSourceTarballReturns struct {
		result1 error
	}
	deleteLocalSourceTarballReturnsOnCall map[int]struct {
		result1 error
	}
	DockerHubLoginStub        func() error
	dockerHubLoginMutex       sync.RWMutex
	dockerHubLoginArgsForCall []struct {
	}
	dockerHubLoginReturns struct {
		result1 error
	}
	dockerHubLoginReturnsOnCall map[int]struct {
		result1 error
	}
	GenerateAttestationStub        func(*anago.StageState, *anago.StageOptions) (*provenance.Statement, error)
	generateAttestationMutex       sync.RWMutex
	generateAttestationArgsForCall []struct {
		arg1 *anago.StageState
		arg2 *anago.StageOptions
	}
	generateAttestationReturns struct {
		result1 *provenance.Statement
		result2 error
	}
	generateAttestationReturnsOnCall map[int]struct {
		result1 *provenance.Statement
		result2 error
	}
	GenerateChangelogStub        func(*changelog.Options) error
	generateChangelogMutex       sync.RWMutex
	generateChangelogArgsForCall []struct {
		arg1 *changelog.Options
	}
	generateChangelogReturns struct {
		result1 error
	}
	generateChangelogReturnsOnCall map[int]struct {
		result1 error
	}
	GenerateReleaseVersionStub        func(string, string, string, bool) (*release.Versions, error)
	generateReleaseVersionMutex       sync.RWMutex
	generateReleaseVersionArgsForCall []struct {
		arg1 string
		arg2 string
		arg3 string
		arg4 bool
	}
	generateReleaseVersionReturns struct {
		result1 *release.Versions
		result2 error
	}
	generateReleaseVersionReturnsOnCall map[int]struct {
		result1 *release.Versions
		result2 error
	}
	GenerateSourceTreeBOMStub        func(*spdx.DocGenerateOptions) (*spdx.Document, error)
	generateSourceTreeBOMMutex       sync.RWMutex
	generateSourceTreeBOMArgsForCall []struct {
		arg1 *spdx.DocGenerateOptions
	}
	generateSourceTreeBOMReturns struct {
		result1 *spdx.Document
		result2 error
	}
	generateSourceTreeBOMReturnsOnCall map[int]struct {
		result1 *spdx.Document
		result2 error
	}
	GenerateVersionArtifactsBOMStub        func(string) error
	generateVersionArtifactsBOMMutex       sync.RWMutex
	generateVersionArtifactsBOMArgsForCall []struct {
		arg1 string
	}
	generateVersionArtifactsBOMReturns struct {
		result1 error
	}
	generateVersionArtifactsBOMReturnsOnCall map[int]struct {
		result1 error
	}
	GetOutputDirSubjectsStub        func(*anago.StageOptions, string, string) ([]in_toto.Subject, error)
	getOutputDirSubjectsMutex       sync.RWMutex
	getOutputDirSubjectsArgsForCall []struct {
		arg1 *anago.StageOptions
		arg2 string
		arg3 string
	}
	getOutputDirSubjectsReturns struct {
		result1 []in_toto.Subject
		result2 error
	}
	getOutputDirSubjectsReturnsOnCall map[int]struct {
		result1 []in_toto.Subject
		result2 error
	}
	GetProvenanceSubjectsStub        func(*anago.StageOptions, string) ([]in_toto.Subject, error)
	getProvenanceSubjectsMutex       sync.RWMutex
	getProvenanceSubjectsArgsForCall []struct {
		arg1 *anago.StageOptions
		arg2 string
	}
	getProvenanceSubjectsReturns struct {
		result1 []in_toto.Subject
		result2 error
	}
	getProvenanceSubjectsReturnsOnCall map[int]struct {
		result1 []in_toto.Subject
		result2 error
	}
	ListBinariesStub func(string) ([]struct {
		Path     string
		Platform string
		Arch     string
	}, error)
	listBinariesMutex       sync.RWMutex
	listBinariesArgsForCall []struct {
		arg1 string
	}
	listBinariesReturns struct {
		result1 []struct {
			Path     string
			Platform string
			Arch     string
		}
		result2 error
	}
	listBinariesReturnsOnCall map[int]struct {
		result1 []struct {
			Path     string
			Platform string
			Arch     string
		}
		result2 error
	}
	ListImageArchivesStub        func(string) ([]string, error)
	listImageArchivesMutex       sync.RWMutex
	listImageArchivesArgsForCall []struct {
		arg1 string
	}
	listImageArchivesReturns struct {
		result1 []string
		result2 error
	}
	listImageArchivesReturnsOnCall map[int]struct {
		result1 []string
		result2 error
	}
	ListTarballsStub        func(string) ([]string, error)
	listTarballsMutex       sync.RWMutex
	listTarballsArgsForCall []struct {
		arg1 string
	}
	listTarballsReturns struct {
		result1 []string
		result2 error
	}
	listTarballsReturnsOnCall map[int]struct {
		result1 []string
		result2 error
	}
	MakeCrossStub        func(string) error
	makeCrossMutex       sync.RWMutex
	makeCrossArgsForCall []struct {
		arg1 string
	}
	makeCrossReturns struct {
		result1 error
	}
	makeCrossReturnsOnCall map[int]struct {
		result1 error
	}
	MergeStub        func(*git.Repo, string) error
	mergeMutex       sync.RWMutex
	mergeArgsForCall []struct {
		arg1 *git.Repo
		arg2 string
	}
	mergeReturns struct {
		result1 error
	}
	mergeReturnsOnCall map[int]struct {
		result1 error
	}
	OpenRepoStub        func(string) (*git.Repo, error)
	openRepoMutex       sync.RWMutex
	openRepoArgsForCall []struct {
		arg1 string
	}
	openRepoReturns struct {
		result1 *git.Repo
		result2 error
	}
	openRepoReturnsOnCall map[int]struct {
		result1 *git.Repo
		result2 error
	}
	PrepareWorkspaceStageStub        func(bool) error
	prepareWorkspaceStageMutex       sync.RWMutex
	prepareWorkspaceStageArgsForCall []struct {
		arg1 bool
	}
	prepareWorkspaceStageReturns struct {
		result1 error
	}
	prepareWorkspaceStageReturnsOnCall map[int]struct {
		result1 error
	}
	PushAttestationStub        func(*provenance.Statement, *anago.StageOptions) error
	pushAttestationMutex       sync.RWMutex
	pushAttestationArgsForCall []struct {
		arg1 *provenance.Statement
		arg2 *anago.StageOptions
	}
	pushAttestationReturns struct {
		result1 error
	}
	pushAttestationReturnsOnCall map[int]struct {
		result1 error
	}
	PushContainerImagesStub        func(*build.Options) error
	pushContainerImagesMutex       sync.RWMutex
	pushContainerImagesArgsForCall []struct {
		arg1 *build.Options
	}
	pushContainerImagesReturns struct {
		result1 error
	}
	pushContainerImagesReturnsOnCall map[int]struct {
		result1 error
	}
	PushReleaseArtifactsStub        func(*build.Options, string, string) error
	pushReleaseArtifactsMutex       sync.RWMutex
	pushReleaseArtifactsArgsForCall []struct {
		arg1 *build.Options
		arg2 string
		arg3 string
	}
	pushReleaseArtifactsReturns struct {
		result1 error
	}
	pushReleaseArtifactsReturnsOnCall map[int]struct {
		result1 error
	}
	RevParseStub        func(*git.Repo, string) (string, error)
	revParseMutex       sync.RWMutex
	revParseArgsForCall []struct {
		arg1 *git.Repo
		arg2 string
	}
	revParseReturns struct {
		result1 string
		result2 error
	}
	revParseReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	RevParseTagStub        func(*git.Repo, string) (string, error)
	revParseTagMutex       sync.RWMutex
	revParseTagArgsForCall []struct {
		arg1 *git.Repo
		arg2 string
	}
	revParseTagReturns struct {
		result1 string
		result2 error
	}
	revParseTagReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	StageLocalArtifactsStub        func(*build.Options) error
	stageLocalArtifactsMutex       sync.RWMutex
	stageLocalArtifactsArgsForCall []struct {
		arg1 *build.Options
	}
	stageLocalArtifactsReturns struct {
		result1 error
	}
	stageLocalArtifactsReturnsOnCall map[int]struct {
		result1 error
	}
	StageLocalSourceTreeStub        func(*build.Options, string, string) error
	stageLocalSourceTreeMutex       sync.RWMutex
	stageLocalSourceTreeArgsForCall []struct {
		arg1 *build.Options
		arg2 string
		arg3 string
	}
	stageLocalSourceTreeReturns struct {
		result1 error
	}
	stageLocalSourceTreeReturnsOnCall map[int]struct {
		result1 error
	}
	SubmitStub        func(*gcb.Options) error
	submitMutex       sync.RWMutex
	submitArgsForCall []struct {
		arg1 *gcb.Options
	}
	submitReturns struct {
		result1 error
	}
	submitReturnsOnCall map[int]struct {
		result1 error
	}
	TagStub        func(*git.Repo, string, string) error
	tagMutex       sync.RWMutex
	tagArgsForCall []struct {
		arg1 *git.Repo
		arg2 string
		arg3 string
	}
	tagReturns struct {
		result1 error
	}
	tagReturnsOnCall map[int]struct {
		result1 error
	}
	ToFileStub        func(string) error
	toFileMutex       sync.RWMutex
	toFileArgsForCall []struct {
		arg1 string
	}
	toFileReturns struct {
		result1 error
	}
	toFileReturnsOnCall map[int]struct {
		result1 error
	}
	VerifyArtifactsStub        func([]string) error
	verifyArtifactsMutex       sync.RWMutex
	verifyArtifactsArgsForCall []struct {
		arg1 []string
	}
	verifyArtifactsReturns struct {
		result1 error
	}
	verifyArtifactsReturnsOnCall map[int]struct {
		result1 error
	}
	WriteSourceBOMStub        func(*spdx.Document, string) error
	writeSourceBOMMutex       sync.RWMutex
	writeSourceBOMArgsForCall []struct {
		arg1 *spdx.Document
		arg2 string
	}
	writeSourceBOMReturns struct {
		result1 error
	}
	writeSourceBOMReturnsOnCall map[int]struct {
		result1 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeStageImpl) AddBinariesToSBOM(arg1 *spdx.Document, arg2 string) error {
	fake.addBinariesToSBOMMutex.Lock()
	ret, specificReturn := fake.addBinariesToSBOMReturnsOnCall[len(fake.addBinariesToSBOMArgsForCall)]
	fake.addBinariesToSBOMArgsForCall = append(fake.addBinariesToSBOMArgsForCall, struct {
		arg1 *spdx.Document
		arg2 string
	}{arg1, arg2})
	stub := fake.AddBinariesToSBOMStub
	fakeReturns := fake.addBinariesToSBOMReturns
	fake.recordInvocation("AddBinariesToSBOM", []interface{}{arg1, arg2})
	fake.addBinariesToSBOMMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) AddBinariesToSBOMCallCount() int {
	fake.addBinariesToSBOMMutex.RLock()
	defer fake.addBinariesToSBOMMutex.RUnlock()
	return len(fake.addBinariesToSBOMArgsForCall)
}

func (fake *FakeStageImpl) AddBinariesToSBOMCalls(stub func(*spdx.Document, string) error) {
	fake.addBinariesToSBOMMutex.Lock()
	defer fake.addBinariesToSBOMMutex.Unlock()
	fake.AddBinariesToSBOMStub = stub
}

func (fake *FakeStageImpl) AddBinariesToSBOMArgsForCall(i int) (*spdx.Document, string) {
	fake.addBinariesToSBOMMutex.RLock()
	defer fake.addBinariesToSBOMMutex.RUnlock()
	argsForCall := fake.addBinariesToSBOMArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeStageImpl) AddBinariesToSBOMReturns(result1 error) {
	fake.addBinariesToSBOMMutex.Lock()
	defer fake.addBinariesToSBOMMutex.Unlock()
	fake.AddBinariesToSBOMStub = nil
	fake.addBinariesToSBOMReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) AddBinariesToSBOMReturnsOnCall(i int, result1 error) {
	fake.addBinariesToSBOMMutex.Lock()
	defer fake.addBinariesToSBOMMutex.Unlock()
	fake.AddBinariesToSBOMStub = nil
	if fake.addBinariesToSBOMReturnsOnCall == nil {
		fake.addBinariesToSBOMReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.addBinariesToSBOMReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) AddTarfilesToSBOM(arg1 *spdx.Document, arg2 string) error {
	fake.addTarfilesToSBOMMutex.Lock()
	ret, specificReturn := fake.addTarfilesToSBOMReturnsOnCall[len(fake.addTarfilesToSBOMArgsForCall)]
	fake.addTarfilesToSBOMArgsForCall = append(fake.addTarfilesToSBOMArgsForCall, struct {
		arg1 *spdx.Document
		arg2 string
	}{arg1, arg2})
	stub := fake.AddTarfilesToSBOMStub
	fakeReturns := fake.addTarfilesToSBOMReturns
	fake.recordInvocation("AddTarfilesToSBOM", []interface{}{arg1, arg2})
	fake.addTarfilesToSBOMMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) AddTarfilesToSBOMCallCount() int {
	fake.addTarfilesToSBOMMutex.RLock()
	defer fake.addTarfilesToSBOMMutex.RUnlock()
	return len(fake.addTarfilesToSBOMArgsForCall)
}

func (fake *FakeStageImpl) AddTarfilesToSBOMCalls(stub func(*spdx.Document, string) error) {
	fake.addTarfilesToSBOMMutex.Lock()
	defer fake.addTarfilesToSBOMMutex.Unlock()
	fake.AddTarfilesToSBOMStub = stub
}

func (fake *FakeStageImpl) AddTarfilesToSBOMArgsForCall(i int) (*spdx.Document, string) {
	fake.addTarfilesToSBOMMutex.RLock()
	defer fake.addTarfilesToSBOMMutex.RUnlock()
	argsForCall := fake.addTarfilesToSBOMArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeStageImpl) AddTarfilesToSBOMReturns(result1 error) {
	fake.addTarfilesToSBOMMutex.Lock()
	defer fake.addTarfilesToSBOMMutex.Unlock()
	fake.AddTarfilesToSBOMStub = nil
	fake.addTarfilesToSBOMReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) AddTarfilesToSBOMReturnsOnCall(i int, result1 error) {
	fake.addTarfilesToSBOMMutex.Lock()
	defer fake.addTarfilesToSBOMMutex.Unlock()
	fake.AddTarfilesToSBOMStub = nil
	if fake.addTarfilesToSBOMReturnsOnCall == nil {
		fake.addTarfilesToSBOMReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.addTarfilesToSBOMReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) BranchNeedsCreation(arg1 string, arg2 string, arg3 semver.Version) (bool, error) {
	fake.branchNeedsCreationMutex.Lock()
	ret, specificReturn := fake.branchNeedsCreationReturnsOnCall[len(fake.branchNeedsCreationArgsForCall)]
	fake.branchNeedsCreationArgsForCall = append(fake.branchNeedsCreationArgsForCall, struct {
		arg1 string
		arg2 string
		arg3 semver.Version
	}{arg1, arg2, arg3})
	stub := fake.BranchNeedsCreationStub
	fakeReturns := fake.branchNeedsCreationReturns
	fake.recordInvocation("BranchNeedsCreation", []interface{}{arg1, arg2, arg3})
	fake.branchNeedsCreationMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) BranchNeedsCreationCallCount() int {
	fake.branchNeedsCreationMutex.RLock()
	defer fake.branchNeedsCreationMutex.RUnlock()
	return len(fake.branchNeedsCreationArgsForCall)
}

func (fake *FakeStageImpl) BranchNeedsCreationCalls(stub func(string, string, semver.Version) (bool, error)) {
	fake.branchNeedsCreationMutex.Lock()
	defer fake.branchNeedsCreationMutex.Unlock()
	fake.BranchNeedsCreationStub = stub
}

func (fake *FakeStageImpl) BranchNeedsCreationArgsForCall(i int) (string, string, semver.Version) {
	fake.branchNeedsCreationMutex.RLock()
	defer fake.branchNeedsCreationMutex.RUnlock()
	argsForCall := fake.branchNeedsCreationArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeStageImpl) BranchNeedsCreationReturns(result1 bool, result2 error) {
	fake.branchNeedsCreationMutex.Lock()
	defer fake.branchNeedsCreationMutex.Unlock()
	fake.BranchNeedsCreationStub = nil
	fake.branchNeedsCreationReturns = struct {
		result1 bool
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) BranchNeedsCreationReturnsOnCall(i int, result1 bool, result2 error) {
	fake.branchNeedsCreationMutex.Lock()
	defer fake.branchNeedsCreationMutex.Unlock()
	fake.BranchNeedsCreationStub = nil
	if fake.branchNeedsCreationReturnsOnCall == nil {
		fake.branchNeedsCreationReturnsOnCall = make(map[int]struct {
			result1 bool
			result2 error
		})
	}
	fake.branchNeedsCreationReturnsOnCall[i] = struct {
		result1 bool
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) BuildBaseArtifactsSBOM(arg1 *spdx.DocGenerateOptions) (*spdx.Document, error) {
	fake.buildBaseArtifactsSBOMMutex.Lock()
	ret, specificReturn := fake.buildBaseArtifactsSBOMReturnsOnCall[len(fake.buildBaseArtifactsSBOMArgsForCall)]
	fake.buildBaseArtifactsSBOMArgsForCall = append(fake.buildBaseArtifactsSBOMArgsForCall, struct {
		arg1 *spdx.DocGenerateOptions
	}{arg1})
	stub := fake.BuildBaseArtifactsSBOMStub
	fakeReturns := fake.buildBaseArtifactsSBOMReturns
	fake.recordInvocation("BuildBaseArtifactsSBOM", []interface{}{arg1})
	fake.buildBaseArtifactsSBOMMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) BuildBaseArtifactsSBOMCallCount() int {
	fake.buildBaseArtifactsSBOMMutex.RLock()
	defer fake.buildBaseArtifactsSBOMMutex.RUnlock()
	return len(fake.buildBaseArtifactsSBOMArgsForCall)
}

func (fake *FakeStageImpl) BuildBaseArtifactsSBOMCalls(stub func(*spdx.DocGenerateOptions) (*spdx.Document, error)) {
	fake.buildBaseArtifactsSBOMMutex.Lock()
	defer fake.buildBaseArtifactsSBOMMutex.Unlock()
	fake.BuildBaseArtifactsSBOMStub = stub
}

func (fake *FakeStageImpl) BuildBaseArtifactsSBOMArgsForCall(i int) *spdx.DocGenerateOptions {
	fake.buildBaseArtifactsSBOMMutex.RLock()
	defer fake.buildBaseArtifactsSBOMMutex.RUnlock()
	argsForCall := fake.buildBaseArtifactsSBOMArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) BuildBaseArtifactsSBOMReturns(result1 *spdx.Document, result2 error) {
	fake.buildBaseArtifactsSBOMMutex.Lock()
	defer fake.buildBaseArtifactsSBOMMutex.Unlock()
	fake.BuildBaseArtifactsSBOMStub = nil
	fake.buildBaseArtifactsSBOMReturns = struct {
		result1 *spdx.Document
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) BuildBaseArtifactsSBOMReturnsOnCall(i int, result1 *spdx.Document, result2 error) {
	fake.buildBaseArtifactsSBOMMutex.Lock()
	defer fake.buildBaseArtifactsSBOMMutex.Unlock()
	fake.BuildBaseArtifactsSBOMStub = nil
	if fake.buildBaseArtifactsSBOMReturnsOnCall == nil {
		fake.buildBaseArtifactsSBOMReturnsOnCall = make(map[int]struct {
			result1 *spdx.Document
			result2 error
		})
	}
	fake.buildBaseArtifactsSBOMReturnsOnCall[i] = struct {
		result1 *spdx.Document
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) CheckPrerequisites() error {
	fake.checkPrerequisitesMutex.Lock()
	ret, specificReturn := fake.checkPrerequisitesReturnsOnCall[len(fake.checkPrerequisitesArgsForCall)]
	fake.checkPrerequisitesArgsForCall = append(fake.checkPrerequisitesArgsForCall, struct {
	}{})
	stub := fake.CheckPrerequisitesStub
	fakeReturns := fake.checkPrerequisitesReturns
	fake.recordInvocation("CheckPrerequisites", []interface{}{})
	fake.checkPrerequisitesMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) CheckPrerequisitesCallCount() int {
	fake.checkPrerequisitesMutex.RLock()
	defer fake.checkPrerequisitesMutex.RUnlock()
	return len(fake.checkPrerequisitesArgsForCall)
}

func (fake *FakeStageImpl) CheckPrerequisitesCalls(stub func() error) {
	fake.checkPrerequisitesMutex.Lock()
	defer fake.checkPrerequisitesMutex.Unlock()
	fake.CheckPrerequisitesStub = stub
}

func (fake *FakeStageImpl) CheckPrerequisitesReturns(result1 error) {
	fake.checkPrerequisitesMutex.Lock()
	defer fake.checkPrerequisitesMutex.Unlock()
	fake.CheckPrerequisitesStub = nil
	fake.checkPrerequisitesReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) CheckPrerequisitesReturnsOnCall(i int, result1 error) {
	fake.checkPrerequisitesMutex.Lock()
	defer fake.checkPrerequisitesMutex.Unlock()
	fake.CheckPrerequisitesStub = nil
	if fake.checkPrerequisitesReturnsOnCall == nil {
		fake.checkPrerequisitesReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.checkPrerequisitesReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) CheckReleaseBucket(arg1 *build.Options) error {
	fake.checkReleaseBucketMutex.Lock()
	ret, specificReturn := fake.checkReleaseBucketReturnsOnCall[len(fake.checkReleaseBucketArgsForCall)]
	fake.checkReleaseBucketArgsForCall = append(fake.checkReleaseBucketArgsForCall, struct {
		arg1 *build.Options
	}{arg1})
	stub := fake.CheckReleaseBucketStub
	fakeReturns := fake.checkReleaseBucketReturns
	fake.recordInvocation("CheckReleaseBucket", []interface{}{arg1})
	fake.checkReleaseBucketMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) CheckReleaseBucketCallCount() int {
	fake.checkReleaseBucketMutex.RLock()
	defer fake.checkReleaseBucketMutex.RUnlock()
	return len(fake.checkReleaseBucketArgsForCall)
}

func (fake *FakeStageImpl) CheckReleaseBucketCalls(stub func(*build.Options) error) {
	fake.checkReleaseBucketMutex.Lock()
	defer fake.checkReleaseBucketMutex.Unlock()
	fake.CheckReleaseBucketStub = stub
}

func (fake *FakeStageImpl) CheckReleaseBucketArgsForCall(i int) *build.Options {
	fake.checkReleaseBucketMutex.RLock()
	defer fake.checkReleaseBucketMutex.RUnlock()
	argsForCall := fake.checkReleaseBucketArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) CheckReleaseBucketReturns(result1 error) {
	fake.checkReleaseBucketMutex.Lock()
	defer fake.checkReleaseBucketMutex.Unlock()
	fake.CheckReleaseBucketStub = nil
	fake.checkReleaseBucketReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) CheckReleaseBucketReturnsOnCall(i int, result1 error) {
	fake.checkReleaseBucketMutex.Lock()
	defer fake.checkReleaseBucketMutex.Unlock()
	fake.CheckReleaseBucketStub = nil
	if fake.checkReleaseBucketReturnsOnCall == nil {
		fake.checkReleaseBucketReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.checkReleaseBucketReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) Checkout(arg1 *git.Repo, arg2 string, arg3 ...string) error {
	fake.checkoutMutex.Lock()
	ret, specificReturn := fake.checkoutReturnsOnCall[len(fake.checkoutArgsForCall)]
	fake.checkoutArgsForCall = append(fake.checkoutArgsForCall, struct {
		arg1 *git.Repo
		arg2 string
		arg3 []string
	}{arg1, arg2, arg3})
	stub := fake.CheckoutStub
	fakeReturns := fake.checkoutReturns
	fake.recordInvocation("Checkout", []interface{}{arg1, arg2, arg3})
	fake.checkoutMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3...)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) CheckoutCallCount() int {
	fake.checkoutMutex.RLock()
	defer fake.checkoutMutex.RUnlock()
	return len(fake.checkoutArgsForCall)
}

func (fake *FakeStageImpl) CheckoutCalls(stub func(*git.Repo, string, ...string) error) {
	fake.checkoutMutex.Lock()
	defer fake.checkoutMutex.Unlock()
	fake.CheckoutStub = stub
}

func (fake *FakeStageImpl) CheckoutArgsForCall(i int) (*git.Repo, string, []string) {
	fake.checkoutMutex.RLock()
	defer fake.checkoutMutex.RUnlock()
	argsForCall := fake.checkoutArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeStageImpl) CheckoutReturns(result1 error) {
	fake.checkoutMutex.Lock()
	defer fake.checkoutMutex.Unlock()
	fake.CheckoutStub = nil
	fake.checkoutReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) CheckoutReturnsOnCall(i int, result1 error) {
	fake.checkoutMutex.Lock()
	defer fake.checkoutMutex.Unlock()
	fake.CheckoutStub = nil
	if fake.checkoutReturnsOnCall == nil {
		fake.checkoutReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.checkoutReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) CommitEmpty(arg1 *git.Repo, arg2 string) error {
	fake.commitEmptyMutex.Lock()
	ret, specificReturn := fake.commitEmptyReturnsOnCall[len(fake.commitEmptyArgsForCall)]
	fake.commitEmptyArgsForCall = append(fake.commitEmptyArgsForCall, struct {
		arg1 *git.Repo
		arg2 string
	}{arg1, arg2})
	stub := fake.CommitEmptyStub
	fakeReturns := fake.commitEmptyReturns
	fake.recordInvocation("CommitEmpty", []interface{}{arg1, arg2})
	fake.commitEmptyMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) CommitEmptyCallCount() int {
	fake.commitEmptyMutex.RLock()
	defer fake.commitEmptyMutex.RUnlock()
	return len(fake.commitEmptyArgsForCall)
}

func (fake *FakeStageImpl) CommitEmptyCalls(stub func(*git.Repo, string) error) {
	fake.commitEmptyMutex.Lock()
	defer fake.commitEmptyMutex.Unlock()
	fake.CommitEmptyStub = stub
}

func (fake *FakeStageImpl) CommitEmptyArgsForCall(i int) (*git.Repo, string) {
	fake.commitEmptyMutex.RLock()
	defer fake.commitEmptyMutex.RUnlock()
	argsForCall := fake.commitEmptyArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeStageImpl) CommitEmptyReturns(result1 error) {
	fake.commitEmptyMutex.Lock()
	defer fake.commitEmptyMutex.Unlock()
	fake.CommitEmptyStub = nil
	fake.commitEmptyReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) CommitEmptyReturnsOnCall(i int, result1 error) {
	fake.commitEmptyMutex.Lock()
	defer fake.commitEmptyMutex.Unlock()
	fake.CommitEmptyStub = nil
	if fake.commitEmptyReturnsOnCall == nil {
		fake.commitEmptyReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.commitEmptyReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) CurrentBranch(arg1 *git.Repo) (string, error) {
	fake.currentBranchMutex.Lock()
	ret, specificReturn := fake.currentBranchReturnsOnCall[len(fake.currentBranchArgsForCall)]
	fake.currentBranchArgsForCall = append(fake.currentBranchArgsForCall, struct {
		arg1 *git.Repo
	}{arg1})
	stub := fake.CurrentBranchStub
	fakeReturns := fake.currentBranchReturns
	fake.recordInvocation("CurrentBranch", []interface{}{arg1})
	fake.currentBranchMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) CurrentBranchCallCount() int {
	fake.currentBranchMutex.RLock()
	defer fake.currentBranchMutex.RUnlock()
	return len(fake.currentBranchArgsForCall)
}

func (fake *FakeStageImpl) CurrentBranchCalls(stub func(*git.Repo) (string, error)) {
	fake.currentBranchMutex.Lock()
	defer fake.currentBranchMutex.Unlock()
	fake.CurrentBranchStub = stub
}

func (fake *FakeStageImpl) CurrentBranchArgsForCall(i int) *git.Repo {
	fake.currentBranchMutex.RLock()
	defer fake.currentBranchMutex.RUnlock()
	argsForCall := fake.currentBranchArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) CurrentBranchReturns(result1 string, result2 error) {
	fake.currentBranchMutex.Lock()
	defer fake.currentBranchMutex.Unlock()
	fake.CurrentBranchStub = nil
	fake.currentBranchReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) CurrentBranchReturnsOnCall(i int, result1 string, result2 error) {
	fake.currentBranchMutex.Lock()
	defer fake.currentBranchMutex.Unlock()
	fake.CurrentBranchStub = nil
	if fake.currentBranchReturnsOnCall == nil {
		fake.currentBranchReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.currentBranchReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) DeleteLocalSourceTarball(arg1 *build.Options, arg2 string) error {
	fake.deleteLocalSourceTarballMutex.Lock()
	ret, specificReturn := fake.deleteLocalSourceTarballReturnsOnCall[len(fake.deleteLocalSourceTarballArgsForCall)]
	fake.deleteLocalSourceTarballArgsForCall = append(fake.deleteLocalSourceTarballArgsForCall, struct {
		arg1 *build.Options
		arg2 string
	}{arg1, arg2})
	stub := fake.DeleteLocalSourceTarballStub
	fakeReturns := fake.deleteLocalSourceTarballReturns
	fake.recordInvocation("DeleteLocalSourceTarball", []interface{}{arg1, arg2})
	fake.deleteLocalSourceTarballMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) DeleteLocalSourceTarballCallCount() int {
	fake.deleteLocalSourceTarballMutex.RLock()
	defer fake.deleteLocalSourceTarballMutex.RUnlock()
	return len(fake.deleteLocalSourceTarballArgsForCall)
}

func (fake *FakeStageImpl) DeleteLocalSourceTarballCalls(stub func(*build.Options, string) error) {
	fake.deleteLocalSourceTarballMutex.Lock()
	defer fake.deleteLocalSourceTarballMutex.Unlock()
	fake.DeleteLocalSourceTarballStub = stub
}

func (fake *FakeStageImpl) DeleteLocalSourceTarballArgsForCall(i int) (*build.Options, string) {
	fake.deleteLocalSourceTarballMutex.RLock()
	defer fake.deleteLocalSourceTarballMutex.RUnlock()
	argsForCall := fake.deleteLocalSourceTarballArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeStageImpl) DeleteLocalSourceTarballReturns(result1 error) {
	fake.deleteLocalSourceTarballMutex.Lock()
	defer fake.deleteLocalSourceTarballMutex.Unlock()
	fake.DeleteLocalSourceTarballStub = nil
	fake.deleteLocalSourceTarballReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) DeleteLocalSourceTarballReturnsOnCall(i int, result1 error) {
	fake.deleteLocalSourceTarballMutex.Lock()
	defer fake.deleteLocalSourceTarballMutex.Unlock()
	fake.DeleteLocalSourceTarballStub = nil
	if fake.deleteLocalSourceTarballReturnsOnCall == nil {
		fake.deleteLocalSourceTarballReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.deleteLocalSourceTarballReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) DockerHubLogin() error {
	fake.dockerHubLoginMutex.Lock()
	ret, specificReturn := fake.dockerHubLoginReturnsOnCall[len(fake.dockerHubLoginArgsForCall)]
	fake.dockerHubLoginArgsForCall = append(fake.dockerHubLoginArgsForCall, struct {
	}{})
	stub := fake.DockerHubLoginStub
	fakeReturns := fake.dockerHubLoginReturns
	fake.recordInvocation("DockerHubLogin", []interface{}{})
	fake.dockerHubLoginMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) DockerHubLoginCallCount() int {
	fake.dockerHubLoginMutex.RLock()
	defer fake.dockerHubLoginMutex.RUnlock()
	return len(fake.dockerHubLoginArgsForCall)
}

func (fake *FakeStageImpl) DockerHubLoginCalls(stub func() error) {
	fake.dockerHubLoginMutex.Lock()
	defer fake.dockerHubLoginMutex.Unlock()
	fake.DockerHubLoginStub = stub
}

func (fake *FakeStageImpl) DockerHubLoginReturns(result1 error) {
	fake.dockerHubLoginMutex.Lock()
	defer fake.dockerHubLoginMutex.Unlock()
	fake.DockerHubLoginStub = nil
	fake.dockerHubLoginReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) DockerHubLoginReturnsOnCall(i int, result1 error) {
	fake.dockerHubLoginMutex.Lock()
	defer fake.dockerHubLoginMutex.Unlock()
	fake.DockerHubLoginStub = nil
	if fake.dockerHubLoginReturnsOnCall == nil {
		fake.dockerHubLoginReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.dockerHubLoginReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) GenerateAttestation(arg1 *anago.StageState, arg2 *anago.StageOptions) (*provenance.Statement, error) {
	fake.generateAttestationMutex.Lock()
	ret, specificReturn := fake.generateAttestationReturnsOnCall[len(fake.generateAttestationArgsForCall)]
	fake.generateAttestationArgsForCall = append(fake.generateAttestationArgsForCall, struct {
		arg1 *anago.StageState
		arg2 *anago.StageOptions
	}{arg1, arg2})
	stub := fake.GenerateAttestationStub
	fakeReturns := fake.generateAttestationReturns
	fake.recordInvocation("GenerateAttestation", []interface{}{arg1, arg2})
	fake.generateAttestationMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) GenerateAttestationCallCount() int {
	fake.generateAttestationMutex.RLock()
	defer fake.generateAttestationMutex.RUnlock()
	return len(fake.generateAttestationArgsForCall)
}

func (fake *FakeStageImpl) GenerateAttestationCalls(stub func(*anago.StageState, *anago.StageOptions) (*provenance.Statement, error)) {
	fake.generateAttestationMutex.Lock()
	defer fake.generateAttestationMutex.Unlock()
	fake.GenerateAttestationStub = stub
}

func (fake *FakeStageImpl) GenerateAttestationArgsForCall(i int) (*anago.StageState, *anago.StageOptions) {
	fake.generateAttestationMutex.RLock()
	defer fake.generateAttestationMutex.RUnlock()
	argsForCall := fake.generateAttestationArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeStageImpl) GenerateAttestationReturns(result1 *provenance.Statement, result2 error) {
	fake.generateAttestationMutex.Lock()
	defer fake.generateAttestationMutex.Unlock()
	fake.GenerateAttestationStub = nil
	fake.generateAttestationReturns = struct {
		result1 *provenance.Statement
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) GenerateAttestationReturnsOnCall(i int, result1 *provenance.Statement, result2 error) {
	fake.generateAttestationMutex.Lock()
	defer fake.generateAttestationMutex.Unlock()
	fake.GenerateAttestationStub = nil
	if fake.generateAttestationReturnsOnCall == nil {
		fake.generateAttestationReturnsOnCall = make(map[int]struct {
			result1 *provenance.Statement
			result2 error
		})
	}
	fake.generateAttestationReturnsOnCall[i] = struct {
		result1 *provenance.Statement
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) GenerateChangelog(arg1 *changelog.Options) error {
	fake.generateChangelogMutex.Lock()
	ret, specificReturn := fake.generateChangelogReturnsOnCall[len(fake.generateChangelogArgsForCall)]
	fake.generateChangelogArgsForCall = append(fake.generateChangelogArgsForCall, struct {
		arg1 *changelog.Options
	}{arg1})
	stub := fake.GenerateChangelogStub
	fakeReturns := fake.generateChangelogReturns
	fake.recordInvocation("GenerateChangelog", []interface{}{arg1})
	fake.generateChangelogMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) GenerateChangelogCallCount() int {
	fake.generateChangelogMutex.RLock()
	defer fake.generateChangelogMutex.RUnlock()
	return len(fake.generateChangelogArgsForCall)
}

func (fake *FakeStageImpl) GenerateChangelogCalls(stub func(*changelog.Options) error) {
	fake.generateChangelogMutex.Lock()
	defer fake.generateChangelogMutex.Unlock()
	fake.GenerateChangelogStub = stub
}

func (fake *FakeStageImpl) GenerateChangelogArgsForCall(i int) *changelog.Options {
	fake.generateChangelogMutex.RLock()
	defer fake.generateChangelogMutex.RUnlock()
	argsForCall := fake.generateChangelogArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) GenerateChangelogReturns(result1 error) {
	fake.generateChangelogMutex.Lock()
	defer fake.generateChangelogMutex.Unlock()
	fake.GenerateChangelogStub = nil
	fake.generateChangelogReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) GenerateChangelogReturnsOnCall(i int, result1 error) {
	fake.generateChangelogMutex.Lock()
	defer fake.generateChangelogMutex.Unlock()
	fake.GenerateChangelogStub = nil
	if fake.generateChangelogReturnsOnCall == nil {
		fake.generateChangelogReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.generateChangelogReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) GenerateReleaseVersion(arg1 string, arg2 string, arg3 string, arg4 bool) (*release.Versions, error) {
	fake.generateReleaseVersionMutex.Lock()
	ret, specificReturn := fake.generateReleaseVersionReturnsOnCall[len(fake.generateReleaseVersionArgsForCall)]
	fake.generateReleaseVersionArgsForCall = append(fake.generateReleaseVersionArgsForCall, struct {
		arg1 string
		arg2 string
		arg3 string
		arg4 bool
	}{arg1, arg2, arg3, arg4})
	stub := fake.GenerateReleaseVersionStub
	fakeReturns := fake.generateReleaseVersionReturns
	fake.recordInvocation("GenerateReleaseVersion", []interface{}{arg1, arg2, arg3, arg4})
	fake.generateReleaseVersionMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3, arg4)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) GenerateReleaseVersionCallCount() int {
	fake.generateReleaseVersionMutex.RLock()
	defer fake.generateReleaseVersionMutex.RUnlock()
	return len(fake.generateReleaseVersionArgsForCall)
}

func (fake *FakeStageImpl) GenerateReleaseVersionCalls(stub func(string, string, string, bool) (*release.Versions, error)) {
	fake.generateReleaseVersionMutex.Lock()
	defer fake.generateReleaseVersionMutex.Unlock()
	fake.GenerateReleaseVersionStub = stub
}

func (fake *FakeStageImpl) GenerateReleaseVersionArgsForCall(i int) (string, string, string, bool) {
	fake.generateReleaseVersionMutex.RLock()
	defer fake.generateReleaseVersionMutex.RUnlock()
	argsForCall := fake.generateReleaseVersionArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3, argsForCall.arg4
}

func (fake *FakeStageImpl) GenerateReleaseVersionReturns(result1 *release.Versions, result2 error) {
	fake.generateReleaseVersionMutex.Lock()
	defer fake.generateReleaseVersionMutex.Unlock()
	fake.GenerateReleaseVersionStub = nil
	fake.generateReleaseVersionReturns = struct {
		result1 *release.Versions
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) GenerateReleaseVersionReturnsOnCall(i int, result1 *release.Versions, result2 error) {
	fake.generateReleaseVersionMutex.Lock()
	defer fake.generateReleaseVersionMutex.Unlock()
	fake.GenerateReleaseVersionStub = nil
	if fake.generateReleaseVersionReturnsOnCall == nil {
		fake.generateReleaseVersionReturnsOnCall = make(map[int]struct {
			result1 *release.Versions
			result2 error
		})
	}
	fake.generateReleaseVersionReturnsOnCall[i] = struct {
		result1 *release.Versions
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) GenerateSourceTreeBOM(arg1 *spdx.DocGenerateOptions) (*spdx.Document, error) {
	fake.generateSourceTreeBOMMutex.Lock()
	ret, specificReturn := fake.generateSourceTreeBOMReturnsOnCall[len(fake.generateSourceTreeBOMArgsForCall)]
	fake.generateSourceTreeBOMArgsForCall = append(fake.generateSourceTreeBOMArgsForCall, struct {
		arg1 *spdx.DocGenerateOptions
	}{arg1})
	stub := fake.GenerateSourceTreeBOMStub
	fakeReturns := fake.generateSourceTreeBOMReturns
	fake.recordInvocation("GenerateSourceTreeBOM", []interface{}{arg1})
	fake.generateSourceTreeBOMMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) GenerateSourceTreeBOMCallCount() int {
	fake.generateSourceTreeBOMMutex.RLock()
	defer fake.generateSourceTreeBOMMutex.RUnlock()
	return len(fake.generateSourceTreeBOMArgsForCall)
}

func (fake *FakeStageImpl) GenerateSourceTreeBOMCalls(stub func(*spdx.DocGenerateOptions) (*spdx.Document, error)) {
	fake.generateSourceTreeBOMMutex.Lock()
	defer fake.generateSourceTreeBOMMutex.Unlock()
	fake.GenerateSourceTreeBOMStub = stub
}

func (fake *FakeStageImpl) GenerateSourceTreeBOMArgsForCall(i int) *spdx.DocGenerateOptions {
	fake.generateSourceTreeBOMMutex.RLock()
	defer fake.generateSourceTreeBOMMutex.RUnlock()
	argsForCall := fake.generateSourceTreeBOMArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) GenerateSourceTreeBOMReturns(result1 *spdx.Document, result2 error) {
	fake.generateSourceTreeBOMMutex.Lock()
	defer fake.generateSourceTreeBOMMutex.Unlock()
	fake.GenerateSourceTreeBOMStub = nil
	fake.generateSourceTreeBOMReturns = struct {
		result1 *spdx.Document
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) GenerateSourceTreeBOMReturnsOnCall(i int, result1 *spdx.Document, result2 error) {
	fake.generateSourceTreeBOMMutex.Lock()
	defer fake.generateSourceTreeBOMMutex.Unlock()
	fake.GenerateSourceTreeBOMStub = nil
	if fake.generateSourceTreeBOMReturnsOnCall == nil {
		fake.generateSourceTreeBOMReturnsOnCall = make(map[int]struct {
			result1 *spdx.Document
			result2 error
		})
	}
	fake.generateSourceTreeBOMReturnsOnCall[i] = struct {
		result1 *spdx.Document
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) GenerateVersionArtifactsBOM(arg1 string) error {
	fake.generateVersionArtifactsBOMMutex.Lock()
	ret, specificReturn := fake.generateVersionArtifactsBOMReturnsOnCall[len(fake.generateVersionArtifactsBOMArgsForCall)]
	fake.generateVersionArtifactsBOMArgsForCall = append(fake.generateVersionArtifactsBOMArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.GenerateVersionArtifactsBOMStub
	fakeReturns := fake.generateVersionArtifactsBOMReturns
	fake.recordInvocation("GenerateVersionArtifactsBOM", []interface{}{arg1})
	fake.generateVersionArtifactsBOMMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) GenerateVersionArtifactsBOMCallCount() int {
	fake.generateVersionArtifactsBOMMutex.RLock()
	defer fake.generateVersionArtifactsBOMMutex.RUnlock()
	return len(fake.generateVersionArtifactsBOMArgsForCall)
}

func (fake *FakeStageImpl) GenerateVersionArtifactsBOMCalls(stub func(string) error) {
	fake.generateVersionArtifactsBOMMutex.Lock()
	defer fake.generateVersionArtifactsBOMMutex.Unlock()
	fake.GenerateVersionArtifactsBOMStub = stub
}

func (fake *FakeStageImpl) GenerateVersionArtifactsBOMArgsForCall(i int) string {
	fake.generateVersionArtifactsBOMMutex.RLock()
	defer fake.generateVersionArtifactsBOMMutex.RUnlock()
	argsForCall := fake.generateVersionArtifactsBOMArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) GenerateVersionArtifactsBOMReturns(result1 error) {
	fake.generateVersionArtifactsBOMMutex.Lock()
	defer fake.generateVersionArtifactsBOMMutex.Unlock()
	fake.GenerateVersionArtifactsBOMStub = nil
	fake.generateVersionArtifactsBOMReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) GenerateVersionArtifactsBOMReturnsOnCall(i int, result1 error) {
	fake.generateVersionArtifactsBOMMutex.Lock()
	defer fake.generateVersionArtifactsBOMMutex.Unlock()
	fake.GenerateVersionArtifactsBOMStub = nil
	if fake.generateVersionArtifactsBOMReturnsOnCall == nil {
		fake.generateVersionArtifactsBOMReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.generateVersionArtifactsBOMReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) GetOutputDirSubjects(arg1 *anago.StageOptions, arg2 string, arg3 string) ([]in_toto.Subject, error) {
	fake.getOutputDirSubjectsMutex.Lock()
	ret, specificReturn := fake.getOutputDirSubjectsReturnsOnCall[len(fake.getOutputDirSubjectsArgsForCall)]
	fake.getOutputDirSubjectsArgsForCall = append(fake.getOutputDirSubjectsArgsForCall, struct {
		arg1 *anago.StageOptions
		arg2 string
		arg3 string
	}{arg1, arg2, arg3})
	stub := fake.GetOutputDirSubjectsStub
	fakeReturns := fake.getOutputDirSubjectsReturns
	fake.recordInvocation("GetOutputDirSubjects", []interface{}{arg1, arg2, arg3})
	fake.getOutputDirSubjectsMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) GetOutputDirSubjectsCallCount() int {
	fake.getOutputDirSubjectsMutex.RLock()
	defer fake.getOutputDirSubjectsMutex.RUnlock()
	return len(fake.getOutputDirSubjectsArgsForCall)
}

func (fake *FakeStageImpl) GetOutputDirSubjectsCalls(stub func(*anago.StageOptions, string, string) ([]in_toto.Subject, error)) {
	fake.getOutputDirSubjectsMutex.Lock()
	defer fake.getOutputDirSubjectsMutex.Unlock()
	fake.GetOutputDirSubjectsStub = stub
}

func (fake *FakeStageImpl) GetOutputDirSubjectsArgsForCall(i int) (*anago.StageOptions, string, string) {
	fake.getOutputDirSubjectsMutex.RLock()
	defer fake.getOutputDirSubjectsMutex.RUnlock()
	argsForCall := fake.getOutputDirSubjectsArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeStageImpl) GetOutputDirSubjectsReturns(result1 []in_toto.Subject, result2 error) {
	fake.getOutputDirSubjectsMutex.Lock()
	defer fake.getOutputDirSubjectsMutex.Unlock()
	fake.GetOutputDirSubjectsStub = nil
	fake.getOutputDirSubjectsReturns = struct {
		result1 []in_toto.Subject
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) GetOutputDirSubjectsReturnsOnCall(i int, result1 []in_toto.Subject, result2 error) {
	fake.getOutputDirSubjectsMutex.Lock()
	defer fake.getOutputDirSubjectsMutex.Unlock()
	fake.GetOutputDirSubjectsStub = nil
	if fake.getOutputDirSubjectsReturnsOnCall == nil {
		fake.getOutputDirSubjectsReturnsOnCall = make(map[int]struct {
			result1 []in_toto.Subject
			result2 error
		})
	}
	fake.getOutputDirSubjectsReturnsOnCall[i] = struct {
		result1 []in_toto.Subject
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) GetProvenanceSubjects(arg1 *anago.StageOptions, arg2 string) ([]in_toto.Subject, error) {
	fake.getProvenanceSubjectsMutex.Lock()
	ret, specificReturn := fake.getProvenanceSubjectsReturnsOnCall[len(fake.getProvenanceSubjectsArgsForCall)]
	fake.getProvenanceSubjectsArgsForCall = append(fake.getProvenanceSubjectsArgsForCall, struct {
		arg1 *anago.StageOptions
		arg2 string
	}{arg1, arg2})
	stub := fake.GetProvenanceSubjectsStub
	fakeReturns := fake.getProvenanceSubjectsReturns
	fake.recordInvocation("GetProvenanceSubjects", []interface{}{arg1, arg2})
	fake.getProvenanceSubjectsMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) GetProvenanceSubjectsCallCount() int {
	fake.getProvenanceSubjectsMutex.RLock()
	defer fake.getProvenanceSubjectsMutex.RUnlock()
	return len(fake.getProvenanceSubjectsArgsForCall)
}

func (fake *FakeStageImpl) GetProvenanceSubjectsCalls(stub func(*anago.StageOptions, string) ([]in_toto.Subject, error)) {
	fake.getProvenanceSubjectsMutex.Lock()
	defer fake.getProvenanceSubjectsMutex.Unlock()
	fake.GetProvenanceSubjectsStub = stub
}

func (fake *FakeStageImpl) GetProvenanceSubjectsArgsForCall(i int) (*anago.StageOptions, string) {
	fake.getProvenanceSubjectsMutex.RLock()
	defer fake.getProvenanceSubjectsMutex.RUnlock()
	argsForCall := fake.getProvenanceSubjectsArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeStageImpl) GetProvenanceSubjectsReturns(result1 []in_toto.Subject, result2 error) {
	fake.getProvenanceSubjectsMutex.Lock()
	defer fake.getProvenanceSubjectsMutex.Unlock()
	fake.GetProvenanceSubjectsStub = nil
	fake.getProvenanceSubjectsReturns = struct {
		result1 []in_toto.Subject
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) GetProvenanceSubjectsReturnsOnCall(i int, result1 []in_toto.Subject, result2 error) {
	fake.getProvenanceSubjectsMutex.Lock()
	defer fake.getProvenanceSubjectsMutex.Unlock()
	fake.GetProvenanceSubjectsStub = nil
	if fake.getProvenanceSubjectsReturnsOnCall == nil {
		fake.getProvenanceSubjectsReturnsOnCall = make(map[int]struct {
			result1 []in_toto.Subject
			result2 error
		})
	}
	fake.getProvenanceSubjectsReturnsOnCall[i] = struct {
		result1 []in_toto.Subject
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) ListBinaries(arg1 string) ([]struct {
	Path     string
	Platform string
	Arch     string
}, error) {
	fake.listBinariesMutex.Lock()
	ret, specificReturn := fake.listBinariesReturnsOnCall[len(fake.listBinariesArgsForCall)]
	fake.listBinariesArgsForCall = append(fake.listBinariesArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.ListBinariesStub
	fakeReturns := fake.listBinariesReturns
	fake.recordInvocation("ListBinaries", []interface{}{arg1})
	fake.listBinariesMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) ListBinariesCallCount() int {
	fake.listBinariesMutex.RLock()
	defer fake.listBinariesMutex.RUnlock()
	return len(fake.listBinariesArgsForCall)
}

func (fake *FakeStageImpl) ListBinariesCalls(stub func(string) ([]struct {
	Path     string
	Platform string
	Arch     string
}, error)) {
	fake.listBinariesMutex.Lock()
	defer fake.listBinariesMutex.Unlock()
	fake.ListBinariesStub = stub
}

func (fake *FakeStageImpl) ListBinariesArgsForCall(i int) string {
	fake.listBinariesMutex.RLock()
	defer fake.listBinariesMutex.RUnlock()
	argsForCall := fake.listBinariesArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) ListBinariesReturns(result1 []struct {
	Path     string
	Platform string
	Arch     string
}, result2 error) {
	fake.listBinariesMutex.Lock()
	defer fake.listBinariesMutex.Unlock()
	fake.ListBinariesStub = nil
	fake.listBinariesReturns = struct {
		result1 []struct {
			Path     string
			Platform string
			Arch     string
		}
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) ListBinariesReturnsOnCall(i int, result1 []struct {
	Path     string
	Platform string
	Arch     string
}, result2 error) {
	fake.listBinariesMutex.Lock()
	defer fake.listBinariesMutex.Unlock()
	fake.ListBinariesStub = nil
	if fake.listBinariesReturnsOnCall == nil {
		fake.listBinariesReturnsOnCall = make(map[int]struct {
			result1 []struct {
				Path     string
				Platform string
				Arch     string
			}
			result2 error
		})
	}
	fake.listBinariesReturnsOnCall[i] = struct {
		result1 []struct {
			Path     string
			Platform string
			Arch     string
		}
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) ListImageArchives(arg1 string) ([]string, error) {
	fake.listImageArchivesMutex.Lock()
	ret, specificReturn := fake.listImageArchivesReturnsOnCall[len(fake.listImageArchivesArgsForCall)]
	fake.listImageArchivesArgsForCall = append(fake.listImageArchivesArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.ListImageArchivesStub
	fakeReturns := fake.listImageArchivesReturns
	fake.recordInvocation("ListImageArchives", []interface{}{arg1})
	fake.listImageArchivesMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) ListImageArchivesCallCount() int {
	fake.listImageArchivesMutex.RLock()
	defer fake.listImageArchivesMutex.RUnlock()
	return len(fake.listImageArchivesArgsForCall)
}

func (fake *FakeStageImpl) ListImageArchivesCalls(stub func(string) ([]string, error)) {
	fake.listImageArchivesMutex.Lock()
	defer fake.listImageArchivesMutex.Unlock()
	fake.ListImageArchivesStub = stub
}

func (fake *FakeStageImpl) ListImageArchivesArgsForCall(i int) string {
	fake.listImageArchivesMutex.RLock()
	defer fake.listImageArchivesMutex.RUnlock()
	argsForCall := fake.listImageArchivesArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) ListImageArchivesReturns(result1 []string, result2 error) {
	fake.listImageArchivesMutex.Lock()
	defer fake.listImageArchivesMutex.Unlock()
	fake.ListImageArchivesStub = nil
	fake.listImageArchivesReturns = struct {
		result1 []string
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) ListImageArchivesReturnsOnCall(i int, result1 []string, result2 error) {
	fake.listImageArchivesMutex.Lock()
	defer fake.listImageArchivesMutex.Unlock()
	fake.ListImageArchivesStub = nil
	if fake.listImageArchivesReturnsOnCall == nil {
		fake.listImageArchivesReturnsOnCall = make(map[int]struct {
			result1 []string
			result2 error
		})
	}
	fake.listImageArchivesReturnsOnCall[i] = struct {
		result1 []string
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) ListTarballs(arg1 string) ([]string, error) {
	fake.listTarballsMutex.Lock()
	ret, specificReturn := fake.listTarballsReturnsOnCall[len(fake.listTarballsArgsForCall)]
	fake.listTarballsArgsForCall = append(fake.listTarballsArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.ListTarballsStub
	fakeReturns := fake.listTarballsReturns
	fake.recordInvocation("ListTarballs", []interface{}{arg1})
	fake.listTarballsMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) ListTarballsCallCount() int {
	fake.listTarballsMutex.RLock()
	defer fake.listTarballsMutex.RUnlock()
	return len(fake.listTarballsArgsForCall)
}

func (fake *FakeStageImpl) ListTarballsCalls(stub func(string) ([]string, error)) {
	fake.listTarballsMutex.Lock()
	defer fake.listTarballsMutex.Unlock()
	fake.ListTarballsStub = stub
}

func (fake *FakeStageImpl) ListTarballsArgsForCall(i int) string {
	fake.listTarballsMutex.RLock()
	defer fake.listTarballsMutex.RUnlock()
	argsForCall := fake.listTarballsArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) ListTarballsReturns(result1 []string, result2 error) {
	fake.listTarballsMutex.Lock()
	defer fake.listTarballsMutex.Unlock()
	fake.ListTarballsStub = nil
	fake.listTarballsReturns = struct {
		result1 []string
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) ListTarballsReturnsOnCall(i int, result1 []string, result2 error) {
	fake.listTarballsMutex.Lock()
	defer fake.listTarballsMutex.Unlock()
	fake.ListTarballsStub = nil
	if fake.listTarballsReturnsOnCall == nil {
		fake.listTarballsReturnsOnCall = make(map[int]struct {
			result1 []string
			result2 error
		})
	}
	fake.listTarballsReturnsOnCall[i] = struct {
		result1 []string
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) MakeCross(arg1 string) error {
	fake.makeCrossMutex.Lock()
	ret, specificReturn := fake.makeCrossReturnsOnCall[len(fake.makeCrossArgsForCall)]
	fake.makeCrossArgsForCall = append(fake.makeCrossArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.MakeCrossStub
	fakeReturns := fake.makeCrossReturns
	fake.recordInvocation("MakeCross", []interface{}{arg1})
	fake.makeCrossMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) MakeCrossCallCount() int {
	fake.makeCrossMutex.RLock()
	defer fake.makeCrossMutex.RUnlock()
	return len(fake.makeCrossArgsForCall)
}

func (fake *FakeStageImpl) MakeCrossCalls(stub func(string) error) {
	fake.makeCrossMutex.Lock()
	defer fake.makeCrossMutex.Unlock()
	fake.MakeCrossStub = stub
}

func (fake *FakeStageImpl) MakeCrossArgsForCall(i int) string {
	fake.makeCrossMutex.RLock()
	defer fake.makeCrossMutex.RUnlock()
	argsForCall := fake.makeCrossArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) MakeCrossReturns(result1 error) {
	fake.makeCrossMutex.Lock()
	defer fake.makeCrossMutex.Unlock()
	fake.MakeCrossStub = nil
	fake.makeCrossReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) MakeCrossReturnsOnCall(i int, result1 error) {
	fake.makeCrossMutex.Lock()
	defer fake.makeCrossMutex.Unlock()
	fake.MakeCrossStub = nil
	if fake.makeCrossReturnsOnCall == nil {
		fake.makeCrossReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.makeCrossReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) Merge(arg1 *git.Repo, arg2 string) error {
	fake.mergeMutex.Lock()
	ret, specificReturn := fake.mergeReturnsOnCall[len(fake.mergeArgsForCall)]
	fake.mergeArgsForCall = append(fake.mergeArgsForCall, struct {
		arg1 *git.Repo
		arg2 string
	}{arg1, arg2})
	stub := fake.MergeStub
	fakeReturns := fake.mergeReturns
	fake.recordInvocation("Merge", []interface{}{arg1, arg2})
	fake.mergeMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) MergeCallCount() int {
	fake.mergeMutex.RLock()
	defer fake.mergeMutex.RUnlock()
	return len(fake.mergeArgsForCall)
}

func (fake *FakeStageImpl) MergeCalls(stub func(*git.Repo, string) error) {
	fake.mergeMutex.Lock()
	defer fake.mergeMutex.Unlock()
	fake.MergeStub = stub
}

func (fake *FakeStageImpl) MergeArgsForCall(i int) (*git.Repo, string) {
	fake.mergeMutex.RLock()
	defer fake.mergeMutex.RUnlock()
	argsForCall := fake.mergeArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeStageImpl) MergeReturns(result1 error) {
	fake.mergeMutex.Lock()
	defer fake.mergeMutex.Unlock()
	fake.MergeStub = nil
	fake.mergeReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) MergeReturnsOnCall(i int, result1 error) {
	fake.mergeMutex.Lock()
	defer fake.mergeMutex.Unlock()
	fake.MergeStub = nil
	if fake.mergeReturnsOnCall == nil {
		fake.mergeReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.mergeReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) OpenRepo(arg1 string) (*git.Repo, error) {
	fake.openRepoMutex.Lock()
	ret, specificReturn := fake.openRepoReturnsOnCall[len(fake.openRepoArgsForCall)]
	fake.openRepoArgsForCall = append(fake.openRepoArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.OpenRepoStub
	fakeReturns := fake.openRepoReturns
	fake.recordInvocation("OpenRepo", []interface{}{arg1})
	fake.openRepoMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) OpenRepoCallCount() int {
	fake.openRepoMutex.RLock()
	defer fake.openRepoMutex.RUnlock()
	return len(fake.openRepoArgsForCall)
}

func (fake *FakeStageImpl) OpenRepoCalls(stub func(string) (*git.Repo, error)) {
	fake.openRepoMutex.Lock()
	defer fake.openRepoMutex.Unlock()
	fake.OpenRepoStub = stub
}

func (fake *FakeStageImpl) OpenRepoArgsForCall(i int) string {
	fake.openRepoMutex.RLock()
	defer fake.openRepoMutex.RUnlock()
	argsForCall := fake.openRepoArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) OpenRepoReturns(result1 *git.Repo, result2 error) {
	fake.openRepoMutex.Lock()
	defer fake.openRepoMutex.Unlock()
	fake.OpenRepoStub = nil
	fake.openRepoReturns = struct {
		result1 *git.Repo
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) OpenRepoReturnsOnCall(i int, result1 *git.Repo, result2 error) {
	fake.openRepoMutex.Lock()
	defer fake.openRepoMutex.Unlock()
	fake.OpenRepoStub = nil
	if fake.openRepoReturnsOnCall == nil {
		fake.openRepoReturnsOnCall = make(map[int]struct {
			result1 *git.Repo
			result2 error
		})
	}
	fake.openRepoReturnsOnCall[i] = struct {
		result1 *git.Repo
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) PrepareWorkspaceStage(arg1 bool) error {
	fake.prepareWorkspaceStageMutex.Lock()
	ret, specificReturn := fake.prepareWorkspaceStageReturnsOnCall[len(fake.prepareWorkspaceStageArgsForCall)]
	fake.prepareWorkspaceStageArgsForCall = append(fake.prepareWorkspaceStageArgsForCall, struct {
		arg1 bool
	}{arg1})
	stub := fake.PrepareWorkspaceStageStub
	fakeReturns := fake.prepareWorkspaceStageReturns
	fake.recordInvocation("PrepareWorkspaceStage", []interface{}{arg1})
	fake.prepareWorkspaceStageMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) PrepareWorkspaceStageCallCount() int {
	fake.prepareWorkspaceStageMutex.RLock()
	defer fake.prepareWorkspaceStageMutex.RUnlock()
	return len(fake.prepareWorkspaceStageArgsForCall)
}

func (fake *FakeStageImpl) PrepareWorkspaceStageCalls(stub func(bool) error) {
	fake.prepareWorkspaceStageMutex.Lock()
	defer fake.prepareWorkspaceStageMutex.Unlock()
	fake.PrepareWorkspaceStageStub = stub
}

func (fake *FakeStageImpl) PrepareWorkspaceStageArgsForCall(i int) bool {
	fake.prepareWorkspaceStageMutex.RLock()
	defer fake.prepareWorkspaceStageMutex.RUnlock()
	argsForCall := fake.prepareWorkspaceStageArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) PrepareWorkspaceStageReturns(result1 error) {
	fake.prepareWorkspaceStageMutex.Lock()
	defer fake.prepareWorkspaceStageMutex.Unlock()
	fake.PrepareWorkspaceStageStub = nil
	fake.prepareWorkspaceStageReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) PrepareWorkspaceStageReturnsOnCall(i int, result1 error) {
	fake.prepareWorkspaceStageMutex.Lock()
	defer fake.prepareWorkspaceStageMutex.Unlock()
	fake.PrepareWorkspaceStageStub = nil
	if fake.prepareWorkspaceStageReturnsOnCall == nil {
		fake.prepareWorkspaceStageReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.prepareWorkspaceStageReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) PushAttestation(arg1 *provenance.Statement, arg2 *anago.StageOptions) error {
	fake.pushAttestationMutex.Lock()
	ret, specificReturn := fake.pushAttestationReturnsOnCall[len(fake.pushAttestationArgsForCall)]
	fake.pushAttestationArgsForCall = append(fake.pushAttestationArgsForCall, struct {
		arg1 *provenance.Statement
		arg2 *anago.StageOptions
	}{arg1, arg2})
	stub := fake.PushAttestationStub
	fakeReturns := fake.pushAttestationReturns
	fake.recordInvocation("PushAttestation", []interface{}{arg1, arg2})
	fake.pushAttestationMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) PushAttestationCallCount() int {
	fake.pushAttestationMutex.RLock()
	defer fake.pushAttestationMutex.RUnlock()
	return len(fake.pushAttestationArgsForCall)
}

func (fake *FakeStageImpl) PushAttestationCalls(stub func(*provenance.Statement, *anago.StageOptions) error) {
	fake.pushAttestationMutex.Lock()
	defer fake.pushAttestationMutex.Unlock()
	fake.PushAttestationStub = stub
}

func (fake *FakeStageImpl) PushAttestationArgsForCall(i int) (*provenance.Statement, *anago.StageOptions) {
	fake.pushAttestationMutex.RLock()
	defer fake.pushAttestationMutex.RUnlock()
	argsForCall := fake.pushAttestationArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeStageImpl) PushAttestationReturns(result1 error) {
	fake.pushAttestationMutex.Lock()
	defer fake.pushAttestationMutex.Unlock()
	fake.PushAttestationStub = nil
	fake.pushAttestationReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) PushAttestationReturnsOnCall(i int, result1 error) {
	fake.pushAttestationMutex.Lock()
	defer fake.pushAttestationMutex.Unlock()
	fake.PushAttestationStub = nil
	if fake.pushAttestationReturnsOnCall == nil {
		fake.pushAttestationReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.pushAttestationReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) PushContainerImages(arg1 *build.Options) error {
	fake.pushContainerImagesMutex.Lock()
	ret, specificReturn := fake.pushContainerImagesReturnsOnCall[len(fake.pushContainerImagesArgsForCall)]
	fake.pushContainerImagesArgsForCall = append(fake.pushContainerImagesArgsForCall, struct {
		arg1 *build.Options
	}{arg1})
	stub := fake.PushContainerImagesStub
	fakeReturns := fake.pushContainerImagesReturns
	fake.recordInvocation("PushContainerImages", []interface{}{arg1})
	fake.pushContainerImagesMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) PushContainerImagesCallCount() int {
	fake.pushContainerImagesMutex.RLock()
	defer fake.pushContainerImagesMutex.RUnlock()
	return len(fake.pushContainerImagesArgsForCall)
}

func (fake *FakeStageImpl) PushContainerImagesCalls(stub func(*build.Options) error) {
	fake.pushContainerImagesMutex.Lock()
	defer fake.pushContainerImagesMutex.Unlock()
	fake.PushContainerImagesStub = stub
}

func (fake *FakeStageImpl) PushContainerImagesArgsForCall(i int) *build.Options {
	fake.pushContainerImagesMutex.RLock()
	defer fake.pushContainerImagesMutex.RUnlock()
	argsForCall := fake.pushContainerImagesArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) PushContainerImagesReturns(result1 error) {
	fake.pushContainerImagesMutex.Lock()
	defer fake.pushContainerImagesMutex.Unlock()
	fake.PushContainerImagesStub = nil
	fake.pushContainerImagesReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) PushContainerImagesReturnsOnCall(i int, result1 error) {
	fake.pushContainerImagesMutex.Lock()
	defer fake.pushContainerImagesMutex.Unlock()
	fake.PushContainerImagesStub = nil
	if fake.pushContainerImagesReturnsOnCall == nil {
		fake.pushContainerImagesReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.pushContainerImagesReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) PushReleaseArtifacts(arg1 *build.Options, arg2 string, arg3 string) error {
	fake.pushReleaseArtifactsMutex.Lock()
	ret, specificReturn := fake.pushReleaseArtifactsReturnsOnCall[len(fake.pushReleaseArtifactsArgsForCall)]
	fake.pushReleaseArtifactsArgsForCall = append(fake.pushReleaseArtifactsArgsForCall, struct {
		arg1 *build.Options
		arg2 string
		arg3 string
	}{arg1, arg2, arg3})
	stub := fake.PushReleaseArtifactsStub
	fakeReturns := fake.pushReleaseArtifactsReturns
	fake.recordInvocation("PushReleaseArtifacts", []interface{}{arg1, arg2, arg3})
	fake.pushReleaseArtifactsMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) PushReleaseArtifactsCallCount() int {
	fake.pushReleaseArtifactsMutex.RLock()
	defer fake.pushReleaseArtifactsMutex.RUnlock()
	return len(fake.pushReleaseArtifactsArgsForCall)
}

func (fake *FakeStageImpl) PushReleaseArtifactsCalls(stub func(*build.Options, string, string) error) {
	fake.pushReleaseArtifactsMutex.Lock()
	defer fake.pushReleaseArtifactsMutex.Unlock()
	fake.PushReleaseArtifactsStub = stub
}

func (fake *FakeStageImpl) PushReleaseArtifactsArgsForCall(i int) (*build.Options, string, string) {
	fake.pushReleaseArtifactsMutex.RLock()
	defer fake.pushReleaseArtifactsMutex.RUnlock()
	argsForCall := fake.pushReleaseArtifactsArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeStageImpl) PushReleaseArtifactsReturns(result1 error) {
	fake.pushReleaseArtifactsMutex.Lock()
	defer fake.pushReleaseArtifactsMutex.Unlock()
	fake.PushReleaseArtifactsStub = nil
	fake.pushReleaseArtifactsReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) PushReleaseArtifactsReturnsOnCall(i int, result1 error) {
	fake.pushReleaseArtifactsMutex.Lock()
	defer fake.pushReleaseArtifactsMutex.Unlock()
	fake.PushReleaseArtifactsStub = nil
	if fake.pushReleaseArtifactsReturnsOnCall == nil {
		fake.pushReleaseArtifactsReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.pushReleaseArtifactsReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) RevParse(arg1 *git.Repo, arg2 string) (string, error) {
	fake.revParseMutex.Lock()
	ret, specificReturn := fake.revParseReturnsOnCall[len(fake.revParseArgsForCall)]
	fake.revParseArgsForCall = append(fake.revParseArgsForCall, struct {
		arg1 *git.Repo
		arg2 string
	}{arg1, arg2})
	stub := fake.RevParseStub
	fakeReturns := fake.revParseReturns
	fake.recordInvocation("RevParse", []interface{}{arg1, arg2})
	fake.revParseMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) RevParseCallCount() int {
	fake.revParseMutex.RLock()
	defer fake.revParseMutex.RUnlock()
	return len(fake.revParseArgsForCall)
}

func (fake *FakeStageImpl) RevParseCalls(stub func(*git.Repo, string) (string, error)) {
	fake.revParseMutex.Lock()
	defer fake.revParseMutex.Unlock()
	fake.RevParseStub = stub
}

func (fake *FakeStageImpl) RevParseArgsForCall(i int) (*git.Repo, string) {
	fake.revParseMutex.RLock()
	defer fake.revParseMutex.RUnlock()
	argsForCall := fake.revParseArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeStageImpl) RevParseReturns(result1 string, result2 error) {
	fake.revParseMutex.Lock()
	defer fake.revParseMutex.Unlock()
	fake.RevParseStub = nil
	fake.revParseReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) RevParseReturnsOnCall(i int, result1 string, result2 error) {
	fake.revParseMutex.Lock()
	defer fake.revParseMutex.Unlock()
	fake.RevParseStub = nil
	if fake.revParseReturnsOnCall == nil {
		fake.revParseReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.revParseReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) RevParseTag(arg1 *git.Repo, arg2 string) (string, error) {
	fake.revParseTagMutex.Lock()
	ret, specificReturn := fake.revParseTagReturnsOnCall[len(fake.revParseTagArgsForCall)]
	fake.revParseTagArgsForCall = append(fake.revParseTagArgsForCall, struct {
		arg1 *git.Repo
		arg2 string
	}{arg1, arg2})
	stub := fake.RevParseTagStub
	fakeReturns := fake.revParseTagReturns
	fake.recordInvocation("RevParseTag", []interface{}{arg1, arg2})
	fake.revParseTagMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) RevParseTagCallCount() int {
	fake.revParseTagMutex.RLock()
	defer fake.revParseTagMutex.RUnlock()
	return len(fake.revParseTagArgsForCall)
}

func (fake *FakeStageImpl) RevParseTagCalls(stub func(*git.Repo, string) (string, error)) {
	fake.revParseTagMutex.Lock()
	defer fake.revParseTagMutex.Unlock()
	fake.RevParseTagStub = stub
}

func (fake *FakeStageImpl) RevParseTagArgsForCall(i int) (*git.Repo, string) {
	fake.revParseTagMutex.RLock()
	defer fake.revParseTagMutex.RUnlock()
	argsForCall := fake.revParseTagArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeStageImpl) RevParseTagReturns(result1 string, result2 error) {
	fake.revParseTagMutex.Lock()
	defer fake.revParseTagMutex.Unlock()
	fake.RevParseTagStub = nil
	fake.revParseTagReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) RevParseTagReturnsOnCall(i int, result1 string, result2 error) {
	fake.revParseTagMutex.Lock()
	defer fake.revParseTagMutex.Unlock()
	fake.RevParseTagStub = nil
	if fake.revParseTagReturnsOnCall == nil {
		fake.revParseTagReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.revParseTagReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) StageLocalArtifacts(arg1 *build.Options) error {
	fake.stageLocalArtifactsMutex.Lock()
	ret, specificReturn := fake.stageLocalArtifactsReturnsOnCall[len(fake.stageLocalArtifactsArgsForCall)]
	fake.stageLocalArtifactsArgsForCall = append(fake.stageLocalArtifactsArgsForCall, struct {
		arg1 *build.Options
	}{arg1})
	stub := fake.StageLocalArtifactsStub
	fakeReturns := fake.stageLocalArtifactsReturns
	fake.recordInvocation("StageLocalArtifacts", []interface{}{arg1})
	fake.stageLocalArtifactsMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) StageLocalArtifactsCallCount() int {
	fake.stageLocalArtifactsMutex.RLock()
	defer fake.stageLocalArtifactsMutex.RUnlock()
	return len(fake.stageLocalArtifactsArgsForCall)
}

func (fake *FakeStageImpl) StageLocalArtifactsCalls(stub func(*build.Options) error) {
	fake.stageLocalArtifactsMutex.Lock()
	defer fake.stageLocalArtifactsMutex.Unlock()
	fake.StageLocalArtifactsStub = stub
}

func (fake *FakeStageImpl) StageLocalArtifactsArgsForCall(i int) *build.Options {
	fake.stageLocalArtifactsMutex.RLock()
	defer fake.stageLocalArtifactsMutex.RUnlock()
	argsForCall := fake.stageLocalArtifactsArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) StageLocalArtifactsReturns(result1 error) {
	fake.stageLocalArtifactsMutex.Lock()
	defer fake.stageLocalArtifactsMutex.Unlock()
	fake.StageLocalArtifactsStub = nil
	fake.stageLocalArtifactsReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) StageLocalArtifactsReturnsOnCall(i int, result1 error) {
	fake.stageLocalArtifactsMutex.Lock()
	defer fake.stageLocalArtifactsMutex.Unlock()
	fake.StageLocalArtifactsStub = nil
	if fake.stageLocalArtifactsReturnsOnCall == nil {
		fake.stageLocalArtifactsReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.stageLocalArtifactsReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) StageLocalSourceTree(arg1 *build.Options, arg2 string, arg3 string) error {
	fake.stageLocalSourceTreeMutex.Lock()
	ret, specificReturn := fake.stageLocalSourceTreeReturnsOnCall[len(fake.stageLocalSourceTreeArgsForCall)]
	fake.stageLocalSourceTreeArgsForCall = append(fake.stageLocalSourceTreeArgsForCall, struct {
		arg1 *build.Options
		arg2 string
		arg3 string
	}{arg1, arg2, arg3})
	stub := fake.StageLocalSourceTreeStub
	fakeReturns := fake.stageLocalSourceTreeReturns
	fake.recordInvocation("StageLocalSourceTree", []interface{}{arg1, arg2, arg3})
	fake.stageLocalSourceTreeMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) StageLocalSourceTreeCallCount() int {
	fake.stageLocalSourceTreeMutex.RLock()
	defer fake.stageLocalSourceTreeMutex.RUnlock()
	return len(fake.stageLocalSourceTreeArgsForCall)
}

func (fake *FakeStageImpl) StageLocalSourceTreeCalls(stub func(*build.Options, string, string) error) {
	fake.stageLocalSourceTreeMutex.Lock()
	defer fake.stageLocalSourceTreeMutex.Unlock()
	fake.StageLocalSourceTreeStub = stub
}

func (fake *FakeStageImpl) StageLocalSourceTreeArgsForCall(i int) (*build.Options, string, string) {
	fake.stageLocalSourceTreeMutex.RLock()
	defer fake.stageLocalSourceTreeMutex.RUnlock()
	argsForCall := fake.stageLocalSourceTreeArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeStageImpl) StageLocalSourceTreeReturns(result1 error) {
	fake.stageLocalSourceTreeMutex.Lock()
	defer fake.stageLocalSourceTreeMutex.Unlock()
	fake.StageLocalSourceTreeStub = nil
	fake.stageLocalSourceTreeReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) StageLocalSourceTreeReturnsOnCall(i int, result1 error) {
	fake.stageLocalSourceTreeMutex.Lock()
	defer fake.stageLocalSourceTreeMutex.Unlock()
	fake.StageLocalSourceTreeStub = nil
	if fake.stageLocalSourceTreeReturnsOnCall == nil {
		fake.stageLocalSourceTreeReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.stageLocalSourceTreeReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) Submit(arg1 *gcb.Options) error {
	fake.submitMutex.Lock()
	ret, specificReturn := fake.submitReturnsOnCall[len(fake.submitArgsForCall)]
	fake.submitArgsForCall = append(fake.submitArgsForCall, struct {
		arg1 *gcb.Options
	}{arg1})
	stub := fake.SubmitStub
	fakeReturns := fake.submitReturns
	fake.recordInvocation("Submit", []interface{}{arg1})
	fake.submitMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) SubmitCallCount() int {
	fake.submitMutex.RLock()
	defer fake.submitMutex.RUnlock()
	return len(fake.submitArgsForCall)
}

func (fake *FakeStageImpl) SubmitCalls(stub func(*gcb.Options) error) {
	fake.submitMutex.Lock()
	defer fake.submitMutex.Unlock()
	fake.SubmitStub = stub
}

func (fake *FakeStageImpl) SubmitArgsForCall(i int) *gcb.Options {
	fake.submitMutex.RLock()
	defer fake.submitMutex.RUnlock()
	argsForCall := fake.submitArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) SubmitReturns(result1 error) {
	fake.submitMutex.Lock()
	defer fake.submitMutex.Unlock()
	fake.SubmitStub = nil
	fake.submitReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) SubmitReturnsOnCall(i int, result1 error) {
	fake.submitMutex.Lock()
	defer fake.submitMutex.Unlock()
	fake.SubmitStub = nil
	if fake.submitReturnsOnCall == nil {
		fake.submitReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.submitReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) Tag(arg1 *git.Repo, arg2 string, arg3 string) error {
	fake.tagMutex.Lock()
	ret, specificReturn := fake.tagReturnsOnCall[len(fake.tagArgsForCall)]
	fake.tagArgsForCall = append(fake.tagArgsForCall, struct {
		arg1 *git.Repo
		arg2 string
		arg3 string
	}{arg1, arg2, arg3})
	stub := fake.TagStub
	fakeReturns := fake.tagReturns
	fake.recordInvocation("Tag", []interface{}{arg1, arg2, arg3})
	fake.tagMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) TagCallCount() int {
	fake.tagMutex.RLock()
	defer fake.tagMutex.RUnlock()
	return len(fake.tagArgsForCall)
}

func (fake *FakeStageImpl) TagCalls(stub func(*git.Repo, string, string) error) {
	fake.tagMutex.Lock()
	defer fake.tagMutex.Unlock()
	fake.TagStub = stub
}

func (fake *FakeStageImpl) TagArgsForCall(i int) (*git.Repo, string, string) {
	fake.tagMutex.RLock()
	defer fake.tagMutex.RUnlock()
	argsForCall := fake.tagArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeStageImpl) TagReturns(result1 error) {
	fake.tagMutex.Lock()
	defer fake.tagMutex.Unlock()
	fake.TagStub = nil
	fake.tagReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) TagReturnsOnCall(i int, result1 error) {
	fake.tagMutex.Lock()
	defer fake.tagMutex.Unlock()
	fake.TagStub = nil
	if fake.tagReturnsOnCall == nil {
		fake.tagReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.tagReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) ToFile(arg1 string) error {
	fake.toFileMutex.Lock()
	ret, specificReturn := fake.toFileReturnsOnCall[len(fake.toFileArgsForCall)]
	fake.toFileArgsForCall = append(fake.toFileArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.ToFileStub
	fakeReturns := fake.toFileReturns
	fake.recordInvocation("ToFile", []interface{}{arg1})
	fake.toFileMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) ToFileCallCount() int {
	fake.toFileMutex.RLock()
	defer fake.toFileMutex.RUnlock()
	return len(fake.toFileArgsForCall)
}

func (fake *FakeStageImpl) ToFileCalls(stub func(string) error) {
	fake.toFileMutex.Lock()
	defer fake.toFileMutex.Unlock()
	fake.ToFileStub = stub
}

func (fake *FakeStageImpl) ToFileArgsForCall(i int) string {
	fake.toFileMutex.RLock()
	defer fake.toFileMutex.RUnlock()
	argsForCall := fake.toFileArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) ToFileReturns(result1 error) {
	fake.toFileMutex.Lock()
	defer fake.toFileMutex.Unlock()
	fake.ToFileStub = nil
	fake.toFileReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) ToFileReturnsOnCall(i int, result1 error) {
	fake.toFileMutex.Lock()
	defer fake.toFileMutex.Unlock()
	fake.ToFileStub = nil
	if fake.toFileReturnsOnCall == nil {
		fake.toFileReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.toFileReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) VerifyArtifacts(arg1 []string) error {
	var arg1Copy []string
	if arg1 != nil {
		arg1Copy = make([]string, len(arg1))
		copy(arg1Copy, arg1)
	}
	fake.verifyArtifactsMutex.Lock()
	ret, specificReturn := fake.verifyArtifactsReturnsOnCall[len(fake.verifyArtifactsArgsForCall)]
	fake.verifyArtifactsArgsForCall = append(fake.verifyArtifactsArgsForCall, struct {
		arg1 []string
	}{arg1Copy})
	stub := fake.VerifyArtifactsStub
	fakeReturns := fake.verifyArtifactsReturns
	fake.recordInvocation("VerifyArtifacts", []interface{}{arg1Copy})
	fake.verifyArtifactsMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) VerifyArtifactsCallCount() int {
	fake.verifyArtifactsMutex.RLock()
	defer fake.verifyArtifactsMutex.RUnlock()
	return len(fake.verifyArtifactsArgsForCall)
}

func (fake *FakeStageImpl) VerifyArtifactsCalls(stub func([]string) error) {
	fake.verifyArtifactsMutex.Lock()
	defer fake.verifyArtifactsMutex.Unlock()
	fake.VerifyArtifactsStub = stub
}

func (fake *FakeStageImpl) VerifyArtifactsArgsForCall(i int) []string {
	fake.verifyArtifactsMutex.RLock()
	defer fake.verifyArtifactsMutex.RUnlock()
	argsForCall := fake.verifyArtifactsArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) VerifyArtifactsReturns(result1 error) {
	fake.verifyArtifactsMutex.Lock()
	defer fake.verifyArtifactsMutex.Unlock()
	fake.VerifyArtifactsStub = nil
	fake.verifyArtifactsReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) VerifyArtifactsReturnsOnCall(i int, result1 error) {
	fake.verifyArtifactsMutex.Lock()
	defer fake.verifyArtifactsMutex.Unlock()
	fake.VerifyArtifactsStub = nil
	if fake.verifyArtifactsReturnsOnCall == nil {
		fake.verifyArtifactsReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.verifyArtifactsReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) WriteSourceBOM(arg1 *spdx.Document, arg2 string) error {
	fake.writeSourceBOMMutex.Lock()
	ret, specificReturn := fake.writeSourceBOMReturnsOnCall[len(fake.writeSourceBOMArgsForCall)]
	fake.writeSourceBOMArgsForCall = append(fake.writeSourceBOMArgsForCall, struct {
		arg1 *spdx.Document
		arg2 string
	}{arg1, arg2})
	stub := fake.WriteSourceBOMStub
	fakeReturns := fake.writeSourceBOMReturns
	fake.recordInvocation("WriteSourceBOM", []interface{}{arg1, arg2})
	fake.writeSourceBOMMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) WriteSourceBOMCallCount() int {
	fake.writeSourceBOMMutex.RLock()
	defer fake.writeSourceBOMMutex.RUnlock()
	return len(fake.writeSourceBOMArgsForCall)
}

func (fake *FakeStageImpl) WriteSourceBOMCalls(stub func(*spdx.Document, string) error) {
	fake.writeSourceBOMMutex.Lock()
	defer fake.writeSourceBOMMutex.Unlock()
	fake.WriteSourceBOMStub = stub
}

func (fake *FakeStageImpl) WriteSourceBOMArgsForCall(i int) (*spdx.Document, string) {
	fake.writeSourceBOMMutex.RLock()
	defer fake.writeSourceBOMMutex.RUnlock()
	argsForCall := fake.writeSourceBOMArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeStageImpl) WriteSourceBOMReturns(result1 error) {
	fake.writeSourceBOMMutex.Lock()
	defer fake.writeSourceBOMMutex.Unlock()
	fake.WriteSourceBOMStub = nil
	fake.writeSourceBOMReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) WriteSourceBOMReturnsOnCall(i int, result1 error) {
	fake.writeSourceBOMMutex.Lock()
	defer fake.writeSourceBOMMutex.Unlock()
	fake.WriteSourceBOMStub = nil
	if fake.writeSourceBOMReturnsOnCall == nil {
		fake.writeSourceBOMReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.writeSourceBOMReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.addBinariesToSBOMMutex.RLock()
	defer fake.addBinariesToSBOMMutex.RUnlock()
	fake.addTarfilesToSBOMMutex.RLock()
	defer fake.addTarfilesToSBOMMutex.RUnlock()
	fake.branchNeedsCreationMutex.RLock()
	defer fake.branchNeedsCreationMutex.RUnlock()
	fake.buildBaseArtifactsSBOMMutex.RLock()
	defer fake.buildBaseArtifactsSBOMMutex.RUnlock()
	fake.checkPrerequisitesMutex.RLock()
	defer fake.checkPrerequisitesMutex.RUnlock()
	fake.checkReleaseBucketMutex.RLock()
	defer fake.checkReleaseBucketMutex.RUnlock()
	fake.checkoutMutex.RLock()
	defer fake.checkoutMutex.RUnlock()
	fake.commitEmptyMutex.RLock()
	defer fake.commitEmptyMutex.RUnlock()
	fake.currentBranchMutex.RLock()
	defer fake.currentBranchMutex.RUnlock()
	fake.deleteLocalSourceTarballMutex.RLock()
	defer fake.deleteLocalSourceTarballMutex.RUnlock()
	fake.dockerHubLoginMutex.RLock()
	defer fake.dockerHubLoginMutex.RUnlock()
	fake.generateAttestationMutex.RLock()
	defer fake.generateAttestationMutex.RUnlock()
	fake.generateChangelogMutex.RLock()
	defer fake.generateChangelogMutex.RUnlock()
	fake.generateReleaseVersionMutex.RLock()
	defer fake.generateReleaseVersionMutex.RUnlock()
	fake.generateSourceTreeBOMMutex.RLock()
	defer fake.generateSourceTreeBOMMutex.RUnlock()
	fake.generateVersionArtifactsBOMMutex.RLock()
	defer fake.generateVersionArtifactsBOMMutex.RUnlock()
	fake.getOutputDirSubjectsMutex.RLock()
	defer fake.getOutputDirSubjectsMutex.RUnlock()
	fake.getProvenanceSubjectsMutex.RLock()
	defer fake.getProvenanceSubjectsMutex.RUnlock()
	fake.listBinariesMutex.RLock()
	defer fake.listBinariesMutex.RUnlock()
	fake.listImageArchivesMutex.RLock()
	defer fake.listImageArchivesMutex.RUnlock()
	fake.listTarballsMutex.RLock()
	defer fake.listTarballsMutex.RUnlock()
	fake.makeCrossMutex.RLock()
	defer fake.makeCrossMutex.RUnlock()
	fake.mergeMutex.RLock()
	defer fake.mergeMutex.RUnlock()
	fake.openRepoMutex.RLock()
	defer fake.openRepoMutex.RUnlock()
	fake.prepareWorkspaceStageMutex.RLock()
	defer fake.prepareWorkspaceStageMutex.RUnlock()
	fake.pushAttestationMutex.RLock()
	defer fake.pushAttestationMutex.RUnlock()
	fake.pushContainerImagesMutex.RLock()
	defer fake.pushContainerImagesMutex.RUnlock()
	fake.pushReleaseArtifactsMutex.RLock()
	defer fake.pushReleaseArtifactsMutex.RUnlock()
	fake.revParseMutex.RLock()
	defer fake.revParseMutex.RUnlock()
	fake.revParseTagMutex.RLock()
	defer fake.revParseTagMutex.RUnlock()
	fake.stageLocalArtifactsMutex.RLock()
	defer fake.stageLocalArtifactsMutex.RUnlock()
	fake.stageLocalSourceTreeMutex.RLock()
	defer fake.stageLocalSourceTreeMutex.RUnlock()
	fake.submitMutex.RLock()
	defer fake.submitMutex.RUnlock()
	fake.tagMutex.RLock()
	defer fake.tagMutex.RUnlock()
	fake.toFileMutex.RLock()
	defer fake.toFileMutex.RUnlock()
	fake.verifyArtifactsMutex.RLock()
	defer fake.verifyArtifactsMutex.RUnlock()
	fake.writeSourceBOMMutex.RLock()
	defer fake.writeSourceBOMMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeStageImpl) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}
