/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package binaryfakes

import (
	"sync"
)

type FakeBinaryImplementation struct {
	ArchStub        func() string
	archMutex       sync.RWMutex
	archArgsForCall []struct {
	}
	archReturns struct {
		result1 string
	}
	archReturnsOnCall map[int]struct {
		result1 string
	}
	OSStub        func() string
	oSMutex       sync.RWMutex
	oSArgsForCall []struct {
	}
	oSReturns struct {
		result1 string
	}
	oSReturnsOnCall map[int]struct {
		result1 string
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeBinaryImplementation) Arch() string {
	fake.archMutex.Lock()
	ret, specificReturn := fake.archReturnsOnCall[len(fake.archArgsForCall)]
	fake.archArgsForCall = append(fake.archArgsForCall, struct {
	}{})
	stub := fake.ArchStub
	fakeReturns := fake.archReturns
	fake.recordInvocation("Arch", []interface{}{})
	fake.archMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeBinaryImplementation) ArchCallCount() int {
	fake.archMutex.RLock()
	defer fake.archMutex.RUnlock()
	return len(fake.archArgsForCall)
}

func (fake *FakeBinaryImplementation) ArchCalls(stub func() string) {
	fake.archMutex.Lock()
	defer fake.archMutex.Unlock()
	fake.ArchStub = stub
}

func (fake *FakeBinaryImplementation) ArchReturns(result1 string) {
	fake.archMutex.Lock()
	defer fake.archMutex.Unlock()
	fake.ArchStub = nil
	fake.archReturns = struct {
		result1 string
	}{result1}
}

func (fake *FakeBinaryImplementation) ArchReturnsOnCall(i int, result1 string) {
	fake.archMutex.Lock()
	defer fake.archMutex.Unlock()
	fake.ArchStub = nil
	if fake.archReturnsOnCall == nil {
		fake.archReturnsOnCall = make(map[int]struct {
			result1 string
		})
	}
	fake.archReturnsOnCall[i] = struct {
		result1 string
	}{result1}
}

func (fake *FakeBinaryImplementation) OS() string {
	fake.oSMutex.Lock()
	ret, specificReturn := fake.oSReturnsOnCall[len(fake.oSArgsForCall)]
	fake.oSArgsForCall = append(fake.oSArgsForCall, struct {
	}{})
	stub := fake.OSStub
	fakeReturns := fake.oSReturns
	fake.recordInvocation("OS", []interface{}{})
	fake.oSMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeBinaryImplementation) OSCallCount() int {
	fake.oSMutex.RLock()
	defer fake.oSMutex.RUnlock()
	return len(fake.oSArgsForCall)
}

func (fake *FakeBinaryImplementation) OSCalls(stub func() string) {
	fake.oSMutex.Lock()
	defer fake.oSMutex.Unlock()
	fake.OSStub = stub
}

func (fake *FakeBinaryImplementation) OSReturns(result1 string) {
	fake.oSMutex.Lock()
	defer fake.oSMutex.Unlock()
	fake.OSStub = nil
	fake.oSReturns = struct {
		result1 string
	}{result1}
}

func (fake *FakeBinaryImplementation) OSReturnsOnCall(i int, result1 string) {
	fake.oSMutex.Lock()
	defer fake.oSMutex.Unlock()
	fake.OSStub = nil
	if fake.oSReturnsOnCall == nil {
		fake.oSReturnsOnCall = make(map[int]struct {
			result1 string
		})
	}
	fake.oSReturnsOnCall[i] = struct {
		result1 string
	}{result1}
}

func (fake *FakeBinaryImplementation) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.archMutex.RLock()
	defer fake.archMutex.RUnlock()
	fake.oSMutex.RLock()
	defer fake.oSMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeBinaryImplementation) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}
