/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package gcbfakes

import (
	"sync"

	"github.com/blang/semver"
	"k8s.io/release/pkg/gcp/gcb"
	"k8s.io/release/pkg/release"
)

type FakeRelease struct {
	GenerateReleaseVersionStub        func(string, string, string, bool) (*release.Versions, error)
	generateReleaseVersionMutex       sync.RWMutex
	generateReleaseVersionArgsForCall []struct {
		arg1 string
		arg2 string
		arg3 string
		arg4 bool
	}
	generateReleaseVersionReturns struct {
		result1 *release.Versions
		result2 error
	}
	generateReleaseVersionReturnsOnCall map[int]struct {
		result1 *release.Versions
		result2 error
	}
	NeedsCreationStub        func(string, string, semver.Version) (bool, error)
	needsCreationMutex       sync.RWMutex
	needsCreationArgsForCall []struct {
		arg1 string
		arg2 string
		arg3 semver.Version
	}
	needsCreationReturns struct {
		result1 bool
		result2 error
	}
	needsCreationReturnsOnCall map[int]struct {
		result1 bool
		result2 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeRelease) GenerateReleaseVersion(arg1 string, arg2 string, arg3 string, arg4 bool) (*release.Versions, error) {
	fake.generateReleaseVersionMutex.Lock()
	ret, specificReturn := fake.generateReleaseVersionReturnsOnCall[len(fake.generateReleaseVersionArgsForCall)]
	fake.generateReleaseVersionArgsForCall = append(fake.generateReleaseVersionArgsForCall, struct {
		arg1 string
		arg2 string
		arg3 string
		arg4 bool
	}{arg1, arg2, arg3, arg4})
	stub := fake.GenerateReleaseVersionStub
	fakeReturns := fake.generateReleaseVersionReturns
	fake.recordInvocation("GenerateReleaseVersion", []interface{}{arg1, arg2, arg3, arg4})
	fake.generateReleaseVersionMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3, arg4)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeRelease) GenerateReleaseVersionCallCount() int {
	fake.generateReleaseVersionMutex.RLock()
	defer fake.generateReleaseVersionMutex.RUnlock()
	return len(fake.generateReleaseVersionArgsForCall)
}

func (fake *FakeRelease) GenerateReleaseVersionCalls(stub func(string, string, string, bool) (*release.Versions, error)) {
	fake.generateReleaseVersionMutex.Lock()
	defer fake.generateReleaseVersionMutex.Unlock()
	fake.GenerateReleaseVersionStub = stub
}

func (fake *FakeRelease) GenerateReleaseVersionArgsForCall(i int) (string, string, string, bool) {
	fake.generateReleaseVersionMutex.RLock()
	defer fake.generateReleaseVersionMutex.RUnlock()
	argsForCall := fake.generateReleaseVersionArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3, argsForCall.arg4
}

func (fake *FakeRelease) GenerateReleaseVersionReturns(result1 *release.Versions, result2 error) {
	fake.generateReleaseVersionMutex.Lock()
	defer fake.generateReleaseVersionMutex.Unlock()
	fake.GenerateReleaseVersionStub = nil
	fake.generateReleaseVersionReturns = struct {
		result1 *release.Versions
		result2 error
	}{result1, result2}
}

func (fake *FakeRelease) GenerateReleaseVersionReturnsOnCall(i int, result1 *release.Versions, result2 error) {
	fake.generateReleaseVersionMutex.Lock()
	defer fake.generateReleaseVersionMutex.Unlock()
	fake.GenerateReleaseVersionStub = nil
	if fake.generateReleaseVersionReturnsOnCall == nil {
		fake.generateReleaseVersionReturnsOnCall = make(map[int]struct {
			result1 *release.Versions
			result2 error
		})
	}
	fake.generateReleaseVersionReturnsOnCall[i] = struct {
		result1 *release.Versions
		result2 error
	}{result1, result2}
}

func (fake *FakeRelease) NeedsCreation(arg1 string, arg2 string, arg3 semver.Version) (bool, error) {
	fake.needsCreationMutex.Lock()
	ret, specificReturn := fake.needsCreationReturnsOnCall[len(fake.needsCreationArgsForCall)]
	fake.needsCreationArgsForCall = append(fake.needsCreationArgsForCall, struct {
		arg1 string
		arg2 string
		arg3 semver.Version
	}{arg1, arg2, arg3})
	stub := fake.NeedsCreationStub
	fakeReturns := fake.needsCreationReturns
	fake.recordInvocation("NeedsCreation", []interface{}{arg1, arg2, arg3})
	fake.needsCreationMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeRelease) NeedsCreationCallCount() int {
	fake.needsCreationMutex.RLock()
	defer fake.needsCreationMutex.RUnlock()
	return len(fake.needsCreationArgsForCall)
}

func (fake *FakeRelease) NeedsCreationCalls(stub func(string, string, semver.Version) (bool, error)) {
	fake.needsCreationMutex.Lock()
	defer fake.needsCreationMutex.Unlock()
	fake.NeedsCreationStub = stub
}

func (fake *FakeRelease) NeedsCreationArgsForCall(i int) (string, string, semver.Version) {
	fake.needsCreationMutex.RLock()
	defer fake.needsCreationMutex.RUnlock()
	argsForCall := fake.needsCreationArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeRelease) NeedsCreationReturns(result1 bool, result2 error) {
	fake.needsCreationMutex.Lock()
	defer fake.needsCreationMutex.Unlock()
	fake.NeedsCreationStub = nil
	fake.needsCreationReturns = struct {
		result1 bool
		result2 error
	}{result1, result2}
}

func (fake *FakeRelease) NeedsCreationReturnsOnCall(i int, result1 bool, result2 error) {
	fake.needsCreationMutex.Lock()
	defer fake.needsCreationMutex.Unlock()
	fake.NeedsCreationStub = nil
	if fake.needsCreationReturnsOnCall == nil {
		fake.needsCreationReturnsOnCall = make(map[int]struct {
			result1 bool
			result2 error
		})
	}
	fake.needsCreationReturnsOnCall[i] = struct {
		result1 bool
		result2 error
	}{result1, result2}
}

func (fake *FakeRelease) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.generateReleaseVersionMutex.RLock()
	defer fake.generateReleaseVersionMutex.RUnlock()
	fake.needsCreationMutex.RLock()
	defer fake.needsCreationMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeRelease) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}

var _ gcb.Release = new(FakeRelease)
