/*
Copyright 2021 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package provenancefakes

import (
	"sync"

	"github.com/in-toto/in-toto-golang/in_toto"
	"k8s.io/release/pkg/provenance"
)

type FakePredicateImplementation struct {
	AddMaterialStub        func(*provenance.Predicate, string, in_toto.DigestSet)
	addMaterialMutex       sync.RWMutex
	addMaterialArgsForCall []struct {
		arg1 *provenance.Predicate
		arg2 string
		arg3 in_toto.DigestSet
	}
	WriteStub        func(*provenance.Predicate, string) error
	writeMutex       sync.RWMutex
	writeArgsForCall []struct {
		arg1 *provenance.Predicate
		arg2 string
	}
	writeReturns struct {
		result1 error
	}
	writeReturnsOnCall map[int]struct {
		result1 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakePredicateImplementation) AddMaterial(arg1 *provenance.Predicate, arg2 string, arg3 in_toto.DigestSet) {
	fake.addMaterialMutex.Lock()
	fake.addMaterialArgsForCall = append(fake.addMaterialArgsForCall, struct {
		arg1 *provenance.Predicate
		arg2 string
		arg3 in_toto.DigestSet
	}{arg1, arg2, arg3})
	stub := fake.AddMaterialStub
	fake.recordInvocation("AddMaterial", []interface{}{arg1, arg2, arg3})
	fake.addMaterialMutex.Unlock()
	if stub != nil {
		fake.AddMaterialStub(arg1, arg2, arg3)
	}
}

func (fake *FakePredicateImplementation) AddMaterialCallCount() int {
	fake.addMaterialMutex.RLock()
	defer fake.addMaterialMutex.RUnlock()
	return len(fake.addMaterialArgsForCall)
}

func (fake *FakePredicateImplementation) AddMaterialCalls(stub func(*provenance.Predicate, string, in_toto.DigestSet)) {
	fake.addMaterialMutex.Lock()
	defer fake.addMaterialMutex.Unlock()
	fake.AddMaterialStub = stub
}

func (fake *FakePredicateImplementation) AddMaterialArgsForCall(i int) (*provenance.Predicate, string, in_toto.DigestSet) {
	fake.addMaterialMutex.RLock()
	defer fake.addMaterialMutex.RUnlock()
	argsForCall := fake.addMaterialArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakePredicateImplementation) Write(arg1 *provenance.Predicate, arg2 string) error {
	fake.writeMutex.Lock()
	ret, specificReturn := fake.writeReturnsOnCall[len(fake.writeArgsForCall)]
	fake.writeArgsForCall = append(fake.writeArgsForCall, struct {
		arg1 *provenance.Predicate
		arg2 string
	}{arg1, arg2})
	stub := fake.WriteStub
	fakeReturns := fake.writeReturns
	fake.recordInvocation("Write", []interface{}{arg1, arg2})
	fake.writeMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakePredicateImplementation) WriteCallCount() int {
	fake.writeMutex.RLock()
	defer fake.writeMutex.RUnlock()
	return len(fake.writeArgsForCall)
}

func (fake *FakePredicateImplementation) WriteCalls(stub func(*provenance.Predicate, string) error) {
	fake.writeMutex.Lock()
	defer fake.writeMutex.Unlock()
	fake.WriteStub = stub
}

func (fake *FakePredicateImplementation) WriteArgsForCall(i int) (*provenance.Predicate, string) {
	fake.writeMutex.RLock()
	defer fake.writeMutex.RUnlock()
	argsForCall := fake.writeArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakePredicateImplementation) WriteReturns(result1 error) {
	fake.writeMutex.Lock()
	defer fake.writeMutex.Unlock()
	fake.WriteStub = nil
	fake.writeReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakePredicateImplementation) WriteReturnsOnCall(i int, result1 error) {
	fake.writeMutex.Lock()
	defer fake.writeMutex.Unlock()
	fake.WriteStub = nil
	if fake.writeReturnsOnCall == nil {
		fake.writeReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.writeReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakePredicateImplementation) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.addMaterialMutex.RLock()
	defer fake.addMaterialMutex.RUnlock()
	fake.writeMutex.RLock()
	defer fake.writeMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakePredicateImplementation) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}

var _ provenance.PredicateImplementation = new(FakePredicateImplementation)
