# Creating a New Release

## Changelog

The changelog is autogenerated by github at the release notes by inspecting 
labels at PRs.

To have a proper changelog, make sure the PRs are labeled as expected so they 
appear at proper the proper section. According to [1] these are the labels:

- Skip release notes:
  - ignore-for-release
- Breaking Changes 🛠
  - Semver-Major
  - kind/breaking-change
- Exciting New Features 🎉
  - Semver-Minor
  - kind/enhancement
- Bug Fix 🐛
  - Semver-Patch
  - kind/bug
- Other changes
  - Everything that has no labels at all

[1] https://github.com/nmstate/nmpolicy/blob/main/.github/release.yml

## Tagging

- [ ] Tag new release in git.
```bash
# Make sure your local git repo is sync with upstream.
# The whole version string should log like `v0.1.0`.
# For the commit message use the following format: `nmpolicy 0.1.0 release`.
git tag --sign v<version>
git push upstream --tags
```

- [ ] In case there is a need to remove a tag:
```bash
# Remove local tag
git tag -d <tag_name>

# Remove upstream tag
git push --delete upstream <tag_name>
```

## GitHub Release

The release is fully automated and appear after pushing a proper semVer tag.
