/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package anagofakes

import (
	"sync"

	"github.com/blang/semver"
	"k8s.io/release/pkg/build"
	"k8s.io/release/pkg/changelog"
	"k8s.io/release/pkg/gcp/gcb"
	"k8s.io/release/pkg/git"
	"k8s.io/release/pkg/release"
)

type FakeStageImpl struct {
	BranchNeedsCreationStub        func(string, string, semver.Version) (bool, error)
	branchNeedsCreationMutex       sync.RWMutex
	branchNeedsCreationArgsForCall []struct {
		arg1 string
		arg2 string
		arg3 semver.Version
	}
	branchNeedsCreationReturns struct {
		result1 bool
		result2 error
	}
	branchNeedsCreationReturnsOnCall map[int]struct {
		result1 bool
		result2 error
	}
	CheckPrerequisitesStub        func() error
	checkPrerequisitesMutex       sync.RWMutex
	checkPrerequisitesArgsForCall []struct {
	}
	checkPrerequisitesReturns struct {
		result1 error
	}
	checkPrerequisitesReturnsOnCall map[int]struct {
		result1 error
	}
	CheckReleaseBucketStub        func(*build.Options) error
	checkReleaseBucketMutex       sync.RWMutex
	checkReleaseBucketArgsForCall []struct {
		arg1 *build.Options
	}
	checkReleaseBucketReturns struct {
		result1 error
	}
	checkReleaseBucketReturnsOnCall map[int]struct {
		result1 error
	}
	CheckoutStub        func(*git.Repo, string, ...string) error
	checkoutMutex       sync.RWMutex
	checkoutArgsForCall []struct {
		arg1 *git.Repo
		arg2 string
		arg3 []string
	}
	checkoutReturns struct {
		result1 error
	}
	checkoutReturnsOnCall map[int]struct {
		result1 error
	}
	CommitEmptyStub        func(*git.Repo, string) error
	commitEmptyMutex       sync.RWMutex
	commitEmptyArgsForCall []struct {
		arg1 *git.Repo
		arg2 string
	}
	commitEmptyReturns struct {
		result1 error
	}
	commitEmptyReturnsOnCall map[int]struct {
		result1 error
	}
	CurrentBranchStub        func(*git.Repo) (string, error)
	currentBranchMutex       sync.RWMutex
	currentBranchArgsForCall []struct {
		arg1 *git.Repo
	}
	currentBranchReturns struct {
		result1 string
		result2 error
	}
	currentBranchReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	DockerHubLoginStub        func() error
	dockerHubLoginMutex       sync.RWMutex
	dockerHubLoginArgsForCall []struct {
	}
	dockerHubLoginReturns struct {
		result1 error
	}
	dockerHubLoginReturnsOnCall map[int]struct {
		result1 error
	}
	GenerateChangelogStub        func(*changelog.Options) error
	generateChangelogMutex       sync.RWMutex
	generateChangelogArgsForCall []struct {
		arg1 *changelog.Options
	}
	generateChangelogReturns struct {
		result1 error
	}
	generateChangelogReturnsOnCall map[int]struct {
		result1 error
	}
	GenerateReleaseVersionStub        func(string, string, string, bool) (*release.Versions, error)
	generateReleaseVersionMutex       sync.RWMutex
	generateReleaseVersionArgsForCall []struct {
		arg1 string
		arg2 string
		arg3 string
		arg4 bool
	}
	generateReleaseVersionReturns struct {
		result1 *release.Versions
		result2 error
	}
	generateReleaseVersionReturnsOnCall map[int]struct {
		result1 *release.Versions
		result2 error
	}
	MakeCrossStub        func(string) error
	makeCrossMutex       sync.RWMutex
	makeCrossArgsForCall []struct {
		arg1 string
	}
	makeCrossReturns struct {
		result1 error
	}
	makeCrossReturnsOnCall map[int]struct {
		result1 error
	}
	OpenRepoStub        func(string) (*git.Repo, error)
	openRepoMutex       sync.RWMutex
	openRepoArgsForCall []struct {
		arg1 string
	}
	openRepoReturns struct {
		result1 *git.Repo
		result2 error
	}
	openRepoReturnsOnCall map[int]struct {
		result1 *git.Repo
		result2 error
	}
	PrepareWorkspaceStageStub        func() error
	prepareWorkspaceStageMutex       sync.RWMutex
	prepareWorkspaceStageArgsForCall []struct {
	}
	prepareWorkspaceStageReturns struct {
		result1 error
	}
	prepareWorkspaceStageReturnsOnCall map[int]struct {
		result1 error
	}
	PushContainerImagesStub        func(*build.Options) error
	pushContainerImagesMutex       sync.RWMutex
	pushContainerImagesArgsForCall []struct {
		arg1 *build.Options
	}
	pushContainerImagesReturns struct {
		result1 error
	}
	pushContainerImagesReturnsOnCall map[int]struct {
		result1 error
	}
	PushReleaseArtifactsStub        func(*build.Options, string, string) error
	pushReleaseArtifactsMutex       sync.RWMutex
	pushReleaseArtifactsArgsForCall []struct {
		arg1 *build.Options
		arg2 string
		arg3 string
	}
	pushReleaseArtifactsReturns struct {
		result1 error
	}
	pushReleaseArtifactsReturnsOnCall map[int]struct {
		result1 error
	}
	RevParseStub        func(*git.Repo, string) (string, error)
	revParseMutex       sync.RWMutex
	revParseArgsForCall []struct {
		arg1 *git.Repo
		arg2 string
	}
	revParseReturns struct {
		result1 string
		result2 error
	}
	revParseReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	RevParseTagStub        func(*git.Repo, string) (string, error)
	revParseTagMutex       sync.RWMutex
	revParseTagArgsForCall []struct {
		arg1 *git.Repo
		arg2 string
	}
	revParseTagReturns struct {
		result1 string
		result2 error
	}
	revParseTagReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	StageLocalArtifactsStub        func(*build.Options) error
	stageLocalArtifactsMutex       sync.RWMutex
	stageLocalArtifactsArgsForCall []struct {
		arg1 *build.Options
	}
	stageLocalArtifactsReturns struct {
		result1 error
	}
	stageLocalArtifactsReturnsOnCall map[int]struct {
		result1 error
	}
	StageLocalSourceTreeStub        func(*build.Options, string, string) error
	stageLocalSourceTreeMutex       sync.RWMutex
	stageLocalSourceTreeArgsForCall []struct {
		arg1 *build.Options
		arg2 string
		arg3 string
	}
	stageLocalSourceTreeReturns struct {
		result1 error
	}
	stageLocalSourceTreeReturnsOnCall map[int]struct {
		result1 error
	}
	SubmitStub        func(*gcb.Options) error
	submitMutex       sync.RWMutex
	submitArgsForCall []struct {
		arg1 *gcb.Options
	}
	submitReturns struct {
		result1 error
	}
	submitReturnsOnCall map[int]struct {
		result1 error
	}
	TagStub        func(*git.Repo, string, string) error
	tagMutex       sync.RWMutex
	tagArgsForCall []struct {
		arg1 *git.Repo
		arg2 string
		arg3 string
	}
	tagReturns struct {
		result1 error
	}
	tagReturnsOnCall map[int]struct {
		result1 error
	}
	ToFileStub        func(string) error
	toFileMutex       sync.RWMutex
	toFileArgsForCall []struct {
		arg1 string
	}
	toFileReturns struct {
		result1 error
	}
	toFileReturnsOnCall map[int]struct {
		result1 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeStageImpl) BranchNeedsCreation(arg1 string, arg2 string, arg3 semver.Version) (bool, error) {
	fake.branchNeedsCreationMutex.Lock()
	ret, specificReturn := fake.branchNeedsCreationReturnsOnCall[len(fake.branchNeedsCreationArgsForCall)]
	fake.branchNeedsCreationArgsForCall = append(fake.branchNeedsCreationArgsForCall, struct {
		arg1 string
		arg2 string
		arg3 semver.Version
	}{arg1, arg2, arg3})
	stub := fake.BranchNeedsCreationStub
	fakeReturns := fake.branchNeedsCreationReturns
	fake.recordInvocation("BranchNeedsCreation", []interface{}{arg1, arg2, arg3})
	fake.branchNeedsCreationMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) BranchNeedsCreationCallCount() int {
	fake.branchNeedsCreationMutex.RLock()
	defer fake.branchNeedsCreationMutex.RUnlock()
	return len(fake.branchNeedsCreationArgsForCall)
}

func (fake *FakeStageImpl) BranchNeedsCreationCalls(stub func(string, string, semver.Version) (bool, error)) {
	fake.branchNeedsCreationMutex.Lock()
	defer fake.branchNeedsCreationMutex.Unlock()
	fake.BranchNeedsCreationStub = stub
}

func (fake *FakeStageImpl) BranchNeedsCreationArgsForCall(i int) (string, string, semver.Version) {
	fake.branchNeedsCreationMutex.RLock()
	defer fake.branchNeedsCreationMutex.RUnlock()
	argsForCall := fake.branchNeedsCreationArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeStageImpl) BranchNeedsCreationReturns(result1 bool, result2 error) {
	fake.branchNeedsCreationMutex.Lock()
	defer fake.branchNeedsCreationMutex.Unlock()
	fake.BranchNeedsCreationStub = nil
	fake.branchNeedsCreationReturns = struct {
		result1 bool
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) BranchNeedsCreationReturnsOnCall(i int, result1 bool, result2 error) {
	fake.branchNeedsCreationMutex.Lock()
	defer fake.branchNeedsCreationMutex.Unlock()
	fake.BranchNeedsCreationStub = nil
	if fake.branchNeedsCreationReturnsOnCall == nil {
		fake.branchNeedsCreationReturnsOnCall = make(map[int]struct {
			result1 bool
			result2 error
		})
	}
	fake.branchNeedsCreationReturnsOnCall[i] = struct {
		result1 bool
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) CheckPrerequisites() error {
	fake.checkPrerequisitesMutex.Lock()
	ret, specificReturn := fake.checkPrerequisitesReturnsOnCall[len(fake.checkPrerequisitesArgsForCall)]
	fake.checkPrerequisitesArgsForCall = append(fake.checkPrerequisitesArgsForCall, struct {
	}{})
	stub := fake.CheckPrerequisitesStub
	fakeReturns := fake.checkPrerequisitesReturns
	fake.recordInvocation("CheckPrerequisites", []interface{}{})
	fake.checkPrerequisitesMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) CheckPrerequisitesCallCount() int {
	fake.checkPrerequisitesMutex.RLock()
	defer fake.checkPrerequisitesMutex.RUnlock()
	return len(fake.checkPrerequisitesArgsForCall)
}

func (fake *FakeStageImpl) CheckPrerequisitesCalls(stub func() error) {
	fake.checkPrerequisitesMutex.Lock()
	defer fake.checkPrerequisitesMutex.Unlock()
	fake.CheckPrerequisitesStub = stub
}

func (fake *FakeStageImpl) CheckPrerequisitesReturns(result1 error) {
	fake.checkPrerequisitesMutex.Lock()
	defer fake.checkPrerequisitesMutex.Unlock()
	fake.CheckPrerequisitesStub = nil
	fake.checkPrerequisitesReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) CheckPrerequisitesReturnsOnCall(i int, result1 error) {
	fake.checkPrerequisitesMutex.Lock()
	defer fake.checkPrerequisitesMutex.Unlock()
	fake.CheckPrerequisitesStub = nil
	if fake.checkPrerequisitesReturnsOnCall == nil {
		fake.checkPrerequisitesReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.checkPrerequisitesReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) CheckReleaseBucket(arg1 *build.Options) error {
	fake.checkReleaseBucketMutex.Lock()
	ret, specificReturn := fake.checkReleaseBucketReturnsOnCall[len(fake.checkReleaseBucketArgsForCall)]
	fake.checkReleaseBucketArgsForCall = append(fake.checkReleaseBucketArgsForCall, struct {
		arg1 *build.Options
	}{arg1})
	stub := fake.CheckReleaseBucketStub
	fakeReturns := fake.checkReleaseBucketReturns
	fake.recordInvocation("CheckReleaseBucket", []interface{}{arg1})
	fake.checkReleaseBucketMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) CheckReleaseBucketCallCount() int {
	fake.checkReleaseBucketMutex.RLock()
	defer fake.checkReleaseBucketMutex.RUnlock()
	return len(fake.checkReleaseBucketArgsForCall)
}

func (fake *FakeStageImpl) CheckReleaseBucketCalls(stub func(*build.Options) error) {
	fake.checkReleaseBucketMutex.Lock()
	defer fake.checkReleaseBucketMutex.Unlock()
	fake.CheckReleaseBucketStub = stub
}

func (fake *FakeStageImpl) CheckReleaseBucketArgsForCall(i int) *build.Options {
	fake.checkReleaseBucketMutex.RLock()
	defer fake.checkReleaseBucketMutex.RUnlock()
	argsForCall := fake.checkReleaseBucketArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) CheckReleaseBucketReturns(result1 error) {
	fake.checkReleaseBucketMutex.Lock()
	defer fake.checkReleaseBucketMutex.Unlock()
	fake.CheckReleaseBucketStub = nil
	fake.checkReleaseBucketReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) CheckReleaseBucketReturnsOnCall(i int, result1 error) {
	fake.checkReleaseBucketMutex.Lock()
	defer fake.checkReleaseBucketMutex.Unlock()
	fake.CheckReleaseBucketStub = nil
	if fake.checkReleaseBucketReturnsOnCall == nil {
		fake.checkReleaseBucketReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.checkReleaseBucketReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) Checkout(arg1 *git.Repo, arg2 string, arg3 ...string) error {
	fake.checkoutMutex.Lock()
	ret, specificReturn := fake.checkoutReturnsOnCall[len(fake.checkoutArgsForCall)]
	fake.checkoutArgsForCall = append(fake.checkoutArgsForCall, struct {
		arg1 *git.Repo
		arg2 string
		arg3 []string
	}{arg1, arg2, arg3})
	stub := fake.CheckoutStub
	fakeReturns := fake.checkoutReturns
	fake.recordInvocation("Checkout", []interface{}{arg1, arg2, arg3})
	fake.checkoutMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3...)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) CheckoutCallCount() int {
	fake.checkoutMutex.RLock()
	defer fake.checkoutMutex.RUnlock()
	return len(fake.checkoutArgsForCall)
}

func (fake *FakeStageImpl) CheckoutCalls(stub func(*git.Repo, string, ...string) error) {
	fake.checkoutMutex.Lock()
	defer fake.checkoutMutex.Unlock()
	fake.CheckoutStub = stub
}

func (fake *FakeStageImpl) CheckoutArgsForCall(i int) (*git.Repo, string, []string) {
	fake.checkoutMutex.RLock()
	defer fake.checkoutMutex.RUnlock()
	argsForCall := fake.checkoutArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeStageImpl) CheckoutReturns(result1 error) {
	fake.checkoutMutex.Lock()
	defer fake.checkoutMutex.Unlock()
	fake.CheckoutStub = nil
	fake.checkoutReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) CheckoutReturnsOnCall(i int, result1 error) {
	fake.checkoutMutex.Lock()
	defer fake.checkoutMutex.Unlock()
	fake.CheckoutStub = nil
	if fake.checkoutReturnsOnCall == nil {
		fake.checkoutReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.checkoutReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) CommitEmpty(arg1 *git.Repo, arg2 string) error {
	fake.commitEmptyMutex.Lock()
	ret, specificReturn := fake.commitEmptyReturnsOnCall[len(fake.commitEmptyArgsForCall)]
	fake.commitEmptyArgsForCall = append(fake.commitEmptyArgsForCall, struct {
		arg1 *git.Repo
		arg2 string
	}{arg1, arg2})
	stub := fake.CommitEmptyStub
	fakeReturns := fake.commitEmptyReturns
	fake.recordInvocation("CommitEmpty", []interface{}{arg1, arg2})
	fake.commitEmptyMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) CommitEmptyCallCount() int {
	fake.commitEmptyMutex.RLock()
	defer fake.commitEmptyMutex.RUnlock()
	return len(fake.commitEmptyArgsForCall)
}

func (fake *FakeStageImpl) CommitEmptyCalls(stub func(*git.Repo, string) error) {
	fake.commitEmptyMutex.Lock()
	defer fake.commitEmptyMutex.Unlock()
	fake.CommitEmptyStub = stub
}

func (fake *FakeStageImpl) CommitEmptyArgsForCall(i int) (*git.Repo, string) {
	fake.commitEmptyMutex.RLock()
	defer fake.commitEmptyMutex.RUnlock()
	argsForCall := fake.commitEmptyArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeStageImpl) CommitEmptyReturns(result1 error) {
	fake.commitEmptyMutex.Lock()
	defer fake.commitEmptyMutex.Unlock()
	fake.CommitEmptyStub = nil
	fake.commitEmptyReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) CommitEmptyReturnsOnCall(i int, result1 error) {
	fake.commitEmptyMutex.Lock()
	defer fake.commitEmptyMutex.Unlock()
	fake.CommitEmptyStub = nil
	if fake.commitEmptyReturnsOnCall == nil {
		fake.commitEmptyReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.commitEmptyReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) CurrentBranch(arg1 *git.Repo) (string, error) {
	fake.currentBranchMutex.Lock()
	ret, specificReturn := fake.currentBranchReturnsOnCall[len(fake.currentBranchArgsForCall)]
	fake.currentBranchArgsForCall = append(fake.currentBranchArgsForCall, struct {
		arg1 *git.Repo
	}{arg1})
	stub := fake.CurrentBranchStub
	fakeReturns := fake.currentBranchReturns
	fake.recordInvocation("CurrentBranch", []interface{}{arg1})
	fake.currentBranchMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) CurrentBranchCallCount() int {
	fake.currentBranchMutex.RLock()
	defer fake.currentBranchMutex.RUnlock()
	return len(fake.currentBranchArgsForCall)
}

func (fake *FakeStageImpl) CurrentBranchCalls(stub func(*git.Repo) (string, error)) {
	fake.currentBranchMutex.Lock()
	defer fake.currentBranchMutex.Unlock()
	fake.CurrentBranchStub = stub
}

func (fake *FakeStageImpl) CurrentBranchArgsForCall(i int) *git.Repo {
	fake.currentBranchMutex.RLock()
	defer fake.currentBranchMutex.RUnlock()
	argsForCall := fake.currentBranchArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) CurrentBranchReturns(result1 string, result2 error) {
	fake.currentBranchMutex.Lock()
	defer fake.currentBranchMutex.Unlock()
	fake.CurrentBranchStub = nil
	fake.currentBranchReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) CurrentBranchReturnsOnCall(i int, result1 string, result2 error) {
	fake.currentBranchMutex.Lock()
	defer fake.currentBranchMutex.Unlock()
	fake.CurrentBranchStub = nil
	if fake.currentBranchReturnsOnCall == nil {
		fake.currentBranchReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.currentBranchReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) DockerHubLogin() error {
	fake.dockerHubLoginMutex.Lock()
	ret, specificReturn := fake.dockerHubLoginReturnsOnCall[len(fake.dockerHubLoginArgsForCall)]
	fake.dockerHubLoginArgsForCall = append(fake.dockerHubLoginArgsForCall, struct {
	}{})
	stub := fake.DockerHubLoginStub
	fakeReturns := fake.dockerHubLoginReturns
	fake.recordInvocation("DockerHubLogin", []interface{}{})
	fake.dockerHubLoginMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) DockerHubLoginCallCount() int {
	fake.dockerHubLoginMutex.RLock()
	defer fake.dockerHubLoginMutex.RUnlock()
	return len(fake.dockerHubLoginArgsForCall)
}

func (fake *FakeStageImpl) DockerHubLoginCalls(stub func() error) {
	fake.dockerHubLoginMutex.Lock()
	defer fake.dockerHubLoginMutex.Unlock()
	fake.DockerHubLoginStub = stub
}

func (fake *FakeStageImpl) DockerHubLoginReturns(result1 error) {
	fake.dockerHubLoginMutex.Lock()
	defer fake.dockerHubLoginMutex.Unlock()
	fake.DockerHubLoginStub = nil
	fake.dockerHubLoginReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) DockerHubLoginReturnsOnCall(i int, result1 error) {
	fake.dockerHubLoginMutex.Lock()
	defer fake.dockerHubLoginMutex.Unlock()
	fake.DockerHubLoginStub = nil
	if fake.dockerHubLoginReturnsOnCall == nil {
		fake.dockerHubLoginReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.dockerHubLoginReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) GenerateChangelog(arg1 *changelog.Options) error {
	fake.generateChangelogMutex.Lock()
	ret, specificReturn := fake.generateChangelogReturnsOnCall[len(fake.generateChangelogArgsForCall)]
	fake.generateChangelogArgsForCall = append(fake.generateChangelogArgsForCall, struct {
		arg1 *changelog.Options
	}{arg1})
	stub := fake.GenerateChangelogStub
	fakeReturns := fake.generateChangelogReturns
	fake.recordInvocation("GenerateChangelog", []interface{}{arg1})
	fake.generateChangelogMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) GenerateChangelogCallCount() int {
	fake.generateChangelogMutex.RLock()
	defer fake.generateChangelogMutex.RUnlock()
	return len(fake.generateChangelogArgsForCall)
}

func (fake *FakeStageImpl) GenerateChangelogCalls(stub func(*changelog.Options) error) {
	fake.generateChangelogMutex.Lock()
	defer fake.generateChangelogMutex.Unlock()
	fake.GenerateChangelogStub = stub
}

func (fake *FakeStageImpl) GenerateChangelogArgsForCall(i int) *changelog.Options {
	fake.generateChangelogMutex.RLock()
	defer fake.generateChangelogMutex.RUnlock()
	argsForCall := fake.generateChangelogArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) GenerateChangelogReturns(result1 error) {
	fake.generateChangelogMutex.Lock()
	defer fake.generateChangelogMutex.Unlock()
	fake.GenerateChangelogStub = nil
	fake.generateChangelogReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) GenerateChangelogReturnsOnCall(i int, result1 error) {
	fake.generateChangelogMutex.Lock()
	defer fake.generateChangelogMutex.Unlock()
	fake.GenerateChangelogStub = nil
	if fake.generateChangelogReturnsOnCall == nil {
		fake.generateChangelogReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.generateChangelogReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) GenerateReleaseVersion(arg1 string, arg2 string, arg3 string, arg4 bool) (*release.Versions, error) {
	fake.generateReleaseVersionMutex.Lock()
	ret, specificReturn := fake.generateReleaseVersionReturnsOnCall[len(fake.generateReleaseVersionArgsForCall)]
	fake.generateReleaseVersionArgsForCall = append(fake.generateReleaseVersionArgsForCall, struct {
		arg1 string
		arg2 string
		arg3 string
		arg4 bool
	}{arg1, arg2, arg3, arg4})
	stub := fake.GenerateReleaseVersionStub
	fakeReturns := fake.generateReleaseVersionReturns
	fake.recordInvocation("GenerateReleaseVersion", []interface{}{arg1, arg2, arg3, arg4})
	fake.generateReleaseVersionMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3, arg4)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) GenerateReleaseVersionCallCount() int {
	fake.generateReleaseVersionMutex.RLock()
	defer fake.generateReleaseVersionMutex.RUnlock()
	return len(fake.generateReleaseVersionArgsForCall)
}

func (fake *FakeStageImpl) GenerateReleaseVersionCalls(stub func(string, string, string, bool) (*release.Versions, error)) {
	fake.generateReleaseVersionMutex.Lock()
	defer fake.generateReleaseVersionMutex.Unlock()
	fake.GenerateReleaseVersionStub = stub
}

func (fake *FakeStageImpl) GenerateReleaseVersionArgsForCall(i int) (string, string, string, bool) {
	fake.generateReleaseVersionMutex.RLock()
	defer fake.generateReleaseVersionMutex.RUnlock()
	argsForCall := fake.generateReleaseVersionArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3, argsForCall.arg4
}

func (fake *FakeStageImpl) GenerateReleaseVersionReturns(result1 *release.Versions, result2 error) {
	fake.generateReleaseVersionMutex.Lock()
	defer fake.generateReleaseVersionMutex.Unlock()
	fake.GenerateReleaseVersionStub = nil
	fake.generateReleaseVersionReturns = struct {
		result1 *release.Versions
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) GenerateReleaseVersionReturnsOnCall(i int, result1 *release.Versions, result2 error) {
	fake.generateReleaseVersionMutex.Lock()
	defer fake.generateReleaseVersionMutex.Unlock()
	fake.GenerateReleaseVersionStub = nil
	if fake.generateReleaseVersionReturnsOnCall == nil {
		fake.generateReleaseVersionReturnsOnCall = make(map[int]struct {
			result1 *release.Versions
			result2 error
		})
	}
	fake.generateReleaseVersionReturnsOnCall[i] = struct {
		result1 *release.Versions
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) MakeCross(arg1 string) error {
	fake.makeCrossMutex.Lock()
	ret, specificReturn := fake.makeCrossReturnsOnCall[len(fake.makeCrossArgsForCall)]
	fake.makeCrossArgsForCall = append(fake.makeCrossArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.MakeCrossStub
	fakeReturns := fake.makeCrossReturns
	fake.recordInvocation("MakeCross", []interface{}{arg1})
	fake.makeCrossMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) MakeCrossCallCount() int {
	fake.makeCrossMutex.RLock()
	defer fake.makeCrossMutex.RUnlock()
	return len(fake.makeCrossArgsForCall)
}

func (fake *FakeStageImpl) MakeCrossCalls(stub func(string) error) {
	fake.makeCrossMutex.Lock()
	defer fake.makeCrossMutex.Unlock()
	fake.MakeCrossStub = stub
}

func (fake *FakeStageImpl) MakeCrossArgsForCall(i int) string {
	fake.makeCrossMutex.RLock()
	defer fake.makeCrossMutex.RUnlock()
	argsForCall := fake.makeCrossArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) MakeCrossReturns(result1 error) {
	fake.makeCrossMutex.Lock()
	defer fake.makeCrossMutex.Unlock()
	fake.MakeCrossStub = nil
	fake.makeCrossReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) MakeCrossReturnsOnCall(i int, result1 error) {
	fake.makeCrossMutex.Lock()
	defer fake.makeCrossMutex.Unlock()
	fake.MakeCrossStub = nil
	if fake.makeCrossReturnsOnCall == nil {
		fake.makeCrossReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.makeCrossReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) OpenRepo(arg1 string) (*git.Repo, error) {
	fake.openRepoMutex.Lock()
	ret, specificReturn := fake.openRepoReturnsOnCall[len(fake.openRepoArgsForCall)]
	fake.openRepoArgsForCall = append(fake.openRepoArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.OpenRepoStub
	fakeReturns := fake.openRepoReturns
	fake.recordInvocation("OpenRepo", []interface{}{arg1})
	fake.openRepoMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) OpenRepoCallCount() int {
	fake.openRepoMutex.RLock()
	defer fake.openRepoMutex.RUnlock()
	return len(fake.openRepoArgsForCall)
}

func (fake *FakeStageImpl) OpenRepoCalls(stub func(string) (*git.Repo, error)) {
	fake.openRepoMutex.Lock()
	defer fake.openRepoMutex.Unlock()
	fake.OpenRepoStub = stub
}

func (fake *FakeStageImpl) OpenRepoArgsForCall(i int) string {
	fake.openRepoMutex.RLock()
	defer fake.openRepoMutex.RUnlock()
	argsForCall := fake.openRepoArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) OpenRepoReturns(result1 *git.Repo, result2 error) {
	fake.openRepoMutex.Lock()
	defer fake.openRepoMutex.Unlock()
	fake.OpenRepoStub = nil
	fake.openRepoReturns = struct {
		result1 *git.Repo
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) OpenRepoReturnsOnCall(i int, result1 *git.Repo, result2 error) {
	fake.openRepoMutex.Lock()
	defer fake.openRepoMutex.Unlock()
	fake.OpenRepoStub = nil
	if fake.openRepoReturnsOnCall == nil {
		fake.openRepoReturnsOnCall = make(map[int]struct {
			result1 *git.Repo
			result2 error
		})
	}
	fake.openRepoReturnsOnCall[i] = struct {
		result1 *git.Repo
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) PrepareWorkspaceStage() error {
	fake.prepareWorkspaceStageMutex.Lock()
	ret, specificReturn := fake.prepareWorkspaceStageReturnsOnCall[len(fake.prepareWorkspaceStageArgsForCall)]
	fake.prepareWorkspaceStageArgsForCall = append(fake.prepareWorkspaceStageArgsForCall, struct {
	}{})
	stub := fake.PrepareWorkspaceStageStub
	fakeReturns := fake.prepareWorkspaceStageReturns
	fake.recordInvocation("PrepareWorkspaceStage", []interface{}{})
	fake.prepareWorkspaceStageMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) PrepareWorkspaceStageCallCount() int {
	fake.prepareWorkspaceStageMutex.RLock()
	defer fake.prepareWorkspaceStageMutex.RUnlock()
	return len(fake.prepareWorkspaceStageArgsForCall)
}

func (fake *FakeStageImpl) PrepareWorkspaceStageCalls(stub func() error) {
	fake.prepareWorkspaceStageMutex.Lock()
	defer fake.prepareWorkspaceStageMutex.Unlock()
	fake.PrepareWorkspaceStageStub = stub
}

func (fake *FakeStageImpl) PrepareWorkspaceStageReturns(result1 error) {
	fake.prepareWorkspaceStageMutex.Lock()
	defer fake.prepareWorkspaceStageMutex.Unlock()
	fake.PrepareWorkspaceStageStub = nil
	fake.prepareWorkspaceStageReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) PrepareWorkspaceStageReturnsOnCall(i int, result1 error) {
	fake.prepareWorkspaceStageMutex.Lock()
	defer fake.prepareWorkspaceStageMutex.Unlock()
	fake.PrepareWorkspaceStageStub = nil
	if fake.prepareWorkspaceStageReturnsOnCall == nil {
		fake.prepareWorkspaceStageReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.prepareWorkspaceStageReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) PushContainerImages(arg1 *build.Options) error {
	fake.pushContainerImagesMutex.Lock()
	ret, specificReturn := fake.pushContainerImagesReturnsOnCall[len(fake.pushContainerImagesArgsForCall)]
	fake.pushContainerImagesArgsForCall = append(fake.pushContainerImagesArgsForCall, struct {
		arg1 *build.Options
	}{arg1})
	stub := fake.PushContainerImagesStub
	fakeReturns := fake.pushContainerImagesReturns
	fake.recordInvocation("PushContainerImages", []interface{}{arg1})
	fake.pushContainerImagesMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) PushContainerImagesCallCount() int {
	fake.pushContainerImagesMutex.RLock()
	defer fake.pushContainerImagesMutex.RUnlock()
	return len(fake.pushContainerImagesArgsForCall)
}

func (fake *FakeStageImpl) PushContainerImagesCalls(stub func(*build.Options) error) {
	fake.pushContainerImagesMutex.Lock()
	defer fake.pushContainerImagesMutex.Unlock()
	fake.PushContainerImagesStub = stub
}

func (fake *FakeStageImpl) PushContainerImagesArgsForCall(i int) *build.Options {
	fake.pushContainerImagesMutex.RLock()
	defer fake.pushContainerImagesMutex.RUnlock()
	argsForCall := fake.pushContainerImagesArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) PushContainerImagesReturns(result1 error) {
	fake.pushContainerImagesMutex.Lock()
	defer fake.pushContainerImagesMutex.Unlock()
	fake.PushContainerImagesStub = nil
	fake.pushContainerImagesReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) PushContainerImagesReturnsOnCall(i int, result1 error) {
	fake.pushContainerImagesMutex.Lock()
	defer fake.pushContainerImagesMutex.Unlock()
	fake.PushContainerImagesStub = nil
	if fake.pushContainerImagesReturnsOnCall == nil {
		fake.pushContainerImagesReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.pushContainerImagesReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) PushReleaseArtifacts(arg1 *build.Options, arg2 string, arg3 string) error {
	fake.pushReleaseArtifactsMutex.Lock()
	ret, specificReturn := fake.pushReleaseArtifactsReturnsOnCall[len(fake.pushReleaseArtifactsArgsForCall)]
	fake.pushReleaseArtifactsArgsForCall = append(fake.pushReleaseArtifactsArgsForCall, struct {
		arg1 *build.Options
		arg2 string
		arg3 string
	}{arg1, arg2, arg3})
	stub := fake.PushReleaseArtifactsStub
	fakeReturns := fake.pushReleaseArtifactsReturns
	fake.recordInvocation("PushReleaseArtifacts", []interface{}{arg1, arg2, arg3})
	fake.pushReleaseArtifactsMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) PushReleaseArtifactsCallCount() int {
	fake.pushReleaseArtifactsMutex.RLock()
	defer fake.pushReleaseArtifactsMutex.RUnlock()
	return len(fake.pushReleaseArtifactsArgsForCall)
}

func (fake *FakeStageImpl) PushReleaseArtifactsCalls(stub func(*build.Options, string, string) error) {
	fake.pushReleaseArtifactsMutex.Lock()
	defer fake.pushReleaseArtifactsMutex.Unlock()
	fake.PushReleaseArtifactsStub = stub
}

func (fake *FakeStageImpl) PushReleaseArtifactsArgsForCall(i int) (*build.Options, string, string) {
	fake.pushReleaseArtifactsMutex.RLock()
	defer fake.pushReleaseArtifactsMutex.RUnlock()
	argsForCall := fake.pushReleaseArtifactsArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeStageImpl) PushReleaseArtifactsReturns(result1 error) {
	fake.pushReleaseArtifactsMutex.Lock()
	defer fake.pushReleaseArtifactsMutex.Unlock()
	fake.PushReleaseArtifactsStub = nil
	fake.pushReleaseArtifactsReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) PushReleaseArtifactsReturnsOnCall(i int, result1 error) {
	fake.pushReleaseArtifactsMutex.Lock()
	defer fake.pushReleaseArtifactsMutex.Unlock()
	fake.PushReleaseArtifactsStub = nil
	if fake.pushReleaseArtifactsReturnsOnCall == nil {
		fake.pushReleaseArtifactsReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.pushReleaseArtifactsReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) RevParse(arg1 *git.Repo, arg2 string) (string, error) {
	fake.revParseMutex.Lock()
	ret, specificReturn := fake.revParseReturnsOnCall[len(fake.revParseArgsForCall)]
	fake.revParseArgsForCall = append(fake.revParseArgsForCall, struct {
		arg1 *git.Repo
		arg2 string
	}{arg1, arg2})
	stub := fake.RevParseStub
	fakeReturns := fake.revParseReturns
	fake.recordInvocation("RevParse", []interface{}{arg1, arg2})
	fake.revParseMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) RevParseCallCount() int {
	fake.revParseMutex.RLock()
	defer fake.revParseMutex.RUnlock()
	return len(fake.revParseArgsForCall)
}

func (fake *FakeStageImpl) RevParseCalls(stub func(*git.Repo, string) (string, error)) {
	fake.revParseMutex.Lock()
	defer fake.revParseMutex.Unlock()
	fake.RevParseStub = stub
}

func (fake *FakeStageImpl) RevParseArgsForCall(i int) (*git.Repo, string) {
	fake.revParseMutex.RLock()
	defer fake.revParseMutex.RUnlock()
	argsForCall := fake.revParseArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeStageImpl) RevParseReturns(result1 string, result2 error) {
	fake.revParseMutex.Lock()
	defer fake.revParseMutex.Unlock()
	fake.RevParseStub = nil
	fake.revParseReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) RevParseReturnsOnCall(i int, result1 string, result2 error) {
	fake.revParseMutex.Lock()
	defer fake.revParseMutex.Unlock()
	fake.RevParseStub = nil
	if fake.revParseReturnsOnCall == nil {
		fake.revParseReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.revParseReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) RevParseTag(arg1 *git.Repo, arg2 string) (string, error) {
	fake.revParseTagMutex.Lock()
	ret, specificReturn := fake.revParseTagReturnsOnCall[len(fake.revParseTagArgsForCall)]
	fake.revParseTagArgsForCall = append(fake.revParseTagArgsForCall, struct {
		arg1 *git.Repo
		arg2 string
	}{arg1, arg2})
	stub := fake.RevParseTagStub
	fakeReturns := fake.revParseTagReturns
	fake.recordInvocation("RevParseTag", []interface{}{arg1, arg2})
	fake.revParseTagMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeStageImpl) RevParseTagCallCount() int {
	fake.revParseTagMutex.RLock()
	defer fake.revParseTagMutex.RUnlock()
	return len(fake.revParseTagArgsForCall)
}

func (fake *FakeStageImpl) RevParseTagCalls(stub func(*git.Repo, string) (string, error)) {
	fake.revParseTagMutex.Lock()
	defer fake.revParseTagMutex.Unlock()
	fake.RevParseTagStub = stub
}

func (fake *FakeStageImpl) RevParseTagArgsForCall(i int) (*git.Repo, string) {
	fake.revParseTagMutex.RLock()
	defer fake.revParseTagMutex.RUnlock()
	argsForCall := fake.revParseTagArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeStageImpl) RevParseTagReturns(result1 string, result2 error) {
	fake.revParseTagMutex.Lock()
	defer fake.revParseTagMutex.Unlock()
	fake.RevParseTagStub = nil
	fake.revParseTagReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) RevParseTagReturnsOnCall(i int, result1 string, result2 error) {
	fake.revParseTagMutex.Lock()
	defer fake.revParseTagMutex.Unlock()
	fake.RevParseTagStub = nil
	if fake.revParseTagReturnsOnCall == nil {
		fake.revParseTagReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.revParseTagReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeStageImpl) StageLocalArtifacts(arg1 *build.Options) error {
	fake.stageLocalArtifactsMutex.Lock()
	ret, specificReturn := fake.stageLocalArtifactsReturnsOnCall[len(fake.stageLocalArtifactsArgsForCall)]
	fake.stageLocalArtifactsArgsForCall = append(fake.stageLocalArtifactsArgsForCall, struct {
		arg1 *build.Options
	}{arg1})
	stub := fake.StageLocalArtifactsStub
	fakeReturns := fake.stageLocalArtifactsReturns
	fake.recordInvocation("StageLocalArtifacts", []interface{}{arg1})
	fake.stageLocalArtifactsMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) StageLocalArtifactsCallCount() int {
	fake.stageLocalArtifactsMutex.RLock()
	defer fake.stageLocalArtifactsMutex.RUnlock()
	return len(fake.stageLocalArtifactsArgsForCall)
}

func (fake *FakeStageImpl) StageLocalArtifactsCalls(stub func(*build.Options) error) {
	fake.stageLocalArtifactsMutex.Lock()
	defer fake.stageLocalArtifactsMutex.Unlock()
	fake.StageLocalArtifactsStub = stub
}

func (fake *FakeStageImpl) StageLocalArtifactsArgsForCall(i int) *build.Options {
	fake.stageLocalArtifactsMutex.RLock()
	defer fake.stageLocalArtifactsMutex.RUnlock()
	argsForCall := fake.stageLocalArtifactsArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) StageLocalArtifactsReturns(result1 error) {
	fake.stageLocalArtifactsMutex.Lock()
	defer fake.stageLocalArtifactsMutex.Unlock()
	fake.StageLocalArtifactsStub = nil
	fake.stageLocalArtifactsReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) StageLocalArtifactsReturnsOnCall(i int, result1 error) {
	fake.stageLocalArtifactsMutex.Lock()
	defer fake.stageLocalArtifactsMutex.Unlock()
	fake.StageLocalArtifactsStub = nil
	if fake.stageLocalArtifactsReturnsOnCall == nil {
		fake.stageLocalArtifactsReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.stageLocalArtifactsReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) StageLocalSourceTree(arg1 *build.Options, arg2 string, arg3 string) error {
	fake.stageLocalSourceTreeMutex.Lock()
	ret, specificReturn := fake.stageLocalSourceTreeReturnsOnCall[len(fake.stageLocalSourceTreeArgsForCall)]
	fake.stageLocalSourceTreeArgsForCall = append(fake.stageLocalSourceTreeArgsForCall, struct {
		arg1 *build.Options
		arg2 string
		arg3 string
	}{arg1, arg2, arg3})
	stub := fake.StageLocalSourceTreeStub
	fakeReturns := fake.stageLocalSourceTreeReturns
	fake.recordInvocation("StageLocalSourceTree", []interface{}{arg1, arg2, arg3})
	fake.stageLocalSourceTreeMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) StageLocalSourceTreeCallCount() int {
	fake.stageLocalSourceTreeMutex.RLock()
	defer fake.stageLocalSourceTreeMutex.RUnlock()
	return len(fake.stageLocalSourceTreeArgsForCall)
}

func (fake *FakeStageImpl) StageLocalSourceTreeCalls(stub func(*build.Options, string, string) error) {
	fake.stageLocalSourceTreeMutex.Lock()
	defer fake.stageLocalSourceTreeMutex.Unlock()
	fake.StageLocalSourceTreeStub = stub
}

func (fake *FakeStageImpl) StageLocalSourceTreeArgsForCall(i int) (*build.Options, string, string) {
	fake.stageLocalSourceTreeMutex.RLock()
	defer fake.stageLocalSourceTreeMutex.RUnlock()
	argsForCall := fake.stageLocalSourceTreeArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeStageImpl) StageLocalSourceTreeReturns(result1 error) {
	fake.stageLocalSourceTreeMutex.Lock()
	defer fake.stageLocalSourceTreeMutex.Unlock()
	fake.StageLocalSourceTreeStub = nil
	fake.stageLocalSourceTreeReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) StageLocalSourceTreeReturnsOnCall(i int, result1 error) {
	fake.stageLocalSourceTreeMutex.Lock()
	defer fake.stageLocalSourceTreeMutex.Unlock()
	fake.StageLocalSourceTreeStub = nil
	if fake.stageLocalSourceTreeReturnsOnCall == nil {
		fake.stageLocalSourceTreeReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.stageLocalSourceTreeReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) Submit(arg1 *gcb.Options) error {
	fake.submitMutex.Lock()
	ret, specificReturn := fake.submitReturnsOnCall[len(fake.submitArgsForCall)]
	fake.submitArgsForCall = append(fake.submitArgsForCall, struct {
		arg1 *gcb.Options
	}{arg1})
	stub := fake.SubmitStub
	fakeReturns := fake.submitReturns
	fake.recordInvocation("Submit", []interface{}{arg1})
	fake.submitMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) SubmitCallCount() int {
	fake.submitMutex.RLock()
	defer fake.submitMutex.RUnlock()
	return len(fake.submitArgsForCall)
}

func (fake *FakeStageImpl) SubmitCalls(stub func(*gcb.Options) error) {
	fake.submitMutex.Lock()
	defer fake.submitMutex.Unlock()
	fake.SubmitStub = stub
}

func (fake *FakeStageImpl) SubmitArgsForCall(i int) *gcb.Options {
	fake.submitMutex.RLock()
	defer fake.submitMutex.RUnlock()
	argsForCall := fake.submitArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) SubmitReturns(result1 error) {
	fake.submitMutex.Lock()
	defer fake.submitMutex.Unlock()
	fake.SubmitStub = nil
	fake.submitReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) SubmitReturnsOnCall(i int, result1 error) {
	fake.submitMutex.Lock()
	defer fake.submitMutex.Unlock()
	fake.SubmitStub = nil
	if fake.submitReturnsOnCall == nil {
		fake.submitReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.submitReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) Tag(arg1 *git.Repo, arg2 string, arg3 string) error {
	fake.tagMutex.Lock()
	ret, specificReturn := fake.tagReturnsOnCall[len(fake.tagArgsForCall)]
	fake.tagArgsForCall = append(fake.tagArgsForCall, struct {
		arg1 *git.Repo
		arg2 string
		arg3 string
	}{arg1, arg2, arg3})
	stub := fake.TagStub
	fakeReturns := fake.tagReturns
	fake.recordInvocation("Tag", []interface{}{arg1, arg2, arg3})
	fake.tagMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) TagCallCount() int {
	fake.tagMutex.RLock()
	defer fake.tagMutex.RUnlock()
	return len(fake.tagArgsForCall)
}

func (fake *FakeStageImpl) TagCalls(stub func(*git.Repo, string, string) error) {
	fake.tagMutex.Lock()
	defer fake.tagMutex.Unlock()
	fake.TagStub = stub
}

func (fake *FakeStageImpl) TagArgsForCall(i int) (*git.Repo, string, string) {
	fake.tagMutex.RLock()
	defer fake.tagMutex.RUnlock()
	argsForCall := fake.tagArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeStageImpl) TagReturns(result1 error) {
	fake.tagMutex.Lock()
	defer fake.tagMutex.Unlock()
	fake.TagStub = nil
	fake.tagReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) TagReturnsOnCall(i int, result1 error) {
	fake.tagMutex.Lock()
	defer fake.tagMutex.Unlock()
	fake.TagStub = nil
	if fake.tagReturnsOnCall == nil {
		fake.tagReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.tagReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) ToFile(arg1 string) error {
	fake.toFileMutex.Lock()
	ret, specificReturn := fake.toFileReturnsOnCall[len(fake.toFileArgsForCall)]
	fake.toFileArgsForCall = append(fake.toFileArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.ToFileStub
	fakeReturns := fake.toFileReturns
	fake.recordInvocation("ToFile", []interface{}{arg1})
	fake.toFileMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageImpl) ToFileCallCount() int {
	fake.toFileMutex.RLock()
	defer fake.toFileMutex.RUnlock()
	return len(fake.toFileArgsForCall)
}

func (fake *FakeStageImpl) ToFileCalls(stub func(string) error) {
	fake.toFileMutex.Lock()
	defer fake.toFileMutex.Unlock()
	fake.ToFileStub = stub
}

func (fake *FakeStageImpl) ToFileArgsForCall(i int) string {
	fake.toFileMutex.RLock()
	defer fake.toFileMutex.RUnlock()
	argsForCall := fake.toFileArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageImpl) ToFileReturns(result1 error) {
	fake.toFileMutex.Lock()
	defer fake.toFileMutex.Unlock()
	fake.ToFileStub = nil
	fake.toFileReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) ToFileReturnsOnCall(i int, result1 error) {
	fake.toFileMutex.Lock()
	defer fake.toFileMutex.Unlock()
	fake.ToFileStub = nil
	if fake.toFileReturnsOnCall == nil {
		fake.toFileReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.toFileReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageImpl) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.branchNeedsCreationMutex.RLock()
	defer fake.branchNeedsCreationMutex.RUnlock()
	fake.checkPrerequisitesMutex.RLock()
	defer fake.checkPrerequisitesMutex.RUnlock()
	fake.checkReleaseBucketMutex.RLock()
	defer fake.checkReleaseBucketMutex.RUnlock()
	fake.checkoutMutex.RLock()
	defer fake.checkoutMutex.RUnlock()
	fake.commitEmptyMutex.RLock()
	defer fake.commitEmptyMutex.RUnlock()
	fake.currentBranchMutex.RLock()
	defer fake.currentBranchMutex.RUnlock()
	fake.dockerHubLoginMutex.RLock()
	defer fake.dockerHubLoginMutex.RUnlock()
	fake.generateChangelogMutex.RLock()
	defer fake.generateChangelogMutex.RUnlock()
	fake.generateReleaseVersionMutex.RLock()
	defer fake.generateReleaseVersionMutex.RUnlock()
	fake.makeCrossMutex.RLock()
	defer fake.makeCrossMutex.RUnlock()
	fake.openRepoMutex.RLock()
	defer fake.openRepoMutex.RUnlock()
	fake.prepareWorkspaceStageMutex.RLock()
	defer fake.prepareWorkspaceStageMutex.RUnlock()
	fake.pushContainerImagesMutex.RLock()
	defer fake.pushContainerImagesMutex.RUnlock()
	fake.pushReleaseArtifactsMutex.RLock()
	defer fake.pushReleaseArtifactsMutex.RUnlock()
	fake.revParseMutex.RLock()
	defer fake.revParseMutex.RUnlock()
	fake.revParseTagMutex.RLock()
	defer fake.revParseTagMutex.RUnlock()
	fake.stageLocalArtifactsMutex.RLock()
	defer fake.stageLocalArtifactsMutex.RUnlock()
	fake.stageLocalSourceTreeMutex.RLock()
	defer fake.stageLocalSourceTreeMutex.RUnlock()
	fake.submitMutex.RLock()
	defer fake.submitMutex.RUnlock()
	fake.tagMutex.RLock()
	defer fake.tagMutex.RUnlock()
	fake.toFileMutex.RLock()
	defer fake.toFileMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeStageImpl) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}
