/*
Copyright 2020 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package changelogfakes

import (
	"io"
	"io/fs"
	"sync"
	"text/template"

	"github.com/blang/semver"
	"github.com/yuin/goldmark/parser"
	"k8s.io/release/pkg/git"
	"k8s.io/release/pkg/github"
	"k8s.io/release/pkg/notes"
	"k8s.io/release/pkg/notes/document"
	"k8s.io/release/pkg/notes/options"
)

type FakeImpl struct {
	AbsStub        func(string) (string, error)
	absMutex       sync.RWMutex
	absArgsForCall []struct {
		arg1 string
	}
	absReturns struct {
		result1 string
		result2 error
	}
	absReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	AddStub        func(*git.Repo, string) error
	addMutex       sync.RWMutex
	addArgsForCall []struct {
		arg1 *git.Repo
		arg2 string
	}
	addReturns struct {
		result1 error
	}
	addReturnsOnCall map[int]struct {
		result1 error
	}
	CheckoutStub        func(*git.Repo, string, ...string) error
	checkoutMutex       sync.RWMutex
	checkoutArgsForCall []struct {
		arg1 *git.Repo
		arg2 string
		arg3 []string
	}
	checkoutReturns struct {
		result1 error
	}
	checkoutReturnsOnCall map[int]struct {
		result1 error
	}
	CloneCVEDataStub        func() (string, error)
	cloneCVEDataMutex       sync.RWMutex
	cloneCVEDataArgsForCall []struct {
	}
	cloneCVEDataReturns struct {
		result1 string
		result2 error
	}
	cloneCVEDataReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	CommitStub        func(*git.Repo, string) error
	commitMutex       sync.RWMutex
	commitArgsForCall []struct {
		arg1 *git.Repo
		arg2 string
	}
	commitReturns struct {
		result1 error
	}
	commitReturnsOnCall map[int]struct {
		result1 error
	}
	CreateDownloadsTableStub        func(io.Writer, string, string, string, string) error
	createDownloadsTableMutex       sync.RWMutex
	createDownloadsTableArgsForCall []struct {
		arg1 io.Writer
		arg2 string
		arg3 string
		arg4 string
		arg5 string
	}
	createDownloadsTableReturns struct {
		result1 error
	}
	createDownloadsTableReturnsOnCall map[int]struct {
		result1 error
	}
	CurrentBranchStub        func(*git.Repo) (string, error)
	currentBranchMutex       sync.RWMutex
	currentBranchArgsForCall []struct {
		arg1 *git.Repo
	}
	currentBranchReturns struct {
		result1 string
		result2 error
	}
	currentBranchReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	DependencyChangesStub        func(string, string) (string, error)
	dependencyChangesMutex       sync.RWMutex
	dependencyChangesArgsForCall []struct {
		arg1 string
		arg2 string
	}
	dependencyChangesReturns struct {
		result1 string
		result2 error
	}
	dependencyChangesReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	GatherReleaseNotesStub        func(*options.Options) (*notes.ReleaseNotes, error)
	gatherReleaseNotesMutex       sync.RWMutex
	gatherReleaseNotesArgsForCall []struct {
		arg1 *options.Options
	}
	gatherReleaseNotesReturns struct {
		result1 *notes.ReleaseNotes
		result2 error
	}
	gatherReleaseNotesReturnsOnCall map[int]struct {
		result1 *notes.ReleaseNotes
		result2 error
	}
	GenerateTOCStub        func(string) (string, error)
	generateTOCMutex       sync.RWMutex
	generateTOCArgsForCall []struct {
		arg1 string
	}
	generateTOCReturns struct {
		result1 string
		result2 error
	}
	generateTOCReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	GetURLResponseStub        func(string) (string, error)
	getURLResponseMutex       sync.RWMutex
	getURLResponseArgsForCall []struct {
		arg1 string
	}
	getURLResponseReturns struct {
		result1 string
		result2 error
	}
	getURLResponseReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	LatestGitHubTagsPerBranchStub        func() (github.TagsPerBranch, error)
	latestGitHubTagsPerBranchMutex       sync.RWMutex
	latestGitHubTagsPerBranchArgsForCall []struct {
	}
	latestGitHubTagsPerBranchReturns struct {
		result1 github.TagsPerBranch
		result2 error
	}
	latestGitHubTagsPerBranchReturnsOnCall map[int]struct {
		result1 github.TagsPerBranch
		result2 error
	}
	MarkdownToHTMLStub        func(string, io.Writer, ...parser.ParseOption) error
	markdownToHTMLMutex       sync.RWMutex
	markdownToHTMLArgsForCall []struct {
		arg1 string
		arg2 io.Writer
		arg3 []parser.ParseOption
	}
	markdownToHTMLReturns struct {
		result1 error
	}
	markdownToHTMLReturnsOnCall map[int]struct {
		result1 error
	}
	NewDocumentStub        func(*notes.ReleaseNotes, string, string) (*document.Document, error)
	newDocumentMutex       sync.RWMutex
	newDocumentArgsForCall []struct {
		arg1 *notes.ReleaseNotes
		arg2 string
		arg3 string
	}
	newDocumentReturns struct {
		result1 *document.Document
		result2 error
	}
	newDocumentReturnsOnCall map[int]struct {
		result1 *document.Document
		result2 error
	}
	OpenRepoStub        func(string) (*git.Repo, error)
	openRepoMutex       sync.RWMutex
	openRepoArgsForCall []struct {
		arg1 string
	}
	openRepoReturns struct {
		result1 *git.Repo
		result2 error
	}
	openRepoReturnsOnCall map[int]struct {
		result1 *git.Repo
		result2 error
	}
	ParseHTMLTemplateStub        func(string) (*template.Template, error)
	parseHTMLTemplateMutex       sync.RWMutex
	parseHTMLTemplateArgsForCall []struct {
		arg1 string
	}
	parseHTMLTemplateReturns struct {
		result1 *template.Template
		result2 error
	}
	parseHTMLTemplateReturnsOnCall map[int]struct {
		result1 *template.Template
		result2 error
	}
	ReadFileStub        func(string) ([]byte, error)
	readFileMutex       sync.RWMutex
	readFileArgsForCall []struct {
		arg1 string
	}
	readFileReturns struct {
		result1 []byte
		result2 error
	}
	readFileReturnsOnCall map[int]struct {
		result1 []byte
		result2 error
	}
	RenderMarkdownTemplateStub        func(*document.Document, string, string, string) (string, error)
	renderMarkdownTemplateMutex       sync.RWMutex
	renderMarkdownTemplateArgsForCall []struct {
		arg1 *document.Document
		arg2 string
		arg3 string
		arg4 string
	}
	renderMarkdownTemplateReturns struct {
		result1 string
		result2 error
	}
	renderMarkdownTemplateReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	RepoDirStub        func(*git.Repo) string
	repoDirMutex       sync.RWMutex
	repoDirArgsForCall []struct {
		arg1 *git.Repo
	}
	repoDirReturns struct {
		result1 string
	}
	repoDirReturnsOnCall map[int]struct {
		result1 string
	}
	RevParseStub        func(*git.Repo, string) (string, error)
	revParseMutex       sync.RWMutex
	revParseArgsForCall []struct {
		arg1 *git.Repo
		arg2 string
	}
	revParseReturns struct {
		result1 string
		result2 error
	}
	revParseReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	RevParseTagStub        func(*git.Repo, string) (string, error)
	revParseTagMutex       sync.RWMutex
	revParseTagArgsForCall []struct {
		arg1 *git.Repo
		arg2 string
	}
	revParseTagReturns struct {
		result1 string
		result2 error
	}
	revParseTagReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	RmStub        func(*git.Repo, bool, ...string) error
	rmMutex       sync.RWMutex
	rmArgsForCall []struct {
		arg1 *git.Repo
		arg2 bool
		arg3 []string
	}
	rmReturns struct {
		result1 error
	}
	rmReturnsOnCall map[int]struct {
		result1 error
	}
	StatStub        func(string) (fs.FileInfo, error)
	statMutex       sync.RWMutex
	statArgsForCall []struct {
		arg1 string
	}
	statReturns struct {
		result1 fs.FileInfo
		result2 error
	}
	statReturnsOnCall map[int]struct {
		result1 fs.FileInfo
		result2 error
	}
	TagStringToSemverStub        func(string) (semver.Version, error)
	tagStringToSemverMutex       sync.RWMutex
	tagStringToSemverArgsForCall []struct {
		arg1 string
	}
	tagStringToSemverReturns struct {
		result1 semver.Version
		result2 error
	}
	tagStringToSemverReturnsOnCall map[int]struct {
		result1 semver.Version
		result2 error
	}
	TemplateExecuteStub        func(*template.Template, io.Writer, interface{}) error
	templateExecuteMutex       sync.RWMutex
	templateExecuteArgsForCall []struct {
		arg1 *template.Template
		arg2 io.Writer
		arg3 interface{}
	}
	templateExecuteReturns struct {
		result1 error
	}
	templateExecuteReturnsOnCall map[int]struct {
		result1 error
	}
	ValidateAndFinishStub        func(*options.Options) error
	validateAndFinishMutex       sync.RWMutex
	validateAndFinishArgsForCall []struct {
		arg1 *options.Options
	}
	validateAndFinishReturns struct {
		result1 error
	}
	validateAndFinishReturnsOnCall map[int]struct {
		result1 error
	}
	WriteFileStub        func(string, []byte, fs.FileMode) error
	writeFileMutex       sync.RWMutex
	writeFileArgsForCall []struct {
		arg1 string
		arg2 []byte
		arg3 fs.FileMode
	}
	writeFileReturns struct {
		result1 error
	}
	writeFileReturnsOnCall map[int]struct {
		result1 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeImpl) Abs(arg1 string) (string, error) {
	fake.absMutex.Lock()
	ret, specificReturn := fake.absReturnsOnCall[len(fake.absArgsForCall)]
	fake.absArgsForCall = append(fake.absArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.AbsStub
	fakeReturns := fake.absReturns
	fake.recordInvocation("Abs", []interface{}{arg1})
	fake.absMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) AbsCallCount() int {
	fake.absMutex.RLock()
	defer fake.absMutex.RUnlock()
	return len(fake.absArgsForCall)
}

func (fake *FakeImpl) AbsCalls(stub func(string) (string, error)) {
	fake.absMutex.Lock()
	defer fake.absMutex.Unlock()
	fake.AbsStub = stub
}

func (fake *FakeImpl) AbsArgsForCall(i int) string {
	fake.absMutex.RLock()
	defer fake.absMutex.RUnlock()
	argsForCall := fake.absArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeImpl) AbsReturns(result1 string, result2 error) {
	fake.absMutex.Lock()
	defer fake.absMutex.Unlock()
	fake.AbsStub = nil
	fake.absReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) AbsReturnsOnCall(i int, result1 string, result2 error) {
	fake.absMutex.Lock()
	defer fake.absMutex.Unlock()
	fake.AbsStub = nil
	if fake.absReturnsOnCall == nil {
		fake.absReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.absReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) Add(arg1 *git.Repo, arg2 string) error {
	fake.addMutex.Lock()
	ret, specificReturn := fake.addReturnsOnCall[len(fake.addArgsForCall)]
	fake.addArgsForCall = append(fake.addArgsForCall, struct {
		arg1 *git.Repo
		arg2 string
	}{arg1, arg2})
	stub := fake.AddStub
	fakeReturns := fake.addReturns
	fake.recordInvocation("Add", []interface{}{arg1, arg2})
	fake.addMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeImpl) AddCallCount() int {
	fake.addMutex.RLock()
	defer fake.addMutex.RUnlock()
	return len(fake.addArgsForCall)
}

func (fake *FakeImpl) AddCalls(stub func(*git.Repo, string) error) {
	fake.addMutex.Lock()
	defer fake.addMutex.Unlock()
	fake.AddStub = stub
}

func (fake *FakeImpl) AddArgsForCall(i int) (*git.Repo, string) {
	fake.addMutex.RLock()
	defer fake.addMutex.RUnlock()
	argsForCall := fake.addArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeImpl) AddReturns(result1 error) {
	fake.addMutex.Lock()
	defer fake.addMutex.Unlock()
	fake.AddStub = nil
	fake.addReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) AddReturnsOnCall(i int, result1 error) {
	fake.addMutex.Lock()
	defer fake.addMutex.Unlock()
	fake.AddStub = nil
	if fake.addReturnsOnCall == nil {
		fake.addReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.addReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) Checkout(arg1 *git.Repo, arg2 string, arg3 ...string) error {
	fake.checkoutMutex.Lock()
	ret, specificReturn := fake.checkoutReturnsOnCall[len(fake.checkoutArgsForCall)]
	fake.checkoutArgsForCall = append(fake.checkoutArgsForCall, struct {
		arg1 *git.Repo
		arg2 string
		arg3 []string
	}{arg1, arg2, arg3})
	stub := fake.CheckoutStub
	fakeReturns := fake.checkoutReturns
	fake.recordInvocation("Checkout", []interface{}{arg1, arg2, arg3})
	fake.checkoutMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3...)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeImpl) CheckoutCallCount() int {
	fake.checkoutMutex.RLock()
	defer fake.checkoutMutex.RUnlock()
	return len(fake.checkoutArgsForCall)
}

func (fake *FakeImpl) CheckoutCalls(stub func(*git.Repo, string, ...string) error) {
	fake.checkoutMutex.Lock()
	defer fake.checkoutMutex.Unlock()
	fake.CheckoutStub = stub
}

func (fake *FakeImpl) CheckoutArgsForCall(i int) (*git.Repo, string, []string) {
	fake.checkoutMutex.RLock()
	defer fake.checkoutMutex.RUnlock()
	argsForCall := fake.checkoutArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeImpl) CheckoutReturns(result1 error) {
	fake.checkoutMutex.Lock()
	defer fake.checkoutMutex.Unlock()
	fake.CheckoutStub = nil
	fake.checkoutReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) CheckoutReturnsOnCall(i int, result1 error) {
	fake.checkoutMutex.Lock()
	defer fake.checkoutMutex.Unlock()
	fake.CheckoutStub = nil
	if fake.checkoutReturnsOnCall == nil {
		fake.checkoutReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.checkoutReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) CloneCVEData() (string, error) {
	fake.cloneCVEDataMutex.Lock()
	ret, specificReturn := fake.cloneCVEDataReturnsOnCall[len(fake.cloneCVEDataArgsForCall)]
	fake.cloneCVEDataArgsForCall = append(fake.cloneCVEDataArgsForCall, struct {
	}{})
	stub := fake.CloneCVEDataStub
	fakeReturns := fake.cloneCVEDataReturns
	fake.recordInvocation("CloneCVEData", []interface{}{})
	fake.cloneCVEDataMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) CloneCVEDataCallCount() int {
	fake.cloneCVEDataMutex.RLock()
	defer fake.cloneCVEDataMutex.RUnlock()
	return len(fake.cloneCVEDataArgsForCall)
}

func (fake *FakeImpl) CloneCVEDataCalls(stub func() (string, error)) {
	fake.cloneCVEDataMutex.Lock()
	defer fake.cloneCVEDataMutex.Unlock()
	fake.CloneCVEDataStub = stub
}

func (fake *FakeImpl) CloneCVEDataReturns(result1 string, result2 error) {
	fake.cloneCVEDataMutex.Lock()
	defer fake.cloneCVEDataMutex.Unlock()
	fake.CloneCVEDataStub = nil
	fake.cloneCVEDataReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) CloneCVEDataReturnsOnCall(i int, result1 string, result2 error) {
	fake.cloneCVEDataMutex.Lock()
	defer fake.cloneCVEDataMutex.Unlock()
	fake.CloneCVEDataStub = nil
	if fake.cloneCVEDataReturnsOnCall == nil {
		fake.cloneCVEDataReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.cloneCVEDataReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) Commit(arg1 *git.Repo, arg2 string) error {
	fake.commitMutex.Lock()
	ret, specificReturn := fake.commitReturnsOnCall[len(fake.commitArgsForCall)]
	fake.commitArgsForCall = append(fake.commitArgsForCall, struct {
		arg1 *git.Repo
		arg2 string
	}{arg1, arg2})
	stub := fake.CommitStub
	fakeReturns := fake.commitReturns
	fake.recordInvocation("Commit", []interface{}{arg1, arg2})
	fake.commitMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeImpl) CommitCallCount() int {
	fake.commitMutex.RLock()
	defer fake.commitMutex.RUnlock()
	return len(fake.commitArgsForCall)
}

func (fake *FakeImpl) CommitCalls(stub func(*git.Repo, string) error) {
	fake.commitMutex.Lock()
	defer fake.commitMutex.Unlock()
	fake.CommitStub = stub
}

func (fake *FakeImpl) CommitArgsForCall(i int) (*git.Repo, string) {
	fake.commitMutex.RLock()
	defer fake.commitMutex.RUnlock()
	argsForCall := fake.commitArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeImpl) CommitReturns(result1 error) {
	fake.commitMutex.Lock()
	defer fake.commitMutex.Unlock()
	fake.CommitStub = nil
	fake.commitReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) CommitReturnsOnCall(i int, result1 error) {
	fake.commitMutex.Lock()
	defer fake.commitMutex.Unlock()
	fake.CommitStub = nil
	if fake.commitReturnsOnCall == nil {
		fake.commitReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.commitReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) CreateDownloadsTable(arg1 io.Writer, arg2 string, arg3 string, arg4 string, arg5 string) error {
	fake.createDownloadsTableMutex.Lock()
	ret, specificReturn := fake.createDownloadsTableReturnsOnCall[len(fake.createDownloadsTableArgsForCall)]
	fake.createDownloadsTableArgsForCall = append(fake.createDownloadsTableArgsForCall, struct {
		arg1 io.Writer
		arg2 string
		arg3 string
		arg4 string
		arg5 string
	}{arg1, arg2, arg3, arg4, arg5})
	stub := fake.CreateDownloadsTableStub
	fakeReturns := fake.createDownloadsTableReturns
	fake.recordInvocation("CreateDownloadsTable", []interface{}{arg1, arg2, arg3, arg4, arg5})
	fake.createDownloadsTableMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3, arg4, arg5)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeImpl) CreateDownloadsTableCallCount() int {
	fake.createDownloadsTableMutex.RLock()
	defer fake.createDownloadsTableMutex.RUnlock()
	return len(fake.createDownloadsTableArgsForCall)
}

func (fake *FakeImpl) CreateDownloadsTableCalls(stub func(io.Writer, string, string, string, string) error) {
	fake.createDownloadsTableMutex.Lock()
	defer fake.createDownloadsTableMutex.Unlock()
	fake.CreateDownloadsTableStub = stub
}

func (fake *FakeImpl) CreateDownloadsTableArgsForCall(i int) (io.Writer, string, string, string, string) {
	fake.createDownloadsTableMutex.RLock()
	defer fake.createDownloadsTableMutex.RUnlock()
	argsForCall := fake.createDownloadsTableArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3, argsForCall.arg4, argsForCall.arg5
}

func (fake *FakeImpl) CreateDownloadsTableReturns(result1 error) {
	fake.createDownloadsTableMutex.Lock()
	defer fake.createDownloadsTableMutex.Unlock()
	fake.CreateDownloadsTableStub = nil
	fake.createDownloadsTableReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) CreateDownloadsTableReturnsOnCall(i int, result1 error) {
	fake.createDownloadsTableMutex.Lock()
	defer fake.createDownloadsTableMutex.Unlock()
	fake.CreateDownloadsTableStub = nil
	if fake.createDownloadsTableReturnsOnCall == nil {
		fake.createDownloadsTableReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.createDownloadsTableReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) CurrentBranch(arg1 *git.Repo) (string, error) {
	fake.currentBranchMutex.Lock()
	ret, specificReturn := fake.currentBranchReturnsOnCall[len(fake.currentBranchArgsForCall)]
	fake.currentBranchArgsForCall = append(fake.currentBranchArgsForCall, struct {
		arg1 *git.Repo
	}{arg1})
	stub := fake.CurrentBranchStub
	fakeReturns := fake.currentBranchReturns
	fake.recordInvocation("CurrentBranch", []interface{}{arg1})
	fake.currentBranchMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) CurrentBranchCallCount() int {
	fake.currentBranchMutex.RLock()
	defer fake.currentBranchMutex.RUnlock()
	return len(fake.currentBranchArgsForCall)
}

func (fake *FakeImpl) CurrentBranchCalls(stub func(*git.Repo) (string, error)) {
	fake.currentBranchMutex.Lock()
	defer fake.currentBranchMutex.Unlock()
	fake.CurrentBranchStub = stub
}

func (fake *FakeImpl) CurrentBranchArgsForCall(i int) *git.Repo {
	fake.currentBranchMutex.RLock()
	defer fake.currentBranchMutex.RUnlock()
	argsForCall := fake.currentBranchArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeImpl) CurrentBranchReturns(result1 string, result2 error) {
	fake.currentBranchMutex.Lock()
	defer fake.currentBranchMutex.Unlock()
	fake.CurrentBranchStub = nil
	fake.currentBranchReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) CurrentBranchReturnsOnCall(i int, result1 string, result2 error) {
	fake.currentBranchMutex.Lock()
	defer fake.currentBranchMutex.Unlock()
	fake.CurrentBranchStub = nil
	if fake.currentBranchReturnsOnCall == nil {
		fake.currentBranchReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.currentBranchReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) DependencyChanges(arg1 string, arg2 string) (string, error) {
	fake.dependencyChangesMutex.Lock()
	ret, specificReturn := fake.dependencyChangesReturnsOnCall[len(fake.dependencyChangesArgsForCall)]
	fake.dependencyChangesArgsForCall = append(fake.dependencyChangesArgsForCall, struct {
		arg1 string
		arg2 string
	}{arg1, arg2})
	stub := fake.DependencyChangesStub
	fakeReturns := fake.dependencyChangesReturns
	fake.recordInvocation("DependencyChanges", []interface{}{arg1, arg2})
	fake.dependencyChangesMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) DependencyChangesCallCount() int {
	fake.dependencyChangesMutex.RLock()
	defer fake.dependencyChangesMutex.RUnlock()
	return len(fake.dependencyChangesArgsForCall)
}

func (fake *FakeImpl) DependencyChangesCalls(stub func(string, string) (string, error)) {
	fake.dependencyChangesMutex.Lock()
	defer fake.dependencyChangesMutex.Unlock()
	fake.DependencyChangesStub = stub
}

func (fake *FakeImpl) DependencyChangesArgsForCall(i int) (string, string) {
	fake.dependencyChangesMutex.RLock()
	defer fake.dependencyChangesMutex.RUnlock()
	argsForCall := fake.dependencyChangesArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeImpl) DependencyChangesReturns(result1 string, result2 error) {
	fake.dependencyChangesMutex.Lock()
	defer fake.dependencyChangesMutex.Unlock()
	fake.DependencyChangesStub = nil
	fake.dependencyChangesReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) DependencyChangesReturnsOnCall(i int, result1 string, result2 error) {
	fake.dependencyChangesMutex.Lock()
	defer fake.dependencyChangesMutex.Unlock()
	fake.DependencyChangesStub = nil
	if fake.dependencyChangesReturnsOnCall == nil {
		fake.dependencyChangesReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.dependencyChangesReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) GatherReleaseNotes(arg1 *options.Options) (*notes.ReleaseNotes, error) {
	fake.gatherReleaseNotesMutex.Lock()
	ret, specificReturn := fake.gatherReleaseNotesReturnsOnCall[len(fake.gatherReleaseNotesArgsForCall)]
	fake.gatherReleaseNotesArgsForCall = append(fake.gatherReleaseNotesArgsForCall, struct {
		arg1 *options.Options
	}{arg1})
	stub := fake.GatherReleaseNotesStub
	fakeReturns := fake.gatherReleaseNotesReturns
	fake.recordInvocation("GatherReleaseNotes", []interface{}{arg1})
	fake.gatherReleaseNotesMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) GatherReleaseNotesCallCount() int {
	fake.gatherReleaseNotesMutex.RLock()
	defer fake.gatherReleaseNotesMutex.RUnlock()
	return len(fake.gatherReleaseNotesArgsForCall)
}

func (fake *FakeImpl) GatherReleaseNotesCalls(stub func(*options.Options) (*notes.ReleaseNotes, error)) {
	fake.gatherReleaseNotesMutex.Lock()
	defer fake.gatherReleaseNotesMutex.Unlock()
	fake.GatherReleaseNotesStub = stub
}

func (fake *FakeImpl) GatherReleaseNotesArgsForCall(i int) *options.Options {
	fake.gatherReleaseNotesMutex.RLock()
	defer fake.gatherReleaseNotesMutex.RUnlock()
	argsForCall := fake.gatherReleaseNotesArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeImpl) GatherReleaseNotesReturns(result1 *notes.ReleaseNotes, result2 error) {
	fake.gatherReleaseNotesMutex.Lock()
	defer fake.gatherReleaseNotesMutex.Unlock()
	fake.GatherReleaseNotesStub = nil
	fake.gatherReleaseNotesReturns = struct {
		result1 *notes.ReleaseNotes
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) GatherReleaseNotesReturnsOnCall(i int, result1 *notes.ReleaseNotes, result2 error) {
	fake.gatherReleaseNotesMutex.Lock()
	defer fake.gatherReleaseNotesMutex.Unlock()
	fake.GatherReleaseNotesStub = nil
	if fake.gatherReleaseNotesReturnsOnCall == nil {
		fake.gatherReleaseNotesReturnsOnCall = make(map[int]struct {
			result1 *notes.ReleaseNotes
			result2 error
		})
	}
	fake.gatherReleaseNotesReturnsOnCall[i] = struct {
		result1 *notes.ReleaseNotes
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) GenerateTOC(arg1 string) (string, error) {
	fake.generateTOCMutex.Lock()
	ret, specificReturn := fake.generateTOCReturnsOnCall[len(fake.generateTOCArgsForCall)]
	fake.generateTOCArgsForCall = append(fake.generateTOCArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.GenerateTOCStub
	fakeReturns := fake.generateTOCReturns
	fake.recordInvocation("GenerateTOC", []interface{}{arg1})
	fake.generateTOCMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) GenerateTOCCallCount() int {
	fake.generateTOCMutex.RLock()
	defer fake.generateTOCMutex.RUnlock()
	return len(fake.generateTOCArgsForCall)
}

func (fake *FakeImpl) GenerateTOCCalls(stub func(string) (string, error)) {
	fake.generateTOCMutex.Lock()
	defer fake.generateTOCMutex.Unlock()
	fake.GenerateTOCStub = stub
}

func (fake *FakeImpl) GenerateTOCArgsForCall(i int) string {
	fake.generateTOCMutex.RLock()
	defer fake.generateTOCMutex.RUnlock()
	argsForCall := fake.generateTOCArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeImpl) GenerateTOCReturns(result1 string, result2 error) {
	fake.generateTOCMutex.Lock()
	defer fake.generateTOCMutex.Unlock()
	fake.GenerateTOCStub = nil
	fake.generateTOCReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) GenerateTOCReturnsOnCall(i int, result1 string, result2 error) {
	fake.generateTOCMutex.Lock()
	defer fake.generateTOCMutex.Unlock()
	fake.GenerateTOCStub = nil
	if fake.generateTOCReturnsOnCall == nil {
		fake.generateTOCReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.generateTOCReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) GetURLResponse(arg1 string) (string, error) {
	fake.getURLResponseMutex.Lock()
	ret, specificReturn := fake.getURLResponseReturnsOnCall[len(fake.getURLResponseArgsForCall)]
	fake.getURLResponseArgsForCall = append(fake.getURLResponseArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.GetURLResponseStub
	fakeReturns := fake.getURLResponseReturns
	fake.recordInvocation("GetURLResponse", []interface{}{arg1})
	fake.getURLResponseMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) GetURLResponseCallCount() int {
	fake.getURLResponseMutex.RLock()
	defer fake.getURLResponseMutex.RUnlock()
	return len(fake.getURLResponseArgsForCall)
}

func (fake *FakeImpl) GetURLResponseCalls(stub func(string) (string, error)) {
	fake.getURLResponseMutex.Lock()
	defer fake.getURLResponseMutex.Unlock()
	fake.GetURLResponseStub = stub
}

func (fake *FakeImpl) GetURLResponseArgsForCall(i int) string {
	fake.getURLResponseMutex.RLock()
	defer fake.getURLResponseMutex.RUnlock()
	argsForCall := fake.getURLResponseArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeImpl) GetURLResponseReturns(result1 string, result2 error) {
	fake.getURLResponseMutex.Lock()
	defer fake.getURLResponseMutex.Unlock()
	fake.GetURLResponseStub = nil
	fake.getURLResponseReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) GetURLResponseReturnsOnCall(i int, result1 string, result2 error) {
	fake.getURLResponseMutex.Lock()
	defer fake.getURLResponseMutex.Unlock()
	fake.GetURLResponseStub = nil
	if fake.getURLResponseReturnsOnCall == nil {
		fake.getURLResponseReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.getURLResponseReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) LatestGitHubTagsPerBranch() (github.TagsPerBranch, error) {
	fake.latestGitHubTagsPerBranchMutex.Lock()
	ret, specificReturn := fake.latestGitHubTagsPerBranchReturnsOnCall[len(fake.latestGitHubTagsPerBranchArgsForCall)]
	fake.latestGitHubTagsPerBranchArgsForCall = append(fake.latestGitHubTagsPerBranchArgsForCall, struct {
	}{})
	stub := fake.LatestGitHubTagsPerBranchStub
	fakeReturns := fake.latestGitHubTagsPerBranchReturns
	fake.recordInvocation("LatestGitHubTagsPerBranch", []interface{}{})
	fake.latestGitHubTagsPerBranchMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) LatestGitHubTagsPerBranchCallCount() int {
	fake.latestGitHubTagsPerBranchMutex.RLock()
	defer fake.latestGitHubTagsPerBranchMutex.RUnlock()
	return len(fake.latestGitHubTagsPerBranchArgsForCall)
}

func (fake *FakeImpl) LatestGitHubTagsPerBranchCalls(stub func() (github.TagsPerBranch, error)) {
	fake.latestGitHubTagsPerBranchMutex.Lock()
	defer fake.latestGitHubTagsPerBranchMutex.Unlock()
	fake.LatestGitHubTagsPerBranchStub = stub
}

func (fake *FakeImpl) LatestGitHubTagsPerBranchReturns(result1 github.TagsPerBranch, result2 error) {
	fake.latestGitHubTagsPerBranchMutex.Lock()
	defer fake.latestGitHubTagsPerBranchMutex.Unlock()
	fake.LatestGitHubTagsPerBranchStub = nil
	fake.latestGitHubTagsPerBranchReturns = struct {
		result1 github.TagsPerBranch
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) LatestGitHubTagsPerBranchReturnsOnCall(i int, result1 github.TagsPerBranch, result2 error) {
	fake.latestGitHubTagsPerBranchMutex.Lock()
	defer fake.latestGitHubTagsPerBranchMutex.Unlock()
	fake.LatestGitHubTagsPerBranchStub = nil
	if fake.latestGitHubTagsPerBranchReturnsOnCall == nil {
		fake.latestGitHubTagsPerBranchReturnsOnCall = make(map[int]struct {
			result1 github.TagsPerBranch
			result2 error
		})
	}
	fake.latestGitHubTagsPerBranchReturnsOnCall[i] = struct {
		result1 github.TagsPerBranch
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) MarkdownToHTML(arg1 string, arg2 io.Writer, arg3 ...parser.ParseOption) error {
	fake.markdownToHTMLMutex.Lock()
	ret, specificReturn := fake.markdownToHTMLReturnsOnCall[len(fake.markdownToHTMLArgsForCall)]
	fake.markdownToHTMLArgsForCall = append(fake.markdownToHTMLArgsForCall, struct {
		arg1 string
		arg2 io.Writer
		arg3 []parser.ParseOption
	}{arg1, arg2, arg3})
	stub := fake.MarkdownToHTMLStub
	fakeReturns := fake.markdownToHTMLReturns
	fake.recordInvocation("MarkdownToHTML", []interface{}{arg1, arg2, arg3})
	fake.markdownToHTMLMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3...)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeImpl) MarkdownToHTMLCallCount() int {
	fake.markdownToHTMLMutex.RLock()
	defer fake.markdownToHTMLMutex.RUnlock()
	return len(fake.markdownToHTMLArgsForCall)
}

func (fake *FakeImpl) MarkdownToHTMLCalls(stub func(string, io.Writer, ...parser.ParseOption) error) {
	fake.markdownToHTMLMutex.Lock()
	defer fake.markdownToHTMLMutex.Unlock()
	fake.MarkdownToHTMLStub = stub
}

func (fake *FakeImpl) MarkdownToHTMLArgsForCall(i int) (string, io.Writer, []parser.ParseOption) {
	fake.markdownToHTMLMutex.RLock()
	defer fake.markdownToHTMLMutex.RUnlock()
	argsForCall := fake.markdownToHTMLArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeImpl) MarkdownToHTMLReturns(result1 error) {
	fake.markdownToHTMLMutex.Lock()
	defer fake.markdownToHTMLMutex.Unlock()
	fake.MarkdownToHTMLStub = nil
	fake.markdownToHTMLReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) MarkdownToHTMLReturnsOnCall(i int, result1 error) {
	fake.markdownToHTMLMutex.Lock()
	defer fake.markdownToHTMLMutex.Unlock()
	fake.MarkdownToHTMLStub = nil
	if fake.markdownToHTMLReturnsOnCall == nil {
		fake.markdownToHTMLReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.markdownToHTMLReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) NewDocument(arg1 *notes.ReleaseNotes, arg2 string, arg3 string) (*document.Document, error) {
	fake.newDocumentMutex.Lock()
	ret, specificReturn := fake.newDocumentReturnsOnCall[len(fake.newDocumentArgsForCall)]
	fake.newDocumentArgsForCall = append(fake.newDocumentArgsForCall, struct {
		arg1 *notes.ReleaseNotes
		arg2 string
		arg3 string
	}{arg1, arg2, arg3})
	stub := fake.NewDocumentStub
	fakeReturns := fake.newDocumentReturns
	fake.recordInvocation("NewDocument", []interface{}{arg1, arg2, arg3})
	fake.newDocumentMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) NewDocumentCallCount() int {
	fake.newDocumentMutex.RLock()
	defer fake.newDocumentMutex.RUnlock()
	return len(fake.newDocumentArgsForCall)
}

func (fake *FakeImpl) NewDocumentCalls(stub func(*notes.ReleaseNotes, string, string) (*document.Document, error)) {
	fake.newDocumentMutex.Lock()
	defer fake.newDocumentMutex.Unlock()
	fake.NewDocumentStub = stub
}

func (fake *FakeImpl) NewDocumentArgsForCall(i int) (*notes.ReleaseNotes, string, string) {
	fake.newDocumentMutex.RLock()
	defer fake.newDocumentMutex.RUnlock()
	argsForCall := fake.newDocumentArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeImpl) NewDocumentReturns(result1 *document.Document, result2 error) {
	fake.newDocumentMutex.Lock()
	defer fake.newDocumentMutex.Unlock()
	fake.NewDocumentStub = nil
	fake.newDocumentReturns = struct {
		result1 *document.Document
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) NewDocumentReturnsOnCall(i int, result1 *document.Document, result2 error) {
	fake.newDocumentMutex.Lock()
	defer fake.newDocumentMutex.Unlock()
	fake.NewDocumentStub = nil
	if fake.newDocumentReturnsOnCall == nil {
		fake.newDocumentReturnsOnCall = make(map[int]struct {
			result1 *document.Document
			result2 error
		})
	}
	fake.newDocumentReturnsOnCall[i] = struct {
		result1 *document.Document
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) OpenRepo(arg1 string) (*git.Repo, error) {
	fake.openRepoMutex.Lock()
	ret, specificReturn := fake.openRepoReturnsOnCall[len(fake.openRepoArgsForCall)]
	fake.openRepoArgsForCall = append(fake.openRepoArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.OpenRepoStub
	fakeReturns := fake.openRepoReturns
	fake.recordInvocation("OpenRepo", []interface{}{arg1})
	fake.openRepoMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) OpenRepoCallCount() int {
	fake.openRepoMutex.RLock()
	defer fake.openRepoMutex.RUnlock()
	return len(fake.openRepoArgsForCall)
}

func (fake *FakeImpl) OpenRepoCalls(stub func(string) (*git.Repo, error)) {
	fake.openRepoMutex.Lock()
	defer fake.openRepoMutex.Unlock()
	fake.OpenRepoStub = stub
}

func (fake *FakeImpl) OpenRepoArgsForCall(i int) string {
	fake.openRepoMutex.RLock()
	defer fake.openRepoMutex.RUnlock()
	argsForCall := fake.openRepoArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeImpl) OpenRepoReturns(result1 *git.Repo, result2 error) {
	fake.openRepoMutex.Lock()
	defer fake.openRepoMutex.Unlock()
	fake.OpenRepoStub = nil
	fake.openRepoReturns = struct {
		result1 *git.Repo
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) OpenRepoReturnsOnCall(i int, result1 *git.Repo, result2 error) {
	fake.openRepoMutex.Lock()
	defer fake.openRepoMutex.Unlock()
	fake.OpenRepoStub = nil
	if fake.openRepoReturnsOnCall == nil {
		fake.openRepoReturnsOnCall = make(map[int]struct {
			result1 *git.Repo
			result2 error
		})
	}
	fake.openRepoReturnsOnCall[i] = struct {
		result1 *git.Repo
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) ParseHTMLTemplate(arg1 string) (*template.Template, error) {
	fake.parseHTMLTemplateMutex.Lock()
	ret, specificReturn := fake.parseHTMLTemplateReturnsOnCall[len(fake.parseHTMLTemplateArgsForCall)]
	fake.parseHTMLTemplateArgsForCall = append(fake.parseHTMLTemplateArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.ParseHTMLTemplateStub
	fakeReturns := fake.parseHTMLTemplateReturns
	fake.recordInvocation("ParseHTMLTemplate", []interface{}{arg1})
	fake.parseHTMLTemplateMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) ParseHTMLTemplateCallCount() int {
	fake.parseHTMLTemplateMutex.RLock()
	defer fake.parseHTMLTemplateMutex.RUnlock()
	return len(fake.parseHTMLTemplateArgsForCall)
}

func (fake *FakeImpl) ParseHTMLTemplateCalls(stub func(string) (*template.Template, error)) {
	fake.parseHTMLTemplateMutex.Lock()
	defer fake.parseHTMLTemplateMutex.Unlock()
	fake.ParseHTMLTemplateStub = stub
}

func (fake *FakeImpl) ParseHTMLTemplateArgsForCall(i int) string {
	fake.parseHTMLTemplateMutex.RLock()
	defer fake.parseHTMLTemplateMutex.RUnlock()
	argsForCall := fake.parseHTMLTemplateArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeImpl) ParseHTMLTemplateReturns(result1 *template.Template, result2 error) {
	fake.parseHTMLTemplateMutex.Lock()
	defer fake.parseHTMLTemplateMutex.Unlock()
	fake.ParseHTMLTemplateStub = nil
	fake.parseHTMLTemplateReturns = struct {
		result1 *template.Template
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) ParseHTMLTemplateReturnsOnCall(i int, result1 *template.Template, result2 error) {
	fake.parseHTMLTemplateMutex.Lock()
	defer fake.parseHTMLTemplateMutex.Unlock()
	fake.ParseHTMLTemplateStub = nil
	if fake.parseHTMLTemplateReturnsOnCall == nil {
		fake.parseHTMLTemplateReturnsOnCall = make(map[int]struct {
			result1 *template.Template
			result2 error
		})
	}
	fake.parseHTMLTemplateReturnsOnCall[i] = struct {
		result1 *template.Template
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) ReadFile(arg1 string) ([]byte, error) {
	fake.readFileMutex.Lock()
	ret, specificReturn := fake.readFileReturnsOnCall[len(fake.readFileArgsForCall)]
	fake.readFileArgsForCall = append(fake.readFileArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.ReadFileStub
	fakeReturns := fake.readFileReturns
	fake.recordInvocation("ReadFile", []interface{}{arg1})
	fake.readFileMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) ReadFileCallCount() int {
	fake.readFileMutex.RLock()
	defer fake.readFileMutex.RUnlock()
	return len(fake.readFileArgsForCall)
}

func (fake *FakeImpl) ReadFileCalls(stub func(string) ([]byte, error)) {
	fake.readFileMutex.Lock()
	defer fake.readFileMutex.Unlock()
	fake.ReadFileStub = stub
}

func (fake *FakeImpl) ReadFileArgsForCall(i int) string {
	fake.readFileMutex.RLock()
	defer fake.readFileMutex.RUnlock()
	argsForCall := fake.readFileArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeImpl) ReadFileReturns(result1 []byte, result2 error) {
	fake.readFileMutex.Lock()
	defer fake.readFileMutex.Unlock()
	fake.ReadFileStub = nil
	fake.readFileReturns = struct {
		result1 []byte
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) ReadFileReturnsOnCall(i int, result1 []byte, result2 error) {
	fake.readFileMutex.Lock()
	defer fake.readFileMutex.Unlock()
	fake.ReadFileStub = nil
	if fake.readFileReturnsOnCall == nil {
		fake.readFileReturnsOnCall = make(map[int]struct {
			result1 []byte
			result2 error
		})
	}
	fake.readFileReturnsOnCall[i] = struct {
		result1 []byte
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) RenderMarkdownTemplate(arg1 *document.Document, arg2 string, arg3 string, arg4 string) (string, error) {
	fake.renderMarkdownTemplateMutex.Lock()
	ret, specificReturn := fake.renderMarkdownTemplateReturnsOnCall[len(fake.renderMarkdownTemplateArgsForCall)]
	fake.renderMarkdownTemplateArgsForCall = append(fake.renderMarkdownTemplateArgsForCall, struct {
		arg1 *document.Document
		arg2 string
		arg3 string
		arg4 string
	}{arg1, arg2, arg3, arg4})
	stub := fake.RenderMarkdownTemplateStub
	fakeReturns := fake.renderMarkdownTemplateReturns
	fake.recordInvocation("RenderMarkdownTemplate", []interface{}{arg1, arg2, arg3, arg4})
	fake.renderMarkdownTemplateMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3, arg4)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) RenderMarkdownTemplateCallCount() int {
	fake.renderMarkdownTemplateMutex.RLock()
	defer fake.renderMarkdownTemplateMutex.RUnlock()
	return len(fake.renderMarkdownTemplateArgsForCall)
}

func (fake *FakeImpl) RenderMarkdownTemplateCalls(stub func(*document.Document, string, string, string) (string, error)) {
	fake.renderMarkdownTemplateMutex.Lock()
	defer fake.renderMarkdownTemplateMutex.Unlock()
	fake.RenderMarkdownTemplateStub = stub
}

func (fake *FakeImpl) RenderMarkdownTemplateArgsForCall(i int) (*document.Document, string, string, string) {
	fake.renderMarkdownTemplateMutex.RLock()
	defer fake.renderMarkdownTemplateMutex.RUnlock()
	argsForCall := fake.renderMarkdownTemplateArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3, argsForCall.arg4
}

func (fake *FakeImpl) RenderMarkdownTemplateReturns(result1 string, result2 error) {
	fake.renderMarkdownTemplateMutex.Lock()
	defer fake.renderMarkdownTemplateMutex.Unlock()
	fake.RenderMarkdownTemplateStub = nil
	fake.renderMarkdownTemplateReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) RenderMarkdownTemplateReturnsOnCall(i int, result1 string, result2 error) {
	fake.renderMarkdownTemplateMutex.Lock()
	defer fake.renderMarkdownTemplateMutex.Unlock()
	fake.RenderMarkdownTemplateStub = nil
	if fake.renderMarkdownTemplateReturnsOnCall == nil {
		fake.renderMarkdownTemplateReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.renderMarkdownTemplateReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) RepoDir(arg1 *git.Repo) string {
	fake.repoDirMutex.Lock()
	ret, specificReturn := fake.repoDirReturnsOnCall[len(fake.repoDirArgsForCall)]
	fake.repoDirArgsForCall = append(fake.repoDirArgsForCall, struct {
		arg1 *git.Repo
	}{arg1})
	stub := fake.RepoDirStub
	fakeReturns := fake.repoDirReturns
	fake.recordInvocation("RepoDir", []interface{}{arg1})
	fake.repoDirMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeImpl) RepoDirCallCount() int {
	fake.repoDirMutex.RLock()
	defer fake.repoDirMutex.RUnlock()
	return len(fake.repoDirArgsForCall)
}

func (fake *FakeImpl) RepoDirCalls(stub func(*git.Repo) string) {
	fake.repoDirMutex.Lock()
	defer fake.repoDirMutex.Unlock()
	fake.RepoDirStub = stub
}

func (fake *FakeImpl) RepoDirArgsForCall(i int) *git.Repo {
	fake.repoDirMutex.RLock()
	defer fake.repoDirMutex.RUnlock()
	argsForCall := fake.repoDirArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeImpl) RepoDirReturns(result1 string) {
	fake.repoDirMutex.Lock()
	defer fake.repoDirMutex.Unlock()
	fake.RepoDirStub = nil
	fake.repoDirReturns = struct {
		result1 string
	}{result1}
}

func (fake *FakeImpl) RepoDirReturnsOnCall(i int, result1 string) {
	fake.repoDirMutex.Lock()
	defer fake.repoDirMutex.Unlock()
	fake.RepoDirStub = nil
	if fake.repoDirReturnsOnCall == nil {
		fake.repoDirReturnsOnCall = make(map[int]struct {
			result1 string
		})
	}
	fake.repoDirReturnsOnCall[i] = struct {
		result1 string
	}{result1}
}

func (fake *FakeImpl) RevParse(arg1 *git.Repo, arg2 string) (string, error) {
	fake.revParseMutex.Lock()
	ret, specificReturn := fake.revParseReturnsOnCall[len(fake.revParseArgsForCall)]
	fake.revParseArgsForCall = append(fake.revParseArgsForCall, struct {
		arg1 *git.Repo
		arg2 string
	}{arg1, arg2})
	stub := fake.RevParseStub
	fakeReturns := fake.revParseReturns
	fake.recordInvocation("RevParse", []interface{}{arg1, arg2})
	fake.revParseMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) RevParseCallCount() int {
	fake.revParseMutex.RLock()
	defer fake.revParseMutex.RUnlock()
	return len(fake.revParseArgsForCall)
}

func (fake *FakeImpl) RevParseCalls(stub func(*git.Repo, string) (string, error)) {
	fake.revParseMutex.Lock()
	defer fake.revParseMutex.Unlock()
	fake.RevParseStub = stub
}

func (fake *FakeImpl) RevParseArgsForCall(i int) (*git.Repo, string) {
	fake.revParseMutex.RLock()
	defer fake.revParseMutex.RUnlock()
	argsForCall := fake.revParseArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeImpl) RevParseReturns(result1 string, result2 error) {
	fake.revParseMutex.Lock()
	defer fake.revParseMutex.Unlock()
	fake.RevParseStub = nil
	fake.revParseReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) RevParseReturnsOnCall(i int, result1 string, result2 error) {
	fake.revParseMutex.Lock()
	defer fake.revParseMutex.Unlock()
	fake.RevParseStub = nil
	if fake.revParseReturnsOnCall == nil {
		fake.revParseReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.revParseReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) RevParseTag(arg1 *git.Repo, arg2 string) (string, error) {
	fake.revParseTagMutex.Lock()
	ret, specificReturn := fake.revParseTagReturnsOnCall[len(fake.revParseTagArgsForCall)]
	fake.revParseTagArgsForCall = append(fake.revParseTagArgsForCall, struct {
		arg1 *git.Repo
		arg2 string
	}{arg1, arg2})
	stub := fake.RevParseTagStub
	fakeReturns := fake.revParseTagReturns
	fake.recordInvocation("RevParseTag", []interface{}{arg1, arg2})
	fake.revParseTagMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) RevParseTagCallCount() int {
	fake.revParseTagMutex.RLock()
	defer fake.revParseTagMutex.RUnlock()
	return len(fake.revParseTagArgsForCall)
}

func (fake *FakeImpl) RevParseTagCalls(stub func(*git.Repo, string) (string, error)) {
	fake.revParseTagMutex.Lock()
	defer fake.revParseTagMutex.Unlock()
	fake.RevParseTagStub = stub
}

func (fake *FakeImpl) RevParseTagArgsForCall(i int) (*git.Repo, string) {
	fake.revParseTagMutex.RLock()
	defer fake.revParseTagMutex.RUnlock()
	argsForCall := fake.revParseTagArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeImpl) RevParseTagReturns(result1 string, result2 error) {
	fake.revParseTagMutex.Lock()
	defer fake.revParseTagMutex.Unlock()
	fake.RevParseTagStub = nil
	fake.revParseTagReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) RevParseTagReturnsOnCall(i int, result1 string, result2 error) {
	fake.revParseTagMutex.Lock()
	defer fake.revParseTagMutex.Unlock()
	fake.RevParseTagStub = nil
	if fake.revParseTagReturnsOnCall == nil {
		fake.revParseTagReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.revParseTagReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) Rm(arg1 *git.Repo, arg2 bool, arg3 ...string) error {
	fake.rmMutex.Lock()
	ret, specificReturn := fake.rmReturnsOnCall[len(fake.rmArgsForCall)]
	fake.rmArgsForCall = append(fake.rmArgsForCall, struct {
		arg1 *git.Repo
		arg2 bool
		arg3 []string
	}{arg1, arg2, arg3})
	stub := fake.RmStub
	fakeReturns := fake.rmReturns
	fake.recordInvocation("Rm", []interface{}{arg1, arg2, arg3})
	fake.rmMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3...)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeImpl) RmCallCount() int {
	fake.rmMutex.RLock()
	defer fake.rmMutex.RUnlock()
	return len(fake.rmArgsForCall)
}

func (fake *FakeImpl) RmCalls(stub func(*git.Repo, bool, ...string) error) {
	fake.rmMutex.Lock()
	defer fake.rmMutex.Unlock()
	fake.RmStub = stub
}

func (fake *FakeImpl) RmArgsForCall(i int) (*git.Repo, bool, []string) {
	fake.rmMutex.RLock()
	defer fake.rmMutex.RUnlock()
	argsForCall := fake.rmArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeImpl) RmReturns(result1 error) {
	fake.rmMutex.Lock()
	defer fake.rmMutex.Unlock()
	fake.RmStub = nil
	fake.rmReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) RmReturnsOnCall(i int, result1 error) {
	fake.rmMutex.Lock()
	defer fake.rmMutex.Unlock()
	fake.RmStub = nil
	if fake.rmReturnsOnCall == nil {
		fake.rmReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.rmReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) Stat(arg1 string) (fs.FileInfo, error) {
	fake.statMutex.Lock()
	ret, specificReturn := fake.statReturnsOnCall[len(fake.statArgsForCall)]
	fake.statArgsForCall = append(fake.statArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.StatStub
	fakeReturns := fake.statReturns
	fake.recordInvocation("Stat", []interface{}{arg1})
	fake.statMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) StatCallCount() int {
	fake.statMutex.RLock()
	defer fake.statMutex.RUnlock()
	return len(fake.statArgsForCall)
}

func (fake *FakeImpl) StatCalls(stub func(string) (fs.FileInfo, error)) {
	fake.statMutex.Lock()
	defer fake.statMutex.Unlock()
	fake.StatStub = stub
}

func (fake *FakeImpl) StatArgsForCall(i int) string {
	fake.statMutex.RLock()
	defer fake.statMutex.RUnlock()
	argsForCall := fake.statArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeImpl) StatReturns(result1 fs.FileInfo, result2 error) {
	fake.statMutex.Lock()
	defer fake.statMutex.Unlock()
	fake.StatStub = nil
	fake.statReturns = struct {
		result1 fs.FileInfo
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) StatReturnsOnCall(i int, result1 fs.FileInfo, result2 error) {
	fake.statMutex.Lock()
	defer fake.statMutex.Unlock()
	fake.StatStub = nil
	if fake.statReturnsOnCall == nil {
		fake.statReturnsOnCall = make(map[int]struct {
			result1 fs.FileInfo
			result2 error
		})
	}
	fake.statReturnsOnCall[i] = struct {
		result1 fs.FileInfo
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) TagStringToSemver(arg1 string) (semver.Version, error) {
	fake.tagStringToSemverMutex.Lock()
	ret, specificReturn := fake.tagStringToSemverReturnsOnCall[len(fake.tagStringToSemverArgsForCall)]
	fake.tagStringToSemverArgsForCall = append(fake.tagStringToSemverArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.TagStringToSemverStub
	fakeReturns := fake.tagStringToSemverReturns
	fake.recordInvocation("TagStringToSemver", []interface{}{arg1})
	fake.tagStringToSemverMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeImpl) TagStringToSemverCallCount() int {
	fake.tagStringToSemverMutex.RLock()
	defer fake.tagStringToSemverMutex.RUnlock()
	return len(fake.tagStringToSemverArgsForCall)
}

func (fake *FakeImpl) TagStringToSemverCalls(stub func(string) (semver.Version, error)) {
	fake.tagStringToSemverMutex.Lock()
	defer fake.tagStringToSemverMutex.Unlock()
	fake.TagStringToSemverStub = stub
}

func (fake *FakeImpl) TagStringToSemverArgsForCall(i int) string {
	fake.tagStringToSemverMutex.RLock()
	defer fake.tagStringToSemverMutex.RUnlock()
	argsForCall := fake.tagStringToSemverArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeImpl) TagStringToSemverReturns(result1 semver.Version, result2 error) {
	fake.tagStringToSemverMutex.Lock()
	defer fake.tagStringToSemverMutex.Unlock()
	fake.TagStringToSemverStub = nil
	fake.tagStringToSemverReturns = struct {
		result1 semver.Version
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) TagStringToSemverReturnsOnCall(i int, result1 semver.Version, result2 error) {
	fake.tagStringToSemverMutex.Lock()
	defer fake.tagStringToSemverMutex.Unlock()
	fake.TagStringToSemverStub = nil
	if fake.tagStringToSemverReturnsOnCall == nil {
		fake.tagStringToSemverReturnsOnCall = make(map[int]struct {
			result1 semver.Version
			result2 error
		})
	}
	fake.tagStringToSemverReturnsOnCall[i] = struct {
		result1 semver.Version
		result2 error
	}{result1, result2}
}

func (fake *FakeImpl) TemplateExecute(arg1 *template.Template, arg2 io.Writer, arg3 interface{}) error {
	fake.templateExecuteMutex.Lock()
	ret, specificReturn := fake.templateExecuteReturnsOnCall[len(fake.templateExecuteArgsForCall)]
	fake.templateExecuteArgsForCall = append(fake.templateExecuteArgsForCall, struct {
		arg1 *template.Template
		arg2 io.Writer
		arg3 interface{}
	}{arg1, arg2, arg3})
	stub := fake.TemplateExecuteStub
	fakeReturns := fake.templateExecuteReturns
	fake.recordInvocation("TemplateExecute", []interface{}{arg1, arg2, arg3})
	fake.templateExecuteMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeImpl) TemplateExecuteCallCount() int {
	fake.templateExecuteMutex.RLock()
	defer fake.templateExecuteMutex.RUnlock()
	return len(fake.templateExecuteArgsForCall)
}

func (fake *FakeImpl) TemplateExecuteCalls(stub func(*template.Template, io.Writer, interface{}) error) {
	fake.templateExecuteMutex.Lock()
	defer fake.templateExecuteMutex.Unlock()
	fake.TemplateExecuteStub = stub
}

func (fake *FakeImpl) TemplateExecuteArgsForCall(i int) (*template.Template, io.Writer, interface{}) {
	fake.templateExecuteMutex.RLock()
	defer fake.templateExecuteMutex.RUnlock()
	argsForCall := fake.templateExecuteArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeImpl) TemplateExecuteReturns(result1 error) {
	fake.templateExecuteMutex.Lock()
	defer fake.templateExecuteMutex.Unlock()
	fake.TemplateExecuteStub = nil
	fake.templateExecuteReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) TemplateExecuteReturnsOnCall(i int, result1 error) {
	fake.templateExecuteMutex.Lock()
	defer fake.templateExecuteMutex.Unlock()
	fake.TemplateExecuteStub = nil
	if fake.templateExecuteReturnsOnCall == nil {
		fake.templateExecuteReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.templateExecuteReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) ValidateAndFinish(arg1 *options.Options) error {
	fake.validateAndFinishMutex.Lock()
	ret, specificReturn := fake.validateAndFinishReturnsOnCall[len(fake.validateAndFinishArgsForCall)]
	fake.validateAndFinishArgsForCall = append(fake.validateAndFinishArgsForCall, struct {
		arg1 *options.Options
	}{arg1})
	stub := fake.ValidateAndFinishStub
	fakeReturns := fake.validateAndFinishReturns
	fake.recordInvocation("ValidateAndFinish", []interface{}{arg1})
	fake.validateAndFinishMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeImpl) ValidateAndFinishCallCount() int {
	fake.validateAndFinishMutex.RLock()
	defer fake.validateAndFinishMutex.RUnlock()
	return len(fake.validateAndFinishArgsForCall)
}

func (fake *FakeImpl) ValidateAndFinishCalls(stub func(*options.Options) error) {
	fake.validateAndFinishMutex.Lock()
	defer fake.validateAndFinishMutex.Unlock()
	fake.ValidateAndFinishStub = stub
}

func (fake *FakeImpl) ValidateAndFinishArgsForCall(i int) *options.Options {
	fake.validateAndFinishMutex.RLock()
	defer fake.validateAndFinishMutex.RUnlock()
	argsForCall := fake.validateAndFinishArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeImpl) ValidateAndFinishReturns(result1 error) {
	fake.validateAndFinishMutex.Lock()
	defer fake.validateAndFinishMutex.Unlock()
	fake.ValidateAndFinishStub = nil
	fake.validateAndFinishReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) ValidateAndFinishReturnsOnCall(i int, result1 error) {
	fake.validateAndFinishMutex.Lock()
	defer fake.validateAndFinishMutex.Unlock()
	fake.ValidateAndFinishStub = nil
	if fake.validateAndFinishReturnsOnCall == nil {
		fake.validateAndFinishReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.validateAndFinishReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) WriteFile(arg1 string, arg2 []byte, arg3 fs.FileMode) error {
	var arg2Copy []byte
	if arg2 != nil {
		arg2Copy = make([]byte, len(arg2))
		copy(arg2Copy, arg2)
	}
	fake.writeFileMutex.Lock()
	ret, specificReturn := fake.writeFileReturnsOnCall[len(fake.writeFileArgsForCall)]
	fake.writeFileArgsForCall = append(fake.writeFileArgsForCall, struct {
		arg1 string
		arg2 []byte
		arg3 fs.FileMode
	}{arg1, arg2Copy, arg3})
	stub := fake.WriteFileStub
	fakeReturns := fake.writeFileReturns
	fake.recordInvocation("WriteFile", []interface{}{arg1, arg2Copy, arg3})
	fake.writeFileMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeImpl) WriteFileCallCount() int {
	fake.writeFileMutex.RLock()
	defer fake.writeFileMutex.RUnlock()
	return len(fake.writeFileArgsForCall)
}

func (fake *FakeImpl) WriteFileCalls(stub func(string, []byte, fs.FileMode) error) {
	fake.writeFileMutex.Lock()
	defer fake.writeFileMutex.Unlock()
	fake.WriteFileStub = stub
}

func (fake *FakeImpl) WriteFileArgsForCall(i int) (string, []byte, fs.FileMode) {
	fake.writeFileMutex.RLock()
	defer fake.writeFileMutex.RUnlock()
	argsForCall := fake.writeFileArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3
}

func (fake *FakeImpl) WriteFileReturns(result1 error) {
	fake.writeFileMutex.Lock()
	defer fake.writeFileMutex.Unlock()
	fake.WriteFileStub = nil
	fake.writeFileReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) WriteFileReturnsOnCall(i int, result1 error) {
	fake.writeFileMutex.Lock()
	defer fake.writeFileMutex.Unlock()
	fake.WriteFileStub = nil
	if fake.writeFileReturnsOnCall == nil {
		fake.writeFileReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.writeFileReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.absMutex.RLock()
	defer fake.absMutex.RUnlock()
	fake.addMutex.RLock()
	defer fake.addMutex.RUnlock()
	fake.checkoutMutex.RLock()
	defer fake.checkoutMutex.RUnlock()
	fake.cloneCVEDataMutex.RLock()
	defer fake.cloneCVEDataMutex.RUnlock()
	fake.commitMutex.RLock()
	defer fake.commitMutex.RUnlock()
	fake.createDownloadsTableMutex.RLock()
	defer fake.createDownloadsTableMutex.RUnlock()
	fake.currentBranchMutex.RLock()
	defer fake.currentBranchMutex.RUnlock()
	fake.dependencyChangesMutex.RLock()
	defer fake.dependencyChangesMutex.RUnlock()
	fake.gatherReleaseNotesMutex.RLock()
	defer fake.gatherReleaseNotesMutex.RUnlock()
	fake.generateTOCMutex.RLock()
	defer fake.generateTOCMutex.RUnlock()
	fake.getURLResponseMutex.RLock()
	defer fake.getURLResponseMutex.RUnlock()
	fake.latestGitHubTagsPerBranchMutex.RLock()
	defer fake.latestGitHubTagsPerBranchMutex.RUnlock()
	fake.markdownToHTMLMutex.RLock()
	defer fake.markdownToHTMLMutex.RUnlock()
	fake.newDocumentMutex.RLock()
	defer fake.newDocumentMutex.RUnlock()
	fake.openRepoMutex.RLock()
	defer fake.openRepoMutex.RUnlock()
	fake.parseHTMLTemplateMutex.RLock()
	defer fake.parseHTMLTemplateMutex.RUnlock()
	fake.readFileMutex.RLock()
	defer fake.readFileMutex.RUnlock()
	fake.renderMarkdownTemplateMutex.RLock()
	defer fake.renderMarkdownTemplateMutex.RUnlock()
	fake.repoDirMutex.RLock()
	defer fake.repoDirMutex.RUnlock()
	fake.revParseMutex.RLock()
	defer fake.revParseMutex.RUnlock()
	fake.revParseTagMutex.RLock()
	defer fake.revParseTagMutex.RUnlock()
	fake.rmMutex.RLock()
	defer fake.rmMutex.RUnlock()
	fake.statMutex.RLock()
	defer fake.statMutex.RUnlock()
	fake.tagStringToSemverMutex.RLock()
	defer fake.tagStringToSemverMutex.RUnlock()
	fake.templateExecuteMutex.RLock()
	defer fake.templateExecuteMutex.RUnlock()
	fake.validateAndFinishMutex.RLock()
	defer fake.validateAndFinishMutex.RUnlock()
	fake.writeFileMutex.RLock()
	defer fake.writeFileMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeImpl) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}
