/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package gcbfakes

import (
	"sync"

	"k8s.io/release/pkg/gcp/gcb"
)

type FakeRepository struct {
	CheckStateStub        func(string, string, string, bool) error
	checkStateMutex       sync.RWMutex
	checkStateArgsForCall []struct {
		arg1 string
		arg2 string
		arg3 string
		arg4 bool
	}
	checkStateReturns struct {
		result1 error
	}
	checkStateReturnsOnCall map[int]struct {
		result1 error
	}
	GetTagStub        func() (string, error)
	getTagMutex       sync.RWMutex
	getTagArgsForCall []struct {
	}
	getTagReturns struct {
		result1 string
		result2 error
	}
	getTagReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	OpenStub        func() error
	openMutex       sync.RWMutex
	openArgsForCall []struct {
	}
	openReturns struct {
		result1 error
	}
	openReturnsOnCall map[int]struct {
		result1 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeRepository) CheckState(arg1 string, arg2 string, arg3 string, arg4 bool) error {
	fake.checkStateMutex.Lock()
	ret, specificReturn := fake.checkStateReturnsOnCall[len(fake.checkStateArgsForCall)]
	fake.checkStateArgsForCall = append(fake.checkStateArgsForCall, struct {
		arg1 string
		arg2 string
		arg3 string
		arg4 bool
	}{arg1, arg2, arg3, arg4})
	stub := fake.CheckStateStub
	fakeReturns := fake.checkStateReturns
	fake.recordInvocation("CheckState", []interface{}{arg1, arg2, arg3, arg4})
	fake.checkStateMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3, arg4)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeRepository) CheckStateCallCount() int {
	fake.checkStateMutex.RLock()
	defer fake.checkStateMutex.RUnlock()
	return len(fake.checkStateArgsForCall)
}

func (fake *FakeRepository) CheckStateCalls(stub func(string, string, string, bool) error) {
	fake.checkStateMutex.Lock()
	defer fake.checkStateMutex.Unlock()
	fake.CheckStateStub = stub
}

func (fake *FakeRepository) CheckStateArgsForCall(i int) (string, string, string, bool) {
	fake.checkStateMutex.RLock()
	defer fake.checkStateMutex.RUnlock()
	argsForCall := fake.checkStateArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3, argsForCall.arg4
}

func (fake *FakeRepository) CheckStateReturns(result1 error) {
	fake.checkStateMutex.Lock()
	defer fake.checkStateMutex.Unlock()
	fake.CheckStateStub = nil
	fake.checkStateReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeRepository) CheckStateReturnsOnCall(i int, result1 error) {
	fake.checkStateMutex.Lock()
	defer fake.checkStateMutex.Unlock()
	fake.CheckStateStub = nil
	if fake.checkStateReturnsOnCall == nil {
		fake.checkStateReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.checkStateReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeRepository) GetTag() (string, error) {
	fake.getTagMutex.Lock()
	ret, specificReturn := fake.getTagReturnsOnCall[len(fake.getTagArgsForCall)]
	fake.getTagArgsForCall = append(fake.getTagArgsForCall, struct {
	}{})
	stub := fake.GetTagStub
	fakeReturns := fake.getTagReturns
	fake.recordInvocation("GetTag", []interface{}{})
	fake.getTagMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeRepository) GetTagCallCount() int {
	fake.getTagMutex.RLock()
	defer fake.getTagMutex.RUnlock()
	return len(fake.getTagArgsForCall)
}

func (fake *FakeRepository) GetTagCalls(stub func() (string, error)) {
	fake.getTagMutex.Lock()
	defer fake.getTagMutex.Unlock()
	fake.GetTagStub = stub
}

func (fake *FakeRepository) GetTagReturns(result1 string, result2 error) {
	fake.getTagMutex.Lock()
	defer fake.getTagMutex.Unlock()
	fake.GetTagStub = nil
	fake.getTagReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeRepository) GetTagReturnsOnCall(i int, result1 string, result2 error) {
	fake.getTagMutex.Lock()
	defer fake.getTagMutex.Unlock()
	fake.GetTagStub = nil
	if fake.getTagReturnsOnCall == nil {
		fake.getTagReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.getTagReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeRepository) Open() error {
	fake.openMutex.Lock()
	ret, specificReturn := fake.openReturnsOnCall[len(fake.openArgsForCall)]
	fake.openArgsForCall = append(fake.openArgsForCall, struct {
	}{})
	stub := fake.OpenStub
	fakeReturns := fake.openReturns
	fake.recordInvocation("Open", []interface{}{})
	fake.openMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeRepository) OpenCallCount() int {
	fake.openMutex.RLock()
	defer fake.openMutex.RUnlock()
	return len(fake.openArgsForCall)
}

func (fake *FakeRepository) OpenCalls(stub func() error) {
	fake.openMutex.Lock()
	defer fake.openMutex.Unlock()
	fake.OpenStub = stub
}

func (fake *FakeRepository) OpenReturns(result1 error) {
	fake.openMutex.Lock()
	defer fake.openMutex.Unlock()
	fake.OpenStub = nil
	fake.openReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeRepository) OpenReturnsOnCall(i int, result1 error) {
	fake.openMutex.Lock()
	defer fake.openMutex.Unlock()
	fake.OpenStub = nil
	if fake.openReturnsOnCall == nil {
		fake.openReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.openReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeRepository) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.checkStateMutex.RLock()
	defer fake.checkStateMutex.RUnlock()
	fake.getTagMutex.RLock()
	defer fake.getTagMutex.RUnlock()
	fake.openMutex.RLock()
	defer fake.openMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeRepository) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}

var _ gcb.Repository = new(FakeRepository)
