/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package releasefakes

import (
	"sync"
)

type FakeCommandClient struct {
	ExecuteStub        func(string, ...string) error
	executeMutex       sync.RWMutex
	executeArgsForCall []struct {
		arg1 string
		arg2 []string
	}
	executeReturns struct {
		result1 error
	}
	executeReturnsOnCall map[int]struct {
		result1 error
	}
	ExecuteOutputStub        func(string, ...string) (string, error)
	executeOutputMutex       sync.RWMutex
	executeOutputArgsForCall []struct {
		arg1 string
		arg2 []string
	}
	executeOutputReturns struct {
		result1 string
		result2 error
	}
	executeOutputReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	RepoTagFromTarballStub        func(string) (string, error)
	repoTagFromTarballMutex       sync.RWMutex
	repoTagFromTarballArgsForCall []struct {
		arg1 string
	}
	repoTagFromTarballReturns struct {
		result1 string
		result2 error
	}
	repoTagFromTarballReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeCommandClient) Execute(arg1 string, arg2 ...string) error {
	fake.executeMutex.Lock()
	ret, specificReturn := fake.executeReturnsOnCall[len(fake.executeArgsForCall)]
	fake.executeArgsForCall = append(fake.executeArgsForCall, struct {
		arg1 string
		arg2 []string
	}{arg1, arg2})
	stub := fake.ExecuteStub
	fakeReturns := fake.executeReturns
	fake.recordInvocation("Execute", []interface{}{arg1, arg2})
	fake.executeMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2...)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeCommandClient) ExecuteCallCount() int {
	fake.executeMutex.RLock()
	defer fake.executeMutex.RUnlock()
	return len(fake.executeArgsForCall)
}

func (fake *FakeCommandClient) ExecuteCalls(stub func(string, ...string) error) {
	fake.executeMutex.Lock()
	defer fake.executeMutex.Unlock()
	fake.ExecuteStub = stub
}

func (fake *FakeCommandClient) ExecuteArgsForCall(i int) (string, []string) {
	fake.executeMutex.RLock()
	defer fake.executeMutex.RUnlock()
	argsForCall := fake.executeArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeCommandClient) ExecuteReturns(result1 error) {
	fake.executeMutex.Lock()
	defer fake.executeMutex.Unlock()
	fake.ExecuteStub = nil
	fake.executeReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeCommandClient) ExecuteReturnsOnCall(i int, result1 error) {
	fake.executeMutex.Lock()
	defer fake.executeMutex.Unlock()
	fake.ExecuteStub = nil
	if fake.executeReturnsOnCall == nil {
		fake.executeReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.executeReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeCommandClient) ExecuteOutput(arg1 string, arg2 ...string) (string, error) {
	fake.executeOutputMutex.Lock()
	ret, specificReturn := fake.executeOutputReturnsOnCall[len(fake.executeOutputArgsForCall)]
	fake.executeOutputArgsForCall = append(fake.executeOutputArgsForCall, struct {
		arg1 string
		arg2 []string
	}{arg1, arg2})
	stub := fake.ExecuteOutputStub
	fakeReturns := fake.executeOutputReturns
	fake.recordInvocation("ExecuteOutput", []interface{}{arg1, arg2})
	fake.executeOutputMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2...)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeCommandClient) ExecuteOutputCallCount() int {
	fake.executeOutputMutex.RLock()
	defer fake.executeOutputMutex.RUnlock()
	return len(fake.executeOutputArgsForCall)
}

func (fake *FakeCommandClient) ExecuteOutputCalls(stub func(string, ...string) (string, error)) {
	fake.executeOutputMutex.Lock()
	defer fake.executeOutputMutex.Unlock()
	fake.ExecuteOutputStub = stub
}

func (fake *FakeCommandClient) ExecuteOutputArgsForCall(i int) (string, []string) {
	fake.executeOutputMutex.RLock()
	defer fake.executeOutputMutex.RUnlock()
	argsForCall := fake.executeOutputArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeCommandClient) ExecuteOutputReturns(result1 string, result2 error) {
	fake.executeOutputMutex.Lock()
	defer fake.executeOutputMutex.Unlock()
	fake.ExecuteOutputStub = nil
	fake.executeOutputReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeCommandClient) ExecuteOutputReturnsOnCall(i int, result1 string, result2 error) {
	fake.executeOutputMutex.Lock()
	defer fake.executeOutputMutex.Unlock()
	fake.ExecuteOutputStub = nil
	if fake.executeOutputReturnsOnCall == nil {
		fake.executeOutputReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.executeOutputReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeCommandClient) RepoTagFromTarball(arg1 string) (string, error) {
	fake.repoTagFromTarballMutex.Lock()
	ret, specificReturn := fake.repoTagFromTarballReturnsOnCall[len(fake.repoTagFromTarballArgsForCall)]
	fake.repoTagFromTarballArgsForCall = append(fake.repoTagFromTarballArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.RepoTagFromTarballStub
	fakeReturns := fake.repoTagFromTarballReturns
	fake.recordInvocation("RepoTagFromTarball", []interface{}{arg1})
	fake.repoTagFromTarballMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeCommandClient) RepoTagFromTarballCallCount() int {
	fake.repoTagFromTarballMutex.RLock()
	defer fake.repoTagFromTarballMutex.RUnlock()
	return len(fake.repoTagFromTarballArgsForCall)
}

func (fake *FakeCommandClient) RepoTagFromTarballCalls(stub func(string) (string, error)) {
	fake.repoTagFromTarballMutex.Lock()
	defer fake.repoTagFromTarballMutex.Unlock()
	fake.RepoTagFromTarballStub = stub
}

func (fake *FakeCommandClient) RepoTagFromTarballArgsForCall(i int) string {
	fake.repoTagFromTarballMutex.RLock()
	defer fake.repoTagFromTarballMutex.RUnlock()
	argsForCall := fake.repoTagFromTarballArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeCommandClient) RepoTagFromTarballReturns(result1 string, result2 error) {
	fake.repoTagFromTarballMutex.Lock()
	defer fake.repoTagFromTarballMutex.Unlock()
	fake.RepoTagFromTarballStub = nil
	fake.repoTagFromTarballReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeCommandClient) RepoTagFromTarballReturnsOnCall(i int, result1 string, result2 error) {
	fake.repoTagFromTarballMutex.Lock()
	defer fake.repoTagFromTarballMutex.Unlock()
	fake.RepoTagFromTarballStub = nil
	if fake.repoTagFromTarballReturnsOnCall == nil {
		fake.repoTagFromTarballReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.repoTagFromTarballReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeCommandClient) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.executeMutex.RLock()
	defer fake.executeMutex.RUnlock()
	fake.executeOutputMutex.RLock()
	defer fake.executeOutputMutex.RUnlock()
	fake.repoTagFromTarballMutex.RLock()
	defer fake.repoTagFromTarballMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeCommandClient) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}
