/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package releasefakes

import (
	"sync"

	"k8s.io/release/pkg/git"
	"k8s.io/release/pkg/release"
)

type FakeRepository struct {
	CurrentBranchStub        func() (string, error)
	currentBranchMutex       sync.RWMutex
	currentBranchArgsForCall []struct {
	}
	currentBranchReturns struct {
		result1 string
		result2 error
	}
	currentBranchReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	DescribeStub        func(*git.DescribeOptions) (string, error)
	describeMutex       sync.RWMutex
	describeArgsForCall []struct {
		arg1 *git.DescribeOptions
	}
	describeReturns struct {
		result1 string
		result2 error
	}
	describeReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	HeadStub        func() (string, error)
	headMutex       sync.RWMutex
	headArgsForCall []struct {
	}
	headReturns struct {
		result1 string
		result2 error
	}
	headReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	IsDirtyStub        func() (bool, error)
	isDirtyMutex       sync.RWMutex
	isDirtyArgsForCall []struct {
	}
	isDirtyReturns struct {
		result1 bool
		result2 error
	}
	isDirtyReturnsOnCall map[int]struct {
		result1 bool
		result2 error
	}
	LsRemoteStub        func(...string) (string, error)
	lsRemoteMutex       sync.RWMutex
	lsRemoteArgsForCall []struct {
		arg1 []string
	}
	lsRemoteReturns struct {
		result1 string
		result2 error
	}
	lsRemoteReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	RemotesStub        func() ([]*git.Remote, error)
	remotesMutex       sync.RWMutex
	remotesArgsForCall []struct {
	}
	remotesReturns struct {
		result1 []*git.Remote
		result2 error
	}
	remotesReturnsOnCall map[int]struct {
		result1 []*git.Remote
		result2 error
	}
	RevParseStub        func(string) (string, error)
	revParseMutex       sync.RWMutex
	revParseArgsForCall []struct {
		arg1 string
	}
	revParseReturns struct {
		result1 string
		result2 error
	}
	revParseReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeRepository) CurrentBranch() (string, error) {
	fake.currentBranchMutex.Lock()
	ret, specificReturn := fake.currentBranchReturnsOnCall[len(fake.currentBranchArgsForCall)]
	fake.currentBranchArgsForCall = append(fake.currentBranchArgsForCall, struct {
	}{})
	stub := fake.CurrentBranchStub
	fakeReturns := fake.currentBranchReturns
	fake.recordInvocation("CurrentBranch", []interface{}{})
	fake.currentBranchMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeRepository) CurrentBranchCallCount() int {
	fake.currentBranchMutex.RLock()
	defer fake.currentBranchMutex.RUnlock()
	return len(fake.currentBranchArgsForCall)
}

func (fake *FakeRepository) CurrentBranchCalls(stub func() (string, error)) {
	fake.currentBranchMutex.Lock()
	defer fake.currentBranchMutex.Unlock()
	fake.CurrentBranchStub = stub
}

func (fake *FakeRepository) CurrentBranchReturns(result1 string, result2 error) {
	fake.currentBranchMutex.Lock()
	defer fake.currentBranchMutex.Unlock()
	fake.CurrentBranchStub = nil
	fake.currentBranchReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeRepository) CurrentBranchReturnsOnCall(i int, result1 string, result2 error) {
	fake.currentBranchMutex.Lock()
	defer fake.currentBranchMutex.Unlock()
	fake.CurrentBranchStub = nil
	if fake.currentBranchReturnsOnCall == nil {
		fake.currentBranchReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.currentBranchReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeRepository) Describe(arg1 *git.DescribeOptions) (string, error) {
	fake.describeMutex.Lock()
	ret, specificReturn := fake.describeReturnsOnCall[len(fake.describeArgsForCall)]
	fake.describeArgsForCall = append(fake.describeArgsForCall, struct {
		arg1 *git.DescribeOptions
	}{arg1})
	stub := fake.DescribeStub
	fakeReturns := fake.describeReturns
	fake.recordInvocation("Describe", []interface{}{arg1})
	fake.describeMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeRepository) DescribeCallCount() int {
	fake.describeMutex.RLock()
	defer fake.describeMutex.RUnlock()
	return len(fake.describeArgsForCall)
}

func (fake *FakeRepository) DescribeCalls(stub func(*git.DescribeOptions) (string, error)) {
	fake.describeMutex.Lock()
	defer fake.describeMutex.Unlock()
	fake.DescribeStub = stub
}

func (fake *FakeRepository) DescribeArgsForCall(i int) *git.DescribeOptions {
	fake.describeMutex.RLock()
	defer fake.describeMutex.RUnlock()
	argsForCall := fake.describeArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeRepository) DescribeReturns(result1 string, result2 error) {
	fake.describeMutex.Lock()
	defer fake.describeMutex.Unlock()
	fake.DescribeStub = nil
	fake.describeReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeRepository) DescribeReturnsOnCall(i int, result1 string, result2 error) {
	fake.describeMutex.Lock()
	defer fake.describeMutex.Unlock()
	fake.DescribeStub = nil
	if fake.describeReturnsOnCall == nil {
		fake.describeReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.describeReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeRepository) Head() (string, error) {
	fake.headMutex.Lock()
	ret, specificReturn := fake.headReturnsOnCall[len(fake.headArgsForCall)]
	fake.headArgsForCall = append(fake.headArgsForCall, struct {
	}{})
	stub := fake.HeadStub
	fakeReturns := fake.headReturns
	fake.recordInvocation("Head", []interface{}{})
	fake.headMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeRepository) HeadCallCount() int {
	fake.headMutex.RLock()
	defer fake.headMutex.RUnlock()
	return len(fake.headArgsForCall)
}

func (fake *FakeRepository) HeadCalls(stub func() (string, error)) {
	fake.headMutex.Lock()
	defer fake.headMutex.Unlock()
	fake.HeadStub = stub
}

func (fake *FakeRepository) HeadReturns(result1 string, result2 error) {
	fake.headMutex.Lock()
	defer fake.headMutex.Unlock()
	fake.HeadStub = nil
	fake.headReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeRepository) HeadReturnsOnCall(i int, result1 string, result2 error) {
	fake.headMutex.Lock()
	defer fake.headMutex.Unlock()
	fake.HeadStub = nil
	if fake.headReturnsOnCall == nil {
		fake.headReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.headReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeRepository) IsDirty() (bool, error) {
	fake.isDirtyMutex.Lock()
	ret, specificReturn := fake.isDirtyReturnsOnCall[len(fake.isDirtyArgsForCall)]
	fake.isDirtyArgsForCall = append(fake.isDirtyArgsForCall, struct {
	}{})
	stub := fake.IsDirtyStub
	fakeReturns := fake.isDirtyReturns
	fake.recordInvocation("IsDirty", []interface{}{})
	fake.isDirtyMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeRepository) IsDirtyCallCount() int {
	fake.isDirtyMutex.RLock()
	defer fake.isDirtyMutex.RUnlock()
	return len(fake.isDirtyArgsForCall)
}

func (fake *FakeRepository) IsDirtyCalls(stub func() (bool, error)) {
	fake.isDirtyMutex.Lock()
	defer fake.isDirtyMutex.Unlock()
	fake.IsDirtyStub = stub
}

func (fake *FakeRepository) IsDirtyReturns(result1 bool, result2 error) {
	fake.isDirtyMutex.Lock()
	defer fake.isDirtyMutex.Unlock()
	fake.IsDirtyStub = nil
	fake.isDirtyReturns = struct {
		result1 bool
		result2 error
	}{result1, result2}
}

func (fake *FakeRepository) IsDirtyReturnsOnCall(i int, result1 bool, result2 error) {
	fake.isDirtyMutex.Lock()
	defer fake.isDirtyMutex.Unlock()
	fake.IsDirtyStub = nil
	if fake.isDirtyReturnsOnCall == nil {
		fake.isDirtyReturnsOnCall = make(map[int]struct {
			result1 bool
			result2 error
		})
	}
	fake.isDirtyReturnsOnCall[i] = struct {
		result1 bool
		result2 error
	}{result1, result2}
}

func (fake *FakeRepository) LsRemote(arg1 ...string) (string, error) {
	fake.lsRemoteMutex.Lock()
	ret, specificReturn := fake.lsRemoteReturnsOnCall[len(fake.lsRemoteArgsForCall)]
	fake.lsRemoteArgsForCall = append(fake.lsRemoteArgsForCall, struct {
		arg1 []string
	}{arg1})
	stub := fake.LsRemoteStub
	fakeReturns := fake.lsRemoteReturns
	fake.recordInvocation("LsRemote", []interface{}{arg1})
	fake.lsRemoteMutex.Unlock()
	if stub != nil {
		return stub(arg1...)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeRepository) LsRemoteCallCount() int {
	fake.lsRemoteMutex.RLock()
	defer fake.lsRemoteMutex.RUnlock()
	return len(fake.lsRemoteArgsForCall)
}

func (fake *FakeRepository) LsRemoteCalls(stub func(...string) (string, error)) {
	fake.lsRemoteMutex.Lock()
	defer fake.lsRemoteMutex.Unlock()
	fake.LsRemoteStub = stub
}

func (fake *FakeRepository) LsRemoteArgsForCall(i int) []string {
	fake.lsRemoteMutex.RLock()
	defer fake.lsRemoteMutex.RUnlock()
	argsForCall := fake.lsRemoteArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeRepository) LsRemoteReturns(result1 string, result2 error) {
	fake.lsRemoteMutex.Lock()
	defer fake.lsRemoteMutex.Unlock()
	fake.LsRemoteStub = nil
	fake.lsRemoteReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeRepository) LsRemoteReturnsOnCall(i int, result1 string, result2 error) {
	fake.lsRemoteMutex.Lock()
	defer fake.lsRemoteMutex.Unlock()
	fake.LsRemoteStub = nil
	if fake.lsRemoteReturnsOnCall == nil {
		fake.lsRemoteReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.lsRemoteReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeRepository) Remotes() ([]*git.Remote, error) {
	fake.remotesMutex.Lock()
	ret, specificReturn := fake.remotesReturnsOnCall[len(fake.remotesArgsForCall)]
	fake.remotesArgsForCall = append(fake.remotesArgsForCall, struct {
	}{})
	stub := fake.RemotesStub
	fakeReturns := fake.remotesReturns
	fake.recordInvocation("Remotes", []interface{}{})
	fake.remotesMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeRepository) RemotesCallCount() int {
	fake.remotesMutex.RLock()
	defer fake.remotesMutex.RUnlock()
	return len(fake.remotesArgsForCall)
}

func (fake *FakeRepository) RemotesCalls(stub func() ([]*git.Remote, error)) {
	fake.remotesMutex.Lock()
	defer fake.remotesMutex.Unlock()
	fake.RemotesStub = stub
}

func (fake *FakeRepository) RemotesReturns(result1 []*git.Remote, result2 error) {
	fake.remotesMutex.Lock()
	defer fake.remotesMutex.Unlock()
	fake.RemotesStub = nil
	fake.remotesReturns = struct {
		result1 []*git.Remote
		result2 error
	}{result1, result2}
}

func (fake *FakeRepository) RemotesReturnsOnCall(i int, result1 []*git.Remote, result2 error) {
	fake.remotesMutex.Lock()
	defer fake.remotesMutex.Unlock()
	fake.RemotesStub = nil
	if fake.remotesReturnsOnCall == nil {
		fake.remotesReturnsOnCall = make(map[int]struct {
			result1 []*git.Remote
			result2 error
		})
	}
	fake.remotesReturnsOnCall[i] = struct {
		result1 []*git.Remote
		result2 error
	}{result1, result2}
}

func (fake *FakeRepository) RevParse(arg1 string) (string, error) {
	fake.revParseMutex.Lock()
	ret, specificReturn := fake.revParseReturnsOnCall[len(fake.revParseArgsForCall)]
	fake.revParseArgsForCall = append(fake.revParseArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.RevParseStub
	fakeReturns := fake.revParseReturns
	fake.recordInvocation("RevParse", []interface{}{arg1})
	fake.revParseMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeRepository) RevParseCallCount() int {
	fake.revParseMutex.RLock()
	defer fake.revParseMutex.RUnlock()
	return len(fake.revParseArgsForCall)
}

func (fake *FakeRepository) RevParseCalls(stub func(string) (string, error)) {
	fake.revParseMutex.Lock()
	defer fake.revParseMutex.Unlock()
	fake.RevParseStub = stub
}

func (fake *FakeRepository) RevParseArgsForCall(i int) string {
	fake.revParseMutex.RLock()
	defer fake.revParseMutex.RUnlock()
	argsForCall := fake.revParseArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeRepository) RevParseReturns(result1 string, result2 error) {
	fake.revParseMutex.Lock()
	defer fake.revParseMutex.Unlock()
	fake.RevParseStub = nil
	fake.revParseReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeRepository) RevParseReturnsOnCall(i int, result1 string, result2 error) {
	fake.revParseMutex.Lock()
	defer fake.revParseMutex.Unlock()
	fake.RevParseStub = nil
	if fake.revParseReturnsOnCall == nil {
		fake.revParseReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.revParseReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeRepository) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.currentBranchMutex.RLock()
	defer fake.currentBranchMutex.RUnlock()
	fake.describeMutex.RLock()
	defer fake.describeMutex.RUnlock()
	fake.headMutex.RLock()
	defer fake.headMutex.RUnlock()
	fake.isDirtyMutex.RLock()
	defer fake.isDirtyMutex.RUnlock()
	fake.lsRemoteMutex.RLock()
	defer fake.lsRemoteMutex.RUnlock()
	fake.remotesMutex.RLock()
	defer fake.remotesMutex.RUnlock()
	fake.revParseMutex.RLock()
	defer fake.revParseMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeRepository) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}

var _ release.Repository = new(FakeRepository)
