/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright 2019 Red Hat, Inc.
 *
 */
// Code generated by informer-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	time "time"

	machinev1beta1 "github.com/openshift/machine-api-operator/pkg/apis/machine/v1beta1"
	versioned "github.com/openshift/machine-api-operator/pkg/generated/clientset/versioned"
	internalinterfaces "github.com/openshift/machine-api-operator/pkg/generated/informers/externalversions/internalinterfaces"
	v1beta1 "github.com/openshift/machine-api-operator/pkg/generated/listers/machine/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// MachineHealthCheckInformer provides access to a shared informer and lister for
// MachineHealthChecks.
type MachineHealthCheckInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1beta1.MachineHealthCheckLister
}

type machineHealthCheckInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewMachineHealthCheckInformer constructs a new informer for MachineHealthCheck type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewMachineHealthCheckInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredMachineHealthCheckInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredMachineHealthCheckInformer constructs a new informer for MachineHealthCheck type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredMachineHealthCheckInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.MachineV1beta1().MachineHealthChecks(namespace).List(context.TODO(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.MachineV1beta1().MachineHealthChecks(namespace).Watch(context.TODO(), options)
			},
		},
		&machinev1beta1.MachineHealthCheck{},
		resyncPeriod,
		indexers,
	)
}

func (f *machineHealthCheckInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredMachineHealthCheckInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *machineHealthCheckInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&machinev1beta1.MachineHealthCheck{}, f.defaultInformer)
}

func (f *machineHealthCheckInformer) Lister() v1beta1.MachineHealthCheckLister {
	return v1beta1.NewMachineHealthCheckLister(f.Informer().GetIndexer())
}
