# grpc_recovery
`import "github.com/grpc-ecosystem/go-grpc-middleware/recovery"`

* [Overview](#pkg-overview)
* [Imported Packages](#pkg-imports)
* [Index](#pkg-index)
* [Examples](#pkg-examples)

## <a name="pkg-overview">Overview</a>
`grpc_recovery` are intereceptors that recover from gRPC handler panics.

### Server Side Recovery Middleware
By default a panic will be converted into a gRPC error with `code.Internal`.

Handling can be customised by providing an alternate recovery function.

Please see examples for simple examples of use.

#### Example:

<details>
<summary>Click to expand code.</summary>

```go
package grpc_recovery_test

import (
    "github.com/grpc-ecosystem/go-grpc-middleware"
    "github.com/grpc-ecosystem/go-grpc-middleware/recovery"
    "google.golang.org/grpc"
)

var (
    customFunc grpc_recovery.RecoveryHandlerFunc
)

// Initialization shows an initialization sequence with a custom recovery handler func.
func Example_initialization() {
    // Shared options for the logger, with a custom gRPC code to log level function.
    opts := []grpc_recovery.Option{
        grpc_recovery.WithRecoveryHandler(customFunc),
    }
    // Create a server. Recovery handlers should typically be last in the chain so that other middleware
    // (e.g. logging) can operate on the recovered state instead of being directly affected by any panic
    _ = grpc.NewServer(
        grpc_middleware.WithUnaryServerChain(
            grpc_recovery.UnaryServerInterceptor(opts...),
        ),
        grpc_middleware.WithStreamServerChain(
            grpc_recovery.StreamServerInterceptor(opts...),
        ),
    )
}
```

</details>

## <a name="pkg-imports">Imported Packages</a>

- [golang.org/x/net/context](https://godoc.org/golang.org/x/net/context)
- [google.golang.org/grpc](https://godoc.org/google.golang.org/grpc)
- [google.golang.org/grpc/codes](https://godoc.org/google.golang.org/grpc/codes)

## <a name="pkg-index">Index</a>
* [func StreamServerInterceptor(opts ...Option) grpc.StreamServerInterceptor](#StreamServerInterceptor)
* [func UnaryServerInterceptor(opts ...Option) grpc.UnaryServerInterceptor](#UnaryServerInterceptor)
* [type Option](#Option)
  * [func WithRecoveryHandler(f RecoveryHandlerFunc) Option](#WithRecoveryHandler)
* [type RecoveryHandlerFunc](#RecoveryHandlerFunc)

#### <a name="pkg-examples">Examples</a>
* [Package (Initialization)](#example__initialization)

#### <a name="pkg-files">Package files</a>
[doc.go](./doc.go) [interceptors.go](./interceptors.go) [options.go](./options.go) 

## <a name="StreamServerInterceptor">func</a> [StreamServerInterceptor](./interceptors.go#L30)
``` go
func StreamServerInterceptor(opts ...Option) grpc.StreamServerInterceptor
```
StreamServerInterceptor returns a new streaming server interceptor for panic recovery.

## <a name="UnaryServerInterceptor">func</a> [UnaryServerInterceptor](./interceptors.go#L16)
``` go
func UnaryServerInterceptor(opts ...Option) grpc.UnaryServerInterceptor
```
UnaryServerInterceptor returns a new unary server interceptor for panic recovery.

## <a name="Option">type</a> [Option](./options.go#L25)
``` go
type Option func(*options)
```

### <a name="WithRecoveryHandler">func</a> [WithRecoveryHandler](./options.go#L28)
``` go
func WithRecoveryHandler(f RecoveryHandlerFunc) Option
```
WithRecoveryHandler customizes the function for recovering from a panic.

## <a name="RecoveryHandlerFunc">type</a> [RecoveryHandlerFunc](./interceptors.go#L13)
``` go
type RecoveryHandlerFunc func(p interface{}) (err error)
```
RecoveryHandlerFunc is a function that recovers from the panic `p` by returning an `error`.

- - -
Generated by [godoc2ghmd](https://github.com/GandalfUK/godoc2ghmd)