// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lexmodelbuildingservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateBotVersion = "CreateBotVersion"

// CreateBotVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateBotVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBotVersion for more information on using the CreateBotVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBotVersionRequest method.
//    req, resp := client.CreateBotVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/CreateBotVersion
func (c *LexModelBuildingService) CreateBotVersionRequest(input *CreateBotVersionInput) (req *request.Request, output *CreateBotVersionOutput) {
	op := &request.Operation{
		Name:       opCreateBotVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{name}/versions",
	}

	if input == nil {
		input = &CreateBotVersionInput{}
	}

	output = &CreateBotVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBotVersion API operation for Amazon Lex Model Building Service.
//
// Creates a new version of the bot based on the $LATEST version. If the $LATEST
// version of this resource hasn't changed since you created the last version,
// Amazon Lex doesn't create a new version. It returns the last created version.
//
// You can update only the $LATEST version of the bot. You can't update the
// numbered versions that you create with the CreateBotVersion operation.
//
// When you create the first version of a bot, Amazon Lex sets the version to
// 1. Subsequent versions increment by 1. For more information, see versioning-intro.
//
// This operation requires permission for the lex:CreateBotVersion action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation CreateBotVersion for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
//   * PreconditionFailedException
//   The checksum of the resource that you are trying to change does not match
//   the checksum in the request. Check the resource's checksum and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/CreateBotVersion
func (c *LexModelBuildingService) CreateBotVersion(input *CreateBotVersionInput) (*CreateBotVersionOutput, error) {
	req, out := c.CreateBotVersionRequest(input)
	return out, req.Send()
}

// CreateBotVersionWithContext is the same as CreateBotVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBotVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) CreateBotVersionWithContext(ctx aws.Context, input *CreateBotVersionInput, opts ...request.Option) (*CreateBotVersionOutput, error) {
	req, out := c.CreateBotVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIntentVersion = "CreateIntentVersion"

// CreateIntentVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateIntentVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIntentVersion for more information on using the CreateIntentVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIntentVersionRequest method.
//    req, resp := client.CreateIntentVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/CreateIntentVersion
func (c *LexModelBuildingService) CreateIntentVersionRequest(input *CreateIntentVersionInput) (req *request.Request, output *CreateIntentVersionOutput) {
	op := &request.Operation{
		Name:       opCreateIntentVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/intents/{name}/versions",
	}

	if input == nil {
		input = &CreateIntentVersionInput{}
	}

	output = &CreateIntentVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIntentVersion API operation for Amazon Lex Model Building Service.
//
// Creates a new version of an intent based on the $LATEST version of the intent.
// If the $LATEST version of this intent hasn't changed since you last updated
// it, Amazon Lex doesn't create a new version. It returns the last version
// you created.
//
// You can update only the $LATEST version of the intent. You can't update the
// numbered versions that you create with the CreateIntentVersion operation.
//
// When you create a version of an intent, Amazon Lex sets the version to 1.
// Subsequent versions increment by 1. For more information, see versioning-intro.
//
// This operation requires permissions to perform the lex:CreateIntentVersion
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation CreateIntentVersion for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
//   * PreconditionFailedException
//   The checksum of the resource that you are trying to change does not match
//   the checksum in the request. Check the resource's checksum and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/CreateIntentVersion
func (c *LexModelBuildingService) CreateIntentVersion(input *CreateIntentVersionInput) (*CreateIntentVersionOutput, error) {
	req, out := c.CreateIntentVersionRequest(input)
	return out, req.Send()
}

// CreateIntentVersionWithContext is the same as CreateIntentVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIntentVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) CreateIntentVersionWithContext(ctx aws.Context, input *CreateIntentVersionInput, opts ...request.Option) (*CreateIntentVersionOutput, error) {
	req, out := c.CreateIntentVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSlotTypeVersion = "CreateSlotTypeVersion"

// CreateSlotTypeVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateSlotTypeVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSlotTypeVersion for more information on using the CreateSlotTypeVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSlotTypeVersionRequest method.
//    req, resp := client.CreateSlotTypeVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/CreateSlotTypeVersion
func (c *LexModelBuildingService) CreateSlotTypeVersionRequest(input *CreateSlotTypeVersionInput) (req *request.Request, output *CreateSlotTypeVersionOutput) {
	op := &request.Operation{
		Name:       opCreateSlotTypeVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/slottypes/{name}/versions",
	}

	if input == nil {
		input = &CreateSlotTypeVersionInput{}
	}

	output = &CreateSlotTypeVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSlotTypeVersion API operation for Amazon Lex Model Building Service.
//
// Creates a new version of a slot type based on the $LATEST version of the
// specified slot type. If the $LATEST version of this resource has not changed
// since the last version that you created, Amazon Lex doesn't create a new
// version. It returns the last version that you created.
//
// You can update only the $LATEST version of a slot type. You can't update
// the numbered versions that you create with the CreateSlotTypeVersion operation.
//
// When you create a version of a slot type, Amazon Lex sets the version to
// 1. Subsequent versions increment by 1. For more information, see versioning-intro.
//
// This operation requires permissions for the lex:CreateSlotTypeVersion action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation CreateSlotTypeVersion for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
//   * PreconditionFailedException
//   The checksum of the resource that you are trying to change does not match
//   the checksum in the request. Check the resource's checksum and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/CreateSlotTypeVersion
func (c *LexModelBuildingService) CreateSlotTypeVersion(input *CreateSlotTypeVersionInput) (*CreateSlotTypeVersionOutput, error) {
	req, out := c.CreateSlotTypeVersionRequest(input)
	return out, req.Send()
}

// CreateSlotTypeVersionWithContext is the same as CreateSlotTypeVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSlotTypeVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) CreateSlotTypeVersionWithContext(ctx aws.Context, input *CreateSlotTypeVersionInput, opts ...request.Option) (*CreateSlotTypeVersionOutput, error) {
	req, out := c.CreateSlotTypeVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBot = "DeleteBot"

// DeleteBotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBot for more information on using the DeleteBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBotRequest method.
//    req, resp := client.DeleteBotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBot
func (c *LexModelBuildingService) DeleteBotRequest(input *DeleteBotInput) (req *request.Request, output *DeleteBotOutput) {
	op := &request.Operation{
		Name:       opDeleteBot,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{name}",
	}

	if input == nil {
		input = &DeleteBotInput{}
	}

	output = &DeleteBotOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBot API operation for Amazon Lex Model Building Service.
//
// Deletes all versions of the bot, including the $LATEST version. To delete
// a specific version of the bot, use the DeleteBotVersion operation. The DeleteBot
// operation doesn't immediately remove the bot schema. Instead, it is marked
// for deletion and removed later.
//
// Amazon Lex stores utterances indefinitely for improving the ability of your
// bot to respond to user inputs. These utterances are not removed when the
// bot is deleted. To remove the utterances, use the DeleteUtterances operation.
//
// If a bot has an alias, you can't delete it. Instead, the DeleteBot operation
// returns a ResourceInUseException exception that includes a reference to the
// alias that refers to the bot. To remove the reference to the bot, delete
// the alias. If you get the same exception again, delete the referring alias
// until the DeleteBot operation is successful.
//
// This operation requires permissions for the lex:DeleteBot action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation DeleteBot for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
//   * ResourceInUseException
//   The resource that you are attempting to delete is referred to by another
//   resource. Use this information to remove references to the resource that
//   you are trying to delete.
//
//   The body of the exception contains a JSON object that describes the resource.
//
//   { "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,
//
//   "resourceReference": {
//
//   "name": string, "version": string } }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBot
func (c *LexModelBuildingService) DeleteBot(input *DeleteBotInput) (*DeleteBotOutput, error) {
	req, out := c.DeleteBotRequest(input)
	return out, req.Send()
}

// DeleteBotWithContext is the same as DeleteBot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) DeleteBotWithContext(ctx aws.Context, input *DeleteBotInput, opts ...request.Option) (*DeleteBotOutput, error) {
	req, out := c.DeleteBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBotAlias = "DeleteBotAlias"

// DeleteBotAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBotAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBotAlias for more information on using the DeleteBotAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBotAliasRequest method.
//    req, resp := client.DeleteBotAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBotAlias
func (c *LexModelBuildingService) DeleteBotAliasRequest(input *DeleteBotAliasInput) (req *request.Request, output *DeleteBotAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteBotAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botName}/aliases/{name}",
	}

	if input == nil {
		input = &DeleteBotAliasInput{}
	}

	output = &DeleteBotAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBotAlias API operation for Amazon Lex Model Building Service.
//
// Deletes an alias for the specified bot.
//
// You can't delete an alias that is used in the association between a bot and
// a messaging channel. If an alias is used in a channel association, the DeleteBot
// operation returns a ResourceInUseException exception that includes a reference
// to the channel association that refers to the bot. You can remove the reference
// to the alias by deleting the channel association. If you get the same exception
// again, delete the referring association until the DeleteBotAlias operation
// is successful.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation DeleteBotAlias for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
//   * ResourceInUseException
//   The resource that you are attempting to delete is referred to by another
//   resource. Use this information to remove references to the resource that
//   you are trying to delete.
//
//   The body of the exception contains a JSON object that describes the resource.
//
//   { "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,
//
//   "resourceReference": {
//
//   "name": string, "version": string } }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBotAlias
func (c *LexModelBuildingService) DeleteBotAlias(input *DeleteBotAliasInput) (*DeleteBotAliasOutput, error) {
	req, out := c.DeleteBotAliasRequest(input)
	return out, req.Send()
}

// DeleteBotAliasWithContext is the same as DeleteBotAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBotAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) DeleteBotAliasWithContext(ctx aws.Context, input *DeleteBotAliasInput, opts ...request.Option) (*DeleteBotAliasOutput, error) {
	req, out := c.DeleteBotAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBotChannelAssociation = "DeleteBotChannelAssociation"

// DeleteBotChannelAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBotChannelAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBotChannelAssociation for more information on using the DeleteBotChannelAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBotChannelAssociationRequest method.
//    req, resp := client.DeleteBotChannelAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBotChannelAssociation
func (c *LexModelBuildingService) DeleteBotChannelAssociationRequest(input *DeleteBotChannelAssociationInput) (req *request.Request, output *DeleteBotChannelAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteBotChannelAssociation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botName}/aliases/{aliasName}/channels/{name}",
	}

	if input == nil {
		input = &DeleteBotChannelAssociationInput{}
	}

	output = &DeleteBotChannelAssociationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBotChannelAssociation API operation for Amazon Lex Model Building Service.
//
// Deletes the association between an Amazon Lex bot and a messaging platform.
//
// This operation requires permission for the lex:DeleteBotChannelAssociation
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation DeleteBotChannelAssociation for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBotChannelAssociation
func (c *LexModelBuildingService) DeleteBotChannelAssociation(input *DeleteBotChannelAssociationInput) (*DeleteBotChannelAssociationOutput, error) {
	req, out := c.DeleteBotChannelAssociationRequest(input)
	return out, req.Send()
}

// DeleteBotChannelAssociationWithContext is the same as DeleteBotChannelAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBotChannelAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) DeleteBotChannelAssociationWithContext(ctx aws.Context, input *DeleteBotChannelAssociationInput, opts ...request.Option) (*DeleteBotChannelAssociationOutput, error) {
	req, out := c.DeleteBotChannelAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBotVersion = "DeleteBotVersion"

// DeleteBotVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBotVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBotVersion for more information on using the DeleteBotVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBotVersionRequest method.
//    req, resp := client.DeleteBotVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBotVersion
func (c *LexModelBuildingService) DeleteBotVersionRequest(input *DeleteBotVersionInput) (req *request.Request, output *DeleteBotVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteBotVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{name}/versions/{version}",
	}

	if input == nil {
		input = &DeleteBotVersionInput{}
	}

	output = &DeleteBotVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBotVersion API operation for Amazon Lex Model Building Service.
//
// Deletes a specific version of a bot. To delete all versions of a bot, use
// the DeleteBot operation.
//
// This operation requires permissions for the lex:DeleteBotVersion action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation DeleteBotVersion for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
//   * ResourceInUseException
//   The resource that you are attempting to delete is referred to by another
//   resource. Use this information to remove references to the resource that
//   you are trying to delete.
//
//   The body of the exception contains a JSON object that describes the resource.
//
//   { "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,
//
//   "resourceReference": {
//
//   "name": string, "version": string } }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBotVersion
func (c *LexModelBuildingService) DeleteBotVersion(input *DeleteBotVersionInput) (*DeleteBotVersionOutput, error) {
	req, out := c.DeleteBotVersionRequest(input)
	return out, req.Send()
}

// DeleteBotVersionWithContext is the same as DeleteBotVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBotVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) DeleteBotVersionWithContext(ctx aws.Context, input *DeleteBotVersionInput, opts ...request.Option) (*DeleteBotVersionOutput, error) {
	req, out := c.DeleteBotVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIntent = "DeleteIntent"

// DeleteIntentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIntent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIntent for more information on using the DeleteIntent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIntentRequest method.
//    req, resp := client.DeleteIntentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteIntent
func (c *LexModelBuildingService) DeleteIntentRequest(input *DeleteIntentInput) (req *request.Request, output *DeleteIntentOutput) {
	op := &request.Operation{
		Name:       opDeleteIntent,
		HTTPMethod: "DELETE",
		HTTPPath:   "/intents/{name}",
	}

	if input == nil {
		input = &DeleteIntentInput{}
	}

	output = &DeleteIntentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIntent API operation for Amazon Lex Model Building Service.
//
// Deletes all versions of the intent, including the $LATEST version. To delete
// a specific version of the intent, use the DeleteIntentVersion operation.
//
// You can delete a version of an intent only if it is not referenced. To delete
// an intent that is referred to in one or more bots (see how-it-works), you
// must remove those references first.
//
// If you get the ResourceInUseException exception, it provides an example reference
// that shows where the intent is referenced. To remove the reference to the
// intent, either update the bot or delete it. If you get the same exception
// when you attempt to delete the intent again, repeat until the intent has
// no references and the call to DeleteIntent is successful.
//
// This operation requires permission for the lex:DeleteIntent action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation DeleteIntent for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
//   * ResourceInUseException
//   The resource that you are attempting to delete is referred to by another
//   resource. Use this information to remove references to the resource that
//   you are trying to delete.
//
//   The body of the exception contains a JSON object that describes the resource.
//
//   { "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,
//
//   "resourceReference": {
//
//   "name": string, "version": string } }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteIntent
func (c *LexModelBuildingService) DeleteIntent(input *DeleteIntentInput) (*DeleteIntentOutput, error) {
	req, out := c.DeleteIntentRequest(input)
	return out, req.Send()
}

// DeleteIntentWithContext is the same as DeleteIntent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIntent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) DeleteIntentWithContext(ctx aws.Context, input *DeleteIntentInput, opts ...request.Option) (*DeleteIntentOutput, error) {
	req, out := c.DeleteIntentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIntentVersion = "DeleteIntentVersion"

// DeleteIntentVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIntentVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIntentVersion for more information on using the DeleteIntentVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIntentVersionRequest method.
//    req, resp := client.DeleteIntentVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteIntentVersion
func (c *LexModelBuildingService) DeleteIntentVersionRequest(input *DeleteIntentVersionInput) (req *request.Request, output *DeleteIntentVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteIntentVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/intents/{name}/versions/{version}",
	}

	if input == nil {
		input = &DeleteIntentVersionInput{}
	}

	output = &DeleteIntentVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIntentVersion API operation for Amazon Lex Model Building Service.
//
// Deletes a specific version of an intent. To delete all versions of a intent,
// use the DeleteIntent operation.
//
// This operation requires permissions for the lex:DeleteIntentVersion action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation DeleteIntentVersion for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
//   * ResourceInUseException
//   The resource that you are attempting to delete is referred to by another
//   resource. Use this information to remove references to the resource that
//   you are trying to delete.
//
//   The body of the exception contains a JSON object that describes the resource.
//
//   { "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,
//
//   "resourceReference": {
//
//   "name": string, "version": string } }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteIntentVersion
func (c *LexModelBuildingService) DeleteIntentVersion(input *DeleteIntentVersionInput) (*DeleteIntentVersionOutput, error) {
	req, out := c.DeleteIntentVersionRequest(input)
	return out, req.Send()
}

// DeleteIntentVersionWithContext is the same as DeleteIntentVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIntentVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) DeleteIntentVersionWithContext(ctx aws.Context, input *DeleteIntentVersionInput, opts ...request.Option) (*DeleteIntentVersionOutput, error) {
	req, out := c.DeleteIntentVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSlotType = "DeleteSlotType"

// DeleteSlotTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSlotType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSlotType for more information on using the DeleteSlotType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSlotTypeRequest method.
//    req, resp := client.DeleteSlotTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteSlotType
func (c *LexModelBuildingService) DeleteSlotTypeRequest(input *DeleteSlotTypeInput) (req *request.Request, output *DeleteSlotTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteSlotType,
		HTTPMethod: "DELETE",
		HTTPPath:   "/slottypes/{name}",
	}

	if input == nil {
		input = &DeleteSlotTypeInput{}
	}

	output = &DeleteSlotTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSlotType API operation for Amazon Lex Model Building Service.
//
// Deletes all versions of the slot type, including the $LATEST version. To
// delete a specific version of the slot type, use the DeleteSlotTypeVersion
// operation.
//
// You can delete a version of a slot type only if it is not referenced. To
// delete a slot type that is referred to in one or more intents, you must remove
// those references first.
//
// If you get the ResourceInUseException exception, the exception provides an
// example reference that shows the intent where the slot type is referenced.
// To remove the reference to the slot type, either update the intent or delete
// it. If you get the same exception when you attempt to delete the slot type
// again, repeat until the slot type has no references and the DeleteSlotType
// call is successful.
//
// This operation requires permission for the lex:DeleteSlotType action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation DeleteSlotType for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
//   * ResourceInUseException
//   The resource that you are attempting to delete is referred to by another
//   resource. Use this information to remove references to the resource that
//   you are trying to delete.
//
//   The body of the exception contains a JSON object that describes the resource.
//
//   { "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,
//
//   "resourceReference": {
//
//   "name": string, "version": string } }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteSlotType
func (c *LexModelBuildingService) DeleteSlotType(input *DeleteSlotTypeInput) (*DeleteSlotTypeOutput, error) {
	req, out := c.DeleteSlotTypeRequest(input)
	return out, req.Send()
}

// DeleteSlotTypeWithContext is the same as DeleteSlotType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSlotType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) DeleteSlotTypeWithContext(ctx aws.Context, input *DeleteSlotTypeInput, opts ...request.Option) (*DeleteSlotTypeOutput, error) {
	req, out := c.DeleteSlotTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSlotTypeVersion = "DeleteSlotTypeVersion"

// DeleteSlotTypeVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSlotTypeVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSlotTypeVersion for more information on using the DeleteSlotTypeVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSlotTypeVersionRequest method.
//    req, resp := client.DeleteSlotTypeVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteSlotTypeVersion
func (c *LexModelBuildingService) DeleteSlotTypeVersionRequest(input *DeleteSlotTypeVersionInput) (req *request.Request, output *DeleteSlotTypeVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteSlotTypeVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/slottypes/{name}/version/{version}",
	}

	if input == nil {
		input = &DeleteSlotTypeVersionInput{}
	}

	output = &DeleteSlotTypeVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSlotTypeVersion API operation for Amazon Lex Model Building Service.
//
// Deletes a specific version of a slot type. To delete all versions of a slot
// type, use the DeleteSlotType operation.
//
// This operation requires permissions for the lex:DeleteSlotTypeVersion action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation DeleteSlotTypeVersion for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
//   * ResourceInUseException
//   The resource that you are attempting to delete is referred to by another
//   resource. Use this information to remove references to the resource that
//   you are trying to delete.
//
//   The body of the exception contains a JSON object that describes the resource.
//
//   { "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,
//
//   "resourceReference": {
//
//   "name": string, "version": string } }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteSlotTypeVersion
func (c *LexModelBuildingService) DeleteSlotTypeVersion(input *DeleteSlotTypeVersionInput) (*DeleteSlotTypeVersionOutput, error) {
	req, out := c.DeleteSlotTypeVersionRequest(input)
	return out, req.Send()
}

// DeleteSlotTypeVersionWithContext is the same as DeleteSlotTypeVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSlotTypeVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) DeleteSlotTypeVersionWithContext(ctx aws.Context, input *DeleteSlotTypeVersionInput, opts ...request.Option) (*DeleteSlotTypeVersionOutput, error) {
	req, out := c.DeleteSlotTypeVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUtterances = "DeleteUtterances"

// DeleteUtterancesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUtterances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUtterances for more information on using the DeleteUtterances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUtterancesRequest method.
//    req, resp := client.DeleteUtterancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteUtterances
func (c *LexModelBuildingService) DeleteUtterancesRequest(input *DeleteUtterancesInput) (req *request.Request, output *DeleteUtterancesOutput) {
	op := &request.Operation{
		Name:       opDeleteUtterances,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botName}/utterances/{userId}",
	}

	if input == nil {
		input = &DeleteUtterancesInput{}
	}

	output = &DeleteUtterancesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUtterances API operation for Amazon Lex Model Building Service.
//
// Deletes stored utterances.
//
// Amazon Lex stores the utterances that users send to your bot. Utterances
// are stored for 15 days for use with the GetUtterancesView operation, and
// then stored indefinitely for use in improving the ability of your bot to
// respond to user input.
//
// Use the DeleteUtterances operation to manually delete stored utterances for
// a specific user. When you use the DeleteUtterances operation, utterances
// stored for improving your bot's ability to respond to user input are deleted
// immediately. Utterances stored for use with the GetUtterancesView operation
// are deleted after 15 days.
//
// This operation requires permissions for the lex:DeleteUtterances action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation DeleteUtterances for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteUtterances
func (c *LexModelBuildingService) DeleteUtterances(input *DeleteUtterancesInput) (*DeleteUtterancesOutput, error) {
	req, out := c.DeleteUtterancesRequest(input)
	return out, req.Send()
}

// DeleteUtterancesWithContext is the same as DeleteUtterances with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUtterances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) DeleteUtterancesWithContext(ctx aws.Context, input *DeleteUtterancesInput, opts ...request.Option) (*DeleteUtterancesOutput, error) {
	req, out := c.DeleteUtterancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBot = "GetBot"

// GetBotRequest generates a "aws/request.Request" representing the
// client's request for the GetBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBot for more information on using the GetBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBotRequest method.
//    req, resp := client.GetBotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBot
func (c *LexModelBuildingService) GetBotRequest(input *GetBotInput) (req *request.Request, output *GetBotOutput) {
	op := &request.Operation{
		Name:       opGetBot,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{name}/versions/{versionoralias}",
	}

	if input == nil {
		input = &GetBotInput{}
	}

	output = &GetBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBot API operation for Amazon Lex Model Building Service.
//
// Returns metadata information for a specific bot. You must provide the bot
// name and the bot version or alias.
//
// This operation requires permissions for the lex:GetBot action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetBot for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBot
func (c *LexModelBuildingService) GetBot(input *GetBotInput) (*GetBotOutput, error) {
	req, out := c.GetBotRequest(input)
	return out, req.Send()
}

// GetBotWithContext is the same as GetBot with the addition of
// the ability to pass a context and additional request options.
//
// See GetBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetBotWithContext(ctx aws.Context, input *GetBotInput, opts ...request.Option) (*GetBotOutput, error) {
	req, out := c.GetBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBotAlias = "GetBotAlias"

// GetBotAliasRequest generates a "aws/request.Request" representing the
// client's request for the GetBotAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBotAlias for more information on using the GetBotAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBotAliasRequest method.
//    req, resp := client.GetBotAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotAlias
func (c *LexModelBuildingService) GetBotAliasRequest(input *GetBotAliasInput) (req *request.Request, output *GetBotAliasOutput) {
	op := &request.Operation{
		Name:       opGetBotAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botName}/aliases/{name}",
	}

	if input == nil {
		input = &GetBotAliasInput{}
	}

	output = &GetBotAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBotAlias API operation for Amazon Lex Model Building Service.
//
// Returns information about an Amazon Lex bot alias. For more information about
// aliases, see versioning-aliases.
//
// This operation requires permissions for the lex:GetBotAlias action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetBotAlias for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotAlias
func (c *LexModelBuildingService) GetBotAlias(input *GetBotAliasInput) (*GetBotAliasOutput, error) {
	req, out := c.GetBotAliasRequest(input)
	return out, req.Send()
}

// GetBotAliasWithContext is the same as GetBotAlias with the addition of
// the ability to pass a context and additional request options.
//
// See GetBotAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetBotAliasWithContext(ctx aws.Context, input *GetBotAliasInput, opts ...request.Option) (*GetBotAliasOutput, error) {
	req, out := c.GetBotAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBotAliases = "GetBotAliases"

// GetBotAliasesRequest generates a "aws/request.Request" representing the
// client's request for the GetBotAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBotAliases for more information on using the GetBotAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBotAliasesRequest method.
//    req, resp := client.GetBotAliasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotAliases
func (c *LexModelBuildingService) GetBotAliasesRequest(input *GetBotAliasesInput) (req *request.Request, output *GetBotAliasesOutput) {
	op := &request.Operation{
		Name:       opGetBotAliases,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botName}/aliases/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetBotAliasesInput{}
	}

	output = &GetBotAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBotAliases API operation for Amazon Lex Model Building Service.
//
// Returns a list of aliases for a specified Amazon Lex bot.
//
// This operation requires permissions for the lex:GetBotAliases action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetBotAliases for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotAliases
func (c *LexModelBuildingService) GetBotAliases(input *GetBotAliasesInput) (*GetBotAliasesOutput, error) {
	req, out := c.GetBotAliasesRequest(input)
	return out, req.Send()
}

// GetBotAliasesWithContext is the same as GetBotAliases with the addition of
// the ability to pass a context and additional request options.
//
// See GetBotAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetBotAliasesWithContext(ctx aws.Context, input *GetBotAliasesInput, opts ...request.Option) (*GetBotAliasesOutput, error) {
	req, out := c.GetBotAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetBotAliasesPages iterates over the pages of a GetBotAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetBotAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetBotAliases operation.
//    pageNum := 0
//    err := client.GetBotAliasesPages(params,
//        func(page *lexmodelbuildingservice.GetBotAliasesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LexModelBuildingService) GetBotAliasesPages(input *GetBotAliasesInput, fn func(*GetBotAliasesOutput, bool) bool) error {
	return c.GetBotAliasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetBotAliasesPagesWithContext same as GetBotAliasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetBotAliasesPagesWithContext(ctx aws.Context, input *GetBotAliasesInput, fn func(*GetBotAliasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetBotAliasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetBotAliasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetBotAliasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetBotChannelAssociation = "GetBotChannelAssociation"

// GetBotChannelAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetBotChannelAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBotChannelAssociation for more information on using the GetBotChannelAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBotChannelAssociationRequest method.
//    req, resp := client.GetBotChannelAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotChannelAssociation
func (c *LexModelBuildingService) GetBotChannelAssociationRequest(input *GetBotChannelAssociationInput) (req *request.Request, output *GetBotChannelAssociationOutput) {
	op := &request.Operation{
		Name:       opGetBotChannelAssociation,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botName}/aliases/{aliasName}/channels/{name}",
	}

	if input == nil {
		input = &GetBotChannelAssociationInput{}
	}

	output = &GetBotChannelAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBotChannelAssociation API operation for Amazon Lex Model Building Service.
//
// Returns information about the association between an Amazon Lex bot and a
// messaging platform.
//
// This operation requires permissions for the lex:GetBotChannelAssociation
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetBotChannelAssociation for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotChannelAssociation
func (c *LexModelBuildingService) GetBotChannelAssociation(input *GetBotChannelAssociationInput) (*GetBotChannelAssociationOutput, error) {
	req, out := c.GetBotChannelAssociationRequest(input)
	return out, req.Send()
}

// GetBotChannelAssociationWithContext is the same as GetBotChannelAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetBotChannelAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetBotChannelAssociationWithContext(ctx aws.Context, input *GetBotChannelAssociationInput, opts ...request.Option) (*GetBotChannelAssociationOutput, error) {
	req, out := c.GetBotChannelAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBotChannelAssociations = "GetBotChannelAssociations"

// GetBotChannelAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the GetBotChannelAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBotChannelAssociations for more information on using the GetBotChannelAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBotChannelAssociationsRequest method.
//    req, resp := client.GetBotChannelAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotChannelAssociations
func (c *LexModelBuildingService) GetBotChannelAssociationsRequest(input *GetBotChannelAssociationsInput) (req *request.Request, output *GetBotChannelAssociationsOutput) {
	op := &request.Operation{
		Name:       opGetBotChannelAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botName}/aliases/{aliasName}/channels/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetBotChannelAssociationsInput{}
	}

	output = &GetBotChannelAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBotChannelAssociations API operation for Amazon Lex Model Building Service.
//
// Returns a list of all of the channels associated with the specified bot.
//
// The GetBotChannelAssociations operation requires permissions for the lex:GetBotChannelAssociations
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetBotChannelAssociations for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotChannelAssociations
func (c *LexModelBuildingService) GetBotChannelAssociations(input *GetBotChannelAssociationsInput) (*GetBotChannelAssociationsOutput, error) {
	req, out := c.GetBotChannelAssociationsRequest(input)
	return out, req.Send()
}

// GetBotChannelAssociationsWithContext is the same as GetBotChannelAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See GetBotChannelAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetBotChannelAssociationsWithContext(ctx aws.Context, input *GetBotChannelAssociationsInput, opts ...request.Option) (*GetBotChannelAssociationsOutput, error) {
	req, out := c.GetBotChannelAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetBotChannelAssociationsPages iterates over the pages of a GetBotChannelAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetBotChannelAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetBotChannelAssociations operation.
//    pageNum := 0
//    err := client.GetBotChannelAssociationsPages(params,
//        func(page *lexmodelbuildingservice.GetBotChannelAssociationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LexModelBuildingService) GetBotChannelAssociationsPages(input *GetBotChannelAssociationsInput, fn func(*GetBotChannelAssociationsOutput, bool) bool) error {
	return c.GetBotChannelAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetBotChannelAssociationsPagesWithContext same as GetBotChannelAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetBotChannelAssociationsPagesWithContext(ctx aws.Context, input *GetBotChannelAssociationsInput, fn func(*GetBotChannelAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetBotChannelAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetBotChannelAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetBotChannelAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetBotVersions = "GetBotVersions"

// GetBotVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetBotVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBotVersions for more information on using the GetBotVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBotVersionsRequest method.
//    req, resp := client.GetBotVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotVersions
func (c *LexModelBuildingService) GetBotVersionsRequest(input *GetBotVersionsInput) (req *request.Request, output *GetBotVersionsOutput) {
	op := &request.Operation{
		Name:       opGetBotVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{name}/versions/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetBotVersionsInput{}
	}

	output = &GetBotVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBotVersions API operation for Amazon Lex Model Building Service.
//
// Gets information about all of the versions of a bot.
//
// The GetBotVersions operation returns a BotMetadata object for each version
// of a bot. For example, if a bot has three numbered versions, the GetBotVersions
// operation returns four BotMetadata objects in the response, one for each
// numbered version and one for the $LATEST version.
//
// The GetBotVersions operation always returns at least one version, the $LATEST
// version.
//
// This operation requires permissions for the lex:GetBotVersions action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetBotVersions for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotVersions
func (c *LexModelBuildingService) GetBotVersions(input *GetBotVersionsInput) (*GetBotVersionsOutput, error) {
	req, out := c.GetBotVersionsRequest(input)
	return out, req.Send()
}

// GetBotVersionsWithContext is the same as GetBotVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetBotVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetBotVersionsWithContext(ctx aws.Context, input *GetBotVersionsInput, opts ...request.Option) (*GetBotVersionsOutput, error) {
	req, out := c.GetBotVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetBotVersionsPages iterates over the pages of a GetBotVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetBotVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetBotVersions operation.
//    pageNum := 0
//    err := client.GetBotVersionsPages(params,
//        func(page *lexmodelbuildingservice.GetBotVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LexModelBuildingService) GetBotVersionsPages(input *GetBotVersionsInput, fn func(*GetBotVersionsOutput, bool) bool) error {
	return c.GetBotVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetBotVersionsPagesWithContext same as GetBotVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetBotVersionsPagesWithContext(ctx aws.Context, input *GetBotVersionsInput, fn func(*GetBotVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetBotVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetBotVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetBotVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetBots = "GetBots"

// GetBotsRequest generates a "aws/request.Request" representing the
// client's request for the GetBots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBots for more information on using the GetBots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBotsRequest method.
//    req, resp := client.GetBotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBots
func (c *LexModelBuildingService) GetBotsRequest(input *GetBotsInput) (req *request.Request, output *GetBotsOutput) {
	op := &request.Operation{
		Name:       opGetBots,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetBotsInput{}
	}

	output = &GetBotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBots API operation for Amazon Lex Model Building Service.
//
// Returns bot information as follows:
//
//    * If you provide the nameContains field, the response includes information
//    for the $LATEST version of all bots whose name contains the specified
//    string.
//
//    * If you don't specify the nameContains field, the operation returns information
//    about the $LATEST version of all of your bots.
//
// This operation requires permission for the lex:GetBots action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetBots for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBots
func (c *LexModelBuildingService) GetBots(input *GetBotsInput) (*GetBotsOutput, error) {
	req, out := c.GetBotsRequest(input)
	return out, req.Send()
}

// GetBotsWithContext is the same as GetBots with the addition of
// the ability to pass a context and additional request options.
//
// See GetBots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetBotsWithContext(ctx aws.Context, input *GetBotsInput, opts ...request.Option) (*GetBotsOutput, error) {
	req, out := c.GetBotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetBotsPages iterates over the pages of a GetBots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetBots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetBots operation.
//    pageNum := 0
//    err := client.GetBotsPages(params,
//        func(page *lexmodelbuildingservice.GetBotsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LexModelBuildingService) GetBotsPages(input *GetBotsInput, fn func(*GetBotsOutput, bool) bool) error {
	return c.GetBotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetBotsPagesWithContext same as GetBotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetBotsPagesWithContext(ctx aws.Context, input *GetBotsInput, fn func(*GetBotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetBotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetBotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetBotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetBuiltinIntent = "GetBuiltinIntent"

// GetBuiltinIntentRequest generates a "aws/request.Request" representing the
// client's request for the GetBuiltinIntent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBuiltinIntent for more information on using the GetBuiltinIntent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBuiltinIntentRequest method.
//    req, resp := client.GetBuiltinIntentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinIntent
func (c *LexModelBuildingService) GetBuiltinIntentRequest(input *GetBuiltinIntentInput) (req *request.Request, output *GetBuiltinIntentOutput) {
	op := &request.Operation{
		Name:       opGetBuiltinIntent,
		HTTPMethod: "GET",
		HTTPPath:   "/builtins/intents/{signature}",
	}

	if input == nil {
		input = &GetBuiltinIntentInput{}
	}

	output = &GetBuiltinIntentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBuiltinIntent API operation for Amazon Lex Model Building Service.
//
// Returns information about a built-in intent.
//
// This operation requires permission for the lex:GetBuiltinIntent action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetBuiltinIntent for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinIntent
func (c *LexModelBuildingService) GetBuiltinIntent(input *GetBuiltinIntentInput) (*GetBuiltinIntentOutput, error) {
	req, out := c.GetBuiltinIntentRequest(input)
	return out, req.Send()
}

// GetBuiltinIntentWithContext is the same as GetBuiltinIntent with the addition of
// the ability to pass a context and additional request options.
//
// See GetBuiltinIntent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetBuiltinIntentWithContext(ctx aws.Context, input *GetBuiltinIntentInput, opts ...request.Option) (*GetBuiltinIntentOutput, error) {
	req, out := c.GetBuiltinIntentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBuiltinIntents = "GetBuiltinIntents"

// GetBuiltinIntentsRequest generates a "aws/request.Request" representing the
// client's request for the GetBuiltinIntents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBuiltinIntents for more information on using the GetBuiltinIntents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBuiltinIntentsRequest method.
//    req, resp := client.GetBuiltinIntentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinIntents
func (c *LexModelBuildingService) GetBuiltinIntentsRequest(input *GetBuiltinIntentsInput) (req *request.Request, output *GetBuiltinIntentsOutput) {
	op := &request.Operation{
		Name:       opGetBuiltinIntents,
		HTTPMethod: "GET",
		HTTPPath:   "/builtins/intents/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetBuiltinIntentsInput{}
	}

	output = &GetBuiltinIntentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBuiltinIntents API operation for Amazon Lex Model Building Service.
//
// Gets a list of built-in intents that meet the specified criteria.
//
// This operation requires permission for the lex:GetBuiltinIntents action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetBuiltinIntents for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinIntents
func (c *LexModelBuildingService) GetBuiltinIntents(input *GetBuiltinIntentsInput) (*GetBuiltinIntentsOutput, error) {
	req, out := c.GetBuiltinIntentsRequest(input)
	return out, req.Send()
}

// GetBuiltinIntentsWithContext is the same as GetBuiltinIntents with the addition of
// the ability to pass a context and additional request options.
//
// See GetBuiltinIntents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetBuiltinIntentsWithContext(ctx aws.Context, input *GetBuiltinIntentsInput, opts ...request.Option) (*GetBuiltinIntentsOutput, error) {
	req, out := c.GetBuiltinIntentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetBuiltinIntentsPages iterates over the pages of a GetBuiltinIntents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetBuiltinIntents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetBuiltinIntents operation.
//    pageNum := 0
//    err := client.GetBuiltinIntentsPages(params,
//        func(page *lexmodelbuildingservice.GetBuiltinIntentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LexModelBuildingService) GetBuiltinIntentsPages(input *GetBuiltinIntentsInput, fn func(*GetBuiltinIntentsOutput, bool) bool) error {
	return c.GetBuiltinIntentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetBuiltinIntentsPagesWithContext same as GetBuiltinIntentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetBuiltinIntentsPagesWithContext(ctx aws.Context, input *GetBuiltinIntentsInput, fn func(*GetBuiltinIntentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetBuiltinIntentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetBuiltinIntentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetBuiltinIntentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetBuiltinSlotTypes = "GetBuiltinSlotTypes"

// GetBuiltinSlotTypesRequest generates a "aws/request.Request" representing the
// client's request for the GetBuiltinSlotTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBuiltinSlotTypes for more information on using the GetBuiltinSlotTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBuiltinSlotTypesRequest method.
//    req, resp := client.GetBuiltinSlotTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinSlotTypes
func (c *LexModelBuildingService) GetBuiltinSlotTypesRequest(input *GetBuiltinSlotTypesInput) (req *request.Request, output *GetBuiltinSlotTypesOutput) {
	op := &request.Operation{
		Name:       opGetBuiltinSlotTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/builtins/slottypes/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetBuiltinSlotTypesInput{}
	}

	output = &GetBuiltinSlotTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBuiltinSlotTypes API operation for Amazon Lex Model Building Service.
//
// Gets a list of built-in slot types that meet the specified criteria.
//
// For a list of built-in slot types, see Slot Type Reference (https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference)
// in the Alexa Skills Kit.
//
// This operation requires permission for the lex:GetBuiltInSlotTypes action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetBuiltinSlotTypes for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinSlotTypes
func (c *LexModelBuildingService) GetBuiltinSlotTypes(input *GetBuiltinSlotTypesInput) (*GetBuiltinSlotTypesOutput, error) {
	req, out := c.GetBuiltinSlotTypesRequest(input)
	return out, req.Send()
}

// GetBuiltinSlotTypesWithContext is the same as GetBuiltinSlotTypes with the addition of
// the ability to pass a context and additional request options.
//
// See GetBuiltinSlotTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetBuiltinSlotTypesWithContext(ctx aws.Context, input *GetBuiltinSlotTypesInput, opts ...request.Option) (*GetBuiltinSlotTypesOutput, error) {
	req, out := c.GetBuiltinSlotTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetBuiltinSlotTypesPages iterates over the pages of a GetBuiltinSlotTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetBuiltinSlotTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetBuiltinSlotTypes operation.
//    pageNum := 0
//    err := client.GetBuiltinSlotTypesPages(params,
//        func(page *lexmodelbuildingservice.GetBuiltinSlotTypesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LexModelBuildingService) GetBuiltinSlotTypesPages(input *GetBuiltinSlotTypesInput, fn func(*GetBuiltinSlotTypesOutput, bool) bool) error {
	return c.GetBuiltinSlotTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetBuiltinSlotTypesPagesWithContext same as GetBuiltinSlotTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetBuiltinSlotTypesPagesWithContext(ctx aws.Context, input *GetBuiltinSlotTypesInput, fn func(*GetBuiltinSlotTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetBuiltinSlotTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetBuiltinSlotTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetBuiltinSlotTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetExport = "GetExport"

// GetExportRequest generates a "aws/request.Request" representing the
// client's request for the GetExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExport for more information on using the GetExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetExportRequest method.
//    req, resp := client.GetExportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetExport
func (c *LexModelBuildingService) GetExportRequest(input *GetExportInput) (req *request.Request, output *GetExportOutput) {
	op := &request.Operation{
		Name:       opGetExport,
		HTTPMethod: "GET",
		HTTPPath:   "/exports/",
	}

	if input == nil {
		input = &GetExportInput{}
	}

	output = &GetExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExport API operation for Amazon Lex Model Building Service.
//
// Exports the contents of a Amazon Lex resource in a specified format.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetExport for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetExport
func (c *LexModelBuildingService) GetExport(input *GetExportInput) (*GetExportOutput, error) {
	req, out := c.GetExportRequest(input)
	return out, req.Send()
}

// GetExportWithContext is the same as GetExport with the addition of
// the ability to pass a context and additional request options.
//
// See GetExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetExportWithContext(ctx aws.Context, input *GetExportInput, opts ...request.Option) (*GetExportOutput, error) {
	req, out := c.GetExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetImport = "GetImport"

// GetImportRequest generates a "aws/request.Request" representing the
// client's request for the GetImport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetImport for more information on using the GetImport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetImportRequest method.
//    req, resp := client.GetImportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetImport
func (c *LexModelBuildingService) GetImportRequest(input *GetImportInput) (req *request.Request, output *GetImportOutput) {
	op := &request.Operation{
		Name:       opGetImport,
		HTTPMethod: "GET",
		HTTPPath:   "/imports/{importId}",
	}

	if input == nil {
		input = &GetImportInput{}
	}

	output = &GetImportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetImport API operation for Amazon Lex Model Building Service.
//
// Gets information about an import job started with the StartImport operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetImport for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetImport
func (c *LexModelBuildingService) GetImport(input *GetImportInput) (*GetImportOutput, error) {
	req, out := c.GetImportRequest(input)
	return out, req.Send()
}

// GetImportWithContext is the same as GetImport with the addition of
// the ability to pass a context and additional request options.
//
// See GetImport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetImportWithContext(ctx aws.Context, input *GetImportInput, opts ...request.Option) (*GetImportOutput, error) {
	req, out := c.GetImportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIntent = "GetIntent"

// GetIntentRequest generates a "aws/request.Request" representing the
// client's request for the GetIntent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIntent for more information on using the GetIntent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIntentRequest method.
//    req, resp := client.GetIntentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntent
func (c *LexModelBuildingService) GetIntentRequest(input *GetIntentInput) (req *request.Request, output *GetIntentOutput) {
	op := &request.Operation{
		Name:       opGetIntent,
		HTTPMethod: "GET",
		HTTPPath:   "/intents/{name}/versions/{version}",
	}

	if input == nil {
		input = &GetIntentInput{}
	}

	output = &GetIntentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIntent API operation for Amazon Lex Model Building Service.
//
// Returns information about an intent. In addition to the intent name, you
// must specify the intent version.
//
// This operation requires permissions to perform the lex:GetIntent action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetIntent for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntent
func (c *LexModelBuildingService) GetIntent(input *GetIntentInput) (*GetIntentOutput, error) {
	req, out := c.GetIntentRequest(input)
	return out, req.Send()
}

// GetIntentWithContext is the same as GetIntent with the addition of
// the ability to pass a context and additional request options.
//
// See GetIntent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetIntentWithContext(ctx aws.Context, input *GetIntentInput, opts ...request.Option) (*GetIntentOutput, error) {
	req, out := c.GetIntentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIntentVersions = "GetIntentVersions"

// GetIntentVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetIntentVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIntentVersions for more information on using the GetIntentVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIntentVersionsRequest method.
//    req, resp := client.GetIntentVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntentVersions
func (c *LexModelBuildingService) GetIntentVersionsRequest(input *GetIntentVersionsInput) (req *request.Request, output *GetIntentVersionsOutput) {
	op := &request.Operation{
		Name:       opGetIntentVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/intents/{name}/versions/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetIntentVersionsInput{}
	}

	output = &GetIntentVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIntentVersions API operation for Amazon Lex Model Building Service.
//
// Gets information about all of the versions of an intent.
//
// The GetIntentVersions operation returns an IntentMetadata object for each
// version of an intent. For example, if an intent has three numbered versions,
// the GetIntentVersions operation returns four IntentMetadata objects in the
// response, one for each numbered version and one for the $LATEST version.
//
// The GetIntentVersions operation always returns at least one version, the
// $LATEST version.
//
// This operation requires permissions for the lex:GetIntentVersions action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetIntentVersions for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntentVersions
func (c *LexModelBuildingService) GetIntentVersions(input *GetIntentVersionsInput) (*GetIntentVersionsOutput, error) {
	req, out := c.GetIntentVersionsRequest(input)
	return out, req.Send()
}

// GetIntentVersionsWithContext is the same as GetIntentVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetIntentVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetIntentVersionsWithContext(ctx aws.Context, input *GetIntentVersionsInput, opts ...request.Option) (*GetIntentVersionsOutput, error) {
	req, out := c.GetIntentVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetIntentVersionsPages iterates over the pages of a GetIntentVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetIntentVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetIntentVersions operation.
//    pageNum := 0
//    err := client.GetIntentVersionsPages(params,
//        func(page *lexmodelbuildingservice.GetIntentVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LexModelBuildingService) GetIntentVersionsPages(input *GetIntentVersionsInput, fn func(*GetIntentVersionsOutput, bool) bool) error {
	return c.GetIntentVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetIntentVersionsPagesWithContext same as GetIntentVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetIntentVersionsPagesWithContext(ctx aws.Context, input *GetIntentVersionsInput, fn func(*GetIntentVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetIntentVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetIntentVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetIntentVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetIntents = "GetIntents"

// GetIntentsRequest generates a "aws/request.Request" representing the
// client's request for the GetIntents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIntents for more information on using the GetIntents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIntentsRequest method.
//    req, resp := client.GetIntentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntents
func (c *LexModelBuildingService) GetIntentsRequest(input *GetIntentsInput) (req *request.Request, output *GetIntentsOutput) {
	op := &request.Operation{
		Name:       opGetIntents,
		HTTPMethod: "GET",
		HTTPPath:   "/intents/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetIntentsInput{}
	}

	output = &GetIntentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIntents API operation for Amazon Lex Model Building Service.
//
// Returns intent information as follows:
//
//    * If you specify the nameContains field, returns the $LATEST version of
//    all intents that contain the specified string.
//
//    * If you don't specify the nameContains field, returns information about
//    the $LATEST version of all intents.
//
// The operation requires permission for the lex:GetIntents action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetIntents for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntents
func (c *LexModelBuildingService) GetIntents(input *GetIntentsInput) (*GetIntentsOutput, error) {
	req, out := c.GetIntentsRequest(input)
	return out, req.Send()
}

// GetIntentsWithContext is the same as GetIntents with the addition of
// the ability to pass a context and additional request options.
//
// See GetIntents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetIntentsWithContext(ctx aws.Context, input *GetIntentsInput, opts ...request.Option) (*GetIntentsOutput, error) {
	req, out := c.GetIntentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetIntentsPages iterates over the pages of a GetIntents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetIntents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetIntents operation.
//    pageNum := 0
//    err := client.GetIntentsPages(params,
//        func(page *lexmodelbuildingservice.GetIntentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LexModelBuildingService) GetIntentsPages(input *GetIntentsInput, fn func(*GetIntentsOutput, bool) bool) error {
	return c.GetIntentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetIntentsPagesWithContext same as GetIntentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetIntentsPagesWithContext(ctx aws.Context, input *GetIntentsInput, fn func(*GetIntentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetIntentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetIntentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetIntentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetSlotType = "GetSlotType"

// GetSlotTypeRequest generates a "aws/request.Request" representing the
// client's request for the GetSlotType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSlotType for more information on using the GetSlotType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSlotTypeRequest method.
//    req, resp := client.GetSlotTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetSlotType
func (c *LexModelBuildingService) GetSlotTypeRequest(input *GetSlotTypeInput) (req *request.Request, output *GetSlotTypeOutput) {
	op := &request.Operation{
		Name:       opGetSlotType,
		HTTPMethod: "GET",
		HTTPPath:   "/slottypes/{name}/versions/{version}",
	}

	if input == nil {
		input = &GetSlotTypeInput{}
	}

	output = &GetSlotTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSlotType API operation for Amazon Lex Model Building Service.
//
// Returns information about a specific version of a slot type. In addition
// to specifying the slot type name, you must specify the slot type version.
//
// This operation requires permissions for the lex:GetSlotType action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetSlotType for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetSlotType
func (c *LexModelBuildingService) GetSlotType(input *GetSlotTypeInput) (*GetSlotTypeOutput, error) {
	req, out := c.GetSlotTypeRequest(input)
	return out, req.Send()
}

// GetSlotTypeWithContext is the same as GetSlotType with the addition of
// the ability to pass a context and additional request options.
//
// See GetSlotType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetSlotTypeWithContext(ctx aws.Context, input *GetSlotTypeInput, opts ...request.Option) (*GetSlotTypeOutput, error) {
	req, out := c.GetSlotTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSlotTypeVersions = "GetSlotTypeVersions"

// GetSlotTypeVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetSlotTypeVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSlotTypeVersions for more information on using the GetSlotTypeVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSlotTypeVersionsRequest method.
//    req, resp := client.GetSlotTypeVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetSlotTypeVersions
func (c *LexModelBuildingService) GetSlotTypeVersionsRequest(input *GetSlotTypeVersionsInput) (req *request.Request, output *GetSlotTypeVersionsOutput) {
	op := &request.Operation{
		Name:       opGetSlotTypeVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/slottypes/{name}/versions/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetSlotTypeVersionsInput{}
	}

	output = &GetSlotTypeVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSlotTypeVersions API operation for Amazon Lex Model Building Service.
//
// Gets information about all versions of a slot type.
//
// The GetSlotTypeVersions operation returns a SlotTypeMetadata object for each
// version of a slot type. For example, if a slot type has three numbered versions,
// the GetSlotTypeVersions operation returns four SlotTypeMetadata objects in
// the response, one for each numbered version and one for the $LATEST version.
//
// The GetSlotTypeVersions operation always returns at least one version, the
// $LATEST version.
//
// This operation requires permissions for the lex:GetSlotTypeVersions action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetSlotTypeVersions for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetSlotTypeVersions
func (c *LexModelBuildingService) GetSlotTypeVersions(input *GetSlotTypeVersionsInput) (*GetSlotTypeVersionsOutput, error) {
	req, out := c.GetSlotTypeVersionsRequest(input)
	return out, req.Send()
}

// GetSlotTypeVersionsWithContext is the same as GetSlotTypeVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetSlotTypeVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetSlotTypeVersionsWithContext(ctx aws.Context, input *GetSlotTypeVersionsInput, opts ...request.Option) (*GetSlotTypeVersionsOutput, error) {
	req, out := c.GetSlotTypeVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetSlotTypeVersionsPages iterates over the pages of a GetSlotTypeVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetSlotTypeVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetSlotTypeVersions operation.
//    pageNum := 0
//    err := client.GetSlotTypeVersionsPages(params,
//        func(page *lexmodelbuildingservice.GetSlotTypeVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LexModelBuildingService) GetSlotTypeVersionsPages(input *GetSlotTypeVersionsInput, fn func(*GetSlotTypeVersionsOutput, bool) bool) error {
	return c.GetSlotTypeVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetSlotTypeVersionsPagesWithContext same as GetSlotTypeVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetSlotTypeVersionsPagesWithContext(ctx aws.Context, input *GetSlotTypeVersionsInput, fn func(*GetSlotTypeVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetSlotTypeVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetSlotTypeVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetSlotTypeVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetSlotTypes = "GetSlotTypes"

// GetSlotTypesRequest generates a "aws/request.Request" representing the
// client's request for the GetSlotTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSlotTypes for more information on using the GetSlotTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSlotTypesRequest method.
//    req, resp := client.GetSlotTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetSlotTypes
func (c *LexModelBuildingService) GetSlotTypesRequest(input *GetSlotTypesInput) (req *request.Request, output *GetSlotTypesOutput) {
	op := &request.Operation{
		Name:       opGetSlotTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/slottypes/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetSlotTypesInput{}
	}

	output = &GetSlotTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSlotTypes API operation for Amazon Lex Model Building Service.
//
// Returns slot type information as follows:
//
//    * If you specify the nameContains field, returns the $LATEST version of
//    all slot types that contain the specified string.
//
//    * If you don't specify the nameContains field, returns information about
//    the $LATEST version of all slot types.
//
// The operation requires permission for the lex:GetSlotTypes action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetSlotTypes for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. Check the resource and
//   try again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetSlotTypes
func (c *LexModelBuildingService) GetSlotTypes(input *GetSlotTypesInput) (*GetSlotTypesOutput, error) {
	req, out := c.GetSlotTypesRequest(input)
	return out, req.Send()
}

// GetSlotTypesWithContext is the same as GetSlotTypes with the addition of
// the ability to pass a context and additional request options.
//
// See GetSlotTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetSlotTypesWithContext(ctx aws.Context, input *GetSlotTypesInput, opts ...request.Option) (*GetSlotTypesOutput, error) {
	req, out := c.GetSlotTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetSlotTypesPages iterates over the pages of a GetSlotTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetSlotTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetSlotTypes operation.
//    pageNum := 0
//    err := client.GetSlotTypesPages(params,
//        func(page *lexmodelbuildingservice.GetSlotTypesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LexModelBuildingService) GetSlotTypesPages(input *GetSlotTypesInput, fn func(*GetSlotTypesOutput, bool) bool) error {
	return c.GetSlotTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetSlotTypesPagesWithContext same as GetSlotTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetSlotTypesPagesWithContext(ctx aws.Context, input *GetSlotTypesInput, fn func(*GetSlotTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetSlotTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetSlotTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetSlotTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetUtterancesView = "GetUtterancesView"

// GetUtterancesViewRequest generates a "aws/request.Request" representing the
// client's request for the GetUtterancesView operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUtterancesView for more information on using the GetUtterancesView
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUtterancesViewRequest method.
//    req, resp := client.GetUtterancesViewRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetUtterancesView
func (c *LexModelBuildingService) GetUtterancesViewRequest(input *GetUtterancesViewInput) (req *request.Request, output *GetUtterancesViewOutput) {
	op := &request.Operation{
		Name:       opGetUtterancesView,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botname}/utterances?view=aggregation",
	}

	if input == nil {
		input = &GetUtterancesViewInput{}
	}

	output = &GetUtterancesViewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUtterancesView API operation for Amazon Lex Model Building Service.
//
// Use the GetUtterancesView operation to get information about the utterances
// that your users have made to your bot. You can use this list to tune the
// utterances that your bot responds to.
//
// For example, say that you have created a bot to order flowers. After your
// users have used your bot for a while, use the GetUtterancesView operation
// to see the requests that they have made and whether they have been successful.
// You might find that the utterance "I want flowers" is not being recognized.
// You could add this utterance to the OrderFlowers intent so that your bot
// recognizes that utterance.
//
// After you publish a new version of a bot, you can get information about the
// old version and the new so that you can compare the performance across the
// two versions.
//
// Utterance statistics are generated once a day. Data is available for the
// last 15 days. You can request information for up to 5 versions of your bot
// in each request. Amazon Lex returns the most frequent utterances received
// by the bot in the last 15 days. The response contains information about a
// maximum of 100 utterances for each version.
//
// If you set childDirected field to true when you created your bot, or if you
// opted out of participating in improving Amazon Lex, utterances are not available.
//
// This operation requires permissions for the lex:GetUtterancesView action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation GetUtterancesView for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetUtterancesView
func (c *LexModelBuildingService) GetUtterancesView(input *GetUtterancesViewInput) (*GetUtterancesViewOutput, error) {
	req, out := c.GetUtterancesViewRequest(input)
	return out, req.Send()
}

// GetUtterancesViewWithContext is the same as GetUtterancesView with the addition of
// the ability to pass a context and additional request options.
//
// See GetUtterancesView for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) GetUtterancesViewWithContext(ctx aws.Context, input *GetUtterancesViewInput, opts ...request.Option) (*GetUtterancesViewOutput, error) {
	req, out := c.GetUtterancesViewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBot = "PutBot"

// PutBotRequest generates a "aws/request.Request" representing the
// client's request for the PutBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBot for more information on using the PutBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBotRequest method.
//    req, resp := client.PutBotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutBot
func (c *LexModelBuildingService) PutBotRequest(input *PutBotInput) (req *request.Request, output *PutBotOutput) {
	op := &request.Operation{
		Name:       opPutBot,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{name}/versions/$LATEST",
	}

	if input == nil {
		input = &PutBotInput{}
	}

	output = &PutBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutBot API operation for Amazon Lex Model Building Service.
//
// Creates an Amazon Lex conversational bot or replaces an existing bot. When
// you create or update a bot you are only required to specify a name, a locale,
// and whether the bot is directed toward children under age 13. You can use
// this to add intents later, or to remove intents from an existing bot. When
// you create a bot with the minimum information, the bot is created or updated
// but Amazon Lex returns the response FAILED. You can build the bot after you
// add one or more intents. For more information about Amazon Lex bots, see
// how-it-works.
//
// If you specify the name of an existing bot, the fields in the request replace
// the existing values in the $LATEST version of the bot. Amazon Lex removes
// any fields that you don't provide values for in the request, except for the
// idleTTLInSeconds and privacySettings fields, which are set to their default
// values. If you don't specify values for required fields, Amazon Lex throws
// an exception.
//
// This operation requires permissions for the lex:PutBot action. For more information,
// see security-iam.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation PutBot for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
//   * PreconditionFailedException
//   The checksum of the resource that you are trying to change does not match
//   the checksum in the request. Check the resource's checksum and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutBot
func (c *LexModelBuildingService) PutBot(input *PutBotInput) (*PutBotOutput, error) {
	req, out := c.PutBotRequest(input)
	return out, req.Send()
}

// PutBotWithContext is the same as PutBot with the addition of
// the ability to pass a context and additional request options.
//
// See PutBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) PutBotWithContext(ctx aws.Context, input *PutBotInput, opts ...request.Option) (*PutBotOutput, error) {
	req, out := c.PutBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBotAlias = "PutBotAlias"

// PutBotAliasRequest generates a "aws/request.Request" representing the
// client's request for the PutBotAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBotAlias for more information on using the PutBotAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBotAliasRequest method.
//    req, resp := client.PutBotAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutBotAlias
func (c *LexModelBuildingService) PutBotAliasRequest(input *PutBotAliasInput) (req *request.Request, output *PutBotAliasOutput) {
	op := &request.Operation{
		Name:       opPutBotAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botName}/aliases/{name}",
	}

	if input == nil {
		input = &PutBotAliasInput{}
	}

	output = &PutBotAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutBotAlias API operation for Amazon Lex Model Building Service.
//
// Creates an alias for the specified version of the bot or replaces an alias
// for the specified bot. To change the version of the bot that the alias points
// to, replace the alias. For more information about aliases, see versioning-aliases.
//
// This operation requires permissions for the lex:PutBotAlias action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation PutBotAlias for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
//   * PreconditionFailedException
//   The checksum of the resource that you are trying to change does not match
//   the checksum in the request. Check the resource's checksum and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutBotAlias
func (c *LexModelBuildingService) PutBotAlias(input *PutBotAliasInput) (*PutBotAliasOutput, error) {
	req, out := c.PutBotAliasRequest(input)
	return out, req.Send()
}

// PutBotAliasWithContext is the same as PutBotAlias with the addition of
// the ability to pass a context and additional request options.
//
// See PutBotAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) PutBotAliasWithContext(ctx aws.Context, input *PutBotAliasInput, opts ...request.Option) (*PutBotAliasOutput, error) {
	req, out := c.PutBotAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutIntent = "PutIntent"

// PutIntentRequest generates a "aws/request.Request" representing the
// client's request for the PutIntent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutIntent for more information on using the PutIntent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutIntentRequest method.
//    req, resp := client.PutIntentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutIntent
func (c *LexModelBuildingService) PutIntentRequest(input *PutIntentInput) (req *request.Request, output *PutIntentOutput) {
	op := &request.Operation{
		Name:       opPutIntent,
		HTTPMethod: "PUT",
		HTTPPath:   "/intents/{name}/versions/$LATEST",
	}

	if input == nil {
		input = &PutIntentInput{}
	}

	output = &PutIntentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutIntent API operation for Amazon Lex Model Building Service.
//
// Creates an intent or replaces an existing intent.
//
// To define the interaction between the user and your bot, you use one or more
// intents. For a pizza ordering bot, for example, you would create an OrderPizza
// intent.
//
// To create an intent or replace an existing intent, you must provide the following:
//
//    * Intent name. For example, OrderPizza.
//
//    * Sample utterances. For example, "Can I order a pizza, please." and "I
//    want to order a pizza."
//
//    * Information to be gathered. You specify slot types for the information
//    that your bot will request from the user. You can specify standard slot
//    types, such as a date or a time, or custom slot types such as the size
//    and crust of a pizza.
//
//    * How the intent will be fulfilled. You can provide a Lambda function
//    or configure the intent to return the intent information to the client
//    application. If you use a Lambda function, when all of the intent information
//    is available, Amazon Lex invokes your Lambda function. If you configure
//    your intent to return the intent information to the client application.
//
// You can specify other optional information in the request, such as:
//
//    * A confirmation prompt to ask the user to confirm an intent. For example,
//    "Shall I order your pizza?"
//
//    * A conclusion statement to send to the user after the intent has been
//    fulfilled. For example, "I placed your pizza order."
//
//    * A follow-up prompt that asks the user for additional activity. For example,
//    asking "Do you want to order a drink with your pizza?"
//
// If you specify an existing intent name to update the intent, Amazon Lex replaces
// the values in the $LATEST version of the intent with the values in the request.
// Amazon Lex removes fields that you don't provide in the request. If you don't
// specify the required fields, Amazon Lex throws an exception. When you update
// the $LATEST version of an intent, the status field of any bot that uses the
// $LATEST version of the intent is set to NOT_BUILT.
//
// For more information, see how-it-works.
//
// This operation requires permissions for the lex:PutIntent action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation PutIntent for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
//   * PreconditionFailedException
//   The checksum of the resource that you are trying to change does not match
//   the checksum in the request. Check the resource's checksum and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutIntent
func (c *LexModelBuildingService) PutIntent(input *PutIntentInput) (*PutIntentOutput, error) {
	req, out := c.PutIntentRequest(input)
	return out, req.Send()
}

// PutIntentWithContext is the same as PutIntent with the addition of
// the ability to pass a context and additional request options.
//
// See PutIntent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) PutIntentWithContext(ctx aws.Context, input *PutIntentInput, opts ...request.Option) (*PutIntentOutput, error) {
	req, out := c.PutIntentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutSlotType = "PutSlotType"

// PutSlotTypeRequest generates a "aws/request.Request" representing the
// client's request for the PutSlotType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSlotType for more information on using the PutSlotType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutSlotTypeRequest method.
//    req, resp := client.PutSlotTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutSlotType
func (c *LexModelBuildingService) PutSlotTypeRequest(input *PutSlotTypeInput) (req *request.Request, output *PutSlotTypeOutput) {
	op := &request.Operation{
		Name:       opPutSlotType,
		HTTPMethod: "PUT",
		HTTPPath:   "/slottypes/{name}/versions/$LATEST",
	}

	if input == nil {
		input = &PutSlotTypeInput{}
	}

	output = &PutSlotTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutSlotType API operation for Amazon Lex Model Building Service.
//
// Creates a custom slot type or replaces an existing custom slot type.
//
// To create a custom slot type, specify a name for the slot type and a set
// of enumeration values, which are the values that a slot of this type can
// assume. For more information, see how-it-works.
//
// If you specify the name of an existing slot type, the fields in the request
// replace the existing values in the $LATEST version of the slot type. Amazon
// Lex removes the fields that you don't provide in the request. If you don't
// specify required fields, Amazon Lex throws an exception. When you update
// the $LATEST version of a slot type, if a bot uses the $LATEST version of
// an intent that contains the slot type, the bot's status field is set to NOT_BUILT.
//
// This operation requires permissions for the lex:PutSlotType action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation PutSlotType for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict processing the request. Try your request again.
//
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
//   * PreconditionFailedException
//   The checksum of the resource that you are trying to change does not match
//   the checksum in the request. Check the resource's checksum and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutSlotType
func (c *LexModelBuildingService) PutSlotType(input *PutSlotTypeInput) (*PutSlotTypeOutput, error) {
	req, out := c.PutSlotTypeRequest(input)
	return out, req.Send()
}

// PutSlotTypeWithContext is the same as PutSlotType with the addition of
// the ability to pass a context and additional request options.
//
// See PutSlotType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) PutSlotTypeWithContext(ctx aws.Context, input *PutSlotTypeInput, opts ...request.Option) (*PutSlotTypeOutput, error) {
	req, out := c.PutSlotTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartImport = "StartImport"

// StartImportRequest generates a "aws/request.Request" representing the
// client's request for the StartImport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartImport for more information on using the StartImport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartImportRequest method.
//    req, resp := client.StartImportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/StartImport
func (c *LexModelBuildingService) StartImportRequest(input *StartImportInput) (req *request.Request, output *StartImportOutput) {
	op := &request.Operation{
		Name:       opStartImport,
		HTTPMethod: "POST",
		HTTPPath:   "/imports/",
	}

	if input == nil {
		input = &StartImportInput{}
	}

	output = &StartImportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartImport API operation for Amazon Lex Model Building Service.
//
// Starts a job to import a resource to Amazon Lex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building Service's
// API operation StartImport for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   The request exceeded a limit. Try your request again.
//
//   * InternalFailureException
//   An internal Amazon Lex error occurred. Try your request again.
//
//   * BadRequestException
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/StartImport
func (c *LexModelBuildingService) StartImport(input *StartImportInput) (*StartImportOutput, error) {
	req, out := c.StartImportRequest(input)
	return out, req.Send()
}

// StartImportWithContext is the same as StartImport with the addition of
// the ability to pass a context and additional request options.
//
// See StartImport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelBuildingService) StartImportWithContext(ctx aws.Context, input *StartImportInput, opts ...request.Option) (*StartImportOutput, error) {
	req, out := c.StartImportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The request is not well formed. For example, a value is invalid or a required
// field is missing. Check the field values, and try again.
type BadRequestException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s BadRequestException) OrigErr() error {
	return nil
}

func (s BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s BadRequestException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s BadRequestException) RequestID() string {
	return s.respMetadata.RequestID
}

// Provides information about a bot alias.
type BotAliasMetadata struct {
	_ struct{} `type:"structure"`

	// The name of the bot to which the alias points.
	BotName *string `locationName:"botName" min:"2" type:"string"`

	// The version of the Amazon Lex bot to which the alias points.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// Checksum of the bot alias.
	Checksum *string `locationName:"checksum" type:"string"`

	// Settings that determine how Amazon Lex uses conversation logs for the alias.
	ConversationLogs *ConversationLogsResponse `locationName:"conversationLogs" type:"structure"`

	// The date that the bot alias was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A description of the bot alias.
	Description *string `locationName:"description" type:"string"`

	// The date that the bot alias was updated. When you create a resource, the
	// creation date and last updated date are the same.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// The name of the bot alias.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s BotAliasMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BotAliasMetadata) GoString() string {
	return s.String()
}

// SetBotName sets the BotName field's value.
func (s *BotAliasMetadata) SetBotName(v string) *BotAliasMetadata {
	s.BotName = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BotAliasMetadata) SetBotVersion(v string) *BotAliasMetadata {
	s.BotVersion = &v
	return s
}

// SetChecksum sets the Checksum field's value.
func (s *BotAliasMetadata) SetChecksum(v string) *BotAliasMetadata {
	s.Checksum = &v
	return s
}

// SetConversationLogs sets the ConversationLogs field's value.
func (s *BotAliasMetadata) SetConversationLogs(v *ConversationLogsResponse) *BotAliasMetadata {
	s.ConversationLogs = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *BotAliasMetadata) SetCreatedDate(v time.Time) *BotAliasMetadata {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *BotAliasMetadata) SetDescription(v string) *BotAliasMetadata {
	s.Description = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *BotAliasMetadata) SetLastUpdatedDate(v time.Time) *BotAliasMetadata {
	s.LastUpdatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *BotAliasMetadata) SetName(v string) *BotAliasMetadata {
	s.Name = &v
	return s
}

// Represents an association between an Amazon Lex bot and an external messaging
// platform.
type BotChannelAssociation struct {
	_ struct{} `type:"structure"`

	// An alias pointing to the specific version of the Amazon Lex bot to which
	// this association is being made.
	BotAlias *string `locationName:"botAlias" min:"1" type:"string"`

	// Provides information necessary to communicate with the messaging platform.
	BotConfiguration map[string]*string `locationName:"botConfiguration" min:"1" type:"map" sensitive:"true"`

	// The name of the Amazon Lex bot to which this association is being made.
	//
	// Currently, Amazon Lex supports associations with Facebook and Slack, and
	// Twilio.
	BotName *string `locationName:"botName" min:"2" type:"string"`

	// The date that the association between the Amazon Lex bot and the channel
	// was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A text description of the association you are creating.
	Description *string `locationName:"description" type:"string"`

	// If status is FAILED, Amazon Lex provides the reason that it failed to create
	// the association.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The name of the association between the bot and the channel.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the bot channel.
	//
	//    * CREATED - The channel has been created and is ready for use.
	//
	//    * IN_PROGRESS - Channel creation is in progress.
	//
	//    * FAILED - There was an error creating the channel. For information about
	//    the reason for the failure, see the failureReason field.
	Status *string `locationName:"status" type:"string" enum:"ChannelStatus"`

	// Specifies the type of association by indicating the type of channel being
	// established between the Amazon Lex bot and the external messaging platform.
	Type *string `locationName:"type" type:"string" enum:"ChannelType"`
}

// String returns the string representation
func (s BotChannelAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BotChannelAssociation) GoString() string {
	return s.String()
}

// SetBotAlias sets the BotAlias field's value.
func (s *BotChannelAssociation) SetBotAlias(v string) *BotChannelAssociation {
	s.BotAlias = &v
	return s
}

// SetBotConfiguration sets the BotConfiguration field's value.
func (s *BotChannelAssociation) SetBotConfiguration(v map[string]*string) *BotChannelAssociation {
	s.BotConfiguration = v
	return s
}

// SetBotName sets the BotName field's value.
func (s *BotChannelAssociation) SetBotName(v string) *BotChannelAssociation {
	s.BotName = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *BotChannelAssociation) SetCreatedDate(v time.Time) *BotChannelAssociation {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *BotChannelAssociation) SetDescription(v string) *BotChannelAssociation {
	s.Description = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *BotChannelAssociation) SetFailureReason(v string) *BotChannelAssociation {
	s.FailureReason = &v
	return s
}

// SetName sets the Name field's value.
func (s *BotChannelAssociation) SetName(v string) *BotChannelAssociation {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BotChannelAssociation) SetStatus(v string) *BotChannelAssociation {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *BotChannelAssociation) SetType(v string) *BotChannelAssociation {
	s.Type = &v
	return s
}

// Provides information about a bot. .
type BotMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the bot was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A description of the bot.
	Description *string `locationName:"description" type:"string"`

	// The date that the bot was updated. When you create a bot, the creation date
	// and last updated date are the same.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// The name of the bot.
	Name *string `locationName:"name" min:"2" type:"string"`

	// The status of the bot.
	Status *string `locationName:"status" type:"string" enum:"Status"`

	// The version of the bot. For a new bot, the version is always $LATEST.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s BotMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BotMetadata) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *BotMetadata) SetCreatedDate(v time.Time) *BotMetadata {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *BotMetadata) SetDescription(v string) *BotMetadata {
	s.Description = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *BotMetadata) SetLastUpdatedDate(v time.Time) *BotMetadata {
	s.LastUpdatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *BotMetadata) SetName(v string) *BotMetadata {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BotMetadata) SetStatus(v string) *BotMetadata {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *BotMetadata) SetVersion(v string) *BotMetadata {
	s.Version = &v
	return s
}

// Provides metadata for a built-in intent.
type BuiltinIntentMetadata struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the built-in intent. To find the signature for an
	// intent, see Standard Built-in Intents (https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
	// in the Alexa Skills Kit.
	Signature *string `locationName:"signature" type:"string"`

	// A list of identifiers for the locales that the intent supports.
	SupportedLocales []*string `locationName:"supportedLocales" type:"list"`
}

// String returns the string representation
func (s BuiltinIntentMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BuiltinIntentMetadata) GoString() string {
	return s.String()
}

// SetSignature sets the Signature field's value.
func (s *BuiltinIntentMetadata) SetSignature(v string) *BuiltinIntentMetadata {
	s.Signature = &v
	return s
}

// SetSupportedLocales sets the SupportedLocales field's value.
func (s *BuiltinIntentMetadata) SetSupportedLocales(v []*string) *BuiltinIntentMetadata {
	s.SupportedLocales = v
	return s
}

// Provides information about a slot used in a built-in intent.
type BuiltinIntentSlot struct {
	_ struct{} `type:"structure"`

	// A list of the slots defined for the intent.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s BuiltinIntentSlot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BuiltinIntentSlot) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *BuiltinIntentSlot) SetName(v string) *BuiltinIntentSlot {
	s.Name = &v
	return s
}

// Provides information about a built in slot type.
type BuiltinSlotTypeMetadata struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the built-in slot type. To find the signature for
	// a slot type, see Slot Type Reference (https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference)
	// in the Alexa Skills Kit.
	Signature *string `locationName:"signature" type:"string"`

	// A list of target locales for the slot.
	SupportedLocales []*string `locationName:"supportedLocales" type:"list"`
}

// String returns the string representation
func (s BuiltinSlotTypeMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BuiltinSlotTypeMetadata) GoString() string {
	return s.String()
}

// SetSignature sets the Signature field's value.
func (s *BuiltinSlotTypeMetadata) SetSignature(v string) *BuiltinSlotTypeMetadata {
	s.Signature = &v
	return s
}

// SetSupportedLocales sets the SupportedLocales field's value.
func (s *BuiltinSlotTypeMetadata) SetSupportedLocales(v []*string) *BuiltinSlotTypeMetadata {
	s.SupportedLocales = v
	return s
}

// Specifies a Lambda function that verifies requests to a bot or fulfills the
// user's request to a bot..
type CodeHook struct {
	_ struct{} `type:"structure"`

	// The version of the request-response that you want Amazon Lex to use to invoke
	// your Lambda function. For more information, see using-lambda.
	//
	// MessageVersion is a required field
	MessageVersion *string `locationName:"messageVersion" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Lambda function.
	//
	// Uri is a required field
	Uri *string `locationName:"uri" min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s CodeHook) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeHook) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeHook) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeHook"}
	if s.MessageVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageVersion"))
	}
	if s.MessageVersion != nil && len(*s.MessageVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageVersion", 1))
	}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}
	if s.Uri != nil && len(*s.Uri) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Uri", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessageVersion sets the MessageVersion field's value.
func (s *CodeHook) SetMessageVersion(v string) *CodeHook {
	s.MessageVersion = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *CodeHook) SetUri(v string) *CodeHook {
	s.Uri = &v
	return s
}

// There was a conflict processing the request. Try your request again.
type ConflictException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ConflictException) OrigErr() error {
	return nil
}

func (s ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ConflictException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ConflictException) RequestID() string {
	return s.respMetadata.RequestID
}

// Provides the settings needed for conversation logs.
type ConversationLogsRequest struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role with permission to write to
	// your CloudWatch Logs for text logs and your S3 bucket for audio logs. If
	// audio encryption is enabled, this role also provides access permission for
	// the AWS KMS key used for encrypting audio logs. For more information, see
	// Creating an IAM Role and Policy for Conversation Logs (https://docs.aws.amazon.com/lex/latest/dg/conversation-logs-role-and-policy.html).
	//
	// IamRoleArn is a required field
	IamRoleArn *string `locationName:"iamRoleArn" min:"20" type:"string" required:"true"`

	// The settings for your conversation logs. You can log the conversation text,
	// conversation audio, or both.
	//
	// LogSettings is a required field
	LogSettings []*LogSettingsRequest `locationName:"logSettings" type:"list" required:"true"`
}

// String returns the string representation
func (s ConversationLogsRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConversationLogsRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConversationLogsRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConversationLogsRequest"}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}
	if s.IamRoleArn != nil && len(*s.IamRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("IamRoleArn", 20))
	}
	if s.LogSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("LogSettings"))
	}
	if s.LogSettings != nil {
		for i, v := range s.LogSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LogSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *ConversationLogsRequest) SetIamRoleArn(v string) *ConversationLogsRequest {
	s.IamRoleArn = &v
	return s
}

// SetLogSettings sets the LogSettings field's value.
func (s *ConversationLogsRequest) SetLogSettings(v []*LogSettingsRequest) *ConversationLogsRequest {
	s.LogSettings = v
	return s
}

// Contains information about conversation log settings.
type ConversationLogsResponse struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role used to write your logs to
	// CloudWatch Logs or an S3 bucket.
	IamRoleArn *string `locationName:"iamRoleArn" min:"20" type:"string"`

	// The settings for your conversation logs. You can log text, audio, or both.
	LogSettings []*LogSettingsResponse `locationName:"logSettings" type:"list"`
}

// String returns the string representation
func (s ConversationLogsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConversationLogsResponse) GoString() string {
	return s.String()
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *ConversationLogsResponse) SetIamRoleArn(v string) *ConversationLogsResponse {
	s.IamRoleArn = &v
	return s
}

// SetLogSettings sets the LogSettings field's value.
func (s *ConversationLogsResponse) SetLogSettings(v []*LogSettingsResponse) *ConversationLogsResponse {
	s.LogSettings = v
	return s
}

type CreateBotVersionInput struct {
	_ struct{} `type:"structure"`

	// Identifies a specific revision of the $LATEST version of the bot. If you
	// specify a checksum and the $LATEST version of the bot has a different checksum,
	// a PreconditionFailedException exception is returned and Amazon Lex doesn't
	// publish a new version. If you don't specify a checksum, Amazon Lex publishes
	// the $LATEST version.
	Checksum *string `locationName:"checksum" type:"string"`

	// The name of the bot that you want to create a new version of. The name is
	// case sensitive.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateBotVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBotVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBotVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBotVersionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChecksum sets the Checksum field's value.
func (s *CreateBotVersionInput) SetChecksum(v string) *CreateBotVersionInput {
	s.Checksum = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateBotVersionInput) SetName(v string) *CreateBotVersionInput {
	s.Name = &v
	return s
}

type CreateBotVersionOutput struct {
	_ struct{} `type:"structure"`

	// The message that Amazon Lex uses to abort a conversation. For more information,
	// see PutBot.
	AbortStatement *Statement `locationName:"abortStatement" type:"structure"`

	// Checksum identifying the version of the bot that was created.
	Checksum *string `locationName:"checksum" type:"string"`

	// For each Amazon Lex bot created with the Amazon Lex Model Building Service,
	// you must specify whether your use of Amazon Lex is related to a website,
	// program, or other application that is directed or targeted, in whole or in
	// part, to children under age 13 and subject to the Children's Online Privacy
	// Protection Act (COPPA) by specifying true or false in the childDirected field.
	// By specifying true in the childDirected field, you confirm that your use
	// of Amazon Lex is related to a website, program, or other application that
	// is directed or targeted, in whole or in part, to children under age 13 and
	// subject to COPPA. By specifying false in the childDirected field, you confirm
	// that your use of Amazon Lex is not related to a website, program, or other
	// application that is directed or targeted, in whole or in part, to children
	// under age 13 and subject to COPPA. You may not specify a default value for
	// the childDirected field that does not accurately reflect whether your use
	// of Amazon Lex is related to a website, program, or other application that
	// is directed or targeted, in whole or in part, to children under age 13 and
	// subject to COPPA.
	//
	// If your use of Amazon Lex relates to a website, program, or other application
	// that is directed in whole or in part, to children under age 13, you must
	// obtain any required verifiable parental consent under COPPA. For information
	// regarding the use of Amazon Lex in connection with websites, programs, or
	// other applications that are directed or targeted, in whole or in part, to
	// children under age 13, see the Amazon Lex FAQ. (https://aws.amazon.com/lex/faqs#data-security)
	ChildDirected *bool `locationName:"childDirected" type:"boolean"`

	// The message that Amazon Lex uses when it doesn't understand the user's request.
	// For more information, see PutBot.
	ClarificationPrompt *Prompt `locationName:"clarificationPrompt" type:"structure"`

	// The date when the bot version was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A description of the bot.
	Description *string `locationName:"description" type:"string"`

	// Indicates whether utterances entered by the user should be sent to Amazon
	// Comprehend for sentiment analysis.
	DetectSentiment *bool `locationName:"detectSentiment" type:"boolean"`

	// If status is FAILED, Amazon Lex provides the reason that it failed to build
	// the bot.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The maximum time in seconds that Amazon Lex retains the data gathered in
	// a conversation. For more information, see PutBot.
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer"`

	// An array of Intent objects. For more information, see PutBot.
	Intents []*Intent `locationName:"intents" type:"list"`

	// The date when the $LATEST version of this bot was updated.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// Specifies the target locale for the bot.
	Locale *string `locationName:"locale" type:"string" enum:"Locale"`

	// The name of the bot.
	Name *string `locationName:"name" min:"2" type:"string"`

	// When you send a request to create or update a bot, Amazon Lex sets the status
	// response element to BUILDING. After Amazon Lex builds the bot, it sets status
	// to READY. If Amazon Lex can't build the bot, it sets status to FAILED. Amazon
	// Lex returns the reason for the failure in the failureReason response element.
	Status *string `locationName:"status" type:"string" enum:"Status"`

	// The version of the bot.
	Version *string `locationName:"version" min:"1" type:"string"`

	// The Amazon Polly voice ID that Amazon Lex uses for voice interactions with
	// the user.
	VoiceId *string `locationName:"voiceId" type:"string"`
}

// String returns the string representation
func (s CreateBotVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBotVersionOutput) GoString() string {
	return s.String()
}

// SetAbortStatement sets the AbortStatement field's value.
func (s *CreateBotVersionOutput) SetAbortStatement(v *Statement) *CreateBotVersionOutput {
	s.AbortStatement = v
	return s
}

// SetChecksum sets the Checksum field's value.
func (s *CreateBotVersionOutput) SetChecksum(v string) *CreateBotVersionOutput {
	s.Checksum = &v
	return s
}

// SetChildDirected sets the ChildDirected field's value.
func (s *CreateBotVersionOutput) SetChildDirected(v bool) *CreateBotVersionOutput {
	s.ChildDirected = &v
	return s
}

// SetClarificationPrompt sets the ClarificationPrompt field's value.
func (s *CreateBotVersionOutput) SetClarificationPrompt(v *Prompt) *CreateBotVersionOutput {
	s.ClarificationPrompt = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *CreateBotVersionOutput) SetCreatedDate(v time.Time) *CreateBotVersionOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBotVersionOutput) SetDescription(v string) *CreateBotVersionOutput {
	s.Description = &v
	return s
}

// SetDetectSentiment sets the DetectSentiment field's value.
func (s *CreateBotVersionOutput) SetDetectSentiment(v bool) *CreateBotVersionOutput {
	s.DetectSentiment = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *CreateBotVersionOutput) SetFailureReason(v string) *CreateBotVersionOutput {
	s.FailureReason = &v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *CreateBotVersionOutput) SetIdleSessionTTLInSeconds(v int64) *CreateBotVersionOutput {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetIntents sets the Intents field's value.
func (s *CreateBotVersionOutput) SetIntents(v []*Intent) *CreateBotVersionOutput {
	s.Intents = v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *CreateBotVersionOutput) SetLastUpdatedDate(v time.Time) *CreateBotVersionOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *CreateBotVersionOutput) SetLocale(v string) *CreateBotVersionOutput {
	s.Locale = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateBotVersionOutput) SetName(v string) *CreateBotVersionOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateBotVersionOutput) SetStatus(v string) *CreateBotVersionOutput {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateBotVersionOutput) SetVersion(v string) *CreateBotVersionOutput {
	s.Version = &v
	return s
}

// SetVoiceId sets the VoiceId field's value.
func (s *CreateBotVersionOutput) SetVoiceId(v string) *CreateBotVersionOutput {
	s.VoiceId = &v
	return s
}

type CreateIntentVersionInput struct {
	_ struct{} `type:"structure"`

	// Checksum of the $LATEST version of the intent that should be used to create
	// the new version. If you specify a checksum and the $LATEST version of the
	// intent has a different checksum, Amazon Lex returns a PreconditionFailedException
	// exception and doesn't publish a new version. If you don't specify a checksum,
	// Amazon Lex publishes the $LATEST version.
	Checksum *string `locationName:"checksum" type:"string"`

	// The name of the intent that you want to create a new version of. The name
	// is case sensitive.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateIntentVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIntentVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIntentVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIntentVersionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChecksum sets the Checksum field's value.
func (s *CreateIntentVersionInput) SetChecksum(v string) *CreateIntentVersionInput {
	s.Checksum = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateIntentVersionInput) SetName(v string) *CreateIntentVersionInput {
	s.Name = &v
	return s
}

type CreateIntentVersionOutput struct {
	_ struct{} `type:"structure"`

	// Checksum of the intent version created.
	Checksum *string `locationName:"checksum" type:"string"`

	// After the Lambda function specified in the fulfillmentActivity field fulfills
	// the intent, Amazon Lex conveys this statement to the user.
	ConclusionStatement *Statement `locationName:"conclusionStatement" type:"structure"`

	// If defined, the prompt that Amazon Lex uses to confirm the user's intent
	// before fulfilling it.
	ConfirmationPrompt *Prompt `locationName:"confirmationPrompt" type:"structure"`

	// The date that the intent was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A description of the intent.
	Description *string `locationName:"description" type:"string"`

	// If defined, Amazon Lex invokes this Lambda function for each user input.
	DialogCodeHook *CodeHook `locationName:"dialogCodeHook" type:"structure"`

	// If defined, Amazon Lex uses this prompt to solicit additional user activity
	// after the intent is fulfilled.
	FollowUpPrompt *FollowUpPrompt `locationName:"followUpPrompt" type:"structure"`

	// Describes how the intent is fulfilled.
	FulfillmentActivity *FulfillmentActivity `locationName:"fulfillmentActivity" type:"structure"`

	// The date that the intent was updated.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// The name of the intent.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A unique identifier for a built-in intent.
	ParentIntentSignature *string `locationName:"parentIntentSignature" type:"string"`

	// If the user answers "no" to the question defined in confirmationPrompt, Amazon
	// Lex responds with this statement to acknowledge that the intent was canceled.
	RejectionStatement *Statement `locationName:"rejectionStatement" type:"structure"`

	// An array of sample utterances configured for the intent.
	SampleUtterances []*string `locationName:"sampleUtterances" type:"list"`

	// An array of slot types that defines the information required to fulfill the
	// intent.
	Slots []*Slot `locationName:"slots" type:"list"`

	// The version number assigned to the new version of the intent.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateIntentVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIntentVersionOutput) GoString() string {
	return s.String()
}

// SetChecksum sets the Checksum field's value.
func (s *CreateIntentVersionOutput) SetChecksum(v string) *CreateIntentVersionOutput {
	s.Checksum = &v
	return s
}

// SetConclusionStatement sets the ConclusionStatement field's value.
func (s *CreateIntentVersionOutput) SetConclusionStatement(v *Statement) *CreateIntentVersionOutput {
	s.ConclusionStatement = v
	return s
}

// SetConfirmationPrompt sets the ConfirmationPrompt field's value.
func (s *CreateIntentVersionOutput) SetConfirmationPrompt(v *Prompt) *CreateIntentVersionOutput {
	s.ConfirmationPrompt = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *CreateIntentVersionOutput) SetCreatedDate(v time.Time) *CreateIntentVersionOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateIntentVersionOutput) SetDescription(v string) *CreateIntentVersionOutput {
	s.Description = &v
	return s
}

// SetDialogCodeHook sets the DialogCodeHook field's value.
func (s *CreateIntentVersionOutput) SetDialogCodeHook(v *CodeHook) *CreateIntentVersionOutput {
	s.DialogCodeHook = v
	return s
}

// SetFollowUpPrompt sets the FollowUpPrompt field's value.
func (s *CreateIntentVersionOutput) SetFollowUpPrompt(v *FollowUpPrompt) *CreateIntentVersionOutput {
	s.FollowUpPrompt = v
	return s
}

// SetFulfillmentActivity sets the FulfillmentActivity field's value.
func (s *CreateIntentVersionOutput) SetFulfillmentActivity(v *FulfillmentActivity) *CreateIntentVersionOutput {
	s.FulfillmentActivity = v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *CreateIntentVersionOutput) SetLastUpdatedDate(v time.Time) *CreateIntentVersionOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateIntentVersionOutput) SetName(v string) *CreateIntentVersionOutput {
	s.Name = &v
	return s
}

// SetParentIntentSignature sets the ParentIntentSignature field's value.
func (s *CreateIntentVersionOutput) SetParentIntentSignature(v string) *CreateIntentVersionOutput {
	s.ParentIntentSignature = &v
	return s
}

// SetRejectionStatement sets the RejectionStatement field's value.
func (s *CreateIntentVersionOutput) SetRejectionStatement(v *Statement) *CreateIntentVersionOutput {
	s.RejectionStatement = v
	return s
}

// SetSampleUtterances sets the SampleUtterances field's value.
func (s *CreateIntentVersionOutput) SetSampleUtterances(v []*string) *CreateIntentVersionOutput {
	s.SampleUtterances = v
	return s
}

// SetSlots sets the Slots field's value.
func (s *CreateIntentVersionOutput) SetSlots(v []*Slot) *CreateIntentVersionOutput {
	s.Slots = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateIntentVersionOutput) SetVersion(v string) *CreateIntentVersionOutput {
	s.Version = &v
	return s
}

type CreateSlotTypeVersionInput struct {
	_ struct{} `type:"structure"`

	// Checksum for the $LATEST version of the slot type that you want to publish.
	// If you specify a checksum and the $LATEST version of the slot type has a
	// different checksum, Amazon Lex returns a PreconditionFailedException exception
	// and doesn't publish the new version. If you don't specify a checksum, Amazon
	// Lex publishes the $LATEST version.
	Checksum *string `locationName:"checksum" type:"string"`

	// The name of the slot type that you want to create a new version for. The
	// name is case sensitive.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSlotTypeVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSlotTypeVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSlotTypeVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSlotTypeVersionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChecksum sets the Checksum field's value.
func (s *CreateSlotTypeVersionInput) SetChecksum(v string) *CreateSlotTypeVersionInput {
	s.Checksum = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSlotTypeVersionInput) SetName(v string) *CreateSlotTypeVersionInput {
	s.Name = &v
	return s
}

type CreateSlotTypeVersionOutput struct {
	_ struct{} `type:"structure"`

	// Checksum of the $LATEST version of the slot type.
	Checksum *string `locationName:"checksum" type:"string"`

	// The date that the slot type was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A description of the slot type.
	Description *string `locationName:"description" type:"string"`

	// A list of EnumerationValue objects that defines the values that the slot
	// type can take.
	EnumerationValues []*EnumerationValue `locationName:"enumerationValues" min:"1" type:"list"`

	// The date that the slot type was updated. When you create a resource, the
	// creation date and last update date are the same.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// The name of the slot type.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The strategy that Amazon Lex uses to determine the value of the slot. For
	// more information, see PutSlotType.
	ValueSelectionStrategy *string `locationName:"valueSelectionStrategy" type:"string" enum:"SlotValueSelectionStrategy"`

	// The version assigned to the new slot type version.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateSlotTypeVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSlotTypeVersionOutput) GoString() string {
	return s.String()
}

// SetChecksum sets the Checksum field's value.
func (s *CreateSlotTypeVersionOutput) SetChecksum(v string) *CreateSlotTypeVersionOutput {
	s.Checksum = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *CreateSlotTypeVersionOutput) SetCreatedDate(v time.Time) *CreateSlotTypeVersionOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSlotTypeVersionOutput) SetDescription(v string) *CreateSlotTypeVersionOutput {
	s.Description = &v
	return s
}

// SetEnumerationValues sets the EnumerationValues field's value.
func (s *CreateSlotTypeVersionOutput) SetEnumerationValues(v []*EnumerationValue) *CreateSlotTypeVersionOutput {
	s.EnumerationValues = v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *CreateSlotTypeVersionOutput) SetLastUpdatedDate(v time.Time) *CreateSlotTypeVersionOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSlotTypeVersionOutput) SetName(v string) *CreateSlotTypeVersionOutput {
	s.Name = &v
	return s
}

// SetValueSelectionStrategy sets the ValueSelectionStrategy field's value.
func (s *CreateSlotTypeVersionOutput) SetValueSelectionStrategy(v string) *CreateSlotTypeVersionOutput {
	s.ValueSelectionStrategy = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateSlotTypeVersionOutput) SetVersion(v string) *CreateSlotTypeVersionOutput {
	s.Version = &v
	return s
}

type DeleteBotAliasInput struct {
	_ struct{} `type:"structure"`

	// The name of the bot that the alias points to.
	//
	// BotName is a required field
	BotName *string `location:"uri" locationName:"botName" min:"2" type:"string" required:"true"`

	// The name of the alias to delete. The name is case sensitive.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBotAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBotAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBotAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBotAliasInput"}
	if s.BotName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotName"))
	}
	if s.BotName != nil && len(*s.BotName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("BotName", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotName sets the BotName field's value.
func (s *DeleteBotAliasInput) SetBotName(v string) *DeleteBotAliasInput {
	s.BotName = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteBotAliasInput) SetName(v string) *DeleteBotAliasInput {
	s.Name = &v
	return s
}

type DeleteBotAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBotAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBotAliasOutput) GoString() string {
	return s.String()
}

type DeleteBotChannelAssociationInput struct {
	_ struct{} `type:"structure"`

	// An alias that points to the specific version of the Amazon Lex bot to which
	// this association is being made.
	//
	// BotAlias is a required field
	BotAlias *string `location:"uri" locationName:"aliasName" min:"1" type:"string" required:"true"`

	// The name of the Amazon Lex bot.
	//
	// BotName is a required field
	BotName *string `location:"uri" locationName:"botName" min:"2" type:"string" required:"true"`

	// The name of the association. The name is case sensitive.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBotChannelAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBotChannelAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBotChannelAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBotChannelAssociationInput"}
	if s.BotAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAlias"))
	}
	if s.BotAlias != nil && len(*s.BotAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotAlias", 1))
	}
	if s.BotName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotName"))
	}
	if s.BotName != nil && len(*s.BotName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("BotName", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAlias sets the BotAlias field's value.
func (s *DeleteBotChannelAssociationInput) SetBotAlias(v string) *DeleteBotChannelAssociationInput {
	s.BotAlias = &v
	return s
}

// SetBotName sets the BotName field's value.
func (s *DeleteBotChannelAssociationInput) SetBotName(v string) *DeleteBotChannelAssociationInput {
	s.BotName = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteBotChannelAssociationInput) SetName(v string) *DeleteBotChannelAssociationInput {
	s.Name = &v
	return s
}

type DeleteBotChannelAssociationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBotChannelAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBotChannelAssociationOutput) GoString() string {
	return s.String()
}

type DeleteBotInput struct {
	_ struct{} `type:"structure"`

	// The name of the bot. The name is case sensitive.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBotInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteBotInput) SetName(v string) *DeleteBotInput {
	s.Name = &v
	return s
}

type DeleteBotOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBotOutput) GoString() string {
	return s.String()
}

type DeleteBotVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the bot.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"2" type:"string" required:"true"`

	// The version of the bot to delete. You cannot delete the $LATEST version of
	// the bot. To delete the $LATEST version, use the DeleteBot operation.
	//
	// Version is a required field
	Version *string `location:"uri" locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBotVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBotVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBotVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBotVersionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 2))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteBotVersionInput) SetName(v string) *DeleteBotVersionInput {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DeleteBotVersionInput) SetVersion(v string) *DeleteBotVersionInput {
	s.Version = &v
	return s
}

type DeleteBotVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBotVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBotVersionOutput) GoString() string {
	return s.String()
}

type DeleteIntentInput struct {
	_ struct{} `type:"structure"`

	// The name of the intent. The name is case sensitive.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIntentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIntentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIntentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIntentInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteIntentInput) SetName(v string) *DeleteIntentInput {
	s.Name = &v
	return s
}

type DeleteIntentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIntentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIntentOutput) GoString() string {
	return s.String()
}

type DeleteIntentVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the intent.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The version of the intent to delete. You cannot delete the $LATEST version
	// of the intent. To delete the $LATEST version, use the DeleteIntent operation.
	//
	// Version is a required field
	Version *string `location:"uri" locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIntentVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIntentVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIntentVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIntentVersionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteIntentVersionInput) SetName(v string) *DeleteIntentVersionInput {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DeleteIntentVersionInput) SetVersion(v string) *DeleteIntentVersionInput {
	s.Version = &v
	return s
}

type DeleteIntentVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIntentVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIntentVersionOutput) GoString() string {
	return s.String()
}

type DeleteSlotTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the slot type. The name is case sensitive.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSlotTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSlotTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSlotTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSlotTypeInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteSlotTypeInput) SetName(v string) *DeleteSlotTypeInput {
	s.Name = &v
	return s
}

type DeleteSlotTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSlotTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSlotTypeOutput) GoString() string {
	return s.String()
}

type DeleteSlotTypeVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the slot type.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The version of the slot type to delete. You cannot delete the $LATEST version
	// of the slot type. To delete the $LATEST version, use the DeleteSlotType operation.
	//
	// Version is a required field
	Version *string `location:"uri" locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSlotTypeVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSlotTypeVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSlotTypeVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSlotTypeVersionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteSlotTypeVersionInput) SetName(v string) *DeleteSlotTypeVersionInput {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DeleteSlotTypeVersionInput) SetVersion(v string) *DeleteSlotTypeVersionInput {
	s.Version = &v
	return s
}

type DeleteSlotTypeVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSlotTypeVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSlotTypeVersionOutput) GoString() string {
	return s.String()
}

type DeleteUtterancesInput struct {
	_ struct{} `type:"structure"`

	// The name of the bot that stored the utterances.
	//
	// BotName is a required field
	BotName *string `location:"uri" locationName:"botName" min:"2" type:"string" required:"true"`

	// The unique identifier for the user that made the utterances. This is the
	// user ID that was sent in the PostContent (http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html)
	// or PostText (http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html)
	// operation request that contained the utterance.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUtterancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUtterancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUtterancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUtterancesInput"}
	if s.BotName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotName"))
	}
	if s.BotName != nil && len(*s.BotName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("BotName", 2))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotName sets the BotName field's value.
func (s *DeleteUtterancesInput) SetBotName(v string) *DeleteUtterancesInput {
	s.BotName = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DeleteUtterancesInput) SetUserId(v string) *DeleteUtterancesInput {
	s.UserId = &v
	return s
}

type DeleteUtterancesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUtterancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUtterancesOutput) GoString() string {
	return s.String()
}

// Each slot type can have a set of values. Each enumeration value represents
// a value the slot type can take.
//
// For example, a pizza ordering bot could have a slot type that specifies the
// type of crust that the pizza should have. The slot type could include the
// values
//
//    * thick
//
//    * thin
//
//    * stuffed
type EnumerationValue struct {
	_ struct{} `type:"structure"`

	// Additional values related to the slot type value.
	Synonyms []*string `locationName:"synonyms" type:"list"`

	// The value of the slot type.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnumerationValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnumerationValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnumerationValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnumerationValue"}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSynonyms sets the Synonyms field's value.
func (s *EnumerationValue) SetSynonyms(v []*string) *EnumerationValue {
	s.Synonyms = v
	return s
}

// SetValue sets the Value field's value.
func (s *EnumerationValue) SetValue(v string) *EnumerationValue {
	s.Value = &v
	return s
}

// A prompt for additional activity after an intent is fulfilled. For example,
// after the OrderPizza intent is fulfilled, you might prompt the user to find
// out whether the user wants to order drinks.
type FollowUpPrompt struct {
	_ struct{} `type:"structure"`

	// Prompts for information from the user.
	//
	// Prompt is a required field
	Prompt *Prompt `locationName:"prompt" type:"structure" required:"true"`

	// If the user answers "no" to the question defined in the prompt field, Amazon
	// Lex responds with this statement to acknowledge that the intent was canceled.
	//
	// RejectionStatement is a required field
	RejectionStatement *Statement `locationName:"rejectionStatement" type:"structure" required:"true"`
}

// String returns the string representation
func (s FollowUpPrompt) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FollowUpPrompt) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FollowUpPrompt) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FollowUpPrompt"}
	if s.Prompt == nil {
		invalidParams.Add(request.NewErrParamRequired("Prompt"))
	}
	if s.RejectionStatement == nil {
		invalidParams.Add(request.NewErrParamRequired("RejectionStatement"))
	}
	if s.Prompt != nil {
		if err := s.Prompt.Validate(); err != nil {
			invalidParams.AddNested("Prompt", err.(request.ErrInvalidParams))
		}
	}
	if s.RejectionStatement != nil {
		if err := s.RejectionStatement.Validate(); err != nil {
			invalidParams.AddNested("RejectionStatement", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrompt sets the Prompt field's value.
func (s *FollowUpPrompt) SetPrompt(v *Prompt) *FollowUpPrompt {
	s.Prompt = v
	return s
}

// SetRejectionStatement sets the RejectionStatement field's value.
func (s *FollowUpPrompt) SetRejectionStatement(v *Statement) *FollowUpPrompt {
	s.RejectionStatement = v
	return s
}

// Describes how the intent is fulfilled after the user provides all of the
// information required for the intent. You can provide a Lambda function to
// process the intent, or you can return the intent information to the client
// application. We recommend that you use a Lambda function so that the relevant
// logic lives in the Cloud and limit the client-side code primarily to presentation.
// If you need to update the logic, you only update the Lambda function; you
// don't need to upgrade your client application.
//
// Consider the following examples:
//
//    * In a pizza ordering application, after the user provides all of the
//    information for placing an order, you use a Lambda function to place an
//    order with a pizzeria.
//
//    * In a gaming application, when a user says "pick up a rock," this information
//    must go back to the client application so that it can perform the operation
//    and update the graphics. In this case, you want Amazon Lex to return the
//    intent data to the client.
type FulfillmentActivity struct {
	_ struct{} `type:"structure"`

	// A description of the Lambda function that is run to fulfill the intent.
	CodeHook *CodeHook `locationName:"codeHook" type:"structure"`

	// How the intent should be fulfilled, either by running a Lambda function or
	// by returning the slot data to the client application.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"FulfillmentActivityType"`
}

// String returns the string representation
func (s FulfillmentActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FulfillmentActivity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FulfillmentActivity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FulfillmentActivity"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.CodeHook != nil {
		if err := s.CodeHook.Validate(); err != nil {
			invalidParams.AddNested("CodeHook", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeHook sets the CodeHook field's value.
func (s *FulfillmentActivity) SetCodeHook(v *CodeHook) *FulfillmentActivity {
	s.CodeHook = v
	return s
}

// SetType sets the Type field's value.
func (s *FulfillmentActivity) SetType(v string) *FulfillmentActivity {
	s.Type = &v
	return s
}

type GetBotAliasInput struct {
	_ struct{} `type:"structure"`

	// The name of the bot.
	//
	// BotName is a required field
	BotName *string `location:"uri" locationName:"botName" min:"2" type:"string" required:"true"`

	// The name of the bot alias. The name is case sensitive.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBotAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBotAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBotAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBotAliasInput"}
	if s.BotName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotName"))
	}
	if s.BotName != nil && len(*s.BotName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("BotName", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotName sets the BotName field's value.
func (s *GetBotAliasInput) SetBotName(v string) *GetBotAliasInput {
	s.BotName = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetBotAliasInput) SetName(v string) *GetBotAliasInput {
	s.Name = &v
	return s
}

type GetBotAliasOutput struct {
	_ struct{} `type:"structure"`

	// The name of the bot that the alias points to.
	BotName *string `locationName:"botName" min:"2" type:"string"`

	// The version of the bot that the alias points to.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// Checksum of the bot alias.
	Checksum *string `locationName:"checksum" type:"string"`

	// The settings that determine how Amazon Lex uses conversation logs for the
	// alias.
	ConversationLogs *ConversationLogsResponse `locationName:"conversationLogs" type:"structure"`

	// The date that the bot alias was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A description of the bot alias.
	Description *string `locationName:"description" type:"string"`

	// The date that the bot alias was updated. When you create a resource, the
	// creation date and the last updated date are the same.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// The name of the bot alias.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s GetBotAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBotAliasOutput) GoString() string {
	return s.String()
}

// SetBotName sets the BotName field's value.
func (s *GetBotAliasOutput) SetBotName(v string) *GetBotAliasOutput {
	s.BotName = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *GetBotAliasOutput) SetBotVersion(v string) *GetBotAliasOutput {
	s.BotVersion = &v
	return s
}

// SetChecksum sets the Checksum field's value.
func (s *GetBotAliasOutput) SetChecksum(v string) *GetBotAliasOutput {
	s.Checksum = &v
	return s
}

// SetConversationLogs sets the ConversationLogs field's value.
func (s *GetBotAliasOutput) SetConversationLogs(v *ConversationLogsResponse) *GetBotAliasOutput {
	s.ConversationLogs = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetBotAliasOutput) SetCreatedDate(v time.Time) *GetBotAliasOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetBotAliasOutput) SetDescription(v string) *GetBotAliasOutput {
	s.Description = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *GetBotAliasOutput) SetLastUpdatedDate(v time.Time) *GetBotAliasOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetBotAliasOutput) SetName(v string) *GetBotAliasOutput {
	s.Name = &v
	return s
}

type GetBotAliasesInput struct {
	_ struct{} `type:"structure"`

	// The name of the bot.
	//
	// BotName is a required field
	BotName *string `location:"uri" locationName:"botName" min:"2" type:"string" required:"true"`

	// The maximum number of aliases to return in the response. The default is 50. .
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Substring to match in bot alias names. An alias will be returned if any part
	// of its name matches the substring. For example, "xyz" matches both "xyzabc"
	// and "abcxyz."
	NameContains *string `location:"querystring" locationName:"nameContains" min:"1" type:"string"`

	// A pagination token for fetching the next page of aliases. If the response
	// to this call is truncated, Amazon Lex returns a pagination token in the response.
	// To fetch the next page of aliases, specify the pagination token in the next
	// request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetBotAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBotAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBotAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBotAliasesInput"}
	if s.BotName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotName"))
	}
	if s.BotName != nil && len(*s.BotName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("BotName", 2))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotName sets the BotName field's value.
func (s *GetBotAliasesInput) SetBotName(v string) *GetBotAliasesInput {
	s.BotName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetBotAliasesInput) SetMaxResults(v int64) *GetBotAliasesInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *GetBotAliasesInput) SetNameContains(v string) *GetBotAliasesInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetBotAliasesInput) SetNextToken(v string) *GetBotAliasesInput {
	s.NextToken = &v
	return s
}

type GetBotAliasesOutput struct {
	_ struct{} `type:"structure"`

	// An array of BotAliasMetadata objects, each describing a bot alias.
	BotAliases []*BotAliasMetadata `type:"list"`

	// A pagination token for fetching next page of aliases. If the response to
	// this call is truncated, Amazon Lex returns a pagination token in the response.
	// To fetch the next page of aliases, specify the pagination token in the next
	// request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetBotAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBotAliasesOutput) GoString() string {
	return s.String()
}

// SetBotAliases sets the BotAliases field's value.
func (s *GetBotAliasesOutput) SetBotAliases(v []*BotAliasMetadata) *GetBotAliasesOutput {
	s.BotAliases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetBotAliasesOutput) SetNextToken(v string) *GetBotAliasesOutput {
	s.NextToken = &v
	return s
}

type GetBotChannelAssociationInput struct {
	_ struct{} `type:"structure"`

	// An alias pointing to the specific version of the Amazon Lex bot to which
	// this association is being made.
	//
	// BotAlias is a required field
	BotAlias *string `location:"uri" locationName:"aliasName" min:"1" type:"string" required:"true"`

	// The name of the Amazon Lex bot.
	//
	// BotName is a required field
	BotName *string `location:"uri" locationName:"botName" min:"2" type:"string" required:"true"`

	// The name of the association between the bot and the channel. The name is
	// case sensitive.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBotChannelAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBotChannelAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBotChannelAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBotChannelAssociationInput"}
	if s.BotAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAlias"))
	}
	if s.BotAlias != nil && len(*s.BotAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotAlias", 1))
	}
	if s.BotName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotName"))
	}
	if s.BotName != nil && len(*s.BotName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("BotName", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAlias sets the BotAlias field's value.
func (s *GetBotChannelAssociationInput) SetBotAlias(v string) *GetBotChannelAssociationInput {
	s.BotAlias = &v
	return s
}

// SetBotName sets the BotName field's value.
func (s *GetBotChannelAssociationInput) SetBotName(v string) *GetBotChannelAssociationInput {
	s.BotName = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetBotChannelAssociationInput) SetName(v string) *GetBotChannelAssociationInput {
	s.Name = &v
	return s
}

type GetBotChannelAssociationOutput struct {
	_ struct{} `type:"structure"`

	// An alias pointing to the specific version of the Amazon Lex bot to which
	// this association is being made.
	BotAlias *string `locationName:"botAlias" min:"1" type:"string"`

	// Provides information that the messaging platform needs to communicate with
	// the Amazon Lex bot.
	BotConfiguration map[string]*string `locationName:"botConfiguration" min:"1" type:"map" sensitive:"true"`

	// The name of the Amazon Lex bot.
	BotName *string `locationName:"botName" min:"2" type:"string"`

	// The date that the association between the bot and the channel was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A description of the association between the bot and the channel.
	Description *string `locationName:"description" type:"string"`

	// If status is FAILED, Amazon Lex provides the reason that it failed to create
	// the association.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The name of the association between the bot and the channel.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the bot channel.
	//
	//    * CREATED - The channel has been created and is ready for use.
	//
	//    * IN_PROGRESS - Channel creation is in progress.
	//
	//    * FAILED - There was an error creating the channel. For information about
	//    the reason for the failure, see the failureReason field.
	Status *string `locationName:"status" type:"string" enum:"ChannelStatus"`

	// The type of the messaging platform.
	Type *string `locationName:"type" type:"string" enum:"ChannelType"`
}

// String returns the string representation
func (s GetBotChannelAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBotChannelAssociationOutput) GoString() string {
	return s.String()
}

// SetBotAlias sets the BotAlias field's value.
func (s *GetBotChannelAssociationOutput) SetBotAlias(v string) *GetBotChannelAssociationOutput {
	s.BotAlias = &v
	return s
}

// SetBotConfiguration sets the BotConfiguration field's value.
func (s *GetBotChannelAssociationOutput) SetBotConfiguration(v map[string]*string) *GetBotChannelAssociationOutput {
	s.BotConfiguration = v
	return s
}

// SetBotName sets the BotName field's value.
func (s *GetBotChannelAssociationOutput) SetBotName(v string) *GetBotChannelAssociationOutput {
	s.BotName = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetBotChannelAssociationOutput) SetCreatedDate(v time.Time) *GetBotChannelAssociationOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetBotChannelAssociationOutput) SetDescription(v string) *GetBotChannelAssociationOutput {
	s.Description = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *GetBotChannelAssociationOutput) SetFailureReason(v string) *GetBotChannelAssociationOutput {
	s.FailureReason = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetBotChannelAssociationOutput) SetName(v string) *GetBotChannelAssociationOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetBotChannelAssociationOutput) SetStatus(v string) *GetBotChannelAssociationOutput {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetBotChannelAssociationOutput) SetType(v string) *GetBotChannelAssociationOutput {
	s.Type = &v
	return s
}

type GetBotChannelAssociationsInput struct {
	_ struct{} `type:"structure"`

	// An alias pointing to the specific version of the Amazon Lex bot to which
	// this association is being made.
	//
	// BotAlias is a required field
	BotAlias *string `location:"uri" locationName:"aliasName" min:"1" type:"string" required:"true"`

	// The name of the Amazon Lex bot in the association.
	//
	// BotName is a required field
	BotName *string `location:"uri" locationName:"botName" min:"2" type:"string" required:"true"`

	// The maximum number of associations to return in the response. The default
	// is 50.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Substring to match in channel association names. An association will be returned
	// if any part of its name matches the substring. For example, "xyz" matches
	// both "xyzabc" and "abcxyz." To return all bot channel associations, use a
	// hyphen ("-") as the nameContains parameter.
	NameContains *string `location:"querystring" locationName:"nameContains" min:"1" type:"string"`

	// A pagination token for fetching the next page of associations. If the response
	// to this call is truncated, Amazon Lex returns a pagination token in the response.
	// To fetch the next page of associations, specify the pagination token in the
	// next request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetBotChannelAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBotChannelAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBotChannelAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBotChannelAssociationsInput"}
	if s.BotAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAlias"))
	}
	if s.BotAlias != nil && len(*s.BotAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotAlias", 1))
	}
	if s.BotName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotName"))
	}
	if s.BotName != nil && len(*s.BotName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("BotName", 2))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAlias sets the BotAlias field's value.
func (s *GetBotChannelAssociationsInput) SetBotAlias(v string) *GetBotChannelAssociationsInput {
	s.BotAlias = &v
	return s
}

// SetBotName sets the BotName field's value.
func (s *GetBotChannelAssociationsInput) SetBotName(v string) *GetBotChannelAssociationsInput {
	s.BotName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetBotChannelAssociationsInput) SetMaxResults(v int64) *GetBotChannelAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *GetBotChannelAssociationsInput) SetNameContains(v string) *GetBotChannelAssociationsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetBotChannelAssociationsInput) SetNextToken(v string) *GetBotChannelAssociationsInput {
	s.NextToken = &v
	return s
}

type GetBotChannelAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects, one for each association, that provides information
	// about the Amazon Lex bot and its association with the channel.
	BotChannelAssociations []*BotChannelAssociation `locationName:"botChannelAssociations" type:"list"`

	// A pagination token that fetches the next page of associations. If the response
	// to this call is truncated, Amazon Lex returns a pagination token in the response.
	// To fetch the next page of associations, specify the pagination token in the
	// next request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetBotChannelAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBotChannelAssociationsOutput) GoString() string {
	return s.String()
}

// SetBotChannelAssociations sets the BotChannelAssociations field's value.
func (s *GetBotChannelAssociationsOutput) SetBotChannelAssociations(v []*BotChannelAssociation) *GetBotChannelAssociationsOutput {
	s.BotChannelAssociations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetBotChannelAssociationsOutput) SetNextToken(v string) *GetBotChannelAssociationsOutput {
	s.NextToken = &v
	return s
}

type GetBotInput struct {
	_ struct{} `type:"structure"`

	// The name of the bot. The name is case sensitive.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"2" type:"string" required:"true"`

	// The version or alias of the bot.
	//
	// VersionOrAlias is a required field
	VersionOrAlias *string `location:"uri" locationName:"versionoralias" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBotInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 2))
	}
	if s.VersionOrAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionOrAlias"))
	}
	if s.VersionOrAlias != nil && len(*s.VersionOrAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionOrAlias", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetBotInput) SetName(v string) *GetBotInput {
	s.Name = &v
	return s
}

// SetVersionOrAlias sets the VersionOrAlias field's value.
func (s *GetBotInput) SetVersionOrAlias(v string) *GetBotInput {
	s.VersionOrAlias = &v
	return s
}

type GetBotOutput struct {
	_ struct{} `type:"structure"`

	// The message that Amazon Lex returns when the user elects to end the conversation
	// without completing it. For more information, see PutBot.
	AbortStatement *Statement `locationName:"abortStatement" type:"structure"`

	// Checksum of the bot used to identify a specific revision of the bot's $LATEST
	// version.
	Checksum *string `locationName:"checksum" type:"string"`

	// For each Amazon Lex bot created with the Amazon Lex Model Building Service,
	// you must specify whether your use of Amazon Lex is related to a website,
	// program, or other application that is directed or targeted, in whole or in
	// part, to children under age 13 and subject to the Children's Online Privacy
	// Protection Act (COPPA) by specifying true or false in the childDirected field.
	// By specifying true in the childDirected field, you confirm that your use
	// of Amazon Lex is related to a website, program, or other application that
	// is directed or targeted, in whole or in part, to children under age 13 and
	// subject to COPPA. By specifying false in the childDirected field, you confirm
	// that your use of Amazon Lex is not related to a website, program, or other
	// application that is directed or targeted, in whole or in part, to children
	// under age 13 and subject to COPPA. You may not specify a default value for
	// the childDirected field that does not accurately reflect whether your use
	// of Amazon Lex is related to a website, program, or other application that
	// is directed or targeted, in whole or in part, to children under age 13 and
	// subject to COPPA.
	//
	// If your use of Amazon Lex relates to a website, program, or other application
	// that is directed in whole or in part, to children under age 13, you must
	// obtain any required verifiable parental consent under COPPA. For information
	// regarding the use of Amazon Lex in connection with websites, programs, or
	// other applications that are directed or targeted, in whole or in part, to
	// children under age 13, see the Amazon Lex FAQ. (https://aws.amazon.com/lex/faqs#data-security)
	ChildDirected *bool `locationName:"childDirected" type:"boolean"`

	// The message Amazon Lex uses when it doesn't understand the user's request.
	// For more information, see PutBot.
	ClarificationPrompt *Prompt `locationName:"clarificationPrompt" type:"structure"`

	// The date that the bot was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A description of the bot.
	Description *string `locationName:"description" type:"string"`

	// Indicates whether user utterances should be sent to Amazon Comprehend for
	// sentiment analysis.
	DetectSentiment *bool `locationName:"detectSentiment" type:"boolean"`

	// If status is FAILED, Amazon Lex explains why it failed to build the bot.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The maximum time in seconds that Amazon Lex retains the data gathered in
	// a conversation. For more information, see PutBot.
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer"`

	// An array of intent objects. For more information, see PutBot.
	Intents []*Intent `locationName:"intents" type:"list"`

	// The date that the bot was updated. When you create a resource, the creation
	// date and last updated date are the same.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// The target locale for the bot.
	Locale *string `locationName:"locale" type:"string" enum:"Locale"`

	// The name of the bot.
	Name *string `locationName:"name" min:"2" type:"string"`

	// The status of the bot.
	//
	// When the status is BUILDING Amazon Lex is building the bot for testing and
	// use.
	//
	// If the status of the bot is READY_BASIC_TESTING, you can test the bot using
	// the exact utterances specified in the bot's intents. When the bot is ready
	// for full testing or to run, the status is READY.
	//
	// If there was a problem with building the bot, the status is FAILED and the
	// failureReason field explains why the bot did not build.
	//
	// If the bot was saved but not built, the status is NOT_BUILT.
	Status *string `locationName:"status" type:"string" enum:"Status"`

	// The version of the bot. For a new bot, the version is always $LATEST.
	Version *string `locationName:"version" min:"1" type:"string"`

	// The Amazon Polly voice ID that Amazon Lex uses for voice interaction with
	// the user. For more information, see PutBot.
	VoiceId *string `locationName:"voiceId" type:"string"`
}

// String returns the string representation
func (s GetBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBotOutput) GoString() string {
	return s.String()
}

// SetAbortStatement sets the AbortStatement field's value.
func (s *GetBotOutput) SetAbortStatement(v *Statement) *GetBotOutput {
	s.AbortStatement = v
	return s
}

// SetChecksum sets the Checksum field's value.
func (s *GetBotOutput) SetChecksum(v string) *GetBotOutput {
	s.Checksum = &v
	return s
}

// SetChildDirected sets the ChildDirected field's value.
func (s *GetBotOutput) SetChildDirected(v bool) *GetBotOutput {
	s.ChildDirected = &v
	return s
}

// SetClarificationPrompt sets the ClarificationPrompt field's value.
func (s *GetBotOutput) SetClarificationPrompt(v *Prompt) *GetBotOutput {
	s.ClarificationPrompt = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetBotOutput) SetCreatedDate(v time.Time) *GetBotOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetBotOutput) SetDescription(v string) *GetBotOutput {
	s.Description = &v
	return s
}

// SetDetectSentiment sets the DetectSentiment field's value.
func (s *GetBotOutput) SetDetectSentiment(v bool) *GetBotOutput {
	s.DetectSentiment = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *GetBotOutput) SetFailureReason(v string) *GetBotOutput {
	s.FailureReason = &v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *GetBotOutput) SetIdleSessionTTLInSeconds(v int64) *GetBotOutput {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetIntents sets the Intents field's value.
func (s *GetBotOutput) SetIntents(v []*Intent) *GetBotOutput {
	s.Intents = v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *GetBotOutput) SetLastUpdatedDate(v time.Time) *GetBotOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *GetBotOutput) SetLocale(v string) *GetBotOutput {
	s.Locale = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetBotOutput) SetName(v string) *GetBotOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetBotOutput) SetStatus(v string) *GetBotOutput {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetBotOutput) SetVersion(v string) *GetBotOutput {
	s.Version = &v
	return s
}

// SetVoiceId sets the VoiceId field's value.
func (s *GetBotOutput) SetVoiceId(v string) *GetBotOutput {
	s.VoiceId = &v
	return s
}

type GetBotVersionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of bot versions to return in the response. The default
	// is 10.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The name of the bot for which versions should be returned.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"2" type:"string" required:"true"`

	// A pagination token for fetching the next page of bot versions. If the response
	// to this call is truncated, Amazon Lex returns a pagination token in the response.
	// To fetch the next page of versions, specify the pagination token in the next
	// request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetBotVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBotVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBotVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBotVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetBotVersionsInput) SetMaxResults(v int64) *GetBotVersionsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetBotVersionsInput) SetName(v string) *GetBotVersionsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetBotVersionsInput) SetNextToken(v string) *GetBotVersionsInput {
	s.NextToken = &v
	return s
}

type GetBotVersionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of BotMetadata objects, one for each numbered version of the bot
	// plus one for the $LATEST version.
	Bots []*BotMetadata `locationName:"bots" type:"list"`

	// A pagination token for fetching the next page of bot versions. If the response
	// to this call is truncated, Amazon Lex returns a pagination token in the response.
	// To fetch the next page of versions, specify the pagination token in the next
	// request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetBotVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBotVersionsOutput) GoString() string {
	return s.String()
}

// SetBots sets the Bots field's value.
func (s *GetBotVersionsOutput) SetBots(v []*BotMetadata) *GetBotVersionsOutput {
	s.Bots = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetBotVersionsOutput) SetNextToken(v string) *GetBotVersionsOutput {
	s.NextToken = &v
	return s
}

type GetBotsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of bots to return in the response that the request will
	// return. The default is 10.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Substring to match in bot names. A bot will be returned if any part of its
	// name matches the substring. For example, "xyz" matches both "xyzabc" and
	// "abcxyz."
	NameContains *string `location:"querystring" locationName:"nameContains" min:"2" type:"string"`

	// A pagination token that fetches the next page of bots. If the response to
	// this call is truncated, Amazon Lex returns a pagination token in the response.
	// To fetch the next page of bots, specify the pagination token in the next
	// request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetBotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBotsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetBotsInput) SetMaxResults(v int64) *GetBotsInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *GetBotsInput) SetNameContains(v string) *GetBotsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetBotsInput) SetNextToken(v string) *GetBotsInput {
	s.NextToken = &v
	return s
}

type GetBotsOutput struct {
	_ struct{} `type:"structure"`

	// An array of botMetadata objects, with one entry for each bot.
	Bots []*BotMetadata `locationName:"bots" type:"list"`

	// If the response is truncated, it includes a pagination token that you can
	// specify in your next request to fetch the next page of bots.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetBotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBotsOutput) GoString() string {
	return s.String()
}

// SetBots sets the Bots field's value.
func (s *GetBotsOutput) SetBots(v []*BotMetadata) *GetBotsOutput {
	s.Bots = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetBotsOutput) SetNextToken(v string) *GetBotsOutput {
	s.NextToken = &v
	return s
}

type GetBuiltinIntentInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for a built-in intent. To find the signature for an
	// intent, see Standard Built-in Intents (https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
	// in the Alexa Skills Kit.
	//
	// Signature is a required field
	Signature *string `location:"uri" locationName:"signature" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBuiltinIntentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBuiltinIntentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBuiltinIntentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBuiltinIntentInput"}
	if s.Signature == nil {
		invalidParams.Add(request.NewErrParamRequired("Signature"))
	}
	if s.Signature != nil && len(*s.Signature) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Signature", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSignature sets the Signature field's value.
func (s *GetBuiltinIntentInput) SetSignature(v string) *GetBuiltinIntentInput {
	s.Signature = &v
	return s
}

type GetBuiltinIntentOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for a built-in intent.
	Signature *string `locationName:"signature" type:"string"`

	// An array of BuiltinIntentSlot objects, one entry for each slot type in the
	// intent.
	Slots []*BuiltinIntentSlot `locationName:"slots" type:"list"`

	// A list of locales that the intent supports.
	SupportedLocales []*string `locationName:"supportedLocales" type:"list"`
}

// String returns the string representation
func (s GetBuiltinIntentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBuiltinIntentOutput) GoString() string {
	return s.String()
}

// SetSignature sets the Signature field's value.
func (s *GetBuiltinIntentOutput) SetSignature(v string) *GetBuiltinIntentOutput {
	s.Signature = &v
	return s
}

// SetSlots sets the Slots field's value.
func (s *GetBuiltinIntentOutput) SetSlots(v []*BuiltinIntentSlot) *GetBuiltinIntentOutput {
	s.Slots = v
	return s
}

// SetSupportedLocales sets the SupportedLocales field's value.
func (s *GetBuiltinIntentOutput) SetSupportedLocales(v []*string) *GetBuiltinIntentOutput {
	s.SupportedLocales = v
	return s
}

type GetBuiltinIntentsInput struct {
	_ struct{} `type:"structure"`

	// A list of locales that the intent supports.
	Locale *string `location:"querystring" locationName:"locale" type:"string" enum:"Locale"`

	// The maximum number of intents to return in the response. The default is 10.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token that fetches the next page of intents. If this API call
	// is truncated, Amazon Lex returns a pagination token in the response. To fetch
	// the next page of intents, use the pagination token in the next request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Substring to match in built-in intent signatures. An intent will be returned
	// if any part of its signature matches the substring. For example, "xyz" matches
	// both "xyzabc" and "abcxyz." To find the signature for an intent, see Standard
	// Built-in Intents (https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
	// in the Alexa Skills Kit.
	SignatureContains *string `location:"querystring" locationName:"signatureContains" type:"string"`
}

// String returns the string representation
func (s GetBuiltinIntentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBuiltinIntentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBuiltinIntentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBuiltinIntentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocale sets the Locale field's value.
func (s *GetBuiltinIntentsInput) SetLocale(v string) *GetBuiltinIntentsInput {
	s.Locale = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetBuiltinIntentsInput) SetMaxResults(v int64) *GetBuiltinIntentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetBuiltinIntentsInput) SetNextToken(v string) *GetBuiltinIntentsInput {
	s.NextToken = &v
	return s
}

// SetSignatureContains sets the SignatureContains field's value.
func (s *GetBuiltinIntentsInput) SetSignatureContains(v string) *GetBuiltinIntentsInput {
	s.SignatureContains = &v
	return s
}

type GetBuiltinIntentsOutput struct {
	_ struct{} `type:"structure"`

	// An array of builtinIntentMetadata objects, one for each intent in the response.
	Intents []*BuiltinIntentMetadata `locationName:"intents" type:"list"`

	// A pagination token that fetches the next page of intents. If the response
	// to this API call is truncated, Amazon Lex returns a pagination token in the
	// response. To fetch the next page of intents, specify the pagination token
	// in the next request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetBuiltinIntentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBuiltinIntentsOutput) GoString() string {
	return s.String()
}

// SetIntents sets the Intents field's value.
func (s *GetBuiltinIntentsOutput) SetIntents(v []*BuiltinIntentMetadata) *GetBuiltinIntentsOutput {
	s.Intents = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetBuiltinIntentsOutput) SetNextToken(v string) *GetBuiltinIntentsOutput {
	s.NextToken = &v
	return s
}

type GetBuiltinSlotTypesInput struct {
	_ struct{} `type:"structure"`

	// A list of locales that the slot type supports.
	Locale *string `location:"querystring" locationName:"locale" type:"string" enum:"Locale"`

	// The maximum number of slot types to return in the response. The default is
	// 10.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token that fetches the next page of slot types. If the response
	// to this API call is truncated, Amazon Lex returns a pagination token in the
	// response. To fetch the next page of slot types, specify the pagination token
	// in the next request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Substring to match in built-in slot type signatures. A slot type will be
	// returned if any part of its signature matches the substring. For example,
	// "xyz" matches both "xyzabc" and "abcxyz."
	SignatureContains *string `location:"querystring" locationName:"signatureContains" type:"string"`
}

// String returns the string representation
func (s GetBuiltinSlotTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBuiltinSlotTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBuiltinSlotTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBuiltinSlotTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocale sets the Locale field's value.
func (s *GetBuiltinSlotTypesInput) SetLocale(v string) *GetBuiltinSlotTypesInput {
	s.Locale = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetBuiltinSlotTypesInput) SetMaxResults(v int64) *GetBuiltinSlotTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetBuiltinSlotTypesInput) SetNextToken(v string) *GetBuiltinSlotTypesInput {
	s.NextToken = &v
	return s
}

// SetSignatureContains sets the SignatureContains field's value.
func (s *GetBuiltinSlotTypesInput) SetSignatureContains(v string) *GetBuiltinSlotTypesInput {
	s.SignatureContains = &v
	return s
}

type GetBuiltinSlotTypesOutput struct {
	_ struct{} `type:"structure"`

	// If the response is truncated, the response includes a pagination token that
	// you can use in your next request to fetch the next page of slot types.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of BuiltInSlotTypeMetadata objects, one entry for each slot type
	// returned.
	SlotTypes []*BuiltinSlotTypeMetadata `locationName:"slotTypes" type:"list"`
}

// String returns the string representation
func (s GetBuiltinSlotTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBuiltinSlotTypesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetBuiltinSlotTypesOutput) SetNextToken(v string) *GetBuiltinSlotTypesOutput {
	s.NextToken = &v
	return s
}

// SetSlotTypes sets the SlotTypes field's value.
func (s *GetBuiltinSlotTypesOutput) SetSlotTypes(v []*BuiltinSlotTypeMetadata) *GetBuiltinSlotTypesOutput {
	s.SlotTypes = v
	return s
}

type GetExportInput struct {
	_ struct{} `type:"structure"`

	// The format of the exported data.
	//
	// ExportType is a required field
	ExportType *string `location:"querystring" locationName:"exportType" type:"string" required:"true" enum:"ExportType"`

	// The name of the bot to export.
	//
	// Name is a required field
	Name *string `location:"querystring" locationName:"name" min:"1" type:"string" required:"true"`

	// The type of resource to export.
	//
	// ResourceType is a required field
	ResourceType *string `location:"querystring" locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`

	// The version of the bot to export.
	//
	// Version is a required field
	Version *string `location:"querystring" locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExportInput"}
	if s.ExportType == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportType sets the ExportType field's value.
func (s *GetExportInput) SetExportType(v string) *GetExportInput {
	s.ExportType = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetExportInput) SetName(v string) *GetExportInput {
	s.Name = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *GetExportInput) SetResourceType(v string) *GetExportInput {
	s.ResourceType = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetExportInput) SetVersion(v string) *GetExportInput {
	s.Version = &v
	return s
}

type GetExportOutput struct {
	_ struct{} `type:"structure"`

	// The status of the export.
	//
	//    * IN_PROGRESS - The export is in progress.
	//
	//    * READY - The export is complete.
	//
	//    * FAILED - The export could not be completed.
	ExportStatus *string `locationName:"exportStatus" type:"string" enum:"ExportStatus"`

	// The format of the exported data.
	ExportType *string `locationName:"exportType" type:"string" enum:"ExportType"`

	// If status is FAILED, Amazon Lex provides the reason that it failed to export
	// the resource.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The name of the bot being exported.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The type of the exported resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// An S3 pre-signed URL that provides the location of the exported resource.
	// The exported resource is a ZIP archive that contains the exported resource
	// in JSON format. The structure of the archive may change. Your code should
	// not rely on the archive structure.
	Url *string `locationName:"url" type:"string"`

	// The version of the bot being exported.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s GetExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExportOutput) GoString() string {
	return s.String()
}

// SetExportStatus sets the ExportStatus field's value.
func (s *GetExportOutput) SetExportStatus(v string) *GetExportOutput {
	s.ExportStatus = &v
	return s
}

// SetExportType sets the ExportType field's value.
func (s *GetExportOutput) SetExportType(v string) *GetExportOutput {
	s.ExportType = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *GetExportOutput) SetFailureReason(v string) *GetExportOutput {
	s.FailureReason = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetExportOutput) SetName(v string) *GetExportOutput {
	s.Name = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *GetExportOutput) SetResourceType(v string) *GetExportOutput {
	s.ResourceType = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *GetExportOutput) SetUrl(v string) *GetExportOutput {
	s.Url = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetExportOutput) SetVersion(v string) *GetExportOutput {
	s.Version = &v
	return s
}

type GetImportInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the import job information to return.
	//
	// ImportId is a required field
	ImportId *string `location:"uri" locationName:"importId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetImportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImportInput"}
	if s.ImportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportId"))
	}
	if s.ImportId != nil && len(*s.ImportId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImportId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImportId sets the ImportId field's value.
func (s *GetImportInput) SetImportId(v string) *GetImportInput {
	s.ImportId = &v
	return s
}

type GetImportOutput struct {
	_ struct{} `type:"structure"`

	// A timestamp for the date and time that the import job was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A string that describes why an import job failed to complete.
	FailureReason []*string `locationName:"failureReason" type:"list"`

	// The identifier for the specific import job.
	ImportId *string `locationName:"importId" type:"string"`

	// The status of the import job. If the status is FAILED, you can get the reason
	// for the failure from the failureReason field.
	ImportStatus *string `locationName:"importStatus" type:"string" enum:"ImportStatus"`

	// The action taken when there was a conflict between an existing resource and
	// a resource in the import file.
	MergeStrategy *string `locationName:"mergeStrategy" type:"string" enum:"MergeStrategy"`

	// The name given to the import job.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The type of resource imported.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s GetImportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportOutput) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetImportOutput) SetCreatedDate(v time.Time) *GetImportOutput {
	s.CreatedDate = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *GetImportOutput) SetFailureReason(v []*string) *GetImportOutput {
	s.FailureReason = v
	return s
}

// SetImportId sets the ImportId field's value.
func (s *GetImportOutput) SetImportId(v string) *GetImportOutput {
	s.ImportId = &v
	return s
}

// SetImportStatus sets the ImportStatus field's value.
func (s *GetImportOutput) SetImportStatus(v string) *GetImportOutput {
	s.ImportStatus = &v
	return s
}

// SetMergeStrategy sets the MergeStrategy field's value.
func (s *GetImportOutput) SetMergeStrategy(v string) *GetImportOutput {
	s.MergeStrategy = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetImportOutput) SetName(v string) *GetImportOutput {
	s.Name = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *GetImportOutput) SetResourceType(v string) *GetImportOutput {
	s.ResourceType = &v
	return s
}

type GetIntentInput struct {
	_ struct{} `type:"structure"`

	// The name of the intent. The name is case sensitive.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The version of the intent.
	//
	// Version is a required field
	Version *string `location:"uri" locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIntentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIntentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIntentInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetIntentInput) SetName(v string) *GetIntentInput {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetIntentInput) SetVersion(v string) *GetIntentInput {
	s.Version = &v
	return s
}

type GetIntentOutput struct {
	_ struct{} `type:"structure"`

	// Checksum of the intent.
	Checksum *string `locationName:"checksum" type:"string"`

	// After the Lambda function specified in the fulfillmentActivity element fulfills
	// the intent, Amazon Lex conveys this statement to the user.
	ConclusionStatement *Statement `locationName:"conclusionStatement" type:"structure"`

	// If defined in the bot, Amazon Lex uses prompt to confirm the intent before
	// fulfilling the user's request. For more information, see PutIntent.
	ConfirmationPrompt *Prompt `locationName:"confirmationPrompt" type:"structure"`

	// The date that the intent was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A description of the intent.
	Description *string `locationName:"description" type:"string"`

	// If defined in the bot, Amazon Amazon Lex invokes this Lambda function for
	// each user input. For more information, see PutIntent.
	DialogCodeHook *CodeHook `locationName:"dialogCodeHook" type:"structure"`

	// If defined in the bot, Amazon Lex uses this prompt to solicit additional
	// user activity after the intent is fulfilled. For more information, see PutIntent.
	FollowUpPrompt *FollowUpPrompt `locationName:"followUpPrompt" type:"structure"`

	// Describes how the intent is fulfilled. For more information, see PutIntent.
	FulfillmentActivity *FulfillmentActivity `locationName:"fulfillmentActivity" type:"structure"`

	// The date that the intent was updated. When you create a resource, the creation
	// date and the last updated date are the same.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// The name of the intent.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A unique identifier for a built-in intent.
	ParentIntentSignature *string `locationName:"parentIntentSignature" type:"string"`

	// If the user answers "no" to the question defined in confirmationPrompt, Amazon
	// Lex responds with this statement to acknowledge that the intent was canceled.
	RejectionStatement *Statement `locationName:"rejectionStatement" type:"structure"`

	// An array of sample utterances configured for the intent.
	SampleUtterances []*string `locationName:"sampleUtterances" type:"list"`

	// An array of intent slots configured for the intent.
	Slots []*Slot `locationName:"slots" type:"list"`

	// The version of the intent.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s GetIntentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntentOutput) GoString() string {
	return s.String()
}

// SetChecksum sets the Checksum field's value.
func (s *GetIntentOutput) SetChecksum(v string) *GetIntentOutput {
	s.Checksum = &v
	return s
}

// SetConclusionStatement sets the ConclusionStatement field's value.
func (s *GetIntentOutput) SetConclusionStatement(v *Statement) *GetIntentOutput {
	s.ConclusionStatement = v
	return s
}

// SetConfirmationPrompt sets the ConfirmationPrompt field's value.
func (s *GetIntentOutput) SetConfirmationPrompt(v *Prompt) *GetIntentOutput {
	s.ConfirmationPrompt = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetIntentOutput) SetCreatedDate(v time.Time) *GetIntentOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetIntentOutput) SetDescription(v string) *GetIntentOutput {
	s.Description = &v
	return s
}

// SetDialogCodeHook sets the DialogCodeHook field's value.
func (s *GetIntentOutput) SetDialogCodeHook(v *CodeHook) *GetIntentOutput {
	s.DialogCodeHook = v
	return s
}

// SetFollowUpPrompt sets the FollowUpPrompt field's value.
func (s *GetIntentOutput) SetFollowUpPrompt(v *FollowUpPrompt) *GetIntentOutput {
	s.FollowUpPrompt = v
	return s
}

// SetFulfillmentActivity sets the FulfillmentActivity field's value.
func (s *GetIntentOutput) SetFulfillmentActivity(v *FulfillmentActivity) *GetIntentOutput {
	s.FulfillmentActivity = v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *GetIntentOutput) SetLastUpdatedDate(v time.Time) *GetIntentOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetIntentOutput) SetName(v string) *GetIntentOutput {
	s.Name = &v
	return s
}

// SetParentIntentSignature sets the ParentIntentSignature field's value.
func (s *GetIntentOutput) SetParentIntentSignature(v string) *GetIntentOutput {
	s.ParentIntentSignature = &v
	return s
}

// SetRejectionStatement sets the RejectionStatement field's value.
func (s *GetIntentOutput) SetRejectionStatement(v *Statement) *GetIntentOutput {
	s.RejectionStatement = v
	return s
}

// SetSampleUtterances sets the SampleUtterances field's value.
func (s *GetIntentOutput) SetSampleUtterances(v []*string) *GetIntentOutput {
	s.SampleUtterances = v
	return s
}

// SetSlots sets the Slots field's value.
func (s *GetIntentOutput) SetSlots(v []*Slot) *GetIntentOutput {
	s.Slots = v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetIntentOutput) SetVersion(v string) *GetIntentOutput {
	s.Version = &v
	return s
}

type GetIntentVersionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of intent versions to return in the response. The default
	// is 10.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The name of the intent for which versions should be returned.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// A pagination token for fetching the next page of intent versions. If the
	// response to this call is truncated, Amazon Lex returns a pagination token
	// in the response. To fetch the next page of versions, specify the pagination
	// token in the next request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetIntentVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntentVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIntentVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIntentVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetIntentVersionsInput) SetMaxResults(v int64) *GetIntentVersionsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetIntentVersionsInput) SetName(v string) *GetIntentVersionsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetIntentVersionsInput) SetNextToken(v string) *GetIntentVersionsInput {
	s.NextToken = &v
	return s
}

type GetIntentVersionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of IntentMetadata objects, one for each numbered version of the
	// intent plus one for the $LATEST version.
	Intents []*IntentMetadata `locationName:"intents" type:"list"`

	// A pagination token for fetching the next page of intent versions. If the
	// response to this call is truncated, Amazon Lex returns a pagination token
	// in the response. To fetch the next page of versions, specify the pagination
	// token in the next request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetIntentVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntentVersionsOutput) GoString() string {
	return s.String()
}

// SetIntents sets the Intents field's value.
func (s *GetIntentVersionsOutput) SetIntents(v []*IntentMetadata) *GetIntentVersionsOutput {
	s.Intents = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetIntentVersionsOutput) SetNextToken(v string) *GetIntentVersionsOutput {
	s.NextToken = &v
	return s
}

type GetIntentsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of intents to return in the response. The default is 10.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Substring to match in intent names. An intent will be returned if any part
	// of its name matches the substring. For example, "xyz" matches both "xyzabc"
	// and "abcxyz."
	NameContains *string `location:"querystring" locationName:"nameContains" min:"1" type:"string"`

	// A pagination token that fetches the next page of intents. If the response
	// to this API call is truncated, Amazon Lex returns a pagination token in the
	// response. To fetch the next page of intents, specify the pagination token
	// in the next request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetIntentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIntentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIntentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetIntentsInput) SetMaxResults(v int64) *GetIntentsInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *GetIntentsInput) SetNameContains(v string) *GetIntentsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetIntentsInput) SetNextToken(v string) *GetIntentsInput {
	s.NextToken = &v
	return s
}

type GetIntentsOutput struct {
	_ struct{} `type:"structure"`

	// An array of Intent objects. For more information, see PutBot.
	Intents []*IntentMetadata `locationName:"intents" type:"list"`

	// If the response is truncated, the response includes a pagination token that
	// you can specify in your next request to fetch the next page of intents.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetIntentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntentsOutput) GoString() string {
	return s.String()
}

// SetIntents sets the Intents field's value.
func (s *GetIntentsOutput) SetIntents(v []*IntentMetadata) *GetIntentsOutput {
	s.Intents = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetIntentsOutput) SetNextToken(v string) *GetIntentsOutput {
	s.NextToken = &v
	return s
}

type GetSlotTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the slot type. The name is case sensitive.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The version of the slot type.
	//
	// Version is a required field
	Version *string `location:"uri" locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSlotTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSlotTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSlotTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSlotTypeInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetSlotTypeInput) SetName(v string) *GetSlotTypeInput {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetSlotTypeInput) SetVersion(v string) *GetSlotTypeInput {
	s.Version = &v
	return s
}

type GetSlotTypeOutput struct {
	_ struct{} `type:"structure"`

	// Checksum of the $LATEST version of the slot type.
	Checksum *string `locationName:"checksum" type:"string"`

	// The date that the slot type was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A description of the slot type.
	Description *string `locationName:"description" type:"string"`

	// A list of EnumerationValue objects that defines the values that the slot
	// type can take.
	EnumerationValues []*EnumerationValue `locationName:"enumerationValues" min:"1" type:"list"`

	// The date that the slot type was updated. When you create a resource, the
	// creation date and last update date are the same.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// The name of the slot type.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The strategy that Amazon Lex uses to determine the value of the slot. For
	// more information, see PutSlotType.
	ValueSelectionStrategy *string `locationName:"valueSelectionStrategy" type:"string" enum:"SlotValueSelectionStrategy"`

	// The version of the slot type.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s GetSlotTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSlotTypeOutput) GoString() string {
	return s.String()
}

// SetChecksum sets the Checksum field's value.
func (s *GetSlotTypeOutput) SetChecksum(v string) *GetSlotTypeOutput {
	s.Checksum = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetSlotTypeOutput) SetCreatedDate(v time.Time) *GetSlotTypeOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetSlotTypeOutput) SetDescription(v string) *GetSlotTypeOutput {
	s.Description = &v
	return s
}

// SetEnumerationValues sets the EnumerationValues field's value.
func (s *GetSlotTypeOutput) SetEnumerationValues(v []*EnumerationValue) *GetSlotTypeOutput {
	s.EnumerationValues = v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *GetSlotTypeOutput) SetLastUpdatedDate(v time.Time) *GetSlotTypeOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetSlotTypeOutput) SetName(v string) *GetSlotTypeOutput {
	s.Name = &v
	return s
}

// SetValueSelectionStrategy sets the ValueSelectionStrategy field's value.
func (s *GetSlotTypeOutput) SetValueSelectionStrategy(v string) *GetSlotTypeOutput {
	s.ValueSelectionStrategy = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetSlotTypeOutput) SetVersion(v string) *GetSlotTypeOutput {
	s.Version = &v
	return s
}

type GetSlotTypeVersionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of slot type versions to return in the response. The default
	// is 10.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The name of the slot type for which versions should be returned.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// A pagination token for fetching the next page of slot type versions. If the
	// response to this call is truncated, Amazon Lex returns a pagination token
	// in the response. To fetch the next page of versions, specify the pagination
	// token in the next request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetSlotTypeVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSlotTypeVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSlotTypeVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSlotTypeVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetSlotTypeVersionsInput) SetMaxResults(v int64) *GetSlotTypeVersionsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetSlotTypeVersionsInput) SetName(v string) *GetSlotTypeVersionsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetSlotTypeVersionsInput) SetNextToken(v string) *GetSlotTypeVersionsInput {
	s.NextToken = &v
	return s
}

type GetSlotTypeVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token for fetching the next page of slot type versions. If the
	// response to this call is truncated, Amazon Lex returns a pagination token
	// in the response. To fetch the next page of versions, specify the pagination
	// token in the next request.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of SlotTypeMetadata objects, one for each numbered version of the
	// slot type plus one for the $LATEST version.
	SlotTypes []*SlotTypeMetadata `locationName:"slotTypes" type:"list"`
}

// String returns the string representation
func (s GetSlotTypeVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSlotTypeVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetSlotTypeVersionsOutput) SetNextToken(v string) *GetSlotTypeVersionsOutput {
	s.NextToken = &v
	return s
}

// SetSlotTypes sets the SlotTypes field's value.
func (s *GetSlotTypeVersionsOutput) SetSlotTypes(v []*SlotTypeMetadata) *GetSlotTypeVersionsOutput {
	s.SlotTypes = v
	return s
}

type GetSlotTypesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of slot types to return in the response. The default is
	// 10.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Substring to match in slot type names. A slot type will be returned if any
	// part of its name matches the substring. For example, "xyz" matches both "xyzabc"
	// and "abcxyz."
	NameContains *string `location:"querystring" locationName:"nameContains" min:"1" type:"string"`

	// A pagination token that fetches the next page of slot types. If the response
	// to this API call is truncated, Amazon Lex returns a pagination token in the
	// response. To fetch next page of slot types, specify the pagination token
	// in the next request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetSlotTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSlotTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSlotTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSlotTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetSlotTypesInput) SetMaxResults(v int64) *GetSlotTypesInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *GetSlotTypesInput) SetNameContains(v string) *GetSlotTypesInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetSlotTypesInput) SetNextToken(v string) *GetSlotTypesInput {
	s.NextToken = &v
	return s
}

type GetSlotTypesOutput struct {
	_ struct{} `type:"structure"`

	// If the response is truncated, it includes a pagination token that you can
	// specify in your next request to fetch the next page of slot types.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects, one for each slot type, that provides information such
	// as the name of the slot type, the version, and a description.
	SlotTypes []*SlotTypeMetadata `locationName:"slotTypes" type:"list"`
}

// String returns the string representation
func (s GetSlotTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSlotTypesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetSlotTypesOutput) SetNextToken(v string) *GetSlotTypesOutput {
	s.NextToken = &v
	return s
}

// SetSlotTypes sets the SlotTypes field's value.
func (s *GetSlotTypesOutput) SetSlotTypes(v []*SlotTypeMetadata) *GetSlotTypesOutput {
	s.SlotTypes = v
	return s
}

type GetUtterancesViewInput struct {
	_ struct{} `type:"structure"`

	// The name of the bot for which utterance information should be returned.
	//
	// BotName is a required field
	BotName *string `location:"uri" locationName:"botname" min:"2" type:"string" required:"true"`

	// An array of bot versions for which utterance information should be returned.
	// The limit is 5 versions per request.
	//
	// BotVersions is a required field
	BotVersions []*string `location:"querystring" locationName:"bot_versions" min:"1" type:"list" required:"true"`

	// To return utterances that were recognized and handled, use Detected. To return
	// utterances that were not recognized, use Missed.
	//
	// StatusType is a required field
	StatusType *string `location:"querystring" locationName:"status_type" type:"string" required:"true" enum:"StatusType"`
}

// String returns the string representation
func (s GetUtterancesViewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUtterancesViewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUtterancesViewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUtterancesViewInput"}
	if s.BotName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotName"))
	}
	if s.BotName != nil && len(*s.BotName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("BotName", 2))
	}
	if s.BotVersions == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersions"))
	}
	if s.BotVersions != nil && len(s.BotVersions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersions", 1))
	}
	if s.StatusType == nil {
		invalidParams.Add(request.NewErrParamRequired("StatusType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotName sets the BotName field's value.
func (s *GetUtterancesViewInput) SetBotName(v string) *GetUtterancesViewInput {
	s.BotName = &v
	return s
}

// SetBotVersions sets the BotVersions field's value.
func (s *GetUtterancesViewInput) SetBotVersions(v []*string) *GetUtterancesViewInput {
	s.BotVersions = v
	return s
}

// SetStatusType sets the StatusType field's value.
func (s *GetUtterancesViewInput) SetStatusType(v string) *GetUtterancesViewInput {
	s.StatusType = &v
	return s
}

type GetUtterancesViewOutput struct {
	_ struct{} `type:"structure"`

	// The name of the bot for which utterance information was returned.
	BotName *string `locationName:"botName" min:"2" type:"string"`

	// An array of UtteranceList objects, each containing a list of UtteranceData
	// objects describing the utterances that were processed by your bot. The response
	// contains a maximum of 100 UtteranceData objects for each version. Amazon
	// Lex returns the most frequent utterances received by the bot in the last
	// 15 days.
	Utterances []*UtteranceList `locationName:"utterances" type:"list"`
}

// String returns the string representation
func (s GetUtterancesViewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUtterancesViewOutput) GoString() string {
	return s.String()
}

// SetBotName sets the BotName field's value.
func (s *GetUtterancesViewOutput) SetBotName(v string) *GetUtterancesViewOutput {
	s.BotName = &v
	return s
}

// SetUtterances sets the Utterances field's value.
func (s *GetUtterancesViewOutput) SetUtterances(v []*UtteranceList) *GetUtterancesViewOutput {
	s.Utterances = v
	return s
}

// Identifies the specific version of an intent.
type Intent struct {
	_ struct{} `type:"structure"`

	// The name of the intent.
	//
	// IntentName is a required field
	IntentName *string `locationName:"intentName" min:"1" type:"string" required:"true"`

	// The version of the intent.
	//
	// IntentVersion is a required field
	IntentVersion *string `locationName:"intentVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Intent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Intent) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Intent) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Intent"}
	if s.IntentName == nil {
		invalidParams.Add(request.NewErrParamRequired("IntentName"))
	}
	if s.IntentName != nil && len(*s.IntentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntentName", 1))
	}
	if s.IntentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("IntentVersion"))
	}
	if s.IntentVersion != nil && len(*s.IntentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntentVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIntentName sets the IntentName field's value.
func (s *Intent) SetIntentName(v string) *Intent {
	s.IntentName = &v
	return s
}

// SetIntentVersion sets the IntentVersion field's value.
func (s *Intent) SetIntentVersion(v string) *Intent {
	s.IntentVersion = &v
	return s
}

// Provides information about an intent.
type IntentMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the intent was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A description of the intent.
	Description *string `locationName:"description" type:"string"`

	// The date that the intent was updated. When you create an intent, the creation
	// date and last updated date are the same.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// The name of the intent.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The version of the intent.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s IntentMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IntentMetadata) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *IntentMetadata) SetCreatedDate(v time.Time) *IntentMetadata {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *IntentMetadata) SetDescription(v string) *IntentMetadata {
	s.Description = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *IntentMetadata) SetLastUpdatedDate(v time.Time) *IntentMetadata {
	s.LastUpdatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *IntentMetadata) SetName(v string) *IntentMetadata {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *IntentMetadata) SetVersion(v string) *IntentMetadata {
	s.Version = &v
	return s
}

// An internal Amazon Lex error occurred. Try your request again.
type InternalFailureException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalFailureException) GoString() string {
	return s.String()
}

func newErrorInternalFailureException(v protocol.ResponseMetadata) error {
	return &InternalFailureException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InternalFailureException) Code() string {
	return "InternalFailureException"
}

// Message returns the exception's message.
func (s InternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InternalFailureException) OrigErr() error {
	return nil
}

func (s InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InternalFailureException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InternalFailureException) RequestID() string {
	return s.respMetadata.RequestID
}

// The request exceeded a limit. Try your request again.
type LimitExceededException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`

	RetryAfterSeconds *string `location:"header" locationName:"Retry-After" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s LimitExceededException) OrigErr() error {
	return nil
}

func (s LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s LimitExceededException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s LimitExceededException) RequestID() string {
	return s.respMetadata.RequestID
}

// Settings used to configure delivery mode and destination for conversation
// logs.
type LogSettingsRequest struct {
	_ struct{} `type:"structure"`

	// Where the logs will be delivered. Text logs are delivered to a CloudWatch
	// Logs log group. Audio logs are delivered to an S3 bucket.
	//
	// Destination is a required field
	Destination *string `locationName:"destination" type:"string" required:"true" enum:"Destination"`

	// The Amazon Resource Name (ARN) of the AWS KMS customer managed key for encrypting
	// audio logs delivered to an S3 bucket. The key does not apply to CloudWatch
	// Logs and is optional for S3 buckets.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"20" type:"string"`

	// The type of logging to enable. Text logs are delivered to a CloudWatch Logs
	// log group. Audio logs are delivered to an S3 bucket.
	//
	// LogType is a required field
	LogType *string `locationName:"logType" type:"string" required:"true" enum:"LogType"`

	// The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3 bucket
	// where the logs should be delivered.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s LogSettingsRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogSettingsRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogSettingsRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LogSettingsRequest"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 20))
	}
	if s.LogType == nil {
		invalidParams.Add(request.NewErrParamRequired("LogType"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *LogSettingsRequest) SetDestination(v string) *LogSettingsRequest {
	s.Destination = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *LogSettingsRequest) SetKmsKeyArn(v string) *LogSettingsRequest {
	s.KmsKeyArn = &v
	return s
}

// SetLogType sets the LogType field's value.
func (s *LogSettingsRequest) SetLogType(v string) *LogSettingsRequest {
	s.LogType = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *LogSettingsRequest) SetResourceArn(v string) *LogSettingsRequest {
	s.ResourceArn = &v
	return s
}

// The settings for conversation logs.
type LogSettingsResponse struct {
	_ struct{} `type:"structure"`

	// The destination where logs are delivered.
	Destination *string `locationName:"destination" type:"string" enum:"Destination"`

	// The Amazon Resource Name (ARN) of the key used to encrypt audio logs in an
	// S3 bucket.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"20" type:"string"`

	// The type of logging that is enabled.
	LogType *string `locationName:"logType" type:"string" enum:"LogType"`

	// The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3 bucket
	// where the logs are delivered.
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string"`

	// The resource prefix is the first part of the S3 object key within the S3
	// bucket that you specified to contain audio logs. For CloudWatch Logs it is
	// the prefix of the log stream name within the log group that you specified.
	ResourcePrefix *string `locationName:"resourcePrefix" type:"string"`
}

// String returns the string representation
func (s LogSettingsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogSettingsResponse) GoString() string {
	return s.String()
}

// SetDestination sets the Destination field's value.
func (s *LogSettingsResponse) SetDestination(v string) *LogSettingsResponse {
	s.Destination = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *LogSettingsResponse) SetKmsKeyArn(v string) *LogSettingsResponse {
	s.KmsKeyArn = &v
	return s
}

// SetLogType sets the LogType field's value.
func (s *LogSettingsResponse) SetLogType(v string) *LogSettingsResponse {
	s.LogType = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *LogSettingsResponse) SetResourceArn(v string) *LogSettingsResponse {
	s.ResourceArn = &v
	return s
}

// SetResourcePrefix sets the ResourcePrefix field's value.
func (s *LogSettingsResponse) SetResourcePrefix(v string) *LogSettingsResponse {
	s.ResourcePrefix = &v
	return s
}

// The message object that provides the message text and its type.
type Message struct {
	_ struct{} `type:"structure"`

	// The text of the message.
	//
	// Content is a required field
	Content *string `locationName:"content" min:"1" type:"string" required:"true"`

	// The content type of the message string.
	//
	// ContentType is a required field
	ContentType *string `locationName:"contentType" type:"string" required:"true" enum:"ContentType"`

	// Identifies the message group that the message belongs to. When a group is
	// assigned to a message, Amazon Lex returns one message from each group in
	// the response.
	GroupNumber *int64 `locationName:"groupNumber" min:"1" type:"integer"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Message) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Message) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Message"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.GroupNumber != nil && *s.GroupNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("GroupNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *Message) SetContent(v string) *Message {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *Message) SetContentType(v string) *Message {
	s.ContentType = &v
	return s
}

// SetGroupNumber sets the GroupNumber field's value.
func (s *Message) SetGroupNumber(v int64) *Message {
	s.GroupNumber = &v
	return s
}

// The resource specified in the request was not found. Check the resource and
// try again.
type NotFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s NotFoundException) OrigErr() error {
	return nil
}

func (s NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s NotFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s NotFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

// The checksum of the resource that you are trying to change does not match
// the checksum in the request. Check the resource's checksum and try again.
type PreconditionFailedException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s PreconditionFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PreconditionFailedException) GoString() string {
	return s.String()
}

func newErrorPreconditionFailedException(v protocol.ResponseMetadata) error {
	return &PreconditionFailedException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s PreconditionFailedException) Code() string {
	return "PreconditionFailedException"
}

// Message returns the exception's message.
func (s PreconditionFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s PreconditionFailedException) OrigErr() error {
	return nil
}

func (s PreconditionFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s PreconditionFailedException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s PreconditionFailedException) RequestID() string {
	return s.respMetadata.RequestID
}

// Obtains information from the user. To define a prompt, provide one or more
// messages and specify the number of attempts to get information from the user.
// If you provide more than one message, Amazon Lex chooses one of the messages
// to use to prompt the user. For more information, see how-it-works.
type Prompt struct {
	_ struct{} `type:"structure"`

	// The number of times to prompt the user for information.
	//
	// MaxAttempts is a required field
	MaxAttempts *int64 `locationName:"maxAttempts" min:"1" type:"integer" required:"true"`

	// An array of objects, each of which provides a message string and its type.
	// You can specify the message string in plain text or in Speech Synthesis Markup
	// Language (SSML).
	//
	// Messages is a required field
	Messages []*Message `locationName:"messages" min:"1" type:"list" required:"true"`

	// A response card. Amazon Lex uses this prompt at runtime, in the PostText
	// API response. It substitutes session attributes and slot values for placeholders
	// in the response card. For more information, see ex-resp-card.
	ResponseCard *string `locationName:"responseCard" min:"1" type:"string"`
}

// String returns the string representation
func (s Prompt) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Prompt) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Prompt) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Prompt"}
	if s.MaxAttempts == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxAttempts"))
	}
	if s.MaxAttempts != nil && *s.MaxAttempts < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxAttempts", 1))
	}
	if s.Messages == nil {
		invalidParams.Add(request.NewErrParamRequired("Messages"))
	}
	if s.Messages != nil && len(s.Messages) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Messages", 1))
	}
	if s.ResponseCard != nil && len(*s.ResponseCard) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResponseCard", 1))
	}
	if s.Messages != nil {
		for i, v := range s.Messages {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Messages", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxAttempts sets the MaxAttempts field's value.
func (s *Prompt) SetMaxAttempts(v int64) *Prompt {
	s.MaxAttempts = &v
	return s
}

// SetMessages sets the Messages field's value.
func (s *Prompt) SetMessages(v []*Message) *Prompt {
	s.Messages = v
	return s
}

// SetResponseCard sets the ResponseCard field's value.
func (s *Prompt) SetResponseCard(v string) *Prompt {
	s.ResponseCard = &v
	return s
}

type PutBotAliasInput struct {
	_ struct{} `type:"structure"`

	// The name of the bot.
	//
	// BotName is a required field
	BotName *string `location:"uri" locationName:"botName" min:"2" type:"string" required:"true"`

	// The version of the bot.
	//
	// BotVersion is a required field
	BotVersion *string `locationName:"botVersion" min:"1" type:"string" required:"true"`

	// Identifies a specific revision of the $LATEST version.
	//
	// When you create a new bot alias, leave the checksum field blank. If you specify
	// a checksum you get a BadRequestException exception.
	//
	// When you want to update a bot alias, set the checksum field to the checksum
	// of the most recent revision of the $LATEST version. If you don't specify
	// the checksum field, or if the checksum does not match the $LATEST version,
	// you get a PreconditionFailedException exception.
	Checksum *string `locationName:"checksum" type:"string"`

	// Settings for conversation logs for the alias.
	ConversationLogs *ConversationLogsRequest `locationName:"conversationLogs" type:"structure"`

	// A description of the alias.
	Description *string `locationName:"description" type:"string"`

	// The name of the alias. The name is not case sensitive.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutBotAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBotAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBotAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBotAliasInput"}
	if s.BotName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotName"))
	}
	if s.BotName != nil && len(*s.BotName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("BotName", 2))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ConversationLogs != nil {
		if err := s.ConversationLogs.Validate(); err != nil {
			invalidParams.AddNested("ConversationLogs", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotName sets the BotName field's value.
func (s *PutBotAliasInput) SetBotName(v string) *PutBotAliasInput {
	s.BotName = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *PutBotAliasInput) SetBotVersion(v string) *PutBotAliasInput {
	s.BotVersion = &v
	return s
}

// SetChecksum sets the Checksum field's value.
func (s *PutBotAliasInput) SetChecksum(v string) *PutBotAliasInput {
	s.Checksum = &v
	return s
}

// SetConversationLogs sets the ConversationLogs field's value.
func (s *PutBotAliasInput) SetConversationLogs(v *ConversationLogsRequest) *PutBotAliasInput {
	s.ConversationLogs = v
	return s
}

// SetDescription sets the Description field's value.
func (s *PutBotAliasInput) SetDescription(v string) *PutBotAliasInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutBotAliasInput) SetName(v string) *PutBotAliasInput {
	s.Name = &v
	return s
}

type PutBotAliasOutput struct {
	_ struct{} `type:"structure"`

	// The name of the bot that the alias points to.
	BotName *string `locationName:"botName" min:"2" type:"string"`

	// The version of the bot that the alias points to.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// The checksum for the current version of the alias.
	Checksum *string `locationName:"checksum" type:"string"`

	// The settings that determine how Amazon Lex uses conversation logs for the
	// alias.
	ConversationLogs *ConversationLogsResponse `locationName:"conversationLogs" type:"structure"`

	// The date that the bot alias was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A description of the alias.
	Description *string `locationName:"description" type:"string"`

	// The date that the bot alias was updated. When you create a resource, the
	// creation date and the last updated date are the same.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// The name of the alias.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s PutBotAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBotAliasOutput) GoString() string {
	return s.String()
}

// SetBotName sets the BotName field's value.
func (s *PutBotAliasOutput) SetBotName(v string) *PutBotAliasOutput {
	s.BotName = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *PutBotAliasOutput) SetBotVersion(v string) *PutBotAliasOutput {
	s.BotVersion = &v
	return s
}

// SetChecksum sets the Checksum field's value.
func (s *PutBotAliasOutput) SetChecksum(v string) *PutBotAliasOutput {
	s.Checksum = &v
	return s
}

// SetConversationLogs sets the ConversationLogs field's value.
func (s *PutBotAliasOutput) SetConversationLogs(v *ConversationLogsResponse) *PutBotAliasOutput {
	s.ConversationLogs = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PutBotAliasOutput) SetCreatedDate(v time.Time) *PutBotAliasOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PutBotAliasOutput) SetDescription(v string) *PutBotAliasOutput {
	s.Description = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *PutBotAliasOutput) SetLastUpdatedDate(v time.Time) *PutBotAliasOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutBotAliasOutput) SetName(v string) *PutBotAliasOutput {
	s.Name = &v
	return s
}

type PutBotInput struct {
	_ struct{} `type:"structure"`

	// When Amazon Lex can't understand the user's input in context, it tries to
	// elicit the information a few times. After that, Amazon Lex sends the message
	// defined in abortStatement to the user, and then aborts the conversation.
	// To set the number of retries, use the valueElicitationPrompt field for the
	// slot type.
	//
	// For example, in a pizza ordering bot, Amazon Lex might ask a user "What type
	// of crust would you like?" If the user's response is not one of the expected
	// responses (for example, "thin crust, "deep dish," etc.), Amazon Lex tries
	// to elicit a correct response a few more times.
	//
	// For example, in a pizza ordering application, OrderPizza might be one of
	// the intents. This intent might require the CrustType slot. You specify the
	// valueElicitationPrompt field when you create the CrustType slot.
	//
	// If you have defined a fallback intent the abort statement will not be sent
	// to the user, the fallback intent is used instead. For more information, see
	// AMAZON.FallbackIntent (https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html).
	AbortStatement *Statement `locationName:"abortStatement" type:"structure"`

	// Identifies a specific revision of the $LATEST version.
	//
	// When you create a new bot, leave the checksum field blank. If you specify
	// a checksum you get a BadRequestException exception.
	//
	// When you want to update a bot, set the checksum field to the checksum of
	// the most recent revision of the $LATEST version. If you don't specify the
	// checksum field, or if the checksum does not match the $LATEST version, you
	// get a PreconditionFailedException exception.
	Checksum *string `locationName:"checksum" type:"string"`

	// For each Amazon Lex bot created with the Amazon Lex Model Building Service,
	// you must specify whether your use of Amazon Lex is related to a website,
	// program, or other application that is directed or targeted, in whole or in
	// part, to children under age 13 and subject to the Children's Online Privacy
	// Protection Act (COPPA) by specifying true or false in the childDirected field.
	// By specifying true in the childDirected field, you confirm that your use
	// of Amazon Lex is related to a website, program, or other application that
	// is directed or targeted, in whole or in part, to children under age 13 and
	// subject to COPPA. By specifying false in the childDirected field, you confirm
	// that your use of Amazon Lex is not related to a website, program, or other
	// application that is directed or targeted, in whole or in part, to children
	// under age 13 and subject to COPPA. You may not specify a default value for
	// the childDirected field that does not accurately reflect whether your use
	// of Amazon Lex is related to a website, program, or other application that
	// is directed or targeted, in whole or in part, to children under age 13 and
	// subject to COPPA.
	//
	// If your use of Amazon Lex relates to a website, program, or other application
	// that is directed in whole or in part, to children under age 13, you must
	// obtain any required verifiable parental consent under COPPA. For information
	// regarding the use of Amazon Lex in connection with websites, programs, or
	// other applications that are directed or targeted, in whole or in part, to
	// children under age 13, see the Amazon Lex FAQ. (https://aws.amazon.com/lex/faqs#data-security)
	//
	// ChildDirected is a required field
	ChildDirected *bool `locationName:"childDirected" type:"boolean" required:"true"`

	// When Amazon Lex doesn't understand the user's intent, it uses this message
	// to get clarification. To specify how many times Amazon Lex should repeat
	// the clarification prompt, use the maxAttempts field. If Amazon Lex still
	// doesn't understand, it sends the message in the abortStatement field.
	//
	// When you create a clarification prompt, make sure that it suggests the correct
	// response from the user. for example, for a bot that orders pizza and drinks,
	// you might create this clarification prompt: "What would you like to do? You
	// can say 'Order a pizza' or 'Order a drink.'"
	//
	// If you have defined a fallback intent, it will be invoked if the clarification
	// prompt is repeated the number of times defined in the maxAttempts field.
	// For more information, see AMAZON.FallbackIntent (https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html).
	//
	// If you don't define a clarification prompt, at runtime Amazon Lex will return
	// a 400 Bad Request exception in three cases:
	//
	//    * Follow-up prompt - When the user responds to a follow-up prompt but
	//    does not provide an intent. For example, in response to a follow-up prompt
	//    that says "Would you like anything else today?" the user says "Yes." Amazon
	//    Lex will return a 400 Bad Request exception because it does not have a
	//    clarification prompt to send to the user to get an intent.
	//
	//    * Lambda function - When using a Lambda function, you return an ElicitIntent
	//    dialog type. Since Amazon Lex does not have a clarification prompt to
	//    get an intent from the user, it returns a 400 Bad Request exception.
	//
	//    * PutSession operation - When using the PutSession operation, you send
	//    an ElicitIntent dialog type. Since Amazon Lex does not have a clarification
	//    prompt to get an intent from the user, it returns a 400 Bad Request exception.
	ClarificationPrompt *Prompt `locationName:"clarificationPrompt" type:"structure"`

	// When set to true a new numbered version of the bot is created. This is the
	// same as calling the CreateBotVersion operation. If you don't specify createVersion,
	// the default is false.
	CreateVersion *bool `locationName:"createVersion" type:"boolean"`

	// A description of the bot.
	Description *string `locationName:"description" type:"string"`

	// When set to true user utterances are sent to Amazon Comprehend for sentiment
	// analysis. If you don't specify detectSentiment, the default is false.
	DetectSentiment *bool `locationName:"detectSentiment" type:"boolean"`

	// The maximum time in seconds that Amazon Lex retains the data gathered in
	// a conversation.
	//
	// A user interaction session remains active for the amount of time specified.
	// If no conversation occurs during this time, the session expires and Amazon
	// Lex deletes any data provided before the timeout.
	//
	// For example, suppose that a user chooses the OrderPizza intent, but gets
	// sidetracked halfway through placing an order. If the user doesn't complete
	// the order within the specified time, Amazon Lex discards the slot information
	// that it gathered, and the user must start over.
	//
	// If you don't include the idleSessionTTLInSeconds element in a PutBot operation
	// request, Amazon Lex uses the default value. This is also true if the request
	// replaces an existing bot.
	//
	// The default is 300 seconds (5 minutes).
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer"`

	// An array of Intent objects. Each intent represents a command that a user
	// can express. For example, a pizza ordering bot might support an OrderPizza
	// intent. For more information, see how-it-works.
	Intents []*Intent `locationName:"intents" type:"list"`

	// Specifies the target locale for the bot. Any intent used in the bot must
	// be compatible with the locale of the bot.
	//
	// The default is en-US.
	//
	// Locale is a required field
	Locale *string `locationName:"locale" type:"string" required:"true" enum:"Locale"`

	// The name of the bot. The name is not case sensitive.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"2" type:"string" required:"true"`

	// If you set the processBehavior element to BUILD, Amazon Lex builds the bot
	// so that it can be run. If you set the element to SAVE Amazon Lex saves the
	// bot, but doesn't build it.
	//
	// If you don't specify this value, the default value is BUILD.
	ProcessBehavior *string `locationName:"processBehavior" type:"string" enum:"ProcessBehavior"`

	// The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions
	// with the user. The locale configured for the voice must match the locale
	// of the bot. For more information, see Voices in Amazon Polly (https://docs.aws.amazon.com/polly/latest/dg/voicelist.html)
	// in the Amazon Polly Developer Guide.
	VoiceId *string `locationName:"voiceId" type:"string"`
}

// String returns the string representation
func (s PutBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBotInput"}
	if s.ChildDirected == nil {
		invalidParams.Add(request.NewErrParamRequired("ChildDirected"))
	}
	if s.IdleSessionTTLInSeconds != nil && *s.IdleSessionTTLInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IdleSessionTTLInSeconds", 60))
	}
	if s.Locale == nil {
		invalidParams.Add(request.NewErrParamRequired("Locale"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 2))
	}
	if s.AbortStatement != nil {
		if err := s.AbortStatement.Validate(); err != nil {
			invalidParams.AddNested("AbortStatement", err.(request.ErrInvalidParams))
		}
	}
	if s.ClarificationPrompt != nil {
		if err := s.ClarificationPrompt.Validate(); err != nil {
			invalidParams.AddNested("ClarificationPrompt", err.(request.ErrInvalidParams))
		}
	}
	if s.Intents != nil {
		for i, v := range s.Intents {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Intents", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbortStatement sets the AbortStatement field's value.
func (s *PutBotInput) SetAbortStatement(v *Statement) *PutBotInput {
	s.AbortStatement = v
	return s
}

// SetChecksum sets the Checksum field's value.
func (s *PutBotInput) SetChecksum(v string) *PutBotInput {
	s.Checksum = &v
	return s
}

// SetChildDirected sets the ChildDirected field's value.
func (s *PutBotInput) SetChildDirected(v bool) *PutBotInput {
	s.ChildDirected = &v
	return s
}

// SetClarificationPrompt sets the ClarificationPrompt field's value.
func (s *PutBotInput) SetClarificationPrompt(v *Prompt) *PutBotInput {
	s.ClarificationPrompt = v
	return s
}

// SetCreateVersion sets the CreateVersion field's value.
func (s *PutBotInput) SetCreateVersion(v bool) *PutBotInput {
	s.CreateVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PutBotInput) SetDescription(v string) *PutBotInput {
	s.Description = &v
	return s
}

// SetDetectSentiment sets the DetectSentiment field's value.
func (s *PutBotInput) SetDetectSentiment(v bool) *PutBotInput {
	s.DetectSentiment = &v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *PutBotInput) SetIdleSessionTTLInSeconds(v int64) *PutBotInput {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetIntents sets the Intents field's value.
func (s *PutBotInput) SetIntents(v []*Intent) *PutBotInput {
	s.Intents = v
	return s
}

// SetLocale sets the Locale field's value.
func (s *PutBotInput) SetLocale(v string) *PutBotInput {
	s.Locale = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutBotInput) SetName(v string) *PutBotInput {
	s.Name = &v
	return s
}

// SetProcessBehavior sets the ProcessBehavior field's value.
func (s *PutBotInput) SetProcessBehavior(v string) *PutBotInput {
	s.ProcessBehavior = &v
	return s
}

// SetVoiceId sets the VoiceId field's value.
func (s *PutBotInput) SetVoiceId(v string) *PutBotInput {
	s.VoiceId = &v
	return s
}

type PutBotOutput struct {
	_ struct{} `type:"structure"`

	// The message that Amazon Lex uses to abort a conversation. For more information,
	// see PutBot.
	AbortStatement *Statement `locationName:"abortStatement" type:"structure"`

	// Checksum of the bot that you created.
	Checksum *string `locationName:"checksum" type:"string"`

	// For each Amazon Lex bot created with the Amazon Lex Model Building Service,
	// you must specify whether your use of Amazon Lex is related to a website,
	// program, or other application that is directed or targeted, in whole or in
	// part, to children under age 13 and subject to the Children's Online Privacy
	// Protection Act (COPPA) by specifying true or false in the childDirected field.
	// By specifying true in the childDirected field, you confirm that your use
	// of Amazon Lex is related to a website, program, or other application that
	// is directed or targeted, in whole or in part, to children under age 13 and
	// subject to COPPA. By specifying false in the childDirected field, you confirm
	// that your use of Amazon Lex is not related to a website, program, or other
	// application that is directed or targeted, in whole or in part, to children
	// under age 13 and subject to COPPA. You may not specify a default value for
	// the childDirected field that does not accurately reflect whether your use
	// of Amazon Lex is related to a website, program, or other application that
	// is directed or targeted, in whole or in part, to children under age 13 and
	// subject to COPPA.
	//
	// If your use of Amazon Lex relates to a website, program, or other application
	// that is directed in whole or in part, to children under age 13, you must
	// obtain any required verifiable parental consent under COPPA. For information
	// regarding the use of Amazon Lex in connection with websites, programs, or
	// other applications that are directed or targeted, in whole or in part, to
	// children under age 13, see the Amazon Lex FAQ. (https://aws.amazon.com/lex/faqs#data-security)
	ChildDirected *bool `locationName:"childDirected" type:"boolean"`

	// The prompts that Amazon Lex uses when it doesn't understand the user's intent.
	// For more information, see PutBot.
	ClarificationPrompt *Prompt `locationName:"clarificationPrompt" type:"structure"`

	// True if a new version of the bot was created. If the createVersion field
	// was not specified in the request, the createVersion field is set to false
	// in the response.
	CreateVersion *bool `locationName:"createVersion" type:"boolean"`

	// The date that the bot was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A description of the bot.
	Description *string `locationName:"description" type:"string"`

	// true if the bot is configured to send user utterances to Amazon Comprehend
	// for sentiment analysis. If the detectSentiment field was not specified in
	// the request, the detectSentiment field is false in the response.
	DetectSentiment *bool `locationName:"detectSentiment" type:"boolean"`

	// If status is FAILED, Amazon Lex provides the reason that it failed to build
	// the bot.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The maximum length of time that Amazon Lex retains the data gathered in a
	// conversation. For more information, see PutBot.
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer"`

	// An array of Intent objects. For more information, see PutBot.
	Intents []*Intent `locationName:"intents" type:"list"`

	// The date that the bot was updated. When you create a resource, the creation
	// date and last updated date are the same.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// The target locale for the bot.
	Locale *string `locationName:"locale" type:"string" enum:"Locale"`

	// The name of the bot.
	Name *string `locationName:"name" min:"2" type:"string"`

	// When you send a request to create a bot with processBehavior set to BUILD,
	// Amazon Lex sets the status response element to BUILDING.
	//
	// In the READY_BASIC_TESTING state you can test the bot with user inputs that
	// exactly match the utterances configured for the bot's intents and values
	// in the slot types.
	//
	// If Amazon Lex can't build the bot, Amazon Lex sets status to FAILED. Amazon
	// Lex returns the reason for the failure in the failureReason response element.
	//
	// When you set processBehavior to SAVE, Amazon Lex sets the status code to
	// NOT BUILT.
	//
	// When the bot is in the READY state you can test and publish the bot.
	Status *string `locationName:"status" type:"string" enum:"Status"`

	// The version of the bot. For a new bot, the version is always $LATEST.
	Version *string `locationName:"version" min:"1" type:"string"`

	// The Amazon Polly voice ID that Amazon Lex uses for voice interaction with
	// the user. For more information, see PutBot.
	VoiceId *string `locationName:"voiceId" type:"string"`
}

// String returns the string representation
func (s PutBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBotOutput) GoString() string {
	return s.String()
}

// SetAbortStatement sets the AbortStatement field's value.
func (s *PutBotOutput) SetAbortStatement(v *Statement) *PutBotOutput {
	s.AbortStatement = v
	return s
}

// SetChecksum sets the Checksum field's value.
func (s *PutBotOutput) SetChecksum(v string) *PutBotOutput {
	s.Checksum = &v
	return s
}

// SetChildDirected sets the ChildDirected field's value.
func (s *PutBotOutput) SetChildDirected(v bool) *PutBotOutput {
	s.ChildDirected = &v
	return s
}

// SetClarificationPrompt sets the ClarificationPrompt field's value.
func (s *PutBotOutput) SetClarificationPrompt(v *Prompt) *PutBotOutput {
	s.ClarificationPrompt = v
	return s
}

// SetCreateVersion sets the CreateVersion field's value.
func (s *PutBotOutput) SetCreateVersion(v bool) *PutBotOutput {
	s.CreateVersion = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PutBotOutput) SetCreatedDate(v time.Time) *PutBotOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PutBotOutput) SetDescription(v string) *PutBotOutput {
	s.Description = &v
	return s
}

// SetDetectSentiment sets the DetectSentiment field's value.
func (s *PutBotOutput) SetDetectSentiment(v bool) *PutBotOutput {
	s.DetectSentiment = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *PutBotOutput) SetFailureReason(v string) *PutBotOutput {
	s.FailureReason = &v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *PutBotOutput) SetIdleSessionTTLInSeconds(v int64) *PutBotOutput {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetIntents sets the Intents field's value.
func (s *PutBotOutput) SetIntents(v []*Intent) *PutBotOutput {
	s.Intents = v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *PutBotOutput) SetLastUpdatedDate(v time.Time) *PutBotOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *PutBotOutput) SetLocale(v string) *PutBotOutput {
	s.Locale = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutBotOutput) SetName(v string) *PutBotOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PutBotOutput) SetStatus(v string) *PutBotOutput {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PutBotOutput) SetVersion(v string) *PutBotOutput {
	s.Version = &v
	return s
}

// SetVoiceId sets the VoiceId field's value.
func (s *PutBotOutput) SetVoiceId(v string) *PutBotOutput {
	s.VoiceId = &v
	return s
}

type PutIntentInput struct {
	_ struct{} `type:"structure"`

	// Identifies a specific revision of the $LATEST version.
	//
	// When you create a new intent, leave the checksum field blank. If you specify
	// a checksum you get a BadRequestException exception.
	//
	// When you want to update a intent, set the checksum field to the checksum
	// of the most recent revision of the $LATEST version. If you don't specify
	// the checksum field, or if the checksum does not match the $LATEST version,
	// you get a PreconditionFailedException exception.
	Checksum *string `locationName:"checksum" type:"string"`

	// The statement that you want Amazon Lex to convey to the user after the intent
	// is successfully fulfilled by the Lambda function.
	//
	// This element is relevant only if you provide a Lambda function in the fulfillmentActivity.
	// If you return the intent to the client application, you can't specify this
	// element.
	//
	// The followUpPrompt and conclusionStatement are mutually exclusive. You can
	// specify only one.
	ConclusionStatement *Statement `locationName:"conclusionStatement" type:"structure"`

	// Prompts the user to confirm the intent. This question should have a yes or
	// no answer.
	//
	// Amazon Lex uses this prompt to ensure that the user acknowledges that the
	// intent is ready for fulfillment. For example, with the OrderPizza intent,
	// you might want to confirm that the order is correct before placing it. For
	// other intents, such as intents that simply respond to user questions, you
	// might not need to ask the user for confirmation before providing the information.
	//
	// You you must provide both the rejectionStatement and the confirmationPrompt,
	// or neither.
	ConfirmationPrompt *Prompt `locationName:"confirmationPrompt" type:"structure"`

	// When set to true a new numbered version of the intent is created. This is
	// the same as calling the CreateIntentVersion operation. If you do not specify
	// createVersion, the default is false.
	CreateVersion *bool `locationName:"createVersion" type:"boolean"`

	// A description of the intent.
	Description *string `locationName:"description" type:"string"`

	// Specifies a Lambda function to invoke for each user input. You can invoke
	// this Lambda function to personalize user interaction.
	//
	// For example, suppose your bot determines that the user is John. Your Lambda
	// function might retrieve John's information from a backend database and prepopulate
	// some of the values. For example, if you find that John is gluten intolerant,
	// you might set the corresponding intent slot, GlutenIntolerant, to true. You
	// might find John's phone number and set the corresponding session attribute.
	DialogCodeHook *CodeHook `locationName:"dialogCodeHook" type:"structure"`

	// Amazon Lex uses this prompt to solicit additional activity after fulfilling
	// an intent. For example, after the OrderPizza intent is fulfilled, you might
	// prompt the user to order a drink.
	//
	// The action that Amazon Lex takes depends on the user's response, as follows:
	//
	//    * If the user says "Yes" it responds with the clarification prompt that
	//    is configured for the bot.
	//
	//    * if the user says "Yes" and continues with an utterance that triggers
	//    an intent it starts a conversation for the intent.
	//
	//    * If the user says "No" it responds with the rejection statement configured
	//    for the the follow-up prompt.
	//
	//    * If it doesn't recognize the utterance it repeats the follow-up prompt
	//    again.
	//
	// The followUpPrompt field and the conclusionStatement field are mutually exclusive.
	// You can specify only one.
	FollowUpPrompt *FollowUpPrompt `locationName:"followUpPrompt" type:"structure"`

	// Required. Describes how the intent is fulfilled. For example, after a user
	// provides all of the information for a pizza order, fulfillmentActivity defines
	// how the bot places an order with a local pizza store.
	//
	// You might configure Amazon Lex to return all of the intent information to
	// the client application, or direct it to invoke a Lambda function that can
	// process the intent (for example, place an order with a pizzeria).
	FulfillmentActivity *FulfillmentActivity `locationName:"fulfillmentActivity" type:"structure"`

	// The name of the intent. The name is not case sensitive.
	//
	// The name can't match a built-in intent name, or a built-in intent name with
	// "AMAZON." removed. For example, because there is a built-in intent called
	// AMAZON.HelpIntent, you can't create a custom intent called HelpIntent.
	//
	// For a list of built-in intents, see Standard Built-in Intents (https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
	// in the Alexa Skills Kit.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// A unique identifier for the built-in intent to base this intent on. To find
	// the signature for an intent, see Standard Built-in Intents (https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
	// in the Alexa Skills Kit.
	ParentIntentSignature *string `locationName:"parentIntentSignature" type:"string"`

	// When the user answers "no" to the question defined in confirmationPrompt,
	// Amazon Lex responds with this statement to acknowledge that the intent was
	// canceled.
	//
	// You must provide both the rejectionStatement and the confirmationPrompt,
	// or neither.
	RejectionStatement *Statement `locationName:"rejectionStatement" type:"structure"`

	// An array of utterances (strings) that a user might say to signal the intent.
	// For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
	//
	// In each utterance, a slot name is enclosed in curly braces.
	SampleUtterances []*string `locationName:"sampleUtterances" type:"list"`

	// An array of intent slots. At runtime, Amazon Lex elicits required slot values
	// from the user using prompts defined in the slots. For more information, see
	// how-it-works.
	Slots []*Slot `locationName:"slots" type:"list"`
}

// String returns the string representation
func (s PutIntentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutIntentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutIntentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutIntentInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ConclusionStatement != nil {
		if err := s.ConclusionStatement.Validate(); err != nil {
			invalidParams.AddNested("ConclusionStatement", err.(request.ErrInvalidParams))
		}
	}
	if s.ConfirmationPrompt != nil {
		if err := s.ConfirmationPrompt.Validate(); err != nil {
			invalidParams.AddNested("ConfirmationPrompt", err.(request.ErrInvalidParams))
		}
	}
	if s.DialogCodeHook != nil {
		if err := s.DialogCodeHook.Validate(); err != nil {
			invalidParams.AddNested("DialogCodeHook", err.(request.ErrInvalidParams))
		}
	}
	if s.FollowUpPrompt != nil {
		if err := s.FollowUpPrompt.Validate(); err != nil {
			invalidParams.AddNested("FollowUpPrompt", err.(request.ErrInvalidParams))
		}
	}
	if s.FulfillmentActivity != nil {
		if err := s.FulfillmentActivity.Validate(); err != nil {
			invalidParams.AddNested("FulfillmentActivity", err.(request.ErrInvalidParams))
		}
	}
	if s.RejectionStatement != nil {
		if err := s.RejectionStatement.Validate(); err != nil {
			invalidParams.AddNested("RejectionStatement", err.(request.ErrInvalidParams))
		}
	}
	if s.Slots != nil {
		for i, v := range s.Slots {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Slots", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChecksum sets the Checksum field's value.
func (s *PutIntentInput) SetChecksum(v string) *PutIntentInput {
	s.Checksum = &v
	return s
}

// SetConclusionStatement sets the ConclusionStatement field's value.
func (s *PutIntentInput) SetConclusionStatement(v *Statement) *PutIntentInput {
	s.ConclusionStatement = v
	return s
}

// SetConfirmationPrompt sets the ConfirmationPrompt field's value.
func (s *PutIntentInput) SetConfirmationPrompt(v *Prompt) *PutIntentInput {
	s.ConfirmationPrompt = v
	return s
}

// SetCreateVersion sets the CreateVersion field's value.
func (s *PutIntentInput) SetCreateVersion(v bool) *PutIntentInput {
	s.CreateVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PutIntentInput) SetDescription(v string) *PutIntentInput {
	s.Description = &v
	return s
}

// SetDialogCodeHook sets the DialogCodeHook field's value.
func (s *PutIntentInput) SetDialogCodeHook(v *CodeHook) *PutIntentInput {
	s.DialogCodeHook = v
	return s
}

// SetFollowUpPrompt sets the FollowUpPrompt field's value.
func (s *PutIntentInput) SetFollowUpPrompt(v *FollowUpPrompt) *PutIntentInput {
	s.FollowUpPrompt = v
	return s
}

// SetFulfillmentActivity sets the FulfillmentActivity field's value.
func (s *PutIntentInput) SetFulfillmentActivity(v *FulfillmentActivity) *PutIntentInput {
	s.FulfillmentActivity = v
	return s
}

// SetName sets the Name field's value.
func (s *PutIntentInput) SetName(v string) *PutIntentInput {
	s.Name = &v
	return s
}

// SetParentIntentSignature sets the ParentIntentSignature field's value.
func (s *PutIntentInput) SetParentIntentSignature(v string) *PutIntentInput {
	s.ParentIntentSignature = &v
	return s
}

// SetRejectionStatement sets the RejectionStatement field's value.
func (s *PutIntentInput) SetRejectionStatement(v *Statement) *PutIntentInput {
	s.RejectionStatement = v
	return s
}

// SetSampleUtterances sets the SampleUtterances field's value.
func (s *PutIntentInput) SetSampleUtterances(v []*string) *PutIntentInput {
	s.SampleUtterances = v
	return s
}

// SetSlots sets the Slots field's value.
func (s *PutIntentInput) SetSlots(v []*Slot) *PutIntentInput {
	s.Slots = v
	return s
}

type PutIntentOutput struct {
	_ struct{} `type:"structure"`

	// Checksum of the $LATESTversion of the intent created or updated.
	Checksum *string `locationName:"checksum" type:"string"`

	// After the Lambda function specified in thefulfillmentActivityintent fulfills
	// the intent, Amazon Lex conveys this statement to the user.
	ConclusionStatement *Statement `locationName:"conclusionStatement" type:"structure"`

	// If defined in the intent, Amazon Lex prompts the user to confirm the intent
	// before fulfilling it.
	ConfirmationPrompt *Prompt `locationName:"confirmationPrompt" type:"structure"`

	// True if a new version of the intent was created. If the createVersion field
	// was not specified in the request, the createVersion field is set to false
	// in the response.
	CreateVersion *bool `locationName:"createVersion" type:"boolean"`

	// The date that the intent was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A description of the intent.
	Description *string `locationName:"description" type:"string"`

	// If defined in the intent, Amazon Lex invokes this Lambda function for each
	// user input.
	DialogCodeHook *CodeHook `locationName:"dialogCodeHook" type:"structure"`

	// If defined in the intent, Amazon Lex uses this prompt to solicit additional
	// user activity after the intent is fulfilled.
	FollowUpPrompt *FollowUpPrompt `locationName:"followUpPrompt" type:"structure"`

	// If defined in the intent, Amazon Lex invokes this Lambda function to fulfill
	// the intent after the user provides all of the information required by the
	// intent.
	FulfillmentActivity *FulfillmentActivity `locationName:"fulfillmentActivity" type:"structure"`

	// The date that the intent was updated. When you create a resource, the creation
	// date and last update dates are the same.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// The name of the intent.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A unique identifier for the built-in intent that this intent is based on.
	ParentIntentSignature *string `locationName:"parentIntentSignature" type:"string"`

	// If the user answers "no" to the question defined in confirmationPrompt Amazon
	// Lex responds with this statement to acknowledge that the intent was canceled.
	RejectionStatement *Statement `locationName:"rejectionStatement" type:"structure"`

	// An array of sample utterances that are configured for the intent.
	SampleUtterances []*string `locationName:"sampleUtterances" type:"list"`

	// An array of intent slots that are configured for the intent.
	Slots []*Slot `locationName:"slots" type:"list"`

	// The version of the intent. For a new intent, the version is always $LATEST.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s PutIntentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutIntentOutput) GoString() string {
	return s.String()
}

// SetChecksum sets the Checksum field's value.
func (s *PutIntentOutput) SetChecksum(v string) *PutIntentOutput {
	s.Checksum = &v
	return s
}

// SetConclusionStatement sets the ConclusionStatement field's value.
func (s *PutIntentOutput) SetConclusionStatement(v *Statement) *PutIntentOutput {
	s.ConclusionStatement = v
	return s
}

// SetConfirmationPrompt sets the ConfirmationPrompt field's value.
func (s *PutIntentOutput) SetConfirmationPrompt(v *Prompt) *PutIntentOutput {
	s.ConfirmationPrompt = v
	return s
}

// SetCreateVersion sets the CreateVersion field's value.
func (s *PutIntentOutput) SetCreateVersion(v bool) *PutIntentOutput {
	s.CreateVersion = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PutIntentOutput) SetCreatedDate(v time.Time) *PutIntentOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PutIntentOutput) SetDescription(v string) *PutIntentOutput {
	s.Description = &v
	return s
}

// SetDialogCodeHook sets the DialogCodeHook field's value.
func (s *PutIntentOutput) SetDialogCodeHook(v *CodeHook) *PutIntentOutput {
	s.DialogCodeHook = v
	return s
}

// SetFollowUpPrompt sets the FollowUpPrompt field's value.
func (s *PutIntentOutput) SetFollowUpPrompt(v *FollowUpPrompt) *PutIntentOutput {
	s.FollowUpPrompt = v
	return s
}

// SetFulfillmentActivity sets the FulfillmentActivity field's value.
func (s *PutIntentOutput) SetFulfillmentActivity(v *FulfillmentActivity) *PutIntentOutput {
	s.FulfillmentActivity = v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *PutIntentOutput) SetLastUpdatedDate(v time.Time) *PutIntentOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutIntentOutput) SetName(v string) *PutIntentOutput {
	s.Name = &v
	return s
}

// SetParentIntentSignature sets the ParentIntentSignature field's value.
func (s *PutIntentOutput) SetParentIntentSignature(v string) *PutIntentOutput {
	s.ParentIntentSignature = &v
	return s
}

// SetRejectionStatement sets the RejectionStatement field's value.
func (s *PutIntentOutput) SetRejectionStatement(v *Statement) *PutIntentOutput {
	s.RejectionStatement = v
	return s
}

// SetSampleUtterances sets the SampleUtterances field's value.
func (s *PutIntentOutput) SetSampleUtterances(v []*string) *PutIntentOutput {
	s.SampleUtterances = v
	return s
}

// SetSlots sets the Slots field's value.
func (s *PutIntentOutput) SetSlots(v []*Slot) *PutIntentOutput {
	s.Slots = v
	return s
}

// SetVersion sets the Version field's value.
func (s *PutIntentOutput) SetVersion(v string) *PutIntentOutput {
	s.Version = &v
	return s
}

type PutSlotTypeInput struct {
	_ struct{} `type:"structure"`

	// Identifies a specific revision of the $LATEST version.
	//
	// When you create a new slot type, leave the checksum field blank. If you specify
	// a checksum you get a BadRequestException exception.
	//
	// When you want to update a slot type, set the checksum field to the checksum
	// of the most recent revision of the $LATEST version. If you don't specify
	// the checksum field, or if the checksum does not match the $LATEST version,
	// you get a PreconditionFailedException exception.
	Checksum *string `locationName:"checksum" type:"string"`

	// When set to true a new numbered version of the slot type is created. This
	// is the same as calling the CreateSlotTypeVersion operation. If you do not
	// specify createVersion, the default is false.
	CreateVersion *bool `locationName:"createVersion" type:"boolean"`

	// A description of the slot type.
	Description *string `locationName:"description" type:"string"`

	// A list of EnumerationValue objects that defines the values that the slot
	// type can take. Each value can have a list of synonyms, which are additional
	// values that help train the machine learning model about the values that it
	// resolves for a slot.
	//
	// When Amazon Lex resolves a slot value, it generates a resolution list that
	// contains up to five possible values for the slot. If you are using a Lambda
	// function, this resolution list is passed to the function. If you are not
	// using a Lambda function you can choose to return the value that the user
	// entered or the first value in the resolution list as the slot value. The
	// valueSelectionStrategy field indicates the option to use.
	EnumerationValues []*EnumerationValue `locationName:"enumerationValues" min:"1" type:"list"`

	// The name of the slot type. The name is not case sensitive.
	//
	// The name can't match a built-in slot type name, or a built-in slot type name
	// with "AMAZON." removed. For example, because there is a built-in slot type
	// called AMAZON.DATE, you can't create a custom slot type called DATE.
	//
	// For a list of built-in slot types, see Slot Type Reference (https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference)
	// in the Alexa Skills Kit.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// Determines the slot resolution strategy that Amazon Lex uses to return slot
	// type values. The field can be set to one of the following values:
	//
	//    * ORIGINAL_VALUE - Returns the value entered by the user, if the user
	//    value is similar to the slot value.
	//
	//    * TOP_RESOLUTION - If there is a resolution list for the slot, return
	//    the first value in the resolution list as the slot type value. If there
	//    is no resolution list, null is returned.
	//
	// If you don't specify the valueSelectionStrategy, the default is ORIGINAL_VALUE.
	ValueSelectionStrategy *string `locationName:"valueSelectionStrategy" type:"string" enum:"SlotValueSelectionStrategy"`
}

// String returns the string representation
func (s PutSlotTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutSlotTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSlotTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutSlotTypeInput"}
	if s.EnumerationValues != nil && len(s.EnumerationValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnumerationValues", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.EnumerationValues != nil {
		for i, v := range s.EnumerationValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EnumerationValues", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChecksum sets the Checksum field's value.
func (s *PutSlotTypeInput) SetChecksum(v string) *PutSlotTypeInput {
	s.Checksum = &v
	return s
}

// SetCreateVersion sets the CreateVersion field's value.
func (s *PutSlotTypeInput) SetCreateVersion(v bool) *PutSlotTypeInput {
	s.CreateVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PutSlotTypeInput) SetDescription(v string) *PutSlotTypeInput {
	s.Description = &v
	return s
}

// SetEnumerationValues sets the EnumerationValues field's value.
func (s *PutSlotTypeInput) SetEnumerationValues(v []*EnumerationValue) *PutSlotTypeInput {
	s.EnumerationValues = v
	return s
}

// SetName sets the Name field's value.
func (s *PutSlotTypeInput) SetName(v string) *PutSlotTypeInput {
	s.Name = &v
	return s
}

// SetValueSelectionStrategy sets the ValueSelectionStrategy field's value.
func (s *PutSlotTypeInput) SetValueSelectionStrategy(v string) *PutSlotTypeInput {
	s.ValueSelectionStrategy = &v
	return s
}

type PutSlotTypeOutput struct {
	_ struct{} `type:"structure"`

	// Checksum of the $LATEST version of the slot type.
	Checksum *string `locationName:"checksum" type:"string"`

	// True if a new version of the slot type was created. If the createVersion
	// field was not specified in the request, the createVersion field is set to
	// false in the response.
	CreateVersion *bool `locationName:"createVersion" type:"boolean"`

	// The date that the slot type was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A description of the slot type.
	Description *string `locationName:"description" type:"string"`

	// A list of EnumerationValue objects that defines the values that the slot
	// type can take.
	EnumerationValues []*EnumerationValue `locationName:"enumerationValues" min:"1" type:"list"`

	// The date that the slot type was updated. When you create a slot type, the
	// creation date and last update date are the same.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// The name of the slot type.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The slot resolution strategy that Amazon Lex uses to determine the value
	// of the slot. For more information, see PutSlotType.
	ValueSelectionStrategy *string `locationName:"valueSelectionStrategy" type:"string" enum:"SlotValueSelectionStrategy"`

	// The version of the slot type. For a new slot type, the version is always
	// $LATEST.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s PutSlotTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutSlotTypeOutput) GoString() string {
	return s.String()
}

// SetChecksum sets the Checksum field's value.
func (s *PutSlotTypeOutput) SetChecksum(v string) *PutSlotTypeOutput {
	s.Checksum = &v
	return s
}

// SetCreateVersion sets the CreateVersion field's value.
func (s *PutSlotTypeOutput) SetCreateVersion(v bool) *PutSlotTypeOutput {
	s.CreateVersion = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PutSlotTypeOutput) SetCreatedDate(v time.Time) *PutSlotTypeOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PutSlotTypeOutput) SetDescription(v string) *PutSlotTypeOutput {
	s.Description = &v
	return s
}

// SetEnumerationValues sets the EnumerationValues field's value.
func (s *PutSlotTypeOutput) SetEnumerationValues(v []*EnumerationValue) *PutSlotTypeOutput {
	s.EnumerationValues = v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *PutSlotTypeOutput) SetLastUpdatedDate(v time.Time) *PutSlotTypeOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutSlotTypeOutput) SetName(v string) *PutSlotTypeOutput {
	s.Name = &v
	return s
}

// SetValueSelectionStrategy sets the ValueSelectionStrategy field's value.
func (s *PutSlotTypeOutput) SetValueSelectionStrategy(v string) *PutSlotTypeOutput {
	s.ValueSelectionStrategy = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PutSlotTypeOutput) SetVersion(v string) *PutSlotTypeOutput {
	s.Version = &v
	return s
}

// The resource that you are attempting to delete is referred to by another
// resource. Use this information to remove references to the resource that
// you are trying to delete.
//
// The body of the exception contains a JSON object that describes the resource.
//
// { "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,
//
// "resourceReference": {
//
// "name": string, "version": string } }
type ResourceInUseException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	// Describes the resource that refers to the resource that you are attempting
	// to delete. This object is returned as part of the ResourceInUseException
	// exception.
	ExampleReference *ResourceReference `locationName:"exampleReference" type:"structure"`

	ReferenceType *string `locationName:"referenceType" type:"string" enum:"ReferenceType"`
}

// String returns the string representation
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s ResourceInUseException) Message() string {
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ResourceInUseException) OrigErr() error {
	return nil
}

func (s ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s ResourceInUseException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ResourceInUseException) RequestID() string {
	return s.respMetadata.RequestID
}

// Describes the resource that refers to the resource that you are attempting
// to delete. This object is returned as part of the ResourceInUseException
// exception.
type ResourceReference struct {
	_ struct{} `type:"structure"`

	// The name of the resource that is using the resource that you are trying to
	// delete.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The version of the resource that is using the resource that you are trying
	// to delete.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceReference) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ResourceReference) SetName(v string) *ResourceReference {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ResourceReference) SetVersion(v string) *ResourceReference {
	s.Version = &v
	return s
}

// Identifies the version of a specific slot.
type Slot struct {
	_ struct{} `type:"structure"`

	// A description of the slot.
	Description *string `locationName:"description" type:"string"`

	// The name of the slot.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Determines whether a slot is obfuscated in conversation logs and stored utterances.
	// When you obfuscate a slot, the value is replaced by the slot name in curly
	// braces ({}). For example, if the slot name is "full_name", obfuscated values
	// are replaced with "{full_name}". For more information, see Slot Obfuscation
	// (https://docs.aws.amazon.com/lex/latest/dg/how-obfuscate.html).
	ObfuscationSetting *string `locationName:"obfuscationSetting" type:"string" enum:"ObfuscationSetting"`

	// Directs Lex the order in which to elicit this slot value from the user. For
	// example, if the intent has two slots with priorities 1 and 2, AWS Lex first
	// elicits a value for the slot with priority 1.
	//
	// If multiple slots share the same priority, the order in which Lex elicits
	// values is arbitrary.
	Priority *int64 `locationName:"priority" type:"integer"`

	// A set of possible responses for the slot type used by text-based clients.
	// A user chooses an option from the response card, instead of using text to
	// reply.
	ResponseCard *string `locationName:"responseCard" min:"1" type:"string"`

	// If you know a specific pattern with which users might respond to an Amazon
	// Lex request for a slot value, you can provide those utterances to improve
	// accuracy. This is optional. In most cases, Amazon Lex is capable of understanding
	// user utterances.
	SampleUtterances []*string `locationName:"sampleUtterances" type:"list"`

	// Specifies whether the slot is required or optional.
	//
	// SlotConstraint is a required field
	SlotConstraint *string `locationName:"slotConstraint" type:"string" required:"true" enum:"SlotConstraint"`

	// The type of the slot, either a custom slot type that you defined or one of
	// the built-in slot types.
	SlotType *string `locationName:"slotType" min:"1" type:"string"`

	// The version of the slot type.
	SlotTypeVersion *string `locationName:"slotTypeVersion" min:"1" type:"string"`

	// The prompt that Amazon Lex uses to elicit the slot value from the user.
	ValueElicitationPrompt *Prompt `locationName:"valueElicitationPrompt" type:"structure"`
}

// String returns the string representation
func (s Slot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Slot) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Slot) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Slot"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ResponseCard != nil && len(*s.ResponseCard) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResponseCard", 1))
	}
	if s.SlotConstraint == nil {
		invalidParams.Add(request.NewErrParamRequired("SlotConstraint"))
	}
	if s.SlotType != nil && len(*s.SlotType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlotType", 1))
	}
	if s.SlotTypeVersion != nil && len(*s.SlotTypeVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlotTypeVersion", 1))
	}
	if s.ValueElicitationPrompt != nil {
		if err := s.ValueElicitationPrompt.Validate(); err != nil {
			invalidParams.AddNested("ValueElicitationPrompt", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *Slot) SetDescription(v string) *Slot {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *Slot) SetName(v string) *Slot {
	s.Name = &v
	return s
}

// SetObfuscationSetting sets the ObfuscationSetting field's value.
func (s *Slot) SetObfuscationSetting(v string) *Slot {
	s.ObfuscationSetting = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *Slot) SetPriority(v int64) *Slot {
	s.Priority = &v
	return s
}

// SetResponseCard sets the ResponseCard field's value.
func (s *Slot) SetResponseCard(v string) *Slot {
	s.ResponseCard = &v
	return s
}

// SetSampleUtterances sets the SampleUtterances field's value.
func (s *Slot) SetSampleUtterances(v []*string) *Slot {
	s.SampleUtterances = v
	return s
}

// SetSlotConstraint sets the SlotConstraint field's value.
func (s *Slot) SetSlotConstraint(v string) *Slot {
	s.SlotConstraint = &v
	return s
}

// SetSlotType sets the SlotType field's value.
func (s *Slot) SetSlotType(v string) *Slot {
	s.SlotType = &v
	return s
}

// SetSlotTypeVersion sets the SlotTypeVersion field's value.
func (s *Slot) SetSlotTypeVersion(v string) *Slot {
	s.SlotTypeVersion = &v
	return s
}

// SetValueElicitationPrompt sets the ValueElicitationPrompt field's value.
func (s *Slot) SetValueElicitationPrompt(v *Prompt) *Slot {
	s.ValueElicitationPrompt = v
	return s
}

// Provides information about a slot type..
type SlotTypeMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the slot type was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// A description of the slot type.
	Description *string `locationName:"description" type:"string"`

	// The date that the slot type was updated. When you create a resource, the
	// creation date and last updated date are the same.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// The name of the slot type.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The version of the slot type.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s SlotTypeMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SlotTypeMetadata) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *SlotTypeMetadata) SetCreatedDate(v time.Time) *SlotTypeMetadata {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SlotTypeMetadata) SetDescription(v string) *SlotTypeMetadata {
	s.Description = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *SlotTypeMetadata) SetLastUpdatedDate(v time.Time) *SlotTypeMetadata {
	s.LastUpdatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *SlotTypeMetadata) SetName(v string) *SlotTypeMetadata {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *SlotTypeMetadata) SetVersion(v string) *SlotTypeMetadata {
	s.Version = &v
	return s
}

type StartImportInput struct {
	_ struct{} `type:"structure"`

	// Specifies the action that the StartImport operation should take when there
	// is an existing resource with the same name.
	//
	//    * FAIL_ON_CONFLICT - The import operation is stopped on the first conflict
	//    between a resource in the import file and an existing resource. The name
	//    of the resource causing the conflict is in the failureReason field of
	//    the response to the GetImport operation. OVERWRITE_LATEST - The import
	//    operation proceeds even if there is a conflict with an existing resource.
	//    The $LASTEST version of the existing resource is overwritten with the
	//    data from the import file.
	//
	// MergeStrategy is a required field
	MergeStrategy *string `locationName:"mergeStrategy" type:"string" required:"true" enum:"MergeStrategy"`

	// A zip archive in binary format. The archive should contain one file, a JSON
	// file containing the resource to import. The resource should match the type
	// specified in the resourceType field.
	//
	// Payload is automatically base64 encoded/decoded by the SDK.
	//
	// Payload is a required field
	Payload []byte `locationName:"payload" type:"blob" required:"true"`

	// Specifies the type of resource to export. Each resource also exports any
	// resources that it depends on.
	//
	//    * A bot exports dependent intents.
	//
	//    * An intent exports dependent slot types.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation
func (s StartImportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartImportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartImportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartImportInput"}
	if s.MergeStrategy == nil {
		invalidParams.Add(request.NewErrParamRequired("MergeStrategy"))
	}
	if s.Payload == nil {
		invalidParams.Add(request.NewErrParamRequired("Payload"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMergeStrategy sets the MergeStrategy field's value.
func (s *StartImportInput) SetMergeStrategy(v string) *StartImportInput {
	s.MergeStrategy = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *StartImportInput) SetPayload(v []byte) *StartImportInput {
	s.Payload = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StartImportInput) SetResourceType(v string) *StartImportInput {
	s.ResourceType = &v
	return s
}

type StartImportOutput struct {
	_ struct{} `type:"structure"`

	// A timestamp for the date and time that the import job was requested.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// The identifier for the specific import job.
	ImportId *string `locationName:"importId" type:"string"`

	// The status of the import job. If the status is FAILED, you can get the reason
	// for the failure using the GetImport operation.
	ImportStatus *string `locationName:"importStatus" type:"string" enum:"ImportStatus"`

	// The action to take when there is a merge conflict.
	MergeStrategy *string `locationName:"mergeStrategy" type:"string" enum:"MergeStrategy"`

	// The name given to the import job.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The type of resource to import.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s StartImportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartImportOutput) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *StartImportOutput) SetCreatedDate(v time.Time) *StartImportOutput {
	s.CreatedDate = &v
	return s
}

// SetImportId sets the ImportId field's value.
func (s *StartImportOutput) SetImportId(v string) *StartImportOutput {
	s.ImportId = &v
	return s
}

// SetImportStatus sets the ImportStatus field's value.
func (s *StartImportOutput) SetImportStatus(v string) *StartImportOutput {
	s.ImportStatus = &v
	return s
}

// SetMergeStrategy sets the MergeStrategy field's value.
func (s *StartImportOutput) SetMergeStrategy(v string) *StartImportOutput {
	s.MergeStrategy = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartImportOutput) SetName(v string) *StartImportOutput {
	s.Name = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StartImportOutput) SetResourceType(v string) *StartImportOutput {
	s.ResourceType = &v
	return s
}

// A collection of messages that convey information to the user. At runtime,
// Amazon Lex selects the message to convey.
type Statement struct {
	_ struct{} `type:"structure"`

	// A collection of message objects.
	//
	// Messages is a required field
	Messages []*Message `locationName:"messages" min:"1" type:"list" required:"true"`

	// At runtime, if the client is using the PostText (http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html)
	// API, Amazon Lex includes the response card in the response. It substitutes
	// all of the session attributes and slot values for placeholders in the response
	// card.
	ResponseCard *string `locationName:"responseCard" min:"1" type:"string"`
}

// String returns the string representation
func (s Statement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Statement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Statement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Statement"}
	if s.Messages == nil {
		invalidParams.Add(request.NewErrParamRequired("Messages"))
	}
	if s.Messages != nil && len(s.Messages) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Messages", 1))
	}
	if s.ResponseCard != nil && len(*s.ResponseCard) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResponseCard", 1))
	}
	if s.Messages != nil {
		for i, v := range s.Messages {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Messages", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessages sets the Messages field's value.
func (s *Statement) SetMessages(v []*Message) *Statement {
	s.Messages = v
	return s
}

// SetResponseCard sets the ResponseCard field's value.
func (s *Statement) SetResponseCard(v string) *Statement {
	s.ResponseCard = &v
	return s
}

// Provides information about a single utterance that was made to your bot.
type UtteranceData struct {
	_ struct{} `type:"structure"`

	// The number of times that the utterance was processed.
	Count *int64 `locationName:"count" type:"integer"`

	// The total number of individuals that used the utterance.
	DistinctUsers *int64 `locationName:"distinctUsers" type:"integer"`

	// The date that the utterance was first recorded.
	FirstUtteredDate *time.Time `locationName:"firstUtteredDate" type:"timestamp"`

	// The date that the utterance was last recorded.
	LastUtteredDate *time.Time `locationName:"lastUtteredDate" type:"timestamp"`

	// The text that was entered by the user or the text representation of an audio
	// clip.
	UtteranceString *string `locationName:"utteranceString" min:"1" type:"string"`
}

// String returns the string representation
func (s UtteranceData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UtteranceData) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *UtteranceData) SetCount(v int64) *UtteranceData {
	s.Count = &v
	return s
}

// SetDistinctUsers sets the DistinctUsers field's value.
func (s *UtteranceData) SetDistinctUsers(v int64) *UtteranceData {
	s.DistinctUsers = &v
	return s
}

// SetFirstUtteredDate sets the FirstUtteredDate field's value.
func (s *UtteranceData) SetFirstUtteredDate(v time.Time) *UtteranceData {
	s.FirstUtteredDate = &v
	return s
}

// SetLastUtteredDate sets the LastUtteredDate field's value.
func (s *UtteranceData) SetLastUtteredDate(v time.Time) *UtteranceData {
	s.LastUtteredDate = &v
	return s
}

// SetUtteranceString sets the UtteranceString field's value.
func (s *UtteranceData) SetUtteranceString(v string) *UtteranceData {
	s.UtteranceString = &v
	return s
}

// Provides a list of utterances that have been made to a specific version of
// your bot. The list contains a maximum of 100 utterances.
type UtteranceList struct {
	_ struct{} `type:"structure"`

	// The version of the bot that processed the list.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// One or more UtteranceData objects that contain information about the utterances
	// that have been made to a bot. The maximum number of object is 100.
	Utterances []*UtteranceData `locationName:"utterances" type:"list"`
}

// String returns the string representation
func (s UtteranceList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UtteranceList) GoString() string {
	return s.String()
}

// SetBotVersion sets the BotVersion field's value.
func (s *UtteranceList) SetBotVersion(v string) *UtteranceList {
	s.BotVersion = &v
	return s
}

// SetUtterances sets the Utterances field's value.
func (s *UtteranceList) SetUtterances(v []*UtteranceData) *UtteranceList {
	s.Utterances = v
	return s
}

const (
	// ChannelStatusInProgress is a ChannelStatus enum value
	ChannelStatusInProgress = "IN_PROGRESS"

	// ChannelStatusCreated is a ChannelStatus enum value
	ChannelStatusCreated = "CREATED"

	// ChannelStatusFailed is a ChannelStatus enum value
	ChannelStatusFailed = "FAILED"
)

const (
	// ChannelTypeFacebook is a ChannelType enum value
	ChannelTypeFacebook = "Facebook"

	// ChannelTypeSlack is a ChannelType enum value
	ChannelTypeSlack = "Slack"

	// ChannelTypeTwilioSms is a ChannelType enum value
	ChannelTypeTwilioSms = "Twilio-Sms"

	// ChannelTypeKik is a ChannelType enum value
	ChannelTypeKik = "Kik"
)

const (
	// ContentTypePlainText is a ContentType enum value
	ContentTypePlainText = "PlainText"

	// ContentTypeSsml is a ContentType enum value
	ContentTypeSsml = "SSML"

	// ContentTypeCustomPayload is a ContentType enum value
	ContentTypeCustomPayload = "CustomPayload"
)

const (
	// DestinationCloudwatchLogs is a Destination enum value
	DestinationCloudwatchLogs = "CLOUDWATCH_LOGS"

	// DestinationS3 is a Destination enum value
	DestinationS3 = "S3"
)

const (
	// ExportStatusInProgress is a ExportStatus enum value
	ExportStatusInProgress = "IN_PROGRESS"

	// ExportStatusReady is a ExportStatus enum value
	ExportStatusReady = "READY"

	// ExportStatusFailed is a ExportStatus enum value
	ExportStatusFailed = "FAILED"
)

const (
	// ExportTypeAlexaSkillsKit is a ExportType enum value
	ExportTypeAlexaSkillsKit = "ALEXA_SKILLS_KIT"

	// ExportTypeLex is a ExportType enum value
	ExportTypeLex = "LEX"
)

const (
	// FulfillmentActivityTypeReturnIntent is a FulfillmentActivityType enum value
	FulfillmentActivityTypeReturnIntent = "ReturnIntent"

	// FulfillmentActivityTypeCodeHook is a FulfillmentActivityType enum value
	FulfillmentActivityTypeCodeHook = "CodeHook"
)

const (
	// ImportStatusInProgress is a ImportStatus enum value
	ImportStatusInProgress = "IN_PROGRESS"

	// ImportStatusComplete is a ImportStatus enum value
	ImportStatusComplete = "COMPLETE"

	// ImportStatusFailed is a ImportStatus enum value
	ImportStatusFailed = "FAILED"
)

const (
	// LocaleEnUs is a Locale enum value
	LocaleEnUs = "en-US"

	// LocaleEnGb is a Locale enum value
	LocaleEnGb = "en-GB"

	// LocaleDeDe is a Locale enum value
	LocaleDeDe = "de-DE"
)

const (
	// LogTypeAudio is a LogType enum value
	LogTypeAudio = "AUDIO"

	// LogTypeText is a LogType enum value
	LogTypeText = "TEXT"
)

const (
	// MergeStrategyOverwriteLatest is a MergeStrategy enum value
	MergeStrategyOverwriteLatest = "OVERWRITE_LATEST"

	// MergeStrategyFailOnConflict is a MergeStrategy enum value
	MergeStrategyFailOnConflict = "FAIL_ON_CONFLICT"
)

const (
	// ObfuscationSettingNone is a ObfuscationSetting enum value
	ObfuscationSettingNone = "NONE"

	// ObfuscationSettingDefaultObfuscation is a ObfuscationSetting enum value
	ObfuscationSettingDefaultObfuscation = "DEFAULT_OBFUSCATION"
)

const (
	// ProcessBehaviorSave is a ProcessBehavior enum value
	ProcessBehaviorSave = "SAVE"

	// ProcessBehaviorBuild is a ProcessBehavior enum value
	ProcessBehaviorBuild = "BUILD"
)

const (
	// ReferenceTypeIntent is a ReferenceType enum value
	ReferenceTypeIntent = "Intent"

	// ReferenceTypeBot is a ReferenceType enum value
	ReferenceTypeBot = "Bot"

	// ReferenceTypeBotAlias is a ReferenceType enum value
	ReferenceTypeBotAlias = "BotAlias"

	// ReferenceTypeBotChannel is a ReferenceType enum value
	ReferenceTypeBotChannel = "BotChannel"
)

const (
	// ResourceTypeBot is a ResourceType enum value
	ResourceTypeBot = "BOT"

	// ResourceTypeIntent is a ResourceType enum value
	ResourceTypeIntent = "INTENT"

	// ResourceTypeSlotType is a ResourceType enum value
	ResourceTypeSlotType = "SLOT_TYPE"
)

const (
	// SlotConstraintRequired is a SlotConstraint enum value
	SlotConstraintRequired = "Required"

	// SlotConstraintOptional is a SlotConstraint enum value
	SlotConstraintOptional = "Optional"
)

const (
	// SlotValueSelectionStrategyOriginalValue is a SlotValueSelectionStrategy enum value
	SlotValueSelectionStrategyOriginalValue = "ORIGINAL_VALUE"

	// SlotValueSelectionStrategyTopResolution is a SlotValueSelectionStrategy enum value
	SlotValueSelectionStrategyTopResolution = "TOP_RESOLUTION"
)

const (
	// StatusBuilding is a Status enum value
	StatusBuilding = "BUILDING"

	// StatusReady is a Status enum value
	StatusReady = "READY"

	// StatusReadyBasicTesting is a Status enum value
	StatusReadyBasicTesting = "READY_BASIC_TESTING"

	// StatusFailed is a Status enum value
	StatusFailed = "FAILED"

	// StatusNotBuilt is a Status enum value
	StatusNotBuilt = "NOT_BUILT"
)

const (
	// StatusTypeDetected is a StatusType enum value
	StatusTypeDetected = "Detected"

	// StatusTypeMissed is a StatusType enum value
	StatusTypeMissed = "Missed"
)
