// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteEventInput struct {
	_ struct{} `type:"structure"`

	// The ID of the event to delete.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteEventInput"}

	if s.EventId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EventId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteEventOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEventOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteEvent = "DeleteEvent"

// DeleteEventRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Deletes the specified event.
//
//    // Example sending a request using DeleteEventRequest.
//    req := client.DeleteEventRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEvent
func (c *Client) DeleteEventRequest(input *DeleteEventInput) DeleteEventRequest {
	op := &aws.Operation{
		Name:       opDeleteEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventInput{}
	}

	req := c.newRequest(op, input, &DeleteEventOutput{})
	return DeleteEventRequest{Request: req, Input: input, Copy: c.DeleteEventRequest}
}

// DeleteEventRequest is the request type for the
// DeleteEvent API operation.
type DeleteEventRequest struct {
	*aws.Request
	Input *DeleteEventInput
	Copy  func(*DeleteEventInput) DeleteEventRequest
}

// Send marshals and sends the DeleteEvent API request.
func (r DeleteEventRequest) Send(ctx context.Context) (*DeleteEventResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteEventResponse{
		DeleteEventOutput: r.Request.Data.(*DeleteEventOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteEventResponse is the response type for the
// DeleteEvent API operation.
type DeleteEventResponse struct {
	*DeleteEventOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteEvent request.
func (r *DeleteEventResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
