package storage

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"net/http"
)

// AccessTier enumerates the values for access tier.
type AccessTier string

const (
	// Cool ...
	Cool AccessTier = "Cool"
	// Hot ...
	Hot AccessTier = "Hot"
)

// PossibleAccessTierValues returns an array of possible values for the AccessTier const type.
func PossibleAccessTierValues() []AccessTier {
	return []AccessTier{Cool, Hot}
}

// AccountStatus enumerates the values for account status.
type AccountStatus string

const (
	// Available ...
	Available AccountStatus = "available"
	// Unavailable ...
	Unavailable AccountStatus = "unavailable"
)

// PossibleAccountStatusValues returns an array of possible values for the AccountStatus const type.
func PossibleAccountStatusValues() []AccountStatus {
	return []AccountStatus{Available, Unavailable}
}

// Action enumerates the values for action.
type Action string

const (
	// Allow ...
	Allow Action = "Allow"
)

// PossibleActionValues returns an array of possible values for the Action const type.
func PossibleActionValues() []Action {
	return []Action{Allow}
}

// Bypass enumerates the values for bypass.
type Bypass string

const (
	// AzureServices ...
	AzureServices Bypass = "AzureServices"
	// Logging ...
	Logging Bypass = "Logging"
	// Metrics ...
	Metrics Bypass = "Metrics"
	// None ...
	None Bypass = "None"
)

// PossibleBypassValues returns an array of possible values for the Bypass const type.
func PossibleBypassValues() []Bypass {
	return []Bypass{AzureServices, Logging, Metrics, None}
}

// DefaultAction enumerates the values for default action.
type DefaultAction string

const (
	// DefaultActionAllow ...
	DefaultActionAllow DefaultAction = "Allow"
	// DefaultActionDeny ...
	DefaultActionDeny DefaultAction = "Deny"
)

// PossibleDefaultActionValues returns an array of possible values for the DefaultAction const type.
func PossibleDefaultActionValues() []DefaultAction {
	return []DefaultAction{DefaultActionAllow, DefaultActionDeny}
}

// HTTPProtocol enumerates the values for http protocol.
type HTTPProtocol string

const (
	// HTTPS ...
	HTTPS HTTPProtocol = "https"
	// Httpshttp ...
	Httpshttp HTTPProtocol = "https,http"
)

// PossibleHTTPProtocolValues returns an array of possible values for the HTTPProtocol const type.
func PossibleHTTPProtocolValues() []HTTPProtocol {
	return []HTTPProtocol{HTTPS, Httpshttp}
}

// ImmutabilityPolicyState enumerates the values for immutability policy state.
type ImmutabilityPolicyState string

const (
	// Locked ...
	Locked ImmutabilityPolicyState = "Locked"
	// Unlocked ...
	Unlocked ImmutabilityPolicyState = "Unlocked"
)

// PossibleImmutabilityPolicyStateValues returns an array of possible values for the ImmutabilityPolicyState const type.
func PossibleImmutabilityPolicyStateValues() []ImmutabilityPolicyState {
	return []ImmutabilityPolicyState{Locked, Unlocked}
}

// ImmutabilityPolicyUpdateType enumerates the values for immutability policy update type.
type ImmutabilityPolicyUpdateType string

const (
	// Extend ...
	Extend ImmutabilityPolicyUpdateType = "extend"
	// Lock ...
	Lock ImmutabilityPolicyUpdateType = "lock"
	// Put ...
	Put ImmutabilityPolicyUpdateType = "put"
)

// PossibleImmutabilityPolicyUpdateTypeValues returns an array of possible values for the ImmutabilityPolicyUpdateType const type.
func PossibleImmutabilityPolicyUpdateTypeValues() []ImmutabilityPolicyUpdateType {
	return []ImmutabilityPolicyUpdateType{Extend, Lock, Put}
}

// KeyPermission enumerates the values for key permission.
type KeyPermission string

const (
	// Full ...
	Full KeyPermission = "Full"
	// Read ...
	Read KeyPermission = "Read"
)

// PossibleKeyPermissionValues returns an array of possible values for the KeyPermission const type.
func PossibleKeyPermissionValues() []KeyPermission {
	return []KeyPermission{Full, Read}
}

// KeySource enumerates the values for key source.
type KeySource string

const (
	// MicrosoftKeyvault ...
	MicrosoftKeyvault KeySource = "Microsoft.Keyvault"
	// MicrosoftStorage ...
	MicrosoftStorage KeySource = "Microsoft.Storage"
)

// PossibleKeySourceValues returns an array of possible values for the KeySource const type.
func PossibleKeySourceValues() []KeySource {
	return []KeySource{MicrosoftKeyvault, MicrosoftStorage}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// BlobStorage ...
	BlobStorage Kind = "BlobStorage"
	// Storage ...
	Storage Kind = "Storage"
	// StorageV2 ...
	StorageV2 Kind = "StorageV2"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{BlobStorage, Storage, StorageV2}
}

// LeaseDuration enumerates the values for lease duration.
type LeaseDuration string

const (
	// Fixed ...
	Fixed LeaseDuration = "Fixed"
	// Infinite ...
	Infinite LeaseDuration = "Infinite"
)

// PossibleLeaseDurationValues returns an array of possible values for the LeaseDuration const type.
func PossibleLeaseDurationValues() []LeaseDuration {
	return []LeaseDuration{Fixed, Infinite}
}

// LeaseState enumerates the values for lease state.
type LeaseState string

const (
	// LeaseStateAvailable ...
	LeaseStateAvailable LeaseState = "Available"
	// LeaseStateBreaking ...
	LeaseStateBreaking LeaseState = "Breaking"
	// LeaseStateBroken ...
	LeaseStateBroken LeaseState = "Broken"
	// LeaseStateExpired ...
	LeaseStateExpired LeaseState = "Expired"
	// LeaseStateLeased ...
	LeaseStateLeased LeaseState = "Leased"
)

// PossibleLeaseStateValues returns an array of possible values for the LeaseState const type.
func PossibleLeaseStateValues() []LeaseState {
	return []LeaseState{LeaseStateAvailable, LeaseStateBreaking, LeaseStateBroken, LeaseStateExpired, LeaseStateLeased}
}

// LeaseStatus enumerates the values for lease status.
type LeaseStatus string

const (
	// LeaseStatusLocked ...
	LeaseStatusLocked LeaseStatus = "Locked"
	// LeaseStatusUnlocked ...
	LeaseStatusUnlocked LeaseStatus = "Unlocked"
)

// PossibleLeaseStatusValues returns an array of possible values for the LeaseStatus const type.
func PossibleLeaseStatusValues() []LeaseStatus {
	return []LeaseStatus{LeaseStatusLocked, LeaseStatusUnlocked}
}

// Permissions enumerates the values for permissions.
type Permissions string

const (
	// A ...
	A Permissions = "a"
	// C ...
	C Permissions = "c"
	// D ...
	D Permissions = "d"
	// L ...
	L Permissions = "l"
	// P ...
	P Permissions = "p"
	// R ...
	R Permissions = "r"
	// U ...
	U Permissions = "u"
	// W ...
	W Permissions = "w"
)

// PossiblePermissionsValues returns an array of possible values for the Permissions const type.
func PossiblePermissionsValues() []Permissions {
	return []Permissions{A, C, D, L, P, R, U, W}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Creating ...
	Creating ProvisioningState = "Creating"
	// ResolvingDNS ...
	ResolvingDNS ProvisioningState = "ResolvingDNS"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Creating, ResolvingDNS, Succeeded}
}

// PublicAccess enumerates the values for public access.
type PublicAccess string

const (
	// PublicAccessBlob ...
	PublicAccessBlob PublicAccess = "Blob"
	// PublicAccessContainer ...
	PublicAccessContainer PublicAccess = "Container"
	// PublicAccessNone ...
	PublicAccessNone PublicAccess = "None"
)

// PossiblePublicAccessValues returns an array of possible values for the PublicAccess const type.
func PossiblePublicAccessValues() []PublicAccess {
	return []PublicAccess{PublicAccessBlob, PublicAccessContainer, PublicAccessNone}
}

// Reason enumerates the values for reason.
type Reason string

const (
	// AccountNameInvalid ...
	AccountNameInvalid Reason = "AccountNameInvalid"
	// AlreadyExists ...
	AlreadyExists Reason = "AlreadyExists"
)

// PossibleReasonValues returns an array of possible values for the Reason const type.
func PossibleReasonValues() []Reason {
	return []Reason{AccountNameInvalid, AlreadyExists}
}

// ReasonCode enumerates the values for reason code.
type ReasonCode string

const (
	// NotAvailableForSubscription ...
	NotAvailableForSubscription ReasonCode = "NotAvailableForSubscription"
	// QuotaID ...
	QuotaID ReasonCode = "QuotaId"
)

// PossibleReasonCodeValues returns an array of possible values for the ReasonCode const type.
func PossibleReasonCodeValues() []ReasonCode {
	return []ReasonCode{NotAvailableForSubscription, QuotaID}
}

// Services enumerates the values for services.
type Services string

const (
	// B ...
	B Services = "b"
	// F ...
	F Services = "f"
	// Q ...
	Q Services = "q"
	// T ...
	T Services = "t"
)

// PossibleServicesValues returns an array of possible values for the Services const type.
func PossibleServicesValues() []Services {
	return []Services{B, F, Q, T}
}

// SignedResource enumerates the values for signed resource.
type SignedResource string

const (
	// SignedResourceB ...
	SignedResourceB SignedResource = "b"
	// SignedResourceC ...
	SignedResourceC SignedResource = "c"
	// SignedResourceF ...
	SignedResourceF SignedResource = "f"
	// SignedResourceS ...
	SignedResourceS SignedResource = "s"
)

// PossibleSignedResourceValues returns an array of possible values for the SignedResource const type.
func PossibleSignedResourceValues() []SignedResource {
	return []SignedResource{SignedResourceB, SignedResourceC, SignedResourceF, SignedResourceS}
}

// SignedResourceTypes enumerates the values for signed resource types.
type SignedResourceTypes string

const (
	// SignedResourceTypesC ...
	SignedResourceTypesC SignedResourceTypes = "c"
	// SignedResourceTypesO ...
	SignedResourceTypesO SignedResourceTypes = "o"
	// SignedResourceTypesS ...
	SignedResourceTypesS SignedResourceTypes = "s"
)

// PossibleSignedResourceTypesValues returns an array of possible values for the SignedResourceTypes const type.
func PossibleSignedResourceTypesValues() []SignedResourceTypes {
	return []SignedResourceTypes{SignedResourceTypesC, SignedResourceTypesO, SignedResourceTypesS}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// PremiumLRS ...
	PremiumLRS SkuName = "Premium_LRS"
	// StandardGRS ...
	StandardGRS SkuName = "Standard_GRS"
	// StandardLRS ...
	StandardLRS SkuName = "Standard_LRS"
	// StandardRAGRS ...
	StandardRAGRS SkuName = "Standard_RAGRS"
	// StandardZRS ...
	StandardZRS SkuName = "Standard_ZRS"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{PremiumLRS, StandardGRS, StandardLRS, StandardRAGRS, StandardZRS}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// Premium ...
	Premium SkuTier = "Premium"
	// Standard ...
	Standard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{Premium, Standard}
}

// State enumerates the values for state.
type State string

const (
	// StateDeprovisioning ...
	StateDeprovisioning State = "deprovisioning"
	// StateFailed ...
	StateFailed State = "failed"
	// StateNetworkSourceDeleted ...
	StateNetworkSourceDeleted State = "networkSourceDeleted"
	// StateProvisioning ...
	StateProvisioning State = "provisioning"
	// StateSucceeded ...
	StateSucceeded State = "succeeded"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateDeprovisioning, StateFailed, StateNetworkSourceDeleted, StateProvisioning, StateSucceeded}
}

// UsageUnit enumerates the values for usage unit.
type UsageUnit string

const (
	// Bytes ...
	Bytes UsageUnit = "Bytes"
	// BytesPerSecond ...
	BytesPerSecond UsageUnit = "BytesPerSecond"
	// Count ...
	Count UsageUnit = "Count"
	// CountsPerSecond ...
	CountsPerSecond UsageUnit = "CountsPerSecond"
	// Percent ...
	Percent UsageUnit = "Percent"
	// Seconds ...
	Seconds UsageUnit = "Seconds"
)

// PossibleUsageUnitValues returns an array of possible values for the UsageUnit const type.
func PossibleUsageUnitValues() []UsageUnit {
	return []UsageUnit{Bytes, BytesPerSecond, Count, CountsPerSecond, Percent, Seconds}
}

// Account the storage account.
type Account struct {
	autorest.Response `json:"-"`
	// Sku - Gets the SKU.
	Sku *Sku `json:"sku,omitempty"`
	// Kind - Gets the Kind. Possible values include: 'Storage', 'StorageV2', 'BlobStorage'
	Kind Kind `json:"kind,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// AccountProperties - Properties of the storage account.
	*AccountProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Sku != nil {
		objectMap["sku"] = a.Sku
	}
	if a.Kind != "" {
		objectMap["kind"] = a.Kind
	}
	if a.Identity != nil {
		objectMap["identity"] = a.Identity
	}
	if a.AccountProperties != nil {
		objectMap["properties"] = a.AccountProperties
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	if a.Type != nil {
		objectMap["type"] = a.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Account struct.
func (a *Account) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				a.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				a.Kind = kind
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				a.Identity = &identity
			}
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				a.AccountProperties = &accountProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AccountCheckNameAvailabilityParameters the parameters used to check the availabity of the storage account name.
type AccountCheckNameAvailabilityParameters struct {
	// Name - The storage account name.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource, Microsoft.Storage/storageAccounts
	Type *string `json:"type,omitempty"`
}

// AccountCreateParameters the parameters used when creating a storage account.
type AccountCreateParameters struct {
	// Sku - Required. Gets or sets the sku name.
	Sku *Sku `json:"sku,omitempty"`
	// Kind - Required. Indicates the type of storage account. Possible values include: 'Storage', 'StorageV2', 'BlobStorage'
	Kind Kind `json:"kind,omitempty"`
	// Location - Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
	Tags map[string]*string `json:"tags"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// AccountPropertiesCreateParameters - The parameters used to create the storage account.
	*AccountPropertiesCreateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountCreateParameters.
func (acp AccountCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if acp.Sku != nil {
		objectMap["sku"] = acp.Sku
	}
	if acp.Kind != "" {
		objectMap["kind"] = acp.Kind
	}
	if acp.Location != nil {
		objectMap["location"] = acp.Location
	}
	if acp.Tags != nil {
		objectMap["tags"] = acp.Tags
	}
	if acp.Identity != nil {
		objectMap["identity"] = acp.Identity
	}
	if acp.AccountPropertiesCreateParameters != nil {
		objectMap["properties"] = acp.AccountPropertiesCreateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountCreateParameters struct.
func (acp *AccountCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				acp.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				acp.Kind = kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				acp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				acp.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				acp.Identity = &identity
			}
		case "properties":
			if v != nil {
				var accountPropertiesCreateParameters AccountPropertiesCreateParameters
				err = json.Unmarshal(*v, &accountPropertiesCreateParameters)
				if err != nil {
					return err
				}
				acp.AccountPropertiesCreateParameters = &accountPropertiesCreateParameters
			}
		}
	}

	return nil
}

// AccountKey an access key for the storage account.
type AccountKey struct {
	// KeyName - Name of the key.
	KeyName *string `json:"keyName,omitempty"`
	// Value - Base 64-encoded value of the key.
	Value *string `json:"value,omitempty"`
	// Permissions - Permissions for the key -- read-only or full permissions. Possible values include: 'Read', 'Full'
	Permissions KeyPermission `json:"permissions,omitempty"`
}

// AccountListKeysResult the response from the ListKeys operation.
type AccountListKeysResult struct {
	autorest.Response `json:"-"`
	// Keys - Gets the list of storage account keys and their properties for the specified storage account.
	Keys *[]AccountKey `json:"keys,omitempty"`
}

// AccountListResult the response from the List Storage Accounts operation.
type AccountListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets the list of storage accounts and their properties.
	Value *[]Account `json:"value,omitempty"`
}

// AccountProperties properties of the storage account.
type AccountProperties struct {
	// ProvisioningState - Gets the status of the storage account at the time the operation was called. Possible values include: 'Creating', 'ResolvingDNS', 'Succeeded'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PrimaryEndpoints - Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object. Note that Standard_ZRS and Premium_LRS accounts only return the blob endpoint.
	PrimaryEndpoints *Endpoints `json:"primaryEndpoints,omitempty"`
	// PrimaryLocation - Gets the location of the primary data center for the storage account.
	PrimaryLocation *string `json:"primaryLocation,omitempty"`
	// StatusOfPrimary - Gets the status indicating whether the primary location of the storage account is available or unavailable. Possible values include: 'Available', 'Unavailable'
	StatusOfPrimary AccountStatus `json:"statusOfPrimary,omitempty"`
	// LastGeoFailoverTime - Gets the timestamp of the most recent instance of a failover to the secondary location. Only the most recent timestamp is retained. This element is not returned if there has never been a failover instance. Only available if the accountType is Standard_GRS or Standard_RAGRS.
	LastGeoFailoverTime *date.Time `json:"lastGeoFailoverTime,omitempty"`
	// SecondaryLocation - Gets the location of the geo-replicated secondary for the storage account. Only available if the accountType is Standard_GRS or Standard_RAGRS.
	SecondaryLocation *string `json:"secondaryLocation,omitempty"`
	// StatusOfSecondary - Gets the status indicating whether the secondary location of the storage account is available or unavailable. Only available if the SKU name is Standard_GRS or Standard_RAGRS. Possible values include: 'Available', 'Unavailable'
	StatusOfSecondary AccountStatus `json:"statusOfSecondary,omitempty"`
	// CreationTime - Gets the creation date and time of the storage account in UTC.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// CustomDomain - Gets the custom domain the user assigned to this storage account.
	CustomDomain *CustomDomain `json:"customDomain,omitempty"`
	// SecondaryEndpoints - Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object from the secondary location of the storage account. Only available if the SKU name is Standard_RAGRS.
	SecondaryEndpoints *Endpoints `json:"secondaryEndpoints,omitempty"`
	// Encryption - Gets the encryption settings on the account. If unspecified, the account is unencrypted.
	Encryption *Encryption `json:"encryption,omitempty"`
	// AccessTier - Required for storage accounts where kind = BlobStorage. The access tier used for billing. Possible values include: 'Hot', 'Cool'
	AccessTier AccessTier `json:"accessTier,omitempty"`
	// EnableHTTPSTrafficOnly - Allows https traffic only to storage service if sets to true.
	EnableHTTPSTrafficOnly *bool `json:"supportsHttpsTrafficOnly,omitempty"`
	// NetworkRuleSet - Network rule set
	NetworkRuleSet *NetworkRuleSet `json:"networkAcls,omitempty"`
}

// AccountPropertiesCreateParameters the parameters used to create the storage account.
type AccountPropertiesCreateParameters struct {
	// CustomDomain - User domain assigned to the storage account. Name is the CNAME source. Only one custom domain is supported per storage account at this time. To clear the existing custom domain, use an empty string for the custom domain name property.
	CustomDomain *CustomDomain `json:"customDomain,omitempty"`
	// Encryption - Provides the encryption settings on the account. If left unspecified the account encryption settings will remain the same. The default setting is unencrypted.
	Encryption *Encryption `json:"encryption,omitempty"`
	// NetworkRuleSet - Network rule set
	NetworkRuleSet *NetworkRuleSet `json:"networkAcls,omitempty"`
	// AccessTier - Required for storage accounts where kind = BlobStorage. The access tier used for billing. Possible values include: 'Hot', 'Cool'
	AccessTier AccessTier `json:"accessTier,omitempty"`
	// EnableHTTPSTrafficOnly - Allows https traffic only to storage service if sets to true.
	EnableHTTPSTrafficOnly *bool `json:"supportsHttpsTrafficOnly,omitempty"`
}

// AccountPropertiesUpdateParameters the parameters used when updating a storage account.
type AccountPropertiesUpdateParameters struct {
	// CustomDomain - Custom domain assigned to the storage account by the user. Name is the CNAME source. Only one custom domain is supported per storage account at this time. To clear the existing custom domain, use an empty string for the custom domain name property.
	CustomDomain *CustomDomain `json:"customDomain,omitempty"`
	// Encryption - Provides the encryption settings on the account. The default setting is unencrypted.
	Encryption *Encryption `json:"encryption,omitempty"`
	// AccessTier - Required for storage accounts where kind = BlobStorage. The access tier used for billing. Possible values include: 'Hot', 'Cool'
	AccessTier AccessTier `json:"accessTier,omitempty"`
	// EnableHTTPSTrafficOnly - Allows https traffic only to storage service if sets to true.
	EnableHTTPSTrafficOnly *bool `json:"supportsHttpsTrafficOnly,omitempty"`
	// NetworkRuleSet - Network rule set
	NetworkRuleSet *NetworkRuleSet `json:"networkAcls,omitempty"`
}

// AccountRegenerateKeyParameters the parameters used to regenerate the storage account key.
type AccountRegenerateKeyParameters struct {
	// KeyName - The name of storage keys that want to be regenerated, possible vaules are key1, key2.
	KeyName *string `json:"keyName,omitempty"`
}

// AccountSasParameters the parameters to list SAS credentials of a storage account.
type AccountSasParameters struct {
	// Services - The signed services accessible with the account SAS. Possible values include: Blob (b), Queue (q), Table (t), File (f). Possible values include: 'B', 'Q', 'T', 'F'
	Services Services `json:"signedServices,omitempty"`
	// ResourceTypes - The signed resource types that are accessible with the account SAS. Service (s): Access to service-level APIs; Container (c): Access to container-level APIs; Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files. Possible values include: 'SignedResourceTypesS', 'SignedResourceTypesC', 'SignedResourceTypesO'
	ResourceTypes SignedResourceTypes `json:"signedResourceTypes,omitempty"`
	// Permissions - The signed permissions for the account SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). Possible values include: 'R', 'D', 'W', 'L', 'A', 'C', 'U', 'P'
	Permissions Permissions `json:"signedPermission,omitempty"`
	// IPAddressOrRange - An IP address or a range of IP addresses from which to accept requests.
	IPAddressOrRange *string `json:"signedIp,omitempty"`
	// Protocols - The protocol permitted for a request made with the account SAS. Possible values include: 'Httpshttp', 'HTTPS'
	Protocols HTTPProtocol `json:"signedProtocol,omitempty"`
	// SharedAccessStartTime - The time at which the SAS becomes valid.
	SharedAccessStartTime *date.Time `json:"signedStart,omitempty"`
	// SharedAccessExpiryTime - The time at which the shared access signature becomes invalid.
	SharedAccessExpiryTime *date.Time `json:"signedExpiry,omitempty"`
	// KeyToSign - The key to sign the account SAS token with.
	KeyToSign *string `json:"keyToSign,omitempty"`
}

// AccountsCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type AccountsCreateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future AccountsCreateFuture) Result(client AccountsClient) (a Account, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storage.AccountsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return a, azure.NewAsyncOpIncompleteError("storage.AccountsCreateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		a, err = client.CreateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "storage.AccountsCreateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "storage.AccountsCreateFuture", "Result", resp, "Failure sending request")
		return
	}
	a, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storage.AccountsCreateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// AccountUpdateParameters the parameters that can be provided when updating the storage account properties.
type AccountUpdateParameters struct {
	// Sku - Gets or sets the SKU name. Note that the SKU name cannot be updated to Standard_ZRS or Premium_LRS, nor can accounts of those sku names be updated to any other value.
	Sku *Sku `json:"sku,omitempty"`
	// Tags - Gets or sets a list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater in length than 128 characters and a value no greater in length than 256 characters.
	Tags map[string]*string `json:"tags"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// AccountPropertiesUpdateParameters - The parameters used when updating a storage account.
	*AccountPropertiesUpdateParameters `json:"properties,omitempty"`
	// Kind - Optional. Indicates the type of storage account. Currently only StorageV2 value supported by server. Possible values include: 'Storage', 'StorageV2', 'BlobStorage'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountUpdateParameters.
func (aup AccountUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aup.Sku != nil {
		objectMap["sku"] = aup.Sku
	}
	if aup.Tags != nil {
		objectMap["tags"] = aup.Tags
	}
	if aup.Identity != nil {
		objectMap["identity"] = aup.Identity
	}
	if aup.AccountPropertiesUpdateParameters != nil {
		objectMap["properties"] = aup.AccountPropertiesUpdateParameters
	}
	if aup.Kind != "" {
		objectMap["kind"] = aup.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountUpdateParameters struct.
func (aup *AccountUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				aup.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				aup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				aup.Identity = &identity
			}
		case "properties":
			if v != nil {
				var accountPropertiesUpdateParameters AccountPropertiesUpdateParameters
				err = json.Unmarshal(*v, &accountPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				aup.AccountPropertiesUpdateParameters = &accountPropertiesUpdateParameters
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				aup.Kind = kind
			}
		}
	}

	return nil
}

// AzureEntityResource the resource model definition for a Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// BlobContainer properties of the blob container, including Id, resource name, resource type, Etag.
type BlobContainer struct {
	autorest.Response `json:"-"`
	// ContainerProperties - Properties of the blob container.
	*ContainerProperties `json:"properties,omitempty"`
	// Etag - Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobContainer.
func (bc BlobContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bc.ContainerProperties != nil {
		objectMap["properties"] = bc.ContainerProperties
	}
	if bc.Etag != nil {
		objectMap["etag"] = bc.Etag
	}
	if bc.ID != nil {
		objectMap["id"] = bc.ID
	}
	if bc.Name != nil {
		objectMap["name"] = bc.Name
	}
	if bc.Type != nil {
		objectMap["type"] = bc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BlobContainer struct.
func (bc *BlobContainer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var containerProperties ContainerProperties
				err = json.Unmarshal(*v, &containerProperties)
				if err != nil {
					return err
				}
				bc.ContainerProperties = &containerProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				bc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bc.Type = &typeVar
			}
		}
	}

	return nil
}

// CheckNameAvailabilityResult the CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - Gets a boolean value that indicates whether the name is available for you to use. If true, the name is available. If false, the name has already been taken or is invalid and cannot be used.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - Gets the reason that a storage account name could not be used. The Reason element is only returned if NameAvailable is false. Possible values include: 'AccountNameInvalid', 'AlreadyExists'
	Reason Reason `json:"reason,omitempty"`
	// Message - Gets an error message explaining the Reason value in more detail.
	Message *string `json:"message,omitempty"`
}

// ContainerProperties the properties of a container.
type ContainerProperties struct {
	// PublicAccess - Specifies whether data in the container may be accessed publicly and the level of access. Possible values include: 'PublicAccessContainer', 'PublicAccessBlob', 'PublicAccessNone'
	PublicAccess PublicAccess `json:"publicAccess,omitempty"`
	// LastModifiedTime - Returns the date and time the container was last modified.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// LeaseStatus - The lease status of the container. Possible values include: 'LeaseStatusLocked', 'LeaseStatusUnlocked'
	LeaseStatus LeaseStatus `json:"leaseStatus,omitempty"`
	// LeaseState - Lease state of the container. Possible values include: 'LeaseStateAvailable', 'LeaseStateLeased', 'LeaseStateExpired', 'LeaseStateBreaking', 'LeaseStateBroken'
	LeaseState LeaseState `json:"leaseState,omitempty"`
	// LeaseDuration - Specifies whether the lease on a container is of infinite or fixed duration, only when the container is leased. Possible values include: 'Infinite', 'Fixed'
	LeaseDuration LeaseDuration `json:"leaseDuration,omitempty"`
	// Metadata - A name-value pair to associate with the container as metadata.
	Metadata map[string]*string `json:"metadata"`
	// ImmutabilityPolicy - The ImmutabilityPolicy property of the container.
	ImmutabilityPolicy *ImmutabilityPolicyProperties `json:"immutabilityPolicy,omitempty"`
	// LegalHold - The LegalHold property of the container.
	LegalHold *LegalHoldProperties `json:"legalHold,omitempty"`
	// HasLegalHold - The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold public property is set to false by SRP if all existing legal hold tags are cleared out. There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
	HasLegalHold *bool `json:"hasLegalHold,omitempty"`
	// HasImmutabilityPolicy - The hasImmutabilityPolicy public property is set to true by SRP if ImmutabilityPolicy has been created for this container. The hasImmutabilityPolicy public property is set to false by SRP if ImmutabilityPolicy has not been created for this container.
	HasImmutabilityPolicy *bool `json:"hasImmutabilityPolicy,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerProperties.
func (cp ContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.PublicAccess != "" {
		objectMap["publicAccess"] = cp.PublicAccess
	}
	if cp.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = cp.LastModifiedTime
	}
	if cp.LeaseStatus != "" {
		objectMap["leaseStatus"] = cp.LeaseStatus
	}
	if cp.LeaseState != "" {
		objectMap["leaseState"] = cp.LeaseState
	}
	if cp.LeaseDuration != "" {
		objectMap["leaseDuration"] = cp.LeaseDuration
	}
	if cp.Metadata != nil {
		objectMap["metadata"] = cp.Metadata
	}
	if cp.ImmutabilityPolicy != nil {
		objectMap["immutabilityPolicy"] = cp.ImmutabilityPolicy
	}
	if cp.LegalHold != nil {
		objectMap["legalHold"] = cp.LegalHold
	}
	if cp.HasLegalHold != nil {
		objectMap["hasLegalHold"] = cp.HasLegalHold
	}
	if cp.HasImmutabilityPolicy != nil {
		objectMap["hasImmutabilityPolicy"] = cp.HasImmutabilityPolicy
	}
	return json.Marshal(objectMap)
}

// CustomDomain the custom domain assigned to this storage account. This can be set via Update.
type CustomDomain struct {
	// Name - Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
	Name *string `json:"name,omitempty"`
	// UseSubDomain - Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
	UseSubDomain *bool `json:"useSubDomain,omitempty"`
}

// Dimension dimension of blobs, possiblly be blob type or access tier.
type Dimension struct {
	// Name - Display name of dimension.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of dimension.
	DisplayName *string `json:"displayName,omitempty"`
}

// Encryption the encryption settings on the storage account.
type Encryption struct {
	// Services - List of services which support encryption.
	Services *EncryptionServices `json:"services,omitempty"`
	// KeySource - The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault. Possible values include: 'MicrosoftStorage', 'MicrosoftKeyvault'
	KeySource KeySource `json:"keySource,omitempty"`
	// KeyVaultProperties - Properties provided by key vault.
	KeyVaultProperties *KeyVaultProperties `json:"keyvaultproperties,omitempty"`
}

// EncryptionService a service that allows server-side encryption to be used.
type EncryptionService struct {
	// Enabled - A boolean indicating whether or not the service encrypts the data as it is stored.
	Enabled *bool `json:"enabled,omitempty"`
	// LastEnabledTime - Gets a rough estimate of the date/time when the encryption was last enabled by the user. Only returned when encryption is enabled. There might be some unencrypted blobs which were written after this time, as it is just a rough estimate.
	LastEnabledTime *date.Time `json:"lastEnabledTime,omitempty"`
}

// EncryptionServices a list of services that support encryption.
type EncryptionServices struct {
	// Blob - The encryption function of the blob storage service.
	Blob *EncryptionService `json:"blob,omitempty"`
	// File - The encryption function of the file storage service.
	File *EncryptionService `json:"file,omitempty"`
	// Table - The encryption function of the table storage service.
	Table *EncryptionService `json:"table,omitempty"`
	// Queue - The encryption function of the queue storage service.
	Queue *EncryptionService `json:"queue,omitempty"`
}

// Endpoints the URIs that are used to perform a retrieval of a public blob, queue, or table object.
type Endpoints struct {
	// Blob - Gets the blob endpoint.
	Blob *string `json:"blob,omitempty"`
	// Queue - Gets the queue endpoint.
	Queue *string `json:"queue,omitempty"`
	// Table - Gets the table endpoint.
	Table *string `json:"table,omitempty"`
	// File - Gets the file endpoint.
	File *string `json:"file,omitempty"`
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type.
	Type *string `json:"type,omitempty"`
}

// ImmutabilityPolicy the ImmutabilityPolicy property of a blob container, including Id, resource name, resource
// type, Etag.
type ImmutabilityPolicy struct {
	autorest.Response `json:"-"`
	// ImmutabilityPolicyProperty - The properties of an ImmutabilityPolicy of a blob container.
	*ImmutabilityPolicyProperty `json:"properties,omitempty"`
	// Etag - Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImmutabilityPolicy.
func (IP ImmutabilityPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.ImmutabilityPolicyProperty != nil {
		objectMap["properties"] = IP.ImmutabilityPolicyProperty
	}
	if IP.Etag != nil {
		objectMap["etag"] = IP.Etag
	}
	if IP.ID != nil {
		objectMap["id"] = IP.ID
	}
	if IP.Name != nil {
		objectMap["name"] = IP.Name
	}
	if IP.Type != nil {
		objectMap["type"] = IP.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImmutabilityPolicy struct.
func (IP *ImmutabilityPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var immutabilityPolicyProperty ImmutabilityPolicyProperty
				err = json.Unmarshal(*v, &immutabilityPolicyProperty)
				if err != nil {
					return err
				}
				IP.ImmutabilityPolicyProperty = &immutabilityPolicyProperty
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				IP.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				IP.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				IP.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				IP.Type = &typeVar
			}
		}
	}

	return nil
}

// ImmutabilityPolicyProperties the properties of an ImmutabilityPolicy of a blob container.
type ImmutabilityPolicyProperties struct {
	// ImmutabilityPolicyProperty - The properties of an ImmutabilityPolicy of a blob container.
	*ImmutabilityPolicyProperty `json:"properties,omitempty"`
	// Etag - ImmutabilityPolicy Etag.
	Etag *string `json:"etag,omitempty"`
	// UpdateHistory - The ImmutabilityPolicy update history of the blob container.
	UpdateHistory *[]UpdateHistoryProperty `json:"updateHistory,omitempty"`
}

// MarshalJSON is the custom marshaler for ImmutabilityPolicyProperties.
func (ipp ImmutabilityPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipp.ImmutabilityPolicyProperty != nil {
		objectMap["properties"] = ipp.ImmutabilityPolicyProperty
	}
	if ipp.Etag != nil {
		objectMap["etag"] = ipp.Etag
	}
	if ipp.UpdateHistory != nil {
		objectMap["updateHistory"] = ipp.UpdateHistory
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImmutabilityPolicyProperties struct.
func (ipp *ImmutabilityPolicyProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var immutabilityPolicyProperty ImmutabilityPolicyProperty
				err = json.Unmarshal(*v, &immutabilityPolicyProperty)
				if err != nil {
					return err
				}
				ipp.ImmutabilityPolicyProperty = &immutabilityPolicyProperty
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ipp.Etag = &etag
			}
		case "updateHistory":
			if v != nil {
				var updateHistory []UpdateHistoryProperty
				err = json.Unmarshal(*v, &updateHistory)
				if err != nil {
					return err
				}
				ipp.UpdateHistory = &updateHistory
			}
		}
	}

	return nil
}

// ImmutabilityPolicyProperty the properties of an ImmutabilityPolicy of a blob container.
type ImmutabilityPolicyProperty struct {
	// ImmutabilityPeriodSinceCreationInDays - The immutability period for the blobs in the container since the policy creation, in days.
	ImmutabilityPeriodSinceCreationInDays *int32 `json:"immutabilityPeriodSinceCreationInDays,omitempty"`
	// State - The ImmutabilityPolicy state of a blob container, possible values include: Locked and Unlocked. Possible values include: 'Locked', 'Unlocked'
	State ImmutabilityPolicyState `json:"state,omitempty"`
}

// IPRule IP rule with specific IP or IP range in CIDR format.
type IPRule struct {
	// IPAddressOrRange - Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
	IPAddressOrRange *string `json:"value,omitempty"`
	// Action - The action of IP ACL rule. Possible values include: 'Allow'
	Action Action `json:"action,omitempty"`
}

// KeyVaultProperties properties of key vault.
type KeyVaultProperties struct {
	// KeyName - The name of KeyVault key.
	KeyName *string `json:"keyname,omitempty"`
	// KeyVersion - The version of KeyVault key.
	KeyVersion *string `json:"keyversion,omitempty"`
	// KeyVaultURI - The Uri of KeyVault.
	KeyVaultURI *string `json:"keyvaulturi,omitempty"`
}

// LegalHold the LegalHold property of a blob container.
type LegalHold struct {
	autorest.Response `json:"-"`
	// HasLegalHold - The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold public property is set to false by SRP if all existing legal hold tags are cleared out. There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
	HasLegalHold *bool `json:"hasLegalHold,omitempty"`
	// Tags - Each tag should be 3 to 23 alphanumeric characters and is normalized to lower case at SRP.
	Tags *[]string `json:"tags,omitempty"`
}

// LegalHoldProperties the LegalHold property of a blob container.
type LegalHoldProperties struct {
	// HasLegalHold - The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold public property is set to false by SRP if all existing legal hold tags are cleared out. There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
	HasLegalHold *bool `json:"hasLegalHold,omitempty"`
	// Tags - The list of LegalHold tags of a blob container.
	Tags *[]TagProperty `json:"tags,omitempty"`
}

// ListAccountSasResponse the List SAS credentials operation response.
type ListAccountSasResponse struct {
	autorest.Response `json:"-"`
	// AccountSasToken - List SAS credentials of storage account.
	AccountSasToken *string `json:"accountSasToken,omitempty"`
}

// ListContainerItem the blob container properties be listed out.
type ListContainerItem struct {
	// ContainerProperties - The blob container properties be listed out.
	*ContainerProperties `json:"properties,omitempty"`
	// Etag - Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ListContainerItem.
func (lci ListContainerItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lci.ContainerProperties != nil {
		objectMap["properties"] = lci.ContainerProperties
	}
	if lci.Etag != nil {
		objectMap["etag"] = lci.Etag
	}
	if lci.ID != nil {
		objectMap["id"] = lci.ID
	}
	if lci.Name != nil {
		objectMap["name"] = lci.Name
	}
	if lci.Type != nil {
		objectMap["type"] = lci.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ListContainerItem struct.
func (lci *ListContainerItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var containerProperties ContainerProperties
				err = json.Unmarshal(*v, &containerProperties)
				if err != nil {
					return err
				}
				lci.ContainerProperties = &containerProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lci.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lci.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lci.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lci.Type = &typeVar
			}
		}
	}

	return nil
}

// ListContainerItems the list of blob containers.
type ListContainerItems struct {
	autorest.Response `json:"-"`
	// Value - The list of blob containers.
	Value *[]ListContainerItem `json:"value,omitempty"`
}

// ListServiceSasResponse the List service SAS credentials operation response.
type ListServiceSasResponse struct {
	autorest.Response `json:"-"`
	// ServiceSasToken - List service SAS credentials of speicific resource.
	ServiceSasToken *string `json:"serviceSasToken,omitempty"`
}

// MetricSpecification metric specification of operation.
type MetricSpecification struct {
	// Name - Name of metric specification.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of metric specification.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Display description of metric specification.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Unit could be Bytes or Count.
	Unit *string `json:"unit,omitempty"`
	// Dimensions - Dimensions of blobs, including blob type and access tier.
	Dimensions *[]Dimension `json:"dimensions,omitempty"`
	// AggregationType - Aggregation type could be Average.
	AggregationType *string `json:"aggregationType,omitempty"`
	// FillGapWithZero - The property to decide fill gap with zero or not.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// Category - The category this metric specification belong to, could be Capacity.
	Category *string `json:"category,omitempty"`
	// ResourceIDDimensionNameOverride - Account Resource Id.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`
}

// NetworkRuleSet network rule set
type NetworkRuleSet struct {
	// Bypass - Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics. Possible values include: 'None', 'Logging', 'Metrics', 'AzureServices'
	Bypass Bypass `json:"bypass,omitempty"`
	// VirtualNetworkRules - Sets the virtual network rules
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	// IPRules - Sets the IP ACL rules
	IPRules *[]IPRule `json:"ipRules,omitempty"`
	// DefaultAction - Specifies the default action of allow or deny when no other rules match. Possible values include: 'DefaultActionAllow', 'DefaultActionDeny'
	DefaultAction DefaultAction `json:"defaultAction,omitempty"`
}

// Operation storage REST API operation definition.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - The origin of operations.
	Origin *string `json:"origin,omitempty"`
	// OperationProperties - Properties of operation, include metric specifications.
	*OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.Origin != nil {
		objectMap["origin"] = o.Origin
	}
	if o.OperationProperties != nil {
		objectMap["properties"] = o.OperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Operation struct.
func (o *Operation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "display":
			if v != nil {
				var display OperationDisplay
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				o.Display = &display
			}
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				o.Origin = &origin
			}
		case "properties":
			if v != nil {
				var operationProperties OperationProperties
				err = json.Unmarshal(*v, &operationProperties)
				if err != nil {
					return err
				}
				o.OperationProperties = &operationProperties
			}
		}
	}

	return nil
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft Storage.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list Storage operations. It contains a list of operations and a URL
// link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Storage operations supported by the Storage resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// OperationProperties properties of operation, include metric specifications.
type OperationProperties struct {
	// ServiceSpecification - One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags
type ProxyResource struct {
	// ID - Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// Resource ...
type Resource struct {
	// ID - Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// Restriction the restriction because of which SKU cannot be used.
type Restriction struct {
	// Type - The type of restrictions. As of now only possible value for this is location.
	Type *string `json:"type,omitempty"`
	// Values - The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted.
	Values *[]string `json:"values,omitempty"`
	// ReasonCode - The reason for the restriction. As of now this can be “QuotaId” or “NotAvailableForSubscription”. Quota Id is set when the SKU has requiredQuotas parameter as the subscription does not belong to that quota. The “NotAvailableForSubscription” is related to capacity at DC. Possible values include: 'QuotaID', 'NotAvailableForSubscription'
	ReasonCode ReasonCode `json:"reasonCode,omitempty"`
}

// ServiceSasParameters the parameters to list service SAS credentials of a speicific resource.
type ServiceSasParameters struct {
	// CanonicalizedResource - The canonical path to the signed resource.
	CanonicalizedResource *string `json:"canonicalizedResource,omitempty"`
	// Resource - The signed services accessible with the service SAS. Possible values include: Blob (b), Container (c), File (f), Share (s). Possible values include: 'SignedResourceB', 'SignedResourceC', 'SignedResourceF', 'SignedResourceS'
	Resource SignedResource `json:"signedResource,omitempty"`
	// Permissions - The signed permissions for the service SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). Possible values include: 'R', 'D', 'W', 'L', 'A', 'C', 'U', 'P'
	Permissions Permissions `json:"signedPermission,omitempty"`
	// IPAddressOrRange - An IP address or a range of IP addresses from which to accept requests.
	IPAddressOrRange *string `json:"signedIp,omitempty"`
	// Protocols - The protocol permitted for a request made with the account SAS. Possible values include: 'Httpshttp', 'HTTPS'
	Protocols HTTPProtocol `json:"signedProtocol,omitempty"`
	// SharedAccessStartTime - The time at which the SAS becomes valid.
	SharedAccessStartTime *date.Time `json:"signedStart,omitempty"`
	// SharedAccessExpiryTime - The time at which the shared access signature becomes invalid.
	SharedAccessExpiryTime *date.Time `json:"signedExpiry,omitempty"`
	// Identifier - A unique value up to 64 characters in length that correlates to an access policy specified for the container, queue, or table.
	Identifier *string `json:"signedIdentifier,omitempty"`
	// PartitionKeyStart - The start of partition key.
	PartitionKeyStart *string `json:"startPk,omitempty"`
	// PartitionKeyEnd - The end of partition key.
	PartitionKeyEnd *string `json:"endPk,omitempty"`
	// RowKeyStart - The start of row key.
	RowKeyStart *string `json:"startRk,omitempty"`
	// RowKeyEnd - The end of row key.
	RowKeyEnd *string `json:"endRk,omitempty"`
	// KeyToSign - The key to sign the account SAS token with.
	KeyToSign *string `json:"keyToSign,omitempty"`
	// CacheControl - The response header override for cache control.
	CacheControl *string `json:"rscc,omitempty"`
	// ContentDisposition - The response header override for content disposition.
	ContentDisposition *string `json:"rscd,omitempty"`
	// ContentEncoding - The response header override for content encoding.
	ContentEncoding *string `json:"rsce,omitempty"`
	// ContentLanguage - The response header override for content language.
	ContentLanguage *string `json:"rscl,omitempty"`
	// ContentType - The response header override for content type.
	ContentType *string `json:"rsct,omitempty"`
}

// ServiceSpecification one property of operation, include metric specifications.
type ServiceSpecification struct {
	// MetricSpecifications - Metric specifications of operation.
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// Sku the SKU of the storage account.
type Sku struct {
	// Name - Gets or sets the sku name. Required for account creation; optional for update. Note that in older versions, sku name was called accountType. Possible values include: 'StandardLRS', 'StandardGRS', 'StandardRAGRS', 'StandardZRS', 'PremiumLRS'
	Name SkuName `json:"name,omitempty"`
	// Tier - Gets the sku tier. This is based on the SKU name. Possible values include: 'Standard', 'Premium'
	Tier SkuTier `json:"tier,omitempty"`
	// ResourceType - The type of the resource, usually it is 'storageAccounts'.
	ResourceType *string `json:"resourceType,omitempty"`
	// Kind - Indicates the type of storage account. Possible values include: 'Storage', 'StorageV2', 'BlobStorage'
	Kind Kind `json:"kind,omitempty"`
	// Locations - The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
	Locations *[]string `json:"locations,omitempty"`
	// Capabilities - The capability information in the specified sku, including file encryption, network acls, change notification, etc.
	Capabilities *[]SKUCapability `json:"capabilities,omitempty"`
	// Restrictions - The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions *[]Restriction `json:"restrictions,omitempty"`
}

// SKUCapability the capability information in the specified sku, including file encryption, network acls, change
// notification, etc.
type SKUCapability struct {
	// Name - The name of capability, The capability information in the specified sku, including file encryption, network acls, change notification, etc.
	Name *string `json:"name,omitempty"`
	// Value - A string value to indicate states of given capability. Possibly 'true' or 'false'.
	Value *string `json:"value,omitempty"`
}

// SkuListResult the response from the List Storage SKUs operation.
type SkuListResult struct {
	autorest.Response `json:"-"`
	// Value - Get the list result of storage SKUs and their properties.
	Value *[]Sku `json:"value,omitempty"`
}

// TagProperty a tag of the LegalHold of a blob container.
type TagProperty struct {
	// Tag - The tag value.
	Tag *string `json:"tag,omitempty"`
	// Timestamp - Returns the date and time the tag was added.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// ObjectIdentifier - Returns the Object ID of the user who added the tag.
	ObjectIdentifier *string `json:"objectIdentifier,omitempty"`
	// TenantID - Returns the Tenant ID that issued the token for the user who added the tag.
	TenantID *string `json:"tenantId,omitempty"`
	// Upn - Returns the User Principal Name of the user who added the tag.
	Upn *string `json:"upn,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.ID != nil {
		objectMap["id"] = tr.ID
	}
	if tr.Name != nil {
		objectMap["name"] = tr.Name
	}
	if tr.Type != nil {
		objectMap["type"] = tr.Type
	}
	return json.Marshal(objectMap)
}

// UpdateHistoryProperty an update history of the ImmutabilityPolicy of a blob container.
type UpdateHistoryProperty struct {
	// Update - The ImmutabilityPolicy update type of a blob container, possible values include: put, lock and extend. Possible values include: 'Put', 'Lock', 'Extend'
	Update ImmutabilityPolicyUpdateType `json:"update,omitempty"`
	// ImmutabilityPeriodSinceCreationInDays - The immutability period for the blobs in the container since the policy creation, in days.
	ImmutabilityPeriodSinceCreationInDays *int32 `json:"immutabilityPeriodSinceCreationInDays,omitempty"`
	// Timestamp - Returns the date and time the ImmutabilityPolicy was updated.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// ObjectIdentifier - Returns the Object ID of the user who updated the ImmutabilityPolicy.
	ObjectIdentifier *string `json:"objectIdentifier,omitempty"`
	// TenantID - Returns the Tenant ID that issued the token for the user who updated the ImmutabilityPolicy.
	TenantID *string `json:"tenantId,omitempty"`
	// Upn - Returns the User Principal Name of the user who updated the ImmutabilityPolicy.
	Upn *string `json:"upn,omitempty"`
}

// Usage describes Storage Resource Usage.
type Usage struct {
	// Unit - Gets the unit of measurement. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountsPerSecond', 'BytesPerSecond'
	Unit UsageUnit `json:"unit,omitempty"`
	// CurrentValue - Gets the current count of the allocated resources in the subscription.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - Gets the maximum count of the resources that can be allocated in the subscription.
	Limit *int32 `json:"limit,omitempty"`
	// Name - Gets the name of the type of usage.
	Name *UsageName `json:"name,omitempty"`
}

// UsageListResult the response from the List Usages operation.
type UsageListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the list of Storage Resource Usages.
	Value *[]Usage `json:"value,omitempty"`
}

// UsageName the usage names that can be used; currently limited to StorageAccount.
type UsageName struct {
	// Value - Gets a string describing the resource name.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - Gets a localized string describing the resource name.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// VirtualNetworkRule virtual Network rule.
type VirtualNetworkRule struct {
	// VirtualNetworkResourceID - Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
	VirtualNetworkResourceID *string `json:"id,omitempty"`
	// Action - The action of virtual network rule. Possible values include: 'Allow'
	Action Action `json:"action,omitempty"`
	// State - Gets the state of virtual network rule. Possible values include: 'StateProvisioning', 'StateDeprovisioning', 'StateSucceeded', 'StateFailed', 'StateNetworkSourceDeleted'
	State State `json:"state,omitempty"`
}
