package install

import (
	"k8s.io/apimachinery/pkg/runtime"
	utilruntime "k8s.io/apimachinery/pkg/util/runtime"
	"k8s.io/kubernetes/pkg/api/legacyscheme"

	authorizationv1 "github.com/openshift/api/authorization/v1"
	authorizationapi "github.com/openshift/openshift-apiserver/pkg/authorization/apis/authorization"
	"github.com/openshift/openshift-apiserver/pkg/authorization/apis/authorization/rbacconversion"
	authorizationapiv1 "github.com/openshift/openshift-apiserver/pkg/authorization/apis/authorization/v1"
)

func init() {
	Install(legacyscheme.Scheme)
}

// Install registers the API group and adds types to a scheme
func Install(scheme *runtime.Scheme) {
	utilruntime.Must(authorizationapi.Install(scheme))
	utilruntime.Must(rbacconversion.AddToScheme(scheme))
	utilruntime.Must(authorizationapiv1.Install(scheme))
	utilruntime.Must(scheme.SetVersionPriority(authorizationv1.GroupVersion))
}
