// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/openshift/api/build/v1"
	scheme "github.com/openshift/client-go/build/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// BuildConfigsGetter has a method to return a BuildConfigInterface.
// A group's client should implement this interface.
type BuildConfigsGetter interface {
	BuildConfigs(namespace string) BuildConfigInterface
}

// BuildConfigInterface has methods to work with BuildConfig resources.
type BuildConfigInterface interface {
	Create(ctx context.Context, buildConfig *v1.BuildConfig, opts metav1.CreateOptions) (*v1.BuildConfig, error)
	Update(ctx context.Context, buildConfig *v1.BuildConfig, opts metav1.UpdateOptions) (*v1.BuildConfig, error)
	UpdateStatus(ctx context.Context, buildConfig *v1.BuildConfig, opts metav1.UpdateOptions) (*v1.BuildConfig, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.BuildConfig, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.BuildConfigList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.BuildConfig, err error)
	Instantiate(ctx context.Context, buildConfigName string, buildRequest *v1.BuildRequest, opts metav1.CreateOptions) (*v1.Build, error)

	BuildConfigExpansion
}

// buildConfigs implements BuildConfigInterface
type buildConfigs struct {
	client rest.Interface
	ns     string
}

// newBuildConfigs returns a BuildConfigs
func newBuildConfigs(c *BuildV1Client, namespace string) *buildConfigs {
	return &buildConfigs{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the buildConfig, and returns the corresponding buildConfig object, and an error if there is any.
func (c *buildConfigs) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.BuildConfig, err error) {
	result = &v1.BuildConfig{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("buildconfigs").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of BuildConfigs that match those selectors.
func (c *buildConfigs) List(ctx context.Context, opts metav1.ListOptions) (result *v1.BuildConfigList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.BuildConfigList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("buildconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested buildConfigs.
func (c *buildConfigs) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("buildconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a buildConfig and creates it.  Returns the server's representation of the buildConfig, and an error, if there is any.
func (c *buildConfigs) Create(ctx context.Context, buildConfig *v1.BuildConfig, opts metav1.CreateOptions) (result *v1.BuildConfig, err error) {
	result = &v1.BuildConfig{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("buildconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(buildConfig).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a buildConfig and updates it. Returns the server's representation of the buildConfig, and an error, if there is any.
func (c *buildConfigs) Update(ctx context.Context, buildConfig *v1.BuildConfig, opts metav1.UpdateOptions) (result *v1.BuildConfig, err error) {
	result = &v1.BuildConfig{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("buildconfigs").
		Name(buildConfig.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(buildConfig).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *buildConfigs) UpdateStatus(ctx context.Context, buildConfig *v1.BuildConfig, opts metav1.UpdateOptions) (result *v1.BuildConfig, err error) {
	result = &v1.BuildConfig{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("buildconfigs").
		Name(buildConfig.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(buildConfig).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the buildConfig and deletes it. Returns an error if one occurs.
func (c *buildConfigs) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("buildconfigs").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *buildConfigs) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("buildconfigs").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched buildConfig.
func (c *buildConfigs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.BuildConfig, err error) {
	result = &v1.BuildConfig{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("buildconfigs").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Instantiate takes the representation of a buildRequest and creates it.  Returns the server's representation of the build, and an error, if there is any.
func (c *buildConfigs) Instantiate(ctx context.Context, buildConfigName string, buildRequest *v1.BuildRequest, opts metav1.CreateOptions) (result *v1.Build, err error) {
	result = &v1.Build{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("buildconfigs").
		Name(buildConfigName).
		SubResource("instantiate").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(buildRequest).
		Do(ctx).
		Into(result)
	return
}
