// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: google/datastore/admin/v1/datastore_admin.proto

package admin

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Operation types.
type OperationType int32

const (
	// Unspecified.
	OperationType_OPERATION_TYPE_UNSPECIFIED OperationType = 0
	// ExportEntities.
	OperationType_EXPORT_ENTITIES OperationType = 1
	// ImportEntities.
	OperationType_IMPORT_ENTITIES OperationType = 2
	// CreateIndex.
	OperationType_CREATE_INDEX OperationType = 3
	// DeleteIndex.
	OperationType_DELETE_INDEX OperationType = 4
)

// Enum value maps for OperationType.
var (
	OperationType_name = map[int32]string{
		0: "OPERATION_TYPE_UNSPECIFIED",
		1: "EXPORT_ENTITIES",
		2: "IMPORT_ENTITIES",
		3: "CREATE_INDEX",
		4: "DELETE_INDEX",
	}
	OperationType_value = map[string]int32{
		"OPERATION_TYPE_UNSPECIFIED": 0,
		"EXPORT_ENTITIES":            1,
		"IMPORT_ENTITIES":            2,
		"CREATE_INDEX":               3,
		"DELETE_INDEX":               4,
	}
)

func (x OperationType) Enum() *OperationType {
	p := new(OperationType)
	*p = x
	return p
}

func (x OperationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OperationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_datastore_admin_v1_datastore_admin_proto_enumTypes[0].Descriptor()
}

func (OperationType) Type() protoreflect.EnumType {
	return &file_google_datastore_admin_v1_datastore_admin_proto_enumTypes[0]
}

func (x OperationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OperationType.Descriptor instead.
func (OperationType) EnumDescriptor() ([]byte, []int) {
	return file_google_datastore_admin_v1_datastore_admin_proto_rawDescGZIP(), []int{0}
}

// The various possible states for an ongoing Operation.
type CommonMetadata_State int32

const (
	// Unspecified.
	CommonMetadata_STATE_UNSPECIFIED CommonMetadata_State = 0
	// Request is being prepared for processing.
	CommonMetadata_INITIALIZING CommonMetadata_State = 1
	// Request is actively being processed.
	CommonMetadata_PROCESSING CommonMetadata_State = 2
	// Request is in the process of being cancelled after user called
	// google.longrunning.Operations.CancelOperation on the operation.
	CommonMetadata_CANCELLING CommonMetadata_State = 3
	// Request has been processed and is in its finalization stage.
	CommonMetadata_FINALIZING CommonMetadata_State = 4
	// Request has completed successfully.
	CommonMetadata_SUCCESSFUL CommonMetadata_State = 5
	// Request has finished being processed, but encountered an error.
	CommonMetadata_FAILED CommonMetadata_State = 6
	// Request has finished being cancelled after user called
	// google.longrunning.Operations.CancelOperation.
	CommonMetadata_CANCELLED CommonMetadata_State = 7
)

// Enum value maps for CommonMetadata_State.
var (
	CommonMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "INITIALIZING",
		2: "PROCESSING",
		3: "CANCELLING",
		4: "FINALIZING",
		5: "SUCCESSFUL",
		6: "FAILED",
		7: "CANCELLED",
	}
	CommonMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"INITIALIZING":      1,
		"PROCESSING":        2,
		"CANCELLING":        3,
		"FINALIZING":        4,
		"SUCCESSFUL":        5,
		"FAILED":            6,
		"CANCELLED":         7,
	}
)

func (x CommonMetadata_State) Enum() *CommonMetadata_State {
	p := new(CommonMetadata_State)
	*p = x
	return p
}

func (x CommonMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommonMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_datastore_admin_v1_datastore_admin_proto_enumTypes[1].Descriptor()
}

func (CommonMetadata_State) Type() protoreflect.EnumType {
	return &file_google_datastore_admin_v1_datastore_admin_proto_enumTypes[1]
}

func (x CommonMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CommonMetadata_State.Descriptor instead.
func (CommonMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_datastore_admin_v1_datastore_admin_proto_rawDescGZIP(), []int{0, 0}
}

// Metadata common to all Datastore Admin operations.
type CommonMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time that work began on the operation.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the operation ended, either successfully or otherwise.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The type of the operation. Can be used as a filter in
	// ListOperationsRequest.
	OperationType OperationType `protobuf:"varint,3,opt,name=operation_type,json=operationType,proto3,enum=google.datastore.admin.v1.OperationType" json:"operation_type,omitempty"`
	// The client-assigned labels which were provided when the operation was
	// created. May also include additional labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The current state of the Operation.
	State CommonMetadata_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.datastore.admin.v1.CommonMetadata_State" json:"state,omitempty"`
}

func (x *CommonMetadata) Reset() {
	*x = CommonMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommonMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommonMetadata) ProtoMessage() {}

func (x *CommonMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommonMetadata.ProtoReflect.Descriptor instead.
func (*CommonMetadata) Descriptor() ([]byte, []int) {
	return file_google_datastore_admin_v1_datastore_admin_proto_rawDescGZIP(), []int{0}
}

func (x *CommonMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *CommonMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *CommonMetadata) GetOperationType() OperationType {
	if x != nil {
		return x.OperationType
	}
	return OperationType_OPERATION_TYPE_UNSPECIFIED
}

func (x *CommonMetadata) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CommonMetadata) GetState() CommonMetadata_State {
	if x != nil {
		return x.State
	}
	return CommonMetadata_STATE_UNSPECIFIED
}

// Measures the progress of a particular metric.
type Progress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The amount of work that has been completed. Note that this may be greater
	// than work_estimated.
	WorkCompleted int64 `protobuf:"varint,1,opt,name=work_completed,json=workCompleted,proto3" json:"work_completed,omitempty"`
	// An estimate of how much work needs to be performed. May be zero if the
	// work estimate is unavailable.
	WorkEstimated int64 `protobuf:"varint,2,opt,name=work_estimated,json=workEstimated,proto3" json:"work_estimated,omitempty"`
}

func (x *Progress) Reset() {
	*x = Progress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Progress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Progress) ProtoMessage() {}

func (x *Progress) ProtoReflect() protoreflect.Message {
	mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Progress.ProtoReflect.Descriptor instead.
func (*Progress) Descriptor() ([]byte, []int) {
	return file_google_datastore_admin_v1_datastore_admin_proto_rawDescGZIP(), []int{1}
}

func (x *Progress) GetWorkCompleted() int64 {
	if x != nil {
		return x.WorkCompleted
	}
	return 0
}

func (x *Progress) GetWorkEstimated() int64 {
	if x != nil {
		return x.WorkEstimated
	}
	return 0
}

// The request for
// [google.datastore.admin.v1.DatastoreAdmin.ExportEntities][google.datastore.admin.v1.DatastoreAdmin.ExportEntities].
type ExportEntitiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project ID against which to make the request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Client-assigned labels.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Description of what data from the project is included in the export.
	EntityFilter *EntityFilter `protobuf:"bytes,3,opt,name=entity_filter,json=entityFilter,proto3" json:"entity_filter,omitempty"`
	// Required. Location for the export metadata and data files.
	//
	// The full resource URL of the external storage location. Currently, only
	// Google Cloud Storage is supported. So output_url_prefix should be of the
	// form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the
	// name of the Cloud Storage bucket and `NAMESPACE_PATH` is an optional Cloud
	// Storage namespace path (this is not a Cloud Datastore namespace). For more
	// information about Cloud Storage namespace paths, see
	// [Object name
	// considerations](https://cloud.google.com/storage/docs/naming#object-considerations).
	//
	// The resulting files will be nested deeper than the specified URL prefix.
	// The final output URL will be provided in the
	// [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url] field. That
	// value should be used for subsequent ImportEntities operations.
	//
	// By nesting the data files deeper, the same Cloud Storage bucket can be used
	// in multiple ExportEntities operations without conflict.
	OutputUrlPrefix string `protobuf:"bytes,4,opt,name=output_url_prefix,json=outputUrlPrefix,proto3" json:"output_url_prefix,omitempty"`
}

func (x *ExportEntitiesRequest) Reset() {
	*x = ExportEntitiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportEntitiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportEntitiesRequest) ProtoMessage() {}

func (x *ExportEntitiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportEntitiesRequest.ProtoReflect.Descriptor instead.
func (*ExportEntitiesRequest) Descriptor() ([]byte, []int) {
	return file_google_datastore_admin_v1_datastore_admin_proto_rawDescGZIP(), []int{2}
}

func (x *ExportEntitiesRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ExportEntitiesRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ExportEntitiesRequest) GetEntityFilter() *EntityFilter {
	if x != nil {
		return x.EntityFilter
	}
	return nil
}

func (x *ExportEntitiesRequest) GetOutputUrlPrefix() string {
	if x != nil {
		return x.OutputUrlPrefix
	}
	return ""
}

// The request for
// [google.datastore.admin.v1.DatastoreAdmin.ImportEntities][google.datastore.admin.v1.DatastoreAdmin.ImportEntities].
type ImportEntitiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project ID against which to make the request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Client-assigned labels.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The full resource URL of the external storage location. Currently, only
	// Google Cloud Storage is supported. So input_url should be of the form:
	// `gs://BUCKET_NAME[/NAMESPACE_PATH]/OVERALL_EXPORT_METADATA_FILE`, where
	// `BUCKET_NAME` is the name of the Cloud Storage bucket, `NAMESPACE_PATH` is
	// an optional Cloud Storage namespace path (this is not a Cloud Datastore
	// namespace), and `OVERALL_EXPORT_METADATA_FILE` is the metadata file written
	// by the ExportEntities operation. For more information about Cloud Storage
	// namespace paths, see
	// [Object name
	// considerations](https://cloud.google.com/storage/docs/naming#object-considerations).
	//
	// For more information, see
	// [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url].
	InputUrl string `protobuf:"bytes,3,opt,name=input_url,json=inputUrl,proto3" json:"input_url,omitempty"`
	// Optionally specify which kinds/namespaces are to be imported. If provided,
	// the list must be a subset of the EntityFilter used in creating the export,
	// otherwise a FAILED_PRECONDITION error will be returned. If no filter is
	// specified then all entities from the export are imported.
	EntityFilter *EntityFilter `protobuf:"bytes,4,opt,name=entity_filter,json=entityFilter,proto3" json:"entity_filter,omitempty"`
}

func (x *ImportEntitiesRequest) Reset() {
	*x = ImportEntitiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportEntitiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportEntitiesRequest) ProtoMessage() {}

func (x *ImportEntitiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportEntitiesRequest.ProtoReflect.Descriptor instead.
func (*ImportEntitiesRequest) Descriptor() ([]byte, []int) {
	return file_google_datastore_admin_v1_datastore_admin_proto_rawDescGZIP(), []int{3}
}

func (x *ImportEntitiesRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ImportEntitiesRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ImportEntitiesRequest) GetInputUrl() string {
	if x != nil {
		return x.InputUrl
	}
	return ""
}

func (x *ImportEntitiesRequest) GetEntityFilter() *EntityFilter {
	if x != nil {
		return x.EntityFilter
	}
	return nil
}

// The response for
// [google.datastore.admin.v1.DatastoreAdmin.ExportEntities][google.datastore.admin.v1.DatastoreAdmin.ExportEntities].
type ExportEntitiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location of the output metadata file. This can be used to begin an import
	// into Cloud Datastore (this project or another project). See
	// [google.datastore.admin.v1.ImportEntitiesRequest.input_url][google.datastore.admin.v1.ImportEntitiesRequest.input_url].
	// Only present if the operation completed successfully.
	OutputUrl string `protobuf:"bytes,1,opt,name=output_url,json=outputUrl,proto3" json:"output_url,omitempty"`
}

func (x *ExportEntitiesResponse) Reset() {
	*x = ExportEntitiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportEntitiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportEntitiesResponse) ProtoMessage() {}

func (x *ExportEntitiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportEntitiesResponse.ProtoReflect.Descriptor instead.
func (*ExportEntitiesResponse) Descriptor() ([]byte, []int) {
	return file_google_datastore_admin_v1_datastore_admin_proto_rawDescGZIP(), []int{4}
}

func (x *ExportEntitiesResponse) GetOutputUrl() string {
	if x != nil {
		return x.OutputUrl
	}
	return ""
}

// Metadata for ExportEntities operations.
type ExportEntitiesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata common to all Datastore Admin operations.
	Common *CommonMetadata `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	// An estimate of the number of entities processed.
	ProgressEntities *Progress `protobuf:"bytes,2,opt,name=progress_entities,json=progressEntities,proto3" json:"progress_entities,omitempty"`
	// An estimate of the number of bytes processed.
	ProgressBytes *Progress `protobuf:"bytes,3,opt,name=progress_bytes,json=progressBytes,proto3" json:"progress_bytes,omitempty"`
	// Description of which entities are being exported.
	EntityFilter *EntityFilter `protobuf:"bytes,4,opt,name=entity_filter,json=entityFilter,proto3" json:"entity_filter,omitempty"`
	// Location for the export metadata and data files. This will be the same
	// value as the
	// [google.datastore.admin.v1.ExportEntitiesRequest.output_url_prefix][google.datastore.admin.v1.ExportEntitiesRequest.output_url_prefix]
	// field. The final output location is provided in
	// [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url].
	OutputUrlPrefix string `protobuf:"bytes,5,opt,name=output_url_prefix,json=outputUrlPrefix,proto3" json:"output_url_prefix,omitempty"`
}

func (x *ExportEntitiesMetadata) Reset() {
	*x = ExportEntitiesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportEntitiesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportEntitiesMetadata) ProtoMessage() {}

func (x *ExportEntitiesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportEntitiesMetadata.ProtoReflect.Descriptor instead.
func (*ExportEntitiesMetadata) Descriptor() ([]byte, []int) {
	return file_google_datastore_admin_v1_datastore_admin_proto_rawDescGZIP(), []int{5}
}

func (x *ExportEntitiesMetadata) GetCommon() *CommonMetadata {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *ExportEntitiesMetadata) GetProgressEntities() *Progress {
	if x != nil {
		return x.ProgressEntities
	}
	return nil
}

func (x *ExportEntitiesMetadata) GetProgressBytes() *Progress {
	if x != nil {
		return x.ProgressBytes
	}
	return nil
}

func (x *ExportEntitiesMetadata) GetEntityFilter() *EntityFilter {
	if x != nil {
		return x.EntityFilter
	}
	return nil
}

func (x *ExportEntitiesMetadata) GetOutputUrlPrefix() string {
	if x != nil {
		return x.OutputUrlPrefix
	}
	return ""
}

// Metadata for ImportEntities operations.
type ImportEntitiesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata common to all Datastore Admin operations.
	Common *CommonMetadata `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	// An estimate of the number of entities processed.
	ProgressEntities *Progress `protobuf:"bytes,2,opt,name=progress_entities,json=progressEntities,proto3" json:"progress_entities,omitempty"`
	// An estimate of the number of bytes processed.
	ProgressBytes *Progress `protobuf:"bytes,3,opt,name=progress_bytes,json=progressBytes,proto3" json:"progress_bytes,omitempty"`
	// Description of which entities are being imported.
	EntityFilter *EntityFilter `protobuf:"bytes,4,opt,name=entity_filter,json=entityFilter,proto3" json:"entity_filter,omitempty"`
	// The location of the import metadata file. This will be the same value as
	// the [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url] field.
	InputUrl string `protobuf:"bytes,5,opt,name=input_url,json=inputUrl,proto3" json:"input_url,omitempty"`
}

func (x *ImportEntitiesMetadata) Reset() {
	*x = ImportEntitiesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportEntitiesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportEntitiesMetadata) ProtoMessage() {}

func (x *ImportEntitiesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportEntitiesMetadata.ProtoReflect.Descriptor instead.
func (*ImportEntitiesMetadata) Descriptor() ([]byte, []int) {
	return file_google_datastore_admin_v1_datastore_admin_proto_rawDescGZIP(), []int{6}
}

func (x *ImportEntitiesMetadata) GetCommon() *CommonMetadata {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *ImportEntitiesMetadata) GetProgressEntities() *Progress {
	if x != nil {
		return x.ProgressEntities
	}
	return nil
}

func (x *ImportEntitiesMetadata) GetProgressBytes() *Progress {
	if x != nil {
		return x.ProgressBytes
	}
	return nil
}

func (x *ImportEntitiesMetadata) GetEntityFilter() *EntityFilter {
	if x != nil {
		return x.EntityFilter
	}
	return nil
}

func (x *ImportEntitiesMetadata) GetInputUrl() string {
	if x != nil {
		return x.InputUrl
	}
	return ""
}

// Identifies a subset of entities in a project. This is specified as
// combinations of kinds and namespaces (either or both of which may be all, as
// described in the following examples).
// Example usage:
//
// Entire project:
//   kinds=[], namespace_ids=[]
//
// Kinds Foo and Bar in all namespaces:
//   kinds=['Foo', 'Bar'], namespace_ids=[]
//
// Kinds Foo and Bar only in the default namespace:
//   kinds=['Foo', 'Bar'], namespace_ids=['']
//
// Kinds Foo and Bar in both the default and Baz namespaces:
//   kinds=['Foo', 'Bar'], namespace_ids=['', 'Baz']
//
// The entire Baz namespace:
//   kinds=[], namespace_ids=['Baz']
type EntityFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If empty, then this represents all kinds.
	Kinds []string `protobuf:"bytes,1,rep,name=kinds,proto3" json:"kinds,omitempty"`
	// An empty list represents all namespaces. This is the preferred
	// usage for projects that don't use namespaces.
	//
	// An empty string element represents the default namespace. This should be
	// used if the project has data in non-default namespaces, but doesn't want to
	// include them.
	// Each namespace in this list must be unique.
	NamespaceIds []string `protobuf:"bytes,2,rep,name=namespace_ids,json=namespaceIds,proto3" json:"namespace_ids,omitempty"`
}

func (x *EntityFilter) Reset() {
	*x = EntityFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntityFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityFilter) ProtoMessage() {}

func (x *EntityFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityFilter.ProtoReflect.Descriptor instead.
func (*EntityFilter) Descriptor() ([]byte, []int) {
	return file_google_datastore_admin_v1_datastore_admin_proto_rawDescGZIP(), []int{7}
}

func (x *EntityFilter) GetKinds() []string {
	if x != nil {
		return x.Kinds
	}
	return nil
}

func (x *EntityFilter) GetNamespaceIds() []string {
	if x != nil {
		return x.NamespaceIds
	}
	return nil
}

// The request for
// [google.datastore.admin.v1.DatastoreAdmin.CreateIndex][google.datastore.admin.v1.DatastoreAdmin.CreateIndex].
type CreateIndexRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Project ID against which to make the request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The index to create. The name and state fields are output only and will be
	// ignored. Single property indexes cannot be created or deleted.
	Index *Index `protobuf:"bytes,3,opt,name=index,proto3" json:"index,omitempty"`
}

func (x *CreateIndexRequest) Reset() {
	*x = CreateIndexRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateIndexRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIndexRequest) ProtoMessage() {}

func (x *CreateIndexRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIndexRequest.ProtoReflect.Descriptor instead.
func (*CreateIndexRequest) Descriptor() ([]byte, []int) {
	return file_google_datastore_admin_v1_datastore_admin_proto_rawDescGZIP(), []int{8}
}

func (x *CreateIndexRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *CreateIndexRequest) GetIndex() *Index {
	if x != nil {
		return x.Index
	}
	return nil
}

// The request for
// [google.datastore.admin.v1.DatastoreAdmin.DeleteIndex][google.datastore.admin.v1.DatastoreAdmin.DeleteIndex].
type DeleteIndexRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Project ID against which to make the request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The resource ID of the index to delete.
	IndexId string `protobuf:"bytes,3,opt,name=index_id,json=indexId,proto3" json:"index_id,omitempty"`
}

func (x *DeleteIndexRequest) Reset() {
	*x = DeleteIndexRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteIndexRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIndexRequest) ProtoMessage() {}

func (x *DeleteIndexRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIndexRequest.ProtoReflect.Descriptor instead.
func (*DeleteIndexRequest) Descriptor() ([]byte, []int) {
	return file_google_datastore_admin_v1_datastore_admin_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteIndexRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *DeleteIndexRequest) GetIndexId() string {
	if x != nil {
		return x.IndexId
	}
	return ""
}

// The request for [google.datastore.admin.v1.DatastoreAdmin.GetIndex][google.datastore.admin.v1.DatastoreAdmin.GetIndex].
type GetIndexRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Project ID against which to make the request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The resource ID of the index to get.
	IndexId string `protobuf:"bytes,3,opt,name=index_id,json=indexId,proto3" json:"index_id,omitempty"`
}

func (x *GetIndexRequest) Reset() {
	*x = GetIndexRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIndexRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIndexRequest) ProtoMessage() {}

func (x *GetIndexRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIndexRequest.ProtoReflect.Descriptor instead.
func (*GetIndexRequest) Descriptor() ([]byte, []int) {
	return file_google_datastore_admin_v1_datastore_admin_proto_rawDescGZIP(), []int{10}
}

func (x *GetIndexRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetIndexRequest) GetIndexId() string {
	if x != nil {
		return x.IndexId
	}
	return ""
}

// The request for
// [google.datastore.admin.v1.DatastoreAdmin.ListIndexes][google.datastore.admin.v1.DatastoreAdmin.ListIndexes].
type ListIndexesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Project ID against which to make the request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	Filter    string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of items to return.  If zero, then all results will be
	// returned.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListIndexesRequest) Reset() {
	*x = ListIndexesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIndexesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIndexesRequest) ProtoMessage() {}

func (x *ListIndexesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIndexesRequest.ProtoReflect.Descriptor instead.
func (*ListIndexesRequest) Descriptor() ([]byte, []int) {
	return file_google_datastore_admin_v1_datastore_admin_proto_rawDescGZIP(), []int{11}
}

func (x *ListIndexesRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ListIndexesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListIndexesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListIndexesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for
// [google.datastore.admin.v1.DatastoreAdmin.ListIndexes][google.datastore.admin.v1.DatastoreAdmin.ListIndexes].
type ListIndexesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The indexes.
	Indexes []*Index `protobuf:"bytes,1,rep,name=indexes,proto3" json:"indexes,omitempty"`
	// The standard List next-page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListIndexesResponse) Reset() {
	*x = ListIndexesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIndexesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIndexesResponse) ProtoMessage() {}

func (x *ListIndexesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIndexesResponse.ProtoReflect.Descriptor instead.
func (*ListIndexesResponse) Descriptor() ([]byte, []int) {
	return file_google_datastore_admin_v1_datastore_admin_proto_rawDescGZIP(), []int{12}
}

func (x *ListIndexesResponse) GetIndexes() []*Index {
	if x != nil {
		return x.Indexes
	}
	return nil
}

func (x *ListIndexesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Metadata for Index operations.
type IndexOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata common to all Datastore Admin operations.
	Common *CommonMetadata `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	// An estimate of the number of entities processed.
	ProgressEntities *Progress `protobuf:"bytes,2,opt,name=progress_entities,json=progressEntities,proto3" json:"progress_entities,omitempty"`
	// The index resource ID that this operation is acting on.
	IndexId string `protobuf:"bytes,3,opt,name=index_id,json=indexId,proto3" json:"index_id,omitempty"`
}

func (x *IndexOperationMetadata) Reset() {
	*x = IndexOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexOperationMetadata) ProtoMessage() {}

func (x *IndexOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexOperationMetadata.ProtoReflect.Descriptor instead.
func (*IndexOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_datastore_admin_v1_datastore_admin_proto_rawDescGZIP(), []int{13}
}

func (x *IndexOperationMetadata) GetCommon() *CommonMetadata {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *IndexOperationMetadata) GetProgressEntities() *Progress {
	if x != nil {
		return x.ProgressEntities
	}
	return nil
}

func (x *IndexOperationMetadata) GetIndexId() string {
	if x != nil {
		return x.IndexId
	}
	return ""
}

var File_google_datastore_admin_v1_datastore_admin_proto protoreflect.FileDescriptor

var file_google_datastore_admin_v1_datastore_admin_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x2f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xb2, 0x04, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x8b, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x49,
	0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x50,
	0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x43,
	0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x46,
	0x49, 0x4e, 0x41, 0x4c, 0x49, 0x5a, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x53,
	0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x46, 0x55, 0x4c, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46,
	0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45,
	0x4c, 0x4c, 0x45, 0x44, 0x10, 0x07, 0x22, 0x58, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x77, 0x6f, 0x72, 0x6b,
	0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0d, 0x77, 0x6f, 0x72, 0x6b, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64,
	0x22, 0xcb, 0x02, 0x0a, 0x15, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x54,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x4c, 0x0a, 0x0d, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x52, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x2f, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x6c,
	0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x6c, 0x50, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xbc,
	0x02, 0x0a, 0x15, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x54, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x6c, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x55, 0x72, 0x6c, 0x12, 0x4c, 0x0a, 0x0d, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x52, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x37, 0x0a,
	0x16, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x55, 0x72, 0x6c, 0x22, 0xf3, 0x02, 0x0a, 0x16, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x41, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x06, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x12, 0x4c, 0x0a, 0x0d, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x52, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x2a, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x70,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x55, 0x72, 0x6c, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x22, 0xe4, 0x02, 0x0a,
	0x16, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x41, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x11, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x0e,
	0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x4c, 0x0a, 0x0d, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f,
	0x75, 0x72, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x55, 0x72, 0x6c, 0x22, 0x49, 0x0a, 0x0c, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x6b, 0x69, 0x6e, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x05, 0x6b, 0x69, 0x6e, 0x64, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0c, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x73, 0x22, 0x6b,
	0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x36, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x4e, 0x0a, 0x12, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x12, 0x19, 0x0a, 0x08, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x49, 0x64, 0x22, 0x4b, 0x0a, 0x0f, 0x47,
	0x65, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a,
	0x08, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x49, 0x64, 0x22, 0x87, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x79, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x07, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x07, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc8, 0x01,
	0x0a, 0x16, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x41, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x11, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x10, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x19, 0x0a,
	0x08, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x49, 0x64, 0x2a, 0x7d, 0x0a, 0x0d, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x4f, 0x50, 0x45,
	0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x45, 0x58, 0x50,
	0x4f, 0x52, 0x54, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x49, 0x45, 0x53, 0x10, 0x01, 0x12, 0x13,
	0x0a, 0x0f, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x49, 0x45,
	0x53, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x49, 0x4e,
	0x44, 0x45, 0x58, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f,
	0x49, 0x4e, 0x44, 0x45, 0x58, 0x10, 0x04, 0x32, 0x84, 0x0a, 0x0a, 0x0e, 0x44, 0x61, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x12, 0xf6, 0x01, 0x0a, 0x0e, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x92,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x22, 0x20, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x7d, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x31, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x2c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2c, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0xca, 0x41, 0x30, 0x0a, 0x16, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0xed, 0x01, 0x0a, 0x0e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25,
	0x22, 0x20, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x69, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x29, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x2c, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f,
	0x75, 0x72, 0x6c, 0x2c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0xca, 0x41, 0x2f, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x16, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0xaf, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x52, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x22, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x3a, 0x05, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0xca, 0x41, 0x1f, 0x0a, 0x05, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x16, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xb3, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x56, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x2a, 0x2c, 0x2f, 0x76, 0x31,
	0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x2f, 0x7b,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x69, 0x64, 0x7d, 0xca, 0x41, 0x1f, 0x0a, 0x05, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x16, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x8e, 0x01, 0x0a, 0x08,
	0x47, 0x65, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x34, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c,
	0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65,
	0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x97, 0x01, 0x0a,
	0x0b, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x12, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x29, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x23, 0x12, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x1a, 0x76, 0xca, 0x41, 0x18, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x58, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0xe0,
	0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x42, 0x13, 0x44, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76,
	0x31, 0x3b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x5c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x23, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_datastore_admin_v1_datastore_admin_proto_rawDescOnce sync.Once
	file_google_datastore_admin_v1_datastore_admin_proto_rawDescData = file_google_datastore_admin_v1_datastore_admin_proto_rawDesc
)

func file_google_datastore_admin_v1_datastore_admin_proto_rawDescGZIP() []byte {
	file_google_datastore_admin_v1_datastore_admin_proto_rawDescOnce.Do(func() {
		file_google_datastore_admin_v1_datastore_admin_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_datastore_admin_v1_datastore_admin_proto_rawDescData)
	})
	return file_google_datastore_admin_v1_datastore_admin_proto_rawDescData
}

var file_google_datastore_admin_v1_datastore_admin_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_datastore_admin_v1_datastore_admin_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_datastore_admin_v1_datastore_admin_proto_goTypes = []interface{}{
	(OperationType)(0),             // 0: google.datastore.admin.v1.OperationType
	(CommonMetadata_State)(0),      // 1: google.datastore.admin.v1.CommonMetadata.State
	(*CommonMetadata)(nil),         // 2: google.datastore.admin.v1.CommonMetadata
	(*Progress)(nil),               // 3: google.datastore.admin.v1.Progress
	(*ExportEntitiesRequest)(nil),  // 4: google.datastore.admin.v1.ExportEntitiesRequest
	(*ImportEntitiesRequest)(nil),  // 5: google.datastore.admin.v1.ImportEntitiesRequest
	(*ExportEntitiesResponse)(nil), // 6: google.datastore.admin.v1.ExportEntitiesResponse
	(*ExportEntitiesMetadata)(nil), // 7: google.datastore.admin.v1.ExportEntitiesMetadata
	(*ImportEntitiesMetadata)(nil), // 8: google.datastore.admin.v1.ImportEntitiesMetadata
	(*EntityFilter)(nil),           // 9: google.datastore.admin.v1.EntityFilter
	(*CreateIndexRequest)(nil),     // 10: google.datastore.admin.v1.CreateIndexRequest
	(*DeleteIndexRequest)(nil),     // 11: google.datastore.admin.v1.DeleteIndexRequest
	(*GetIndexRequest)(nil),        // 12: google.datastore.admin.v1.GetIndexRequest
	(*ListIndexesRequest)(nil),     // 13: google.datastore.admin.v1.ListIndexesRequest
	(*ListIndexesResponse)(nil),    // 14: google.datastore.admin.v1.ListIndexesResponse
	(*IndexOperationMetadata)(nil), // 15: google.datastore.admin.v1.IndexOperationMetadata
	nil,                            // 16: google.datastore.admin.v1.CommonMetadata.LabelsEntry
	nil,                            // 17: google.datastore.admin.v1.ExportEntitiesRequest.LabelsEntry
	nil,                            // 18: google.datastore.admin.v1.ImportEntitiesRequest.LabelsEntry
	(*timestamppb.Timestamp)(nil),  // 19: google.protobuf.Timestamp
	(*Index)(nil),                  // 20: google.datastore.admin.v1.Index
	(*longrunning.Operation)(nil),  // 21: google.longrunning.Operation
}
var file_google_datastore_admin_v1_datastore_admin_proto_depIdxs = []int32{
	19, // 0: google.datastore.admin.v1.CommonMetadata.start_time:type_name -> google.protobuf.Timestamp
	19, // 1: google.datastore.admin.v1.CommonMetadata.end_time:type_name -> google.protobuf.Timestamp
	0,  // 2: google.datastore.admin.v1.CommonMetadata.operation_type:type_name -> google.datastore.admin.v1.OperationType
	16, // 3: google.datastore.admin.v1.CommonMetadata.labels:type_name -> google.datastore.admin.v1.CommonMetadata.LabelsEntry
	1,  // 4: google.datastore.admin.v1.CommonMetadata.state:type_name -> google.datastore.admin.v1.CommonMetadata.State
	17, // 5: google.datastore.admin.v1.ExportEntitiesRequest.labels:type_name -> google.datastore.admin.v1.ExportEntitiesRequest.LabelsEntry
	9,  // 6: google.datastore.admin.v1.ExportEntitiesRequest.entity_filter:type_name -> google.datastore.admin.v1.EntityFilter
	18, // 7: google.datastore.admin.v1.ImportEntitiesRequest.labels:type_name -> google.datastore.admin.v1.ImportEntitiesRequest.LabelsEntry
	9,  // 8: google.datastore.admin.v1.ImportEntitiesRequest.entity_filter:type_name -> google.datastore.admin.v1.EntityFilter
	2,  // 9: google.datastore.admin.v1.ExportEntitiesMetadata.common:type_name -> google.datastore.admin.v1.CommonMetadata
	3,  // 10: google.datastore.admin.v1.ExportEntitiesMetadata.progress_entities:type_name -> google.datastore.admin.v1.Progress
	3,  // 11: google.datastore.admin.v1.ExportEntitiesMetadata.progress_bytes:type_name -> google.datastore.admin.v1.Progress
	9,  // 12: google.datastore.admin.v1.ExportEntitiesMetadata.entity_filter:type_name -> google.datastore.admin.v1.EntityFilter
	2,  // 13: google.datastore.admin.v1.ImportEntitiesMetadata.common:type_name -> google.datastore.admin.v1.CommonMetadata
	3,  // 14: google.datastore.admin.v1.ImportEntitiesMetadata.progress_entities:type_name -> google.datastore.admin.v1.Progress
	3,  // 15: google.datastore.admin.v1.ImportEntitiesMetadata.progress_bytes:type_name -> google.datastore.admin.v1.Progress
	9,  // 16: google.datastore.admin.v1.ImportEntitiesMetadata.entity_filter:type_name -> google.datastore.admin.v1.EntityFilter
	20, // 17: google.datastore.admin.v1.CreateIndexRequest.index:type_name -> google.datastore.admin.v1.Index
	20, // 18: google.datastore.admin.v1.ListIndexesResponse.indexes:type_name -> google.datastore.admin.v1.Index
	2,  // 19: google.datastore.admin.v1.IndexOperationMetadata.common:type_name -> google.datastore.admin.v1.CommonMetadata
	3,  // 20: google.datastore.admin.v1.IndexOperationMetadata.progress_entities:type_name -> google.datastore.admin.v1.Progress
	4,  // 21: google.datastore.admin.v1.DatastoreAdmin.ExportEntities:input_type -> google.datastore.admin.v1.ExportEntitiesRequest
	5,  // 22: google.datastore.admin.v1.DatastoreAdmin.ImportEntities:input_type -> google.datastore.admin.v1.ImportEntitiesRequest
	10, // 23: google.datastore.admin.v1.DatastoreAdmin.CreateIndex:input_type -> google.datastore.admin.v1.CreateIndexRequest
	11, // 24: google.datastore.admin.v1.DatastoreAdmin.DeleteIndex:input_type -> google.datastore.admin.v1.DeleteIndexRequest
	12, // 25: google.datastore.admin.v1.DatastoreAdmin.GetIndex:input_type -> google.datastore.admin.v1.GetIndexRequest
	13, // 26: google.datastore.admin.v1.DatastoreAdmin.ListIndexes:input_type -> google.datastore.admin.v1.ListIndexesRequest
	21, // 27: google.datastore.admin.v1.DatastoreAdmin.ExportEntities:output_type -> google.longrunning.Operation
	21, // 28: google.datastore.admin.v1.DatastoreAdmin.ImportEntities:output_type -> google.longrunning.Operation
	21, // 29: google.datastore.admin.v1.DatastoreAdmin.CreateIndex:output_type -> google.longrunning.Operation
	21, // 30: google.datastore.admin.v1.DatastoreAdmin.DeleteIndex:output_type -> google.longrunning.Operation
	20, // 31: google.datastore.admin.v1.DatastoreAdmin.GetIndex:output_type -> google.datastore.admin.v1.Index
	14, // 32: google.datastore.admin.v1.DatastoreAdmin.ListIndexes:output_type -> google.datastore.admin.v1.ListIndexesResponse
	27, // [27:33] is the sub-list for method output_type
	21, // [21:27] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_datastore_admin_v1_datastore_admin_proto_init() }
func file_google_datastore_admin_v1_datastore_admin_proto_init() {
	if File_google_datastore_admin_v1_datastore_admin_proto != nil {
		return
	}
	file_google_datastore_admin_v1_index_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommonMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Progress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportEntitiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportEntitiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportEntitiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportEntitiesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportEntitiesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntityFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateIndexRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteIndexRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIndexRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIndexesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIndexesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_datastore_admin_v1_datastore_admin_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_datastore_admin_v1_datastore_admin_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_datastore_admin_v1_datastore_admin_proto_goTypes,
		DependencyIndexes: file_google_datastore_admin_v1_datastore_admin_proto_depIdxs,
		EnumInfos:         file_google_datastore_admin_v1_datastore_admin_proto_enumTypes,
		MessageInfos:      file_google_datastore_admin_v1_datastore_admin_proto_msgTypes,
	}.Build()
	File_google_datastore_admin_v1_datastore_admin_proto = out.File
	file_google_datastore_admin_v1_datastore_admin_proto_rawDesc = nil
	file_google_datastore_admin_v1_datastore_admin_proto_goTypes = nil
	file_google_datastore_admin_v1_datastore_admin_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DatastoreAdminClient is the client API for DatastoreAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DatastoreAdminClient interface {
	// Exports a copy of all or a subset of entities from Google Cloud Datastore
	// to another storage system, such as Google Cloud Storage. Recent updates to
	// entities may not be reflected in the export. The export occurs in the
	// background and its progress can be monitored and managed via the
	// Operation resource that is created. The output of an export may only be
	// used once the associated operation is done. If an export operation is
	// cancelled before completion it may leave partial data behind in Google
	// Cloud Storage.
	ExportEntities(ctx context.Context, in *ExportEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Imports entities into Google Cloud Datastore. Existing entities with the
	// same key are overwritten. The import occurs in the background and its
	// progress can be monitored and managed via the Operation resource that is
	// created. If an ImportEntities operation is cancelled, it is possible
	// that a subset of the data has already been imported to Cloud Datastore.
	ImportEntities(ctx context.Context, in *ImportEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates the specified index.
	// A newly created index's initial state is `CREATING`. On completion of the
	// returned [google.longrunning.Operation][google.longrunning.Operation], the state will be `READY`.
	// If the index already exists, the call will return an `ALREADY_EXISTS`
	// status.
	//
	// During index creation, the process could result in an error, in which
	// case the index will move to the `ERROR` state. The process can be recovered
	// by fixing the data that caused the error, removing the index with
	// [delete][google.datastore.admin.v1.DatastoreAdmin.DeleteIndex], then
	// re-creating the index with [create]
	// [google.datastore.admin.v1.DatastoreAdmin.CreateIndex].
	//
	// Indexes with a single property cannot be created.
	CreateIndex(ctx context.Context, in *CreateIndexRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes an existing index.
	// An index can only be deleted if it is in a `READY` or `ERROR` state. On
	// successful execution of the request, the index will be in a `DELETING`
	// [state][google.datastore.admin.v1.Index.State]. And on completion of the
	// returned [google.longrunning.Operation][google.longrunning.Operation], the index will be removed.
	//
	// During index deletion, the process could result in an error, in which
	// case the index will move to the `ERROR` state. The process can be recovered
	// by fixing the data that caused the error, followed by calling
	// [delete][google.datastore.admin.v1.DatastoreAdmin.DeleteIndex] again.
	DeleteIndex(ctx context.Context, in *DeleteIndexRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets an index.
	GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error)
	// Lists the indexes that match the specified filters.  Datastore uses an
	// eventually consistent query to fetch the list of indexes and may
	// occasionally return stale results.
	ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error)
}

type datastoreAdminClient struct {
	cc grpc.ClientConnInterface
}

func NewDatastoreAdminClient(cc grpc.ClientConnInterface) DatastoreAdminClient {
	return &datastoreAdminClient{cc}
}

func (c *datastoreAdminClient) ExportEntities(ctx context.Context, in *ExportEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.datastore.admin.v1.DatastoreAdmin/ExportEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreAdminClient) ImportEntities(ctx context.Context, in *ImportEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.datastore.admin.v1.DatastoreAdmin/ImportEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreAdminClient) CreateIndex(ctx context.Context, in *CreateIndexRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.datastore.admin.v1.DatastoreAdmin/CreateIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreAdminClient) DeleteIndex(ctx context.Context, in *DeleteIndexRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.datastore.admin.v1.DatastoreAdmin/DeleteIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreAdminClient) GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error) {
	out := new(Index)
	err := c.cc.Invoke(ctx, "/google.datastore.admin.v1.DatastoreAdmin/GetIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreAdminClient) ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error) {
	out := new(ListIndexesResponse)
	err := c.cc.Invoke(ctx, "/google.datastore.admin.v1.DatastoreAdmin/ListIndexes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DatastoreAdminServer is the server API for DatastoreAdmin service.
type DatastoreAdminServer interface {
	// Exports a copy of all or a subset of entities from Google Cloud Datastore
	// to another storage system, such as Google Cloud Storage. Recent updates to
	// entities may not be reflected in the export. The export occurs in the
	// background and its progress can be monitored and managed via the
	// Operation resource that is created. The output of an export may only be
	// used once the associated operation is done. If an export operation is
	// cancelled before completion it may leave partial data behind in Google
	// Cloud Storage.
	ExportEntities(context.Context, *ExportEntitiesRequest) (*longrunning.Operation, error)
	// Imports entities into Google Cloud Datastore. Existing entities with the
	// same key are overwritten. The import occurs in the background and its
	// progress can be monitored and managed via the Operation resource that is
	// created. If an ImportEntities operation is cancelled, it is possible
	// that a subset of the data has already been imported to Cloud Datastore.
	ImportEntities(context.Context, *ImportEntitiesRequest) (*longrunning.Operation, error)
	// Creates the specified index.
	// A newly created index's initial state is `CREATING`. On completion of the
	// returned [google.longrunning.Operation][google.longrunning.Operation], the state will be `READY`.
	// If the index already exists, the call will return an `ALREADY_EXISTS`
	// status.
	//
	// During index creation, the process could result in an error, in which
	// case the index will move to the `ERROR` state. The process can be recovered
	// by fixing the data that caused the error, removing the index with
	// [delete][google.datastore.admin.v1.DatastoreAdmin.DeleteIndex], then
	// re-creating the index with [create]
	// [google.datastore.admin.v1.DatastoreAdmin.CreateIndex].
	//
	// Indexes with a single property cannot be created.
	CreateIndex(context.Context, *CreateIndexRequest) (*longrunning.Operation, error)
	// Deletes an existing index.
	// An index can only be deleted if it is in a `READY` or `ERROR` state. On
	// successful execution of the request, the index will be in a `DELETING`
	// [state][google.datastore.admin.v1.Index.State]. And on completion of the
	// returned [google.longrunning.Operation][google.longrunning.Operation], the index will be removed.
	//
	// During index deletion, the process could result in an error, in which
	// case the index will move to the `ERROR` state. The process can be recovered
	// by fixing the data that caused the error, followed by calling
	// [delete][google.datastore.admin.v1.DatastoreAdmin.DeleteIndex] again.
	DeleteIndex(context.Context, *DeleteIndexRequest) (*longrunning.Operation, error)
	// Gets an index.
	GetIndex(context.Context, *GetIndexRequest) (*Index, error)
	// Lists the indexes that match the specified filters.  Datastore uses an
	// eventually consistent query to fetch the list of indexes and may
	// occasionally return stale results.
	ListIndexes(context.Context, *ListIndexesRequest) (*ListIndexesResponse, error)
}

// UnimplementedDatastoreAdminServer can be embedded to have forward compatible implementations.
type UnimplementedDatastoreAdminServer struct {
}

func (*UnimplementedDatastoreAdminServer) ExportEntities(context.Context, *ExportEntitiesRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportEntities not implemented")
}
func (*UnimplementedDatastoreAdminServer) ImportEntities(context.Context, *ImportEntitiesRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportEntities not implemented")
}
func (*UnimplementedDatastoreAdminServer) CreateIndex(context.Context, *CreateIndexRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIndex not implemented")
}
func (*UnimplementedDatastoreAdminServer) DeleteIndex(context.Context, *DeleteIndexRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIndex not implemented")
}
func (*UnimplementedDatastoreAdminServer) GetIndex(context.Context, *GetIndexRequest) (*Index, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIndex not implemented")
}
func (*UnimplementedDatastoreAdminServer) ListIndexes(context.Context, *ListIndexesRequest) (*ListIndexesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIndexes not implemented")
}

func RegisterDatastoreAdminServer(s *grpc.Server, srv DatastoreAdminServer) {
	s.RegisterService(&_DatastoreAdmin_serviceDesc, srv)
}

func _DatastoreAdmin_ExportEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).ExportEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.admin.v1.DatastoreAdmin/ExportEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).ExportEntities(ctx, req.(*ExportEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatastoreAdmin_ImportEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).ImportEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.admin.v1.DatastoreAdmin/ImportEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).ImportEntities(ctx, req.(*ImportEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatastoreAdmin_CreateIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).CreateIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.admin.v1.DatastoreAdmin/CreateIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).CreateIndex(ctx, req.(*CreateIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatastoreAdmin_DeleteIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).DeleteIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.admin.v1.DatastoreAdmin/DeleteIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).DeleteIndex(ctx, req.(*DeleteIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatastoreAdmin_GetIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).GetIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.admin.v1.DatastoreAdmin/GetIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).GetIndex(ctx, req.(*GetIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatastoreAdmin_ListIndexes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIndexesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).ListIndexes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.admin.v1.DatastoreAdmin/ListIndexes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).ListIndexes(ctx, req.(*ListIndexesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DatastoreAdmin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.datastore.admin.v1.DatastoreAdmin",
	HandlerType: (*DatastoreAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ExportEntities",
			Handler:    _DatastoreAdmin_ExportEntities_Handler,
		},
		{
			MethodName: "ImportEntities",
			Handler:    _DatastoreAdmin_ImportEntities_Handler,
		},
		{
			MethodName: "CreateIndex",
			Handler:    _DatastoreAdmin_CreateIndex_Handler,
		},
		{
			MethodName: "DeleteIndex",
			Handler:    _DatastoreAdmin_DeleteIndex_Handler,
		},
		{
			MethodName: "GetIndex",
			Handler:    _DatastoreAdmin_GetIndex_Handler,
		},
		{
			MethodName: "ListIndexes",
			Handler:    _DatastoreAdmin_ListIndexes_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/datastore/admin/v1/datastore_admin.proto",
}
