// Code generated by go-swagger; DO NOT EDIT.

package p_cloud_images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/IBM-Cloud/power-go-client/power/models"
)

// PcloudV2ImagesExportPostReader is a Reader for the PcloudV2ImagesExportPost structure.
type PcloudV2ImagesExportPostReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PcloudV2ImagesExportPostReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {

	case 202:
		result := NewPcloudV2ImagesExportPostAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil

	case 400:
		result := NewPcloudV2ImagesExportPostBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 401:
		result := NewPcloudV2ImagesExportPostUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 404:
		result := NewPcloudV2ImagesExportPostNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 409:
		result := NewPcloudV2ImagesExportPostConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 422:
		result := NewPcloudV2ImagesExportPostUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 500:
		result := NewPcloudV2ImagesExportPostInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("unknown error", response, response.Code())
	}
}

// NewPcloudV2ImagesExportPostAccepted creates a PcloudV2ImagesExportPostAccepted with default headers values
func NewPcloudV2ImagesExportPostAccepted() *PcloudV2ImagesExportPostAccepted {
	return &PcloudV2ImagesExportPostAccepted{}
}

/*PcloudV2ImagesExportPostAccepted handles this case with default header values.

Accepted, image export successfully added to the jobs queue
*/
type PcloudV2ImagesExportPostAccepted struct {
	Payload *models.JobReference
}

func (o *PcloudV2ImagesExportPostAccepted) Error() string {
	return fmt.Sprintf("[POST /pcloud/v2/cloud-instances/{cloud_instance_id}/images/{image_id}/export][%d] pcloudV2ImagesExportPostAccepted  %+v", 202, o.Payload)
}

func (o *PcloudV2ImagesExportPostAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.JobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPcloudV2ImagesExportPostBadRequest creates a PcloudV2ImagesExportPostBadRequest with default headers values
func NewPcloudV2ImagesExportPostBadRequest() *PcloudV2ImagesExportPostBadRequest {
	return &PcloudV2ImagesExportPostBadRequest{}
}

/*PcloudV2ImagesExportPostBadRequest handles this case with default header values.

Bad Request
*/
type PcloudV2ImagesExportPostBadRequest struct {
	Payload *models.Error
}

func (o *PcloudV2ImagesExportPostBadRequest) Error() string {
	return fmt.Sprintf("[POST /pcloud/v2/cloud-instances/{cloud_instance_id}/images/{image_id}/export][%d] pcloudV2ImagesExportPostBadRequest  %+v", 400, o.Payload)
}

func (o *PcloudV2ImagesExportPostBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPcloudV2ImagesExportPostUnauthorized creates a PcloudV2ImagesExportPostUnauthorized with default headers values
func NewPcloudV2ImagesExportPostUnauthorized() *PcloudV2ImagesExportPostUnauthorized {
	return &PcloudV2ImagesExportPostUnauthorized{}
}

/*PcloudV2ImagesExportPostUnauthorized handles this case with default header values.

Unauthorized
*/
type PcloudV2ImagesExportPostUnauthorized struct {
	Payload *models.Error
}

func (o *PcloudV2ImagesExportPostUnauthorized) Error() string {
	return fmt.Sprintf("[POST /pcloud/v2/cloud-instances/{cloud_instance_id}/images/{image_id}/export][%d] pcloudV2ImagesExportPostUnauthorized  %+v", 401, o.Payload)
}

func (o *PcloudV2ImagesExportPostUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPcloudV2ImagesExportPostNotFound creates a PcloudV2ImagesExportPostNotFound with default headers values
func NewPcloudV2ImagesExportPostNotFound() *PcloudV2ImagesExportPostNotFound {
	return &PcloudV2ImagesExportPostNotFound{}
}

/*PcloudV2ImagesExportPostNotFound handles this case with default header values.

image id not found
*/
type PcloudV2ImagesExportPostNotFound struct {
	Payload *models.Error
}

func (o *PcloudV2ImagesExportPostNotFound) Error() string {
	return fmt.Sprintf("[POST /pcloud/v2/cloud-instances/{cloud_instance_id}/images/{image_id}/export][%d] pcloudV2ImagesExportPostNotFound  %+v", 404, o.Payload)
}

func (o *PcloudV2ImagesExportPostNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPcloudV2ImagesExportPostConflict creates a PcloudV2ImagesExportPostConflict with default headers values
func NewPcloudV2ImagesExportPostConflict() *PcloudV2ImagesExportPostConflict {
	return &PcloudV2ImagesExportPostConflict{}
}

/*PcloudV2ImagesExportPostConflict handles this case with default header values.

Conflict, a conflict has prevented adding image export job
*/
type PcloudV2ImagesExportPostConflict struct {
	Payload *models.Error
}

func (o *PcloudV2ImagesExportPostConflict) Error() string {
	return fmt.Sprintf("[POST /pcloud/v2/cloud-instances/{cloud_instance_id}/images/{image_id}/export][%d] pcloudV2ImagesExportPostConflict  %+v", 409, o.Payload)
}

func (o *PcloudV2ImagesExportPostConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPcloudV2ImagesExportPostUnprocessableEntity creates a PcloudV2ImagesExportPostUnprocessableEntity with default headers values
func NewPcloudV2ImagesExportPostUnprocessableEntity() *PcloudV2ImagesExportPostUnprocessableEntity {
	return &PcloudV2ImagesExportPostUnprocessableEntity{}
}

/*PcloudV2ImagesExportPostUnprocessableEntity handles this case with default header values.

Unprocessable Entity
*/
type PcloudV2ImagesExportPostUnprocessableEntity struct {
	Payload *models.Error
}

func (o *PcloudV2ImagesExportPostUnprocessableEntity) Error() string {
	return fmt.Sprintf("[POST /pcloud/v2/cloud-instances/{cloud_instance_id}/images/{image_id}/export][%d] pcloudV2ImagesExportPostUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *PcloudV2ImagesExportPostUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPcloudV2ImagesExportPostInternalServerError creates a PcloudV2ImagesExportPostInternalServerError with default headers values
func NewPcloudV2ImagesExportPostInternalServerError() *PcloudV2ImagesExportPostInternalServerError {
	return &PcloudV2ImagesExportPostInternalServerError{}
}

/*PcloudV2ImagesExportPostInternalServerError handles this case with default header values.

Internal Server Error
*/
type PcloudV2ImagesExportPostInternalServerError struct {
	Payload *models.Error
}

func (o *PcloudV2ImagesExportPostInternalServerError) Error() string {
	return fmt.Sprintf("[POST /pcloud/v2/cloud-instances/{cloud_instance_id}/images/{image_id}/export][%d] pcloudV2ImagesExportPostInternalServerError  %+v", 500, o.Payload)
}

func (o *PcloudV2ImagesExportPostInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
