// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// IPSecPolicyUpdate IPSEc Policy object used for update
// swagger:model IPSecPolicyUpdate
type IPSecPolicyUpdate struct {

	// authentication
	Authentication IPSECPolicyAuthentication `json:"authentication,omitempty"`

	// Diffie-Hellman group
	// Enum: [1 2 5 14 19 20 24]
	DhGroup int64 `json:"dhGroup,omitempty"`

	// connection encryption policy
	// Enum: [3des-cbc aes-128-cbc aes-128-gcm aes-192-cbc aes-192-gcm aes-256-cbc aes-256-gcm des-cbc]
	Encryption string `json:"encryption,omitempty"`

	// key lifetime
	KeyLifetime KeyLifetime `json:"keyLifetime,omitempty"`

	// IPSec Policy name
	// Max Length: 47
	// Min Length: 1
	Name string `json:"name,omitempty"`

	// Perfect Forward Secrecy
	Pfs *bool `json:"pfs,omitempty"`

	// IP sec policy update additional properties
	IPSecPolicyUpdateAdditionalProperties map[string]interface{} `json:"-"`
}

// UnmarshalJSON unmarshals this object with additional properties from JSON
func (m *IPSecPolicyUpdate) UnmarshalJSON(data []byte) error {
	// stage 1, bind the properties
	var stage1 struct {

		// authentication
		Authentication IPSECPolicyAuthentication `json:"authentication,omitempty"`

		// Diffie-Hellman group
		// Enum: [1 2 5 14 19 20 24]
		DhGroup int64 `json:"dhGroup,omitempty"`

		// connection encryption policy
		// Enum: [3des-cbc aes-128-cbc aes-128-gcm aes-192-cbc aes-192-gcm aes-256-cbc aes-256-gcm des-cbc]
		Encryption string `json:"encryption,omitempty"`

		// key lifetime
		KeyLifetime KeyLifetime `json:"keyLifetime,omitempty"`

		// IPSec Policy name
		// Max Length: 47
		// Min Length: 1
		Name string `json:"name,omitempty"`

		// Perfect Forward Secrecy
		Pfs *bool `json:"pfs,omitempty"`
	}
	if err := json.Unmarshal(data, &stage1); err != nil {
		return err
	}
	var rcv IPSecPolicyUpdate

	rcv.Authentication = stage1.Authentication

	rcv.DhGroup = stage1.DhGroup

	rcv.Encryption = stage1.Encryption

	rcv.KeyLifetime = stage1.KeyLifetime

	rcv.Name = stage1.Name

	rcv.Pfs = stage1.Pfs

	*m = rcv

	// stage 2, remove properties and add to map
	stage2 := make(map[string]json.RawMessage)
	if err := json.Unmarshal(data, &stage2); err != nil {
		return err
	}

	delete(stage2, "authentication")

	delete(stage2, "dhGroup")

	delete(stage2, "encryption")

	delete(stage2, "keyLifetime")

	delete(stage2, "name")

	delete(stage2, "pfs")

	// stage 3, add additional properties values
	if len(stage2) > 0 {
		result := make(map[string]interface{})
		for k, v := range stage2 {
			var toadd interface{}
			if err := json.Unmarshal(v, &toadd); err != nil {
				return err
			}
			result[k] = toadd
		}
		m.IPSecPolicyUpdateAdditionalProperties = result
	}

	return nil
}

// MarshalJSON marshals this object with additional properties into a JSON object
func (m IPSecPolicyUpdate) MarshalJSON() ([]byte, error) {
	var stage1 struct {

		// authentication
		Authentication IPSECPolicyAuthentication `json:"authentication,omitempty"`

		// Diffie-Hellman group
		// Enum: [1 2 5 14 19 20 24]
		DhGroup int64 `json:"dhGroup,omitempty"`

		// connection encryption policy
		// Enum: [3des-cbc aes-128-cbc aes-128-gcm aes-192-cbc aes-192-gcm aes-256-cbc aes-256-gcm des-cbc]
		Encryption string `json:"encryption,omitempty"`

		// key lifetime
		KeyLifetime KeyLifetime `json:"keyLifetime,omitempty"`

		// IPSec Policy name
		// Max Length: 47
		// Min Length: 1
		Name string `json:"name,omitempty"`

		// Perfect Forward Secrecy
		Pfs *bool `json:"pfs,omitempty"`
	}

	stage1.Authentication = m.Authentication

	stage1.DhGroup = m.DhGroup

	stage1.Encryption = m.Encryption

	stage1.KeyLifetime = m.KeyLifetime

	stage1.Name = m.Name

	stage1.Pfs = m.Pfs

	// make JSON object for known properties
	props, err := json.Marshal(stage1)
	if err != nil {
		return nil, err
	}

	if len(m.IPSecPolicyUpdateAdditionalProperties) == 0 {
		return props, nil
	}

	// make JSON object for the additional properties
	additional, err := json.Marshal(m.IPSecPolicyUpdateAdditionalProperties)
	if err != nil {
		return nil, err
	}

	if len(props) < 3 {
		return additional, nil
	}

	// concatenate the 2 objects
	props[len(props)-1] = ','
	return append(props, additional[1:]...), nil
}

// Validate validates this IP sec policy update
func (m *IPSecPolicyUpdate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAuthentication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDhGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKeyLifetime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPSecPolicyUpdate) validateAuthentication(formats strfmt.Registry) error {

	if swag.IsZero(m.Authentication) { // not required
		return nil
	}

	if err := m.Authentication.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("authentication")
		}
		return err
	}

	return nil
}

var ipSecPolicyUpdateTypeDhGroupPropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[1,2,5,14,19,20,24]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipSecPolicyUpdateTypeDhGroupPropEnum = append(ipSecPolicyUpdateTypeDhGroupPropEnum, v)
	}
}

// prop value enum
func (m *IPSecPolicyUpdate) validateDhGroupEnum(path, location string, value int64) error {
	if err := validate.Enum(path, location, value, ipSecPolicyUpdateTypeDhGroupPropEnum); err != nil {
		return err
	}
	return nil
}

func (m *IPSecPolicyUpdate) validateDhGroup(formats strfmt.Registry) error {

	if swag.IsZero(m.DhGroup) { // not required
		return nil
	}

	// value enum
	if err := m.validateDhGroupEnum("dhGroup", "body", m.DhGroup); err != nil {
		return err
	}

	return nil
}

var ipSecPolicyUpdateTypeEncryptionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["3des-cbc","aes-128-cbc","aes-128-gcm","aes-192-cbc","aes-192-gcm","aes-256-cbc","aes-256-gcm","des-cbc"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipSecPolicyUpdateTypeEncryptionPropEnum = append(ipSecPolicyUpdateTypeEncryptionPropEnum, v)
	}
}

const (

	// IPSecPolicyUpdateEncryptionNr3desCbc captures enum value "3des-cbc"
	IPSecPolicyUpdateEncryptionNr3desCbc string = "3des-cbc"

	// IPSecPolicyUpdateEncryptionAes128Cbc captures enum value "aes-128-cbc"
	IPSecPolicyUpdateEncryptionAes128Cbc string = "aes-128-cbc"

	// IPSecPolicyUpdateEncryptionAes128Gcm captures enum value "aes-128-gcm"
	IPSecPolicyUpdateEncryptionAes128Gcm string = "aes-128-gcm"

	// IPSecPolicyUpdateEncryptionAes192Cbc captures enum value "aes-192-cbc"
	IPSecPolicyUpdateEncryptionAes192Cbc string = "aes-192-cbc"

	// IPSecPolicyUpdateEncryptionAes192Gcm captures enum value "aes-192-gcm"
	IPSecPolicyUpdateEncryptionAes192Gcm string = "aes-192-gcm"

	// IPSecPolicyUpdateEncryptionAes256Cbc captures enum value "aes-256-cbc"
	IPSecPolicyUpdateEncryptionAes256Cbc string = "aes-256-cbc"

	// IPSecPolicyUpdateEncryptionAes256Gcm captures enum value "aes-256-gcm"
	IPSecPolicyUpdateEncryptionAes256Gcm string = "aes-256-gcm"

	// IPSecPolicyUpdateEncryptionDesCbc captures enum value "des-cbc"
	IPSecPolicyUpdateEncryptionDesCbc string = "des-cbc"
)

// prop value enum
func (m *IPSecPolicyUpdate) validateEncryptionEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, ipSecPolicyUpdateTypeEncryptionPropEnum); err != nil {
		return err
	}
	return nil
}

func (m *IPSecPolicyUpdate) validateEncryption(formats strfmt.Registry) error {

	if swag.IsZero(m.Encryption) { // not required
		return nil
	}

	// value enum
	if err := m.validateEncryptionEnum("encryption", "body", m.Encryption); err != nil {
		return err
	}

	return nil
}

func (m *IPSecPolicyUpdate) validateKeyLifetime(formats strfmt.Registry) error {

	if swag.IsZero(m.KeyLifetime) { // not required
		return nil
	}

	if err := m.KeyLifetime.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("keyLifetime")
		}
		return err
	}

	return nil
}

func (m *IPSecPolicyUpdate) validateName(formats strfmt.Registry) error {

	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", string(m.Name), 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", string(m.Name), 47); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPSecPolicyUpdate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPSecPolicyUpdate) UnmarshalBinary(b []byte) error {
	var res IPSecPolicyUpdate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
