// Code generated by go-swagger; DO NOT EDIT.

package p_cloud_volumes

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"
)

// New creates a new p cloud volumes API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) *Client {
	return &Client{transport: transport, formats: formats}
}

/*
Client for p cloud volumes API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

/*
PcloudCloudinstancesVolumesActionPost performs an action on a volume
*/
func (a *Client) PcloudCloudinstancesVolumesActionPost(params *PcloudCloudinstancesVolumesActionPostParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudCloudinstancesVolumesActionPostAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudCloudinstancesVolumesActionPostParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.cloudinstances.volumes.action.post",
		Method:             "POST",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/volumes/{volume_id}/action",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudCloudinstancesVolumesActionPostReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudCloudinstancesVolumesActionPostAccepted), nil

}

/*
PcloudCloudinstancesVolumesDelete deletes a cloud instance volume
*/
func (a *Client) PcloudCloudinstancesVolumesDelete(params *PcloudCloudinstancesVolumesDeleteParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudCloudinstancesVolumesDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudCloudinstancesVolumesDeleteParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.cloudinstances.volumes.delete",
		Method:             "DELETE",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/volumes/{volume_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudCloudinstancesVolumesDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudCloudinstancesVolumesDeleteOK), nil

}

/*
PcloudCloudinstancesVolumesGet detaileds info of a volume
*/
func (a *Client) PcloudCloudinstancesVolumesGet(params *PcloudCloudinstancesVolumesGetParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudCloudinstancesVolumesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudCloudinstancesVolumesGetParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.cloudinstances.volumes.get",
		Method:             "GET",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/volumes/{volume_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudCloudinstancesVolumesGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudCloudinstancesVolumesGetOK), nil

}

/*
PcloudCloudinstancesVolumesGetall lists all volumes for this cloud instance
*/
func (a *Client) PcloudCloudinstancesVolumesGetall(params *PcloudCloudinstancesVolumesGetallParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudCloudinstancesVolumesGetallOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudCloudinstancesVolumesGetallParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.cloudinstances.volumes.getall",
		Method:             "GET",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/volumes",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudCloudinstancesVolumesGetallReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudCloudinstancesVolumesGetallOK), nil

}

/*
PcloudCloudinstancesVolumesPost creates a new data volume
*/
func (a *Client) PcloudCloudinstancesVolumesPost(params *PcloudCloudinstancesVolumesPostParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudCloudinstancesVolumesPostAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudCloudinstancesVolumesPostParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.cloudinstances.volumes.post",
		Method:             "POST",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/volumes",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudCloudinstancesVolumesPostReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudCloudinstancesVolumesPostAccepted), nil

}

/*
PcloudCloudinstancesVolumesPut updates a cloud instance volume
*/
func (a *Client) PcloudCloudinstancesVolumesPut(params *PcloudCloudinstancesVolumesPutParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudCloudinstancesVolumesPutOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudCloudinstancesVolumesPutParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.cloudinstances.volumes.put",
		Method:             "PUT",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/volumes/{volume_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudCloudinstancesVolumesPutReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudCloudinstancesVolumesPutOK), nil

}

/*
PcloudPvminstancesVolumesDelete detaches a volume from a p VM instance
*/
func (a *Client) PcloudPvminstancesVolumesDelete(params *PcloudPvminstancesVolumesDeleteParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudPvminstancesVolumesDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudPvminstancesVolumesDeleteParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.pvminstances.volumes.delete",
		Method:             "DELETE",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/pvm-instances/{pvm_instance_id}/volumes/{volume_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudPvminstancesVolumesDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudPvminstancesVolumesDeleteAccepted), nil

}

/*
PcloudPvminstancesVolumesGet detaileds info of a volume attached to a p VM instance
*/
func (a *Client) PcloudPvminstancesVolumesGet(params *PcloudPvminstancesVolumesGetParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudPvminstancesVolumesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudPvminstancesVolumesGetParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.pvminstances.volumes.get",
		Method:             "GET",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/pvm-instances/{pvm_instance_id}/volumes/{volume_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudPvminstancesVolumesGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudPvminstancesVolumesGetOK), nil

}

/*
PcloudPvminstancesVolumesGetall lists all volumes attached to a p VM instance
*/
func (a *Client) PcloudPvminstancesVolumesGetall(params *PcloudPvminstancesVolumesGetallParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudPvminstancesVolumesGetallOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudPvminstancesVolumesGetallParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.pvminstances.volumes.getall",
		Method:             "GET",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/pvm-instances/{pvm_instance_id}/volumes",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudPvminstancesVolumesGetallReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudPvminstancesVolumesGetallOK), nil

}

/*
PcloudPvminstancesVolumesPost attaches a volume to a p VM instance
*/
func (a *Client) PcloudPvminstancesVolumesPost(params *PcloudPvminstancesVolumesPostParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudPvminstancesVolumesPostOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudPvminstancesVolumesPostParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.pvminstances.volumes.post",
		Method:             "POST",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/pvm-instances/{pvm_instance_id}/volumes/{volume_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudPvminstancesVolumesPostReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudPvminstancesVolumesPostOK), nil

}

/*
PcloudPvminstancesVolumesPut updates a volume attached to a p VM instance
*/
func (a *Client) PcloudPvminstancesVolumesPut(params *PcloudPvminstancesVolumesPutParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudPvminstancesVolumesPutOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudPvminstancesVolumesPutParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.pvminstances.volumes.put",
		Method:             "PUT",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/pvm-instances/{pvm_instance_id}/volumes/{volume_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudPvminstancesVolumesPutReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudPvminstancesVolumesPutOK), nil

}

/*
PcloudPvminstancesVolumesSetbootPut sets the p VM instance volume as the boot volume
*/
func (a *Client) PcloudPvminstancesVolumesSetbootPut(params *PcloudPvminstancesVolumesSetbootPutParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudPvminstancesVolumesSetbootPutOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudPvminstancesVolumesSetbootPutParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.pvminstances.volumes.setboot.put",
		Method:             "PUT",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/pvm-instances/{pvm_instance_id}/volumes/{volume_id}/setboot",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudPvminstancesVolumesSetbootPutReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudPvminstancesVolumesSetbootPutOK), nil

}

/*
PcloudV2PvminstancesVolumesPost attaches all volumes to a p VM instance
*/
func (a *Client) PcloudV2PvminstancesVolumesPost(params *PcloudV2PvminstancesVolumesPostParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudV2PvminstancesVolumesPostAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudV2PvminstancesVolumesPostParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.v2.pvminstances.volumes.post",
		Method:             "POST",
		PathPattern:        "/pcloud/v2/cloud-instances/{cloud_instance_id}/pvm-instances/{pvm_instance_id}/volumes",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudV2PvminstancesVolumesPostReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudV2PvminstancesVolumesPostAccepted), nil

}

/*
PcloudV2VolumesClonePost creates a volume clone for specified volumes
*/
func (a *Client) PcloudV2VolumesClonePost(params *PcloudV2VolumesClonePostParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudV2VolumesClonePostAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudV2VolumesClonePostParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.v2.volumes.clone.post",
		Method:             "POST",
		PathPattern:        "/pcloud/v2/cloud-instances/{cloud_instance_id}/volumes/clone",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudV2VolumesClonePostReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudV2VolumesClonePostAccepted), nil

}

/*
PcloudV2VolumesClonetasksGet gets the status of a volumes clone request for the specified clone task ID
*/
func (a *Client) PcloudV2VolumesClonetasksGet(params *PcloudV2VolumesClonetasksGetParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudV2VolumesClonetasksGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudV2VolumesClonetasksGetParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.v2.volumes.clonetasks.get",
		Method:             "GET",
		PathPattern:        "/pcloud/v2/cloud-instances/{cloud_instance_id}/volumes/clone-tasks/{clone_task_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudV2VolumesClonetasksGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudV2VolumesClonetasksGetOK), nil

}

/*
PcloudV2VolumesPost creates multiple data volumes from a single definition
*/
func (a *Client) PcloudV2VolumesPost(params *PcloudV2VolumesPostParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudV2VolumesPostCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudV2VolumesPostParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.v2.volumes.post",
		Method:             "POST",
		PathPattern:        "/pcloud/v2/cloud-instances/{cloud_instance_id}/volumes",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudV2VolumesPostReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudV2VolumesPostCreated), nil

}

/*
PcloudV2VolumescloneCancelPost cancels a volumes clone request initiates the cleanup action cleanup action performs the cleanup of the preparatory clones and snapshot volumes
*/
func (a *Client) PcloudV2VolumescloneCancelPost(params *PcloudV2VolumescloneCancelPostParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudV2VolumescloneCancelPostAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudV2VolumescloneCancelPostParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.v2.volumesclone.cancel.post",
		Method:             "POST",
		PathPattern:        "/pcloud/v2/cloud-instances/{cloud_instance_id}/volumes-clone/{volumes_clone_id}/cancel",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudV2VolumescloneCancelPostReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudV2VolumescloneCancelPostAccepted), nil

}

/*
PcloudV2VolumescloneDelete deletes a volumes clone request
*/
func (a *Client) PcloudV2VolumescloneDelete(params *PcloudV2VolumescloneDeleteParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudV2VolumescloneDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudV2VolumescloneDeleteParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.v2.volumesclone.delete",
		Method:             "DELETE",
		PathPattern:        "/pcloud/v2/cloud-instances/{cloud_instance_id}/volumes-clone/{volumes_clone_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudV2VolumescloneDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudV2VolumescloneDeleteOK), nil

}

/*
PcloudV2VolumescloneExecutePost initiates the execute action for a volumes clone request execute action creates the cloned volumes using the volume snapshots
*/
func (a *Client) PcloudV2VolumescloneExecutePost(params *PcloudV2VolumescloneExecutePostParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudV2VolumescloneExecutePostAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudV2VolumescloneExecutePostParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.v2.volumesclone.execute.post",
		Method:             "POST",
		PathPattern:        "/pcloud/v2/cloud-instances/{cloud_instance_id}/volumes-clone/{volumes_clone_id}/execute",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudV2VolumescloneExecutePostReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudV2VolumescloneExecutePostAccepted), nil

}

/*
PcloudV2VolumescloneGet gets the details for a volumes clone request
*/
func (a *Client) PcloudV2VolumescloneGet(params *PcloudV2VolumescloneGetParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudV2VolumescloneGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudV2VolumescloneGetParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.v2.volumesclone.get",
		Method:             "GET",
		PathPattern:        "/pcloud/v2/cloud-instances/{cloud_instance_id}/volumes-clone/{volumes_clone_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudV2VolumescloneGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudV2VolumescloneGetOK), nil

}

/*
PcloudV2VolumescloneGetall gets the list of volumes clone request for a cloud instance
*/
func (a *Client) PcloudV2VolumescloneGetall(params *PcloudV2VolumescloneGetallParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudV2VolumescloneGetallOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudV2VolumescloneGetallParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.v2.volumesclone.getall",
		Method:             "GET",
		PathPattern:        "/pcloud/v2/cloud-instances/{cloud_instance_id}/volumes-clone",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudV2VolumescloneGetallReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudV2VolumescloneGetallOK), nil

}

/*
PcloudV2VolumesclonePost creates a new volumes clone request and initiates the prepare action requires a minimum of two volumes requires a minimum of one volume to be in the in use state requires a unique volumes clone name prepare action does the preparatory work for creating the snapshot volumes
*/
func (a *Client) PcloudV2VolumesclonePost(params *PcloudV2VolumesclonePostParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudV2VolumesclonePostAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudV2VolumesclonePostParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.v2.volumesclone.post",
		Method:             "POST",
		PathPattern:        "/pcloud/v2/cloud-instances/{cloud_instance_id}/volumes-clone",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudV2VolumesclonePostReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudV2VolumesclonePostAccepted), nil

}

/*
PcloudV2VolumescloneStartPost initiates the start action for a volumes clone request start action starts the consistency group to initiate the flash copy
*/
func (a *Client) PcloudV2VolumescloneStartPost(params *PcloudV2VolumescloneStartPostParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudV2VolumescloneStartPostOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudV2VolumescloneStartPostParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.v2.volumesclone.start.post",
		Method:             "POST",
		PathPattern:        "/pcloud/v2/cloud-instances/{cloud_instance_id}/volumes-clone/{volumes_clone_id}/start",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudV2VolumescloneStartPostReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudV2VolumescloneStartPostOK), nil

}

/*
PcloudVolumesClonePost creates a volume clone for specified volumes
*/
func (a *Client) PcloudVolumesClonePost(params *PcloudVolumesClonePostParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudVolumesClonePostOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudVolumesClonePostParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.volumes.clone.post",
		Method:             "POST",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/volumes/clone",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudVolumesClonePostReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudVolumesClonePostOK), nil

}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
