// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DeadPeerDetection Dead Peer Detection of the VPN Connection
// swagger:model DeadPeerDetection
type DeadPeerDetection struct {

	// Action to take when a Peer Gateway stops responding
	// Required: true
	// Enum: [restart]
	Action *string `json:"action"`

	// How often to test that the Peer Gateway is responsive
	// Required: true
	// Maximum: 60
	// Minimum: 2
	Interval *int64 `json:"interval"`

	// The number of attempts to connect before tearing down the connection
	// Required: true
	// Maximum: 5
	// Minimum: 1
	Threshold *int64 `json:"threshold"`
}

// Validate validates this dead peer detection
func (m *DeadPeerDetection) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInterval(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThreshold(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var deadPeerDetectionTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["restart"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		deadPeerDetectionTypeActionPropEnum = append(deadPeerDetectionTypeActionPropEnum, v)
	}
}

const (

	// DeadPeerDetectionActionRestart captures enum value "restart"
	DeadPeerDetectionActionRestart string = "restart"
)

// prop value enum
func (m *DeadPeerDetection) validateActionEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, deadPeerDetectionTypeActionPropEnum); err != nil {
		return err
	}
	return nil
}

func (m *DeadPeerDetection) validateAction(formats strfmt.Registry) error {

	if err := validate.Required("action", "body", m.Action); err != nil {
		return err
	}

	// value enum
	if err := m.validateActionEnum("action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

func (m *DeadPeerDetection) validateInterval(formats strfmt.Registry) error {

	if err := validate.Required("interval", "body", m.Interval); err != nil {
		return err
	}

	if err := validate.MinimumInt("interval", "body", int64(*m.Interval), 2, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("interval", "body", int64(*m.Interval), 60, false); err != nil {
		return err
	}

	return nil
}

func (m *DeadPeerDetection) validateThreshold(formats strfmt.Registry) error {

	if err := validate.Required("threshold", "body", m.Threshold); err != nil {
		return err
	}

	if err := validate.MinimumInt("threshold", "body", int64(*m.Threshold), 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("threshold", "body", int64(*m.Threshold), 5, false); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DeadPeerDetection) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DeadPeerDetection) UnmarshalBinary(b []byte) error {
	var res DeadPeerDetection
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
