// Code generated by go-swagger; DO NOT EDIT.

package internal_storage_regions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/IBM-Cloud/power-go-client/power/models"
)

// NewInternalV1StorageRegionsThresholdsPutParams creates a new InternalV1StorageRegionsThresholdsPutParams object
// with the default values initialized.
func NewInternalV1StorageRegionsThresholdsPutParams() *InternalV1StorageRegionsThresholdsPutParams {
	var ()
	return &InternalV1StorageRegionsThresholdsPutParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewInternalV1StorageRegionsThresholdsPutParamsWithTimeout creates a new InternalV1StorageRegionsThresholdsPutParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewInternalV1StorageRegionsThresholdsPutParamsWithTimeout(timeout time.Duration) *InternalV1StorageRegionsThresholdsPutParams {
	var ()
	return &InternalV1StorageRegionsThresholdsPutParams{

		timeout: timeout,
	}
}

// NewInternalV1StorageRegionsThresholdsPutParamsWithContext creates a new InternalV1StorageRegionsThresholdsPutParams object
// with the default values initialized, and the ability to set a context for a request
func NewInternalV1StorageRegionsThresholdsPutParamsWithContext(ctx context.Context) *InternalV1StorageRegionsThresholdsPutParams {
	var ()
	return &InternalV1StorageRegionsThresholdsPutParams{

		Context: ctx,
	}
}

// NewInternalV1StorageRegionsThresholdsPutParamsWithHTTPClient creates a new InternalV1StorageRegionsThresholdsPutParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewInternalV1StorageRegionsThresholdsPutParamsWithHTTPClient(client *http.Client) *InternalV1StorageRegionsThresholdsPutParams {
	var ()
	return &InternalV1StorageRegionsThresholdsPutParams{
		HTTPClient: client,
	}
}

/*InternalV1StorageRegionsThresholdsPutParams contains all the parameters to send to the API endpoint
for the internal v1 storage regions thresholds put operation typically these are written to a http.Request
*/
type InternalV1StorageRegionsThresholdsPutParams struct {

	/*Body
	  Parameters for updating default threshold settings for a region-zone

	*/
	Body *models.Thresholds
	/*RegionZoneID
	  ID of a Power Cloud Region Zone

	*/
	RegionZoneID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the internal v1 storage regions thresholds put params
func (o *InternalV1StorageRegionsThresholdsPutParams) WithTimeout(timeout time.Duration) *InternalV1StorageRegionsThresholdsPutParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the internal v1 storage regions thresholds put params
func (o *InternalV1StorageRegionsThresholdsPutParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the internal v1 storage regions thresholds put params
func (o *InternalV1StorageRegionsThresholdsPutParams) WithContext(ctx context.Context) *InternalV1StorageRegionsThresholdsPutParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the internal v1 storage regions thresholds put params
func (o *InternalV1StorageRegionsThresholdsPutParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the internal v1 storage regions thresholds put params
func (o *InternalV1StorageRegionsThresholdsPutParams) WithHTTPClient(client *http.Client) *InternalV1StorageRegionsThresholdsPutParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the internal v1 storage regions thresholds put params
func (o *InternalV1StorageRegionsThresholdsPutParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the internal v1 storage regions thresholds put params
func (o *InternalV1StorageRegionsThresholdsPutParams) WithBody(body *models.Thresholds) *InternalV1StorageRegionsThresholdsPutParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the internal v1 storage regions thresholds put params
func (o *InternalV1StorageRegionsThresholdsPutParams) SetBody(body *models.Thresholds) {
	o.Body = body
}

// WithRegionZoneID adds the regionZoneID to the internal v1 storage regions thresholds put params
func (o *InternalV1StorageRegionsThresholdsPutParams) WithRegionZoneID(regionZoneID string) *InternalV1StorageRegionsThresholdsPutParams {
	o.SetRegionZoneID(regionZoneID)
	return o
}

// SetRegionZoneID adds the regionZoneId to the internal v1 storage regions thresholds put params
func (o *InternalV1StorageRegionsThresholdsPutParams) SetRegionZoneID(regionZoneID string) {
	o.RegionZoneID = regionZoneID
}

// WriteToRequest writes these params to a swagger request
func (o *InternalV1StorageRegionsThresholdsPutParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param region_zone_id
	if err := r.SetPathParam("region_zone_id", o.RegionZoneID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
