// Code generated by go-swagger; DO NOT EDIT.

package internal_storage_regions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/IBM-Cloud/power-go-client/power/models"
)

// InternalV1StorageRegionsThresholdsPutReader is a Reader for the InternalV1StorageRegionsThresholdsPut structure.
type InternalV1StorageRegionsThresholdsPutReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *InternalV1StorageRegionsThresholdsPutReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {

	case 202:
		result := NewInternalV1StorageRegionsThresholdsPutAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil

	case 400:
		result := NewInternalV1StorageRegionsThresholdsPutBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 401:
		result := NewInternalV1StorageRegionsThresholdsPutUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 403:
		result := NewInternalV1StorageRegionsThresholdsPutForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 409:
		result := NewInternalV1StorageRegionsThresholdsPutConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 422:
		result := NewInternalV1StorageRegionsThresholdsPutUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 500:
		result := NewInternalV1StorageRegionsThresholdsPutInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("unknown error", response, response.Code())
	}
}

// NewInternalV1StorageRegionsThresholdsPutAccepted creates a InternalV1StorageRegionsThresholdsPutAccepted with default headers values
func NewInternalV1StorageRegionsThresholdsPutAccepted() *InternalV1StorageRegionsThresholdsPutAccepted {
	return &InternalV1StorageRegionsThresholdsPutAccepted{}
}

/*InternalV1StorageRegionsThresholdsPutAccepted handles this case with default header values.

OK, region-zone default threshold settings update
*/
type InternalV1StorageRegionsThresholdsPutAccepted struct {
	Payload *models.Thresholds
}

func (o *InternalV1StorageRegionsThresholdsPutAccepted) Error() string {
	return fmt.Sprintf("[PUT /internal/v1/storage/regions/{region_zone_id}/thresholds][%d] internalV1StorageRegionsThresholdsPutAccepted  %+v", 202, o.Payload)
}

func (o *InternalV1StorageRegionsThresholdsPutAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Thresholds)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInternalV1StorageRegionsThresholdsPutBadRequest creates a InternalV1StorageRegionsThresholdsPutBadRequest with default headers values
func NewInternalV1StorageRegionsThresholdsPutBadRequest() *InternalV1StorageRegionsThresholdsPutBadRequest {
	return &InternalV1StorageRegionsThresholdsPutBadRequest{}
}

/*InternalV1StorageRegionsThresholdsPutBadRequest handles this case with default header values.

Bad Request
*/
type InternalV1StorageRegionsThresholdsPutBadRequest struct {
	Payload *models.Error
}

func (o *InternalV1StorageRegionsThresholdsPutBadRequest) Error() string {
	return fmt.Sprintf("[PUT /internal/v1/storage/regions/{region_zone_id}/thresholds][%d] internalV1StorageRegionsThresholdsPutBadRequest  %+v", 400, o.Payload)
}

func (o *InternalV1StorageRegionsThresholdsPutBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInternalV1StorageRegionsThresholdsPutUnauthorized creates a InternalV1StorageRegionsThresholdsPutUnauthorized with default headers values
func NewInternalV1StorageRegionsThresholdsPutUnauthorized() *InternalV1StorageRegionsThresholdsPutUnauthorized {
	return &InternalV1StorageRegionsThresholdsPutUnauthorized{}
}

/*InternalV1StorageRegionsThresholdsPutUnauthorized handles this case with default header values.

Unauthorized
*/
type InternalV1StorageRegionsThresholdsPutUnauthorized struct {
	Payload *models.Error
}

func (o *InternalV1StorageRegionsThresholdsPutUnauthorized) Error() string {
	return fmt.Sprintf("[PUT /internal/v1/storage/regions/{region_zone_id}/thresholds][%d] internalV1StorageRegionsThresholdsPutUnauthorized  %+v", 401, o.Payload)
}

func (o *InternalV1StorageRegionsThresholdsPutUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInternalV1StorageRegionsThresholdsPutForbidden creates a InternalV1StorageRegionsThresholdsPutForbidden with default headers values
func NewInternalV1StorageRegionsThresholdsPutForbidden() *InternalV1StorageRegionsThresholdsPutForbidden {
	return &InternalV1StorageRegionsThresholdsPutForbidden{}
}

/*InternalV1StorageRegionsThresholdsPutForbidden handles this case with default header values.

Forbidden
*/
type InternalV1StorageRegionsThresholdsPutForbidden struct {
	Payload *models.Error
}

func (o *InternalV1StorageRegionsThresholdsPutForbidden) Error() string {
	return fmt.Sprintf("[PUT /internal/v1/storage/regions/{region_zone_id}/thresholds][%d] internalV1StorageRegionsThresholdsPutForbidden  %+v", 403, o.Payload)
}

func (o *InternalV1StorageRegionsThresholdsPutForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInternalV1StorageRegionsThresholdsPutConflict creates a InternalV1StorageRegionsThresholdsPutConflict with default headers values
func NewInternalV1StorageRegionsThresholdsPutConflict() *InternalV1StorageRegionsThresholdsPutConflict {
	return &InternalV1StorageRegionsThresholdsPutConflict{}
}

/*InternalV1StorageRegionsThresholdsPutConflict handles this case with default header values.

Conflict
*/
type InternalV1StorageRegionsThresholdsPutConflict struct {
	Payload *models.Error
}

func (o *InternalV1StorageRegionsThresholdsPutConflict) Error() string {
	return fmt.Sprintf("[PUT /internal/v1/storage/regions/{region_zone_id}/thresholds][%d] internalV1StorageRegionsThresholdsPutConflict  %+v", 409, o.Payload)
}

func (o *InternalV1StorageRegionsThresholdsPutConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInternalV1StorageRegionsThresholdsPutUnprocessableEntity creates a InternalV1StorageRegionsThresholdsPutUnprocessableEntity with default headers values
func NewInternalV1StorageRegionsThresholdsPutUnprocessableEntity() *InternalV1StorageRegionsThresholdsPutUnprocessableEntity {
	return &InternalV1StorageRegionsThresholdsPutUnprocessableEntity{}
}

/*InternalV1StorageRegionsThresholdsPutUnprocessableEntity handles this case with default header values.

Unprocessable Entity
*/
type InternalV1StorageRegionsThresholdsPutUnprocessableEntity struct {
	Payload *models.Error
}

func (o *InternalV1StorageRegionsThresholdsPutUnprocessableEntity) Error() string {
	return fmt.Sprintf("[PUT /internal/v1/storage/regions/{region_zone_id}/thresholds][%d] internalV1StorageRegionsThresholdsPutUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *InternalV1StorageRegionsThresholdsPutUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInternalV1StorageRegionsThresholdsPutInternalServerError creates a InternalV1StorageRegionsThresholdsPutInternalServerError with default headers values
func NewInternalV1StorageRegionsThresholdsPutInternalServerError() *InternalV1StorageRegionsThresholdsPutInternalServerError {
	return &InternalV1StorageRegionsThresholdsPutInternalServerError{}
}

/*InternalV1StorageRegionsThresholdsPutInternalServerError handles this case with default header values.

Internal Server Error
*/
type InternalV1StorageRegionsThresholdsPutInternalServerError struct {
	Payload *models.Error
}

func (o *InternalV1StorageRegionsThresholdsPutInternalServerError) Error() string {
	return fmt.Sprintf("[PUT /internal/v1/storage/regions/{region_zone_id}/thresholds][%d] internalV1StorageRegionsThresholdsPutInternalServerError  %+v", 500, o.Payload)
}

func (o *InternalV1StorageRegionsThresholdsPutInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
