// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ExportImage export image
// swagger:model ExportImage
type ExportImage struct {

	// Cloud Object Storage Access key
	// Required: true
	AccessKey *string `json:"accessKey"`

	// Cloud Object Storage Bucket name
	// Required: true
	BucketName *string `json:"bucketName"`

	// Cloud Object Storage Region; required for IBM COS
	Region string `json:"region,omitempty"`

	// Cloud Object Storage Secret key
	SecretKey string `json:"secretKey,omitempty"`
}

// Validate validates this export image
func (m *ExportImage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccessKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBucketName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ExportImage) validateAccessKey(formats strfmt.Registry) error {

	if err := validate.Required("accessKey", "body", m.AccessKey); err != nil {
		return err
	}

	return nil
}

func (m *ExportImage) validateBucketName(formats strfmt.Registry) error {

	if err := validate.Required("bucketName", "body", m.BucketName); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ExportImage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ExportImage) UnmarshalBinary(b []byte) error {
	var res ExportImage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
