package containerregistryapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/containerregistry/mgmt/2016-06-27-preview/containerregistry"
	"github.com/Azure/go-autorest/autorest"
)

// RegistriesClientAPI contains the set of methods on the RegistriesClient type.
type RegistriesClientAPI interface {
	CheckNameAvailability(ctx context.Context, registryNameCheckRequest containerregistry.RegistryNameCheckRequest) (result containerregistry.RegistryNameStatus, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, registryName string, registry containerregistry.Registry) (result containerregistry.Registry, err error)
	Delete(ctx context.Context, resourceGroupName string, registryName string) (result autorest.Response, err error)
	GetCredentials(ctx context.Context, resourceGroupName string, registryName string) (result containerregistry.RegistryCredentials, err error)
	GetProperties(ctx context.Context, resourceGroupName string, registryName string) (result containerregistry.Registry, err error)
	List(ctx context.Context) (result containerregistry.RegistryListResultPage, err error)
	ListComplete(ctx context.Context) (result containerregistry.RegistryListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result containerregistry.RegistryListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result containerregistry.RegistryListResultIterator, err error)
	RegenerateCredentials(ctx context.Context, resourceGroupName string, registryName string) (result containerregistry.RegistryCredentials, err error)
	Update(ctx context.Context, resourceGroupName string, registryName string, registryUpdateParameters containerregistry.RegistryUpdateParameters) (result containerregistry.Registry, err error)
}

var _ RegistriesClientAPI = (*containerregistry.RegistriesClient)(nil)
