/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.prestosql.security;

import org.testng.annotations.Test;

import static io.prestosql.spi.testing.InterfaceTestUtils.assertAllMethodsOverridden;
import static io.prestosql.spi.testing.InterfaceTestUtils.assertProperForwardingMethodsAreCalled;

public class TestForwardingAccessControl
{
    @Test
    public void testEverythingImplemented()
    {
        assertAllMethodsOverridden(AccessControl.class, ForwardingAccessControl.class);
    }

    @Test
    public void testProperForwardingMethodsAreCalled()
    {
        assertProperForwardingMethodsAreCalled(AccessControl.class, accessControl -> ForwardingAccessControl.of(() -> accessControl));
    }
}
