// DO NOT EDIT: This file is autogenerated via the builtin command.

package date

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 103,
					Line:   40,
				},
				File:   "hour_duration_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"\n\nt_duration_hour = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.hour(t: duration(v : r._value))})))\n\ntest _duration_hour = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_hour})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "hour_duration_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "hour_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "hour_duration_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "hour_duration_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "hour_duration_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "hour_duration_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   19,
					},
					File:   "hour_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "hour_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   19,
						},
						File:   "hour_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "hour_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "hour_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "hour_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 78,
						Line:   37,
					},
					File:   "hour_duration_test.flux",
					Source: "t_duration_hour = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.hour(t: duration(v : r._value))})))",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   34,
						},
						File:   "hour_duration_test.flux",
						Source: "t_duration_hour",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "t_duration_hour",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 78,
							Line:   37,
						},
						File:   "hour_duration_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.hour(t: duration(v : r._value))})))",
						Start: ast.Position{
							Column: 19,
							Line:   34,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 78,
								Line:   37,
							},
							File:   "hour_duration_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.hour(t: duration(v : r._value))})))",
							Start: ast.Position{
								Column: 2,
								Line:   35,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   35,
										},
										File:   "hour_duration_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   35,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   36,
									},
									File:   "hour_duration_test.flux",
									Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   35,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   36,
											},
											File:   "hour_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   36,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   36,
												},
												File:   "hour_duration_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   36,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   36,
													},
													File:   "hour_duration_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   36,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   36,
													},
													File:   "hour_duration_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   36,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   36,
										},
										File:   "hour_duration_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   36,
											},
											File:   "hour_duration_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   36,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 77,
									Line:   37,
								},
								File:   "hour_duration_test.flux",
								Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.hour(t: duration(v : r._value))}))",
								Start: ast.Position{
									Column: 3,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 76,
											Line:   37,
										},
										File:   "hour_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.hour(t: duration(v : r._value))})",
										Start: ast.Position{
											Column: 10,
											Line:   37,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   37,
											},
											File:   "hour_duration_test.flux",
											Source: "fn: (r) => ({r with _value: date.hour(t: duration(v : r._value))})",
											Start: ast.Position{
												Column: 10,
												Line:   37,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   37,
												},
												File:   "hour_duration_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   37,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 76,
													Line:   37,
												},
												File:   "hour_duration_test.flux",
												Source: "(r) => ({r with _value: date.hour(t: duration(v : r._value))})",
												Start: ast.Position{
													Column: 14,
													Line:   37,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 76,
														Line:   37,
													},
													File:   "hour_duration_test.flux",
													Source: "({r with _value: date.hour(t: duration(v : r._value))})",
													Start: ast.Position{
														Column: 21,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 75,
															Line:   37,
														},
														File:   "hour_duration_test.flux",
														Source: "{r with _value: date.hour(t: duration(v : r._value))}",
														Start: ast.Position{
															Column: 22,
															Line:   37,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 74,
																Line:   37,
															},
															File:   "hour_duration_test.flux",
															Source: "_value: date.hour(t: duration(v : r._value))",
															Start: ast.Position{
																Column: 30,
																Line:   37,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   37,
																},
																File:   "hour_duration_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 73,
																		Line:   37,
																	},
																	File:   "hour_duration_test.flux",
																	Source: "t: duration(v : r._value)",
																	Start: ast.Position{
																		Column: 48,
																		Line:   37,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 73,
																			Line:   37,
																		},
																		File:   "hour_duration_test.flux",
																		Source: "t: duration(v : r._value)",
																		Start: ast.Position{
																			Column: 48,
																			Line:   37,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 49,
																				Line:   37,
																			},
																			File:   "hour_duration_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 48,
																				Line:   37,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 72,
																					Line:   37,
																				},
																				File:   "hour_duration_test.flux",
																				Source: "v : r._value",
																				Start: ast.Position{
																					Column: 60,
																					Line:   37,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 72,
																						Line:   37,
																					},
																					File:   "hour_duration_test.flux",
																					Source: "v : r._value",
																					Start: ast.Position{
																						Column: 60,
																						Line:   37,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 61,
																							Line:   37,
																						},
																						File:   "hour_duration_test.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 60,
																							Line:   37,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Separator: nil,
																			Value: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 72,
																							Line:   37,
																						},
																						File:   "hour_duration_test.flux",
																						Source: "r._value",
																						Start: ast.Position{
																							Column: 64,
																							Line:   37,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 65,
																								Line:   37,
																							},
																							File:   "hour_duration_test.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 64,
																								Line:   37,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 72,
																								Line:   37,
																							},
																							File:   "hour_duration_test.flux",
																							Source: "_value",
																							Start: ast.Position{
																								Column: 66,
																								Line:   37,
																							},
																						},
																					},
																					Name: "_value",
																				},
																				Rbrack: nil,
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 73,
																				Line:   37,
																			},
																			File:   "hour_duration_test.flux",
																			Source: "duration(v : r._value)",
																			Start: ast.Position{
																				Column: 51,
																				Line:   37,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 59,
																					Line:   37,
																				},
																				File:   "hour_duration_test.flux",
																				Source: "duration",
																				Start: ast.Position{
																					Column: 51,
																					Line:   37,
																				},
																			},
																		},
																		Name: "duration",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 74,
																	Line:   37,
																},
																File:   "hour_duration_test.flux",
																Source: "date.hour(t: duration(v : r._value))",
																Start: ast.Position{
																	Column: 38,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   37,
																	},
																	File:   "hour_duration_test.flux",
																	Source: "date.hour",
																	Start: ast.Position{
																		Column: 38,
																		Line:   37,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   37,
																		},
																		File:   "hour_duration_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   37,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 47,
																			Line:   37,
																		},
																		File:   "hour_duration_test.flux",
																		Source: "hour",
																		Start: ast.Position{
																			Column: 43,
																			Line:   37,
																		},
																	},
																},
																Name: "hour",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   37,
															},
															File:   "hour_duration_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   37,
													},
													File:   "hour_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   37,
														},
														File:   "hour_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   37,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 77,
										Line:   37,
									},
									File:   "hour_duration_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.hour(t: duration(v : r._value))}))",
									Start: ast.Position{
										Column: 6,
										Line:   37,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   37,
										},
										File:   "hour_duration_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   37,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   34,
							},
							File:   "hour_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 20,
								Line:   34,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   34,
								},
								File:   "hour_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 20,
									Line:   34,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   34,
							},
							File:   "hour_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 26,
								Line:   34,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 103,
							Line:   40,
						},
						File:   "hour_duration_test.flux",
						Source: "_duration_hour = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_hour})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   39,
							},
							File:   "hour_duration_test.flux",
							Source: "_duration_hour",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_duration_hour",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 103,
								Line:   40,
							},
							File:   "hour_duration_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_hour})",
							Start: ast.Position{
								Column: 23,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 103,
									Line:   40,
								},
								File:   "hour_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_hour})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 102,
										Line:   40,
									},
									File:   "hour_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_hour}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "hour_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "hour_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   40,
												},
												File:   "hour_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   40,
													},
													File:   "hour_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   40,
														},
														File:   "hour_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   40,
														},
														File:   "hour_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "hour_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   40,
												},
												File:   "hour_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   40,
													},
													File:   "hour_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   40,
													},
													File:   "hour_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "hour_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "hour_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   40,
												},
												File:   "hour_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   40,
													},
													File:   "hour_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   40,
														},
														File:   "hour_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   40,
														},
														File:   "hour_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "hour_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   40,
												},
												File:   "hour_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   40,
													},
													File:   "hour_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   40,
													},
													File:   "hour_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 101,
											Line:   40,
										},
										File:   "hour_duration_test.flux",
										Source: "fn: t_duration_hour",
										Start: ast.Position{
											Column: 82,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   40,
											},
											File:   "hour_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 101,
												Line:   40,
											},
											File:   "hour_duration_test.flux",
											Source: "t_duration_hour",
											Start: ast.Position{
												Column: 86,
												Line:   40,
											},
										},
									},
									Name: "t_duration_hour",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 103,
						Line:   40,
					},
					File:   "hour_duration_test.flux",
					Source: "test _duration_hour = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_hour})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "hour_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "hour_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "hour_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "hour_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "hour_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "hour_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "hour_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 99,
					Line:   76,
				},
				File:   "hour_time_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T00:53:00Z,_m,FF,1\n,,0,2018-05-22T01:53:00Z,_m,FF,1\n,,0,2018-05-22T02:53:10Z,_m,FF,1\n,,0,2018-05-22T03:53:20Z,_m,FF,1\n,,0,2018-05-22T04:53:30Z,_m,FF,1\n,,0,2018-05-22T05:53:40Z,_m,FF,1\n,,0,2018-05-22T06:53:50Z,_m,FF,1\n,,1,2018-05-22T07:53:00Z,_m,QQ,1\n,,1,2018-05-22T08:53:10Z,_m,QQ,1\n,,1,2018-05-22T09:53:20Z,_m,QQ,1\n,,1,2018-05-22T10:53:30Z,_m,QQ,1\n,,1,2018-05-22T11:53:40Z,_m,QQ,1\n,,1,2018-05-22T12:53:50Z,_m,QQ,1\n,,1,2018-05-22T13:54:00Z,_m,QQ,1\n,,1,2018-05-22T14:54:10Z,_m,QQ,1\n,,1,2018-05-22T15:54:20Z,_m,QQ,1\n,,2,2018-05-22T16:53:00Z,_m,RR,1\n,,2,2018-05-22T17:53:10Z,_m,RR,1\n,,2,2018-05-22T18:53:20Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,3,2018-05-22T20:53:40Z,_m,SR,1\n,,3,2018-05-22T21:53:50Z,_m,SR,1\n,,3,2018-05-22T22:53:00Z,_m,SR,1\n,,3,2018-05-22T23:53:50Z,_m,SR,1\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T00:53:00Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T01:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T02:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T03:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T04:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T05:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T06:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T07:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T08:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T09:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T10:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T11:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T12:53:50Z,12\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T13:54:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T14:54:10Z,14\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T15:54:20Z,15\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T16:53:00Z,16\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T17:53:10Z,17\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T18:53:20Z,18\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:30Z,19\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T20:53:40Z,20\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T21:53:50Z,21\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T22:53:00Z,22\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T23:53:50Z,23\n\"\n\nt_time_hour = (table=<-) =>\n\t(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.hour(t: r._time)})))\n\ntest _time_hour = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_hour})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "hour_time_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "hour_time_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "hour_time_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "hour_time_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "hour_time_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "hour_time_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   37,
					},
					File:   "hour_time_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T00:53:00Z,_m,FF,1\n,,0,2018-05-22T01:53:00Z,_m,FF,1\n,,0,2018-05-22T02:53:10Z,_m,FF,1\n,,0,2018-05-22T03:53:20Z,_m,FF,1\n,,0,2018-05-22T04:53:30Z,_m,FF,1\n,,0,2018-05-22T05:53:40Z,_m,FF,1\n,,0,2018-05-22T06:53:50Z,_m,FF,1\n,,1,2018-05-22T07:53:00Z,_m,QQ,1\n,,1,2018-05-22T08:53:10Z,_m,QQ,1\n,,1,2018-05-22T09:53:20Z,_m,QQ,1\n,,1,2018-05-22T10:53:30Z,_m,QQ,1\n,,1,2018-05-22T11:53:40Z,_m,QQ,1\n,,1,2018-05-22T12:53:50Z,_m,QQ,1\n,,1,2018-05-22T13:54:00Z,_m,QQ,1\n,,1,2018-05-22T14:54:10Z,_m,QQ,1\n,,1,2018-05-22T15:54:20Z,_m,QQ,1\n,,2,2018-05-22T16:53:00Z,_m,RR,1\n,,2,2018-05-22T17:53:10Z,_m,RR,1\n,,2,2018-05-22T18:53:20Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,3,2018-05-22T20:53:40Z,_m,SR,1\n,,3,2018-05-22T21:53:50Z,_m,SR,1\n,,3,2018-05-22T22:53:00Z,_m,SR,1\n,,3,2018-05-22T23:53:50Z,_m,SR,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "hour_time_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   37,
						},
						File:   "hour_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T00:53:00Z,_m,FF,1\n,,0,2018-05-22T01:53:00Z,_m,FF,1\n,,0,2018-05-22T02:53:10Z,_m,FF,1\n,,0,2018-05-22T03:53:20Z,_m,FF,1\n,,0,2018-05-22T04:53:30Z,_m,FF,1\n,,0,2018-05-22T05:53:40Z,_m,FF,1\n,,0,2018-05-22T06:53:50Z,_m,FF,1\n,,1,2018-05-22T07:53:00Z,_m,QQ,1\n,,1,2018-05-22T08:53:10Z,_m,QQ,1\n,,1,2018-05-22T09:53:20Z,_m,QQ,1\n,,1,2018-05-22T10:53:30Z,_m,QQ,1\n,,1,2018-05-22T11:53:40Z,_m,QQ,1\n,,1,2018-05-22T12:53:50Z,_m,QQ,1\n,,1,2018-05-22T13:54:00Z,_m,QQ,1\n,,1,2018-05-22T14:54:10Z,_m,QQ,1\n,,1,2018-05-22T15:54:20Z,_m,QQ,1\n,,2,2018-05-22T16:53:00Z,_m,RR,1\n,,2,2018-05-22T17:53:10Z,_m,RR,1\n,,2,2018-05-22T18:53:20Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,3,2018-05-22T20:53:40Z,_m,SR,1\n,,3,2018-05-22T21:53:50Z,_m,SR,1\n,,3,2018-05-22T22:53:00Z,_m,SR,1\n,,3,2018-05-22T23:53:50Z,_m,SR,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T00:53:00Z,_m,FF,1\n,,0,2018-05-22T01:53:00Z,_m,FF,1\n,,0,2018-05-22T02:53:10Z,_m,FF,1\n,,0,2018-05-22T03:53:20Z,_m,FF,1\n,,0,2018-05-22T04:53:30Z,_m,FF,1\n,,0,2018-05-22T05:53:40Z,_m,FF,1\n,,0,2018-05-22T06:53:50Z,_m,FF,1\n,,1,2018-05-22T07:53:00Z,_m,QQ,1\n,,1,2018-05-22T08:53:10Z,_m,QQ,1\n,,1,2018-05-22T09:53:20Z,_m,QQ,1\n,,1,2018-05-22T10:53:30Z,_m,QQ,1\n,,1,2018-05-22T11:53:40Z,_m,QQ,1\n,,1,2018-05-22T12:53:50Z,_m,QQ,1\n,,1,2018-05-22T13:54:00Z,_m,QQ,1\n,,1,2018-05-22T14:54:10Z,_m,QQ,1\n,,1,2018-05-22T15:54:20Z,_m,QQ,1\n,,2,2018-05-22T16:53:00Z,_m,RR,1\n,,2,2018-05-22T17:53:10Z,_m,RR,1\n,,2,2018-05-22T18:53:20Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,3,2018-05-22T20:53:40Z,_m,SR,1\n,,3,2018-05-22T21:53:50Z,_m,SR,1\n,,3,2018-05-22T22:53:00Z,_m,SR,1\n,,3,2018-05-22T23:53:50Z,_m,SR,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   68,
					},
					File:   "hour_time_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T00:53:00Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T01:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T02:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T03:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T04:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T05:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T06:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T07:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T08:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T09:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T10:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T11:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T12:53:50Z,12\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T13:54:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T14:54:10Z,14\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T15:54:20Z,15\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T16:53:00Z,16\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T17:53:10Z,17\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T18:53:20Z,18\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:30Z,19\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T20:53:40Z,20\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T21:53:50Z,21\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T22:53:00Z,22\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T23:53:50Z,23\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   39,
						},
						File:   "hour_time_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   39,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   68,
						},
						File:   "hour_time_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T00:53:00Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T01:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T02:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T03:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T04:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T05:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T06:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T07:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T08:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T09:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T10:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T11:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T12:53:50Z,12\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T13:54:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T14:54:10Z,14\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T15:54:20Z,15\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T16:53:00Z,16\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T17:53:10Z,17\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T18:53:20Z,18\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:30Z,19\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T20:53:40Z,20\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T21:53:50Z,21\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T22:53:00Z,22\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T23:53:50Z,23\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   39,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T00:53:00Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T01:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T02:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T03:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T04:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T05:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T06:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T07:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T08:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T09:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T10:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T11:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T12:53:50Z,12\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T13:54:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T14:54:10Z,14\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T15:54:20Z,15\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T16:53:00Z,16\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T17:53:10Z,17\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T18:53:20Z,18\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:30Z,19\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T20:53:40Z,20\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T21:53:50Z,21\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T22:53:00Z,22\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T23:53:50Z,23\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 63,
						Line:   73,
					},
					File:   "hour_time_test.flux",
					Source: "t_time_hour = (table=<-) =>\n\t(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.hour(t: r._time)})))",
					Start: ast.Position{
						Column: 1,
						Line:   70,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   70,
						},
						File:   "hour_time_test.flux",
						Source: "t_time_hour",
						Start: ast.Position{
							Column: 1,
							Line:   70,
						},
					},
				},
				Name: "t_time_hour",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 63,
							Line:   73,
						},
						File:   "hour_time_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.hour(t: r._time)})))",
						Start: ast.Position{
							Column: 15,
							Line:   70,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 63,
								Line:   73,
							},
							File:   "hour_time_test.flux",
							Source: "(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.hour(t: r._time)})))",
							Start: ast.Position{
								Column: 2,
								Line:   71,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   71,
										},
										File:   "hour_time_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   71,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   72,
									},
									File:   "hour_time_test.flux",
									Source: "table\n\t    |> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   71,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   72,
											},
											File:   "hour_time_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 15,
												Line:   72,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   72,
												},
												File:   "hour_time_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 15,
													Line:   72,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   72,
													},
													File:   "hour_time_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 15,
														Line:   72,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   72,
													},
													File:   "hour_time_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 22,
														Line:   72,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   72,
										},
										File:   "hour_time_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 9,
											Line:   72,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   72,
											},
											File:   "hour_time_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 9,
												Line:   72,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   73,
								},
								File:   "hour_time_test.flux",
								Source: "table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.hour(t: r._time)}))",
								Start: ast.Position{
									Column: 3,
									Line:   71,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   73,
										},
										File:   "hour_time_test.flux",
										Source: "fn: (r) => ({r with _value: date.hour(t: r._time)})",
										Start: ast.Position{
											Column: 10,
											Line:   73,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   73,
											},
											File:   "hour_time_test.flux",
											Source: "fn: (r) => ({r with _value: date.hour(t: r._time)})",
											Start: ast.Position{
												Column: 10,
												Line:   73,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   73,
												},
												File:   "hour_time_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   73,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   73,
												},
												File:   "hour_time_test.flux",
												Source: "(r) => ({r with _value: date.hour(t: r._time)})",
												Start: ast.Position{
													Column: 14,
													Line:   73,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   73,
													},
													File:   "hour_time_test.flux",
													Source: "({r with _value: date.hour(t: r._time)})",
													Start: ast.Position{
														Column: 21,
														Line:   73,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   73,
														},
														File:   "hour_time_test.flux",
														Source: "{r with _value: date.hour(t: r._time)}",
														Start: ast.Position{
															Column: 22,
															Line:   73,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 59,
																Line:   73,
															},
															File:   "hour_time_test.flux",
															Source: "_value: date.hour(t: r._time)",
															Start: ast.Position{
																Column: 30,
																Line:   73,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   73,
																},
																File:   "hour_time_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   73,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 58,
																		Line:   73,
																	},
																	File:   "hour_time_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 48,
																		Line:   73,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   73,
																		},
																		File:   "hour_time_test.flux",
																		Source: "t: r._time",
																		Start: ast.Position{
																			Column: 48,
																			Line:   73,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 49,
																				Line:   73,
																			},
																			File:   "hour_time_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 48,
																				Line:   73,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 58,
																				Line:   73,
																			},
																			File:   "hour_time_test.flux",
																			Source: "r._time",
																			Start: ast.Position{
																				Column: 51,
																				Line:   73,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 52,
																					Line:   73,
																				},
																				File:   "hour_time_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 51,
																					Line:   73,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 58,
																					Line:   73,
																				},
																				File:   "hour_time_test.flux",
																				Source: "_time",
																				Start: ast.Position{
																					Column: 53,
																					Line:   73,
																				},
																			},
																		},
																		Name: "_time",
																	},
																	Rbrack: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 59,
																	Line:   73,
																},
																File:   "hour_time_test.flux",
																Source: "date.hour(t: r._time)",
																Start: ast.Position{
																	Column: 38,
																	Line:   73,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   73,
																	},
																	File:   "hour_time_test.flux",
																	Source: "date.hour",
																	Start: ast.Position{
																		Column: 38,
																		Line:   73,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   73,
																		},
																		File:   "hour_time_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   73,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 47,
																			Line:   73,
																		},
																		File:   "hour_time_test.flux",
																		Source: "hour",
																		Start: ast.Position{
																			Column: 43,
																			Line:   73,
																		},
																	},
																},
																Name: "hour",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   73,
															},
															File:   "hour_time_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   73,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   73,
													},
													File:   "hour_time_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   73,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   73,
														},
														File:   "hour_time_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   73,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   73,
									},
									File:   "hour_time_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.hour(t: r._time)}))",
									Start: ast.Position{
										Column: 6,
										Line:   73,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   73,
										},
										File:   "hour_time_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   73,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   70,
							},
							File:   "hour_time_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 16,
								Line:   70,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   70,
								},
								File:   "hour_time_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 16,
									Line:   70,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   70,
							},
							File:   "hour_time_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   70,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 99,
							Line:   76,
						},
						File:   "hour_time_test.flux",
						Source: "_time_hour = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_hour})",
						Start: ast.Position{
							Column: 6,
							Line:   75,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   75,
							},
							File:   "hour_time_test.flux",
							Source: "_time_hour",
							Start: ast.Position{
								Column: 6,
								Line:   75,
							},
						},
					},
					Name: "_time_hour",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   76,
							},
							File:   "hour_time_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_hour})",
							Start: ast.Position{
								Column: 19,
								Line:   75,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   76,
								},
								File:   "hour_time_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_hour})",
								Start: ast.Position{
									Column: 2,
									Line:   76,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 98,
										Line:   76,
									},
									File:   "hour_time_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_hour}",
									Start: ast.Position{
										Column: 3,
										Line:   76,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   76,
										},
										File:   "hour_time_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   76,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   76,
											},
											File:   "hour_time_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   76,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   76,
												},
												File:   "hour_time_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   76,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   76,
													},
													File:   "hour_time_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   76,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   76,
														},
														File:   "hour_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   76,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   76,
														},
														File:   "hour_time_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   76,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   76,
											},
											File:   "hour_time_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   76,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   76,
												},
												File:   "hour_time_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   76,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   76,
													},
													File:   "hour_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   76,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   76,
													},
													File:   "hour_time_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   76,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   76,
										},
										File:   "hour_time_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   76,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   76,
											},
											File:   "hour_time_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   76,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   76,
												},
												File:   "hour_time_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   76,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   76,
													},
													File:   "hour_time_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   76,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   76,
														},
														File:   "hour_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   76,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   76,
														},
														File:   "hour_time_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   76,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   76,
											},
											File:   "hour_time_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   76,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   76,
												},
												File:   "hour_time_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   76,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   76,
													},
													File:   "hour_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   76,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   76,
													},
													File:   "hour_time_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   76,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 97,
											Line:   76,
										},
										File:   "hour_time_test.flux",
										Source: "fn: t_time_hour",
										Start: ast.Position{
											Column: 82,
											Line:   76,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   76,
											},
											File:   "hour_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   76,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 97,
												Line:   76,
											},
											File:   "hour_time_test.flux",
											Source: "t_time_hour",
											Start: ast.Position{
												Column: 86,
												Line:   76,
											},
										},
									},
									Name: "t_time_hour",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 99,
						Line:   76,
					},
					File:   "hour_time_test.flux",
					Source: "test _time_hour = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_hour})",
					Start: ast.Position{
						Column: 1,
						Line:   75,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "hour_time_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "hour_time_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "hour_time_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "hour_time_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "hour_time_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "hour_time_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "hour_time_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 110,
					Line:   40,
				},
				File:   "microsecond_duration_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"\n\nt_duration_microsecond = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.microsecond(t: duration(v : r._value))})))\n\ntest _duration_microsecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_microsecond})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "microsecond_duration_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "microsecond_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "microsecond_duration_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "microsecond_duration_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "microsecond_duration_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "microsecond_duration_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   19,
					},
					File:   "microsecond_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "microsecond_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   19,
						},
						File:   "microsecond_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "microsecond_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "microsecond_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "microsecond_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 85,
						Line:   37,
					},
					File:   "microsecond_duration_test.flux",
					Source: "t_duration_microsecond = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.microsecond(t: duration(v : r._value))})))",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 23,
							Line:   34,
						},
						File:   "microsecond_duration_test.flux",
						Source: "t_duration_microsecond",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "t_duration_microsecond",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 85,
							Line:   37,
						},
						File:   "microsecond_duration_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.microsecond(t: duration(v : r._value))})))",
						Start: ast.Position{
							Column: 26,
							Line:   34,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 85,
								Line:   37,
							},
							File:   "microsecond_duration_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.microsecond(t: duration(v : r._value))})))",
							Start: ast.Position{
								Column: 2,
								Line:   35,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   35,
										},
										File:   "microsecond_duration_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   35,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   36,
									},
									File:   "microsecond_duration_test.flux",
									Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   35,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   36,
											},
											File:   "microsecond_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   36,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   36,
												},
												File:   "microsecond_duration_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   36,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   36,
													},
													File:   "microsecond_duration_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   36,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   36,
													},
													File:   "microsecond_duration_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   36,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   36,
										},
										File:   "microsecond_duration_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   36,
											},
											File:   "microsecond_duration_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   36,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   37,
								},
								File:   "microsecond_duration_test.flux",
								Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.microsecond(t: duration(v : r._value))}))",
								Start: ast.Position{
									Column: 3,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 83,
											Line:   37,
										},
										File:   "microsecond_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.microsecond(t: duration(v : r._value))})",
										Start: ast.Position{
											Column: 10,
											Line:   37,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 83,
												Line:   37,
											},
											File:   "microsecond_duration_test.flux",
											Source: "fn: (r) => ({r with _value: date.microsecond(t: duration(v : r._value))})",
											Start: ast.Position{
												Column: 10,
												Line:   37,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   37,
												},
												File:   "microsecond_duration_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   37,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 83,
													Line:   37,
												},
												File:   "microsecond_duration_test.flux",
												Source: "(r) => ({r with _value: date.microsecond(t: duration(v : r._value))})",
												Start: ast.Position{
													Column: 14,
													Line:   37,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 83,
														Line:   37,
													},
													File:   "microsecond_duration_test.flux",
													Source: "({r with _value: date.microsecond(t: duration(v : r._value))})",
													Start: ast.Position{
														Column: 21,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   37,
														},
														File:   "microsecond_duration_test.flux",
														Source: "{r with _value: date.microsecond(t: duration(v : r._value))}",
														Start: ast.Position{
															Column: 22,
															Line:   37,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 81,
																Line:   37,
															},
															File:   "microsecond_duration_test.flux",
															Source: "_value: date.microsecond(t: duration(v : r._value))",
															Start: ast.Position{
																Column: 30,
																Line:   37,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   37,
																},
																File:   "microsecond_duration_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 80,
																		Line:   37,
																	},
																	File:   "microsecond_duration_test.flux",
																	Source: "t: duration(v : r._value)",
																	Start: ast.Position{
																		Column: 55,
																		Line:   37,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 80,
																			Line:   37,
																		},
																		File:   "microsecond_duration_test.flux",
																		Source: "t: duration(v : r._value)",
																		Start: ast.Position{
																			Column: 55,
																			Line:   37,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   37,
																			},
																			File:   "microsecond_duration_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 55,
																				Line:   37,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 79,
																					Line:   37,
																				},
																				File:   "microsecond_duration_test.flux",
																				Source: "v : r._value",
																				Start: ast.Position{
																					Column: 67,
																					Line:   37,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 79,
																						Line:   37,
																					},
																					File:   "microsecond_duration_test.flux",
																					Source: "v : r._value",
																					Start: ast.Position{
																						Column: 67,
																						Line:   37,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 68,
																							Line:   37,
																						},
																						File:   "microsecond_duration_test.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 67,
																							Line:   37,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Separator: nil,
																			Value: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 79,
																							Line:   37,
																						},
																						File:   "microsecond_duration_test.flux",
																						Source: "r._value",
																						Start: ast.Position{
																							Column: 71,
																							Line:   37,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 72,
																								Line:   37,
																							},
																							File:   "microsecond_duration_test.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 71,
																								Line:   37,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 79,
																								Line:   37,
																							},
																							File:   "microsecond_duration_test.flux",
																							Source: "_value",
																							Start: ast.Position{
																								Column: 73,
																								Line:   37,
																							},
																						},
																					},
																					Name: "_value",
																				},
																				Rbrack: nil,
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 80,
																				Line:   37,
																			},
																			File:   "microsecond_duration_test.flux",
																			Source: "duration(v : r._value)",
																			Start: ast.Position{
																				Column: 58,
																				Line:   37,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 66,
																					Line:   37,
																				},
																				File:   "microsecond_duration_test.flux",
																				Source: "duration",
																				Start: ast.Position{
																					Column: 58,
																					Line:   37,
																				},
																			},
																		},
																		Name: "duration",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 81,
																	Line:   37,
																},
																File:   "microsecond_duration_test.flux",
																Source: "date.microsecond(t: duration(v : r._value))",
																Start: ast.Position{
																	Column: 38,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 54,
																		Line:   37,
																	},
																	File:   "microsecond_duration_test.flux",
																	Source: "date.microsecond",
																	Start: ast.Position{
																		Column: 38,
																		Line:   37,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   37,
																		},
																		File:   "microsecond_duration_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   37,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 54,
																			Line:   37,
																		},
																		File:   "microsecond_duration_test.flux",
																		Source: "microsecond",
																		Start: ast.Position{
																			Column: 43,
																			Line:   37,
																		},
																	},
																},
																Name: "microsecond",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   37,
															},
															File:   "microsecond_duration_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   37,
													},
													File:   "microsecond_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   37,
														},
														File:   "microsecond_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   37,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   37,
									},
									File:   "microsecond_duration_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.microsecond(t: duration(v : r._value))}))",
									Start: ast.Position{
										Column: 6,
										Line:   37,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   37,
										},
										File:   "microsecond_duration_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   37,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   34,
							},
							File:   "microsecond_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 27,
								Line:   34,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   34,
								},
								File:   "microsecond_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 27,
									Line:   34,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   34,
							},
							File:   "microsecond_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 33,
								Line:   34,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 110,
							Line:   40,
						},
						File:   "microsecond_duration_test.flux",
						Source: "_duration_microsecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_microsecond})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   39,
							},
							File:   "microsecond_duration_test.flux",
							Source: "_duration_microsecond",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_duration_microsecond",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 110,
								Line:   40,
							},
							File:   "microsecond_duration_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_microsecond})",
							Start: ast.Position{
								Column: 30,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 110,
									Line:   40,
								},
								File:   "microsecond_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_microsecond})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 109,
										Line:   40,
									},
									File:   "microsecond_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_microsecond}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "microsecond_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "microsecond_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   40,
												},
												File:   "microsecond_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   40,
													},
													File:   "microsecond_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   40,
														},
														File:   "microsecond_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   40,
														},
														File:   "microsecond_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "microsecond_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   40,
												},
												File:   "microsecond_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   40,
													},
													File:   "microsecond_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   40,
													},
													File:   "microsecond_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "microsecond_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "microsecond_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   40,
												},
												File:   "microsecond_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   40,
													},
													File:   "microsecond_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   40,
														},
														File:   "microsecond_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   40,
														},
														File:   "microsecond_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "microsecond_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   40,
												},
												File:   "microsecond_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   40,
													},
													File:   "microsecond_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   40,
													},
													File:   "microsecond_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 108,
											Line:   40,
										},
										File:   "microsecond_duration_test.flux",
										Source: "fn: t_duration_microsecond",
										Start: ast.Position{
											Column: 82,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   40,
											},
											File:   "microsecond_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   40,
											},
											File:   "microsecond_duration_test.flux",
											Source: "t_duration_microsecond",
											Start: ast.Position{
												Column: 86,
												Line:   40,
											},
										},
									},
									Name: "t_duration_microsecond",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 110,
						Line:   40,
					},
					File:   "microsecond_duration_test.flux",
					Source: "test _duration_microsecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_microsecond})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "microsecond_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "microsecond_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "microsecond_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "microsecond_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "microsecond_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "microsecond_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "microsecond_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 106,
					Line:   58,
				},
				File:   "microsecond_time_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254819\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748691\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947182\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538816\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676423\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982342\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819823\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587284\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984375\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723847\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192983\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712938\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062103\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786432\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823748\n\"\n\nt_time_microsecond = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.microsecond(t: r._time)})))\n\ntest _time_microsecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_microsecond})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "microsecond_time_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "microsecond_time_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "microsecond_time_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "microsecond_time_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "microsecond_time_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "microsecond_time_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   28,
					},
					File:   "microsecond_time_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "microsecond_time_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   28,
						},
						File:   "microsecond_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   50,
					},
					File:   "microsecond_time_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254819\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748691\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947182\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538816\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676423\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982342\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819823\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587284\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984375\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723847\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192983\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712938\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062103\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786432\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823748\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   30,
						},
						File:   "microsecond_time_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   50,
						},
						File:   "microsecond_time_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254819\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748691\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947182\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538816\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676423\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982342\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819823\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587284\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984375\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723847\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192983\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712938\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062103\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786432\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823748\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   30,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254819\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748691\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947182\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538816\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676423\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982342\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819823\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587284\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984375\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723847\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192983\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712938\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062103\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786432\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823748\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 70,
						Line:   55,
					},
					File:   "microsecond_time_test.flux",
					Source: "t_time_microsecond = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.microsecond(t: r._time)})))",
					Start: ast.Position{
						Column: 1,
						Line:   52,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   52,
						},
						File:   "microsecond_time_test.flux",
						Source: "t_time_microsecond",
						Start: ast.Position{
							Column: 1,
							Line:   52,
						},
					},
				},
				Name: "t_time_microsecond",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   55,
						},
						File:   "microsecond_time_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.microsecond(t: r._time)})))",
						Start: ast.Position{
							Column: 22,
							Line:   52,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   55,
							},
							File:   "microsecond_time_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.microsecond(t: r._time)})))",
							Start: ast.Position{
								Column: 2,
								Line:   53,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   53,
										},
										File:   "microsecond_time_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   53,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   54,
									},
									File:   "microsecond_time_test.flux",
									Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   53,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   54,
											},
											File:   "microsecond_time_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   54,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   54,
												},
												File:   "microsecond_time_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   54,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   54,
													},
													File:   "microsecond_time_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   54,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   54,
													},
													File:   "microsecond_time_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   54,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   54,
										},
										File:   "microsecond_time_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   54,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   54,
											},
											File:   "microsecond_time_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   54,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   55,
								},
								File:   "microsecond_time_test.flux",
								Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.microsecond(t: r._time)}))",
								Start: ast.Position{
									Column: 3,
									Line:   53,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   55,
										},
										File:   "microsecond_time_test.flux",
										Source: "fn: (r) => ({r with _value: date.microsecond(t: r._time)})",
										Start: ast.Position{
											Column: 10,
											Line:   55,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   55,
											},
											File:   "microsecond_time_test.flux",
											Source: "fn: (r) => ({r with _value: date.microsecond(t: r._time)})",
											Start: ast.Position{
												Column: 10,
												Line:   55,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   55,
												},
												File:   "microsecond_time_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   55,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   55,
												},
												File:   "microsecond_time_test.flux",
												Source: "(r) => ({r with _value: date.microsecond(t: r._time)})",
												Start: ast.Position{
													Column: 14,
													Line:   55,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   55,
													},
													File:   "microsecond_time_test.flux",
													Source: "({r with _value: date.microsecond(t: r._time)})",
													Start: ast.Position{
														Column: 21,
														Line:   55,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 67,
															Line:   55,
														},
														File:   "microsecond_time_test.flux",
														Source: "{r with _value: date.microsecond(t: r._time)}",
														Start: ast.Position{
															Column: 22,
															Line:   55,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 66,
																Line:   55,
															},
															File:   "microsecond_time_test.flux",
															Source: "_value: date.microsecond(t: r._time)",
															Start: ast.Position{
																Column: 30,
																Line:   55,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   55,
																},
																File:   "microsecond_time_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   55,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 65,
																		Line:   55,
																	},
																	File:   "microsecond_time_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 55,
																		Line:   55,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 65,
																			Line:   55,
																		},
																		File:   "microsecond_time_test.flux",
																		Source: "t: r._time",
																		Start: ast.Position{
																			Column: 55,
																			Line:   55,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   55,
																			},
																			File:   "microsecond_time_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 55,
																				Line:   55,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 65,
																				Line:   55,
																			},
																			File:   "microsecond_time_test.flux",
																			Source: "r._time",
																			Start: ast.Position{
																				Column: 58,
																				Line:   55,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 59,
																					Line:   55,
																				},
																				File:   "microsecond_time_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 58,
																					Line:   55,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 65,
																					Line:   55,
																				},
																				File:   "microsecond_time_test.flux",
																				Source: "_time",
																				Start: ast.Position{
																					Column: 60,
																					Line:   55,
																				},
																			},
																		},
																		Name: "_time",
																	},
																	Rbrack: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 66,
																	Line:   55,
																},
																File:   "microsecond_time_test.flux",
																Source: "date.microsecond(t: r._time)",
																Start: ast.Position{
																	Column: 38,
																	Line:   55,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 54,
																		Line:   55,
																	},
																	File:   "microsecond_time_test.flux",
																	Source: "date.microsecond",
																	Start: ast.Position{
																		Column: 38,
																		Line:   55,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   55,
																		},
																		File:   "microsecond_time_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   55,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 54,
																			Line:   55,
																		},
																		File:   "microsecond_time_test.flux",
																		Source: "microsecond",
																		Start: ast.Position{
																			Column: 43,
																			Line:   55,
																		},
																	},
																},
																Name: "microsecond",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   55,
															},
															File:   "microsecond_time_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   55,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   55,
													},
													File:   "microsecond_time_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   55,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   55,
														},
														File:   "microsecond_time_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   55,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   55,
									},
									File:   "microsecond_time_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.microsecond(t: r._time)}))",
									Start: ast.Position{
										Column: 6,
										Line:   55,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   55,
										},
										File:   "microsecond_time_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   55,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   52,
							},
							File:   "microsecond_time_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 23,
								Line:   52,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   52,
								},
								File:   "microsecond_time_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 23,
									Line:   52,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   52,
							},
							File:   "microsecond_time_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 29,
								Line:   52,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 106,
							Line:   58,
						},
						File:   "microsecond_time_test.flux",
						Source: "_time_microsecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_microsecond})",
						Start: ast.Position{
							Column: 6,
							Line:   57,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   57,
							},
							File:   "microsecond_time_test.flux",
							Source: "_time_microsecond",
							Start: ast.Position{
								Column: 6,
								Line:   57,
							},
						},
					},
					Name: "_time_microsecond",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 106,
								Line:   58,
							},
							File:   "microsecond_time_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_microsecond})",
							Start: ast.Position{
								Column: 26,
								Line:   57,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 106,
									Line:   58,
								},
								File:   "microsecond_time_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_microsecond})",
								Start: ast.Position{
									Column: 2,
									Line:   58,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 105,
										Line:   58,
									},
									File:   "microsecond_time_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_microsecond}",
									Start: ast.Position{
										Column: 3,
										Line:   58,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   58,
										},
										File:   "microsecond_time_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   58,
											},
											File:   "microsecond_time_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   58,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   58,
												},
												File:   "microsecond_time_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   58,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   58,
													},
													File:   "microsecond_time_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   58,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   58,
														},
														File:   "microsecond_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   58,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   58,
														},
														File:   "microsecond_time_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   58,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   58,
											},
											File:   "microsecond_time_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   58,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   58,
												},
												File:   "microsecond_time_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   58,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   58,
													},
													File:   "microsecond_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   58,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   58,
													},
													File:   "microsecond_time_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   58,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   58,
										},
										File:   "microsecond_time_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   58,
											},
											File:   "microsecond_time_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   58,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   58,
												},
												File:   "microsecond_time_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   58,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   58,
													},
													File:   "microsecond_time_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   58,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   58,
														},
														File:   "microsecond_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   58,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   58,
														},
														File:   "microsecond_time_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   58,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   58,
											},
											File:   "microsecond_time_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   58,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   58,
												},
												File:   "microsecond_time_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   58,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   58,
													},
													File:   "microsecond_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   58,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   58,
													},
													File:   "microsecond_time_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   58,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 104,
											Line:   58,
										},
										File:   "microsecond_time_test.flux",
										Source: "fn: t_time_microsecond",
										Start: ast.Position{
											Column: 82,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   58,
											},
											File:   "microsecond_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   58,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 104,
												Line:   58,
											},
											File:   "microsecond_time_test.flux",
											Source: "t_time_microsecond",
											Start: ast.Position{
												Column: 86,
												Line:   58,
											},
										},
									},
									Name: "t_time_microsecond",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 106,
						Line:   58,
					},
					File:   "microsecond_time_test.flux",
					Source: "test _time_microsecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_microsecond})",
					Start: ast.Position{
						Column: 1,
						Line:   57,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "microsecond_time_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "microsecond_time_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "microsecond_time_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "microsecond_time_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "microsecond_time_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "microsecond_time_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "microsecond_time_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 110,
					Line:   40,
				},
				File:   "millisecond_duration_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"\n\nt_duration_millisecond = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.millisecond(t: duration(v : r._value))})))\n\ntest _duration_millisecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_millisecond})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "millisecond_duration_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "millisecond_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "millisecond_duration_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "millisecond_duration_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "millisecond_duration_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "millisecond_duration_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   19,
					},
					File:   "millisecond_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "millisecond_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   19,
						},
						File:   "millisecond_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "millisecond_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "millisecond_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "millisecond_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 85,
						Line:   37,
					},
					File:   "millisecond_duration_test.flux",
					Source: "t_duration_millisecond = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.millisecond(t: duration(v : r._value))})))",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 23,
							Line:   34,
						},
						File:   "millisecond_duration_test.flux",
						Source: "t_duration_millisecond",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "t_duration_millisecond",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 85,
							Line:   37,
						},
						File:   "millisecond_duration_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.millisecond(t: duration(v : r._value))})))",
						Start: ast.Position{
							Column: 26,
							Line:   34,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 85,
								Line:   37,
							},
							File:   "millisecond_duration_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.millisecond(t: duration(v : r._value))})))",
							Start: ast.Position{
								Column: 2,
								Line:   35,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   35,
										},
										File:   "millisecond_duration_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   35,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   36,
									},
									File:   "millisecond_duration_test.flux",
									Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   35,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   36,
											},
											File:   "millisecond_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   36,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   36,
												},
												File:   "millisecond_duration_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   36,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   36,
													},
													File:   "millisecond_duration_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   36,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   36,
													},
													File:   "millisecond_duration_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   36,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   36,
										},
										File:   "millisecond_duration_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   36,
											},
											File:   "millisecond_duration_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   36,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   37,
								},
								File:   "millisecond_duration_test.flux",
								Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.millisecond(t: duration(v : r._value))}))",
								Start: ast.Position{
									Column: 3,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 83,
											Line:   37,
										},
										File:   "millisecond_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.millisecond(t: duration(v : r._value))})",
										Start: ast.Position{
											Column: 10,
											Line:   37,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 83,
												Line:   37,
											},
											File:   "millisecond_duration_test.flux",
											Source: "fn: (r) => ({r with _value: date.millisecond(t: duration(v : r._value))})",
											Start: ast.Position{
												Column: 10,
												Line:   37,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   37,
												},
												File:   "millisecond_duration_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   37,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 83,
													Line:   37,
												},
												File:   "millisecond_duration_test.flux",
												Source: "(r) => ({r with _value: date.millisecond(t: duration(v : r._value))})",
												Start: ast.Position{
													Column: 14,
													Line:   37,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 83,
														Line:   37,
													},
													File:   "millisecond_duration_test.flux",
													Source: "({r with _value: date.millisecond(t: duration(v : r._value))})",
													Start: ast.Position{
														Column: 21,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   37,
														},
														File:   "millisecond_duration_test.flux",
														Source: "{r with _value: date.millisecond(t: duration(v : r._value))}",
														Start: ast.Position{
															Column: 22,
															Line:   37,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 81,
																Line:   37,
															},
															File:   "millisecond_duration_test.flux",
															Source: "_value: date.millisecond(t: duration(v : r._value))",
															Start: ast.Position{
																Column: 30,
																Line:   37,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   37,
																},
																File:   "millisecond_duration_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 80,
																		Line:   37,
																	},
																	File:   "millisecond_duration_test.flux",
																	Source: "t: duration(v : r._value)",
																	Start: ast.Position{
																		Column: 55,
																		Line:   37,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 80,
																			Line:   37,
																		},
																		File:   "millisecond_duration_test.flux",
																		Source: "t: duration(v : r._value)",
																		Start: ast.Position{
																			Column: 55,
																			Line:   37,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   37,
																			},
																			File:   "millisecond_duration_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 55,
																				Line:   37,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 79,
																					Line:   37,
																				},
																				File:   "millisecond_duration_test.flux",
																				Source: "v : r._value",
																				Start: ast.Position{
																					Column: 67,
																					Line:   37,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 79,
																						Line:   37,
																					},
																					File:   "millisecond_duration_test.flux",
																					Source: "v : r._value",
																					Start: ast.Position{
																						Column: 67,
																						Line:   37,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 68,
																							Line:   37,
																						},
																						File:   "millisecond_duration_test.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 67,
																							Line:   37,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Separator: nil,
																			Value: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 79,
																							Line:   37,
																						},
																						File:   "millisecond_duration_test.flux",
																						Source: "r._value",
																						Start: ast.Position{
																							Column: 71,
																							Line:   37,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 72,
																								Line:   37,
																							},
																							File:   "millisecond_duration_test.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 71,
																								Line:   37,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 79,
																								Line:   37,
																							},
																							File:   "millisecond_duration_test.flux",
																							Source: "_value",
																							Start: ast.Position{
																								Column: 73,
																								Line:   37,
																							},
																						},
																					},
																					Name: "_value",
																				},
																				Rbrack: nil,
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 80,
																				Line:   37,
																			},
																			File:   "millisecond_duration_test.flux",
																			Source: "duration(v : r._value)",
																			Start: ast.Position{
																				Column: 58,
																				Line:   37,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 66,
																					Line:   37,
																				},
																				File:   "millisecond_duration_test.flux",
																				Source: "duration",
																				Start: ast.Position{
																					Column: 58,
																					Line:   37,
																				},
																			},
																		},
																		Name: "duration",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 81,
																	Line:   37,
																},
																File:   "millisecond_duration_test.flux",
																Source: "date.millisecond(t: duration(v : r._value))",
																Start: ast.Position{
																	Column: 38,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 54,
																		Line:   37,
																	},
																	File:   "millisecond_duration_test.flux",
																	Source: "date.millisecond",
																	Start: ast.Position{
																		Column: 38,
																		Line:   37,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   37,
																		},
																		File:   "millisecond_duration_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   37,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 54,
																			Line:   37,
																		},
																		File:   "millisecond_duration_test.flux",
																		Source: "millisecond",
																		Start: ast.Position{
																			Column: 43,
																			Line:   37,
																		},
																	},
																},
																Name: "millisecond",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   37,
															},
															File:   "millisecond_duration_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   37,
													},
													File:   "millisecond_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   37,
														},
														File:   "millisecond_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   37,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   37,
									},
									File:   "millisecond_duration_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.millisecond(t: duration(v : r._value))}))",
									Start: ast.Position{
										Column: 6,
										Line:   37,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   37,
										},
										File:   "millisecond_duration_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   37,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   34,
							},
							File:   "millisecond_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 27,
								Line:   34,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   34,
								},
								File:   "millisecond_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 27,
									Line:   34,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   34,
							},
							File:   "millisecond_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 33,
								Line:   34,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 110,
							Line:   40,
						},
						File:   "millisecond_duration_test.flux",
						Source: "_duration_millisecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_millisecond})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   39,
							},
							File:   "millisecond_duration_test.flux",
							Source: "_duration_millisecond",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_duration_millisecond",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 110,
								Line:   40,
							},
							File:   "millisecond_duration_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_millisecond})",
							Start: ast.Position{
								Column: 30,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 110,
									Line:   40,
								},
								File:   "millisecond_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_millisecond})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 109,
										Line:   40,
									},
									File:   "millisecond_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_millisecond}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "millisecond_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "millisecond_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   40,
												},
												File:   "millisecond_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   40,
													},
													File:   "millisecond_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   40,
														},
														File:   "millisecond_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   40,
														},
														File:   "millisecond_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "millisecond_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   40,
												},
												File:   "millisecond_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   40,
													},
													File:   "millisecond_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   40,
													},
													File:   "millisecond_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "millisecond_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "millisecond_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   40,
												},
												File:   "millisecond_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   40,
													},
													File:   "millisecond_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   40,
														},
														File:   "millisecond_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   40,
														},
														File:   "millisecond_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "millisecond_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   40,
												},
												File:   "millisecond_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   40,
													},
													File:   "millisecond_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   40,
													},
													File:   "millisecond_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 108,
											Line:   40,
										},
										File:   "millisecond_duration_test.flux",
										Source: "fn: t_duration_millisecond",
										Start: ast.Position{
											Column: 82,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   40,
											},
											File:   "millisecond_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   40,
											},
											File:   "millisecond_duration_test.flux",
											Source: "t_duration_millisecond",
											Start: ast.Position{
												Column: 86,
												Line:   40,
											},
										},
									},
									Name: "t_duration_millisecond",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 110,
						Line:   40,
					},
					File:   "millisecond_duration_test.flux",
					Source: "test _duration_millisecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_millisecond})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "millisecond_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "millisecond_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "millisecond_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "millisecond_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "millisecond_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "millisecond_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "millisecond_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 106,
					Line:   58,
				},
				File:   "millisecond_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823\n\"\n\nt_time_millisecond = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.millisecond(t: r._time)})))\n\ntest _time_millisecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_millisecond})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "millisecond_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "millisecond_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "millisecond_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "millisecond_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "millisecond_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "millisecond_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   28,
					},
					File:   "millisecond_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "millisecond_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   28,
						},
						File:   "millisecond_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   50,
					},
					File:   "millisecond_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   30,
						},
						File:   "millisecond_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   50,
						},
						File:   "millisecond_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   30,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 70,
						Line:   55,
					},
					File:   "millisecond_test.flux",
					Source: "t_time_millisecond = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.millisecond(t: r._time)})))",
					Start: ast.Position{
						Column: 1,
						Line:   52,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   52,
						},
						File:   "millisecond_test.flux",
						Source: "t_time_millisecond",
						Start: ast.Position{
							Column: 1,
							Line:   52,
						},
					},
				},
				Name: "t_time_millisecond",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   55,
						},
						File:   "millisecond_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.millisecond(t: r._time)})))",
						Start: ast.Position{
							Column: 22,
							Line:   52,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   55,
							},
							File:   "millisecond_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.millisecond(t: r._time)})))",
							Start: ast.Position{
								Column: 2,
								Line:   53,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   53,
										},
										File:   "millisecond_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   53,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   54,
									},
									File:   "millisecond_test.flux",
									Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   53,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   54,
											},
											File:   "millisecond_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   54,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   54,
												},
												File:   "millisecond_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   54,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   54,
													},
													File:   "millisecond_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   54,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   54,
													},
													File:   "millisecond_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   54,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   54,
										},
										File:   "millisecond_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   54,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   54,
											},
											File:   "millisecond_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   54,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   55,
								},
								File:   "millisecond_test.flux",
								Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.millisecond(t: r._time)}))",
								Start: ast.Position{
									Column: 3,
									Line:   53,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   55,
										},
										File:   "millisecond_test.flux",
										Source: "fn: (r) => ({r with _value: date.millisecond(t: r._time)})",
										Start: ast.Position{
											Column: 10,
											Line:   55,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   55,
											},
											File:   "millisecond_test.flux",
											Source: "fn: (r) => ({r with _value: date.millisecond(t: r._time)})",
											Start: ast.Position{
												Column: 10,
												Line:   55,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   55,
												},
												File:   "millisecond_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   55,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   55,
												},
												File:   "millisecond_test.flux",
												Source: "(r) => ({r with _value: date.millisecond(t: r._time)})",
												Start: ast.Position{
													Column: 14,
													Line:   55,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   55,
													},
													File:   "millisecond_test.flux",
													Source: "({r with _value: date.millisecond(t: r._time)})",
													Start: ast.Position{
														Column: 21,
														Line:   55,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 67,
															Line:   55,
														},
														File:   "millisecond_test.flux",
														Source: "{r with _value: date.millisecond(t: r._time)}",
														Start: ast.Position{
															Column: 22,
															Line:   55,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 66,
																Line:   55,
															},
															File:   "millisecond_test.flux",
															Source: "_value: date.millisecond(t: r._time)",
															Start: ast.Position{
																Column: 30,
																Line:   55,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   55,
																},
																File:   "millisecond_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   55,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 65,
																		Line:   55,
																	},
																	File:   "millisecond_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 55,
																		Line:   55,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 65,
																			Line:   55,
																		},
																		File:   "millisecond_test.flux",
																		Source: "t: r._time",
																		Start: ast.Position{
																			Column: 55,
																			Line:   55,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   55,
																			},
																			File:   "millisecond_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 55,
																				Line:   55,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 65,
																				Line:   55,
																			},
																			File:   "millisecond_test.flux",
																			Source: "r._time",
																			Start: ast.Position{
																				Column: 58,
																				Line:   55,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 59,
																					Line:   55,
																				},
																				File:   "millisecond_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 58,
																					Line:   55,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 65,
																					Line:   55,
																				},
																				File:   "millisecond_test.flux",
																				Source: "_time",
																				Start: ast.Position{
																					Column: 60,
																					Line:   55,
																				},
																			},
																		},
																		Name: "_time",
																	},
																	Rbrack: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 66,
																	Line:   55,
																},
																File:   "millisecond_test.flux",
																Source: "date.millisecond(t: r._time)",
																Start: ast.Position{
																	Column: 38,
																	Line:   55,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 54,
																		Line:   55,
																	},
																	File:   "millisecond_test.flux",
																	Source: "date.millisecond",
																	Start: ast.Position{
																		Column: 38,
																		Line:   55,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   55,
																		},
																		File:   "millisecond_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   55,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 54,
																			Line:   55,
																		},
																		File:   "millisecond_test.flux",
																		Source: "millisecond",
																		Start: ast.Position{
																			Column: 43,
																			Line:   55,
																		},
																	},
																},
																Name: "millisecond",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   55,
															},
															File:   "millisecond_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   55,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   55,
													},
													File:   "millisecond_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   55,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   55,
														},
														File:   "millisecond_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   55,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   55,
									},
									File:   "millisecond_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.millisecond(t: r._time)}))",
									Start: ast.Position{
										Column: 6,
										Line:   55,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   55,
										},
										File:   "millisecond_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   55,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   52,
							},
							File:   "millisecond_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 23,
								Line:   52,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   52,
								},
								File:   "millisecond_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 23,
									Line:   52,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   52,
							},
							File:   "millisecond_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 29,
								Line:   52,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 106,
							Line:   58,
						},
						File:   "millisecond_test.flux",
						Source: "_time_millisecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_millisecond})",
						Start: ast.Position{
							Column: 6,
							Line:   57,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   57,
							},
							File:   "millisecond_test.flux",
							Source: "_time_millisecond",
							Start: ast.Position{
								Column: 6,
								Line:   57,
							},
						},
					},
					Name: "_time_millisecond",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 106,
								Line:   58,
							},
							File:   "millisecond_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_millisecond})",
							Start: ast.Position{
								Column: 26,
								Line:   57,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 106,
									Line:   58,
								},
								File:   "millisecond_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_millisecond})",
								Start: ast.Position{
									Column: 2,
									Line:   58,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 105,
										Line:   58,
									},
									File:   "millisecond_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_millisecond}",
									Start: ast.Position{
										Column: 3,
										Line:   58,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   58,
										},
										File:   "millisecond_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   58,
											},
											File:   "millisecond_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   58,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   58,
												},
												File:   "millisecond_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   58,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   58,
													},
													File:   "millisecond_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   58,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   58,
														},
														File:   "millisecond_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   58,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   58,
														},
														File:   "millisecond_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   58,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   58,
											},
											File:   "millisecond_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   58,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   58,
												},
												File:   "millisecond_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   58,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   58,
													},
													File:   "millisecond_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   58,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   58,
													},
													File:   "millisecond_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   58,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   58,
										},
										File:   "millisecond_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   58,
											},
											File:   "millisecond_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   58,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   58,
												},
												File:   "millisecond_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   58,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   58,
													},
													File:   "millisecond_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   58,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   58,
														},
														File:   "millisecond_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   58,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   58,
														},
														File:   "millisecond_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   58,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   58,
											},
											File:   "millisecond_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   58,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   58,
												},
												File:   "millisecond_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   58,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   58,
													},
													File:   "millisecond_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   58,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   58,
													},
													File:   "millisecond_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   58,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 104,
											Line:   58,
										},
										File:   "millisecond_test.flux",
										Source: "fn: t_time_millisecond",
										Start: ast.Position{
											Column: 82,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   58,
											},
											File:   "millisecond_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   58,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 104,
												Line:   58,
											},
											File:   "millisecond_test.flux",
											Source: "t_time_millisecond",
											Start: ast.Position{
												Column: 86,
												Line:   58,
											},
										},
									},
									Name: "t_time_millisecond",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 106,
						Line:   58,
					},
					File:   "millisecond_test.flux",
					Source: "test _time_millisecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_millisecond})",
					Start: ast.Position{
						Column: 1,
						Line:   57,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "millisecond_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "millisecond_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "millisecond_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "millisecond_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "millisecond_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "millisecond_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "millisecond_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 105,
					Line:   40,
				},
				File:   "minute_duration_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"\n\nt_duration_minute = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.minute(t: duration(v : r._value))})))\n\ntest _duration_minute = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_minute})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "minute_duration_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "minute_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "minute_duration_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "minute_duration_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "minute_duration_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "minute_duration_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   19,
					},
					File:   "minute_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "minute_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   19,
						},
						File:   "minute_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "minute_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "minute_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "minute_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 80,
						Line:   37,
					},
					File:   "minute_duration_test.flux",
					Source: "t_duration_minute = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.minute(t: duration(v : r._value))})))",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   34,
						},
						File:   "minute_duration_test.flux",
						Source: "t_duration_minute",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "t_duration_minute",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 80,
							Line:   37,
						},
						File:   "minute_duration_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.minute(t: duration(v : r._value))})))",
						Start: ast.Position{
							Column: 21,
							Line:   34,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 80,
								Line:   37,
							},
							File:   "minute_duration_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.minute(t: duration(v : r._value))})))",
							Start: ast.Position{
								Column: 2,
								Line:   35,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   35,
										},
										File:   "minute_duration_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   35,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   36,
									},
									File:   "minute_duration_test.flux",
									Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   35,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   36,
											},
											File:   "minute_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   36,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   36,
												},
												File:   "minute_duration_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   36,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   36,
													},
													File:   "minute_duration_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   36,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   36,
													},
													File:   "minute_duration_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   36,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   36,
										},
										File:   "minute_duration_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   36,
											},
											File:   "minute_duration_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   36,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   37,
								},
								File:   "minute_duration_test.flux",
								Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.minute(t: duration(v : r._value))}))",
								Start: ast.Position{
									Column: 3,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   37,
										},
										File:   "minute_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.minute(t: duration(v : r._value))})",
										Start: ast.Position{
											Column: 10,
											Line:   37,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   37,
											},
											File:   "minute_duration_test.flux",
											Source: "fn: (r) => ({r with _value: date.minute(t: duration(v : r._value))})",
											Start: ast.Position{
												Column: 10,
												Line:   37,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   37,
												},
												File:   "minute_duration_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   37,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 78,
													Line:   37,
												},
												File:   "minute_duration_test.flux",
												Source: "(r) => ({r with _value: date.minute(t: duration(v : r._value))})",
												Start: ast.Position{
													Column: 14,
													Line:   37,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   37,
													},
													File:   "minute_duration_test.flux",
													Source: "({r with _value: date.minute(t: duration(v : r._value))})",
													Start: ast.Position{
														Column: 21,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   37,
														},
														File:   "minute_duration_test.flux",
														Source: "{r with _value: date.minute(t: duration(v : r._value))}",
														Start: ast.Position{
															Column: 22,
															Line:   37,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 76,
																Line:   37,
															},
															File:   "minute_duration_test.flux",
															Source: "_value: date.minute(t: duration(v : r._value))",
															Start: ast.Position{
																Column: 30,
																Line:   37,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   37,
																},
																File:   "minute_duration_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 75,
																		Line:   37,
																	},
																	File:   "minute_duration_test.flux",
																	Source: "t: duration(v : r._value)",
																	Start: ast.Position{
																		Column: 50,
																		Line:   37,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 75,
																			Line:   37,
																		},
																		File:   "minute_duration_test.flux",
																		Source: "t: duration(v : r._value)",
																		Start: ast.Position{
																			Column: 50,
																			Line:   37,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 51,
																				Line:   37,
																			},
																			File:   "minute_duration_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 50,
																				Line:   37,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 74,
																					Line:   37,
																				},
																				File:   "minute_duration_test.flux",
																				Source: "v : r._value",
																				Start: ast.Position{
																					Column: 62,
																					Line:   37,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 74,
																						Line:   37,
																					},
																					File:   "minute_duration_test.flux",
																					Source: "v : r._value",
																					Start: ast.Position{
																						Column: 62,
																						Line:   37,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 63,
																							Line:   37,
																						},
																						File:   "minute_duration_test.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 62,
																							Line:   37,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Separator: nil,
																			Value: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 74,
																							Line:   37,
																						},
																						File:   "minute_duration_test.flux",
																						Source: "r._value",
																						Start: ast.Position{
																							Column: 66,
																							Line:   37,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 67,
																								Line:   37,
																							},
																							File:   "minute_duration_test.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 66,
																								Line:   37,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 74,
																								Line:   37,
																							},
																							File:   "minute_duration_test.flux",
																							Source: "_value",
																							Start: ast.Position{
																								Column: 68,
																								Line:   37,
																							},
																						},
																					},
																					Name: "_value",
																				},
																				Rbrack: nil,
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 75,
																				Line:   37,
																			},
																			File:   "minute_duration_test.flux",
																			Source: "duration(v : r._value)",
																			Start: ast.Position{
																				Column: 53,
																				Line:   37,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 61,
																					Line:   37,
																				},
																				File:   "minute_duration_test.flux",
																				Source: "duration",
																				Start: ast.Position{
																					Column: 53,
																					Line:   37,
																				},
																			},
																		},
																		Name: "duration",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 76,
																	Line:   37,
																},
																File:   "minute_duration_test.flux",
																Source: "date.minute(t: duration(v : r._value))",
																Start: ast.Position{
																	Column: 38,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   37,
																	},
																	File:   "minute_duration_test.flux",
																	Source: "date.minute",
																	Start: ast.Position{
																		Column: 38,
																		Line:   37,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   37,
																		},
																		File:   "minute_duration_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   37,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   37,
																		},
																		File:   "minute_duration_test.flux",
																		Source: "minute",
																		Start: ast.Position{
																			Column: 43,
																			Line:   37,
																		},
																	},
																},
																Name: "minute",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   37,
															},
															File:   "minute_duration_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   37,
													},
													File:   "minute_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   37,
														},
														File:   "minute_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   37,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 79,
										Line:   37,
									},
									File:   "minute_duration_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.minute(t: duration(v : r._value))}))",
									Start: ast.Position{
										Column: 6,
										Line:   37,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   37,
										},
										File:   "minute_duration_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   37,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   34,
							},
							File:   "minute_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 22,
								Line:   34,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   34,
								},
								File:   "minute_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 22,
									Line:   34,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   34,
							},
							File:   "minute_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   34,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 105,
							Line:   40,
						},
						File:   "minute_duration_test.flux",
						Source: "_duration_minute = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_minute})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   39,
							},
							File:   "minute_duration_test.flux",
							Source: "_duration_minute",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_duration_minute",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 105,
								Line:   40,
							},
							File:   "minute_duration_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_minute})",
							Start: ast.Position{
								Column: 25,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   40,
								},
								File:   "minute_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_minute})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 104,
										Line:   40,
									},
									File:   "minute_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_minute}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "minute_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "minute_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   40,
												},
												File:   "minute_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   40,
													},
													File:   "minute_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   40,
														},
														File:   "minute_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   40,
														},
														File:   "minute_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "minute_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   40,
												},
												File:   "minute_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   40,
													},
													File:   "minute_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   40,
													},
													File:   "minute_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "minute_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "minute_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   40,
												},
												File:   "minute_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   40,
													},
													File:   "minute_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   40,
														},
														File:   "minute_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   40,
														},
														File:   "minute_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "minute_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   40,
												},
												File:   "minute_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   40,
													},
													File:   "minute_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   40,
													},
													File:   "minute_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 103,
											Line:   40,
										},
										File:   "minute_duration_test.flux",
										Source: "fn: t_duration_minute",
										Start: ast.Position{
											Column: 82,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   40,
											},
											File:   "minute_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 103,
												Line:   40,
											},
											File:   "minute_duration_test.flux",
											Source: "t_duration_minute",
											Start: ast.Position{
												Column: 86,
												Line:   40,
											},
										},
									},
									Name: "t_duration_minute",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 105,
						Line:   40,
					},
					File:   "minute_duration_test.flux",
					Source: "test _duration_minute = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_minute})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "minute_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "minute_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "minute_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "minute_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "minute_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "minute_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "minute_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 101,
					Line:   72,
				},
				File:   "minute_time_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00Z,_m,FF,1\n,,0,2018-05-22T19:02:00Z,_m,FF,1\n,,0,2018-05-22T19:03:00Z,_m,FF,1\n,,0,2018-05-22T19:04:00Z,_m,FF,1\n,,0,2018-05-22T19:05:00Z,_m,FF,1\n,,0,2018-05-22T19:06:00Z,_m,FF,1\n,,1,2018-05-22T19:07:00Z,_m,QQ,1\n,,1,2018-05-22T19:08:00Z,_m,QQ,1\n,,1,2018-05-22T19:09:00Z,_m,QQ,1\n,,1,2018-05-22T19:10:00Z,_m,QQ,1\n,,1,2018-05-22T19:13:00Z,_m,QQ,1\n,,1,2018-05-22T19:15:00Z,_m,QQ,1\n,,1,2018-05-22T19:20:00Z,_m,QQ,1\n,,1,2018-05-22T19:23:00Z,_m,QQ,1\n,,1,2018-05-22T19:25:00Z,_m,QQ,1\n,,2,2018-05-22T19:28:00Z,_m,RR,1\n,,2,2018-05-22T19:36:00Z,_m,RR,1\n,,2,2018-05-22T19:38:00Z,_m,RR,1\n,,2,2018-05-22T19:47:00Z,_m,RR,1\n,,3,2018-05-22T19:48:00Z,_m,SR,1\n,,3,2018-05-22T19:59:00Z,_m,SR,1\n,,3,2018-05-22T20:00:00Z,_m,SR,1\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00Z,15\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00Z,20\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00Z,23\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00Z,25\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:28:00Z,28\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:36:00Z,36\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:38:00Z,38\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:47:00Z,47\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:48:00Z,48\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:59:00Z,59\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T20:00:00Z,00\n\"\n\nt_time_minute = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.minute(t: r._time)})))\n\ntest _time_minute = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_minute})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "minute_time_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "minute_time_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "minute_time_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "minute_time_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "minute_time_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "minute_time_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   35,
					},
					File:   "minute_time_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00Z,_m,FF,1\n,,0,2018-05-22T19:02:00Z,_m,FF,1\n,,0,2018-05-22T19:03:00Z,_m,FF,1\n,,0,2018-05-22T19:04:00Z,_m,FF,1\n,,0,2018-05-22T19:05:00Z,_m,FF,1\n,,0,2018-05-22T19:06:00Z,_m,FF,1\n,,1,2018-05-22T19:07:00Z,_m,QQ,1\n,,1,2018-05-22T19:08:00Z,_m,QQ,1\n,,1,2018-05-22T19:09:00Z,_m,QQ,1\n,,1,2018-05-22T19:10:00Z,_m,QQ,1\n,,1,2018-05-22T19:13:00Z,_m,QQ,1\n,,1,2018-05-22T19:15:00Z,_m,QQ,1\n,,1,2018-05-22T19:20:00Z,_m,QQ,1\n,,1,2018-05-22T19:23:00Z,_m,QQ,1\n,,1,2018-05-22T19:25:00Z,_m,QQ,1\n,,2,2018-05-22T19:28:00Z,_m,RR,1\n,,2,2018-05-22T19:36:00Z,_m,RR,1\n,,2,2018-05-22T19:38:00Z,_m,RR,1\n,,2,2018-05-22T19:47:00Z,_m,RR,1\n,,3,2018-05-22T19:48:00Z,_m,SR,1\n,,3,2018-05-22T19:59:00Z,_m,SR,1\n,,3,2018-05-22T20:00:00Z,_m,SR,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "minute_time_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   35,
						},
						File:   "minute_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00Z,_m,FF,1\n,,0,2018-05-22T19:02:00Z,_m,FF,1\n,,0,2018-05-22T19:03:00Z,_m,FF,1\n,,0,2018-05-22T19:04:00Z,_m,FF,1\n,,0,2018-05-22T19:05:00Z,_m,FF,1\n,,0,2018-05-22T19:06:00Z,_m,FF,1\n,,1,2018-05-22T19:07:00Z,_m,QQ,1\n,,1,2018-05-22T19:08:00Z,_m,QQ,1\n,,1,2018-05-22T19:09:00Z,_m,QQ,1\n,,1,2018-05-22T19:10:00Z,_m,QQ,1\n,,1,2018-05-22T19:13:00Z,_m,QQ,1\n,,1,2018-05-22T19:15:00Z,_m,QQ,1\n,,1,2018-05-22T19:20:00Z,_m,QQ,1\n,,1,2018-05-22T19:23:00Z,_m,QQ,1\n,,1,2018-05-22T19:25:00Z,_m,QQ,1\n,,2,2018-05-22T19:28:00Z,_m,RR,1\n,,2,2018-05-22T19:36:00Z,_m,RR,1\n,,2,2018-05-22T19:38:00Z,_m,RR,1\n,,2,2018-05-22T19:47:00Z,_m,RR,1\n,,3,2018-05-22T19:48:00Z,_m,SR,1\n,,3,2018-05-22T19:59:00Z,_m,SR,1\n,,3,2018-05-22T20:00:00Z,_m,SR,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00Z,_m,FF,1\n,,0,2018-05-22T19:02:00Z,_m,FF,1\n,,0,2018-05-22T19:03:00Z,_m,FF,1\n,,0,2018-05-22T19:04:00Z,_m,FF,1\n,,0,2018-05-22T19:05:00Z,_m,FF,1\n,,0,2018-05-22T19:06:00Z,_m,FF,1\n,,1,2018-05-22T19:07:00Z,_m,QQ,1\n,,1,2018-05-22T19:08:00Z,_m,QQ,1\n,,1,2018-05-22T19:09:00Z,_m,QQ,1\n,,1,2018-05-22T19:10:00Z,_m,QQ,1\n,,1,2018-05-22T19:13:00Z,_m,QQ,1\n,,1,2018-05-22T19:15:00Z,_m,QQ,1\n,,1,2018-05-22T19:20:00Z,_m,QQ,1\n,,1,2018-05-22T19:23:00Z,_m,QQ,1\n,,1,2018-05-22T19:25:00Z,_m,QQ,1\n,,2,2018-05-22T19:28:00Z,_m,RR,1\n,,2,2018-05-22T19:36:00Z,_m,RR,1\n,,2,2018-05-22T19:38:00Z,_m,RR,1\n,,2,2018-05-22T19:47:00Z,_m,RR,1\n,,3,2018-05-22T19:48:00Z,_m,SR,1\n,,3,2018-05-22T19:59:00Z,_m,SR,1\n,,3,2018-05-22T20:00:00Z,_m,SR,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   64,
					},
					File:   "minute_time_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00Z,15\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00Z,20\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00Z,23\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00Z,25\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:28:00Z,28\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:36:00Z,36\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:38:00Z,38\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:47:00Z,47\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:48:00Z,48\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:59:00Z,59\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T20:00:00Z,00\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   37,
						},
						File:   "minute_time_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   37,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   64,
						},
						File:   "minute_time_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00Z,15\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00Z,20\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00Z,23\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00Z,25\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:28:00Z,28\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:36:00Z,36\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:38:00Z,38\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:47:00Z,47\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:48:00Z,48\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:59:00Z,59\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T20:00:00Z,00\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   37,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00Z,15\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00Z,20\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00Z,23\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00Z,25\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:28:00Z,28\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:36:00Z,36\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:38:00Z,38\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:47:00Z,47\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:48:00Z,48\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:59:00Z,59\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T20:00:00Z,00\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 65,
						Line:   69,
					},
					File:   "minute_time_test.flux",
					Source: "t_time_minute = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.minute(t: r._time)})))",
					Start: ast.Position{
						Column: 1,
						Line:   66,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   66,
						},
						File:   "minute_time_test.flux",
						Source: "t_time_minute",
						Start: ast.Position{
							Column: 1,
							Line:   66,
						},
					},
				},
				Name: "t_time_minute",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 65,
							Line:   69,
						},
						File:   "minute_time_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.minute(t: r._time)})))",
						Start: ast.Position{
							Column: 17,
							Line:   66,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   69,
							},
							File:   "minute_time_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.minute(t: r._time)})))",
							Start: ast.Position{
								Column: 2,
								Line:   67,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   67,
										},
										File:   "minute_time_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   67,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   68,
									},
									File:   "minute_time_test.flux",
									Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   67,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   68,
											},
											File:   "minute_time_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   68,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   68,
												},
												File:   "minute_time_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   68,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   68,
													},
													File:   "minute_time_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   68,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   68,
													},
													File:   "minute_time_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   68,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   68,
										},
										File:   "minute_time_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   68,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   68,
											},
											File:   "minute_time_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   68,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   69,
								},
								File:   "minute_time_test.flux",
								Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.minute(t: r._time)}))",
								Start: ast.Position{
									Column: 3,
									Line:   67,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   69,
										},
										File:   "minute_time_test.flux",
										Source: "fn: (r) => ({r with _value: date.minute(t: r._time)})",
										Start: ast.Position{
											Column: 10,
											Line:   69,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 63,
												Line:   69,
											},
											File:   "minute_time_test.flux",
											Source: "fn: (r) => ({r with _value: date.minute(t: r._time)})",
											Start: ast.Position{
												Column: 10,
												Line:   69,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   69,
												},
												File:   "minute_time_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   69,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   69,
												},
												File:   "minute_time_test.flux",
												Source: "(r) => ({r with _value: date.minute(t: r._time)})",
												Start: ast.Position{
													Column: 14,
													Line:   69,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 63,
														Line:   69,
													},
													File:   "minute_time_test.flux",
													Source: "({r with _value: date.minute(t: r._time)})",
													Start: ast.Position{
														Column: 21,
														Line:   69,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   69,
														},
														File:   "minute_time_test.flux",
														Source: "{r with _value: date.minute(t: r._time)}",
														Start: ast.Position{
															Column: 22,
															Line:   69,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 61,
																Line:   69,
															},
															File:   "minute_time_test.flux",
															Source: "_value: date.minute(t: r._time)",
															Start: ast.Position{
																Column: 30,
																Line:   69,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   69,
																},
																File:   "minute_time_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   69,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 60,
																		Line:   69,
																	},
																	File:   "minute_time_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 50,
																		Line:   69,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 60,
																			Line:   69,
																		},
																		File:   "minute_time_test.flux",
																		Source: "t: r._time",
																		Start: ast.Position{
																			Column: 50,
																			Line:   69,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 51,
																				Line:   69,
																			},
																			File:   "minute_time_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 50,
																				Line:   69,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 60,
																				Line:   69,
																			},
																			File:   "minute_time_test.flux",
																			Source: "r._time",
																			Start: ast.Position{
																				Column: 53,
																				Line:   69,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 54,
																					Line:   69,
																				},
																				File:   "minute_time_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 53,
																					Line:   69,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 60,
																					Line:   69,
																				},
																				File:   "minute_time_test.flux",
																				Source: "_time",
																				Start: ast.Position{
																					Column: 55,
																					Line:   69,
																				},
																			},
																		},
																		Name: "_time",
																	},
																	Rbrack: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 61,
																	Line:   69,
																},
																File:   "minute_time_test.flux",
																Source: "date.minute(t: r._time)",
																Start: ast.Position{
																	Column: 38,
																	Line:   69,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   69,
																	},
																	File:   "minute_time_test.flux",
																	Source: "date.minute",
																	Start: ast.Position{
																		Column: 38,
																		Line:   69,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   69,
																		},
																		File:   "minute_time_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   69,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   69,
																		},
																		File:   "minute_time_test.flux",
																		Source: "minute",
																		Start: ast.Position{
																			Column: 43,
																			Line:   69,
																		},
																	},
																},
																Name: "minute",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   69,
															},
															File:   "minute_time_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   69,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   69,
													},
													File:   "minute_time_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   69,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   69,
														},
														File:   "minute_time_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   69,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   69,
									},
									File:   "minute_time_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.minute(t: r._time)}))",
									Start: ast.Position{
										Column: 6,
										Line:   69,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   69,
										},
										File:   "minute_time_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   69,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   66,
							},
							File:   "minute_time_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 18,
								Line:   66,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   66,
								},
								File:   "minute_time_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 18,
									Line:   66,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   66,
							},
							File:   "minute_time_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   66,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 101,
							Line:   72,
						},
						File:   "minute_time_test.flux",
						Source: "_time_minute = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_minute})",
						Start: ast.Position{
							Column: 6,
							Line:   71,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   71,
							},
							File:   "minute_time_test.flux",
							Source: "_time_minute",
							Start: ast.Position{
								Column: 6,
								Line:   71,
							},
						},
					},
					Name: "_time_minute",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 101,
								Line:   72,
							},
							File:   "minute_time_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_minute})",
							Start: ast.Position{
								Column: 21,
								Line:   71,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   72,
								},
								File:   "minute_time_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_minute})",
								Start: ast.Position{
									Column: 2,
									Line:   72,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 100,
										Line:   72,
									},
									File:   "minute_time_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_minute}",
									Start: ast.Position{
										Column: 3,
										Line:   72,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   72,
										},
										File:   "minute_time_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   72,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   72,
											},
											File:   "minute_time_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   72,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   72,
												},
												File:   "minute_time_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   72,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   72,
													},
													File:   "minute_time_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   72,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   72,
														},
														File:   "minute_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   72,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   72,
														},
														File:   "minute_time_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   72,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   72,
											},
											File:   "minute_time_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   72,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   72,
												},
												File:   "minute_time_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   72,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   72,
													},
													File:   "minute_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   72,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   72,
													},
													File:   "minute_time_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   72,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   72,
										},
										File:   "minute_time_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   72,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   72,
											},
											File:   "minute_time_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   72,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   72,
												},
												File:   "minute_time_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   72,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   72,
													},
													File:   "minute_time_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   72,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   72,
														},
														File:   "minute_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   72,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   72,
														},
														File:   "minute_time_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   72,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   72,
											},
											File:   "minute_time_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   72,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   72,
												},
												File:   "minute_time_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   72,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   72,
													},
													File:   "minute_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   72,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   72,
													},
													File:   "minute_time_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   72,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 99,
											Line:   72,
										},
										File:   "minute_time_test.flux",
										Source: "fn: t_time_minute",
										Start: ast.Position{
											Column: 82,
											Line:   72,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   72,
											},
											File:   "minute_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   72,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 99,
												Line:   72,
											},
											File:   "minute_time_test.flux",
											Source: "t_time_minute",
											Start: ast.Position{
												Column: 86,
												Line:   72,
											},
										},
									},
									Name: "t_time_minute",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 101,
						Line:   72,
					},
					File:   "minute_time_test.flux",
					Source: "test _time_minute = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_minute})",
					Start: ast.Position{
						Column: 1,
						Line:   71,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "minute_time_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "minute_time_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "minute_time_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "minute_time_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "minute_time_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "minute_time_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "minute_time_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 108,
					Line:   40,
				},
				File:   "month_day_duration_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"\n\nt_duration_month_day = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.monthDay(t: duration(v : r._value))})))\n\ntest _duration_month_day = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month_day})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "month_day_duration_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "month_day_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "month_day_duration_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "month_day_duration_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "month_day_duration_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "month_day_duration_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   19,
					},
					File:   "month_day_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "month_day_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   19,
						},
						File:   "month_day_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "month_day_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "month_day_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "month_day_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 82,
						Line:   37,
					},
					File:   "month_day_duration_test.flux",
					Source: "t_duration_month_day = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.monthDay(t: duration(v : r._value))})))",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   34,
						},
						File:   "month_day_duration_test.flux",
						Source: "t_duration_month_day",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "t_duration_month_day",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 82,
							Line:   37,
						},
						File:   "month_day_duration_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.monthDay(t: duration(v : r._value))})))",
						Start: ast.Position{
							Column: 24,
							Line:   34,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   37,
							},
							File:   "month_day_duration_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.monthDay(t: duration(v : r._value))})))",
							Start: ast.Position{
								Column: 2,
								Line:   35,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   35,
										},
										File:   "month_day_duration_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   35,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   36,
									},
									File:   "month_day_duration_test.flux",
									Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   35,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   36,
											},
											File:   "month_day_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   36,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   36,
												},
												File:   "month_day_duration_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   36,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   36,
													},
													File:   "month_day_duration_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   36,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   36,
													},
													File:   "month_day_duration_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   36,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   36,
										},
										File:   "month_day_duration_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   36,
											},
											File:   "month_day_duration_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   36,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   37,
								},
								File:   "month_day_duration_test.flux",
								Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.monthDay(t: duration(v : r._value))}))",
								Start: ast.Position{
									Column: 3,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   37,
										},
										File:   "month_day_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.monthDay(t: duration(v : r._value))})",
										Start: ast.Position{
											Column: 10,
											Line:   37,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   37,
											},
											File:   "month_day_duration_test.flux",
											Source: "fn: (r) => ({r with _value: date.monthDay(t: duration(v : r._value))})",
											Start: ast.Position{
												Column: 10,
												Line:   37,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   37,
												},
												File:   "month_day_duration_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   37,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   37,
												},
												File:   "month_day_duration_test.flux",
												Source: "(r) => ({r with _value: date.monthDay(t: duration(v : r._value))})",
												Start: ast.Position{
													Column: 14,
													Line:   37,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   37,
													},
													File:   "month_day_duration_test.flux",
													Source: "({r with _value: date.monthDay(t: duration(v : r._value))})",
													Start: ast.Position{
														Column: 21,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   37,
														},
														File:   "month_day_duration_test.flux",
														Source: "{r with _value: date.monthDay(t: duration(v : r._value))}",
														Start: ast.Position{
															Column: 22,
															Line:   37,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 78,
																Line:   37,
															},
															File:   "month_day_duration_test.flux",
															Source: "_value: date.monthDay(t: duration(v : r._value))",
															Start: ast.Position{
																Column: 30,
																Line:   37,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   37,
																},
																File:   "month_day_duration_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 77,
																		Line:   37,
																	},
																	File:   "month_day_duration_test.flux",
																	Source: "t: duration(v : r._value)",
																	Start: ast.Position{
																		Column: 52,
																		Line:   37,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 77,
																			Line:   37,
																		},
																		File:   "month_day_duration_test.flux",
																		Source: "t: duration(v : r._value)",
																		Start: ast.Position{
																			Column: 52,
																			Line:   37,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 53,
																				Line:   37,
																			},
																			File:   "month_day_duration_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 52,
																				Line:   37,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 76,
																					Line:   37,
																				},
																				File:   "month_day_duration_test.flux",
																				Source: "v : r._value",
																				Start: ast.Position{
																					Column: 64,
																					Line:   37,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 76,
																						Line:   37,
																					},
																					File:   "month_day_duration_test.flux",
																					Source: "v : r._value",
																					Start: ast.Position{
																						Column: 64,
																						Line:   37,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 65,
																							Line:   37,
																						},
																						File:   "month_day_duration_test.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 64,
																							Line:   37,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Separator: nil,
																			Value: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 76,
																							Line:   37,
																						},
																						File:   "month_day_duration_test.flux",
																						Source: "r._value",
																						Start: ast.Position{
																							Column: 68,
																							Line:   37,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 69,
																								Line:   37,
																							},
																							File:   "month_day_duration_test.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 68,
																								Line:   37,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 76,
																								Line:   37,
																							},
																							File:   "month_day_duration_test.flux",
																							Source: "_value",
																							Start: ast.Position{
																								Column: 70,
																								Line:   37,
																							},
																						},
																					},
																					Name: "_value",
																				},
																				Rbrack: nil,
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 77,
																				Line:   37,
																			},
																			File:   "month_day_duration_test.flux",
																			Source: "duration(v : r._value)",
																			Start: ast.Position{
																				Column: 55,
																				Line:   37,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 63,
																					Line:   37,
																				},
																				File:   "month_day_duration_test.flux",
																				Source: "duration",
																				Start: ast.Position{
																					Column: 55,
																					Line:   37,
																				},
																			},
																		},
																		Name: "duration",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 78,
																	Line:   37,
																},
																File:   "month_day_duration_test.flux",
																Source: "date.monthDay(t: duration(v : r._value))",
																Start: ast.Position{
																	Column: 38,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 51,
																		Line:   37,
																	},
																	File:   "month_day_duration_test.flux",
																	Source: "date.monthDay",
																	Start: ast.Position{
																		Column: 38,
																		Line:   37,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   37,
																		},
																		File:   "month_day_duration_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   37,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 51,
																			Line:   37,
																		},
																		File:   "month_day_duration_test.flux",
																		Source: "monthDay",
																		Start: ast.Position{
																			Column: 43,
																			Line:   37,
																		},
																	},
																},
																Name: "monthDay",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   37,
															},
															File:   "month_day_duration_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   37,
													},
													File:   "month_day_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   37,
														},
														File:   "month_day_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   37,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   37,
									},
									File:   "month_day_duration_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.monthDay(t: duration(v : r._value))}))",
									Start: ast.Position{
										Column: 6,
										Line:   37,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   37,
										},
										File:   "month_day_duration_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   37,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   34,
							},
							File:   "month_day_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 25,
								Line:   34,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   34,
								},
								File:   "month_day_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 25,
									Line:   34,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   34,
							},
							File:   "month_day_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 31,
								Line:   34,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 108,
							Line:   40,
						},
						File:   "month_day_duration_test.flux",
						Source: "_duration_month_day = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month_day})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   39,
							},
							File:   "month_day_duration_test.flux",
							Source: "_duration_month_day",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_duration_month_day",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 108,
								Line:   40,
							},
							File:   "month_day_duration_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month_day})",
							Start: ast.Position{
								Column: 28,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 108,
									Line:   40,
								},
								File:   "month_day_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month_day})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 107,
										Line:   40,
									},
									File:   "month_day_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month_day}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "month_day_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "month_day_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   40,
												},
												File:   "month_day_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   40,
													},
													File:   "month_day_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   40,
														},
														File:   "month_day_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   40,
														},
														File:   "month_day_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "month_day_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   40,
												},
												File:   "month_day_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   40,
													},
													File:   "month_day_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   40,
													},
													File:   "month_day_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "month_day_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "month_day_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   40,
												},
												File:   "month_day_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   40,
													},
													File:   "month_day_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   40,
														},
														File:   "month_day_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   40,
														},
														File:   "month_day_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "month_day_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   40,
												},
												File:   "month_day_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   40,
													},
													File:   "month_day_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   40,
													},
													File:   "month_day_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 106,
											Line:   40,
										},
										File:   "month_day_duration_test.flux",
										Source: "fn: t_duration_month_day",
										Start: ast.Position{
											Column: 82,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   40,
											},
											File:   "month_day_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 106,
												Line:   40,
											},
											File:   "month_day_duration_test.flux",
											Source: "t_duration_month_day",
											Start: ast.Position{
												Column: 86,
												Line:   40,
											},
										},
									},
									Name: "t_duration_month_day",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 108,
						Line:   40,
					},
					File:   "month_day_duration_test.flux",
					Source: "test _duration_month_day = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month_day})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "month_day_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "month_day_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "month_day_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "month_day_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "month_day_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "month_day_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "month_day_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 104,
					Line:   90,
				},
				File:   "month_day_time_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-01T19:53:00Z,_m,FF,1\n,,0,2018-05-02T19:53:10Z,_m,FF,1\n,,0,2018-05-03T19:53:20Z,_m,FF,1\n,,0,2018-05-04T19:53:30Z,_m,FF,1\n,,0,2018-05-05T19:53:40Z,_m,FF,1\n,,0,2018-05-06T19:53:50Z,_m,FF,1\n,,1,2018-05-07T19:53:00Z,_m,QQ,1\n,,1,2018-05-08T19:53:10Z,_m,QQ,1\n,,1,2018-05-09T19:53:20Z,_m,QQ,1\n,,1,2018-05-10T19:53:30Z,_m,QQ,1\n,,1,2018-05-11T19:53:40Z,_m,QQ,1\n,,1,2018-05-12T19:53:50Z,_m,QQ,1\n,,1,2018-05-13T19:54:00Z,_m,QQ,1\n,,1,2018-05-14T19:54:10Z,_m,QQ,1\n,,1,2018-05-15T19:54:20Z,_m,QQ,1\n,,2,2018-05-16T19:53:00Z,_m,RR,1\n,,2,2018-05-17T19:53:10Z,_m,RR,1\n,,2,2018-05-18T19:53:20Z,_m,RR,1\n,,2,2018-05-19T19:53:30Z,_m,RR,1\n,,3,2018-05-20T19:53:40Z,_m,SR,1\n,,3,2018-05-21T19:53:50Z,_m,SR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n,,3,2018-05-23T19:54:00Z,_m,SR,1\n,,3,2018-05-24T19:54:00Z,_m,SR,1\n,,3,2018-05-25T19:54:00Z,_m,SR,1\n,,3,2018-05-26T19:54:00Z,_m,SR,1\n,,3,2018-05-27T19:54:00Z,_m,SR,1\n,,3,2018-05-28T19:54:00Z,_m,SR,1\n,,3,2018-05-29T19:54:00Z,_m,SR,1\n,,3,2018-05-30T19:54:00Z,_m,SR,1\n,,3,2018-05-31T19:54:00Z,_m,SR,1\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-01T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-02T19:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-03T19:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-04T19:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-05T19:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-06T19:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-07T19:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-08T19:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-09T19:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-10T19:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-11T19:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-12T19:53:50Z,12\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-13T19:54:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-14T19:54:10Z,14\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-15T19:54:20Z,15\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-16T19:53:00Z,16\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-17T19:53:10Z,17\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-18T19:53:20Z,18\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-19T19:53:30Z,19\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-20T19:53:40Z,20\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-21T19:53:50Z,21\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:54:00Z,22\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-23T19:54:00Z,23\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-24T19:54:00Z,24\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-25T19:54:00Z,25\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-26T19:54:00Z,26\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-27T19:54:00Z,27\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-28T19:54:00Z,28\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-29T19:54:00Z,29\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-30T19:54:00Z,30\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-31T19:54:00Z,31\n\"\n\nt_time_month_day = (table=<-) =>\n\t(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.monthDay(t: r._time)})))\n\ntest _time_month_day = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month_day})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "month_day_time_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "month_day_time_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "month_day_time_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "month_day_time_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "month_day_time_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "month_day_time_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "month_day_time_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-01T19:53:00Z,_m,FF,1\n,,0,2018-05-02T19:53:10Z,_m,FF,1\n,,0,2018-05-03T19:53:20Z,_m,FF,1\n,,0,2018-05-04T19:53:30Z,_m,FF,1\n,,0,2018-05-05T19:53:40Z,_m,FF,1\n,,0,2018-05-06T19:53:50Z,_m,FF,1\n,,1,2018-05-07T19:53:00Z,_m,QQ,1\n,,1,2018-05-08T19:53:10Z,_m,QQ,1\n,,1,2018-05-09T19:53:20Z,_m,QQ,1\n,,1,2018-05-10T19:53:30Z,_m,QQ,1\n,,1,2018-05-11T19:53:40Z,_m,QQ,1\n,,1,2018-05-12T19:53:50Z,_m,QQ,1\n,,1,2018-05-13T19:54:00Z,_m,QQ,1\n,,1,2018-05-14T19:54:10Z,_m,QQ,1\n,,1,2018-05-15T19:54:20Z,_m,QQ,1\n,,2,2018-05-16T19:53:00Z,_m,RR,1\n,,2,2018-05-17T19:53:10Z,_m,RR,1\n,,2,2018-05-18T19:53:20Z,_m,RR,1\n,,2,2018-05-19T19:53:30Z,_m,RR,1\n,,3,2018-05-20T19:53:40Z,_m,SR,1\n,,3,2018-05-21T19:53:50Z,_m,SR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n,,3,2018-05-23T19:54:00Z,_m,SR,1\n,,3,2018-05-24T19:54:00Z,_m,SR,1\n,,3,2018-05-25T19:54:00Z,_m,SR,1\n,,3,2018-05-26T19:54:00Z,_m,SR,1\n,,3,2018-05-27T19:54:00Z,_m,SR,1\n,,3,2018-05-28T19:54:00Z,_m,SR,1\n,,3,2018-05-29T19:54:00Z,_m,SR,1\n,,3,2018-05-30T19:54:00Z,_m,SR,1\n,,3,2018-05-31T19:54:00Z,_m,SR,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "month_day_time_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "month_day_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-01T19:53:00Z,_m,FF,1\n,,0,2018-05-02T19:53:10Z,_m,FF,1\n,,0,2018-05-03T19:53:20Z,_m,FF,1\n,,0,2018-05-04T19:53:30Z,_m,FF,1\n,,0,2018-05-05T19:53:40Z,_m,FF,1\n,,0,2018-05-06T19:53:50Z,_m,FF,1\n,,1,2018-05-07T19:53:00Z,_m,QQ,1\n,,1,2018-05-08T19:53:10Z,_m,QQ,1\n,,1,2018-05-09T19:53:20Z,_m,QQ,1\n,,1,2018-05-10T19:53:30Z,_m,QQ,1\n,,1,2018-05-11T19:53:40Z,_m,QQ,1\n,,1,2018-05-12T19:53:50Z,_m,QQ,1\n,,1,2018-05-13T19:54:00Z,_m,QQ,1\n,,1,2018-05-14T19:54:10Z,_m,QQ,1\n,,1,2018-05-15T19:54:20Z,_m,QQ,1\n,,2,2018-05-16T19:53:00Z,_m,RR,1\n,,2,2018-05-17T19:53:10Z,_m,RR,1\n,,2,2018-05-18T19:53:20Z,_m,RR,1\n,,2,2018-05-19T19:53:30Z,_m,RR,1\n,,3,2018-05-20T19:53:40Z,_m,SR,1\n,,3,2018-05-21T19:53:50Z,_m,SR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n,,3,2018-05-23T19:54:00Z,_m,SR,1\n,,3,2018-05-24T19:54:00Z,_m,SR,1\n,,3,2018-05-25T19:54:00Z,_m,SR,1\n,,3,2018-05-26T19:54:00Z,_m,SR,1\n,,3,2018-05-27T19:54:00Z,_m,SR,1\n,,3,2018-05-28T19:54:00Z,_m,SR,1\n,,3,2018-05-29T19:54:00Z,_m,SR,1\n,,3,2018-05-30T19:54:00Z,_m,SR,1\n,,3,2018-05-31T19:54:00Z,_m,SR,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-01T19:53:00Z,_m,FF,1\n,,0,2018-05-02T19:53:10Z,_m,FF,1\n,,0,2018-05-03T19:53:20Z,_m,FF,1\n,,0,2018-05-04T19:53:30Z,_m,FF,1\n,,0,2018-05-05T19:53:40Z,_m,FF,1\n,,0,2018-05-06T19:53:50Z,_m,FF,1\n,,1,2018-05-07T19:53:00Z,_m,QQ,1\n,,1,2018-05-08T19:53:10Z,_m,QQ,1\n,,1,2018-05-09T19:53:20Z,_m,QQ,1\n,,1,2018-05-10T19:53:30Z,_m,QQ,1\n,,1,2018-05-11T19:53:40Z,_m,QQ,1\n,,1,2018-05-12T19:53:50Z,_m,QQ,1\n,,1,2018-05-13T19:54:00Z,_m,QQ,1\n,,1,2018-05-14T19:54:10Z,_m,QQ,1\n,,1,2018-05-15T19:54:20Z,_m,QQ,1\n,,2,2018-05-16T19:53:00Z,_m,RR,1\n,,2,2018-05-17T19:53:10Z,_m,RR,1\n,,2,2018-05-18T19:53:20Z,_m,RR,1\n,,2,2018-05-19T19:53:30Z,_m,RR,1\n,,3,2018-05-20T19:53:40Z,_m,SR,1\n,,3,2018-05-21T19:53:50Z,_m,SR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n,,3,2018-05-23T19:54:00Z,_m,SR,1\n,,3,2018-05-24T19:54:00Z,_m,SR,1\n,,3,2018-05-25T19:54:00Z,_m,SR,1\n,,3,2018-05-26T19:54:00Z,_m,SR,1\n,,3,2018-05-27T19:54:00Z,_m,SR,1\n,,3,2018-05-28T19:54:00Z,_m,SR,1\n,,3,2018-05-29T19:54:00Z,_m,SR,1\n,,3,2018-05-30T19:54:00Z,_m,SR,1\n,,3,2018-05-31T19:54:00Z,_m,SR,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   82,
					},
					File:   "month_day_time_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-01T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-02T19:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-03T19:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-04T19:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-05T19:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-06T19:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-07T19:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-08T19:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-09T19:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-10T19:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-11T19:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-12T19:53:50Z,12\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-13T19:54:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-14T19:54:10Z,14\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-15T19:54:20Z,15\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-16T19:53:00Z,16\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-17T19:53:10Z,17\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-18T19:53:20Z,18\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-19T19:53:30Z,19\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-20T19:53:40Z,20\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-21T19:53:50Z,21\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:54:00Z,22\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-23T19:54:00Z,23\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-24T19:54:00Z,24\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-25T19:54:00Z,25\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-26T19:54:00Z,26\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-27T19:54:00Z,27\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-28T19:54:00Z,28\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-29T19:54:00Z,29\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-30T19:54:00Z,30\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-31T19:54:00Z,31\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   46,
						},
						File:   "month_day_time_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   82,
						},
						File:   "month_day_time_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-01T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-02T19:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-03T19:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-04T19:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-05T19:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-06T19:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-07T19:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-08T19:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-09T19:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-10T19:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-11T19:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-12T19:53:50Z,12\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-13T19:54:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-14T19:54:10Z,14\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-15T19:54:20Z,15\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-16T19:53:00Z,16\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-17T19:53:10Z,17\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-18T19:53:20Z,18\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-19T19:53:30Z,19\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-20T19:53:40Z,20\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-21T19:53:50Z,21\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:54:00Z,22\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-23T19:54:00Z,23\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-24T19:54:00Z,24\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-25T19:54:00Z,25\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-26T19:54:00Z,26\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-27T19:54:00Z,27\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-28T19:54:00Z,28\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-29T19:54:00Z,29\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-30T19:54:00Z,30\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-31T19:54:00Z,31\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   46,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-01T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-02T19:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-03T19:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-04T19:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-05T19:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-06T19:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-07T19:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-08T19:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-09T19:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-10T19:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-11T19:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-12T19:53:50Z,12\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-13T19:54:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-14T19:54:10Z,14\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-15T19:54:20Z,15\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-16T19:53:00Z,16\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-17T19:53:10Z,17\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-18T19:53:20Z,18\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-19T19:53:30Z,19\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-20T19:53:40Z,20\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-21T19:53:50Z,21\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:54:00Z,22\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-23T19:54:00Z,23\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-24T19:54:00Z,24\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-25T19:54:00Z,25\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-26T19:54:00Z,26\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-27T19:54:00Z,27\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-28T19:54:00Z,28\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-29T19:54:00Z,29\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-30T19:54:00Z,30\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-31T19:54:00Z,31\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 67,
						Line:   87,
					},
					File:   "month_day_time_test.flux",
					Source: "t_time_month_day = (table=<-) =>\n\t(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.monthDay(t: r._time)})))",
					Start: ast.Position{
						Column: 1,
						Line:   84,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   84,
						},
						File:   "month_day_time_test.flux",
						Source: "t_time_month_day",
						Start: ast.Position{
							Column: 1,
							Line:   84,
						},
					},
				},
				Name: "t_time_month_day",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 67,
							Line:   87,
						},
						File:   "month_day_time_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.monthDay(t: r._time)})))",
						Start: ast.Position{
							Column: 20,
							Line:   84,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 67,
								Line:   87,
							},
							File:   "month_day_time_test.flux",
							Source: "(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.monthDay(t: r._time)})))",
							Start: ast.Position{
								Column: 2,
								Line:   85,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   85,
										},
										File:   "month_day_time_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   85,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   86,
									},
									File:   "month_day_time_test.flux",
									Source: "table\n\t    |> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   85,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   86,
											},
											File:   "month_day_time_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 15,
												Line:   86,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   86,
												},
												File:   "month_day_time_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 15,
													Line:   86,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   86,
													},
													File:   "month_day_time_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 15,
														Line:   86,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   86,
													},
													File:   "month_day_time_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 22,
														Line:   86,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   86,
										},
										File:   "month_day_time_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 9,
											Line:   86,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   86,
											},
											File:   "month_day_time_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 9,
												Line:   86,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   87,
								},
								File:   "month_day_time_test.flux",
								Source: "table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.monthDay(t: r._time)}))",
								Start: ast.Position{
									Column: 3,
									Line:   85,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   87,
										},
										File:   "month_day_time_test.flux",
										Source: "fn: (r) => ({r with _value: date.monthDay(t: r._time)})",
										Start: ast.Position{
											Column: 10,
											Line:   87,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   87,
											},
											File:   "month_day_time_test.flux",
											Source: "fn: (r) => ({r with _value: date.monthDay(t: r._time)})",
											Start: ast.Position{
												Column: 10,
												Line:   87,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   87,
												},
												File:   "month_day_time_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   87,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   87,
												},
												File:   "month_day_time_test.flux",
												Source: "(r) => ({r with _value: date.monthDay(t: r._time)})",
												Start: ast.Position{
													Column: 14,
													Line:   87,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 65,
														Line:   87,
													},
													File:   "month_day_time_test.flux",
													Source: "({r with _value: date.monthDay(t: r._time)})",
													Start: ast.Position{
														Column: 21,
														Line:   87,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   87,
														},
														File:   "month_day_time_test.flux",
														Source: "{r with _value: date.monthDay(t: r._time)}",
														Start: ast.Position{
															Column: 22,
															Line:   87,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 63,
																Line:   87,
															},
															File:   "month_day_time_test.flux",
															Source: "_value: date.monthDay(t: r._time)",
															Start: ast.Position{
																Column: 30,
																Line:   87,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   87,
																},
																File:   "month_day_time_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   87,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 62,
																		Line:   87,
																	},
																	File:   "month_day_time_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 52,
																		Line:   87,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 62,
																			Line:   87,
																		},
																		File:   "month_day_time_test.flux",
																		Source: "t: r._time",
																		Start: ast.Position{
																			Column: 52,
																			Line:   87,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 53,
																				Line:   87,
																			},
																			File:   "month_day_time_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 52,
																				Line:   87,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 62,
																				Line:   87,
																			},
																			File:   "month_day_time_test.flux",
																			Source: "r._time",
																			Start: ast.Position{
																				Column: 55,
																				Line:   87,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 56,
																					Line:   87,
																				},
																				File:   "month_day_time_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 55,
																					Line:   87,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 62,
																					Line:   87,
																				},
																				File:   "month_day_time_test.flux",
																				Source: "_time",
																				Start: ast.Position{
																					Column: 57,
																					Line:   87,
																				},
																			},
																		},
																		Name: "_time",
																	},
																	Rbrack: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 63,
																	Line:   87,
																},
																File:   "month_day_time_test.flux",
																Source: "date.monthDay(t: r._time)",
																Start: ast.Position{
																	Column: 38,
																	Line:   87,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 51,
																		Line:   87,
																	},
																	File:   "month_day_time_test.flux",
																	Source: "date.monthDay",
																	Start: ast.Position{
																		Column: 38,
																		Line:   87,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   87,
																		},
																		File:   "month_day_time_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   87,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 51,
																			Line:   87,
																		},
																		File:   "month_day_time_test.flux",
																		Source: "monthDay",
																		Start: ast.Position{
																			Column: 43,
																			Line:   87,
																		},
																	},
																},
																Name: "monthDay",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   87,
															},
															File:   "month_day_time_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   87,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   87,
													},
													File:   "month_day_time_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   87,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   87,
														},
														File:   "month_day_time_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   87,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   87,
									},
									File:   "month_day_time_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.monthDay(t: r._time)}))",
									Start: ast.Position{
										Column: 6,
										Line:   87,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   87,
										},
										File:   "month_day_time_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   87,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   84,
							},
							File:   "month_day_time_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   84,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   84,
								},
								File:   "month_day_time_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   84,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   84,
							},
							File:   "month_day_time_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   84,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 104,
							Line:   90,
						},
						File:   "month_day_time_test.flux",
						Source: "_time_month_day = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month_day})",
						Start: ast.Position{
							Column: 6,
							Line:   89,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   89,
							},
							File:   "month_day_time_test.flux",
							Source: "_time_month_day",
							Start: ast.Position{
								Column: 6,
								Line:   89,
							},
						},
					},
					Name: "_time_month_day",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 104,
								Line:   90,
							},
							File:   "month_day_time_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month_day})",
							Start: ast.Position{
								Column: 24,
								Line:   89,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 104,
									Line:   90,
								},
								File:   "month_day_time_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month_day})",
								Start: ast.Position{
									Column: 2,
									Line:   90,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 103,
										Line:   90,
									},
									File:   "month_day_time_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month_day}",
									Start: ast.Position{
										Column: 3,
										Line:   90,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   90,
										},
										File:   "month_day_time_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   90,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   90,
											},
											File:   "month_day_time_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   90,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   90,
												},
												File:   "month_day_time_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   90,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   90,
													},
													File:   "month_day_time_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   90,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   90,
														},
														File:   "month_day_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   90,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   90,
														},
														File:   "month_day_time_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   90,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   90,
											},
											File:   "month_day_time_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   90,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   90,
												},
												File:   "month_day_time_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   90,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   90,
													},
													File:   "month_day_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   90,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   90,
													},
													File:   "month_day_time_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   90,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   90,
										},
										File:   "month_day_time_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   90,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   90,
											},
											File:   "month_day_time_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   90,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   90,
												},
												File:   "month_day_time_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   90,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   90,
													},
													File:   "month_day_time_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   90,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   90,
														},
														File:   "month_day_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   90,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   90,
														},
														File:   "month_day_time_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   90,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   90,
											},
											File:   "month_day_time_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   90,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   90,
												},
												File:   "month_day_time_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   90,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   90,
													},
													File:   "month_day_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   90,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   90,
													},
													File:   "month_day_time_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   90,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 102,
											Line:   90,
										},
										File:   "month_day_time_test.flux",
										Source: "fn: t_time_month_day",
										Start: ast.Position{
											Column: 82,
											Line:   90,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   90,
											},
											File:   "month_day_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   90,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 102,
												Line:   90,
											},
											File:   "month_day_time_test.flux",
											Source: "t_time_month_day",
											Start: ast.Position{
												Column: 86,
												Line:   90,
											},
										},
									},
									Name: "t_time_month_day",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 104,
						Line:   90,
					},
					File:   "month_day_time_test.flux",
					Source: "test _time_month_day = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month_day})",
					Start: ast.Position{
						Column: 1,
						Line:   89,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "month_day_time_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "month_day_time_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "month_day_time_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "month_day_time_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "month_day_time_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "month_day_time_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "month_day_time_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 104,
					Line:   40,
				},
				File:   "month_duration_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"\n\nt_duration_month = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.month(t: duration(v : r._value))})))\n\ntest _duration_month = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "month_duration_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "month_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "month_duration_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "month_duration_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "month_duration_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "month_duration_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   19,
					},
					File:   "month_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "month_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   19,
						},
						File:   "month_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "month_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "month_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "month_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 79,
						Line:   37,
					},
					File:   "month_duration_test.flux",
					Source: "t_duration_month = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.month(t: duration(v : r._value))})))",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   34,
						},
						File:   "month_duration_test.flux",
						Source: "t_duration_month",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "t_duration_month",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 79,
							Line:   37,
						},
						File:   "month_duration_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.month(t: duration(v : r._value))})))",
						Start: ast.Position{
							Column: 20,
							Line:   34,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 79,
								Line:   37,
							},
							File:   "month_duration_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.month(t: duration(v : r._value))})))",
							Start: ast.Position{
								Column: 2,
								Line:   35,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   35,
										},
										File:   "month_duration_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   35,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   36,
									},
									File:   "month_duration_test.flux",
									Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   35,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   36,
											},
											File:   "month_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   36,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   36,
												},
												File:   "month_duration_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   36,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   36,
													},
													File:   "month_duration_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   36,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   36,
													},
													File:   "month_duration_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   36,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   36,
										},
										File:   "month_duration_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   36,
											},
											File:   "month_duration_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   36,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   37,
								},
								File:   "month_duration_test.flux",
								Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.month(t: duration(v : r._value))}))",
								Start: ast.Position{
									Column: 3,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   37,
										},
										File:   "month_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.month(t: duration(v : r._value))})",
										Start: ast.Position{
											Column: 10,
											Line:   37,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   37,
											},
											File:   "month_duration_test.flux",
											Source: "fn: (r) => ({r with _value: date.month(t: duration(v : r._value))})",
											Start: ast.Position{
												Column: 10,
												Line:   37,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   37,
												},
												File:   "month_duration_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   37,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 77,
													Line:   37,
												},
												File:   "month_duration_test.flux",
												Source: "(r) => ({r with _value: date.month(t: duration(v : r._value))})",
												Start: ast.Position{
													Column: 14,
													Line:   37,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 77,
														Line:   37,
													},
													File:   "month_duration_test.flux",
													Source: "({r with _value: date.month(t: duration(v : r._value))})",
													Start: ast.Position{
														Column: 21,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 76,
															Line:   37,
														},
														File:   "month_duration_test.flux",
														Source: "{r with _value: date.month(t: duration(v : r._value))}",
														Start: ast.Position{
															Column: 22,
															Line:   37,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 75,
																Line:   37,
															},
															File:   "month_duration_test.flux",
															Source: "_value: date.month(t: duration(v : r._value))",
															Start: ast.Position{
																Column: 30,
																Line:   37,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   37,
																},
																File:   "month_duration_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 74,
																		Line:   37,
																	},
																	File:   "month_duration_test.flux",
																	Source: "t: duration(v : r._value)",
																	Start: ast.Position{
																		Column: 49,
																		Line:   37,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 74,
																			Line:   37,
																		},
																		File:   "month_duration_test.flux",
																		Source: "t: duration(v : r._value)",
																		Start: ast.Position{
																			Column: 49,
																			Line:   37,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 50,
																				Line:   37,
																			},
																			File:   "month_duration_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 49,
																				Line:   37,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 73,
																					Line:   37,
																				},
																				File:   "month_duration_test.flux",
																				Source: "v : r._value",
																				Start: ast.Position{
																					Column: 61,
																					Line:   37,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 73,
																						Line:   37,
																					},
																					File:   "month_duration_test.flux",
																					Source: "v : r._value",
																					Start: ast.Position{
																						Column: 61,
																						Line:   37,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 62,
																							Line:   37,
																						},
																						File:   "month_duration_test.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 61,
																							Line:   37,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Separator: nil,
																			Value: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 73,
																							Line:   37,
																						},
																						File:   "month_duration_test.flux",
																						Source: "r._value",
																						Start: ast.Position{
																							Column: 65,
																							Line:   37,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 66,
																								Line:   37,
																							},
																							File:   "month_duration_test.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 65,
																								Line:   37,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 73,
																								Line:   37,
																							},
																							File:   "month_duration_test.flux",
																							Source: "_value",
																							Start: ast.Position{
																								Column: 67,
																								Line:   37,
																							},
																						},
																					},
																					Name: "_value",
																				},
																				Rbrack: nil,
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 74,
																				Line:   37,
																			},
																			File:   "month_duration_test.flux",
																			Source: "duration(v : r._value)",
																			Start: ast.Position{
																				Column: 52,
																				Line:   37,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 60,
																					Line:   37,
																				},
																				File:   "month_duration_test.flux",
																				Source: "duration",
																				Start: ast.Position{
																					Column: 52,
																					Line:   37,
																				},
																			},
																		},
																		Name: "duration",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 75,
																	Line:   37,
																},
																File:   "month_duration_test.flux",
																Source: "date.month(t: duration(v : r._value))",
																Start: ast.Position{
																	Column: 38,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   37,
																	},
																	File:   "month_duration_test.flux",
																	Source: "date.month",
																	Start: ast.Position{
																		Column: 38,
																		Line:   37,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   37,
																		},
																		File:   "month_duration_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   37,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 48,
																			Line:   37,
																		},
																		File:   "month_duration_test.flux",
																		Source: "month",
																		Start: ast.Position{
																			Column: 43,
																			Line:   37,
																		},
																	},
																},
																Name: "month",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   37,
															},
															File:   "month_duration_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   37,
													},
													File:   "month_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   37,
														},
														File:   "month_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   37,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   37,
									},
									File:   "month_duration_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.month(t: duration(v : r._value))}))",
									Start: ast.Position{
										Column: 6,
										Line:   37,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   37,
										},
										File:   "month_duration_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   37,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   34,
							},
							File:   "month_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   34,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   34,
								},
								File:   "month_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   34,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   34,
							},
							File:   "month_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   34,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 104,
							Line:   40,
						},
						File:   "month_duration_test.flux",
						Source: "_duration_month = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   39,
							},
							File:   "month_duration_test.flux",
							Source: "_duration_month",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_duration_month",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 104,
								Line:   40,
							},
							File:   "month_duration_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month})",
							Start: ast.Position{
								Column: 24,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 104,
									Line:   40,
								},
								File:   "month_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 103,
										Line:   40,
									},
									File:   "month_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "month_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "month_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   40,
												},
												File:   "month_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   40,
													},
													File:   "month_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   40,
														},
														File:   "month_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   40,
														},
														File:   "month_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "month_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   40,
												},
												File:   "month_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   40,
													},
													File:   "month_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   40,
													},
													File:   "month_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "month_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "month_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   40,
												},
												File:   "month_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   40,
													},
													File:   "month_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   40,
														},
														File:   "month_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   40,
														},
														File:   "month_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "month_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   40,
												},
												File:   "month_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   40,
													},
													File:   "month_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   40,
													},
													File:   "month_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 102,
											Line:   40,
										},
										File:   "month_duration_test.flux",
										Source: "fn: t_duration_month",
										Start: ast.Position{
											Column: 82,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   40,
											},
											File:   "month_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 102,
												Line:   40,
											},
											File:   "month_duration_test.flux",
											Source: "t_duration_month",
											Start: ast.Position{
												Column: 86,
												Line:   40,
											},
										},
									},
									Name: "t_duration_month",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 104,
						Line:   40,
					},
					File:   "month_duration_test.flux",
					Source: "test _duration_month = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "month_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "month_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "month_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "month_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "month_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "month_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "month_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 100,
					Line:   52,
				},
				File:   "month_time_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-01-22T19:53:00Z,_m,FF,1\n,,0,2018-02-22T19:53:10Z,_m,FF,1\n,,0,2018-03-22T19:53:20Z,_m,FF,1\n,,0,2018-04-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-06-22T19:53:50Z,_m,FF,1\n,,1,2018-07-22T19:53:00Z,_m,QQ,1\n,,1,2018-08-22T19:53:10Z,_m,QQ,1\n,,1,2018-09-22T19:53:20Z,_m,QQ,1\n,,1,2018-10-22T19:53:30Z,_m,QQ,1\n,,1,2018-11-22T19:53:40Z,_m,QQ,1\n,,1,2018-12-22T19:53:50Z,_m,QQ,1\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-01-22T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-02-22T19:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-03-22T19:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-04-22T19:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-06-22T19:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-07-22T19:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-08-22T19:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-09-22T19:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-10-22T19:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-11-22T19:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-12-22T19:53:50Z,12\n\"\n\nt_time_month = (table=<-) =>\n\t(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.month(t: r._time)})))\n\ntest _time_month = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "month_time_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "month_time_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "month_time_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "month_time_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "month_time_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "month_time_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   25,
					},
					File:   "month_time_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-01-22T19:53:00Z,_m,FF,1\n,,0,2018-02-22T19:53:10Z,_m,FF,1\n,,0,2018-03-22T19:53:20Z,_m,FF,1\n,,0,2018-04-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-06-22T19:53:50Z,_m,FF,1\n,,1,2018-07-22T19:53:00Z,_m,QQ,1\n,,1,2018-08-22T19:53:10Z,_m,QQ,1\n,,1,2018-09-22T19:53:20Z,_m,QQ,1\n,,1,2018-10-22T19:53:30Z,_m,QQ,1\n,,1,2018-11-22T19:53:40Z,_m,QQ,1\n,,1,2018-12-22T19:53:50Z,_m,QQ,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "month_time_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   25,
						},
						File:   "month_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-01-22T19:53:00Z,_m,FF,1\n,,0,2018-02-22T19:53:10Z,_m,FF,1\n,,0,2018-03-22T19:53:20Z,_m,FF,1\n,,0,2018-04-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-06-22T19:53:50Z,_m,FF,1\n,,1,2018-07-22T19:53:00Z,_m,QQ,1\n,,1,2018-08-22T19:53:10Z,_m,QQ,1\n,,1,2018-09-22T19:53:20Z,_m,QQ,1\n,,1,2018-10-22T19:53:30Z,_m,QQ,1\n,,1,2018-11-22T19:53:40Z,_m,QQ,1\n,,1,2018-12-22T19:53:50Z,_m,QQ,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-01-22T19:53:00Z,_m,FF,1\n,,0,2018-02-22T19:53:10Z,_m,FF,1\n,,0,2018-03-22T19:53:20Z,_m,FF,1\n,,0,2018-04-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-06-22T19:53:50Z,_m,FF,1\n,,1,2018-07-22T19:53:00Z,_m,QQ,1\n,,1,2018-08-22T19:53:10Z,_m,QQ,1\n,,1,2018-09-22T19:53:20Z,_m,QQ,1\n,,1,2018-10-22T19:53:30Z,_m,QQ,1\n,,1,2018-11-22T19:53:40Z,_m,QQ,1\n,,1,2018-12-22T19:53:50Z,_m,QQ,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "month_time_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-01-22T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-02-22T19:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-03-22T19:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-04-22T19:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-06-22T19:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-07-22T19:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-08-22T19:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-09-22T19:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-10-22T19:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-11-22T19:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-12-22T19:53:50Z,12\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   27,
						},
						File:   "month_time_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   27,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "month_time_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-01-22T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-02-22T19:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-03-22T19:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-04-22T19:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-06-22T19:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-07-22T19:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-08-22T19:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-09-22T19:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-10-22T19:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-11-22T19:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-12-22T19:53:50Z,12\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   27,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-01-22T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-02-22T19:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-03-22T19:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-04-22T19:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-06-22T19:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-07-22T19:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-08-22T19:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-09-22T19:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-10-22T19:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-11-22T19:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-12-22T19:53:50Z,12\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 64,
						Line:   49,
					},
					File:   "month_time_test.flux",
					Source: "t_time_month = (table=<-) =>\n\t(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.month(t: r._time)})))",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   46,
						},
						File:   "month_time_test.flux",
						Source: "t_time_month",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "t_time_month",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 64,
							Line:   49,
						},
						File:   "month_time_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.month(t: r._time)})))",
						Start: ast.Position{
							Column: 16,
							Line:   46,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   49,
							},
							File:   "month_time_test.flux",
							Source: "(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.month(t: r._time)})))",
							Start: ast.Position{
								Column: 2,
								Line:   47,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   47,
										},
										File:   "month_time_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   47,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   48,
									},
									File:   "month_time_test.flux",
									Source: "table\n\t    |> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   47,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   48,
											},
											File:   "month_time_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 15,
												Line:   48,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   48,
												},
												File:   "month_time_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 15,
													Line:   48,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   48,
													},
													File:   "month_time_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 15,
														Line:   48,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   48,
													},
													File:   "month_time_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 22,
														Line:   48,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   48,
										},
										File:   "month_time_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 9,
											Line:   48,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   48,
											},
											File:   "month_time_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 9,
												Line:   48,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   49,
								},
								File:   "month_time_test.flux",
								Source: "table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.month(t: r._time)}))",
								Start: ast.Position{
									Column: 3,
									Line:   47,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 62,
											Line:   49,
										},
										File:   "month_time_test.flux",
										Source: "fn: (r) => ({r with _value: date.month(t: r._time)})",
										Start: ast.Position{
											Column: 10,
											Line:   49,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 62,
												Line:   49,
											},
											File:   "month_time_test.flux",
											Source: "fn: (r) => ({r with _value: date.month(t: r._time)})",
											Start: ast.Position{
												Column: 10,
												Line:   49,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   49,
												},
												File:   "month_time_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   49,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 62,
													Line:   49,
												},
												File:   "month_time_test.flux",
												Source: "(r) => ({r with _value: date.month(t: r._time)})",
												Start: ast.Position{
													Column: 14,
													Line:   49,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 62,
														Line:   49,
													},
													File:   "month_time_test.flux",
													Source: "({r with _value: date.month(t: r._time)})",
													Start: ast.Position{
														Column: 21,
														Line:   49,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   49,
														},
														File:   "month_time_test.flux",
														Source: "{r with _value: date.month(t: r._time)}",
														Start: ast.Position{
															Column: 22,
															Line:   49,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 60,
																Line:   49,
															},
															File:   "month_time_test.flux",
															Source: "_value: date.month(t: r._time)",
															Start: ast.Position{
																Column: 30,
																Line:   49,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   49,
																},
																File:   "month_time_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   49,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 59,
																		Line:   49,
																	},
																	File:   "month_time_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 49,
																		Line:   49,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   49,
																		},
																		File:   "month_time_test.flux",
																		Source: "t: r._time",
																		Start: ast.Position{
																			Column: 49,
																			Line:   49,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 50,
																				Line:   49,
																			},
																			File:   "month_time_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 49,
																				Line:   49,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 59,
																				Line:   49,
																			},
																			File:   "month_time_test.flux",
																			Source: "r._time",
																			Start: ast.Position{
																				Column: 52,
																				Line:   49,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 53,
																					Line:   49,
																				},
																				File:   "month_time_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 52,
																					Line:   49,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 59,
																					Line:   49,
																				},
																				File:   "month_time_test.flux",
																				Source: "_time",
																				Start: ast.Position{
																					Column: 54,
																					Line:   49,
																				},
																			},
																		},
																		Name: "_time",
																	},
																	Rbrack: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 60,
																	Line:   49,
																},
																File:   "month_time_test.flux",
																Source: "date.month(t: r._time)",
																Start: ast.Position{
																	Column: 38,
																	Line:   49,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   49,
																	},
																	File:   "month_time_test.flux",
																	Source: "date.month",
																	Start: ast.Position{
																		Column: 38,
																		Line:   49,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   49,
																		},
																		File:   "month_time_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   49,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 48,
																			Line:   49,
																		},
																		File:   "month_time_test.flux",
																		Source: "month",
																		Start: ast.Position{
																			Column: 43,
																			Line:   49,
																		},
																	},
																},
																Name: "month",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   49,
															},
															File:   "month_time_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   49,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   49,
													},
													File:   "month_time_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   49,
														},
														File:   "month_time_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   49,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   49,
									},
									File:   "month_time_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.month(t: r._time)}))",
									Start: ast.Position{
										Column: 6,
										Line:   49,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   49,
										},
										File:   "month_time_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   49,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   46,
							},
							File:   "month_time_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 17,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   46,
								},
								File:   "month_time_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 17,
									Line:   46,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   46,
							},
							File:   "month_time_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 23,
								Line:   46,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 100,
							Line:   52,
						},
						File:   "month_time_test.flux",
						Source: "_time_month = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month})",
						Start: ast.Position{
							Column: 6,
							Line:   51,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   51,
							},
							File:   "month_time_test.flux",
							Source: "_time_month",
							Start: ast.Position{
								Column: 6,
								Line:   51,
							},
						},
					},
					Name: "_time_month",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 100,
								Line:   52,
							},
							File:   "month_time_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month})",
							Start: ast.Position{
								Column: 20,
								Line:   51,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   52,
								},
								File:   "month_time_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month})",
								Start: ast.Position{
									Column: 2,
									Line:   52,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   52,
									},
									File:   "month_time_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month}",
									Start: ast.Position{
										Column: 3,
										Line:   52,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   52,
										},
										File:   "month_time_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   52,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   52,
											},
											File:   "month_time_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   52,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   52,
												},
												File:   "month_time_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   52,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   52,
													},
													File:   "month_time_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   52,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   52,
														},
														File:   "month_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   52,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   52,
														},
														File:   "month_time_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   52,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   52,
											},
											File:   "month_time_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   52,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   52,
												},
												File:   "month_time_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   52,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   52,
													},
													File:   "month_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   52,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   52,
													},
													File:   "month_time_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   52,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   52,
										},
										File:   "month_time_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   52,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   52,
											},
											File:   "month_time_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   52,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   52,
												},
												File:   "month_time_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   52,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   52,
													},
													File:   "month_time_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   52,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   52,
														},
														File:   "month_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   52,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   52,
														},
														File:   "month_time_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   52,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   52,
											},
											File:   "month_time_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   52,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   52,
												},
												File:   "month_time_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   52,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   52,
													},
													File:   "month_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   52,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   52,
													},
													File:   "month_time_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   52,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   52,
										},
										File:   "month_time_test.flux",
										Source: "fn: t_time_month",
										Start: ast.Position{
											Column: 82,
											Line:   52,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   52,
											},
											File:   "month_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   52,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   52,
											},
											File:   "month_time_test.flux",
											Source: "t_time_month",
											Start: ast.Position{
												Column: 86,
												Line:   52,
											},
										},
									},
									Name: "t_time_month",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 100,
						Line:   52,
					},
					File:   "month_time_test.flux",
					Source: "test _time_month = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month})",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "month_time_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "month_time_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "month_time_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "month_time_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "month_time_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "month_time_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "month_time_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 105,
					Line:   40,
				},
				File:   "nanosecond_duration_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999999997\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999999998\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,2\n\"\n\nt_time_nanosecond = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.nanosecond(t: duration(v : r._value))})))\n\ntest _time_nanosecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "nanosecond_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "nanosecond_duration_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "nanosecond_duration_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "nanosecond_duration_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "nanosecond_duration_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   19,
					},
					File:   "nanosecond_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   19,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "nanosecond_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999999997\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999999998\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999999997\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999999998\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,2\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999999997\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999999998\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 84,
						Line:   37,
					},
					File:   "nanosecond_duration_test.flux",
					Source: "t_time_nanosecond = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.nanosecond(t: duration(v : r._value))})))",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   34,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "t_time_nanosecond",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "t_time_nanosecond",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 84,
							Line:   37,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.nanosecond(t: duration(v : r._value))})))",
						Start: ast.Position{
							Column: 21,
							Line:   34,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   37,
							},
							File:   "nanosecond_duration_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.nanosecond(t: duration(v : r._value))})))",
							Start: ast.Position{
								Column: 2,
								Line:   35,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   35,
										},
										File:   "nanosecond_duration_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   35,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   36,
									},
									File:   "nanosecond_duration_test.flux",
									Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   35,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   36,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   36,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   36,
												},
												File:   "nanosecond_duration_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   36,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   36,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   36,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   36,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   36,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   36,
										},
										File:   "nanosecond_duration_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   36,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   36,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   37,
								},
								File:   "nanosecond_duration_test.flux",
								Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.nanosecond(t: duration(v : r._value))}))",
								Start: ast.Position{
									Column: 3,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 82,
											Line:   37,
										},
										File:   "nanosecond_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.nanosecond(t: duration(v : r._value))})",
										Start: ast.Position{
											Column: 10,
											Line:   37,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 82,
												Line:   37,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "fn: (r) => ({r with _value: date.nanosecond(t: duration(v : r._value))})",
											Start: ast.Position{
												Column: 10,
												Line:   37,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   37,
												},
												File:   "nanosecond_duration_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   37,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 82,
													Line:   37,
												},
												File:   "nanosecond_duration_test.flux",
												Source: "(r) => ({r with _value: date.nanosecond(t: duration(v : r._value))})",
												Start: ast.Position{
													Column: 14,
													Line:   37,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   37,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "({r with _value: date.nanosecond(t: duration(v : r._value))})",
													Start: ast.Position{
														Column: 21,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 81,
															Line:   37,
														},
														File:   "nanosecond_duration_test.flux",
														Source: "{r with _value: date.nanosecond(t: duration(v : r._value))}",
														Start: ast.Position{
															Column: 22,
															Line:   37,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 80,
																Line:   37,
															},
															File:   "nanosecond_duration_test.flux",
															Source: "_value: date.nanosecond(t: duration(v : r._value))",
															Start: ast.Position{
																Column: 30,
																Line:   37,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   37,
																},
																File:   "nanosecond_duration_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 79,
																		Line:   37,
																	},
																	File:   "nanosecond_duration_test.flux",
																	Source: "t: duration(v : r._value)",
																	Start: ast.Position{
																		Column: 54,
																		Line:   37,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 79,
																			Line:   37,
																		},
																		File:   "nanosecond_duration_test.flux",
																		Source: "t: duration(v : r._value)",
																		Start: ast.Position{
																			Column: 54,
																			Line:   37,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 55,
																				Line:   37,
																			},
																			File:   "nanosecond_duration_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 54,
																				Line:   37,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 78,
																					Line:   37,
																				},
																				File:   "nanosecond_duration_test.flux",
																				Source: "v : r._value",
																				Start: ast.Position{
																					Column: 66,
																					Line:   37,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 78,
																						Line:   37,
																					},
																					File:   "nanosecond_duration_test.flux",
																					Source: "v : r._value",
																					Start: ast.Position{
																						Column: 66,
																						Line:   37,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 67,
																							Line:   37,
																						},
																						File:   "nanosecond_duration_test.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 66,
																							Line:   37,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Separator: nil,
																			Value: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 78,
																							Line:   37,
																						},
																						File:   "nanosecond_duration_test.flux",
																						Source: "r._value",
																						Start: ast.Position{
																							Column: 70,
																							Line:   37,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 71,
																								Line:   37,
																							},
																							File:   "nanosecond_duration_test.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 70,
																								Line:   37,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 78,
																								Line:   37,
																							},
																							File:   "nanosecond_duration_test.flux",
																							Source: "_value",
																							Start: ast.Position{
																								Column: 72,
																								Line:   37,
																							},
																						},
																					},
																					Name: "_value",
																				},
																				Rbrack: nil,
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 79,
																				Line:   37,
																			},
																			File:   "nanosecond_duration_test.flux",
																			Source: "duration(v : r._value)",
																			Start: ast.Position{
																				Column: 57,
																				Line:   37,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 65,
																					Line:   37,
																				},
																				File:   "nanosecond_duration_test.flux",
																				Source: "duration",
																				Start: ast.Position{
																					Column: 57,
																					Line:   37,
																				},
																			},
																		},
																		Name: "duration",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 80,
																	Line:   37,
																},
																File:   "nanosecond_duration_test.flux",
																Source: "date.nanosecond(t: duration(v : r._value))",
																Start: ast.Position{
																	Column: 38,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 53,
																		Line:   37,
																	},
																	File:   "nanosecond_duration_test.flux",
																	Source: "date.nanosecond",
																	Start: ast.Position{
																		Column: 38,
																		Line:   37,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   37,
																		},
																		File:   "nanosecond_duration_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   37,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 53,
																			Line:   37,
																		},
																		File:   "nanosecond_duration_test.flux",
																		Source: "nanosecond",
																		Start: ast.Position{
																			Column: 43,
																			Line:   37,
																		},
																	},
																},
																Name: "nanosecond",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   37,
															},
															File:   "nanosecond_duration_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   37,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   37,
														},
														File:   "nanosecond_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   37,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 83,
										Line:   37,
									},
									File:   "nanosecond_duration_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.nanosecond(t: duration(v : r._value))}))",
									Start: ast.Position{
										Column: 6,
										Line:   37,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   37,
										},
										File:   "nanosecond_duration_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   37,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   34,
							},
							File:   "nanosecond_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 22,
								Line:   34,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   34,
								},
								File:   "nanosecond_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 22,
									Line:   34,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   34,
							},
							File:   "nanosecond_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   34,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 105,
							Line:   40,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "_time_nanosecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   39,
							},
							File:   "nanosecond_duration_test.flux",
							Source: "_time_nanosecond",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_time_nanosecond",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 105,
								Line:   40,
							},
							File:   "nanosecond_duration_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
							Start: ast.Position{
								Column: 25,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   40,
								},
								File:   "nanosecond_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 104,
										Line:   40,
									},
									File:   "nanosecond_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "nanosecond_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   40,
												},
												File:   "nanosecond_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   40,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   40,
														},
														File:   "nanosecond_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   40,
														},
														File:   "nanosecond_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   40,
												},
												File:   "nanosecond_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   40,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   40,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "nanosecond_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   40,
												},
												File:   "nanosecond_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   40,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   40,
														},
														File:   "nanosecond_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   40,
														},
														File:   "nanosecond_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   40,
												},
												File:   "nanosecond_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   40,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   40,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 103,
											Line:   40,
										},
										File:   "nanosecond_duration_test.flux",
										Source: "fn: t_time_nanosecond",
										Start: ast.Position{
											Column: 82,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   40,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 103,
												Line:   40,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "t_time_nanosecond",
											Start: ast.Position{
												Column: 86,
												Line:   40,
											},
										},
									},
									Name: "t_time_nanosecond",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 105,
						Line:   40,
					},
					File:   "nanosecond_duration_test.flux",
					Source: "test _time_nanosecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "nanosecond_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "nanosecond_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "nanosecond_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "nanosecond_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 105,
					Line:   58,
				},
				File:   "nanosecond_time_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254819212\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748691723\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947182316\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538816341\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676423456\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982342357\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819823471\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587284314\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984375238\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723847562\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192983472\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712938413\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062103483\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786432256\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823748524\n\"\n\nt_time_nanosecond = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.nanosecond(t: r._time)})))\n\ntest _time_nanosecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "nanosecond_time_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "nanosecond_time_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "nanosecond_time_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "nanosecond_time_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "nanosecond_time_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "nanosecond_time_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   28,
					},
					File:   "nanosecond_time_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "nanosecond_time_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   28,
						},
						File:   "nanosecond_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   50,
					},
					File:   "nanosecond_time_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254819212\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748691723\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947182316\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538816341\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676423456\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982342357\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819823471\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587284314\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984375238\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723847562\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192983472\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712938413\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062103483\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786432256\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823748524\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   30,
						},
						File:   "nanosecond_time_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   50,
						},
						File:   "nanosecond_time_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254819212\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748691723\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947182316\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538816341\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676423456\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982342357\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819823471\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587284314\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984375238\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723847562\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192983472\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712938413\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062103483\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786432256\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823748524\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   30,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254819212\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748691723\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947182316\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538816341\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676423456\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982342357\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819823471\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587284314\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984375238\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723847562\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192983472\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712938413\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062103483\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786432256\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823748524\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 69,
						Line:   55,
					},
					File:   "nanosecond_time_test.flux",
					Source: "t_time_nanosecond = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.nanosecond(t: r._time)})))",
					Start: ast.Position{
						Column: 1,
						Line:   52,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   52,
						},
						File:   "nanosecond_time_test.flux",
						Source: "t_time_nanosecond",
						Start: ast.Position{
							Column: 1,
							Line:   52,
						},
					},
				},
				Name: "t_time_nanosecond",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 69,
							Line:   55,
						},
						File:   "nanosecond_time_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.nanosecond(t: r._time)})))",
						Start: ast.Position{
							Column: 21,
							Line:   52,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 69,
								Line:   55,
							},
							File:   "nanosecond_time_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.nanosecond(t: r._time)})))",
							Start: ast.Position{
								Column: 2,
								Line:   53,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   53,
										},
										File:   "nanosecond_time_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   53,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   54,
									},
									File:   "nanosecond_time_test.flux",
									Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   53,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   54,
											},
											File:   "nanosecond_time_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   54,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   54,
												},
												File:   "nanosecond_time_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   54,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   54,
													},
													File:   "nanosecond_time_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   54,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   54,
													},
													File:   "nanosecond_time_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   54,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   54,
										},
										File:   "nanosecond_time_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   54,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   54,
											},
											File:   "nanosecond_time_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   54,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   55,
								},
								File:   "nanosecond_time_test.flux",
								Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.nanosecond(t: r._time)}))",
								Start: ast.Position{
									Column: 3,
									Line:   53,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   55,
										},
										File:   "nanosecond_time_test.flux",
										Source: "fn: (r) => ({r with _value: date.nanosecond(t: r._time)})",
										Start: ast.Position{
											Column: 10,
											Line:   55,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   55,
											},
											File:   "nanosecond_time_test.flux",
											Source: "fn: (r) => ({r with _value: date.nanosecond(t: r._time)})",
											Start: ast.Position{
												Column: 10,
												Line:   55,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   55,
												},
												File:   "nanosecond_time_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   55,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   55,
												},
												File:   "nanosecond_time_test.flux",
												Source: "(r) => ({r with _value: date.nanosecond(t: r._time)})",
												Start: ast.Position{
													Column: 14,
													Line:   55,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   55,
													},
													File:   "nanosecond_time_test.flux",
													Source: "({r with _value: date.nanosecond(t: r._time)})",
													Start: ast.Position{
														Column: 21,
														Line:   55,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 66,
															Line:   55,
														},
														File:   "nanosecond_time_test.flux",
														Source: "{r with _value: date.nanosecond(t: r._time)}",
														Start: ast.Position{
															Column: 22,
															Line:   55,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 65,
																Line:   55,
															},
															File:   "nanosecond_time_test.flux",
															Source: "_value: date.nanosecond(t: r._time)",
															Start: ast.Position{
																Column: 30,
																Line:   55,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   55,
																},
																File:   "nanosecond_time_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   55,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 64,
																		Line:   55,
																	},
																	File:   "nanosecond_time_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 54,
																		Line:   55,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 64,
																			Line:   55,
																		},
																		File:   "nanosecond_time_test.flux",
																		Source: "t: r._time",
																		Start: ast.Position{
																			Column: 54,
																			Line:   55,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 55,
																				Line:   55,
																			},
																			File:   "nanosecond_time_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 54,
																				Line:   55,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 64,
																				Line:   55,
																			},
																			File:   "nanosecond_time_test.flux",
																			Source: "r._time",
																			Start: ast.Position{
																				Column: 57,
																				Line:   55,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 58,
																					Line:   55,
																				},
																				File:   "nanosecond_time_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 57,
																					Line:   55,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 64,
																					Line:   55,
																				},
																				File:   "nanosecond_time_test.flux",
																				Source: "_time",
																				Start: ast.Position{
																					Column: 59,
																					Line:   55,
																				},
																			},
																		},
																		Name: "_time",
																	},
																	Rbrack: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 65,
																	Line:   55,
																},
																File:   "nanosecond_time_test.flux",
																Source: "date.nanosecond(t: r._time)",
																Start: ast.Position{
																	Column: 38,
																	Line:   55,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 53,
																		Line:   55,
																	},
																	File:   "nanosecond_time_test.flux",
																	Source: "date.nanosecond",
																	Start: ast.Position{
																		Column: 38,
																		Line:   55,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   55,
																		},
																		File:   "nanosecond_time_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   55,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 53,
																			Line:   55,
																		},
																		File:   "nanosecond_time_test.flux",
																		Source: "nanosecond",
																		Start: ast.Position{
																			Column: 43,
																			Line:   55,
																		},
																	},
																},
																Name: "nanosecond",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   55,
															},
															File:   "nanosecond_time_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   55,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   55,
													},
													File:   "nanosecond_time_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   55,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   55,
														},
														File:   "nanosecond_time_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   55,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   55,
									},
									File:   "nanosecond_time_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.nanosecond(t: r._time)}))",
									Start: ast.Position{
										Column: 6,
										Line:   55,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   55,
										},
										File:   "nanosecond_time_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   55,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   52,
							},
							File:   "nanosecond_time_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 22,
								Line:   52,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   52,
								},
								File:   "nanosecond_time_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 22,
									Line:   52,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   52,
							},
							File:   "nanosecond_time_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   52,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 105,
							Line:   58,
						},
						File:   "nanosecond_time_test.flux",
						Source: "_time_nanosecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
						Start: ast.Position{
							Column: 6,
							Line:   57,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   57,
							},
							File:   "nanosecond_time_test.flux",
							Source: "_time_nanosecond",
							Start: ast.Position{
								Column: 6,
								Line:   57,
							},
						},
					},
					Name: "_time_nanosecond",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 105,
								Line:   58,
							},
							File:   "nanosecond_time_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
							Start: ast.Position{
								Column: 25,
								Line:   57,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   58,
								},
								File:   "nanosecond_time_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
								Start: ast.Position{
									Column: 2,
									Line:   58,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 104,
										Line:   58,
									},
									File:   "nanosecond_time_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond}",
									Start: ast.Position{
										Column: 3,
										Line:   58,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   58,
										},
										File:   "nanosecond_time_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   58,
											},
											File:   "nanosecond_time_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   58,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   58,
												},
												File:   "nanosecond_time_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   58,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   58,
													},
													File:   "nanosecond_time_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   58,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   58,
														},
														File:   "nanosecond_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   58,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   58,
														},
														File:   "nanosecond_time_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   58,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   58,
											},
											File:   "nanosecond_time_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   58,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   58,
												},
												File:   "nanosecond_time_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   58,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   58,
													},
													File:   "nanosecond_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   58,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   58,
													},
													File:   "nanosecond_time_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   58,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   58,
										},
										File:   "nanosecond_time_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   58,
											},
											File:   "nanosecond_time_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   58,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   58,
												},
												File:   "nanosecond_time_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   58,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   58,
													},
													File:   "nanosecond_time_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   58,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   58,
														},
														File:   "nanosecond_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   58,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   58,
														},
														File:   "nanosecond_time_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   58,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   58,
											},
											File:   "nanosecond_time_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   58,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   58,
												},
												File:   "nanosecond_time_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   58,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   58,
													},
													File:   "nanosecond_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   58,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   58,
													},
													File:   "nanosecond_time_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   58,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 103,
											Line:   58,
										},
										File:   "nanosecond_time_test.flux",
										Source: "fn: t_time_nanosecond",
										Start: ast.Position{
											Column: 82,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   58,
											},
											File:   "nanosecond_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   58,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 103,
												Line:   58,
											},
											File:   "nanosecond_time_test.flux",
											Source: "t_time_nanosecond",
											Start: ast.Position{
												Column: 86,
												Line:   58,
											},
										},
									},
									Name: "t_time_nanosecond",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 105,
						Line:   58,
					},
					File:   "nanosecond_time_test.flux",
					Source: "test _time_nanosecond = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
					Start: ast.Position{
						Column: 1,
						Line:   57,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "nanosecond_time_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "nanosecond_time_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "nanosecond_time_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "nanosecond_time_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "nanosecond_time_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "nanosecond_time_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "nanosecond_time_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 106,
					Line:   40,
				},
				File:   "quarter_duration_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"\n\nt_duration_quarter = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.quarter(t: duration(v : r._value))})))\n\ntest _duration_quarter = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_quarter})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "quarter_duration_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "quarter_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "quarter_duration_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "quarter_duration_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "quarter_duration_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "quarter_duration_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   19,
					},
					File:   "quarter_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "quarter_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   19,
						},
						File:   "quarter_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "quarter_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "quarter_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "quarter_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 81,
						Line:   37,
					},
					File:   "quarter_duration_test.flux",
					Source: "t_duration_quarter = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.quarter(t: duration(v : r._value))})))",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   34,
						},
						File:   "quarter_duration_test.flux",
						Source: "t_duration_quarter",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "t_duration_quarter",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   37,
						},
						File:   "quarter_duration_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.quarter(t: duration(v : r._value))})))",
						Start: ast.Position{
							Column: 22,
							Line:   34,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   37,
							},
							File:   "quarter_duration_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.quarter(t: duration(v : r._value))})))",
							Start: ast.Position{
								Column: 2,
								Line:   35,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   35,
										},
										File:   "quarter_duration_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   35,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   36,
									},
									File:   "quarter_duration_test.flux",
									Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   35,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   36,
											},
											File:   "quarter_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   36,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   36,
												},
												File:   "quarter_duration_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   36,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   36,
													},
													File:   "quarter_duration_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   36,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   36,
													},
													File:   "quarter_duration_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   36,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   36,
										},
										File:   "quarter_duration_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   36,
											},
											File:   "quarter_duration_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   36,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 80,
									Line:   37,
								},
								File:   "quarter_duration_test.flux",
								Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.quarter(t: duration(v : r._value))}))",
								Start: ast.Position{
									Column: 3,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 79,
											Line:   37,
										},
										File:   "quarter_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.quarter(t: duration(v : r._value))})",
										Start: ast.Position{
											Column: 10,
											Line:   37,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 79,
												Line:   37,
											},
											File:   "quarter_duration_test.flux",
											Source: "fn: (r) => ({r with _value: date.quarter(t: duration(v : r._value))})",
											Start: ast.Position{
												Column: 10,
												Line:   37,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   37,
												},
												File:   "quarter_duration_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   37,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   37,
												},
												File:   "quarter_duration_test.flux",
												Source: "(r) => ({r with _value: date.quarter(t: duration(v : r._value))})",
												Start: ast.Position{
													Column: 14,
													Line:   37,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   37,
													},
													File:   "quarter_duration_test.flux",
													Source: "({r with _value: date.quarter(t: duration(v : r._value))})",
													Start: ast.Position{
														Column: 21,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   37,
														},
														File:   "quarter_duration_test.flux",
														Source: "{r with _value: date.quarter(t: duration(v : r._value))}",
														Start: ast.Position{
															Column: 22,
															Line:   37,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   37,
															},
															File:   "quarter_duration_test.flux",
															Source: "_value: date.quarter(t: duration(v : r._value))",
															Start: ast.Position{
																Column: 30,
																Line:   37,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   37,
																},
																File:   "quarter_duration_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 76,
																		Line:   37,
																	},
																	File:   "quarter_duration_test.flux",
																	Source: "t: duration(v : r._value)",
																	Start: ast.Position{
																		Column: 51,
																		Line:   37,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 76,
																			Line:   37,
																		},
																		File:   "quarter_duration_test.flux",
																		Source: "t: duration(v : r._value)",
																		Start: ast.Position{
																			Column: 51,
																			Line:   37,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 52,
																				Line:   37,
																			},
																			File:   "quarter_duration_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 51,
																				Line:   37,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 75,
																					Line:   37,
																				},
																				File:   "quarter_duration_test.flux",
																				Source: "v : r._value",
																				Start: ast.Position{
																					Column: 63,
																					Line:   37,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 75,
																						Line:   37,
																					},
																					File:   "quarter_duration_test.flux",
																					Source: "v : r._value",
																					Start: ast.Position{
																						Column: 63,
																						Line:   37,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 64,
																							Line:   37,
																						},
																						File:   "quarter_duration_test.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 63,
																							Line:   37,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Separator: nil,
																			Value: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 75,
																							Line:   37,
																						},
																						File:   "quarter_duration_test.flux",
																						Source: "r._value",
																						Start: ast.Position{
																							Column: 67,
																							Line:   37,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 68,
																								Line:   37,
																							},
																							File:   "quarter_duration_test.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 67,
																								Line:   37,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 75,
																								Line:   37,
																							},
																							File:   "quarter_duration_test.flux",
																							Source: "_value",
																							Start: ast.Position{
																								Column: 69,
																								Line:   37,
																							},
																						},
																					},
																					Name: "_value",
																				},
																				Rbrack: nil,
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 76,
																				Line:   37,
																			},
																			File:   "quarter_duration_test.flux",
																			Source: "duration(v : r._value)",
																			Start: ast.Position{
																				Column: 54,
																				Line:   37,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 62,
																					Line:   37,
																				},
																				File:   "quarter_duration_test.flux",
																				Source: "duration",
																				Start: ast.Position{
																					Column: 54,
																					Line:   37,
																				},
																			},
																		},
																		Name: "duration",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   37,
																},
																File:   "quarter_duration_test.flux",
																Source: "date.quarter(t: duration(v : r._value))",
																Start: ast.Position{
																	Column: 38,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 50,
																		Line:   37,
																	},
																	File:   "quarter_duration_test.flux",
																	Source: "date.quarter",
																	Start: ast.Position{
																		Column: 38,
																		Line:   37,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   37,
																		},
																		File:   "quarter_duration_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   37,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 50,
																			Line:   37,
																		},
																		File:   "quarter_duration_test.flux",
																		Source: "quarter",
																		Start: ast.Position{
																			Column: 43,
																			Line:   37,
																		},
																	},
																},
																Name: "quarter",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   37,
															},
															File:   "quarter_duration_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   37,
													},
													File:   "quarter_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   37,
														},
														File:   "quarter_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   37,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 80,
										Line:   37,
									},
									File:   "quarter_duration_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.quarter(t: duration(v : r._value))}))",
									Start: ast.Position{
										Column: 6,
										Line:   37,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   37,
										},
										File:   "quarter_duration_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   37,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   34,
							},
							File:   "quarter_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 23,
								Line:   34,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   34,
								},
								File:   "quarter_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 23,
									Line:   34,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   34,
							},
							File:   "quarter_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 29,
								Line:   34,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 106,
							Line:   40,
						},
						File:   "quarter_duration_test.flux",
						Source: "_duration_quarter = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_quarter})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   39,
							},
							File:   "quarter_duration_test.flux",
							Source: "_duration_quarter",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_duration_quarter",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 106,
								Line:   40,
							},
							File:   "quarter_duration_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_quarter})",
							Start: ast.Position{
								Column: 26,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 106,
									Line:   40,
								},
								File:   "quarter_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_quarter})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 105,
										Line:   40,
									},
									File:   "quarter_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_quarter}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "quarter_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "quarter_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   40,
												},
												File:   "quarter_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   40,
													},
													File:   "quarter_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   40,
														},
														File:   "quarter_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   40,
														},
														File:   "quarter_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "quarter_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   40,
												},
												File:   "quarter_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   40,
													},
													File:   "quarter_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   40,
													},
													File:   "quarter_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "quarter_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "quarter_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   40,
												},
												File:   "quarter_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   40,
													},
													File:   "quarter_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   40,
														},
														File:   "quarter_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   40,
														},
														File:   "quarter_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "quarter_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   40,
												},
												File:   "quarter_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   40,
													},
													File:   "quarter_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   40,
													},
													File:   "quarter_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 104,
											Line:   40,
										},
										File:   "quarter_duration_test.flux",
										Source: "fn: t_duration_quarter",
										Start: ast.Position{
											Column: 82,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   40,
											},
											File:   "quarter_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 104,
												Line:   40,
											},
											File:   "quarter_duration_test.flux",
											Source: "t_duration_quarter",
											Start: ast.Position{
												Column: 86,
												Line:   40,
											},
										},
									},
									Name: "t_duration_quarter",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 106,
						Line:   40,
					},
					File:   "quarter_duration_test.flux",
					Source: "test _duration_quarter = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_quarter})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "quarter_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "quarter_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "quarter_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "quarter_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "quarter_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "quarter_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "quarter_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 102,
					Line:   52,
				},
				File:   "quarter_time_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-01-22T19:53:00Z,_m,FF,1\n,,0,2018-02-22T19:53:10Z,_m,FF,1\n,,0,2018-03-22T19:53:20Z,_m,FF,1\n,,0,2018-04-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-06-22T19:53:50Z,_m,FF,1\n,,1,2018-07-22T19:53:00Z,_m,QQ,1\n,,1,2018-08-22T19:53:10Z,_m,QQ,1\n,,1,2018-09-22T19:53:20Z,_m,QQ,1\n,,1,2018-10-22T19:53:30Z,_m,QQ,1\n,,1,2018-11-22T19:53:40Z,_m,QQ,1\n,,1,2018-12-22T19:53:50Z,_m,QQ,1\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-01-22T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-02-22T19:53:10Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-03-22T19:53:20Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-04-22T19:53:30Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-06-22T19:53:50Z,2\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-07-22T19:53:00Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-08-22T19:53:10Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-09-22T19:53:20Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-10-22T19:53:30Z,4\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-11-22T19:53:40Z,4\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-12-22T19:53:50Z,4\n\"\n\nt_time_quarter = (table=<-) =>\n\t(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.quarter(t: r._time)})))\n\ntest _time_quarter = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_quarter})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "quarter_time_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "quarter_time_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "quarter_time_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "quarter_time_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "quarter_time_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "quarter_time_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   25,
					},
					File:   "quarter_time_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-01-22T19:53:00Z,_m,FF,1\n,,0,2018-02-22T19:53:10Z,_m,FF,1\n,,0,2018-03-22T19:53:20Z,_m,FF,1\n,,0,2018-04-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-06-22T19:53:50Z,_m,FF,1\n,,1,2018-07-22T19:53:00Z,_m,QQ,1\n,,1,2018-08-22T19:53:10Z,_m,QQ,1\n,,1,2018-09-22T19:53:20Z,_m,QQ,1\n,,1,2018-10-22T19:53:30Z,_m,QQ,1\n,,1,2018-11-22T19:53:40Z,_m,QQ,1\n,,1,2018-12-22T19:53:50Z,_m,QQ,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "quarter_time_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   25,
						},
						File:   "quarter_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-01-22T19:53:00Z,_m,FF,1\n,,0,2018-02-22T19:53:10Z,_m,FF,1\n,,0,2018-03-22T19:53:20Z,_m,FF,1\n,,0,2018-04-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-06-22T19:53:50Z,_m,FF,1\n,,1,2018-07-22T19:53:00Z,_m,QQ,1\n,,1,2018-08-22T19:53:10Z,_m,QQ,1\n,,1,2018-09-22T19:53:20Z,_m,QQ,1\n,,1,2018-10-22T19:53:30Z,_m,QQ,1\n,,1,2018-11-22T19:53:40Z,_m,QQ,1\n,,1,2018-12-22T19:53:50Z,_m,QQ,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-01-22T19:53:00Z,_m,FF,1\n,,0,2018-02-22T19:53:10Z,_m,FF,1\n,,0,2018-03-22T19:53:20Z,_m,FF,1\n,,0,2018-04-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-06-22T19:53:50Z,_m,FF,1\n,,1,2018-07-22T19:53:00Z,_m,QQ,1\n,,1,2018-08-22T19:53:10Z,_m,QQ,1\n,,1,2018-09-22T19:53:20Z,_m,QQ,1\n,,1,2018-10-22T19:53:30Z,_m,QQ,1\n,,1,2018-11-22T19:53:40Z,_m,QQ,1\n,,1,2018-12-22T19:53:50Z,_m,QQ,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "quarter_time_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-01-22T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-02-22T19:53:10Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-03-22T19:53:20Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-04-22T19:53:30Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-06-22T19:53:50Z,2\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-07-22T19:53:00Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-08-22T19:53:10Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-09-22T19:53:20Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-10-22T19:53:30Z,4\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-11-22T19:53:40Z,4\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-12-22T19:53:50Z,4\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   27,
						},
						File:   "quarter_time_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   27,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "quarter_time_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-01-22T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-02-22T19:53:10Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-03-22T19:53:20Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-04-22T19:53:30Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-06-22T19:53:50Z,2\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-07-22T19:53:00Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-08-22T19:53:10Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-09-22T19:53:20Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-10-22T19:53:30Z,4\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-11-22T19:53:40Z,4\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-12-22T19:53:50Z,4\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   27,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-01-22T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-02-22T19:53:10Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-03-22T19:53:20Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-04-22T19:53:30Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-06-22T19:53:50Z,2\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-07-22T19:53:00Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-08-22T19:53:10Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-09-22T19:53:20Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-10-22T19:53:30Z,4\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-11-22T19:53:40Z,4\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-12-22T19:53:50Z,4\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 66,
						Line:   49,
					},
					File:   "quarter_time_test.flux",
					Source: "t_time_quarter = (table=<-) =>\n\t(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.quarter(t: r._time)})))",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   46,
						},
						File:   "quarter_time_test.flux",
						Source: "t_time_quarter",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "t_time_quarter",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 66,
							Line:   49,
						},
						File:   "quarter_time_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.quarter(t: r._time)})))",
						Start: ast.Position{
							Column: 18,
							Line:   46,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   49,
							},
							File:   "quarter_time_test.flux",
							Source: "(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.quarter(t: r._time)})))",
							Start: ast.Position{
								Column: 2,
								Line:   47,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   47,
										},
										File:   "quarter_time_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   47,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   48,
									},
									File:   "quarter_time_test.flux",
									Source: "table\n\t    |> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   47,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   48,
											},
											File:   "quarter_time_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 15,
												Line:   48,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   48,
												},
												File:   "quarter_time_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 15,
													Line:   48,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   48,
													},
													File:   "quarter_time_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 15,
														Line:   48,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   48,
													},
													File:   "quarter_time_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 22,
														Line:   48,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   48,
										},
										File:   "quarter_time_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 9,
											Line:   48,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   48,
											},
											File:   "quarter_time_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 9,
												Line:   48,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   49,
								},
								File:   "quarter_time_test.flux",
								Source: "table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.quarter(t: r._time)}))",
								Start: ast.Position{
									Column: 3,
									Line:   47,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   49,
										},
										File:   "quarter_time_test.flux",
										Source: "fn: (r) => ({r with _value: date.quarter(t: r._time)})",
										Start: ast.Position{
											Column: 10,
											Line:   49,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 64,
												Line:   49,
											},
											File:   "quarter_time_test.flux",
											Source: "fn: (r) => ({r with _value: date.quarter(t: r._time)})",
											Start: ast.Position{
												Column: 10,
												Line:   49,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   49,
												},
												File:   "quarter_time_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   49,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 64,
													Line:   49,
												},
												File:   "quarter_time_test.flux",
												Source: "(r) => ({r with _value: date.quarter(t: r._time)})",
												Start: ast.Position{
													Column: 14,
													Line:   49,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   49,
													},
													File:   "quarter_time_test.flux",
													Source: "({r with _value: date.quarter(t: r._time)})",
													Start: ast.Position{
														Column: 21,
														Line:   49,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   49,
														},
														File:   "quarter_time_test.flux",
														Source: "{r with _value: date.quarter(t: r._time)}",
														Start: ast.Position{
															Column: 22,
															Line:   49,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 62,
																Line:   49,
															},
															File:   "quarter_time_test.flux",
															Source: "_value: date.quarter(t: r._time)",
															Start: ast.Position{
																Column: 30,
																Line:   49,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   49,
																},
																File:   "quarter_time_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   49,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 61,
																		Line:   49,
																	},
																	File:   "quarter_time_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 51,
																		Line:   49,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 61,
																			Line:   49,
																		},
																		File:   "quarter_time_test.flux",
																		Source: "t: r._time",
																		Start: ast.Position{
																			Column: 51,
																			Line:   49,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 52,
																				Line:   49,
																			},
																			File:   "quarter_time_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 51,
																				Line:   49,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 61,
																				Line:   49,
																			},
																			File:   "quarter_time_test.flux",
																			Source: "r._time",
																			Start: ast.Position{
																				Column: 54,
																				Line:   49,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 55,
																					Line:   49,
																				},
																				File:   "quarter_time_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 54,
																					Line:   49,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 61,
																					Line:   49,
																				},
																				File:   "quarter_time_test.flux",
																				Source: "_time",
																				Start: ast.Position{
																					Column: 56,
																					Line:   49,
																				},
																			},
																		},
																		Name: "_time",
																	},
																	Rbrack: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 62,
																	Line:   49,
																},
																File:   "quarter_time_test.flux",
																Source: "date.quarter(t: r._time)",
																Start: ast.Position{
																	Column: 38,
																	Line:   49,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 50,
																		Line:   49,
																	},
																	File:   "quarter_time_test.flux",
																	Source: "date.quarter",
																	Start: ast.Position{
																		Column: 38,
																		Line:   49,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   49,
																		},
																		File:   "quarter_time_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   49,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 50,
																			Line:   49,
																		},
																		File:   "quarter_time_test.flux",
																		Source: "quarter",
																		Start: ast.Position{
																			Column: 43,
																			Line:   49,
																		},
																	},
																},
																Name: "quarter",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   49,
															},
															File:   "quarter_time_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   49,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   49,
													},
													File:   "quarter_time_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   49,
														},
														File:   "quarter_time_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   49,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   49,
									},
									File:   "quarter_time_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.quarter(t: r._time)}))",
									Start: ast.Position{
										Column: 6,
										Line:   49,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   49,
										},
										File:   "quarter_time_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   49,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   46,
							},
							File:   "quarter_time_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 19,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   46,
								},
								File:   "quarter_time_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 19,
									Line:   46,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   46,
							},
							File:   "quarter_time_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 25,
								Line:   46,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 102,
							Line:   52,
						},
						File:   "quarter_time_test.flux",
						Source: "_time_quarter = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_quarter})",
						Start: ast.Position{
							Column: 6,
							Line:   51,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   51,
							},
							File:   "quarter_time_test.flux",
							Source: "_time_quarter",
							Start: ast.Position{
								Column: 6,
								Line:   51,
							},
						},
					},
					Name: "_time_quarter",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   52,
							},
							File:   "quarter_time_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_quarter})",
							Start: ast.Position{
								Column: 22,
								Line:   51,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   52,
								},
								File:   "quarter_time_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_quarter})",
								Start: ast.Position{
									Column: 2,
									Line:   52,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 101,
										Line:   52,
									},
									File:   "quarter_time_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_quarter}",
									Start: ast.Position{
										Column: 3,
										Line:   52,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   52,
										},
										File:   "quarter_time_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   52,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   52,
											},
											File:   "quarter_time_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   52,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   52,
												},
												File:   "quarter_time_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   52,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   52,
													},
													File:   "quarter_time_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   52,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   52,
														},
														File:   "quarter_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   52,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   52,
														},
														File:   "quarter_time_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   52,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   52,
											},
											File:   "quarter_time_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   52,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   52,
												},
												File:   "quarter_time_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   52,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   52,
													},
													File:   "quarter_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   52,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   52,
													},
													File:   "quarter_time_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   52,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   52,
										},
										File:   "quarter_time_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   52,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   52,
											},
											File:   "quarter_time_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   52,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   52,
												},
												File:   "quarter_time_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   52,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   52,
													},
													File:   "quarter_time_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   52,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   52,
														},
														File:   "quarter_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   52,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   52,
														},
														File:   "quarter_time_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   52,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   52,
											},
											File:   "quarter_time_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   52,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   52,
												},
												File:   "quarter_time_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   52,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   52,
													},
													File:   "quarter_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   52,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   52,
													},
													File:   "quarter_time_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   52,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 100,
											Line:   52,
										},
										File:   "quarter_time_test.flux",
										Source: "fn: t_time_quarter",
										Start: ast.Position{
											Column: 82,
											Line:   52,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   52,
											},
											File:   "quarter_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   52,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 100,
												Line:   52,
											},
											File:   "quarter_time_test.flux",
											Source: "t_time_quarter",
											Start: ast.Position{
												Column: 86,
												Line:   52,
											},
										},
									},
									Name: "t_time_quarter",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 102,
						Line:   52,
					},
					File:   "quarter_time_test.flux",
					Source: "test _time_quarter = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_quarter})",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "quarter_time_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "quarter_time_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "quarter_time_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "quarter_time_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "quarter_time_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "quarter_time_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "quarter_time_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 105,
					Line:   40,
				},
				File:   "second_duration_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"\n\nt_duration_second = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.second(t: duration(v : r._value))})))\n\ntest _duration_second = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_second})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "second_duration_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "second_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "second_duration_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "second_duration_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "second_duration_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "second_duration_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   19,
					},
					File:   "second_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "second_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   19,
						},
						File:   "second_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "second_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "second_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "second_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 80,
						Line:   37,
					},
					File:   "second_duration_test.flux",
					Source: "t_duration_second = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.second(t: duration(v : r._value))})))",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   34,
						},
						File:   "second_duration_test.flux",
						Source: "t_duration_second",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "t_duration_second",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 80,
							Line:   37,
						},
						File:   "second_duration_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.second(t: duration(v : r._value))})))",
						Start: ast.Position{
							Column: 21,
							Line:   34,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 80,
								Line:   37,
							},
							File:   "second_duration_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.second(t: duration(v : r._value))})))",
							Start: ast.Position{
								Column: 2,
								Line:   35,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   35,
										},
										File:   "second_duration_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   35,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   36,
									},
									File:   "second_duration_test.flux",
									Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   35,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   36,
											},
											File:   "second_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   36,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   36,
												},
												File:   "second_duration_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   36,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   36,
													},
													File:   "second_duration_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   36,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   36,
													},
													File:   "second_duration_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   36,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   36,
										},
										File:   "second_duration_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   36,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   36,
											},
											File:   "second_duration_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   36,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   37,
								},
								File:   "second_duration_test.flux",
								Source: "table\n\t\t|> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.second(t: duration(v : r._value))}))",
								Start: ast.Position{
									Column: 3,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   37,
										},
										File:   "second_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.second(t: duration(v : r._value))})",
										Start: ast.Position{
											Column: 10,
											Line:   37,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   37,
											},
											File:   "second_duration_test.flux",
											Source: "fn: (r) => ({r with _value: date.second(t: duration(v : r._value))})",
											Start: ast.Position{
												Column: 10,
												Line:   37,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   37,
												},
												File:   "second_duration_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   37,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 78,
													Line:   37,
												},
												File:   "second_duration_test.flux",
												Source: "(r) => ({r with _value: date.second(t: duration(v : r._value))})",
												Start: ast.Position{
													Column: 14,
													Line:   37,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   37,
													},
													File:   "second_duration_test.flux",
													Source: "({r with _value: date.second(t: duration(v : r._value))})",
													Start: ast.Position{
														Column: 21,
														Line:   37,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   37,
														},
														File:   "second_duration_test.flux",
														Source: "{r with _value: date.second(t: duration(v : r._value))}",
														Start: ast.Position{
															Column: 22,
															Line:   37,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 76,
																Line:   37,
															},
															File:   "second_duration_test.flux",
															Source: "_value: date.second(t: duration(v : r._value))",
															Start: ast.Position{
																Column: 30,
																Line:   37,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   37,
																},
																File:   "second_duration_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   37,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 75,
																		Line:   37,
																	},
																	File:   "second_duration_test.flux",
																	Source: "t: duration(v : r._value)",
																	Start: ast.Position{
																		Column: 50,
																		Line:   37,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 75,
																			Line:   37,
																		},
																		File:   "second_duration_test.flux",
																		Source: "t: duration(v : r._value)",
																		Start: ast.Position{
																			Column: 50,
																			Line:   37,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 51,
																				Line:   37,
																			},
																			File:   "second_duration_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 50,
																				Line:   37,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 74,
																					Line:   37,
																				},
																				File:   "second_duration_test.flux",
																				Source: "v : r._value",
																				Start: ast.Position{
																					Column: 62,
																					Line:   37,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 74,
																						Line:   37,
																					},
																					File:   "second_duration_test.flux",
																					Source: "v : r._value",
																					Start: ast.Position{
																						Column: 62,
																						Line:   37,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 63,
																							Line:   37,
																						},
																						File:   "second_duration_test.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 62,
																							Line:   37,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Separator: nil,
																			Value: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 74,
																							Line:   37,
																						},
																						File:   "second_duration_test.flux",
																						Source: "r._value",
																						Start: ast.Position{
																							Column: 66,
																							Line:   37,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 67,
																								Line:   37,
																							},
																							File:   "second_duration_test.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 66,
																								Line:   37,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 74,
																								Line:   37,
																							},
																							File:   "second_duration_test.flux",
																							Source: "_value",
																							Start: ast.Position{
																								Column: 68,
																								Line:   37,
																							},
																						},
																					},
																					Name: "_value",
																				},
																				Rbrack: nil,
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 75,
																				Line:   37,
																			},
																			File:   "second_duration_test.flux",
																			Source: "duration(v : r._value)",
																			Start: ast.Position{
																				Column: 53,
																				Line:   37,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 61,
																					Line:   37,
																				},
																				File:   "second_duration_test.flux",
																				Source: "duration",
																				Start: ast.Position{
																					Column: 53,
																					Line:   37,
																				},
																			},
																		},
																		Name: "duration",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 76,
																	Line:   37,
																},
																File:   "second_duration_test.flux",
																Source: "date.second(t: duration(v : r._value))",
																Start: ast.Position{
																	Column: 38,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   37,
																	},
																	File:   "second_duration_test.flux",
																	Source: "date.second",
																	Start: ast.Position{
																		Column: 38,
																		Line:   37,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   37,
																		},
																		File:   "second_duration_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   37,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   37,
																		},
																		File:   "second_duration_test.flux",
																		Source: "second",
																		Start: ast.Position{
																			Column: 43,
																			Line:   37,
																		},
																	},
																},
																Name: "second",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   37,
															},
															File:   "second_duration_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   37,
													},
													File:   "second_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   37,
														},
														File:   "second_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   37,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 79,
										Line:   37,
									},
									File:   "second_duration_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.second(t: duration(v : r._value))}))",
									Start: ast.Position{
										Column: 6,
										Line:   37,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   37,
										},
										File:   "second_duration_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   37,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   34,
							},
							File:   "second_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 22,
								Line:   34,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   34,
								},
								File:   "second_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 22,
									Line:   34,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   34,
							},
							File:   "second_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   34,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 105,
							Line:   40,
						},
						File:   "second_duration_test.flux",
						Source: "_duration_second = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_second})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   39,
							},
							File:   "second_duration_test.flux",
							Source: "_duration_second",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_duration_second",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 105,
								Line:   40,
							},
							File:   "second_duration_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_second})",
							Start: ast.Position{
								Column: 25,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   40,
								},
								File:   "second_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_second})",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 104,
										Line:   40,
									},
									File:   "second_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_second}",
									Start: ast.Position{
										Column: 3,
										Line:   40,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "second_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   40,
											},
											File:   "second_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   40,
												},
												File:   "second_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   40,
													},
													File:   "second_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   40,
														},
														File:   "second_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   40,
														},
														File:   "second_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "second_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   40,
												},
												File:   "second_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   40,
													},
													File:   "second_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   40,
													},
													File:   "second_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "second_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "second_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   40,
												},
												File:   "second_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   40,
													},
													File:   "second_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   40,
														},
														File:   "second_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   40,
														},
														File:   "second_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "second_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   40,
												},
												File:   "second_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   40,
													},
													File:   "second_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   40,
													},
													File:   "second_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 103,
											Line:   40,
										},
										File:   "second_duration_test.flux",
										Source: "fn: t_duration_second",
										Start: ast.Position{
											Column: 82,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   40,
											},
											File:   "second_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 103,
												Line:   40,
											},
											File:   "second_duration_test.flux",
											Source: "t_duration_second",
											Start: ast.Position{
												Column: 86,
												Line:   40,
											},
										},
									},
									Name: "t_duration_second",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 105,
						Line:   40,
					},
					File:   "second_duration_test.flux",
					Source: "test _duration_second = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_second})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "second_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "second_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "second_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "second_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "second_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "second_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "second_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 101,
					Line:   72,
				},
				File:   "second_time_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:00Z,_m,FF,1\n,,0,2018-05-22T19:53:10Z,_m,FF,1\n,,0,2018-05-22T19:53:20Z,_m,FF,1\n,,0,2018-05-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-05-22T19:53:50Z,_m,FF,1\n,,1,2018-05-22T19:53:00Z,_m,QQ,1\n,,1,2018-05-22T19:53:10Z,_m,QQ,1\n,,1,2018-05-22T19:53:20Z,_m,QQ,1\n,,1,2018-05-22T19:53:30Z,_m,QQ,1\n,,1,2018-05-22T19:53:40Z,_m,QQ,1\n,,1,2018-05-22T19:53:50Z,_m,QQ,1\n,,1,2018-05-22T19:54:00Z,_m,QQ,1\n,,1,2018-05-22T19:54:10Z,_m,QQ,1\n,,1,2018-05-22T19:54:20Z,_m,QQ,1\n,,2,2018-05-22T19:53:00Z,_m,RR,1\n,,2,2018-05-22T19:53:10Z,_m,RR,1\n,,2,2018-05-22T19:53:20Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,3,2018-05-22T19:53:40Z,_m,SR,1\n,,3,2018-05-22T19:53:50Z,_m,SR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:00Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:10Z,10\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:20Z,20\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:30Z,30\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,40\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:50Z,50\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:00Z,0\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:10Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:20Z,20\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:30Z,30\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:40Z,40\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:50Z,50\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:00Z,0\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:10Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:20Z,20\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:00Z,0\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:10Z,10\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:20Z,20\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:30Z,30\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:53:40Z,40\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:53:50Z,50\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:54:00Z,0\n\"\n\nt_time_second = (table=<-) =>\n\t(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.second(t: r._time)})))\n\ntest _time_second = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_second})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "second_time_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "second_time_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "second_time_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "second_time_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "second_time_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "second_time_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   35,
					},
					File:   "second_time_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:00Z,_m,FF,1\n,,0,2018-05-22T19:53:10Z,_m,FF,1\n,,0,2018-05-22T19:53:20Z,_m,FF,1\n,,0,2018-05-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-05-22T19:53:50Z,_m,FF,1\n,,1,2018-05-22T19:53:00Z,_m,QQ,1\n,,1,2018-05-22T19:53:10Z,_m,QQ,1\n,,1,2018-05-22T19:53:20Z,_m,QQ,1\n,,1,2018-05-22T19:53:30Z,_m,QQ,1\n,,1,2018-05-22T19:53:40Z,_m,QQ,1\n,,1,2018-05-22T19:53:50Z,_m,QQ,1\n,,1,2018-05-22T19:54:00Z,_m,QQ,1\n,,1,2018-05-22T19:54:10Z,_m,QQ,1\n,,1,2018-05-22T19:54:20Z,_m,QQ,1\n,,2,2018-05-22T19:53:00Z,_m,RR,1\n,,2,2018-05-22T19:53:10Z,_m,RR,1\n,,2,2018-05-22T19:53:20Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,3,2018-05-22T19:53:40Z,_m,SR,1\n,,3,2018-05-22T19:53:50Z,_m,SR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "second_time_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   35,
						},
						File:   "second_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:00Z,_m,FF,1\n,,0,2018-05-22T19:53:10Z,_m,FF,1\n,,0,2018-05-22T19:53:20Z,_m,FF,1\n,,0,2018-05-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-05-22T19:53:50Z,_m,FF,1\n,,1,2018-05-22T19:53:00Z,_m,QQ,1\n,,1,2018-05-22T19:53:10Z,_m,QQ,1\n,,1,2018-05-22T19:53:20Z,_m,QQ,1\n,,1,2018-05-22T19:53:30Z,_m,QQ,1\n,,1,2018-05-22T19:53:40Z,_m,QQ,1\n,,1,2018-05-22T19:53:50Z,_m,QQ,1\n,,1,2018-05-22T19:54:00Z,_m,QQ,1\n,,1,2018-05-22T19:54:10Z,_m,QQ,1\n,,1,2018-05-22T19:54:20Z,_m,QQ,1\n,,2,2018-05-22T19:53:00Z,_m,RR,1\n,,2,2018-05-22T19:53:10Z,_m,RR,1\n,,2,2018-05-22T19:53:20Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,3,2018-05-22T19:53:40Z,_m,SR,1\n,,3,2018-05-22T19:53:50Z,_m,SR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:00Z,_m,FF,1\n,,0,2018-05-22T19:53:10Z,_m,FF,1\n,,0,2018-05-22T19:53:20Z,_m,FF,1\n,,0,2018-05-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-05-22T19:53:50Z,_m,FF,1\n,,1,2018-05-22T19:53:00Z,_m,QQ,1\n,,1,2018-05-22T19:53:10Z,_m,QQ,1\n,,1,2018-05-22T19:53:20Z,_m,QQ,1\n,,1,2018-05-22T19:53:30Z,_m,QQ,1\n,,1,2018-05-22T19:53:40Z,_m,QQ,1\n,,1,2018-05-22T19:53:50Z,_m,QQ,1\n,,1,2018-05-22T19:54:00Z,_m,QQ,1\n,,1,2018-05-22T19:54:10Z,_m,QQ,1\n,,1,2018-05-22T19:54:20Z,_m,QQ,1\n,,2,2018-05-22T19:53:00Z,_m,RR,1\n,,2,2018-05-22T19:53:10Z,_m,RR,1\n,,2,2018-05-22T19:53:20Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,3,2018-05-22T19:53:40Z,_m,SR,1\n,,3,2018-05-22T19:53:50Z,_m,SR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   64,
					},
					File:   "second_time_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:00Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:10Z,10\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:20Z,20\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:30Z,30\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,40\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:50Z,50\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:00Z,0\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:10Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:20Z,20\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:30Z,30\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:40Z,40\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:50Z,50\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:00Z,0\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:10Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:20Z,20\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:00Z,0\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:10Z,10\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:20Z,20\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:30Z,30\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:53:40Z,40\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:53:50Z,50\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:54:00Z,0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   37,
						},
						File:   "second_time_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   37,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   64,
						},
						File:   "second_time_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:00Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:10Z,10\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:20Z,20\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:30Z,30\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,40\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:50Z,50\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:00Z,0\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:10Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:20Z,20\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:30Z,30\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:40Z,40\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:50Z,50\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:00Z,0\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:10Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:20Z,20\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:00Z,0\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:10Z,10\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:20Z,20\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:30Z,30\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:53:40Z,40\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:53:50Z,50\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:54:00Z,0\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   37,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:00Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:10Z,10\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:20Z,20\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:30Z,30\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,40\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:50Z,50\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:00Z,0\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:10Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:20Z,20\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:30Z,30\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:40Z,40\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:50Z,50\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:00Z,0\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:10Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:20Z,20\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:00Z,0\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:10Z,10\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:20Z,20\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:30Z,30\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:53:40Z,40\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:53:50Z,50\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:54:00Z,0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 65,
						Line:   69,
					},
					File:   "second_time_test.flux",
					Source: "t_time_second = (table=<-) =>\n\t(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.second(t: r._time)})))",
					Start: ast.Position{
						Column: 1,
						Line:   66,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   66,
						},
						File:   "second_time_test.flux",
						Source: "t_time_second",
						Start: ast.Position{
							Column: 1,
							Line:   66,
						},
					},
				},
				Name: "t_time_second",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 65,
							Line:   69,
						},
						File:   "second_time_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.second(t: r._time)})))",
						Start: ast.Position{
							Column: 17,
							Line:   66,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   69,
							},
							File:   "second_time_test.flux",
							Source: "(table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.second(t: r._time)})))",
							Start: ast.Position{
								Column: 2,
								Line:   67,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   67,
										},
										File:   "second_time_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   67,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   68,
									},
									File:   "second_time_test.flux",
									Source: "table\n\t    |> range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   67,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   68,
											},
											File:   "second_time_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 15,
												Line:   68,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   68,
												},
												File:   "second_time_test.flux",
												Source: "start: 2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 15,
													Line:   68,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   68,
													},
													File:   "second_time_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 15,
														Line:   68,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   68,
													},
													File:   "second_time_test.flux",
													Source: "2018-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 22,
														Line:   68,
													},
												},
											},
											Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   68,
										},
										File:   "second_time_test.flux",
										Source: "range(start: 2018-01-01T00:00:00Z)",
										Start: ast.Position{
											Column: 9,
											Line:   68,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   68,
											},
											File:   "second_time_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 9,
												Line:   68,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   69,
								},
								File:   "second_time_test.flux",
								Source: "table\n\t    |> range(start: 2018-01-01T00:00:00Z)\n\t\t|> map(fn: (r) => ({r with _value: date.second(t: r._time)}))",
								Start: ast.Position{
									Column: 3,
									Line:   67,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   69,
										},
										File:   "second_time_test.flux",
										Source: "fn: (r) => ({r with _value: date.second(t: r._time)})",
										Start: ast.Position{
											Column: 10,
											Line:   69,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 63,
												Line:   69,
											},
											File:   "second_time_test.flux",
											Source: "fn: (r) => ({r with _value: date.second(t: r._time)})",
											Start: ast.Position{
												Column: 10,
												Line:   69,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   69,
												},
												File:   "second_time_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   69,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   69,
												},
												File:   "second_time_test.flux",
												Source: "(r) => ({r with _value: date.second(t: r._time)})",
												Start: ast.Position{
													Column: 14,
													Line:   69,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 63,
														Line:   69,
													},
													File:   "second_time_test.flux",
													Source: "({r with _value: date.second(t: r._time)})",
													Start: ast.Position{
														Column: 21,
														Line:   69,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   69,
														},
														File:   "second_time_test.flux",
														Source: "{r with _value: date.second(t: r._time)}",
														Start: ast.Position{
															Column: 22,
															Line:   69,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 61,
																Line:   69,
															},
															File:   "second_time_test.flux",
															Source: "_value: date.second(t: r._time)",
															Start: ast.Position{
																Column: 30,
																Line:   69,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   69,
																},
																File:   "second_time_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   69,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 60,
																		Line:   69,
																	},
																	File:   "second_time_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 50,
																		Line:   69,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 60,
																			Line:   69,
																		},
																		File:   "second_time_test.flux",
																		Source: "t: r._time",
																		Start: ast.Position{
																			Column: 50,
																			Line:   69,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 51,
																				Line:   69,
																			},
																			File:   "second_time_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 50,
																				Line:   69,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 60,
																				Line:   69,
																			},
																			File:   "second_time_test.flux",
																			Source: "r._time",
																			Start: ast.Position{
																				Column: 53,
																				Line:   69,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 54,
																					Line:   69,
																				},
																				File:   "second_time_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 53,
																					Line:   69,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 60,
																					Line:   69,
																				},
																				File:   "second_time_test.flux",
																				Source: "_time",
																				Start: ast.Position{
																					Column: 55,
																					Line:   69,
																				},
																			},
																		},
																		Name: "_time",
																	},
																	Rbrack: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 61,
																	Line:   69,
																},
																File:   "second_time_test.flux",
																Source: "date.second(t: r._time)",
																Start: ast.Position{
																	Column: 38,
																	Line:   69,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   69,
																	},
																	File:   "second_time_test.flux",
																	Source: "date.second",
																	Start: ast.Position{
																		Column: 38,
																		Line:   69,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   69,
																		},
																		File:   "second_time_test.flux",
																		Source: "date",
																		Start: ast.Position{
																			Column: 38,
																			Line:   69,
																		},
																	},
																},
																Name: "date",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   69,
																		},
																		File:   "second_time_test.flux",
																		Source: "second",
																		Start: ast.Position{
																			Column: 43,
																			Line:   69,
																		},
																	},
																},
																Name: "second",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   69,
															},
															File:   "second_time_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   69,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   69,
													},
													File:   "second_time_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   69,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   69,
														},
														File:   "second_time_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   69,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   69,
									},
									File:   "second_time_test.flux",
									Source: "map(fn: (r) => ({r with _value: date.second(t: r._time)}))",
									Start: ast.Position{
										Column: 6,
										Line:   69,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   69,
										},
										File:   "second_time_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   69,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   66,
							},
							File:   "second_time_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 18,
								Line:   66,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   66,
								},
								File:   "second_time_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 18,
									Line:   66,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   66,
							},
							File:   "second_time_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   66,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 101,
							Line:   72,
						},
						File:   "second_time_test.flux",
						Source: "_time_second = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_second})",
						Start: ast.Position{
							Column: 6,
							Line:   71,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   71,
							},
							File:   "second_time_test.flux",
							Source: "_time_second",
							Start: ast.Position{
								Column: 6,
								Line:   71,
							},
						},
					},
					Name: "_time_second",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 101,
								Line:   72,
							},
							File:   "second_time_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_second})",
							Start: ast.Position{
								Column: 21,
								Line:   71,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   72,
								},
								File:   "second_time_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_second})",
								Start: ast.Position{
									Column: 2,
									Line:   72,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 100,
										Line:   72,
									},
									File:   "second_time_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_second}",
									Start: ast.Position{
										Column: 3,
										Line:   72,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   72,
										},
										File:   "second_time_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   72,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   72,
											},
											File:   "second_time_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   72,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   72,
												},
												File:   "second_time_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   72,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   72,
													},
													File:   "second_time_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   72,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   72,
														},
														File:   "second_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   72,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   72,
														},
														File:   "second_time_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   72,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   72,
											},
											File:   "second_time_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   72,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   72,
												},
												File:   "second_time_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   72,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   72,
													},
													File:   "second_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   72,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   72,
													},
													File:   "second_time_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   72,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   72,
										},
										File:   "second_time_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   72,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   72,
											},
											File:   "second_time_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   72,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   72,
												},
												File:   "second_time_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   72,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   72,
													},
													File:   "second_time_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   72,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   72,
														},
														File:   "second_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   72,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   72,
														},
														File:   "second_time_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   72,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   72,
											},
											File:   "second_time_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   72,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   72,
												},
												File:   "second_time_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   72,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   72,
													},
													File:   "second_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   72,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   72,
													},
													File:   "second_time_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   72,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 99,
											Line:   72,
										},
										File:   "second_time_test.flux",
										Source: "fn: t_time_second",
										Start: ast.Position{
											Column: 82,
											Line:   72,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   72,
											},
											File:   "second_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   72,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 99,
												Line:   72,
											},
											File:   "second_time_test.flux",
											Source: "t_time_second",
											Start: ast.Position{
												Column: 86,
												Line:   72,
											},
										},
									},
									Name: "t_time_second",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 101,
						Line:   72,
					},
					File:   "second_time_test.flux",
					Source: "test _time_second = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_second})",
					Start: ast.Position{
						Column: 1,
						Line:   71,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "second_time_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "second_time_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "second_time_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "second_time_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "second_time_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "second_time_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "second_time_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 107,
					Line:   43,
				},
				File:   "truncate_duration_test.flux",
				Source: "package date_test\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:00.000000000Z,_m,FF,-3600000000000\n,,0,2018-05-22T19:53:10.000000000Z,_m,FF,-7200000000000\n,,0,2018-05-22T19:53:20.000000000Z,_m,FF,-10800000000000\n,,0,2018-05-22T19:53:30.000000000Z,_m,FF,0\n,,0,2018-05-22T19:53:40.000000000Z,_m,FF,3600000000000\n,,0,2018-05-22T19:53:50.000000000Z,_m,FF,7200000000000\n,,0,2018-05-22T19:54:00.000000000Z,_m,FF,10800000000000\n\"\n\noutData = \"\n#datatype,string,long,string,string,dateTime:RFC3339,long\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_field,_measurement,_time,_value\n,,0,FF,_m,2018-05-22T19:53:00.000000000Z,1893452400000000000\n,,0,FF,_m,2018-05-22T19:53:10.000000000Z,1893448800000000000\n,,0,FF,_m,2018-05-22T19:53:20.000000000Z,1893445200000000000\n,,0,FF,_m,2018-05-22T19:53:30.000000000Z,1893456000000000000\n,,0,FF,_m,2018-05-22T19:53:40.000000000Z,1893459600000000000\n,,0,FF,_m,2018-05-22T19:53:50.000000000Z,1893463200000000000\n,,0,FF,_m,2018-05-22T19:54:00.000000000Z,1893466800000000000\n\"\n\nt_duration_truncate = (table=<-) =>\n\t(table\n\t    |> range(start: 2018-05-22T19:53:00.000000000Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> map(fn: (r) => ({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))})))\n\ntest _duration_truncate = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_truncate})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "truncate_duration_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "truncate_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "truncate_duration_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "truncate_duration_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "truncate_duration_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "truncate_duration_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "truncate_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:00.000000000Z,_m,FF,-3600000000000\n,,0,2018-05-22T19:53:10.000000000Z,_m,FF,-7200000000000\n,,0,2018-05-22T19:53:20.000000000Z,_m,FF,-10800000000000\n,,0,2018-05-22T19:53:30.000000000Z,_m,FF,0\n,,0,2018-05-22T19:53:40.000000000Z,_m,FF,3600000000000\n,,0,2018-05-22T19:53:50.000000000Z,_m,FF,7200000000000\n,,0,2018-05-22T19:54:00.000000000Z,_m,FF,10800000000000\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "truncate_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "truncate_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:00.000000000Z,_m,FF,-3600000000000\n,,0,2018-05-22T19:53:10.000000000Z,_m,FF,-7200000000000\n,,0,2018-05-22T19:53:20.000000000Z,_m,FF,-10800000000000\n,,0,2018-05-22T19:53:30.000000000Z,_m,FF,0\n,,0,2018-05-22T19:53:40.000000000Z,_m,FF,3600000000000\n,,0,2018-05-22T19:53:50.000000000Z,_m,FF,7200000000000\n,,0,2018-05-22T19:54:00.000000000Z,_m,FF,10800000000000\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:00.000000000Z,_m,FF,-3600000000000\n,,0,2018-05-22T19:53:10.000000000Z,_m,FF,-7200000000000\n,,0,2018-05-22T19:53:20.000000000Z,_m,FF,-10800000000000\n,,0,2018-05-22T19:53:30.000000000Z,_m,FF,0\n,,0,2018-05-22T19:53:40.000000000Z,_m,FF,3600000000000\n,,0,2018-05-22T19:53:50.000000000Z,_m,FF,7200000000000\n,,0,2018-05-22T19:54:00.000000000Z,_m,FF,10800000000000\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   34,
					},
					File:   "truncate_duration_test.flux",
					Source: "outData = \"\n#datatype,string,long,string,string,dateTime:RFC3339,long\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_field,_measurement,_time,_value\n,,0,FF,_m,2018-05-22T19:53:00.000000000Z,1893452400000000000\n,,0,FF,_m,2018-05-22T19:53:10.000000000Z,1893448800000000000\n,,0,FF,_m,2018-05-22T19:53:20.000000000Z,1893445200000000000\n,,0,FF,_m,2018-05-22T19:53:30.000000000Z,1893456000000000000\n,,0,FF,_m,2018-05-22T19:53:40.000000000Z,1893459600000000000\n,,0,FF,_m,2018-05-22T19:53:50.000000000Z,1893463200000000000\n,,0,FF,_m,2018-05-22T19:54:00.000000000Z,1893466800000000000\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   22,
						},
						File:   "truncate_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   22,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   34,
						},
						File:   "truncate_duration_test.flux",
						Source: "\"\n#datatype,string,long,string,string,dateTime:RFC3339,long\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_field,_measurement,_time,_value\n,,0,FF,_m,2018-05-22T19:53:00.000000000Z,1893452400000000000\n,,0,FF,_m,2018-05-22T19:53:10.000000000Z,1893448800000000000\n,,0,FF,_m,2018-05-22T19:53:20.000000000Z,1893445200000000000\n,,0,FF,_m,2018-05-22T19:53:30.000000000Z,1893456000000000000\n,,0,FF,_m,2018-05-22T19:53:40.000000000Z,1893459600000000000\n,,0,FF,_m,2018-05-22T19:53:50.000000000Z,1893463200000000000\n,,0,FF,_m,2018-05-22T19:54:00.000000000Z,1893466800000000000\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   22,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,dateTime:RFC3339,long\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_field,_measurement,_time,_value\n,,0,FF,_m,2018-05-22T19:53:00.000000000Z,1893452400000000000\n,,0,FF,_m,2018-05-22T19:53:10.000000000Z,1893448800000000000\n,,0,FF,_m,2018-05-22T19:53:20.000000000Z,1893445200000000000\n,,0,FF,_m,2018-05-22T19:53:30.000000000Z,1893456000000000000\n,,0,FF,_m,2018-05-22T19:53:40.000000000Z,1893459600000000000\n,,0,FF,_m,2018-05-22T19:53:50.000000000Z,1893463200000000000\n,,0,FF,_m,2018-05-22T19:54:00.000000000Z,1893466800000000000\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 99,
						Line:   40,
					},
					File:   "truncate_duration_test.flux",
					Source: "t_duration_truncate = (table=<-) =>\n\t(table\n\t    |> range(start: 2018-05-22T19:53:00.000000000Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> map(fn: (r) => ({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))})))",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   36,
						},
						File:   "truncate_duration_test.flux",
						Source: "t_duration_truncate",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "t_duration_truncate",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 99,
							Line:   40,
						},
						File:   "truncate_duration_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t    |> range(start: 2018-05-22T19:53:00.000000000Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> map(fn: (r) => ({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))})))",
						Start: ast.Position{
							Column: 23,
							Line:   36,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   40,
							},
							File:   "truncate_duration_test.flux",
							Source: "(table\n\t    |> range(start: 2018-05-22T19:53:00.000000000Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> map(fn: (r) => ({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))})))",
							Start: ast.Position{
								Column: 2,
								Line:   37,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   37,
											},
											File:   "truncate_duration_test.flux",
											Source: "table",
											Start: ast.Position{
												Column: 3,
												Line:   37,
											},
										},
									},
									Name: "table",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   38,
										},
										File:   "truncate_duration_test.flux",
										Source: "table\n\t    |> range(start: 2018-05-22T19:53:00.000000000Z)",
										Start: ast.Position{
											Column: 3,
											Line:   37,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   38,
												},
												File:   "truncate_duration_test.flux",
												Source: "start: 2018-05-22T19:53:00.000000000Z",
												Start: ast.Position{
													Column: 15,
													Line:   38,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   38,
													},
													File:   "truncate_duration_test.flux",
													Source: "start: 2018-05-22T19:53:00.000000000Z",
													Start: ast.Position{
														Column: 15,
														Line:   38,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   38,
														},
														File:   "truncate_duration_test.flux",
														Source: "start",
														Start: ast.Position{
															Column: 15,
															Line:   38,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.DateTimeLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   38,
														},
														File:   "truncate_duration_test.flux",
														Source: "2018-05-22T19:53:00.000000000Z",
														Start: ast.Position{
															Column: 22,
															Line:   38,
														},
													},
												},
												Value: parser.MustParseTime("2018-05-22T19:53:00Z"),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   38,
											},
											File:   "truncate_duration_test.flux",
											Source: "range(start: 2018-05-22T19:53:00.000000000Z)",
											Start: ast.Position{
												Column: 9,
												Line:   38,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   38,
												},
												File:   "truncate_duration_test.flux",
												Source: "range",
												Start: ast.Position{
													Column: 9,
													Line:   38,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   39,
									},
									File:   "truncate_duration_test.flux",
									Source: "table\n\t    |> range(start: 2018-05-22T19:53:00.000000000Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 3,
										Line:   37,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   39,
											},
											File:   "truncate_duration_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 14,
												Line:   39,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   39,
												},
												File:   "truncate_duration_test.flux",
												Source: "columns: [\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 14,
													Line:   39,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   39,
													},
													File:   "truncate_duration_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 14,
														Line:   39,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   39,
													},
													File:   "truncate_duration_test.flux",
													Source: "[\"_start\", \"_stop\"]",
													Start: ast.Position{
														Column: 23,
														Line:   39,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   39,
														},
														File:   "truncate_duration_test.flux",
														Source: "\"_start\"",
														Start: ast.Position{
															Column: 24,
															Line:   39,
														},
													},
												},
												Value: "_start",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   39,
														},
														File:   "truncate_duration_test.flux",
														Source: "\"_stop\"",
														Start: ast.Position{
															Column: 34,
															Line:   39,
														},
													},
												},
												Value: "_stop",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   39,
										},
										File:   "truncate_duration_test.flux",
										Source: "drop(columns: [\"_start\", \"_stop\"])",
										Start: ast.Position{
											Column: 9,
											Line:   39,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   39,
											},
											File:   "truncate_duration_test.flux",
											Source: "drop",
											Start: ast.Position{
												Column: 9,
												Line:   39,
											},
										},
									},
									Name: "drop",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 98,
									Line:   40,
								},
								File:   "truncate_duration_test.flux",
								Source: "table\n\t    |> range(start: 2018-05-22T19:53:00.000000000Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> map(fn: (r) => ({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))}))",
								Start: ast.Position{
									Column: 3,
									Line:   37,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 97,
											Line:   40,
										},
										File:   "truncate_duration_test.flux",
										Source: "fn: (r) => ({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))})",
										Start: ast.Position{
											Column: 10,
											Line:   40,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 97,
												Line:   40,
											},
											File:   "truncate_duration_test.flux",
											Source: "fn: (r) => ({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))})",
											Start: ast.Position{
												Column: 10,
												Line:   40,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   40,
												},
												File:   "truncate_duration_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   40,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 97,
													Line:   40,
												},
												File:   "truncate_duration_test.flux",
												Source: "(r) => ({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))})",
												Start: ast.Position{
													Column: 14,
													Line:   40,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 97,
														Line:   40,
													},
													File:   "truncate_duration_test.flux",
													Source: "({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))})",
													Start: ast.Position{
														Column: 21,
														Line:   40,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 96,
															Line:   40,
														},
														File:   "truncate_duration_test.flux",
														Source: "{r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))}",
														Start: ast.Position{
															Column: 22,
															Line:   40,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 95,
																Line:   40,
															},
															File:   "truncate_duration_test.flux",
															Source: "_value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))",
															Start: ast.Position{
																Column: 30,
																Line:   40,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   40,
																},
																File:   "truncate_duration_test.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   40,
																},
															},
														},
														Name: "_value",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 94,
																		Line:   40,
																	},
																	File:   "truncate_duration_test.flux",
																	Source: "v: date.truncate(t: duration(v: r._value), unit: 1s)",
																	Start: ast.Position{
																		Column: 42,
																		Line:   40,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 94,
																			Line:   40,
																		},
																		File:   "truncate_duration_test.flux",
																		Source: "v: date.truncate(t: duration(v: r._value), unit: 1s)",
																		Start: ast.Position{
																			Column: 42,
																			Line:   40,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 43,
																				Line:   40,
																			},
																			File:   "truncate_duration_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 42,
																				Line:   40,
																			},
																		},
																	},
																	Name: "v",
																},
																Separator: nil,
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 93,
																					Line:   40,
																				},
																				File:   "truncate_duration_test.flux",
																				Source: "t: duration(v: r._value), unit: 1s",
																				Start: ast.Position{
																					Column: 59,
																					Line:   40,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 83,
																						Line:   40,
																					},
																					File:   "truncate_duration_test.flux",
																					Source: "t: duration(v: r._value)",
																					Start: ast.Position{
																						Column: 59,
																						Line:   40,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 60,
																							Line:   40,
																						},
																						File:   "truncate_duration_test.flux",
																						Source: "t",
																						Start: ast.Position{
																							Column: 59,
																							Line:   40,
																						},
																					},
																				},
																				Name: "t",
																			},
																			Separator: nil,
																			Value: &ast.CallExpression{
																				Arguments: []ast.Expression{&ast.ObjectExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 82,
																								Line:   40,
																							},
																							File:   "truncate_duration_test.flux",
																							Source: "v: r._value",
																							Start: ast.Position{
																								Column: 71,
																								Line:   40,
																							},
																						},
																					},
																					Lbrace: nil,
																					Properties: []*ast.Property{&ast.Property{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 82,
																									Line:   40,
																								},
																								File:   "truncate_duration_test.flux",
																								Source: "v: r._value",
																								Start: ast.Position{
																									Column: 71,
																									Line:   40,
																								},
																							},
																						},
																						Comma: nil,
																						Key: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 72,
																										Line:   40,
																									},
																									File:   "truncate_duration_test.flux",
																									Source: "v",
																									Start: ast.Position{
																										Column: 71,
																										Line:   40,
																									},
																								},
																							},
																							Name: "v",
																						},
																						Separator: nil,
																						Value: &ast.MemberExpression{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.Sour