// DO NOT EDIT: This file is autogenerated via the builtin command.

package monitor

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 19,
					Line:   145,
				},
				File:   "monitor.flux",
				Source: "package monitor\n\nimport \"experimental\"\nimport \"influxdata/influxdb/v1\"\nimport \"influxdata/influxdb\"\n\nbucket = \"_monitoring\"\n\n// Write persists the check statuses\noption write = (tables=<-) => tables |> experimental.to(bucket: bucket)\n\n// Log records notification events\noption log = (tables=<-) => tables |> experimental.to(bucket: bucket)\n\n// From retrieves the check statuses that have been stored.\nfrom = (start, stop=now(), fn=(r) => true) =>\n    influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"statuses\")\n        |> filter(fn: fn)\n        |> v1.fieldsAsCols()\n\n// levels describing the result of a check\nlevelOK = \"ok\"\nlevelInfo = \"info\"\nlevelWarn = \"warn\"\nlevelCrit = \"crit\"\nlevelUnknown = \"unknown\"\n\n_stateChanges = (fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    toLevelFilter = if toLevel == \"any\" then (r) => r._level != fromLevel and exists r._level\n                   else (r) => r._level == toLevel\n\n    fromLevelFilter = if fromLevel == \"any\" then (r) => r._level != toLevel and exists r._level\n                   else (r) => r._level == fromLevel\n\n    return tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}\n\n// stateChangesOnly takes a stream of tables that contains a _level column and\n// returns a stream of tables where each record in a table represents a state change\n// of the _level column.\n// Statuses are sorted by source timestamp, because default sort order of statuses may differ\n// (`_time` column holds the time when check was executed) and that could result in detecting\n// status changes at the wrong time or even false changes.\nstateChangesOnly = (tables=<-) => {\n    return tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}\n\n// StateChanges takes a stream of tables, fromLevel, and toLevel and returns\n// a stream of tables where status has gone from fromLevel to toLevel.\n//\n// StateChanges only operates on data with data where r._level exists.\nstateChanges = (fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    return if fromLevel == \"any\" and toLevel == \"any\" then tables |> stateChangesOnly()\n           else tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)\n}\n\n// Notify will call the endpoint and log the results.\nnotify = (tables=<-, endpoint, data) =>\n    tables\n        |> experimental.set(o: data)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n        |> map(fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }))\n        |> endpoint()\n        |> experimental.group(mode: \"extend\", columns: [\"_sent\"])\n        |> log()\n\n// Logs retrieves notification events that have been logged.\nlogs = (start, stop=now(), fn) =>\n    influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"notifications\")\n        |> filter(fn: fn)\n        |> v1.fieldsAsCols()\n\n// Deadman takes in a stream of tables and reports which tables\n// were observed strictly before t and which were observed after.\n//\ndeadman = (t, tables=<-) => tables\n    |> max(column: \"_time\")\n    |> map(fn: (r) => ( {r with dead: r._time < t} ))\n\n// Check performs a check against its input using the given ok, info, warn and crit functions\n// and writes the result to a system bucket.\ncheck = (\n    tables=<-,\n    data,\n    messageFn,\n    crit=(r) => false,\n    warn=(r) => false,\n    info=(r) => false,\n    ok=(r) => true\n) =>\n    tables\n        |> experimental.set(o: data.tags)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n        |> map(fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }))\n        |> map(fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }))\n        |> experimental.group(mode: \"extend\", columns: [\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"])\n        |> write()",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 23,
						Line:   7,
					},
					File:   "monitor.flux",
					Source: "bucket = \"_monitoring\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "monitor.flux",
						Source: "bucket",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "bucket",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 23,
							Line:   7,
						},
						File:   "monitor.flux",
						Source: "\"_monitoring\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "_monitoring",
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 72,
							Line:   10,
						},
						File:   "monitor.flux",
						Source: "write = (tables=<-) => tables |> experimental.to(bucket: bucket)",
						Start: ast.Position{
							Column: 8,
							Line:   10,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   10,
							},
							File:   "monitor.flux",
							Source: "write",
							Start: ast.Position{
								Column: 8,
								Line:   10,
							},
						},
					},
					Name: "write",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   10,
							},
							File:   "monitor.flux",
							Source: "(tables=<-) => tables |> experimental.to(bucket: bucket)",
							Start: ast.Position{
								Column: 16,
								Line:   10,
							},
						},
					},
					Body: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   10,
									},
									File:   "monitor.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 31,
										Line:   10,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   10,
								},
								File:   "monitor.flux",
								Source: "tables |> experimental.to(bucket: bucket)",
								Start: ast.Position{
									Column: 31,
									Line:   10,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   10,
										},
										File:   "monitor.flux",
										Source: "bucket: bucket",
										Start: ast.Position{
											Column: 57,
											Line:   10,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   10,
											},
											File:   "monitor.flux",
											Source: "bucket: bucket",
											Start: ast.Position{
												Column: 57,
												Line:   10,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   10,
												},
												File:   "monitor.flux",
												Source: "bucket",
												Start: ast.Position{
													Column: 57,
													Line:   10,
												},
											},
										},
										Name: "bucket",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   10,
												},
												File:   "monitor.flux",
												Source: "bucket",
												Start: ast.Position{
													Column: 65,
													Line:   10,
												},
											},
										},
										Name: "bucket",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   10,
									},
									File:   "monitor.flux",
									Source: "experimental.to(bucket: bucket)",
									Start: ast.Position{
										Column: 41,
										Line:   10,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 56,
											Line:   10,
										},
										File:   "monitor.flux",
										Source: "experimental.to",
										Start: ast.Position{
											Column: 41,
											Line:   10,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   10,
											},
											File:   "monitor.flux",
											Source: "experimental",
											Start: ast.Position{
												Column: 41,
												Line:   10,
											},
										},
									},
									Name: "experimental",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   10,
											},
											File:   "monitor.flux",
											Source: "to",
											Start: ast.Position{
												Column: 54,
												Line:   10,
											},
										},
									},
									Name: "to",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   10,
								},
								File:   "monitor.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 17,
									Line:   10,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   10,
									},
									File:   "monitor.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 17,
										Line:   10,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   10,
								},
								File:   "monitor.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 24,
									Line:   10,
								},
							},
						}},
					}},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Write persists the check statuses\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 72,
						Line:   10,
					},
					File:   "monitor.flux",
					Source: "option write = (tables=<-) => tables |> experimental.to(bucket: bucket)",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   13,
						},
						File:   "monitor.flux",
						Source: "log = (tables=<-) => tables |> experimental.to(bucket: bucket)",
						Start: ast.Position{
							Column: 8,
							Line:   13,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   13,
							},
							File:   "monitor.flux",
							Source: "log",
							Start: ast.Position{
								Column: 8,
								Line:   13,
							},
						},
					},
					Name: "log",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   13,
							},
							File:   "monitor.flux",
							Source: "(tables=<-) => tables |> experimental.to(bucket: bucket)",
							Start: ast.Position{
								Column: 14,
								Line:   13,
							},
						},
					},
					Body: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   13,
									},
									File:   "monitor.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 29,
										Line:   13,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   13,
								},
								File:   "monitor.flux",
								Source: "tables |> experimental.to(bucket: bucket)",
								Start: ast.Position{
									Column: 29,
									Line:   13,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   13,
										},
										File:   "monitor.flux",
										Source: "bucket: bucket",
										Start: ast.Position{
											Column: 55,
											Line:   13,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   13,
											},
											File:   "monitor.flux",
											Source: "bucket: bucket",
											Start: ast.Position{
												Column: 55,
												Line:   13,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   13,
												},
												File:   "monitor.flux",
												Source: "bucket",
												Start: ast.Position{
													Column: 55,
													Line:   13,
												},
											},
										},
										Name: "bucket",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   13,
												},
												File:   "monitor.flux",
												Source: "bucket",
												Start: ast.Position{
													Column: 63,
													Line:   13,
												},
											},
										},
										Name: "bucket",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   13,
									},
									File:   "monitor.flux",
									Source: "experimental.to(bucket: bucket)",
									Start: ast.Position{
										Column: 39,
										Line:   13,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   13,
										},
										File:   "monitor.flux",
										Source: "experimental.to",
										Start: ast.Position{
											Column: 39,
											Line:   13,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   13,
											},
											File:   "monitor.flux",
											Source: "experimental",
											Start: ast.Position{
												Column: 39,
												Line:   13,
											},
										},
									},
									Name: "experimental",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   13,
											},
											File:   "monitor.flux",
											Source: "to",
											Start: ast.Position{
												Column: 52,
												Line:   13,
											},
										},
									},
									Name: "to",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   13,
								},
								File:   "monitor.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 15,
									Line:   13,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   13,
									},
									File:   "monitor.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 15,
										Line:   13,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   13,
								},
								File:   "monitor.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 22,
									Line:   13,
								},
							},
						}},
					}},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Log records notification events\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 70,
						Line:   13,
					},
					File:   "monitor.flux",
					Source: "option log = (tables=<-) => tables |> experimental.to(bucket: bucket)",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 29,
						Line:   21,
					},
					File:   "monitor.flux",
					Source: "from = (start, stop=now(), fn=(r) => true) =>\n    influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"statuses\")\n        |> filter(fn: fn)\n        |> v1.fieldsAsCols()",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// From retrieves the check statuses that have been stored.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   16,
						},
						File:   "monitor.flux",
						Source: "from",
						Start: ast.Position{
							Column: 1,
							Line:   16,
						},
					},
				},
				Name: "from",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 29,
							Line:   21,
						},
						File:   "monitor.flux",
						Source: "(start, stop=now(), fn=(r) => true) =>\n    influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"statuses\")\n        |> filter(fn: fn)\n        |> v1.fieldsAsCols()",
						Start: ast.Position{
							Column: 8,
							Line:   16,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   17,
												},
												File:   "monitor.flux",
												Source: "bucket: bucket",
												Start: ast.Position{
													Column: 19,
													Line:   17,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   17,
													},
													File:   "monitor.flux",
													Source: "bucket: bucket",
													Start: ast.Position{
														Column: 19,
														Line:   17,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   17,
														},
														File:   "monitor.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 19,
															Line:   17,
														},
													},
												},
												Name: "bucket",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   17,
														},
														File:   "monitor.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 27,
															Line:   17,
														},
													},
												},
												Name: "bucket",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   17,
											},
											File:   "monitor.flux",
											Source: "influxdb.from(bucket: bucket)",
											Start: ast.Position{
												Column: 5,
												Line:   17,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   17,
												},
												File:   "monitor.flux",
												Source: "influxdb.from",
												Start: ast.Position{
													Column: 5,
													Line:   17,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   17,
													},
													File:   "monitor.flux",
													Source: "influxdb",
													Start: ast.Position{
														Column: 5,
														Line:   17,
													},
												},
											},
											Name: "influxdb",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   17,
													},
													File:   "monitor.flux",
													Source: "from",
													Start: ast.Position{
														Column: 14,
														Line:   17,
													},
												},
											},
											Name: "from",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   18,
										},
										File:   "monitor.flux",
										Source: "influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)",
										Start: ast.Position{
											Column: 5,
											Line:   17,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   18,
												},
												File:   "monitor.flux",
												Source: "start: start, stop: stop",
												Start: ast.Position{
													Column: 18,
													Line:   18,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   18,
													},
													File:   "monitor.flux",
													Source: "start: start",
													Start: ast.Position{
														Column: 18,
														Line:   18,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 23,
															Line:   18,
														},
														File:   "monitor.flux",
														Source: "start",
														Start: ast.Position{
															Column: 18,
															Line:   18,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   18,
														},
														File:   "monitor.flux",
														Source: "start",
														Start: ast.Position{
															Column: 25,
															Line:   18,
														},
													},
												},
												Name: "start",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   18,
													},
													File:   "monitor.flux",
													Source: "stop: stop",
													Start: ast.Position{
														Column: 32,
														Line:   18,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   18,
														},
														File:   "monitor.flux",
														Source: "stop",
														Start: ast.Position{
															Column: 32,
															Line:   18,
														},
													},
												},
												Name: "stop",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   18,
														},
														File:   "monitor.flux",
														Source: "stop",
														Start: ast.Position{
															Column: 38,
															Line:   18,
														},
													},
												},
												Name: "stop",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   18,
											},
											File:   "monitor.flux",
											Source: "range(start: start, stop: stop)",
											Start: ast.Position{
												Column: 12,
												Line:   18,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   18,
												},
												File:   "monitor.flux",
												Source: "range",
												Start: ast.Position{
													Column: 12,
													Line:   18,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   19,
									},
									File:   "monitor.flux",
									Source: "influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"statuses\")",
									Start: ast.Position{
										Column: 5,
										Line:   17,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   19,
											},
											File:   "monitor.flux",
											Source: "fn: (r) => r._measurement == \"statuses\"",
											Start: ast.Position{
												Column: 19,
												Line:   19,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   19,
												},
												File:   "monitor.flux",
												Source: "fn: (r) => r._measurement == \"statuses\"",
												Start: ast.Position{
													Column: 19,
													Line:   19,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   19,
													},
													File:   "monitor.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 19,
														Line:   19,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   19,
													},
													File:   "monitor.flux",
													Source: "(r) => r._measurement == \"statuses\"",
													Start: ast.Position{
														Column: 23,
														Line:   19,
													},
												},
											},
											Body: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   19,
														},
														File:   "monitor.flux",
														Source: "r._measurement == \"statuses\"",
														Start: ast.Position{
															Column: 30,
															Line:   19,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   19,
															},
															File:   "monitor.flux",
															Source: "r._measurement",
															Start: ast.Position{
																Column: 30,
																Line:   19,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   19,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 30,
																	Line:   19,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   19,
																},
																File:   "monitor.flux",
																Source: "_measurement",
																Start: ast.Position{
																	Column: 32,
																	Line:   19,
																},
															},
														},
														Name: "_measurement",
													},
													Rbrack: nil,
												},
												Operator: 17,
												Right: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 58,
																Line:   19,
															},
															File:   "monitor.flux",
															Source: "\"statuses\"",
															Start: ast.Position{
																Column: 48,
																Line:   19,
															},
														},
													},
													Value: "statuses",
												},
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   19,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 24,
															Line:   19,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   19,
															},
															File:   "monitor.flux",
															Source: "r",
															Start: ast.Position{
																Column: 24,
																Line:   19,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   19,
										},
										File:   "monitor.flux",
										Source: "filter(fn: (r) => r._measurement == \"statuses\")",
										Start: ast.Position{
											Column: 12,
											Line:   19,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   19,
											},
											File:   "monitor.flux",
											Source: "filter",
											Start: ast.Position{
												Column: 12,
												Line:   19,
											},
										},
									},
									Name: "filter",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   20,
								},
								File:   "monitor.flux",
								Source: "influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"statuses\")\n        |> filter(fn: fn)",
								Start: ast.Position{
									Column: 5,
									Line:   17,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   20,
										},
										File:   "monitor.flux",
										Source: "fn: fn",
										Start: ast.Position{
											Column: 19,
											Line:   20,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   20,
											},
											File:   "monitor.flux",
											Source: "fn: fn",
											Start: ast.Position{
												Column: 19,
												Line:   20,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   20,
												},
												File:   "monitor.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 19,
													Line:   20,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   20,
												},
												File:   "monitor.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 23,
													Line:   20,
												},
											},
										},
										Name: "fn",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   20,
									},
									File:   "monitor.flux",
									Source: "filter(fn: fn)",
									Start: ast.Position{
										Column: 12,
										Line:   20,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   20,
										},
										File:   "monitor.flux",
										Source: "filter",
										Start: ast.Position{
											Column: 12,
											Line:   20,
										},
									},
								},
								Name: "filter",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   21,
							},
							File:   "monitor.flux",
							Source: "influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"statuses\")\n        |> filter(fn: fn)\n        |> v1.fieldsAsCols()",
							Start: ast.Position{
								Column: 5,
								Line:   17,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   21,
								},
								File:   "monitor.flux",
								Source: "v1.fieldsAsCols()",
								Start: ast.Position{
									Column: 12,
									Line:   21,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   21,
									},
									File:   "monitor.flux",
									Source: "v1.fieldsAsCols",
									Start: ast.Position{
										Column: 12,
										Line:   21,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   21,
										},
										File:   "monitor.flux",
										Source: "v1",
										Start: ast.Position{
											Column: 12,
											Line:   21,
										},
									},
								},
								Name: "v1",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   21,
										},
										File:   "monitor.flux",
										Source: "fieldsAsCols",
										Start: ast.Position{
											Column: 15,
											Line:   21,
										},
									},
								},
								Name: "fieldsAsCols",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   16,
							},
							File:   "monitor.flux",
							Source: "start",
							Start: ast.Position{
								Column: 9,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   16,
								},
								File:   "monitor.flux",
								Source: "start",
								Start: ast.Position{
									Column: 9,
									Line:   16,
								},
							},
						},
						Name: "start",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   16,
							},
							File:   "monitor.flux",
							Source: "stop=now()",
							Start: ast.Position{
								Column: 16,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   16,
								},
								File:   "monitor.flux",
								Source: "stop",
								Start: ast.Position{
									Column: 16,
									Line:   16,
								},
							},
						},
						Name: "stop",
					},
					Separator: nil,
					Value: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   16,
								},
								File:   "monitor.flux",
								Source: "now()",
								Start: ast.Position{
									Column: 21,
									Line:   16,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   16,
									},
									File:   "monitor.flux",
									Source: "now",
									Start: ast.Position{
										Column: 21,
										Line:   16,
									},
								},
							},
							Name: "now",
						},
						Lparen: nil,
						Rparen: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   16,
							},
							File:   "monitor.flux",
							Source: "fn=(r) => true",
							Start: ast.Position{
								Column: 28,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   16,
								},
								File:   "monitor.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 28,
									Line:   16,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   16,
								},
								File:   "monitor.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 31,
									Line:   16,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   16,
									},
									File:   "monitor.flux",
									Source: "true",
									Start: ast.Position{
										Column: 38,
										Line:   16,
									},
								},
							},
							Name: "true",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   16,
									},
									File:   "monitor.flux",
									Source: "r",
									Start: ast.Position{
										Column: 32,
										Line:   16,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   16,
										},
										File:   "monitor.flux",
										Source: "r",
										Start: ast.Position{
											Column: 32,
											Line:   16,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   24,
					},
					File:   "monitor.flux",
					Source: "levelOK = \"ok\"",
					Start: ast.Position{
						Column: 1,
						Line:   24,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// levels describing the result of a check\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   24,
						},
						File:   "monitor.flux",
						Source: "levelOK",
						Start: ast.Position{
							Column: 1,
							Line:   24,
						},
					},
				},
				Name: "levelOK",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   24,
						},
						File:   "monitor.flux",
						Source: "\"ok\"",
						Start: ast.Position{
							Column: 11,
							Line:   24,
						},
					},
				},
				Value: "ok",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   25,
					},
					File:   "monitor.flux",
					Source: "levelInfo = \"info\"",
					Start: ast.Position{
						Column: 1,
						Line:   25,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   25,
						},
						File:   "monitor.flux",
						Source: "levelInfo",
						Start: ast.Position{
							Column: 1,
							Line:   25,
						},
					},
				},
				Name: "levelInfo",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   25,
						},
						File:   "monitor.flux",
						Source: "\"info\"",
						Start: ast.Position{
							Column: 13,
							Line:   25,
						},
					},
				},
				Value: "info",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   26,
					},
					File:   "monitor.flux",
					Source: "levelWarn = \"warn\"",
					Start: ast.Position{
						Column: 1,
						Line:   26,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   26,
						},
						File:   "monitor.flux",
						Source: "levelWarn",
						Start: ast.Position{
							Column: 1,
							Line:   26,
						},
					},
				},
				Name: "levelWarn",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   26,
						},
						File:   "monitor.flux",
						Source: "\"warn\"",
						Start: ast.Position{
							Column: 13,
							Line:   26,
						},
					},
				},
				Value: "warn",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   27,
					},
					File:   "monitor.flux",
					Source: "levelCrit = \"crit\"",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   27,
						},
						File:   "monitor.flux",
						Source: "levelCrit",
						Start: ast.Position{
							Column: 1,
							Line:   27,
						},
					},
				},
				Name: "levelCrit",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   27,
						},
						File:   "monitor.flux",
						Source: "\"crit\"",
						Start: ast.Position{
							Column: 13,
							Line:   27,
						},
					},
				},
				Value: "crit",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   28,
					},
					File:   "monitor.flux",
					Source: "levelUnknown = \"unknown\"",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   28,
						},
						File:   "monitor.flux",
						Source: "levelUnknown",
						Start: ast.Position{
							Column: 1,
							Line:   28,
						},
					},
				},
				Name: "levelUnknown",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   28,
						},
						File:   "monitor.flux",
						Source: "\"unknown\"",
						Start: ast.Position{
							Column: 16,
							Line:   28,
						},
					},
				},
				Value: "unknown",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   49,
					},
					File:   "monitor.flux",
					Source: "_stateChanges = (fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    toLevelFilter = if toLevel == \"any\" then (r) => r._level != fromLevel and exists r._level\n                   else (r) => r._level == toLevel\n\n    fromLevelFilter = if fromLevel == \"any\" then (r) => r._level != toLevel and exists r._level\n                   else (r) => r._level == fromLevel\n\n    return tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   30,
						},
						File:   "monitor.flux",
						Source: "_stateChanges",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "_stateChanges",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   49,
						},
						File:   "monitor.flux",
						Source: "(fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    toLevelFilter = if toLevel == \"any\" then (r) => r._level != fromLevel and exists r._level\n                   else (r) => r._level == toLevel\n\n    fromLevelFilter = if fromLevel == \"any\" then (r) => r._level != toLevel and exists r._level\n                   else (r) => r._level == fromLevel\n\n    return tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
						Start: ast.Position{
							Column: 17,
							Line:   30,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   49,
							},
							File:   "monitor.flux",
							Source: "{\n    toLevelFilter = if toLevel == \"any\" then (r) => r._level != fromLevel and exists r._level\n                   else (r) => r._level == toLevel\n\n    fromLevelFilter = if fromLevel == \"any\" then (r) => r._level != toLevel and exists r._level\n                   else (r) => r._level == fromLevel\n\n    return tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
							Start: ast.Position{
								Column: 64,
								Line:   30,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   32,
								},
								File:   "monitor.flux",
								Source: "toLevelFilter = if toLevel == \"any\" then (r) => r._level != fromLevel and exists r._level\n                   else (r) => r._level == toLevel",
								Start: ast.Position{
									Column: 5,
									Line:   31,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   31,
									},
									File:   "monitor.flux",
									Source: "toLevelFilter",
									Start: ast.Position{
										Column: 5,
										Line:   31,
									},
								},
							},
							Name: "toLevelFilter",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   32,
										},
										File:   "monitor.flux",
										Source: "(r) => r._level == toLevel",
										Start: ast.Position{
											Column: 25,
											Line:   32,
										},
									},
								},
								Body: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   32,
											},
											File:   "monitor.flux",
											Source: "r._level == toLevel",
											Start: ast.Position{
												Column: 32,
												Line:   32,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   32,
												},
												File:   "monitor.flux",
												Source: "r._level",
												Start: ast.Position{
													Column: 32,
													Line:   32,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   32,
													},
													File:   "monitor.flux",
													Source: "r",
													Start: ast.Position{
														Column: 32,
														Line:   32,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   32,
													},
													File:   "monitor.flux",
													Source: "_level",
													Start: ast.Position{
														Column: 34,
														Line:   32,
													},
												},
											},
											Name: "_level",
										},
										Rbrack: nil,
									},
									Operator: 17,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   32,
												},
												File:   "monitor.flux",
												Source: "toLevel",
												Start: ast.Position{
													Column: 44,
													Line:   32,
												},
											},
										},
										Name: "toLevel",
									},
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   32,
											},
											File:   "monitor.flux",
											Source: "r",
											Start: ast.Position{
												Column: 26,
												Line:   32,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   32,
												},
												File:   "monitor.flux",
												Source: "r",
												Start: ast.Position{
													Column: 26,
													Line:   32,
												},
											},
										},
										Name: "r",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   32,
									},
									File:   "monitor.flux",
									Source: "if toLevel == \"any\" then (r) => r._level != fromLevel and exists r._level\n                   else (r) => r._level == toLevel",
									Start: ast.Position{
										Column: 21,
										Line:   31,
									},
								},
							},
							Consequent: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 94,
											Line:   31,
										},
										File:   "monitor.flux",
										Source: "(r) => r._level != fromLevel and exists r._level",
										Start: ast.Position{
											Column: 46,
											Line:   31,
										},
									},
								},
								Body: &ast.LogicalExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 94,
												Line:   31,
											},
											File:   "monitor.flux",
											Source: "r._level != fromLevel and exists r._level",
											Start: ast.Position{
												Column: 53,
												Line:   31,
											},
										},
									},
									Left: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   31,
												},
												File:   "monitor.flux",
												Source: "r._level != fromLevel",
												Start: ast.Position{
													Column: 53,
													Line:   31,
												},
											},
										},
										Left: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   31,
													},
													File:   "monitor.flux",
													Source: "r._level",
													Start: ast.Position{
														Column: 53,
														Line:   31,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 54,
															Line:   31,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 53,
															Line:   31,
														},
													},
												},
												Name: "r",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   31,
														},
														File:   "monitor.flux",
														Source: "_level",
														Start: ast.Position{
															Column: 55,
															Line:   31,
														},
													},
												},
												Name: "_level",
											},
											Rbrack: nil,
										},
										Operator: 18,
										Right: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   31,
													},
													File:   "monitor.flux",
													Source: "fromLevel",
													Start: ast.Position{
														Column: 65,
														Line:   31,
													},
												},
											},
											Name: "fromLevel",
										},
									},
									Operator: 1,
									Right: &ast.UnaryExpression{
										Argument: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 94,
														Line:   31,
													},
													File:   "monitor.flux",
													Source: "r._level",
													Start: ast.Position{
														Column: 86,
														Line:   31,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 87,
															Line:   31,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 86,
															Line:   31,
														},
													},
												},
												Name: "r",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 94,
															Line:   31,
														},
														File:   "monitor.flux",
														Source: "_level",
														Start: ast.Position{
															Column: 88,
															Line:   31,
														},
													},
												},
												Name: "_level",
											},
											Rbrack: nil,
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   31,
												},
												File:   "monitor.flux",
												Source: "exists r._level",
												Start: ast.Position{
													Column: 79,
													Line:   31,
												},
											},
										},
										Operator: 14,
									},
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   31,
											},
											File:   "monitor.flux",
											Source: "r",
											Start: ast.Position{
												Column: 47,
												Line:   31,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   31,
												},
												File:   "monitor.flux",
												Source: "r",
												Start: ast.Position{
													Column: 47,
													Line:   31,
												},
											},
										},
										Name: "r",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   31,
										},
										File:   "monitor.flux",
										Source: "toLevel == \"any\"",
										Start: ast.Position{
											Column: 24,
											Line:   31,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   31,
											},
											File:   "monitor.flux",
											Source: "toLevel",
											Start: ast.Position{
												Column: 24,
												Line:   31,
											},
										},
									},
									Name: "toLevel",
								},
								Operator: 17,
								Right: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   31,
											},
											File:   "monitor.flux",
											Source: "\"any\"",
											Start: ast.Position{
												Column: 35,
												Line:   31,
											},
										},
									},
									Value: "any",
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   35,
								},
								File:   "monitor.flux",
								Source: "fromLevelFilter = if fromLevel == \"any\" then (r) => r._level != toLevel and exists r._level\n                   else (r) => r._level == fromLevel",
								Start: ast.Position{
									Column: 5,
									Line:   34,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   34,
									},
									File:   "monitor.flux",
									Source: "fromLevelFilter",
									Start: ast.Position{
										Column: 5,
										Line:   34,
									},
								},
							},
							Name: "fromLevelFilter",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   35,
										},
										File:   "monitor.flux",
										Source: "(r) => r._level == fromLevel",
										Start: ast.Position{
											Column: 25,
											Line:   35,
										},
									},
								},
								Body: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   35,
											},
											File:   "monitor.flux",
											Source: "r._level == fromLevel",
											Start: ast.Position{
												Column: 32,
												Line:   35,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   35,
												},
												File:   "monitor.flux",
												Source: "r._level",
												Start: ast.Position{
													Column: 32,
													Line:   35,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   35,
													},
													File:   "monitor.flux",
													Source: "r",
													Start: ast.Position{
														Column: 32,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   35,
													},
													File:   "monitor.flux",
													Source: "_level",
													Start: ast.Position{
														Column: 34,
														Line:   35,
													},
												},
											},
											Name: "_level",
										},
										Rbrack: nil,
									},
									Operator: 17,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   35,
												},
												File:   "monitor.flux",
												Source: "fromLevel",
												Start: ast.Position{
													Column: 44,
													Line:   35,
												},
											},
										},
										Name: "fromLevel",
									},
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   35,
											},
											File:   "monitor.flux",
											Source: "r",
											Start: ast.Position{
												Column: 26,
												Line:   35,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   35,
												},
												File:   "monitor.flux",
												Source: "r",
												Start: ast.Position{
													Column: 26,
													Line:   35,
												},
											},
										},
										Name: "r",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   35,
									},
									File:   "monitor.flux",
									Source: "if fromLevel == \"any\" then (r) => r._level != toLevel and exists r._level\n                   else (r) => r._level == fromLevel",
									Start: ast.Position{
										Column: 23,
										Line:   34,
									},
								},
							},
							Consequent: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 96,
											Line:   34,
										},
										File:   "monitor.flux",
										Source: "(r) => r._level != toLevel and exists r._level",
										Start: ast.Position{
											Column: 50,
											Line:   34,
										},
									},
								},
								Body: &ast.LogicalExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 96,
												Line:   34,
											},
											File:   "monitor.flux",
											Source: "r._level != toLevel and exists r._level",
											Start: ast.Position{
												Column: 57,
												Line:   34,
											},
										},
									},
									Left: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 76,
													Line:   34,
												},
												File:   "monitor.flux",
												Source: "r._level != toLevel",
												Start: ast.Position{
													Column: 57,
													Line:   34,
												},
											},
										},
										Left: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 65,
														Line:   34,
													},
													File:   "monitor.flux",
													Source: "r._level",
													Start: ast.Position{
														Column: 57,
														Line:   34,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   34,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 57,
															Line:   34,
														},
													},
												},
												Name: "r",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   34,
														},
														File:   "monitor.flux",
														Source: "_level",
														Start: ast.Position{
															Column: 59,
															Line:   34,
														},
													},
												},
												Name: "_level",
											},
											Rbrack: nil,
										},
										Operator: 18,
										Right: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 76,
														Line:   34,
													},
													File:   "monitor.flux",
													Source: "toLevel",
													Start: ast.Position{
														Column: 69,
														Line:   34,
													},
												},
											},
											Name: "toLevel",
										},
									},
									Operator: 1,
									Right: &ast.UnaryExpression{
										Argument: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 96,
														Line:   34,
													},
													File:   "monitor.flux",
													Source: "r._level",
													Start: ast.Position{
														Column: 88,
														Line:   34,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 89,
															Line:   34,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 88,
															Line:   34,
														},
													},
												},
												Name: "r",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 96,
															Line:   34,
														},
														File:   "monitor.flux",
														Source: "_level",
														Start: ast.Position{
															Column: 90,
															Line:   34,
														},
													},
												},
												Name: "_level",
											},
											Rbrack: nil,
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 96,
													Line:   34,
												},
												File:   "monitor.flux",
												Source: "exists r._level",
												Start: ast.Position{
													Column: 81,
													Line:   34,
												},
											},
										},
										Operator: 14,
									},
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   34,
											},
											File:   "monitor.flux",
											Source: "r",
											Start: ast.Position{
												Column: 51,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   34,
												},
												File:   "monitor.flux",
												Source: "r",
												Start: ast.Position{
													Column: 51,
													Line:   34,
												},
											},
										},
										Name: "r",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   34,
										},
										File:   "monitor.flux",
										Source: "fromLevel == \"any\"",
										Start: ast.Position{
											Column: 26,
											Line:   34,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   34,
											},
											File:   "monitor.flux",
											Source: "fromLevel",
											Start: ast.Position{
												Column: 26,
												Line:   34,
											},
										},
									},
									Name: "fromLevel",
								},
								Operator: 17,
								Right: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   34,
											},
											File:   "monitor.flux",
											Source: "\"any\"",
											Start: ast.Position{
												Column: 39,
												Line:   34,
											},
										},
									},
									Value: "any",
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.PipeExpression{
												Argument: &ast.PipeExpression{
													Argument: &ast.PipeExpression{
														Argument: &ast.PipeExpression{
															Argument: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   37,
																		},
																		File:   "monitor.flux",
																		Source: "tables",
																		Start: ast.Position{
																			Column: 12,
																			Line:   37,
																		},
																	},
																},
																Name: "tables",
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 60,
																		Line:   40,
																	},
																	File:   "monitor.flux",
																	Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))",
																	Start: ast.Position{
																		Column: 12,
																		Line:   37,
																	},
																},
															},
															Call: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 59,
																				Line:   40,
																			},
																			File:   "monitor.flux",
																			Source: "fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10})",
																			Start: ast.Position{
																				Column: 16,
																				Line:   38,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 59,
																					Line:   40,
																				},
																				File:   "monitor.flux",
																				Source: "fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10})",
																				Start: ast.Position{
																					Column: 16,
																					Line:   38,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 18,
																						Line:   38,
																					},
																					File:   "monitor.flux",
																					Source: "fn",
																					Start: ast.Position{
																						Column: 16,
																						Line:   38,
																					},
																				},
																			},
																			Name: "fn",
																		},
																		Separator: nil,
																		Value: &ast.FunctionExpression{
																			Arrow: nil,
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 59,
																						Line:   40,
																					},
																					File:   "monitor.flux",
																					Source: "(r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10})",
																					Start: ast.Position{
																						Column: 20,
																						Line:   38,
																					},
																				},
																			},
																			Body: &ast.ParenExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 59,
																							Line:   40,
																						},
																						File:   "monitor.flux",
																						Source: "({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10})",
																						Start: ast.Position{
																							Column: 27,
																							Line:   38,
																						},
																					},
																				},
																				Expression: &ast.ObjectExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 58,
																								Line:   40,
																							},
																							File:   "monitor.flux",
																							Source: "{r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}",
																							Start: ast.Position{
																								Column: 28,
																								Line:   38,
																							},
																						},
																					},
																					Lbrace: nil,
																					Properties: []*ast.Property{&ast.Property{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 57,
																									Line:   40,
																								},
																								File:   "monitor.flux",
																								Source: "level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10",
																								Start: ast.Position{
																									Column: 36,
																									Line:   38,
																								},
																							},
																						},
																						Comma: nil,
																						Key: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 47,
																										Line:   38,
																									},
																									File:   "monitor.flux",
																									Source: "level_value",
																									Start: ast.Position{
																										Column: 36,
																										Line:   38,
																									},
																								},
																							},
																							Name: "level_value",
																						},
																						Separator: nil,
																						Value: &ast.ConditionalExpression{
																							Alternate: &ast.ConditionalExpression{
																								Alternate: &ast.UnaryExpression{
																									Argument: &ast.IntegerLiteral{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 57,
																													Line:   40,
																												},
																												File:   "monitor.flux",
																												Source: "10",
																												Start: ast.Position{
																													Column: 55,
																													Line:   40,
																												},
																											},
																										},
																										Value: int64(10),
																									},
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 57,
																												Line:   40,
																											},
																											File:   "monitor.flux",
																											Source: "-10",
																											Start: ast.Position{
																												Column: 54,
																												Line:   40,
																											},
																										},
																									},
																									Operator: 6,
																								},
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 57,
																											Line:   40,
																										},
																										File:   "monitor.flux",
																										Source: "if fromLevelFilter(r: r) then 0\n                                                else -10",
																										Start: ast.Position{
																											Column: 54,
																											Line:   39,
																										},
																									},
																								},
																								Consequent: &ast.IntegerLiteral{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 85,
																												Line:   39,
																											},
																											File:   "monitor.flux",
																											Source: "0",
																											Start: ast.Position{
																												Column: 84,
																												Line:   39,
																											},
																										},
																									},
																									Value: int64(0),
																								},
																								Test: &ast.CallExpression{
																									Arguments: []ast.Expression{&ast.ObjectExpression{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 77,
																													Line:   39,
																												},
																												File:   "monitor.flux",
																												Source: "r: r",
																												Start: ast.Position{
																													Column: 73,
																													Line:   39,
																												},
																											},
																										},
																										Lbrace: nil,
																										Properties: []*ast.Property{&ast.Property{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 77,
																														Line:   39,
																													},
																													File:   "monitor.flux",
																													Source: "r: r",
																													Start: ast.Position{
																														Column: 73,
																														Line:   39,
																													},
																												},
																											},
																											Comma: nil,
																											Key: &ast.Identifier{
																												BaseNode: ast.BaseNode{
																													Comments: nil,
																													Errors:   nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 74,
																															Line:   39,
																														},
																														File:   "monitor.flux",
																														Source: "r",
																														Start: ast.Position{
																															Column: 73,
																															Line:   39,
																														},
																													},
																												},
																												Name: "r",
																											},
																											Separator: nil,
																											Value: &ast.Identifier{
																												BaseNode: ast.BaseNode{
																													Comments: nil,
																													Errors:   nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 77,
																															Line:   39,
																														},
																														File:   "monitor.flux",
																														Source: "r",
																														Start: ast.Position{
																															Column: 76,
																															Line:   39,
																														},
																													},
																												},
																												Name: "r",
																											},
																										}},
																										Rbrace: nil,
																										With:   nil,
																									}},
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 78,
																												Line:   39,
																											},
																											File:   "monitor.flux",
																											Source: "fromLevelFilter(r: r)",
																											Start: ast.Position{
																												Column: 57,
																												Line:   39,
																											},
																										},
																									},
																									Callee: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 72,
																													Line:   39,
																												},
																												File:   "monitor.flux",
																												Source: "fromLevelFilter",
																												Start: ast.Position{
																													Column: 57,
																													Line:   39,
																												},
																											},
																										},
																										Name: "fromLevelFilter",
																									},
																									Lparen: nil,
																									Rparen: nil,
																								},
																								Tk_else: nil,
																								Tk_if:   nil,
																								Tk_then: nil,
																							},
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 57,
																										Line:   40,
																									},
																									File:   "monitor.flux",
																									Source: "if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10",
																									Start: ast.Position{
																										Column: 49,
																										Line:   38,
																									},
																								},
																							},
																							Consequent: &ast.IntegerLiteral{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 78,
																											Line:   38,
																										},
																										File:   "monitor.flux",
																										Source: "1",
																										Start: ast.Position{
																											Column: 77,
																											Line:   38,
																										},
																									},
																								},
																								Value: int64(1),
																							},
																							Test: &ast.CallExpression{
																								Arguments: []ast.Expression{&ast.ObjectExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 70,
																												Line:   38,
																											},
																											File:   "monitor.flux",
																											Source: "r: r",
																											Start: ast.Position{
																												Column: 66,
																												Line:   38,
																											},
																										},
																									},
																									Lbrace: nil,
																									Properties: []*ast.Property{&ast.Property{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 70,
																													Line:   38,
																												},
																												File:   "monitor.flux",
																												Source: "r: r",
																												Start: ast.Position{
																													Column: 66,
																													Line:   38,
																												},
																											},
																										},
																										Comma: nil,
																										Key: &ast.Identifier{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 67,
																														Line:   38,
																													},
																													File:   "monitor.flux",
																													Source: "r",
																													Start: ast.Position{
																														Column: 66,
																														Line:   38,
																													},
																												},
																											},
																											Name: "r",
																										},
																										Separator: nil,
																										Value: &ast.Identifier{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 70,
																														Line:   38,
																													},
																													File:   "monitor.flux",
																													Source: "r",
																													Start: ast.Position{
																														Column: 69,
																														Line:   38,
																													},
																												},
																											},
																											Name: "r",
																										},
																									}},
																									Rbrace: nil,
																									With:   nil,
																								}},
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 71,
																											Line:   38,
																										},
																										File:   "monitor.flux",
																										Source: "toLevelFilter(r: r)",
																										Start: ast.Position{
																											Column: 52,
																											Line:   38,
																										},
																									},
																								},
																								Callee: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 65,
																												Line:   38,
																											},
																											File:   "monitor.flux",
																											Source: "toLevelFilter",
																											Start: ast.Position{
																												Column: 52,
																												Line:   38,
																											},
																										},
																									},
																									Name: "toLevelFilter",
																								},
																								Lparen: nil,
																								Rparen: nil,
																							},
																							Tk_else: nil,
																							Tk_if:   nil,
																							Tk_then: nil,
																						},
																					}},
																					Rbrace: nil,
																					With: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 30,
																									Line:   38,
																								},
																								File:   "monitor.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 29,
																									Line:   38,
																								},
																							},
																						},
																						Name: "r",
																					},
																				},
																				Lparen: nil,
																				Rparen: nil,
																			},
																			Lparen: nil,
																			Params: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 22,
																							Line:   38,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 21,
																							Line:   38,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 22,
																								Line:   38,
																							},
																							File:   "monitor.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 21,
																								Line:   38,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Separator: nil,
																				Value:     nil,
																			}},
																			Rparan: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 60,
																			Line:   40,
																		},
																		File:   "monitor.flux",
																		Source: "map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))",
																		Start: ast.Position{
																			Column: 12,
																			Line:   38,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 15,
																				Line:   38,
																			},
																			File:   "monitor.flux",
																			Source: "map",
																			Start: ast.Position{
																				Column: 12,
																				Line:   38,
																			},
																		},
																	},
																	Name: "map",
																},
																Lparen: nil,
																Rparen: nil,
															},
														},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 65,
																	Line:   41,
																},
																File:   "monitor.flux",
																Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")",
																Start: ast.Position{
																	Column: 12,
																	Line:   37,
																},
															},
														},
														Call: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 64,
																			Line:   41,
																		},
																		File:   "monitor.flux",
																		Source: "column: \"_level\", as: \"____temp_level____\"",
																		Start: ast.Position{
																			Column: 22,
																			Line:   41,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 38,
																				Line:   41,
																			},
																			File:   "monitor.flux",
																			Source: "column: \"_level\"",
																			Start: ast.Position{
																				Column: 22,
																				Line:   41,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   41,
																				},
																				File:   "monitor.flux",
																				Source: "column",
																				Start: ast.Position{
																					Column: 22,
																					Line:   41,
																				},
																			},
																		},
																		Name: "column",
																	},
																	Separator: nil,
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 38,
																					Line:   41,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 30,
																					Line:   41,
																				},
																			},
																		},
																		Value: "_level",
																	},
																}, &ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 64,
																				Line:   41,
																			},
																			File:   "monitor.flux",
																			Source: "as: \"____temp_level____\"",
																			Start: ast.Position{
																				Column: 40,
																				Line:   41,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 42,
																					Line:   41,
																				},
																				File:   "monitor.flux",
																				Source: "as",
																				Start: ast.Position{
																					Column: 40,
																					Line:   41,
																				},
																			},
																		},
																		Name: "as",
																	},
																	Separator: nil,
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 64,
																					Line:   41,
																				},
																				File:   "monitor.flux",
																				Source: "\"____temp_level____\"",
																				Start: ast.Position{
																					Column: 44,
																					Line:   41,
																				},
																			},
																		},
																		Value: "____temp_level____",
																	},
																}},
																Rbrace: nil,
																With:   nil,
															}},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 65,
																		Line:   41,
																	},
																	File:   "monitor.flux",
																	Source: "duplicate(column: \"_level\", as: \"____temp_level____\")",
																	Start: ast.Position{
																		Column: 12,
																		Line:   41,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   41,
																		},
																		File:   "monitor.flux",
																		Source: "duplicate",
																		Start: ast.Position{
																			Column: 12,
																			Line:   41,
																		},
																	},
																},
																Name: "duplicate",
															},
															Lparen: nil,
															Rparen: nil,
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   42,
															},
															File:   "monitor.flux",
															Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])",
															Start: ast.Position{
																Column: 12,
																Line:   37,
															},
														},
													},
													Call: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   42,
																	},
																	File:   "monitor.flux",
																	Source: "columns: [\"_level\"]",
																	Start: ast.Position{
																		Column: 17,
																		Line:   42,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   42,
																		},
																		File:   "monitor.flux",
																		Source: "columns: [\"_level\"]",
																		Start: ast.Position{
																			Column: 17,
																			Line:   42,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   42,
																			},
																			File:   "monitor.flux",
																			Source: "columns",
																			Start: ast.Position{
																				Column: 17,
																				Line:   42,
																			},
																		},
																	},
																	Name: "columns",
																},
																Separator: nil,
																Value: &ast.ArrayExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 36,
																				Line:   42,
																			},
																			File:   "monitor.flux",
																			Source: "[\"_level\"]",
																			Start: ast.Position{
																				Column: 26,
																				Line:   42,
																			},
																		},
																	},
																	Elements: []ast.Expression{&ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 35,
																					Line:   42,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 27,
																					Line:   42,
																				},
																			},
																		},
																		Value: "_level",
																	}},
																	Lbrack: nil,
																	Rbrack: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   42,
																},
																File:   "monitor.flux",
																Source: "drop(columns: [\"_level\"])",
																Start: ast.Position{
																	Column: 12,
																	Line:   42,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 16,
																		Line:   42,
																	},
																	File:   "monitor.flux",
																	Source: "drop",
																	Start: ast.Position{
																		Column: 12,
																		Line:   42,
																	},
																},
															},
															Name: "drop",
														},
														Lparen: nil,
														Rparen: nil,
													},
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   43,
														},
														File:   "monitor.flux",
														Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})",
														Start: ast.Position{
															Column: 12,
															Line:   37,
														},
													},
												},
												Call: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 60,
																	Line:   43,
																},
																File:   "monitor.flux",
																Source: "columns: {\"____temp_level____\": \"_level\"}",
																Start: ast.Position{
																	Column: 19,
																	Line:   43,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 60,
																		Line:   43,
																	},
																	File:   "monitor.flux",
																	Source: "columns: {\"____temp_level____\": \"_level\"}",
																	Start: ast.Position{
																		Column: 19,
																		Line:   43,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 26,
																			Line:   43,
																		},
																		File:   "monitor.flux",
																		Source: "columns",
																		Start: ast.Position{
																			Column: 19,
																			Line:   43,
																		},
																	},
																},
																Name: "columns",
															},
															Separator: nil,
															Value: &ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 60,
																			Line:   43,
																		},
																		File:   "monitor.flux",
																		Source: "{\"____temp_level____\": \"_level\"}",
																		Start: ast.Position{
																			Column: 28,
																			Line:   43,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 59,
																				Line:   43,
																			},
																			File:   "monitor.flux",
																			Source: "\"____temp_level____\": \"_level\"",
																			Start: ast.Position{
																				Column: 29,
																				Line:   43,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 49,
																					Line:   43,
																				},
																				File:   "monitor.flux",
																				Source: "\"____temp_level____\"",
																				Start: ast.Position{
																					Column: 29,
																					Line:   43,
																				},
																			},
																		},
																		Value: "____temp_level____",
																	},
																	Separator: nil,
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 59,
																					Line:   43,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 51,
																					Line:   43,
																				},
																			},
																		},
																		Value: "_level",
																	},
																}},
																Rbrace: nil,
																With:   nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 61,
																Line:   43,
															},
															File:   "monitor.flux",
															Source: "rename(columns: {\"____temp_level____\": \"_level\"})",
															Start: ast.Position{
																Column: 12,
																Line:   43,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   43,
																},
																File:   "monitor.flux",
																Source: "rename",
																Start: ast.Position{
																	Column: 12,
																	Line:   43,
																},
															},
														},
														Name: "rename",
													},
													Lparen: nil,
													Rparen: nil,
												},
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   44,
													},
													File:   "monitor.flux",
													Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)",
													Start: ast.Position{
														Column: 12,
														Line:   37,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 60,
																Line:   44,
															},
															File:   "monitor.flux",
															Source: "columns: [\"_source_timestamp\"], desc: false",
															Start: ast.Position{
																Column: 17,
																Line:   44,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   44,
																},
																File:   "monitor.flux",
																Source: "columns: [\"_source_timestamp\"]",
																Start: ast.Position{
																	Column: 17,
																	Line:   44,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   44,
																	},
																	File:   "monitor.flux",
																	Source: "columns",
																	Start: ast.Position{
																		Column: 17,
																		Line:   44,
																	},
																},
															},
															Name: "columns",
														},
														Separator: nil,
														Value: &ast.ArrayExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   44,
																	},
																	File:   "monitor.flux",
																	Source: "[\"_source_timestamp\"]",
																	Start: ast.Position{
																		Column: 26,
																		Line:   44,
																	},
																},
															},
															Elements: []ast.Expression{&ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   44,
																		},
																		File:   "monitor.flux",
																		Source: "\"_source_timestamp\"",
																		Start: ast.Position{
																			Column: 27,
																			Line:   44,
																		},
																	},
																},
																Value: "_source_timestamp",
															}},
															Lbrack: nil,
															Rbrack: nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 60,
																	Line:   44,
																},
																File:   "monitor.flux",
																Source: "desc: false",
																Start: ast.Position{
																	Column: 49,
																	Line:   44,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 53,
																		Line:   44,
																	},
																	File:   "monitor.flux",
																	Source: "desc",
																	Start: ast.Position{
																		Column: 49,
																		Line:   44,
																	},
																},
															},
															Name: "desc",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 60,
																		Line:   44,
																	},
																	File:   "monitor.flux",
																	Source: "false",
																	Start: ast.Position{
																		Column: 55,
																		Line:   44,
																	},
																},
															},
															Name: "false",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   44,
														},
														File:   "monitor.flux",
														Source: "sort(columns: [\"_source_timestamp\"], desc: false)",
														Start: ast.Position{
															Column: 12,
															Line:   44,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 16,
																Line:   44,
															},
															File:   "monitor.flux",
															Source: "sort",
															Start: ast.Position{
																Column: 12,
																Line:   44,
															},
														},
													},
													Name: "sort",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   45,
												},
												File:   "monitor.flux",
												Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])",
												Start: ast.Position{
													Column: 12,
													Line:   37,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   45,
														},
														File:   "monitor.flux",
														Source: "columns: [\"level_value\"]",
														Start: ast.Position{
															Column: 23,
															Line:   45,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 47,
																Line:   45,
															},
															File:   "monitor.flux",
															Source: "columns: [\"level_value\"]",
															Start: ast.Position{
																Column: 23,
																Line:   45,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   45,
																},
																File:   "monitor.flux",
																Source: "columns",
																Start: ast.Position{
																	Column: 23,
																	Line:   45,
																},
															},
														},
														Name: "columns",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   45,
																},
																File:   "monitor.flux",
																Source: "[\"level_value\"]",
																Start: ast.Position{
																	Column: 32,
																	Line:   45,
																},
															},
														},
														Elements: []ast.Expression{&ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   45,
																	},
																	File:   "monitor.flux",
																	Source: "\"level_value\"",
																	Start: ast.Position{
																		Column: 33,
																		Line:   45,
																	},
																},
															},
															Value: "level_value",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   45,
													},
													File:   "monitor.flux",
													Source: "difference(columns: [\"level_value\"])",
													Start: ast.Position{
														Column: 12,
														Line:   45,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   45,
														},
														File:   "monitor.flux",
														Source: "difference",
														Start: ast.Position{
															Column: 12,
															Line:   45,
														},
													},
												},
												Name: "difference",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   46,
											},
											File:   "monitor.flux",
											Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)",
											Start: ast.Position{
												Column: 12,
												Line:   37,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   46,
													},
													File:   "monitor.flux",
													Source: "fn: (r) => r.level_value == 1",
													Start: ast.Position{
														Column: 19,
														Line:   46,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   46,
														},
														File:   "monitor.flux",
														Source: "fn: (r) => r.level_value == 1",
														Start: ast.Position{
															Column: 19,
															Line:   46,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   46,
															},
															File:   "monitor.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 19,
																Line:   46,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   46,
															},
															File:   "monitor.flux",
															Source: "(r) => r.level_value == 1",
															Start: ast.Position{
																Column: 23,
																Line:   46,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   46,
																},
																File:   "monitor.flux",
																Source: "r.level_value == 1",
																Start: ast.Position{
																	Column: 30,
																	Line:   46,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 43,
																		Line:   46,
																	},
																	File:   "monitor.flux",
																	Source: "r.level_value",
																	Start: ast.Position{
																		Column: 30,
																		Line:   46,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   46,
																		},
																		File:   "monitor.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 30,
																			Line:   46,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 43,
																			Line:   46,
																		},
																		File:   "monitor.flux",
																		Source: "level_value",
																		Start: ast.Position{
																			Column: 32,
																			Line:   46,
																		},
																	},
																},
																Name: "level_value",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.IntegerLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   46,
																	},
																	File:   "monitor.flux",
																	Source: "1",
																	Start: ast.Position{
																		Column: 47,
																		Line:   46,
																	},
																},
															},
															Value: int64(1),
														},
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   46,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 24,
																	Line:   46,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   46,
																	},
																	File:   "monitor.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 24,
																		Line:   46,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   46,
												},
												File:   "monitor.flux",
												Source: "filter(fn: (r) => r.level_value == 1)",
												Start: ast.Position{
													Column: 12,
													Line:   46,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   46,
													},
													File:   "monitor.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 12,
														Line:   46,
													},
												},
											},
											Name: "filter",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   47,
										},
										File:   "monitor.flux",
										Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])",
										Start: ast.Position{
											Column: 12,
											Line:   37,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   47,
												},
												File:   "monitor.flux",
												Source: "columns: [\"level_value\"]",
												Start: ast.Position{
													Column: 17,
													Line:   47,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   47,
													},
													File:   "monitor.flux",
													Source: "columns: [\"level_value\"]",
													Start: ast.Position{
														Column: 17,
														Line:   47,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   47,
														},
														File:   "monitor.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 17,
															Line:   47,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   47,
														},
														File:   "monitor.flux",
														Source: "[\"level_value\"]",
														Start: ast.Position{
															Column: 26,
															Line:   47,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   47,
															},
															File:   "monitor.flux",
															Source: "\"level_value\"",
															Start: ast.Position{
																Column: 27,
																Line:   47,
															},
														},
													},
													Value: "level_value",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   47,
											},
											File:   "monitor.flux",
											Source: "drop(columns: [\"level_value\"])",
											Start: ast.Position{
												Column: 12,
												Line:   47,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   47,
												},
												File:   "monitor.flux",
												Source: "drop",
												Start: ast.Position{
													Column: 12,
													Line:   47,
												},
											},
										},
										Name: "drop",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   48,
									},
									File:   "monitor.flux",
									Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])",
									Start: ast.Position{
										Column: 12,
										Line:   37,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   48,
											},
											File:   "monitor.flux",
											Source: "mode: \"extend\", columns: [\"_level\"]",
											Start: ast.Position{
												Column: 31,
												Line:   48,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   48,
												},
												File:   "monitor.flux",
												Source: "mode: \"extend\"",
												Start: ast.Position{
													Column: 31,
													Line:   48,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   48,
													},
													File:   "monitor.flux",
													Source: "mode",
													Start: ast.Position{
														Column: 31,
														Line:   48,
													},
												},
											},
											Name: "mode",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   48,
													},
													File:   "monitor.flux",
													Source: "\"extend\"",
													Start: ast.Position{
														Column: 37,
														Line:   48,
													},
												},
											},
											Value: "extend",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   48,
												},
												File:   "monitor.flux",
												Source: "columns: [\"_level\"]",
												Start: ast.Position{
													Column: 47,
													Line:   48,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   48,
													},
													File:   "monitor.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 47,
														Line:   48,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   48,
													},
													File:   "monitor.flux",
													Source: "[\"_level\"]",
													Start: ast.Position{
														Column: 56,
														Line:   48,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   48,
														},
														File:   "monitor.flux",
														Source: "\"_level\"",
														Start: ast.Position{
															Column: 57,
															Line:   48,
														},
													},
												},
												Value: "_level",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   48,
										},
										File:   "monitor.flux",
										Source: "experimental.group(mode: \"extend\", columns: [\"_level\"])",
										Start: ast.Position{
											Column: 12,
											Line:   48,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   48,
											},
											File:   "monitor.flux",
											Source: "experimental.group",
											Start: ast.Position{
												Column: 12,
												Line:   48,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   48,
												},
												File:   "monitor.flux",
												Source: "experimental",
												Start: ast.Position{
													Column: 12,
													Line:   48,
												},
											},
										},
										Name: "experimental",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   48,
												},
												File:   "monitor.flux",
												Source: "group",
												Start: ast.Position{
													Column: 25,
													Line:   48,
												},
											},
										},
										Name: "group",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   48,
								},
								File:   "monitor.flux",
								Source: "return tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])",
								Start: ast.Position{
									Column: 5,
									Line:   37,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   30,
							},
							File:   "monitor.flux",
							Source: "fromLevel=\"any\"",
							Start: ast.Position{
								Column: 18,
								Line:   30,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   30,
								},
								File:   "monitor.flux",
								Source: "fromLevel",
								Start: ast.Position{
									Column: 18,
									Line:   30,
								},
							},
						},
						Name: "fromLevel",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   30,
								},
								File:   "monitor.flux",
								Source: "\"any\"",
								Start: ast.Position{
									Column: 28,
									Line:   30,
								},
							},
						},
						Value: "any",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   30,
							},
							File:   "monitor.flux",
							Source: "toLevel=\"any\"",
							Start: ast.Position{
								Column: 35,
								Line:   30,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   30,
								},
								File:   "monitor.flux",
								Source: "toLevel",
								Start: ast.Position{
									Column: 35,
									Line:   30,
								},
							},
						},
						Name: "toLevel",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   30,
								},
								File:   "monitor.flux",
								Source: "\"any\"",
								Start: ast.Position{
									Column: 43,
									Line:   30,
								},
							},
						},
						Value: "any",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   30,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 50,
								Line:   30,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   30,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 50,
									Line:   30,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   30,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 57,
								Line:   30,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   72,
					},
					File:   "monitor.flux",
					Source: "stateChangesOnly = (tables=<-) => {\n    return tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
					Start: ast.Position{
						Column: 1,
						Line:   57,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// stateChangesOnly takes a stream of tables that contains a _level column and\n"}, ast.Comment{Text: "// returns a stream of tables where each record in a table represents a state change\n"}, ast.Comment{Text: "// of the _level column.\n"}, ast.Comment{Text: "// Statuses are sorted by source timestamp, because default sort order of statuses may differ\n"}, ast.Comment{Text: "// (`_time` column holds the time when check was executed) and that could result in detecting\n"}, ast.Comment{Text: "// status changes at the wrong time or even false changes.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   57,
						},
						File:   "monitor.flux",
						Source: "stateChangesOnly",
						Start: ast.Position{
							Column: 1,
							Line:   57,
						},
					},
				},
				Name: "stateChangesOnly",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   72,
						},
						File:   "monitor.flux",
						Source: "(tables=<-) => {\n    return tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
						Start: ast.Position{
							Column: 20,
							Line:   57,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   72,
							},
							File:   "monitor.flux",
							Source: "{\n    return tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
							Start: ast.Position{
								Column: 35,
								Line:   57,
							},
						},
					},
					Body: []ast.Statement{&ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.PipeExpression{
												Argument: &ast.PipeExpression{
													Argument: &ast.PipeExpression{
														Argument: &ast.PipeExpression{
															Argument: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   58,
																		},
																		File:   "monitor.flux",
																		Source: "tables",
																		Start: ast.Position{
																			Column: 12,
																			Line:   58,
																		},
																	},
																},
																Name: "tables",
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 58,
																		Line:   63,
																	},
																	File:   "monitor.flux",
																	Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))",
																	Start: ast.Position{
																		Column: 12,
																		Line:   58,
																	},
																},
															},
															Call: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 57,
																				Line:   63,
																			},
																			File:   "monitor.flux",
																			Source: "fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0})",
																			Start: ast.Position{
																				Column: 16,
																				Line:   59,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 57,
																					Line:   63,
																				},
																				File:   "monitor.flux",
																				Source: "fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0})",
																				Start: ast.Position{
																					Column: 16,
																					Line:   59,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 18,
																						Line:   59,
																					},
																					File:   "monitor.flux",
																					Source: "fn",
																					Start: ast.Position{
																						Column: 16,
																						Line:   59,
																					},
																				},
																			},
																			Name: "fn",
																		},
																		Separator: nil,
																		Value: &ast.FunctionExpression{
																			Arrow: nil,
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 57,
																						Line:   63,
																					},
																					File:   "monitor.flux",
																					Source: "(r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0})",
																					Start: ast.Position{
																						Column: 20,
																						Line:   59,
																					},
																				},
																			},
																			Body: &ast.ParenExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 57,
																							Line:   63,
																						},
																						File:   "monitor.flux",
																						Source: "({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0})",
																						Start: ast.Position{
																							Column: 27,
																							Line:   59,
																						},
																					},
																				},
																				Expression: &ast.ObjectExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 56,
																								Line:   63,
																							},
																							File:   "monitor.flux",
																							Source: "{r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}",
																							Start: ast.Position{
																								Column: 28,
																								Line:   59,
																							},
																						},
																					},
																					Lbrace: nil,
																					Properties: []*ast.Property{&ast.Property{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 55,
																									Line:   63,
																								},
																								File:   "monitor.flux",
																								Source: "level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0",
																								Start: ast.Position{
																									Column: 36,
																									Line:   59,
																								},
																							},
																						},
																						Comma: nil,
																						Key: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 47,
																										Line:   59,
																									},
																									File:   "monitor.flux",
																									Source: "level_value",
																									Start: ast.Position{
																										Column: 36,
																										Line:   59,
																									},
																								},
																							},
																							Name: "level_value",
																						},
																						Separator: nil,
																						Value: &ast.ConditionalExpression{
																							Alternate: &ast.ConditionalExpression{
																								Alternate: &ast.ConditionalExpression{
																									Alternate: &ast.ConditionalExpression{
																										Alternate: &ast.IntegerLiteral{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 55,
																														Line:   63,
																													},
																													File:   "monitor.flux",
																													Source: "0",
																													Start: ast.Position{
																														Column: 54,
																														Line:   63,
																													},
																												},
																											},
																											Value: int64(0),
																										},
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 55,
																													Line:   63,
																												},
																												File:   "monitor.flux",
																												Source: "if r._level == levelOK then 1\n                                                else 0",
																												Start: ast.Position{
																													Column: 54,
																													Line:   62,
																												},
																											},
																										},
																										Consequent: &ast.IntegerLiteral{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 83,
																														Line:   62,
																													},
																													File:   "monitor.flux",
																													Source: "1",
																													Start: ast.Position{
																														Column: 82,
																														Line:   62,
																													},
																												},
																											},
																											Value: int64(1),
																										},
																										Test: &ast.BinaryExpression{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 76,
																														Line:   62,
																													},
																													File:   "monitor.flux",
																													Source: "r._level == levelOK",
																													Start: ast.Position{
																														Column: 57,
																														Line:   62,
																													},
																												},
																											},
																											Left: &ast.MemberExpression{
																												BaseNode: ast.BaseNode{
																													Comments: nil,
																													Errors:   nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 65,
																															Line:   62,
																														},
																														File:   "monitor.flux",
																														Source: "r._level",
																														Start: ast.Position{
																															Column: 57,
																															Line:   62,
																														},
																													},
																												},
																												Lbrack: nil,
																												Object: &ast.Identifier{
																													BaseNode: ast.BaseNode{
																														Comments: nil,
																														Errors:   nil,
																														Loc: &ast.SourceLocation{
																															End: ast.Position{
																																Column: 58,
																																Line:   62,
																															},
																															File:   "monitor.flux",
																															Source: "r",
																															Start: ast.Position{
																																Column: 57,
																																Line:   62,
																															},
																														},
																													},
																													Name: "r",
																												},
																												Property: &ast.Identifier{
																													BaseNode: ast.BaseNode{
																														Comments: nil,
																														Errors:   nil,
																														Loc: &ast.SourceLocation{
																															End: ast.Position{
																																Column: 65,
																																Line:   62,
																															},
																															File:   "monitor.flux",
																															Source: "_level",
																															Start: ast.Position{
																																Column: 59,
																																Line:   62,
																															},
																														},
																													},
																													Name: "_level",
																												},
																												Rbrack: nil,
																											},
																											Operator: 17,
																											Right: &ast.Identifier{
																												BaseNode: ast.BaseNode{
																													Comments: nil,
																													Errors:   nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 76,
																															Line:   62,
																														},
																														File:   "monitor.flux",
																														Source: "levelOK",
																														Start: ast.Position{
																															Column: 69,
																															Line:   62,
																														},
																													},
																												},
																												Name: "levelOK",
																											},
																										},
																										Tk_else: nil,
																										Tk_if:   nil,
																										Tk_then: nil,
																									},
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 55,
																												Line:   63,
																											},
																											File:   "monitor.flux",
																											Source: "if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0",
																											Start: ast.Position{
																												Column: 54,
																												Line:   61,
																											},
																										},
																									},
																									Consequent: &ast.IntegerLiteral{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 85,
																													Line:   61,
																												},
																												File:   "monitor.flux",
																												Source: "2",
																												Start: ast.Position{
																													Column: 84,
																													Line:   61,
																												},
																											},
																										},
																										Value: int64(2),
																									},
																									Test: &ast.BinaryExpression{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 78,
																													Line:   61,
																												},
																												File:   "monitor.flux",
																												Source: "r._level == levelInfo",
																												Start: ast.Position{
																													Column: 57,
																													Line:   61,
																												},
																											},
																										},
																										Left: &ast.MemberExpression{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 65,
																														Line:   61,
																													},
																													File:   "monitor.flux",
																													Source: "r._level",
																													Start: ast.Position{
																														Column: 57,
																														Line:   61,
																													},
																												},
																											},
																											Lbrack: nil,
																											Object: &ast.Identifier{
																												BaseNode: ast.BaseNode{
																													Comments: nil,
																													Errors:   nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 58,
																															Line:   61,
																														},
																														File:   "monitor.flux",
																														Source: "r",
																														Start: ast.Position{
																															Column: 57,
																															Line:   61,
																														},
																													},
																												},
																												Name: "r",
																											},
																											Property: &ast.Identifier{
																												BaseNode: ast.BaseNode{
																													Comments: nil,
																													Errors:   nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 65,
																															Line:   61,
																														},
																														File:   "monitor.flux",
																														Source: "_level",
																														Start: ast.Position{
																															Column: 59,
																															Line:   61,
																														},
																													},
																												},
																												Name: "_level",
																											},
																											Rbrack: nil,
																										},
																										Operator: 17,
																										Right: &ast.Identifier{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 78,
																														Line:   61,
																													},
																													File:   "monitor.flux",
																													Source: "levelInfo",
																													Start: ast.Position{
																														Column: 69,
																														Line:   61,
																													},
																												},
																											},
																											Name: "levelInfo",
																										},
																									},
																									Tk_else: nil,
																									Tk_if:   nil,
																									Tk_then: nil,
																								},
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 55,
																											Line:   63,
																										},
																										File:   "monitor.flux",
																										Source: "if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0",
																										Start: ast.Position{
																											Column: 54,
																											Line:   60,
																										},
																									},
																								},
																								Consequent: &ast.IntegerLiteral{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 85,
																												Line:   60,
																											},
																											File:   "monitor.flux",
																											Source: "3",
																											Start: ast.Position{
																												Column: 84,
																												Line:   60,
																											},
																										},
																									},
																									Value: int64(3),
																								},
																								Test: &ast.BinaryExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 78,
																												Line:   60,
																											},
																											File:   "monitor.flux",
																											Source: "r._level == levelWarn",
																											Start: ast.Position{
																												Column: 57,
																												Line:   60,
																											},
																										},
																									},
																									Left: &ast.MemberExpression{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 65,
																													Line:   60,
																												},
																												File:   "monitor.flux",
																												Source: "r._level",
																												Start: ast.Position{
																													Column: 57,
																													Line:   60,
																												},
																											},
																										},
																										Lbrack: nil,
																										Object: &ast.Identifier{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 58,
																														Line:   60,
																													},
																													File:   "monitor.flux",
																													Source: "r",
																													Start: ast.Position{
																														Column: 57,
																														Line:   60,
																													},
																												},
																											},
																											Name: "r",
																										},
																										Property: &ast.Identifier{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 65,
																														Line:   60,
																													},
																													File:   "monitor.flux",
																													Source: "_level",
																													Start: ast.Position{
																														Column: 59,
																														Line:   60,
																													},
																												},
																											},
																											Name: "_level",
																										},
																										Rbrack: nil,
																									},
																									Operator: 17,
																									Right: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 78,
																													Line:   60,
																												},
																												File:   "monitor.flux",
																												Source: "levelWarn",
																												Start: ast.Position{
																													Column: 69,
																													Line:   60,
																												},
																											},
																										},
																										Name: "levelWarn",
																									},
																								},
																								Tk_else: nil,
																								Tk_if:   nil,
																								Tk_then: nil,
																							},
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 55,
																										Line:   63,
																									},
																									File:   "monitor.flux",
																									Source: "if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0",
																									Start: ast.Position{
																										Column: 49,
																										Line:   59,
																									},
																								},
																							},
																							Consequent: &ast.IntegerLiteral{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 80,
																											Line:   59,
																										},
																										File:   "monitor.flux",
																										Source: "4",
																										Start: ast.Position{
																											Column: 79,
																											Line:   59,
																										},
																									},
																								},
																								Value: int64(4),
																							},
																							Test: &ast.BinaryExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 73,
																											Line:   59,
																										},
																										File:   "monitor.flux",
																										Source: "r._level == levelCrit",
																										Start: ast.Position{
																											Column: 52,
																											Line:   59,
																										},
																									},
																								},
																								Left: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 60,
																												Line:   59,
																											},
																											File:   "monitor.flux",
																											Source: "r._level",
																											Start: ast.Position{
																												Column: 52,
																												Line:   59,
																											},
																										},
																									},
																									Lbrack: nil,
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 53,
																													Line:   59,
																												},
																												File:   "monitor.flux",
																												Source: "r",
																												Start: ast.Position{
																													Column: 52,
																													Line:   59,
																												},
																											},
																										},
																										Name: "r",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 60,
																													Line:   59,
																												},
																												File:   "monitor.flux",
																												Source: "_level",
																												Start: ast.Position{
																													Column: 54,
																													Line:   59,
																												},
																											},
																										},
																										Name: "_level",
																									},
																									Rbrack: nil,
																								},
																								Operator: 17,
																								Right: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 73,
																												Line:   59,
																											},
																											File:   "monitor.flux",
																											Source: "levelCrit",
																											Start: ast.Position{
																												Column: 64,
																												Line:   59,
																											},
																										},
																									},
																									Name: "levelCrit",
																								},
																							},
																							Tk_else: nil,
																							Tk_if:   nil,
																							Tk_then: nil,
																						},
																					}},
																					Rbrace: nil,
																					With: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 30,
																									Line:   59,
																								},
																								File:   "monitor.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 29,
																									Line:   59,
																								},
																							},
																						},
																						Name: "r",
																					},
																				},
																				Lparen: nil,
																				Rparen: nil,
																			},
																			Lparen: nil,
																			Params: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 22,
																							Line:   59,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 21,
																							Line:   59,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 22,
																								Line:   59,
																							},
																							File:   "monitor.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 21,
																								Line:   59,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Separator: nil,
																				Value:     nil,
																			}},
																			Rparan: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   63,
																		},
																		File:   "monitor.flux",
																		Source: "map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))",
																		Start: ast.Position{
																			Column: 12,
																			Line:   59,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 15,
																				Line:   59,
																			},
																			File:   "monitor.flux",
																			Source: "map",
																			Start: ast.Position{
																				Column: 12,
																				Line:   59,
																			},
																		},
																	},
																	Name: "map",
																},
																Lparen: nil,
																Rparen: nil,
															},
														},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 65,
																	Line:   64,
																},
																File:   "monitor.flux",
																Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")",
																Start: ast.Position{
																	Column: 12,
																	Line:   58,
																},
															},
														},
														Call: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 64,
																			Line:   64,
																		},
																		File:   "monitor.flux",
																		Source: "column: \"_level\", as: \"____temp_level____\"",
																		Start: ast.Position{
																			Column: 22,
																			Line:   64,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 38,
																				Line:   64,
																			},
																			File:   "monitor.flux",
																			Source: "column: \"_level\"",
																			Start: ast.Position{
																				Column: 22,
																				Line:   64,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   64,
																				},
																				File:   "monitor.flux",
																				Source: "column",
																				Start: ast.Position{
																					Column: 22,
																					Line:   64,
																				},
																			},
																		},
																		Name: "column",
																	},
																	Separator: nil,
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 38,
																					Line:   64,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 30,
																					Line:   64,
																				},
																			},
																		},
																		Value: "_level",
																	},
																}, &ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 64,
																				Line:   64,
																			},
																			File:   "monitor.flux",
																			Source: "as: \"____temp_level____\"",
																			Start: ast.Position{
																				Column: 40,
																				Line:   64,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 42,
																					Line:   64,
																				},
																				File:   "monitor.flux",
																				Source: "as",
																				Start: ast.Position{
																					Column: 40,
																					Line:   64,
																				},
																			},
																		},
																		Name: "as",
																	},
																	Separator: nil,
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 64,
																					Line:   64,
																				},
																				File:   "monitor.flux",
																				Source: "\"____temp_level____\"",
																				Start: ast.Position{
																					Column: 44,
																					Line:   64,
																				},
																			},
																		},
																		Value: "____temp_level____",
																	},
																}},
																Rbrace: nil,
																With:   nil,
															}},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 65,
																		Line:   64,
																	},
																	File:   "monitor.flux",
																	Source: "duplicate(column: \"_level\", as: \"____temp_level____\")",
																	Start: ast.Position{
																		Column: 12,
																		Line:   64,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   64,
																		},
																		File:   "monitor.flux",
																		Source: "duplicate",
																		Start: ast.Position{
																			Column: 12,
																			Line:   64,
																		},
																	},
																},
																Name: "duplicate",
															},
															Lparen: nil,
															Rparen: nil,
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   65,
															},
															File:   "monitor.flux",
															Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])",
															Start: ast.Position{
																Column: 12,
																Line:   58,
															},
														},
													},
													Call: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   65,
																	},
																	File:   "monitor.flux",
																	Source: "columns: [\"_level\"]",
																	Start: ast.Position{
																		Column: 17,
																		Line:   65,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   65,
																		},
																		File:   "monitor.flux",
																		Source: "columns: [\"_level\"]",
																		Start: ast.Position{
																			Column: 17,
																			Line:   65,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   65,
																			},
																			File:   "monitor.flux",
																			Source: "columns",
																			Start: ast.Position{
																				Column: 17,
																				Line:   65,
																			},
																		},
																	},
																	Name: "columns",
																},
																Separator: nil,
																Value: &ast.ArrayExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 36,
																				Line:   65,
																			},
																			File:   "monitor.flux",
																			Source: "[\"_level\"]",
																			Start: ast.Position{
																				Column: 26,
																				Line:   65,
																			},
																		},
																	},
																	Elements: []ast.Expression{&ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 35,
																					Line:   65,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 27,
																					Line:   65,
																				},
																			},
																		},
																		Value: "_level",
																	}},
																	Lbrack: nil,
																	Rbrack: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   65,
																},
																File:   "monitor.flux",
																Source: "drop(columns: [\"_level\"])",
																Start: ast.Position{
																	Column: 12,
																	Line:   65,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 16,
																		Line:   65,
																	},
																	File:   "monitor.flux",
																	Source: "drop",
																	Start: ast.Position{
																		Column: 12,
																		Line:   65,
																	},
																},
															},
															Name: "drop",
														},
														Lparen: nil,
														Rparen: nil,
													},
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   66,
														},
														File:   "monitor.flux",
														Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})",
														Start: ast.Position{
															Column: 12,
															Line:   58,
														},
													},
												},
												Call: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 60,
																	Line:   66,
																},
																File:   "monitor.flux",
																Source: "columns: {\"____temp_level____\": \"_level\"}",
																Start: ast.Position{
																	Column: 19,
																	Line:   66,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 60,
																		Line:   66,
																	},
																	File:   "monitor.flux",
																	Source: "columns: {\"____temp_level____\": \"_level\"}",
																	Start: ast.Position{
																		Column: 19,
																		Line:   66,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 26,
																			Line:   66,
																		},
																		File:   "monitor.flux",
																		Source: "columns",
																		Start: ast.Position{
																			Column: 19,
																			Line:   66,
																		},
																	},
																},
																Name: "columns",
															},
															Separator: nil,
															Value: &ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 60,
																			Line:   66,
																		},
																		File:   "monitor.flux",
																		Source: "{\"____temp_level____\": \"_level\"}",
																		Start: ast.Position{
																			Column: 28,
																			Line:   66,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 59,
																				Line:   66,
																			},
																			File:   "monitor.flux",
																			Source: "\"____temp_level____\": \"_level\"",
																			Start: ast.Position{
																				Column: 29,
																				Line:   66,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 49,
																					Line:   66,
																				},
																				File:   "monitor.flux",
																				Source: "\"____temp_level____\"",
																				Start: ast.Position{
																					Column: 29,
																					Line:   66,
																				},
																			},
																		},
																		Value: "____temp_level____",
																	},
																	Separator: nil,
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 59,
																					Line:   66,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 51,
																					Line:   66,
																				},
																			},
																		},
																		Value: "_level",
																	},
																}},
																Rbrace: nil,
																With:   nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 61,
																Line:   66,
															},
															File:   "monitor.flux",
															Source: "rename(columns: {\"____temp_level____\": \"_level\"})",
															Start: ast.Position{
																Column: 12,
																Line:   66,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   66,
																},
																File:   "monitor.flux",
																Source: "rename",
																Start: ast.Position{
																	Column: 12,
																	Line:   66,
																},
															},
														},
														Name: "rename",
													},
													Lparen: nil,
													Rparen: nil,
												},
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   67,
													},
													File:   "monitor.flux",
													Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)",
													Start: ast.Position{
														Column: 12,
														Line:   58,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 60,
																Line:   67,
															},
															File:   "monitor.flux",
															Source: "columns: [\"_source_timestamp\"], desc: false",
															Start: ast.Position{
																Column: 17,
																Line:   67,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   67,
																},
																File:   "monitor.flux",
																Source: "columns: [\"_source_timestamp\"]",
																Start: ast.Position{
																	Column: 17,
																	Line:   67,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   67,
																	},
																	File:   "monitor.flux",
																	Source: "columns",
																	Start: ast.Position{
																		Column: 17,
																		Line:   67,
																	},
																},
															},
															Name: "columns",
														},
														Separator: nil,
														Value: &ast.ArrayExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   67,
																	},
																	File:   "monitor.flux",
																	Source: "[\"_source_timestamp\"]",
																	Start: ast.Position{
																		Column: 26,
																		Line:   67,
																	},
																},
															},
															Elements: []ast.Expression{&ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   67,
																		},
																		File:   "monitor.flux",
																		Source: "\"_source_timestamp\"",
																		Start: ast.Position{
																			Column: 27,
																			Line:   67,
																		},
																	},
																},
																Value: "_source_timestamp",
															}},
															Lbrack: nil,
															Rbrack: nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 60,
																	Line:   67,
																},
																File:   "monitor.flux",
																Source: "desc: false",
																Start: ast.Position{
																	Column: 49,
																	Line:   67,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 53,
																		Line:   67,
																	},
																	File:   "monitor.flux",
																	Source: "desc",
																	Start: ast.Position{
																		Column: 49,
																		Line:   67,
																	},
																},
															},
															Name: "desc",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 60,
																		Line:   67,
																	},
																	File:   "monitor.flux",
																	Source: "false",
																	Start: ast.Position{
																		Column: 55,
																		Line:   67,
																	},
																},
															},
															Name: "false",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   67,
														},
														File:   "monitor.flux",
														Source: "sort(columns: [\"_source_timestamp\"], desc: false)",
														Start: ast.Position{
															Column: 12,
															Line:   67,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 16,
																Line:   67,
															},
															File:   "monitor.flux",
															Source: "sort",
															Start: ast.Position{
																Column: 12,
																Line:   67,
															},
														},
													},
													Name: "sort",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   68,
												},
												File:   "monitor.flux",
												Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])",
												Start: ast.Position{
													Column: 12,
													Line:   58,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   68,
														},
														File:   "monitor.flux",
														Source: "columns: [\"level_value\"]",
														Start: ast.Position{
															Column: 23,
															Line:   68,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 47,
																Line:   68,
															},
															File:   "monitor.flux",
															Source: "columns: [\"level_value\"]",
															Start: ast.Position{
																Column: 23,
																Line:   68,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   68,
																},
																File:   "monitor.flux",
																Source: "columns",
																Start: ast.Position{
																	Column: 23,
																	Line:   68,
																},
															},
														},
														Name: "columns",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   68,
																},
																File:   "monitor.flux",
																Source: "[\"level_value\"]",
																Start: ast.Position{
																	Column: 32,
																	Line:   68,
																},
															},
														},
														Elements: []ast.Expression{&ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   68,
																	},
																	File:   "monitor.flux",
																	Source: "\"level_value\"",
																	Start: ast.Position{
																		Column: 33,
																		Line:   68,
																	},
																},
															},
															Value: "level_value",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   68,
													},
													File:   "monitor.flux",
													Source: "difference(columns: [\"level_value\"])",
													Start: ast.Position{
														Column: 12,
														Line:   68,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   68,
														},
														File:   "monitor.flux",
														Source: "difference",
														Start: ast.Position{
															Column: 12,
															Line:   68,
														},
													},
												},
												Name: "difference",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   69,
											},
											File:   "monitor.flux",
											Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)",
											Start: ast.Position{
												Column: 12,
												Line:   58,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   69,
													},
													File:   "monitor.flux",
													Source: "fn: (r) => r.level_value != 0",
													Start: ast.Position{
														Column: 19,
														Line:   69,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   69,
														},
														File:   "monitor.flux",
														Source: "fn: (r) => r.level_value != 0",
														Start: ast.Position{
															Column: 19,
															Line:   69,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   69,
															},
															File:   "monitor.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 19,
																Line:   69,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   69,
															},
															File:   "monitor.flux",
															Source: "(r) => r.level_value != 0",
															Start: ast.Position{
																Column: 23,
																Line:   69,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   69,
																},
																File:   "monitor.flux",
																Source: "r.level_value != 0",
																Start: ast.Position{
																	Column: 30,
																	Line:   69,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 43,
																		Line:   69,
																	},
																	File:   "monitor.flux",
																	Source: "r.level_value",
																	Start: ast.Position{
																		Column: 30,
																		Line:   69,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   69,
																		},
																		File:   "monitor.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 30,
																			Line:   69,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 43,
																			Line:   69,
																		},
																		File:   "monitor.flux",
																		Source: "level_value",
																		Start: ast.Position{
																			Column: 32,
																			Line:   69,
																		},
																	},
																},
																Name: "level_value",
															},
															Rbrack: nil,
														},
														Operator: 18,
														Right: &ast.IntegerLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   69,
																	},
																	File:   "monitor.flux",
																	Source: "0",
																	Start: ast.Position{
																		Column: 47,
																		Line:   69,
																	},
																},
															},
															Value: int64(0),
														},
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   69,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 24,
																	Line:   69,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   69,
																	},
																	File:   "monitor.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 24,
																		Line:   69,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   69,
												},
												File:   "monitor.flux",
												Source: "filter(fn: (r) => r.level_value != 0)",
												Start: ast.Position{
													Column: 12,
													Line:   69,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   69,
													},
													File:   "monitor.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 12,
														Line:   69,
													},
												},
											},
											Name: "filter",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   70,
										},
										File:   "monitor.flux",
										Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])",
										Start: ast.Position{
											Column: 12,
											Line:   58,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   70,
												},
												File:   "monitor.flux",
												Source: "columns: [\"level_value\"]",
												Start: ast.Position{
													Column: 17,
													Line:   70,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   70,
													},
													File:   "monitor.flux",
													Source: "columns: [\"level_value\"]",
													Start: ast.Position{
														Column: 17,
														Line:   70,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   70,
														},
														File:   "monitor.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 17,
															Line:   70,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   70,
														},
														File:   "monitor.flux",
														Source: "[\"level_value\"]",
														Start: ast.Position{
															Column: 26,
															Line:   70,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   70,
															},
															File:   "monitor.flux",
															Source: "\"level_value\"",
															Start: ast.Position{
																Column: 27,
																Line:   70,
															},
														},
													},
													Value: "level_value",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   70,
											},
											File:   "monitor.flux",
											Source: "drop(columns: [\"level_value\"])",
											Start: ast.Position{
												Column: 12,
												Line:   70,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   70,
												},
												File:   "monitor.flux",
												Source: "drop",
												Start: ast.Position{
													Column: 12,
													Line:   70,
												},
											},
										},
										Name: "drop",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   71,
									},
									File:   "monitor.flux",
									Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])",
									Start: ast.Position{
										Column: 12,
										Line:   58,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   71,
											},
											File:   "monitor.flux",
											Source: "mode: \"extend\", columns: [\"_level\"]",
											Start: ast.Position{
												Column: 31,
												Line:   71,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   71,
												},
												File:   "monitor.flux",
												Source: "mode: \"extend\"",
												Start: ast.Position{
													Column: 31,
													Line:   71,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   71,
													},
													File:   "monitor.flux",
													Source: "mode",
													Start: ast.Position{
														Column: 31,
														Line:   71,
													},
												},
											},
											Name: "mode",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   71,
													},
													File:   "monitor.flux",
													Source: "\"extend\"",
													Start: ast.Position{
														Column: 37,
														Line:   71,
													},
												},
											},
											Value: "extend",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   71,
												},
												File:   "monitor.flux",
												Source: "columns: [\"_level\"]",
												Start: ast.Position{
													Column: 47,
													Line:   71,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   71,
													},
													File:   "monitor.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 47,
														Line:   71,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   71,
													},
													File:   "monitor.flux",
													Source: "[\"_level\"]",
													Start: ast.Position{
														Column: 56,
														Line:   71,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   71,
														},
														File:   "monitor.flux",
														Source: "\"_level\"",
														Start: ast.Position{
															Column: 57,
															Line:   71,
														},
													},
												},
												Value: "_level",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   71,
										},
										File:   "monitor.flux",
										Source: "experimental.group(mode: \"extend\", columns: [\"_level\"])",
										Start: ast.Position{
											Column: 12,
											Line:   71,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   71,
											},
											File:   "monitor.flux",
											Source: "experimental.group",
											Start: ast.Position{
												Column: 12,
												Line:   71,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   71,
												},
												File:   "monitor.flux",
												Source: "experimental",
												Start: ast.Position{
													Column: 12,
													Line:   71,
												},
											},
										},
										Name: "experimental",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   71,
												},
												File:   "monitor.flux",
												Source: "group",
												Start: ast.Position{
													Column: 25,
													Line:   71,
												},
											},
										},
										Name: "group",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   71,
								},
								File:   "monitor.flux",
								Source: "return tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])",
								Start: ast.Position{
									Column: 5,
									Line:   58,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   57,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 21,
								Line:   57,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   57,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 21,
									Line:   57,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   57,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   57,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   81,
					},
					File:   "monitor.flux",
					Source: "stateChanges = (fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    return if fromLevel == \"any\" and toLevel == \"any\" then tables |> stateChangesOnly()\n           else tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   78,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// StateChanges takes a stream of tables, fromLevel, and toLevel and returns\n"}, ast.Comment{Text: "// a stream of tables where status has gone from fromLevel to toLevel.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// StateChanges only operates on data with data where r._level exists.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   78,
						},
						File:   "monitor.flux",
						Source: "stateChanges",
						Start: ast.Position{
							Column: 1,
							Line:   78,
						},
					},
				},
				Name: "stateChanges",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   81,
						},
						File:   "monitor.flux",
						Source: "(fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    return if fromLevel == \"any\" and toLevel == \"any\" then tables |> stateChangesOnly()\n           else tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)\n}",
						Start: ast.Position{
							Column: 16,
							Line:   78,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   81,
							},
							File:   "monitor.flux",
							Source: "{\n    return if fromLevel == \"any\" and toLevel == \"any\" then tables |> stateChangesOnly()\n           else tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)\n}",
							Start: ast.Position{
								Column: 63,
								Line:   78,
							},
						},
					},
					Body: []ast.Statement{&ast.ReturnStatement{
						Argument: &ast.ConditionalExpression{
							Alternate: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   80,
											},
											File:   "monitor.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 17,
												Line:   80,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   80,
										},
										File:   "monitor.flux",
										Source: "tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)",
										Start: ast.Position{
											Column: 17,
											Line:   80,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   80,
												},
												File:   "monitor.flux",
												Source: "fromLevel: fromLevel, toLevel: toLevel",
												Start: ast.Position{
													Column: 41,
													Line:   80,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   80,
													},
													File:   "monitor.flux",
													Source: "fromLevel: fromLevel",
													Start: ast.Position{
														Column: 41,
														Line:   80,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   80,
														},
														File:   "monitor.flux",
														Source: "fromLevel",
														Start: ast.Position{
															Column: 41,
															Line:   80,
														},
													},
												},
												Name: "fromLevel",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   80,
														},
														File:   "monitor.flux",
														Source: "fromLevel",
														Start: ast.Position{
															Column: 52,
															Line:   80,
														},
													},
												},
												Name: "fromLevel",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   80,
													},
													File:   "monitor.flux",
													Source: "toLevel: toLevel",
													Start: ast.Position{
														Column: 63,
														Line:   80,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   80,
														},
														File:   "monitor.flux",
														Source: "toLevel",
														Start: ast.Position{
															Column: 63,
															Line:   80,
														},
													},
												},
												Name: "toLevel",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   80,
														},
														File:   "monitor.flux",
														Source: "toLevel",
														Start: ast.Position{
															Column: 72,
															Line:   80,
														},
													},
												},
												Name: "toLevel",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   80,
											},
											File:   "monitor.flux",
											Source: "_stateChanges(fromLevel: fromLevel, toLevel: toLevel)",
											Start: ast.Position{
												Column: 27,
												Line:   80,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   80,
												},
												File:   "monitor.flux",
												Source: "_stateChanges",
												Start: ast.Position{
													Column: 27,
													Line:   80,
												},
											},
										},
										Name: "_stateChanges",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 80,
										Line:   80,
									},
									File:   "monitor.flux",
									Source: "if fromLevel == \"any\" and toLevel == \"any\" then tables |> stateChangesOnly()\n           else tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)",
									Start: ast.Position{
										Column: 12,
										Line:   79,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   79,
											},
											File:   "monitor.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 60,
												Line:   79,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   79,
										},
										File:   "monitor.flux",
										Source: "tables |> stateChangesOnly()",
										Start: ast.Position{
											Column: 60,
											Line:   79,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   79,
											},
											File:   "monitor.flux",
											Source: "stateChangesOnly()",
											Start: ast.Position{
												Column: 70,
												Line:   79,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 86,
													Line:   79,
												},
												File:   "monitor.flux",
												Source: "stateChangesOnly",
												Start: ast.Position{
													Column: 70,
													Line:   79,
												},
											},
										},
										Name: "stateChangesOnly",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Test: &ast.LogicalExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   79,
										},
										File:   "monitor.flux",
										Source: "fromLevel == \"any\" and toLevel == \"any\"",
										Start: ast.Position{
											Column: 15,
											Line:   79,
										},
									},
								},
								Left: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   79,
											},
											File:   "monitor.flux",
											Source: "fromLevel == \"any\"",
											Start: ast.Position{
												Column: 15,
												Line:   79,
											},
										},
									},
									Left: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   79,
												},
												File:   "monitor.flux",
												Source: "fromLevel",
												Start: ast.Position{
													Column: 15,
													Line:   79,
												},
											},
										},
										Name: "fromLevel",
									},
									Operator: 17,
									Right: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   79,
												},
												File:   "monitor.flux",
												Source: "\"any\"",
												Start: ast.Position{
													Column: 28,
													Line:   79,
												},
											},
										},
										Value: "any",
									},
								},
								Operator: 1,
								Right: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   79,
											},
											File:   "monitor.flux",
											Source: "toLevel == \"any\"",
											Start: ast.Position{
												Column: 38,
												Line:   79,
											},
										},
									},
									Left: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   79,
												},
												File:   "monitor.flux",
												Source: "toLevel",
												Start: ast.Position{
													Column: 38,
													Line:   79,
												},
											},
										},
										Name: "toLevel",
									},
									Operator: 17,
									Right: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   79,
												},
												File:   "monitor.flux",
												Source: "\"any\"",
												Start: ast.Position{
													Column: 49,
													Line:   79,
												},
											},
										},
										Value: "any",
									},
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 80,
									Line:   80,
								},
								File:   "monitor.flux",
								Source: "return if fromLevel == \"any\" and toLevel == \"any\" then tables |> stateChangesOnly()\n           else tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)",
								Start: ast.Position{
									Column: 5,
									Line:   79,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   78,
							},
							File:   "monitor.flux",
							Source: "fromLevel=\"any\"",
							Start: ast.Position{
								Column: 17,
								Line:   78,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   78,
								},
								File:   "monitor.flux",
								Source: "fromLevel",
								Start: ast.Position{
									Column: 17,
									Line:   78,
								},
							},
						},
						Name: "fromLevel",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   78,
								},
								File:   "monitor.flux",
								Source: "\"any\"",
								Start: ast.Position{
									Column: 27,
									Line:   78,
								},
							},
						},
						Value: "any",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 47,
								Line:   78,
							},
							File:   "monitor.flux",
							Source: "toLevel=\"any\"",
							Start: ast.Position{
								Column: 34,
								Line:   78,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   78,
								},
								File:   "monitor.flux",
								Source: "toLevel",
								Start: ast.Position{
									Column: 34,
									Line:   78,
								},
							},
						},
						Name: "toLevel",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   78,
								},
								File:   "monitor.flux",
								Source: "\"any\"",
								Start: ast.Position{
									Column: 42,
									Line:   78,
								},
							},
						},
						Value: "any",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   78,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 49,
								Line:   78,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   78,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 49,
									Line:   78,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   78,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 56,
								Line:   78,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   95,
					},
					File:   "monitor.flux",
					Source: "notify = (tables=<-, endpoint, data) =>\n    tables\n        |> experimental.set(o: data)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n        |> map(fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }))\n        |> endpoint()\n        |> experimental.group(mode: \"extend\", columns: [\"_sent\"])\n        |> log()",
					Start: ast.Position{
						Column: 1,
						Line:   84,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Notify will call the endpoint and log the results.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   84,
						},
						File:   "monitor.flux",
						Source: "notify",
						Start: ast.Position{
							Column: 1,
							Line:   84,
						},
					},
				},
				Name: "notify",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   95,
						},
						File:   "monitor.flux",
						Source: "(tables=<-, endpoint, data) =>\n    tables\n        |> experimental.set(o: data)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n        |> map(fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }))\n        |> endpoint()\n        |> experimental.group(mode: \"extend\", columns: [\"_sent\"])\n        |> log()",
						Start: ast.Position{
							Column: 10,
							Line:   84,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   85,
													},
													File:   "monitor.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 5,
														Line:   85,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   86,
												},
												File:   "monitor.flux",
												Source: "tables\n        |> experimental.set(o: data)",
												Start: ast.Position{
													Column: 5,
													Line:   85,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   86,
														},
														File:   "monitor.flux",
														Source: "o: data",
														Start: ast.Position{
															Column: 29,
															Line:   86,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   86,
															},
															File:   "monitor.flux",
															Source: "o: data",
															Start: ast.Position{
																Column: 29,
																Line:   86,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   86,
																},
																File:   "monitor.flux",
																Source: "o",
																Start: ast.Position{
																	Column: 29,
																	Line:   86,
																},
															},
														},
														Name: "o",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   86,
																},
																File:   "monitor.flux",
																Source: "data",
																Start: ast.Position{
																	Column: 32,
																	Line:   86,
																},
															},
														},
														Name: "data",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   86,
													},
													File:   "monitor.flux",
													Source: "experimental.set(o: data)",
													Start: ast.Position{
														Column: 12,
														Line:   86,
													},
												},
											},
											Callee: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   86,
														},
														File:   "monitor.flux",
														Source: "experimental.set",
														Start: ast.Position{
															Column: 12,
															Line:   86,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   86,
															},
															File:   "monitor.flux",
															Source: "experimental",
															Start: ast.Position{
																Column: 12,
																Line:   86,
															},
														},
													},
													Name: "experimental",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   86,
															},
															File:   "monitor.flux",
															Source: "set",
															Start: ast.Position{
																Column: 25,
																Line:   86,
															},
														},
													},
													Name: "set",
												},
												Rbrack: nil,
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 89,
												Line:   87,
											},
											File:   "monitor.flux",
											Source: "tables\n        |> experimental.set(o: data)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))",
											Start: ast.Position{
												Column: 5,
												Line:   85,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 88,
														Line:   87,
													},
													File:   "monitor.flux",
													Source: "mode: \"extend\", columns: experimental.objectKeys(o: data)",
													Start: ast.Position{
														Column: 31,
														Line:   87,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   87,
														},
														File:   "monitor.flux",
														Source: "mode: \"extend\"",
														Start: ast.Position{
															Column: 31,
															Line:   87,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   87,
															},
															File:   "monitor.flux",
															Source: "mode",
															Start: ast.Position{
																Column: 31,
																Line:   87,
															},
														},
													},
													Name: "mode",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   87,
															},
															File:   "monitor.flux",
															Source: "\"extend\"",
															Start: ast.Position{
																Column: 37,
																Line:   87,
															},
														},
													},
													Value: "extend",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 88,
															Line:   87,
														},
														File:   "monitor.flux",
														Source: "columns: experimental.objectKeys(o: data)",
														Start: ast.Position{
															Column: 47,
															Line:   87,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 54,
																Line:   87,
															},
															File:   "monitor.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 47,
																Line:   87,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 87,
																	Line:   87,
																},
																File:   "monitor.flux",
																Source: "o: data",
																Start: ast.Position{
																	Column: 80,
																	Line:   87,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 87,
																		Line:   87,
																	},
																	File:   "monitor.flux",
																	Source: "o: data",
																	Start: ast.Position{
																		Column: 80,
																		Line:   87,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 81,
																			Line:   87,
																		},
																		File:   "monitor.flux",
																		Source: "o",
																		Start: ast.Position{
																			Column: 80,
																			Line:   87,
																		},
																	},
																},
																Name: "o",
															},
															Separator: nil,
															Value: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 87,
																			Line:   87,
																		},
																		File:   "monitor.flux",
																		Source: "data",
																		Start: ast.Position{
																			Column: 83,
																			Line:   87,
																		},
																	},
																},
																Name: "data",
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 88,
																Line:   87,
															},
															File:   "monitor.flux",
															Source: "experimental.objectKeys(o: data)",
															Start: ast.Position{
																Column: 56,
																Line:   87,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 79,
																	Line:   87,
																},
																File:   "monitor.flux",
																Source: "experimental.objectKeys",
																Start: ast.Position{
																	Column: 56,
																	Line:   87,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   87,
																	},
																	File:   "monitor.flux",
																	Source: "experimental",
																	Start: ast.Position{
																		Column: 56,
																		Line:   87,
																	},
																},
															},
															Name: "experimental",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 79,
																		Line:   87,
																	},
																	File:   "monitor.flux",
																	Source: "objectKeys",
																	Start: ast.Position{
																		Column: 69,
																		Line:   87,
																	},
																},
															},
															Name: "objectKeys",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 89,
													Line:   87,
												},
												File:   "monitor.flux",
												Source: "experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))",
												Start: ast.Position{
													Column: 12,
													Line:   87,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   87,
													},
													File:   "monitor.flux",
													Source: "experimental.group",
													Start: ast.Position{
														Column: 12,
														Line:   87,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   87,
														},
														File:   "monitor.flux",
														Source: "experimental",
														Start: ast.Position{
															Column: 12,
															Line:   87,
														},
													},
												},
												Name: "experimental",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   87,
														},
														File:   "monitor.flux",
														Source: "group",
														Start: ast.Position{
															Column: 25,
															Line:   87,
														},
													},
												},
												Name: "group",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   92,
										},
										File:   "monitor.flux",
										Source: "tables\n        |> experimental.set(o: data)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n        |> map(fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }))",
										Start: ast.Position{
											Column: 5,
											Line:   85,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   92,
												},
												File:   "monitor.flux",
												Source: "fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        })",
												Start: ast.Position{
													Column: 16,
													Line:   88,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   92,
													},
													File:   "monitor.flux",
													Source: "fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        })",
													Start: ast.Position{
														Column: 16,
														Line:   88,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   88,
														},
														File:   "monitor.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 16,
															Line:   88,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   92,
														},
														File:   "monitor.flux",
														Source: "(r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        })",
														Start: ast.Position{
															Column: 20,
															Line:   88,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 11,
																Line:   92,
															},
															File:   "monitor.flux",
															Source: "({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        })",
															Start: ast.Position{
																Column: 27,
																Line:   88,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 10,
																	Line:   92,
																},
																File:   "monitor.flux",
																Source: "{r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }",
																Start: ast.Position{
																	Column: 28,
																	Line:   88,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 42,
																		Line:   89,
																	},
																	File:   "monitor.flux",
																	Source: "_measurement: \"notifications\"",
																	Start: ast.Position{
																		Column: 13,
																		Line:   89,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   89,
																		},
																		File:   "monitor.flux",
																		Source: "_measurement",
																		Start: ast.Position{
																			Column: 13,
																			Line:   89,
																		},
																	},
																},
																Name: "_measurement",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   89,
																		},
																		File:   "monitor.flux",
																		Source: "\"notifications\"",
																		Start: ast.Position{
																			Column: 27,
																			Line:   89,
																		},
																	},
																},
																Value: "notifications",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   90,
																	},
																	File:   "monitor.flux",
																	Source: "_status_timestamp: int(v: r._time)",
																	Start: ast.Position{
																		Column: 13,
																		Line:   90,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 30,
																			Line:   90,
																		},
																		File:   "monitor.flux",
																		Source: "_status_timestamp",
																		Start: ast.Position{
																			Column: 13,
																			Line:   90,
																		},
																	},
																},
																Name: "_status_timestamp",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 46,
																				Line:   90,
																			},
																			File:   "monitor.flux",
																			Source: "v: r._time",
																			Start: ast.Position{
																				Column: 36,
																				Line:   90,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 46,
																					Line:   90,
																				},
																				File:   "monitor.flux",
																				Source: "v: r._time",
																				Start: ast.Position{
																					Column: 36,
																					Line:   90,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 37,
																						Line:   90,
																					},
																					File:   "monitor.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 36,
																						Line:   90,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 46,
																						Line:   90,
																					},
																					File:   "monitor.flux",
																					Source: "r._time",
																					Start: ast.Position{
																						Column: 39,
																						Line:   90,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 40,
																							Line:   90,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 39,
																							Line:   90,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 46,
																							Line:   90,
																						},
																						File:   "monitor.flux",
																						Source: "_time",
																						Start: ast.Position{
																							Column: 41,
																							Line:   90,
																						},
																					},
																				},
																				Name: "_time",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 47,
																			Line:   90,
																		},
																		File:   "monitor.flux",
																		Source: "int(v: r._time)",
																		Start: ast.Position{
																			Column: 32,
																			Line:   90,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 35,
																				Line:   90,
																			},
																			File:   "monitor.flux",
																			Source: "int",
																			Start: ast.Position{
																				Column: 32,
																				Line:   90,
																			},
																		},
																	},
																	Name: "int",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   91,
																	},
																	File:   "monitor.flux",
																	Source: "_time: now()",
																	Start: ast.Position{
																		Column: 13,
																		Line:   91,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   91,
																		},
																		File:   "monitor.flux",
																		Source: "_time",
																		Start: ast.Position{
																			Column: 13,
																			Line:   91,
																		},
																	},
																},
																Name: "_time",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: nil,
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   91,
																		},
																		File:   "monitor.flux",
																		Source: "now()",
																		Start: ast.Position{
																			Column: 20,
																			Line:   91,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 23,
																				Line:   91,
																			},
																			File:   "monitor.flux",
																			Source: "now",
																			Start: ast.Position{
																				Column: 20,
																				Line:   91,
																			},
																		},
																	},
																	Name: "now",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   88,
																	},
																	File:   "monitor.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 29,
																		Line:   88,
																	},
																},
															},
															Name: "r",
														},
													},
													Lparen: nil,
													Rparen: nil,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   88,
															},
															File:   "monitor.flux",
															Source: "r",
															Start: ast.Position{
																Column: 21,
																Line:   88,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   88,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 21,
																	Line:   88,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   92,
											},
											File:   "monitor.flux",
											Source: "map(fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }))",
											Start: ast.Position{
												Column: 12,
												Line:   88,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   88,
												},
												File:   "monitor.flux",
												Source: "map",
												Start: ast.Position{
													Column: 12,
													Line:   88,
												},
											},
										},
										Name: "map",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   93,
									},
									File:   "monitor.flux",
									Source: "tables\n        |> experimental.set(o: data)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n        |> map(fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }))\n        |> endpoint()",
									Start: ast.Position{
										Column: 5,
										Line:   85,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   93,
										},
										File:   "monitor.flux",
										Source: "endpoint()",
										Start: ast.Position{
											Column: 12,
											Line:   93,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   93,
											},
											File:   "monitor.flux",
											Source: "endpoint",
											Start: ast.Position{
												Column: 12,
												Line:   93,
											},
										},
									},
									Name: "endpoint",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   94,
								},
								File:   "monitor.flux",
								Source: "tables\n        |> experimental.set(o: data)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n        |> map(fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }))\n        |> endpoint()\n        |> experimental.group(mode: \"extend\", columns: [\"_sent\"])",
								Start: ast.Position{
									Column: 5,
									Line:   85,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   94,
										},
										File:   "monitor.flux",
										Source: "mode: \"extend\", columns: [\"_sent\"]",
										Start: ast.Position{
											Column: 31,
											Line:   94,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   94,
											},
											File:   "monitor.flux",
											Source: "mode: \"extend\"",
											Start: ast.Position{
												Column: 31,
												Line:   94,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   94,
												},
												File:   "monitor.flux",
												Source: "mode",
												Start: ast.Position{
													Column: 31,
													Line:   94,
												},
											},
										},
										Name: "mode",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   94,
												},
												File:   "monitor.flux",
												Source: "\"extend\"",
												Start: ast.Position{
													Column: 37,
													Line:   94,
												},
											},
										},
										Value: "extend",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   94,
											},
											File:   "monitor.flux",
											Source: "columns: [\"_sent\"]",
											Start: ast.Position{
												Column: 47,
												Line:   94,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   94,
												},
												File:   "monitor.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 47,
													Line:   94,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   94,
												},
												File:   "monitor.flux",
												Source: "[\"_sent\"]",
												Start: ast.Position{
													Column: 56,
													Line:   94,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   94,
													},
													File:   "monitor.flux",
													Source: "\"_sent\"",
													Start: ast.Position{
														Column: 57,
														Line:   94,
													},
												},
											},
											Value: "_sent",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   94,
									},
									File:   "monitor.flux",
									Source: "experimental.group(mode: \"extend\", columns: [\"_sent\"])",
									Start: ast.Position{
										Column: 12,
										Line:   94,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   94,
										},
										File:   "monitor.flux",
										Source: "experimental.group",
										Start: ast.Position{
											Column: 12,
											Line:   94,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   94,
											},
											File:   "monitor.flux",
											Source: "experimental",
											Start: ast.Position{
												Column: 12,
												Line:   94,
											},
										},
									},
									Name: "experimental",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   94,
											},
											File:   "monitor.flux",
											Source: "group",
											Start: ast.Position{
												Column: 25,
												Line:   94,
											},
										},
									},
									Name: "group",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   95,
							},
							File:   "monitor.flux",
							Source: "tables\n        |> experimental.set(o: data)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n        |> map(fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }))\n        |> endpoint()\n        |> experimental.group(mode: \"extend\", columns: [\"_sent\"])\n        |> log()",
							Start: ast.Position{
								Column: 5,
								Line:   85,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   95,
								},
								File:   "monitor.flux",
								Source: "log()",
								Start: ast.Position{
									Column: 12,
									Line:   95,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   95,
									},
									File:   "monitor.flux",
									Source: "log",
									Start: ast.Position{
										Column: 12,
										Line:   95,
									},
								},
							},
							Name: "log",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   84,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 11,
								Line:   84,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   84,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 11,
									Line:   84,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   84,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 18,
								Line:   84,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   84,
							},
							File:   "monitor.flux",
							Source: "endpoint",
							Start: ast.Position{
								Column: 22,
								Line:   84,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   84,
								},
								File:   "monitor.flux",
								Source: "endpoint",
								Start: ast.Position{
									Column: 22,
									Line:   84,
								},
							},
						},
						Name: "endpoint",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   84,
							},
							File:   "monitor.flux",
							Source: "data",
							Start: ast.Position{
								Column: 32,
								Line:   84,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   84,
								},
								File:   "monitor.flux",
								Source: "data",
								Start: ast.Position{
									Column: 32,
									Line:   84,
								},
							},
						},
						Name: "data",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 29,
						Line:   103,
					},
					File:   "monitor.flux",
					Source: "logs = (start, stop=now(), fn) =>\n    influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"notifications\")\n        |> filter(fn: fn)\n        |> v1.fieldsAsCols()",
					Start: ast.Position{
						Column: 1,
						Line:   98,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Logs retrieves notification events that have been logged.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   98,
						},
						File:   "monitor.flux",
						Source: "logs",
						Start: ast.Position{
							Column: 1,
							Line:   98,
						},
					},
				},
				Name: "logs",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 29,
							Line:   103,
						},
						File:   "monitor.flux",
						Source: "(start, stop=now(), fn) =>\n    influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"notifications\")\n        |> filter(fn: fn)\n        |> v1.fieldsAsCols()",
						Start: ast.Position{
							Column: 8,
							Line:   98,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   99,
												},
												File:   "monitor.flux",
												Source: "bucket: bucket",
												Start: ast.Position{
													Column: 19,
													Line:   99,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   99,
													},
													File:   "monitor.flux",
													Source: "bucket: bucket",
													Start: ast.Position{
														Column: 19,
														Line:   99,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   99,
														},
														File:   "monitor.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 19,
															Line:   99,
														},
													},
												},
												Name: "bucket",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   99,
														},
														File:   "monitor.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 27,
															Line:   99,
														},
													},
												},
												Name: "bucket",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   99,
											},
											File:   "monitor.flux",
											Source: "influxdb.from(bucket: bucket)",
											Start: ast.Position{
												Column: 5,
												Line:   99,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   99,
												},
												File:   "monitor.flux",
												Source: "influxdb.from",
												Start: ast.Position{
													Column: 5,
													Line:   99,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   99,
													},
													File:   "monitor.flux",
													Source: "influxdb",
													Start: ast.Position{
														Column: 5,
														Line:   99,
													},
												},
											},
											Name: "influxdb",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   99,
													},
													File:   "monitor.flux",
													Source: "from",
													Start: ast.Position{
														Column: 14,
														Line:   99,
													},
												},
											},
											Name: "from",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   100,
										},
										File:   "monitor.flux",
										Source: "influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)",
										Start: ast.Position{
											Column: 5,
											Line:   99,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   100,
												},
												File:   "monitor.flux",
												Source: "start: start, stop: stop",
												Start: ast.Position{
													Column: 18,
													Line:   100,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   100,
													},
													File:   "monitor.flux",
													Source: "start: start",
													Start: ast.Position{
														Column: 18,
														Line:   100,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 23,
															Line:   100,
														},
														File:   "monitor.flux",
														Source: "start",
														Start: ast.Position{
															Column: 18,
															Line:   100,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   100,
														},
														File:   "monitor.flux",
														Source: "start",
														Start: ast.Position{
															Column: 25,
															Line:   100,
														},
													},
												},
												Name: "start",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   100,
													},
													File:   "monitor.flux",
													Source: "stop: stop",
													Start: ast.Position{
														Column: 32,
														Line:   100,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   100,
														},
														File:   "monitor.flux",
														Source: "stop",
														Start: ast.Position{
															Column: 32,
															Line:   100,
														},
													},
												},
												Name: "stop",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   100,
														},
														File:   "monitor.flux",
														Source: "stop",
														Start: ast.Position{
															Column: 38,
															Line:   100,
														},
													},
												},
												Name: "stop",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   100,
											},
											File:   "monitor.flux",
											Source: "range(start: start, stop: stop)",
											Start: ast.Position{
												Column: 12,
												Line:   100,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   100,
												},
												File:   "monitor.flux",
												Source: "range",
												Start: ast.Position{
													Column: 12,
													Line:   100,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   101,
									},
									File:   "monitor.flux",
									Source: "influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"notifications\")",
									Start: ast.Position{
										Column: 5,
										Line:   99,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 63,
												Line:   101,
											},
											File:   "monitor.flux",
											Source: "fn: (r) => r._measurement == \"notifications\"",
											Start: ast.Position{
												Column: 19,
												Line:   101,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   101,
												},
												File:   "monitor.flux",
												Source: "fn: (r) => r._measurement == \"notifications\"",
												Start: ast.Position{
													Column: 19,
													Line:   101,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   101,
													},
													File:   "monitor.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 19,
														Line:   101,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 63,
														Line:   101,
													},
													File:   "monitor.flux",
													Source: "(r) => r._measurement == \"notifications\"",
													Start: ast.Position{
														Column: 23,
														Line:   101,
													},
												},
											},
											Body: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   101,
														},
														File:   "monitor.flux",
														Source: "r._measurement == \"notifications\"",
														Start: ast.Position{
															Column: 30,
															Line:   101,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   101,
															},
															File:   "monitor.flux",
															Source: "r._measurement",
															Start: ast.Position{
																Column: 30,
																Line:   101,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   101,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 30,
																	Line:   101,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   101,
																},
																File:   "monitor.flux",
																Source: "_measurement",
																Start: ast.Position{
																	Column: 32,
																	Line:   101,
																},
															},
														},
														Name: "_measurement",
													},
													Rbrack: nil,
												},
												Operator: 17,
												Right: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 63,
																Line:   101,
															},
															File:   "monitor.flux",
															Source: "\"notifications\"",
															Start: ast.Position{
																Column: 48,
																Line:   101,
															},
														},
													},
													Value: "notifications",
												},
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   101,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 24,
															Line:   101,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   101,
															},
															File:   "monitor.flux",
															Source: "r",
															Start: ast.Position{
																Column: 24,
																Line:   101,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   101,
										},
										File:   "monitor.flux",
										Source: "filter(fn: (r) => r._measurement == \"notifications\")",
										Start: ast.Position{
											Column: 12,
											Line:   101,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   101,
											},
											File:   "monitor.flux",
											Source: "filter",
											Start: ast.Position{
												Column: 12,
												Line:   101,
											},
										},
									},
									Name: "filter",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   102,
								},
								File:   "monitor.flux",
								Source: "influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"notifications\")\n        |> filter(fn: fn)",
								Start: ast.Position{
									Column: 5,
									Line:   99,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   102,
										},
										File:   "monitor.flux",
										Source: "fn: fn",
										Start: ast.Position{
											Column: 19,
											Line:   102,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   102,
											},
											File:   "monitor.flux",
											Source: "fn: fn",
											Start: ast.Position{
												Column: 19,
												Line:   102,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   102,
												},
												File:   "monitor.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 19,
													Line:   102,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   102,
												},
												File:   "monitor.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 23,
													Line:   102,
												},
											},
										},
										Name: "fn",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   102,
									},
									File:   "monitor.flux",
									Source: "filter(fn: fn)",
									Start: ast.Position{
										Column: 12,
										Line:   102,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   102,
										},
										File:   "monitor.flux",
										Source: "filter",
										Start: ast.Position{
											Column: 12,
											Line:   102,
										},
									},
								},
								Name: "filter",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   103,
							},
							File:   "monitor.flux",
							Source: "influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"notifications\")\n        |> filter(fn: fn)\n        |> v1.fieldsAsCols()",
							Start: ast.Position{
								Column: 5,
								Line:   99,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   103,
								},
								File:   "monitor.flux",
								Source: "v1.fieldsAsCols()",
								Start: ast.Position{
									Column: 12,
									Line:   103,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   103,
									},
									File:   "monitor.flux",
									Source: "v1.fieldsAsCols",
									Start: ast.Position{
										Column: 12,
										Line:   103,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   103,
										},
										File:   "monitor.flux",
										Source: "v1",
										Start: ast.Position{
											Column: 12,
											Line:   103,
										},
									},
								},
								Name: "v1",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   103,
										},
										File:   "monitor.flux",
										Source: "fieldsAsCols",
										Start: ast.Position{
											Column: 15,
											Line:   103,
										},
									},
								},
								Name: "fieldsAsCols",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   98,
							},
							File:   "monitor.flux",
							Source: "start",
							Start: ast.Position{
								Column: 9,
								Line:   98,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   98,
								},
								File:   "monitor.flux",
								Source: "start",
								Start: ast.Position{
									Column: 9,
									Line:   98,
								},
							},
						},
						Name: "start",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   98,
							},
							File:   "monitor.flux",
							Source: "stop=now()",
							Start: ast.Position{
								Column: 16,
								Line:   98,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   98,
								},
								File:   "monitor.flux",
								Source: "stop",
								Start: ast.Position{
									Column: 16,
									Line:   98,
								},
							},
						},
						Name: "stop",
					},
					Separator: nil,
					Value: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   98,
								},
								File:   "monitor.flux",
								Source: "now()",
								Start: ast.Position{
									Column: 21,
									Line:   98,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   98,
									},
									File:   "monitor.flux",
									Source: "now",
									Start: ast.Position{
										Column: 21,
										Line:   98,
									},
								},
							},
							Name: "now",
						},
						Lparen: nil,
						Rparen: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   98,
							},
							File:   "monitor.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 28,
								Line:   98,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   98,
								},
								File:   "monitor.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 28,
									Line:   98,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 54,
						Line:   110,
					},
					File:   "monitor.flux",
					Source: "deadman = (t, tables=<-) => tables\n    |> max(column: \"_time\")\n    |> map(fn: (r) => ( {r with dead: r._time < t} ))",
					Start: ast.Position{
						Column: 1,
						Line:   108,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Deadman takes in a stream of tables and reports which tables\n"}, ast.Comment{Text: "// were observed strictly before t and which were observed after.\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   108,
						},
						File:   "monitor.flux",
						Source: "deadman",
						Start: ast.Position{
							Column: 1,
							Line:   108,
						},
					},
				},
				Name: "deadman",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 54,
							Line:   110,
						},
						File:   "monitor.flux",
						Source: "(t, tables=<-) => tables\n    |> max(column: \"_time\")\n    |> map(fn: (r) => ( {r with dead: r._time < t} ))",
						Start: ast.Position{
							Column: 11,
							Line:   108,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   108,
									},
									File:   "monitor.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 29,
										Line:   108,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   109,
								},
								File:   "monitor.flux",
								Source: "tables\n    |> max(column: \"_time\")",
								Start: ast.Position{
									Column: 29,
									Line:   108,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   109,
										},
										File:   "monitor.flux",
										Source: "column: \"_time\"",
										Start: ast.Position{
											Column: 12,
											Line:   109,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   109,
											},
											File:   "monitor.flux",
											Source: "column: \"_time\"",
											Start: ast.Position{
												Column: 12,
												Line:   109,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   109,
												},
												File:   "monitor.flux",
												Source: "column",
												Start: ast.Position{
													Column: 12,
													Line:   109,
												},
											},
										},
										Name: "column",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   109,
												},
												File:   "monitor.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 20,
													Line:   109,
												},
											},
										},
										Value: "_time",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   109,
									},
									File:   "monitor.flux",
									Source: "max(column: \"_time\")",
									Start: ast.Position{
										Column: 8,
										Line:   109,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   109,
										},
										File:   "monitor.flux",
										Source: "max",
										Start: ast.Position{
											Column: 8,
											Line:   109,
										},
									},
								},
								Name: "max",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   110,
							},
							File:   "monitor.flux",
							Source: "tables\n    |> max(column: \"_time\")\n    |> map(fn: (r) => ( {r with dead: r._time < t} ))",
							Start: ast.Position{
								Column: 29,
								Line:   108,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   110,
									},
									File:   "monitor.flux",
									Source: "fn: (r) => ( {r with dead: r._time < t} )",
									Start: ast.Position{
										Column: 12,
										Line:   110,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   110,
										},
										File:   "monitor.flux",
										Source: "fn: (r) => ( {r with dead: r._time < t} )",
										Start: ast.Position{
											Column: 12,
											Line:   110,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   110,
											},
											File:   "monitor.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   110,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   110,
											},
											File:   "monitor.flux",
											Source: "(r) => ( {r with dead: r._time < t} )",
											Start: ast.Position{
												Column: 16,
												Line:   110,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   110,
												},
												File:   "monitor.flux",
												Source: "( {r with dead: r._time < t} )",
												Start: ast.Position{
													Column: 23,
													Line:   110,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 51,
														Line:   110,
													},
													File:   "monitor.flux",
													Source: "{r with dead: r._time < t}",
													Start: ast.Position{
														Column: 25,
														Line:   110,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   110,
														},
														File:   "monitor.flux",
														Source: "dead: r._time < t",
														Start: ast.Position{
															Column: 33,
															Line:   110,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   110,
															},
															File:   "monitor.flux",
															Source: "dead",
															Start: ast.Position{
																Column: 33,
																Line:   110,
															},
														},
													},
													Name: "dead",
												},
												Separator: nil,
												Value: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   110,
															},
															File:   "monitor.flux",
															Source: "r._time < t",
															Start: ast.Position{
																Column: 39,
																Line:   110,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   110,
																},
																File:   "monitor.flux",
																Source: "r._time",
																Start: ast.Position{
																	Column: 39,
																	Line:   110,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 40,
																		Line:   110,
																	},
																	File:   "monitor.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 39,
																		Line:   110,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   110,
																	},
																	File:   "monitor.flux",
																	Source: "_time",
																	Start: ast.Position{
																		Column: 41,
																		Line:   110,
																	},
																},
															},
															Name: "_time",
														},
														Rbrack: nil,
													},
													Operator: 8,
													Right: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 50,
																	Line:   110,
																},
																File:   "monitor.flux",
																Source: "t",
																Start: ast.Position{
																	Column: 49,
																	Line:   110,
																},
															},
														},
														Name: "t",
													},
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   110,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 26,
															Line:   110,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   110,
												},
												File:   "monitor.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   110,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   110,
													},
													File:   "monitor.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   110,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   110,
								},
								File:   "monitor.flux",
								Source: "map(fn: (r) => ( {r with dead: r._time < t} ))",
								Start: ast.Position{
									Column: 8,
									Line:   110,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   110,
									},
									File:   "monitor.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   110,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   108,
							},
							File:   "monitor.flux",
							Source: "t",
							Start: ast.Position{
								Column: 12,
								Line:   108,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   108,
								},
								File:   "monitor.flux",
								Source: "t",
								Start: ast.Position{
									Column: 12,
									Line:   108,
								},
							},
						},
						Name: "t",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   108,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   108,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   108,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   108,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   108,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   108,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   145,
					},
					File:   "monitor.flux",
					Source: "check = (\n    tables=<-,\n    data,\n    messageFn,\n    crit=(r) => false,\n    warn=(r) => false,\n    info=(r) => false,\n    ok=(r) => true\n) =>\n    tables\n        |> experimental.set(o: data.tags)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n        |> map(fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }))\n        |> map(fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }))\n        |> experimental.group(mode: \"extend\", columns: [\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"])\n        |> write()",
					Start: ast.Position{
						Column: 1,
						Line:   114,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Check performs a check against its input using the given ok, info, warn and crit functions\n"}, ast.Comment{Text: "// and writes the result to a system bucket.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   114,
						},
						File:   "monitor.flux",
						Source: "check",
						Start: ast.Position{
							Column: 1,
							Line:   114,
						},
					},
				},
				Name: "check",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   145,
						},
						File:   "monitor.flux",
						Source: "(\n    tables=<-,\n    data,\n    messageFn,\n    crit=(r) => false,\n    warn=(r) => false,\n    info=(r) => false,\n    ok=(r) => true\n) =>\n    tables\n        |> experimental.set(o: data.tags)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n        |> map(fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }))\n        |> map(fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }))\n        |> experimental.group(mode: \"extend\", columns: [\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"])\n        |> write()",
						Start: ast.Position{
							Column: 9,
							Line:   114,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   123,
													},
													File:   "monitor.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 5,
														Line:   123,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   124,
												},
												File:   "monitor.flux",
												Source: "tables\n        |> experimental.set(o: data.tags)",
												Start: ast.Position{
													Column: 5,
													Line:   123,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   124,
														},
														File:   "monitor.flux",
														Source: "o: data.tags",
														Start: ast.Position{
															Column: 29,
															Line:   124,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   124,
															},
															File:   "monitor.flux",
															Source: "o: data.tags",
															Start: ast.Position{
																Column: 29,
																Line:   124,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   124,
																},
																File:   "monitor.flux",
																Source: "o",
																Start: ast.Position{
																	Column: 29,
																	Line:   124,
																},
															},
														},
														Name: "o",
													},
													Separator: nil,
													Value: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   124,
																},
																File:   "monitor.flux",
																Source: "data.tags",
																Start: ast.Position{
																	Column: 32,
																	Line:   124,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   124,
																	},
																	File:   "monitor.flux",
																	Source: "data",
																	Start: ast.Position{
																		Column: 32,
																		Line:   124,
																	},
																},
															},
															Name: "data",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   124,
																	},
																	File:   "monitor.flux",
																	Source: "tags",
																	Start: ast.Position{
																		Column: 37,
																		Line:   124,
																	},
																},
															},
															Name: "tags",
														},
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   124,
													},
													File:   "monitor.flux",
													Source: "experimental.set(o: data.tags)",
													Start: ast.Position{
														Column: 12,
														Line:   124,
													},
												},
											},
											Callee: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   124,
														},
														File:   "monitor.flux",
														Source: "experimental.set",
														Start: ast.Position{
															Column: 12,
															Line:   124,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   124,
															},
															File:   "monitor.flux",
															Source: "experimental",
															Start: ast.Position{
																Column: 12,
																Line:   124,
															},
														},
													},
													Name: "experimental",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   124,
															},
															File:   "monitor.flux",
															Source: "set",
															Start: ast.Position{
																Column: 25,
																Line:   124,
															},
														},
													},
													Name: "set",
												},
												Rbrack: nil,
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 94,
												Line:   125,
											},
											File:   "monitor.flux",
											Source: "tables\n        |> experimental.set(o: data.tags)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))",
											Start: ast.Position{
												Column: 5,
												Line:   123,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 93,
														Line:   125,
													},
													File:   "monitor.flux",
													Source: "mode: \"extend\", columns: experimental.objectKeys(o: data.tags)",
													Start: ast.Position{
														Column: 31,
														Line:   125,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   125,
														},
														File:   "monitor.flux",
														Source: "mode: \"extend\"",
														Start: ast.Position{
															Column: 31,
															Line:   125,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   125,
															},
															File:   "monitor.flux",
															Source: "mode",
															Start: ast.Position{
																Column: 31,
																Line:   125,
															},
														},
													},
													Name: "mode",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   125,
															},
															File:   "monitor.flux",
															Source: "\"extend\"",
															Start: ast.Position{
																Column: 37,
																Line:   125,
															},
														},
													},
													Value: "extend",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 93,
															Line:   125,
														},
														File:   "monitor.flux",
														Source: "columns: experimental.objectKeys(o: data.tags)",
														Start: ast.Position{
															Column: 47,
															Line:   125,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 54,
																Line:   125,
															},
															File:   "monitor.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 47,
																Line:   125,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 92,
																	Line:   125,
																},
																File:   "monitor.flux",
																Source: "o: data.tags",
																Start: ast.Position{
																	Column: 80,
																	Line:   125,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 92,
																		Line:   125,
																	},
																	File:   "monitor.flux",
																	Source: "o: data.tags",
																	Start: ast.Position{
																		Column: 80,
																		Line:   125,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 81,
																			Line:   125,
																		},
																		File:   "monitor.flux",
																		Source: "o",
																		Start: ast.Position{
																			Column: 80,
																			Line:   125,
																		},
																	},
																},
																Name: "o",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 92,
																			Line:   125,
																		},
																		File:   "monitor.flux",
																		Source: "data.tags",
																		Start: ast.Position{
																			Column: 83,
																			Line:   125,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 87,
																				Line:   125,
																			},
																			File:   "monitor.flux",
																			Source: "data",
																			Start: ast.Position{
																				Column: 83,
																				Line:   125,
																			},
																		},
																	},
																	Name: "data",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 92,
																				Line:   125,
																			},
																			File:   "monitor.flux",
																			Source: "tags",
																			Start: ast.Position{
																				Column: 88,
																				Line:   125,
																			},
																		},
																	},
																	Name: "tags",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 93,
																Line:   125,
															},
															File:   "monitor.flux",
															Source: "experimental.objectKeys(o: data.tags)",
															Start: ast.Position{
																Column: 56,
																Line:   125,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 79,
																	Line:   125,
																},
																File:   "monitor.flux",
																Source: "experimental.objectKeys",
																Start: ast.Position{
																	Column: 56,
																	Line:   125,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   125,
																	},
																	File:   "monitor.flux",
																	Source: "experimental",
																	Start: ast.Position{
																		Column: 56,
																		Line:   125,
																	},
																},
															},
															Name: "experimental",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 79,
																		Line:   125,
																	},
																	File:   "monitor.flux",
																	Source: "objectKeys",
																	Start: ast.Position{
																		Column: 69,
																		Line:   125,
																	},
																},
															},
															Name: "objectKeys",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   125,
												},
												File:   "monitor.flux",
												Source: "experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))",
												Start: ast.Position{
													Column: 12,
													Line:   125,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   125,
													},
													File:   "monitor.flux",
													Source: "experimental.group",
													Start: ast.Position{
														Column: 12,
														Line:   125,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   125,
														},
														File:   "monitor.flux",
														Source: "experimental",
														Start: ast.Position{
															Column: 12,
															Line:   125,
														},
													},
												},
												Name: "experimental",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   125,
														},
														File:   "monitor.flux",
														Source: "group",
														Start: ast.Position{
															Column: 25,
															Line:   125,
														},
													},
												},
												Name: "group",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   140,
										},
										File:   "monitor.flux",
										Source: "tables\n        |> experimental.set(o: data.tags)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n        |> map(fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }))",
										Start: ast.Position{
											Column: 5,
											Line:   123,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   140,
												},
												File:   "monitor.flux",
												Source: "fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        })",
												Start: ast.Position{
													Column: 16,
													Line:   126,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   140,
													},
													File:   "monitor.flux",
													Source: "fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        })",
													Start: ast.Position{
														Column: 16,
														Line:   126,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   126,
														},
														File:   "monitor.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 16,
															Line:   126,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   140,
														},
														File:   "monitor.flux",
														Source: "(r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        })",
														Start: ast.Position{
															Column: 20,
															Line:   126,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 11,
																Line:   140,
															},
															File:   "monitor.flux",
															Source: "({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        })",
															Start: ast.Position{
																Column: 27,
																Line:   126,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 10,
																	Line:   140,
																},
																File:   "monitor.flux",
																Source: "{r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }",
																Start: ast.Position{
																	Column: 28,
																	Line:   126,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   127,
																	},
																	File:   "monitor.flux",
																	Source: "_measurement: \"statuses\"",
																	Start: ast.Position{
																		Column: 13,
																		Line:   127,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   127,
																		},
																		File:   "monitor.flux",
																		Source: "_measurement",
																		Start: ast.Position{
																			Column: 13,
																			Line:   127,
																		},
																	},
																},
																Name: "_measurement",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   127,
																		},
																		File:   "monitor.flux",
																		Source: "\"statuses\"",
																		Start: ast.Position{
																			Column: 27,
																			Line:   127,
																		},
																	},
																},
																Value: "statuses",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   128,
																	},
																	File:   "monitor.flux",
																	Source: "_source_measurement: r._measurement",
																	Start: ast.Position{
																		Column: 13,
																		Line:   128,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 32,
																			Line:   128,
																		},
																		File:   "monitor.flux",
																		Source: "_source_measurement",
																		Start: ast.Position{
																			Column: 13,
																			Line:   128,
																		},
																	},
																},
																Name: "_source_measurement",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 48,
																			Line:   128,
																		},
																		File:   "monitor.flux",
																		Source: "r._measurement",
																		Start: ast.Position{
																			Column: 34,
																			Line:   128,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 35,
																				Line:   128,
																			},
																			File:   "monitor.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 34,
																				Line:   128,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   128,
																			},
																			File:   "monitor.flux",
																			Source: "_measurement",
																			Start: ast.Position{
																				Column: 36,
																				Line:   128,
																			},
																		},
																	},
																	Name: "_measurement",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   129,
																	},
																	File:   "monitor.flux",
																	Source: "_type: data._type",
																	Start: ast.Position{
																		Column: 13,
																		Line:   129,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   129,
																		},
																		File:   "monitor.flux",
																		Source: "_type",
																		Start: ast.Position{
																			Column: 13,
																			Line:   129,
																		},
																	},
																},
																Name: "_type",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 30,
																			Line:   129,
																		},
																		File:   "monitor.flux",
																		Source: "data._type",
																		Start: ast.Position{
																			Column: 20,
																			Line:   129,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   129,
																			},
																			File:   "monitor.flux",
																			Source: "data",
																			Start: ast.Position{
																				Column: 20,
																				Line:   129,
																			},
																		},
																	},
																	Name: "data",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   129,
																			},
																			File:   "monitor.flux",
																			Source: "_type",
																			Start: ast.Position{
																				Column: 25,
																				Line:   129,
																			},
																		},
																	},
																	Name: "_type",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 39,
																		Line:   130,
																	},
																	File:   "monitor.flux",
																	Source: "_check_id:  data._check_id",
																	Start: ast.Position{
																		Column: 13,
																		Line:   130,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   130,
																		},
																		File:   "monitor.flux",
																		Source: "_check_id",
																		Start: ast.Position{
																			Column: 13,
																			Line:   130,
																		},
																	},
																},
																Name: "_check_id",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 39,
																			Line:   130,
																		},
																		File:   "monitor.flux",
																		Source: "data._check_id",
																		Start: ast.Position{
																			Column: 25,
																			Line:   130,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   130,
																			},
																			File:   "monitor.flux",
																			Source: "data",
																			Start: ast.Position{
																				Column: 25,
																				Line:   130,
																			},
																		},
																	},
																	Name: "data",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 39,
																				Line:   130,
																			},
																			File:   "monitor.flux",
																			Source: "_check_id",
																			Start: ast.Position{
																				Column: 30,
																				Line:   130,
																			},
																		},
																	},
																	Name: "_check_id",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 42,
																		Line:   131,
																	},
																	File:   "monitor.flux",
																	Source: "_check_name: data._check_name",
																	Start: ast.Position{
																		Column: 13,
																		Line:   131,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 24,
																			Line:   131,
																		},
																		File:   "monitor.flux",
																		Source: "_check_name",
																		Start: ast.Position{
																			Column: 13,
																			Line:   131,
																		},
																	},
																},
																Name: "_check_name",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   131,
																		},
																		File:   "monitor.flux",
																		Source: "data._check_name",
																		Start: ast.Position{
																			Column: 26,
																			Line:   131,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   131,
																			},
																			File:   "monitor.flux",
																			Source: "data",
																			Start: ast.Position{
																				Column: 26,
																				Line:   131,
																			},
																		},
																	},
																	Name: "data",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 42,
																				Line:   131,
																			},
																			File:   "monitor.flux",
																			Source: "_check_name",
																			Start: ast.Position{
																				Column: 31,
																				Line:   131,
																			},
																		},
																	},
																	Name: "_check_name",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   137,
																	},
																	File:   "monitor.flux",
																	Source: "_level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown",
																	Start: ast.Position{
																		Column: 13,
																		Line:   132,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 19,
																			Line:   132,
																		},
																		File:   "monitor.flux",
																		Source: "_level",
																		Start: ast.Position{
																			Column: 13,
																			Line:   132,
																		},
																	},
																},
																Name: "_level",
															},
															Separator: nil,
															Value: &ast.ConditionalExpression{
																Alternate: &ast.ConditionalExpression{
																	Alternate: &ast.ConditionalExpression{
																		Alternate: &ast.ConditionalExpression{
																			Alternate: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 34,
																							Line:   137,
																						},
																						File:   "monitor.flux",
																						Source: "levelUnknown",
																						Start: ast.Position{
																							Column: 22,
																							Line:   137,
																						},
																					},
																				},
																				Name: "levelUnknown",
																			},
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 34,
																						Line:   137,
																					},
																					File:   "monitor.flux",
																					Source: "if ok(r: r) then levelOK\n                else levelUnknown",
																					Start: ast.Position{
																						Column: 22,
																						Line:   136,
																					},
																				},
																			},
																			Consequent: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 46,
																							Line:   136,
																						},
																						File:   "monitor.flux",
																						Source: "levelOK",
																						Start: ast.Position{
																							Column: 39,
																							Line:   136,
																						},
																					},
																				},
																				Name: "levelOK",
																			},
																			Test: &ast.CallExpression{
																				Arguments: []ast.Expression{&ast.ObjectExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 32,
																								Line:   136,
																							},
																							File:   "monitor.flux",
																							Source: "r: r",
																							Start: ast.Position{
																								Column: 28,
																								Line:   136,
																							},
																						},
																					},
																					Lbrace: nil,
																					Properties: []*ast.Property{&ast.Property{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 32,
																									Line:   136,
																								},
																								File:   "monitor.flux",
																								Source: "r: r",
																								Start: ast.Position{
																									Column: 28,
																									Line:   136,
																								},
																							},
																						},
																						Comma: nil,
																						Key: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 29,
																										Line:   136,
																									},
																									File:   "monitor.flux",
																									Source: "r",
																									Start: ast.Position{
																										Column: 28,
																										Line:   136,
																									},
																								},
																							},
																							Name: "r",
																						},
																						Separator: nil,
																						Value: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 32,
																										Line:   136,
																									},
																									File:   "monitor.flux",
																									Source: "r",
																									Start: ast.Position{
																										Column: 31,
																										Line:   136,
																									},
																								},
																							},
																							Name: "r",
																						},
																					}},
																					Rbrace: nil,
																					With:   nil,
																				}},
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 33,
																							Line:   136,
																						},
																						File:   "monitor.flux",
																						Source: "ok(r: r)",
																						Start: ast.Position{
																							Column: 25,
																							Line:   136,
																						},
																					},
																				},
																				Callee: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 27,
																								Line:   136,
																							},
																							File:   "monitor.flux",
																							Source: "ok",
																							Start: ast.Position{
																								Column: 25,
																								Line:   136,
																							},
																						},
																					},
																					Name: "ok",
																				},
																				Lparen: nil,
																				Rparen: nil,
																			},
																			Tk_else: nil,
																			Tk_if:   nil,
																			Tk_then: nil,
																		},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 34,
																					Line:   137,
																				},
																				File:   "monitor.flux",
																				Source: "if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown",
																				Start: ast.Position{
																					Column: 22,
																					Line:   135,
																				},
																			},
																		},
																		Consequent: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 50,
																						Line:   135,
																					},
																					File:   "monitor.flux",
																					Source: "levelInfo",
																					Start: ast.Position{
																						Column: 41,
																						Line:   135,
																					},
																				},
																			},
																			Name: "levelInfo",
																		},
																		Test: &ast.CallExpression{
																			Arguments: []ast.Expression{&ast.ObjectExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 34,
																							Line:   135,
																						},
																						File:   "monitor.flux",
																						Source: "r: r",
																						Start: ast.Position{
																							Column: 30,
																							Line:   135,
																						},
																					},
																				},
																				Lbrace: nil,
																				Properties: []*ast.Property{&ast.Property{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 34,
																								Line:   135,
																							},
																							File:   "monitor.flux",
																							Source: "r: r",
																							Start: ast.Position{
																								Column: 30,
																								Line:   135,
																							},
																						},
																					},
																					Comma: nil,
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 31,
																									Line:   135,
																								},
																								File:   "monitor.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 30,
																									Line:   135,
																								},
																							},
																						},
																						Name: "r",
																					},
																					Separator: nil,
																					Value: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 34,
																									Line:   135,
																								},
																								File:   "monitor.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 33,
																									Line:   135,
																								},
																							},
																						},
																						Name: "r",
																					},
																				}},
																				Rbrace: nil,
																				With:   nil,
																			}},
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 35,
																						Line:   135,
																					},
																					File:   "monitor.flux",
																					Source: "info(r: r)",
																					Start: ast.Position{
																						Column: 25,
																						Line:   135,
																					},
																				},
																			},
																			Callee: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 29,
																							Line:   135,
																						},
																						File:   "monitor.flux",
																						Source: "info",
																						Start: ast.Position{
																							Column: 25,
																							Line:   135,
																						},
																					},
																				},
																				Name: "info",
																			},
																			Lparen: nil,
																			Rparen: nil,
																		},
																		Tk_else: nil,
																		Tk_if:   nil,
																		Tk_then: nil,
																	},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 34,
																				Line:   137,
																			},
																			File:   "monitor.flux",
																			Source: "if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown",
																			Start: ast.Position{
																				Column: 22,
																				Line:   134,
																			},
																		},
																	},
																	Consequent: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 50,
																					Line:   134,
																				},
																				File:   "monitor.flux",
																				Source: "levelWarn",
																				Start: ast.Position{
																					Column: 41,
																					Line:   134,
																				},
																			},
																		},
																		Name: "levelWarn",
																	},
																	Test: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 34,
																						Line:   134,
																					},
																					File:   "monitor.flux",
																					Source: "r: r",
																					Start: ast.Position{
																						Column: 30,
																						Line:   134,
																					},
																				},
																			},
																			Lbrace: nil,
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 34,
																							Line:   134,
																						},
																						File:   "monitor.flux",
																						Source: "r: r",
																						Start: ast.Position{
																							Column: 30,
																							Line:   134,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 31,
																								Line:   134,
																							},
																							File:   "monitor.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 30,
																								Line:   134,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Separator: nil,
																				Value: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 34,
																								Line:   134,
																							},
																							File:   "monitor.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 33,
																								Line:   134,
																							},
																						},
																					},
																					Name: "r",
																				},
																			}},
																			Rbrace: nil,
																			With:   nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 35,
																					Line:   134,
																				},
																				File:   "monitor.flux",
																				Source: "warn(r: r)",
																				Start: ast.Position{
																					Column: 25,
																					Line:   134,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 29,
																						Line:   134,
																					},
																					File:   "monitor.flux",
																					Source: "warn",
																					Start: ast.Position{
																						Column: 25,
																						Line:   134,
																					},
																				},
																			},
																			Name: "warn",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																	Tk_else: nil,
																	Tk_if:   nil,
																	Tk_then: nil,
																},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 34,
																			Line:   137,
																		},
																		File:   "monitor.flux",
																		Source: "if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown",
																		Start: ast.Position{
																			Column: 17,
																			Line:   133,
																		},
																	},
																},
																Consequent: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   133,
																			},
																			File:   "monitor.flux",
																			Source: "levelCrit",
																			Start: ast.Position{
																				Column: 36,
																				Line:   133,
																			},
																		},
																	},
																	Name: "levelCrit",
																},
																Test: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 29,
																					Line:   133,
																				},
																				File:   "monitor.flux",
																				Source: "r: r",
																				Start: ast.Position{
																					Column: 25,
																					Line:   133,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 29,
																						Line:   133,
																					},
																					File:   "monitor.flux",
																					Source: "r: r",
																					Start: ast.Position{
																						Column: 25,
																						Line:   133,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 26,
																							Line:   133,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 25,
																							Line:   133,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Separator: nil,
																			Value: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 29,
																							Line:   133,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 28,
																							Line:   133,
																						},
																					},
																				},
																				Name: "r",
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   133,
																			},
																			File:   "monitor.flux",
																			Source: "crit(r: r)",
																			Start: ast.Position{
																				Column: 20,
																				Line:   133,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 24,
																					Line:   133,
																				},
																				File:   "monitor.flux",
																				Source: "crit",
																				Start: ast.Position{
																					Column: 20,
																					Line:   133,
																				},
																			},
																		},
																		Name: "crit",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
																Tk_else: nil,
																Tk_if:   nil,
																Tk_then: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   138,
																	},
																	File:   "monitor.flux",
																	Source: "_source_timestamp: int(v:r._time)",
																	Start: ast.Position{
																		Column: 13,
																		Line:   138,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 30,
																			Line:   138,
																		},
																		File:   "monitor.flux",
																		Source: "_source_timestamp",
																		Start: ast.Position{
																			Column: 13,
																			Line:   138,
																		},
																	},
																},
																Name: "_source_timestamp",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   138,
																			},
																			File:   "monitor.flux",
																			Source: "v:r._time",
																			Start: ast.Position{
																				Column: 36,
																				Line:   138,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 45,
																					Line:   138,
																				},
																				File:   "monitor.flux",
																				Source: "v:r._time",
																				Start: ast.Position{
																					Column: 36,
																					Line:   138,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 37,
																						Line:   138,
																					},
																					File:   "monitor.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 36,
																						Line:   138,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 45,
																						Line:   138,
																					},
																					File:   "monitor.flux",
																					Source: "r._time",
																					Start: ast.Position{
																						Column: 38,
																						Line:   138,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 39,
																							Line:   138,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 38,
																							Line:   138,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 45,
																							Line:   138,
																						},
																						File:   "monitor.flux",
																						Source: "_time",
																						Start: ast.Position{
																							Column: 40,
																							Line:   138,
																						},
																					},
																				},
																				Name: "_time",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   138,
																		},
																		File:   "monitor.flux",
																		Source: "int(v:r._time)",
																		Start: ast.Position{
																			Column: 32,
																			Line:   138,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 35,
																				Line:   138,
																			},
																			File:   "monitor.flux",
																			Source: "int",
																			Start: ast.Position{
																				Column: 32,
																				Line:   138,
																			},
																		},
																	},
																	Name: "int",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   139,
																	},
																	File:   "monitor.flux",
																	Source: "_time: now()",
																	Start: ast.Position{
																		Column: 13,
																		Line:   139,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   139,
																		},
																		File:   "monitor.flux",
																		Source: "_time",
																		Start: ast.Position{
																			Column: 13,
																			Line:   139,
																		},
																	},
																},
																Name: "_time",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: nil,
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   139,
																		},
																		File:   "monitor.flux",
																		Source: "now()",
																		Start: ast.Position{
																			Column: 20,
																			Line:   139,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 23,
																				Line:   139,
																			},
																			File:   "monitor.flux",
																			Source: "now",
																			Start: ast.Position{
																				Column: 20,
																				Line:   139,
																			},
																		},
																	},
																	Name: "now",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   126,
																	},
																	File:   "monitor.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 29,
																		Line:   126,
																	},
																},
															},
															Name: "r",
														},
													},
													Lparen: nil,
													Rparen: nil,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   126,
															},
															File:   "monitor.flux",
															Source: "r",
															Start: ast.Position{
																Column: 21,
																Line:   126,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   126,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 21,
																	Line:   126,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   140,
											},
											File:   "monitor.flux",
											Source: "map(fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }))",
											Start: ast.Position{
												Column: 12,
												Line:   126,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   126,
												},
												File:   "monitor.flux",
												Source: "map",
												Start: ast.Position{
													Column: 12,
													Line:   126,
												},
											},
										},
										Name: "map",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   143,
									},
									File:   "monitor.flux",
									Source: "tables\n        |> experimental.set(o: data.tags)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n        |> map(fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }))\n        |> map(fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }))",
									Start: ast.Position{
										Column: 5,
										Line:   123,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   143,
											},
											File:   "monitor.flux",
											Source: "fn: (r) => ({r with\n            _message: messageFn(r: r),\n        })",
											Start: ast.Position{
												Column: 16,
												Line:   141,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   143,
												},
												File:   "monitor.flux",
												Source: "fn: (r) => ({r with\n            _message: messageFn(r: r),\n        })",
												Start: ast.Position{
													Column: 16,
													Line:   141,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   141,
													},
													File:   "monitor.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 16,
														Line:   141,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   143,
													},
													File:   "monitor.flux",
													Source: "(r) => ({r with\n            _message: messageFn(r: r),\n        })",
													Start: ast.Position{
														Column: 20,
														Line:   141,
													},
												},
											},
											Body: &ast.ParenExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   143,
														},
														File:   "monitor.flux",
														Source: "({r with\n            _message: messageFn(r: r),\n        })",
														Start: ast.Position{
															Column: 27,
															Line:   141,
														},
													},
												},
												Expression: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 10,
																Line:   143,
															},
															File:   "monitor.flux",
															Source: "{r with\n            _message: messageFn(r: r),\n        }",
															Start: ast.Position{
																Column: 28,
																Line:   141,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   142,
																},
																File:   "monitor.flux",
																Source: "_message: messageFn(r: r)",
																Start: ast.Position{
																	Column: 13,
																	Line:   142,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   142,
																	},
																	File:   "monitor.flux",
																	Source: "_message",
																	Start: ast.Position{
																		Column: 13,
																		Line:   142,
																	},
																},
															},
															Name: "_message",
														},
														Separator: nil,
														Value: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   142,
																		},
																		File:   "monitor.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 33,
																			Line:   142,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 37,
																				Line:   142,
																			},
																			File:   "monitor.flux",
																			Source: "r: r",
																			Start: ast.Position{
																				Column: 33,
																				Line:   142,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 34,
																					Line:   142,
																				},
																				File:   "monitor.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 33,
																					Line:   142,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Separator: nil,
																	Value: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 37,
																					Line:   142,
																				},
																				File:   "monitor.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 36,
																					Line:   142,
																				},
																			},
																		},
																		Name: "r",
																	},
																}},
																Rbrace: nil,
																With:   nil,
															}},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   142,
																	},
																	File:   "monitor.flux",
																	Source: "messageFn(r: r)",
																	Start: ast.Position{
																		Column: 23,
																		Line:   142,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 32,
																			Line:   142,
																		},
																		File:   "monitor.flux",
																		Source: "messageFn",
																		Start: ast.Position{
																			Column: 23,
																			Line:   142,
																		},
																	},
																},
																Name: "messageFn",
															},
															Lparen: nil,
															Rparen: nil,
														},
													}},
													Rbrace: nil,
													With: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   141,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 29,
																	Line:   141,
																},
															},
														},
														Name: "r",
													},
												},
												Lparen: nil,
												Rparen: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   141,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 21,
															Line:   141,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   141,
															},
															File:   "monitor.flux",
															Source: "r",
															Start: ast.Position{
																Column: 21,
																Line:   141,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   143,
										},
										File:   "monitor.flux",
										Source: "map(fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }))",
										Start: ast.Position{
											Column: 12,
											Line:   141,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   141,
											},
											File:   "monitor.flux",
											Source: "map",
											Start: ast.Position{
												Column: 12,
												Line:   141,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 127,
									Line:   144,
								},
								File:   "monitor.flux",
								Source: "tables\n        |> experimental.set(o: data.tags)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n        |> map(fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }))\n        |> map(fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }))\n        |> experimental.group(mode: \"extend\", columns: [\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"])",
								Start: ast.Position{
									Column: 5,
									Line:   123,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 126,
											Line:   144,
										},
										File:   "monitor.flux",
										Source: "mode: \"extend\", columns: [\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"]",
										Start: ast.Position{
											Column: 31,
											Line:   144,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   144,
											},
											File:   "monitor.flux",
											Source: "mode: \"extend\"",
											Start: ast.Position{
												Column: 31,
												Line:   144,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   144,
												},
												File:   "monitor.flux",
												Source: "mode",
												Start: ast.Position{
													Column: 31,
													Line:   144,
												},
											},
										},
										Name: "mode",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   144,
												},
												File:   "monitor.flux",
												Source: "\"extend\"",
												Start: ast.Position{
													Column: 37,
													Line:   144,
												},
											},
										},
										Value: "extend",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 126,
												Line:   144,
											},
											File:   "monitor.flux",
											Source: "columns: [\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"]",
											Start: ast.Position{
												Column: 47,
												Line:   144,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   144,
												},
												File:   "monitor.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 47,
													Line:   144,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 126,
													Line:   144,
												},
												File:   "monitor.flux",
												Source: "[\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"]",
												Start: ast.Position{
													Column: 56,
													Line:   144,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   144,
													},
													File:   "monitor.flux",
													Source: "\"_source_measurement\"",
													Start: ast.Position{
														Column: 57,
														Line:   144,
													},
												},
											},
											Value: "_source_measurement",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   144,
													},
													File:   "monitor.flux",
													Source: "\"_type\"",
													Start: ast.Position{
														Column: 80,
														Line:   144,
													},
												},
											},
											Value: "_type",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 100,
														Line:   144,
													},
													File:   "monitor.flux",
													Source: "\"_check_id\"",
													Start: ast.Position{
														Column: 89,
														Line:   144,
													},
												},
											},
											Value: "_check_id",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 115,
														Line:   144,
													},
													File:   "monitor.flux",
													Source: "\"_check_name\"",
													Start: ast.Position{
														Column: 102,
														Line:   144,
													},
												},
											},
											Value: "_check_name",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 125,
														Line:   144,
													},
													File:   "monitor.flux",
													Source: "\"_level\"",
													Start: ast.Position{
														Column: 117,
														Line:   144,
													},
												},
											},
											Value: "_level",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 127,
										Line:   144,
									},
									File:   "monitor.flux",
									Source: "experimental.group(mode: \"extend\", columns: [\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"])",
									Start: ast.Position{
										Column: 12,
										Line:   144,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   144,
										},
										File:   "monitor.flux",
										Source: "experimental.group",
										Start: ast.Position{
											Column: 12,
											Line:   144,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   144,
											},
											File:   "monitor.flux",
											Source: "experimental",
											Start: ast.Position{
												Column: 12,
												Line:   144,
											},
										},
									},
									Name: "experimental",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   144,
											},
											File:   "monitor.flux",
											Source: "group",
											Start: ast.Position{
												Column: 25,
												Line:   144,
											},
										},
									},
									Name: "group",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   145,
							},
							File:   "monitor.flux",
							Source: "tables\n        |> experimental.set(o: data.tags)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n        |> map(fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }))\n        |> map(fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }))\n        |> experimental.group(mode: \"extend\", columns: [\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"])\n        |> write()",
							Start: ast.Position{
								Column: 5,
								Line:   123,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   145,
								},
								File:   "monitor.flux",
								Source: "write()",
								Start: ast.Position{
									Column: 12,
									Line:   145,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   145,
									},
									File:   "monitor.flux",
									Source: "write",
									Start: ast.Position{
										Column: 12,
										Line:   145,
									},
								},
							},
							Name: "write",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   115,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 5,
								Line:   115,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   115,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   115,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   115,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 12,
								Line:   115,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   116,
							},
							File:   "monitor.flux",
							Source: "data",
							Start: ast.Position{
								Column: 5,
								Line:   116,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   116,
								},
								File:   "monitor.flux",
								Source: "data",
								Start: ast.Position{
									Column: 5,
									Line:   116,
								},
							},
						},
						Name: "data",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   117,
							},
							File:   "monitor.flux",
							Source: "messageFn",
							Start: ast.Position{
								Column: 5,
								Line:   117,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   117,
								},
								File:   "monitor.flux",
								Source: "messageFn",
								Start: ast.Position{
									Column: 5,
									Line:   117,
								},
							},
						},
						Name: "messageFn",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   118,
							},
							File:   "monitor.flux",
							Source: "crit=(r) => false",
							Start: ast.Position{
								Column: 5,
								Line:   118,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   118,
								},
								File:   "monitor.flux",
								Source: "crit",
								Start: ast.Position{
									Column: 5,
									Line:   118,
								},
							},
						},
						Name: "crit",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   118,
								},
								File:   "monitor.flux",
								Source: "(r) => false",
								Start: ast.Position{
									Column: 10,
									Line:   118,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   118,
									},
									File:   "monitor.flux",
									Source: "false",
									Start: ast.Position{
										Column: 17,
										Line:   118,
									},
								},
							},
							Name: "false",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   118,
									},
									File:   "monitor.flux",
									Source: "r",
									Start: ast.Position{
										Column: 11,
										Line:   118,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   118,
										},
										File:   "monitor.flux",
										Source: "r",
										Start: ast.Position{
											Column: 11,
											Line:   118,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   119,
							},
							File:   "monitor.flux",
							Source: "warn=(r) => false",
							Start: ast.Position{
								Column: 5,
								Line:   119,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   119,
								},
								File:   "monitor.flux",
								Source: "warn",
								Start: ast.Position{
									Column: 5,
									Line:   119,
								},
							},
						},
						Name: "warn",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   119,
								},
								File:   "monitor.flux",
								Source: "(r) => false",
								Start: ast.Position{
									Column: 10,
									Line:   119,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   119,
									},
									File:   "monitor.flux",
									Source: "false",
									Start: ast.Position{
										Column: 17,
										Line:   119,
									},
								},
							},
							Name: "false",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   119,
									},
									File:   "monitor.flux",
									Source: "r",
									Start: ast.Position{
										Column: 11,
										Line:   119,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   119,
										},
										File:   "monitor.flux",
										Source: "r",
										Start: ast.Position{
											Column: 11,
											Line:   119,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   120,
							},
							File:   "monitor.flux",
							Source: "info=(r) => false",
							Start: ast.Position{
								Column: 5,
								Line:   120,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   120,
								},
								File:   "monitor.flux",
								Source: "info",
								Start: ast.Position{
									Column: 5,
									Line:   120,
								},
							},
						},
						Name: "info",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   120,
								},
								File:   "monitor.flux",
								Source: "(r) => false",
								Start: ast.Position{
									Column: 10,
									Line:   120,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   120,
									},
									File:   "monitor.flux",
									Source: "false",
									Start: ast.Position{
										Column: 17,
										Line:   120,
									},
								},
							},
							Name: "false",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   120,
									},
									File:   "monitor.flux",
									Source: "r",
									Start: ast.Position{
										Column: 11,
										Line:   120,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   120,
										},
										File:   "monitor.flux",
										Source: "r",
										Start: ast.Position{
											Column: 11,
											Line:   120,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   121,
							},
							File:   "monitor.flux",
							Source: "ok=(r) => true",
							Start: ast.Position{
								Column: 5,
								Line:   121,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 7,
									Line:   121,
								},
								File:   "monitor.flux",
								Source: "ok",
								Start: ast.Position{
									Column: 5,
									Line:   121,
								},
							},
						},
						Name: "ok",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   121,
								},
								File:   "monitor.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 8,
									Line:   121,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   121,
									},
									File:   "monitor.flux",
									Source: "true",
									Start: ast.Position{
										Column: 15,
										Line:   121,
									},
								},
							},
							Name: "true",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   121,
									},
									File:   "monitor.flux",
									Source: "r",
									Start: ast.Position{
										Column: 9,
										Line:   121,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   121,
										},
										File:   "monitor.flux",
										Source: "r",
										Start: ast.Position{
											Column: 9,
											Line:   121,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   3,
					},
					File:   "monitor.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   3,
						},
						File:   "monitor.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "experimental",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   4,
					},
					File:   "monitor.flux",
					Source: "import \"influxdata/influxdb/v1\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   4,
						},
						File:   "monitor.flux",
						Source: "\"influxdata/influxdb/v1\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "influxdata/influxdb/v1",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 29,
						Line:   5,
					},
					File:   "monitor.flux",
					Source: "import \"influxdata/influxdb\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 29,
							Line:   5,
						},
						File:   "monitor.flux",
						Source: "\"influxdata/influxdb\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "influxdata/influxdb",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "monitor.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   1,
					},
					File:   "monitor.flux",
					Source: "package monitor",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   1,
						},
						File:   "monitor.flux",
						Source: "monitor",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "monitor",
			},
		},
	}},
	Package: "monitor",
	Path:    "influxdata/influxdb/monitor",
}
