// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: binary.proto

/*
	Package binary is a generated protocol buffer package.

	It is generated from these files:
		binary.proto

	It has these top-level messages:
		Header
		BucketHeader
		BucketFooter
		FloatPoints
		IntegerPoints
		UnsignedPoints
		BooleanPoints
		StringPoints
		SeriesHeader
		SeriesFooter
*/
package binary

import (
	fmt "fmt"

	proto "github.com/gogo/protobuf/proto"

	math "math"

	_ "github.com/gogo/protobuf/gogoproto"

	time "time"

	io "io"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type FieldType int32

const (
	FloatFieldType    FieldType = 0
	IntegerFieldType  FieldType = 1
	UnsignedFieldType FieldType = 2
	BooleanFieldType  FieldType = 3
	StringFieldType   FieldType = 4
)

var FieldType_name = map[int32]string{
	0: "FLOAT",
	1: "INTEGER",
	2: "UNSIGNED",
	3: "BOOLEAN",
	4: "STRING",
}
var FieldType_value = map[string]int32{
	"FLOAT":    0,
	"INTEGER":  1,
	"UNSIGNED": 2,
	"BOOLEAN":  3,
	"STRING":   4,
}

func (x FieldType) String() string {
	return proto.EnumName(FieldType_name, int32(x))
}
func (FieldType) EnumDescriptor() ([]byte, []int) { return fileDescriptorBinary, []int{0} }

type Header_Version int32

const (
	Version0 Header_Version = 0
)

var Header_Version_name = map[int32]string{
	0: "VERSION_0",
}
var Header_Version_value = map[string]int32{
	"VERSION_0": 0,
}

func (x Header_Version) String() string {
	return proto.EnumName(Header_Version_name, int32(x))
}
func (Header_Version) EnumDescriptor() ([]byte, []int) { return fileDescriptorBinary, []int{0, 0} }

type Header struct {
	Version         Header_Version `protobuf:"varint,1,opt,name=version,proto3,enum=binary.Header_Version" json:"version,omitempty"`
	Database        string         `protobuf:"bytes,2,opt,name=database,proto3" json:"database,omitempty"`
	RetentionPolicy string         `protobuf:"bytes,3,opt,name=retention_policy,json=retentionPolicy,proto3" json:"retention_policy,omitempty"`
	ShardDuration   time.Duration  `protobuf:"varint,4,opt,name=shard_duration,json=shardDuration,proto3,stdduration" json:"shard_duration,omitempty"`
}

func (m *Header) Reset()                    { *m = Header{} }
func (m *Header) String() string            { return proto.CompactTextString(m) }
func (*Header) ProtoMessage()               {}
func (*Header) Descriptor() ([]byte, []int) { return fileDescriptorBinary, []int{0} }

type BucketHeader struct {
	Start int64 `protobuf:"fixed64,1,opt,name=start,proto3" json:"start,omitempty"`
	End   int64 `protobuf:"fixed64,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (m *BucketHeader) Reset()                    { *m = BucketHeader{} }
func (m *BucketHeader) String() string            { return proto.CompactTextString(m) }
func (*BucketHeader) ProtoMessage()               {}
func (*BucketHeader) Descriptor() ([]byte, []int) { return fileDescriptorBinary, []int{1} }

type BucketFooter struct {
}

func (m *BucketFooter) Reset()                    { *m = BucketFooter{} }
func (m *BucketFooter) String() string            { return proto.CompactTextString(m) }
func (*BucketFooter) ProtoMessage()               {}
func (*BucketFooter) Descriptor() ([]byte, []int) { return fileDescriptorBinary, []int{2} }

type FloatPoints struct {
	Timestamps []int64   `protobuf:"fixed64,1,rep,packed,name=timestamps" json:"timestamps,omitempty"`
	Values     []float64 `protobuf:"fixed64,2,rep,packed,name=values" json:"values,omitempty"`
}

func (m *FloatPoints) Reset()                    { *m = FloatPoints{} }
func (m *FloatPoints) String() string            { return proto.CompactTextString(m) }
func (*FloatPoints) ProtoMessage()               {}
func (*FloatPoints) Descriptor() ([]byte, []int) { return fileDescriptorBinary, []int{3} }

type IntegerPoints struct {
	Timestamps []int64 `protobuf:"fixed64,1,rep,packed,name=timestamps" json:"timestamps,omitempty"`
	Values     []int64 `protobuf:"varint,2,rep,packed,name=values" json:"values,omitempty"`
}

func (m *IntegerPoints) Reset()                    { *m = IntegerPoints{} }
func (m *IntegerPoints) String() string            { return proto.CompactTextString(m) }
func (*IntegerPoints) ProtoMessage()               {}
func (*IntegerPoints) Descriptor() ([]byte, []int) { return fileDescriptorBinary, []int{4} }

type UnsignedPoints struct {
	Timestamps []int64  `protobuf:"fixed64,1,rep,packed,name=timestamps" json:"timestamps,omitempty"`
	Values     []uint64 `protobuf:"varint,2,rep,packed,name=values" json:"values,omitempty"`
}

func (m *UnsignedPoints) Reset()                    { *m = UnsignedPoints{} }
func (m *UnsignedPoints) String() string            { return proto.CompactTextString(m) }
func (*UnsignedPoints) ProtoMessage()               {}
func (*UnsignedPoints) Descriptor() ([]byte, []int) { return fileDescriptorBinary, []int{5} }

type BooleanPoints struct {
	Timestamps []int64 `protobuf:"fixed64,1,rep,packed,name=timestamps" json:"timestamps,omitempty"`
	Values     []bool  `protobuf:"varint,2,rep,packed,name=values" json:"values,omitempty"`
}

func (m *BooleanPoints) Reset()                    { *m = BooleanPoints{} }
func (m *BooleanPoints) String() string            { return proto.CompactTextString(m) }
func (*BooleanPoints) ProtoMessage()               {}
func (*BooleanPoints) Descriptor() ([]byte, []int) { return fileDescriptorBinary, []int{6} }

type StringPoints struct {
	Timestamps []int64  `protobuf:"fixed64,1,rep,packed,name=timestamps" json:"timestamps,omitempty"`
	Values     []string `protobuf:"bytes,2,rep,name=values" json:"values,omitempty"`
}

func (m *StringPoints) Reset()                    { *m = StringPoints{} }
func (m *StringPoints) String() string            { return proto.CompactTextString(m) }
func (*StringPoints) ProtoMessage()               {}
func (*StringPoints) Descriptor() ([]byte, []int) { return fileDescriptorBinary, []int{7} }

type SeriesHeader struct {
	FieldType FieldType `protobuf:"varint,1,opt,name=field_type,json=fieldType,proto3,enum=binary.FieldType" json:"field_type,omitempty"`
	SeriesKey []byte    `protobuf:"bytes,2,opt,name=series_key,json=seriesKey,proto3" json:"series_key,omitempty"`
	Field     []byte    `protobuf:"bytes,3,opt,name=field,proto3" json:"field,omitempty"`
}

func (m *SeriesHeader) Reset()                    { *m = SeriesHeader{} }
func (m *SeriesHeader) String() string            { return proto.CompactTextString(m) }
func (*SeriesHeader) ProtoMessage()               {}
func (*SeriesHeader) Descriptor() ([]byte, []int) { return fileDescriptorBinary, []int{8} }

type SeriesFooter struct {
}

func (m *SeriesFooter) Reset()                    { *m = SeriesFooter{} }
func (m *SeriesFooter) String() string            { return proto.CompactTextString(m) }
func (*SeriesFooter) ProtoMessage()               {}
func (*SeriesFooter) Descriptor() ([]byte, []int) { return fileDescriptorBinary, []int{9} }

func init() {
	proto.RegisterType((*Header)(nil), "binary.Header")
	proto.RegisterType((*BucketHeader)(nil), "binary.BucketHeader")
	proto.RegisterType((*BucketFooter)(nil), "binary.BucketFooter")
	proto.RegisterType((*FloatPoints)(nil), "binary.FloatPoints")
	proto.RegisterType((*IntegerPoints)(nil), "binary.IntegerPoints")
	proto.RegisterType((*UnsignedPoints)(nil), "binary.UnsignedPoints")
	proto.RegisterType((*BooleanPoints)(nil), "binary.BooleanPoints")
	proto.RegisterType((*StringPoints)(nil), "binary.StringPoints")
	proto.RegisterType((*SeriesHeader)(nil), "binary.SeriesHeader")
	proto.RegisterType((*SeriesFooter)(nil), "binary.SeriesFooter")
	proto.RegisterEnum("binary.FieldType", FieldType_name, FieldType_value)
	proto.RegisterEnum("binary.Header_Version", Header_Version_name, Header_Version_value)
}
func (m *Header) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Header) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Version != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintBinary(dAtA, i, uint64(m.Version))
	}
	if len(m.Database) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBinary(dAtA, i, uint64(len(m.Database)))
		i += copy(dAtA[i:], m.Database)
	}
	if len(m.RetentionPolicy) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBinary(dAtA, i, uint64(len(m.RetentionPolicy)))
		i += copy(dAtA[i:], m.RetentionPolicy)
	}
	if m.ShardDuration != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintBinary(dAtA, i, uint64(m.ShardDuration))
	}
	return i, nil
}

func (m *BucketHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BucketHeader) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Start != 0 {
		dAtA[i] = 0x9
		i++
		i = encodeFixed64Binary(dAtA, i, uint64(m.Start))
	}
	if m.End != 0 {
		dAtA[i] = 0x11
		i++
		i = encodeFixed64Binary(dAtA, i, uint64(m.End))
	}
	return i, nil
}

func (m *BucketFooter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BucketFooter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *FloatPoints) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FloatPoints) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBinary(dAtA, i, uint64(len(m.Timestamps)*8))
		for _, num := range m.Timestamps {
			dAtA[i] = uint8(num)
			i++
			dAtA[i] = uint8(num >> 8)
			i++
			dAtA[i] = uint8(num >> 16)
			i++
			dAtA[i] = uint8(num >> 24)
			i++
			dAtA[i] = uint8(num >> 32)
			i++
			dAtA[i] = uint8(num >> 40)
			i++
			dAtA[i] = uint8(num >> 48)
			i++
			dAtA[i] = uint8(num >> 56)
			i++
		}
	}
	if len(m.Values) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBinary(dAtA, i, uint64(len(m.Values)*8))
		for _, num := range m.Values {
			f1 := math.Float64bits(float64(num))
			dAtA[i] = uint8(f1)
			i++
			dAtA[i] = uint8(f1 >> 8)
			i++
			dAtA[i] = uint8(f1 >> 16)
			i++
			dAtA[i] = uint8(f1 >> 24)
			i++
			dAtA[i] = uint8(f1 >> 32)
			i++
			dAtA[i] = uint8(f1 >> 40)
			i++
			dAtA[i] = uint8(f1 >> 48)
			i++
			dAtA[i] = uint8(f1 >> 56)
			i++
		}
	}
	return i, nil
}

func (m *IntegerPoints) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IntegerPoints) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBinary(dAtA, i, uint64(len(m.Timestamps)*8))
		for _, num := range m.Timestamps {
			dAtA[i] = uint8(num)
			i++
			dAtA[i] = uint8(num >> 8)
			i++
			dAtA[i] = uint8(num >> 16)
			i++
			dAtA[i] = uint8(num >> 24)
			i++
			dAtA[i] = uint8(num >> 32)
			i++
			dAtA[i] = uint8(num >> 40)
			i++
			dAtA[i] = uint8(num >> 48)
			i++
			dAtA[i] = uint8(num >> 56)
			i++
		}
	}
	if len(m.Values) > 0 {
		dAtA3 := make([]byte, len(m.Values)*10)
		var j2 int
		for _, num1 := range m.Values {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA3[j2] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j2++
			}
			dAtA3[j2] = uint8(num)
			j2++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintBinary(dAtA, i, uint64(j2))
		i += copy(dAtA[i:], dAtA3[:j2])
	}
	return i, nil
}

func (m *UnsignedPoints) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UnsignedPoints) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBinary(dAtA, i, uint64(len(m.Timestamps)*8))
		for _, num := range m.Timestamps {
			dAtA[i] = uint8(num)
			i++
			dAtA[i] = uint8(num >> 8)
			i++
			dAtA[i] = uint8(num >> 16)
			i++
			dAtA[i] = uint8(num >> 24)
			i++
			dAtA[i] = uint8(num >> 32)
			i++
			dAtA[i] = uint8(num >> 40)
			i++
			dAtA[i] = uint8(num >> 48)
			i++
			dAtA[i] = uint8(num >> 56)
			i++
		}
	}
	if len(m.Values) > 0 {
		dAtA5 := make([]byte, len(m.Values)*10)
		var j4 int
		for _, num := range m.Values {
			for num >= 1<<7 {
				dAtA5[j4] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j4++
			}
			dAtA5[j4] = uint8(num)
			j4++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintBinary(dAtA, i, uint64(j4))
		i += copy(dAtA[i:], dAtA5[:j4])
	}
	return i, nil
}

func (m *BooleanPoints) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BooleanPoints) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBinary(dAtA, i, uint64(len(m.Timestamps)*8))
		for _, num := range m.Timestamps {
			dAtA[i] = uint8(num)
			i++
			dAtA[i] = uint8(num >> 8)
			i++
			dAtA[i] = uint8(num >> 16)
			i++
			dAtA[i] = uint8(num >> 24)
			i++
			dAtA[i] = uint8(num >> 32)
			i++
			dAtA[i] = uint8(num >> 40)
			i++
			dAtA[i] = uint8(num >> 48)
			i++
			dAtA[i] = uint8(num >> 56)
			i++
		}
	}
	if len(m.Values) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBinary(dAtA, i, uint64(len(m.Values)))
		for _, b := range m.Values {
			if b {
				dAtA[i] = 1
			} else {
				dAtA[i] = 0
			}
			i++
		}
	}
	return i, nil
}

func (m *StringPoints) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StringPoints) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBinary(dAtA, i, uint64(len(m.Timestamps)*8))
		for _, num := range m.Timestamps {
			dAtA[i] = uint8(num)
			i++
			dAtA[i] = uint8(num >> 8)
			i++
			dAtA[i] = uint8(num >> 16)
			i++
			dAtA[i] = uint8(num >> 24)
			i++
			dAtA[i] = uint8(num >> 32)
			i++
			dAtA[i] = uint8(num >> 40)
			i++
			dAtA[i] = uint8(num >> 48)
			i++
			dAtA[i] = uint8(num >> 56)
			i++
		}
	}
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *SeriesHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SeriesHeader) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.FieldType != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintBinary(dAtA, i, uint64(m.FieldType))
	}
	if len(m.SeriesKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBinary(dAtA, i, uint64(len(m.SeriesKey)))
		i += copy(dAtA[i:], m.SeriesKey)
	}
	if len(m.Field) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBinary(dAtA, i, uint64(len(m.Field)))
		i += copy(dAtA[i:], m.Field)
	}
	return i, nil
}

func (m *SeriesFooter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SeriesFooter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func encodeFixed64Binary(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Binary(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintBinary(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Header) Size() (n int) {
	var l int
	_ = l
	if m.Version != 0 {
		n += 1 + sovBinary(uint64(m.Version))
	}
	l = len(m.Database)
	if l > 0 {
		n += 1 + l + sovBinary(uint64(l))
	}
	l = len(m.RetentionPolicy)
	if l > 0 {
		n += 1 + l + sovBinary(uint64(l))
	}
	if m.ShardDuration != 0 {
		n += 1 + sovBinary(uint64(m.ShardDuration))
	}
	return n
}

func (m *BucketHeader) Size() (n int) {
	var l int
	_ = l
	if m.Start != 0 {
		n += 9
	}
	if m.End != 0 {
		n += 9
	}
	return n
}

func (m *BucketFooter) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *FloatPoints) Size() (n int) {
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		n += 1 + sovBinary(uint64(len(m.Timestamps)*8)) + len(m.Timestamps)*8
	}
	if len(m.Values) > 0 {
		n += 1 + sovBinary(uint64(len(m.Values)*8)) + len(m.Values)*8
	}
	return n
}

func (m *IntegerPoints) Size() (n int) {
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		n += 1 + sovBinary(uint64(len(m.Timestamps)*8)) + len(m.Timestamps)*8
	}
	if len(m.Values) > 0 {
		l = 0
		for _, e := range m.Values {
			l += sovBinary(uint64(e))
		}
		n += 1 + sovBinary(uint64(l)) + l
	}
	return n
}

func (m *UnsignedPoints) Size() (n int) {
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		n += 1 + sovBinary(uint64(len(m.Timestamps)*8)) + len(m.Timestamps)*8
	}
	if len(m.Values) > 0 {
		l = 0
		for _, e := range m.Values {
			l += sovBinary(uint64(e))
		}
		n += 1 + sovBinary(uint64(l)) + l
	}
	return n
}

func (m *BooleanPoints) Size() (n int) {
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		n += 1 + sovBinary(uint64(len(m.Timestamps)*8)) + len(m.Timestamps)*8
	}
	if len(m.Values) > 0 {
		n += 1 + sovBinary(uint64(len(m.Values))) + len(m.Values)*1
	}
	return n
}

func (m *StringPoints) Size() (n int) {
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		n += 1 + sovBinary(uint64(len(m.Timestamps)*8)) + len(m.Timestamps)*8
	}
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			l = len(s)
			n += 1 + l + sovBinary(uint64(l))
		}
	}
	return n
}

func (m *SeriesHeader) Size() (n int) {
	var l int
	_ = l
	if m.FieldType != 0 {
		n += 1 + sovBinary(uint64(m.FieldType))
	}
	l = len(m.SeriesKey)
	if l > 0 {
		n += 1 + l + sovBinary(uint64(l))
	}
	l = len(m.Field)
	if l > 0 {
		n += 1 + l + sovBinary(uint64(l))
	}
	return n
}

func (m *SeriesFooter) Size() (n int) {
	var l int
	_ = l
	return n
}

func sovBinary(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozBinary(x uint64) (n int) {
	return sovBinary(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Header) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBinary
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Header: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Header: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBinary
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= (Header_Version(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBinary
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBinary
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Database = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetentionPolicy", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBinary
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBinary
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RetentionPolicy = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardDuration", wireType)
			}
			m.ShardDuration = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBinary
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardDuration |= (time.Duration(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBinary(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBinary
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BucketHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBinary
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BucketHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BucketHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			m.Start = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.Start = int64(dAtA[iNdEx-8])
			m.Start |= int64(dAtA[iNdEx-7]) << 8
			m.Start |= int64(dAtA[iNdEx-6]) << 16
			m.Start |= int64(dAtA[iNdEx-5]) << 24
			m.Start |= int64(dAtA[iNdEx-4]) << 32
			m.Start |= int64(dAtA[iNdEx-3]) << 40
			m.Start |= int64(dAtA[iNdEx-2]) << 48
			m.Start |= int64(dAtA[iNdEx-1]) << 56
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			m.End = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.End = int64(dAtA[iNdEx-8])
			m.End |= int64(dAtA[iNdEx-7]) << 8
			m.End |= int64(dAtA[iNdEx-6]) << 16
			m.End |= int64(dAtA[iNdEx-5]) << 24
			m.End |= int64(dAtA[iNdEx-4]) << 32
			m.End |= int64(dAtA[iNdEx-3]) << 40
			m.End |= int64(dAtA[iNdEx-2]) << 48
			m.End |= int64(dAtA[iNdEx-1]) << 56
		default:
			iNdEx = preIndex
			skippy, err := skipBinary(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBinary
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BucketFooter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBinary
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BucketFooter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BucketFooter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipBinary(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBinary
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FloatPoints) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBinary
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FloatPoints: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FloatPoints: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 1 {
				var v int64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				iNdEx += 8
				v = int64(dAtA[iNdEx-8])
				v |= int64(dAtA[iNdEx-7]) << 8
				v |= int64(dAtA[iNdEx-6]) << 16
				v |= int64(dAtA[iNdEx-5]) << 24
				v |= int64(dAtA[iNdEx-4]) << 32
				v |= int64(dAtA[iNdEx-3]) << 40
				v |= int64(dAtA[iNdEx-2]) << 48
				v |= int64(dAtA[iNdEx-1]) << 56
				m.Timestamps = append(m.Timestamps, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBinary
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthBinary
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					iNdEx += 8
					v = int64(dAtA[iNdEx-8])
					v |= int64(dAtA[iNdEx-7]) << 8
					v |= int64(dAtA[iNdEx-6]) << 16
					v |= int64(dAtA[iNdEx-5]) << 24
					v |= int64(dAtA[iNdEx-4]) << 32
					v |= int64(dAtA[iNdEx-3]) << 40
					v |= int64(dAtA[iNdEx-2]) << 48
					v |= int64(dAtA[iNdEx-1]) << 56
					m.Timestamps = append(m.Timestamps, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamps", wireType)
			}
		case 2:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				iNdEx += 8
				v = uint64(dAtA[iNdEx-8])
				v |= uint64(dAtA[iNdEx-7]) << 8
				v |= uint64(dAtA[iNdEx-6]) << 16
				v |= uint64(dAtA[iNdEx-5]) << 24
				v |= uint64(dAtA[iNdEx-4]) << 32
				v |= uint64(dAtA[iNdEx-3]) << 40
				v |= uint64(dAtA[iNdEx-2]) << 48
				v |= uint64(dAtA[iNdEx-1]) << 56
				v2 := float64(math.Float64frombits(v))
				m.Values = append(m.Values, v2)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBinary
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthBinary
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					iNdEx += 8
					v = uint64(dAtA[iNdEx-8])
					v |= uint64(dAtA[iNdEx-7]) << 8
					v |= uint64(dAtA[iNdEx-6]) << 16
					v |= uint64(dAtA[iNdEx-5]) << 24
					v |= uint64(dAtA[iNdEx-4]) << 32
					v |= uint64(dAtA[iNdEx-3]) << 40
					v |= uint64(dAtA[iNdEx-2]) << 48
					v |= uint64(dAtA[iNdEx-1]) << 56
					v2 := float64(math.Float64frombits(v))
					m.Values = append(m.Values, v2)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBinary(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBinary
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IntegerPoints) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBinary
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IntegerPoints: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IntegerPoints: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 1 {
				var v int64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				iNdEx += 8
				v = int64(dAtA[iNdEx-8])
				v |= int64(dAtA[iNdEx-7]) << 8
				v |= int64(dAtA[iNdEx-6]) << 16
				v |= int64(dAtA[iNdEx-5]) << 24
				v |= int64(dAtA[iNdEx-4]) << 32
				v |= int64(dAtA[iNdEx-3]) << 40
				v |= int64(dAtA[iNdEx-2]) << 48
				v |= int64(dAtA[iNdEx-1]) << 56
				m.Timestamps = append(m.Timestamps, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBinary
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthBinary
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					iNdEx += 8
					v = int64(dAtA[iNdEx-8])
					v |= int64(dAtA[iNdEx-7]) << 8
					v |= int64(dAtA[iNdEx-6]) << 16
					v |= int64(dAtA[iNdEx-5]) << 24
					v |= int64(dAtA[iNdEx-4]) << 32
					v |= int64(dAtA[iNdEx-3]) << 40
					v |= int64(dAtA[iNdEx-2]) << 48
					v |= int64(dAtA[iNdEx-1]) << 56
					m.Timestamps = append(m.Timestamps, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamps", wireType)
			}
		case 2:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBinary
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Values = append(m.Values, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBinary
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthBinary
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowBinary
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Values = append(m.Values, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBinary(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBinary
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UnsignedPoints) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBinary
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UnsignedPoints: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UnsignedPoints: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 1 {
				var v int64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				iNdEx += 8
				v = int64(dAtA[iNdEx-8])
				v |= int64(dAtA[iNdEx-7]) << 8
				v |= int64(dAtA[iNdEx-6]) << 16
				v |= int64(dAtA[iNdEx-5]) << 24
				v |= int64(dAtA[iNdEx-4]) << 32
				v |= int64(dAtA[iNdEx-3]) << 40
				v |= int64(dAtA[iNdEx-2]) << 48
				v |= int64(dAtA[iNdEx-1]) << 56
				m.Timestamps = append(m.Timestamps, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBinary
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthBinary
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					iNdEx += 8
					v = int64(dAtA[iNdEx-8])
					v |= int64(dAtA[iNdEx-7]) << 8
					v |= int64(dAtA[iNdEx-6]) << 16
					v |= int64(dAtA[iNdEx-5]) << 24
					v |= int64(dAtA[iNdEx-4]) << 32
					v |= int64(dAtA[iNdEx-3]) << 40
					v |= int64(dAtA[iNdEx-2]) << 48
					v |= int64(dAtA[iNdEx-1]) << 56
					m.Timestamps = append(m.Timestamps, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamps", wireType)
			}
		case 2:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBinary
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Values = append(m.Values, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBinary
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthBinary
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowBinary
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Values = append(m.Values, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBinary(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBinary
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BooleanPoints) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBinary
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BooleanPoints: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BooleanPoints: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 1 {
				var v int64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				iNdEx += 8
				v = int64(dAtA[iNdEx-8])
				v |= int64(dAtA[iNdEx-7]) << 8
				v |= int64(dAtA[iNdEx-6]) << 16
				v |= int64(dAtA[iNdEx-5]) << 24
				v |= int64(dAtA[iNdEx-4]) << 32
				v |= int64(dAtA[iNdEx-3]) << 40
				v |= int64(dAtA[iNdEx-2]) << 48
				v |= int64(dAtA[iNdEx-1]) << 56
				m.Timestamps = append(m.Timestamps, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBinary
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthBinary
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					iNdEx += 8
					v = int64(dAtA[iNdEx-8])
					v |= int64(dAtA[iNdEx-7]) << 8
					v |= int64(dAtA[iNdEx-6]) << 16
					v |= int64(dAtA[iNdEx-5]) << 24
					v |= int64(dAtA[iNdEx-4]) << 32
					v |= int64(dAtA[iNdEx-3]) << 40
					v |= int64(dAtA[iNdEx-2]) << 48
					v |= int64(dAtA[iNdEx-1]) << 56
					m.Timestamps = append(m.Timestamps, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamps", wireType)
			}
		case 2:
			if wireType == 0 {
				var v int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBinary
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Values = append(m.Values, bool(v != 0))
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBinary
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthBinary
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowBinary
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Values = append(m.Values, bool(v != 0))
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBinary(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBinary
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StringPoints) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBinary
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringPoints: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringPoints: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 1 {
				var v int64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				iNdEx += 8
				v = int64(dAtA[iNdEx-8])
				v |= int64(dAtA[iNdEx-7]) << 8
				v |= int64(dAtA[iNdEx-6]) << 16
				v |= int64(dAtA[iNdEx-5]) << 24
				v |= int64(dAtA[iNdEx-4]) << 32
				v |= int64(dAtA[iNdEx-3]) << 40
				v |= int64(dAtA[iNdEx-2]) << 48
				v |= int64(dAtA[iNdEx-1]) << 56
				m.Timestamps = append(m.Timestamps, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBinary
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthBinary
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					iNdEx += 8
					v = int64(dAtA[iNdEx-8])
					v |= int64(dAtA[iNdEx-7]) << 8
					v |= int64(dAtA[iNdEx-6]) << 16
					v |= int64(dAtA[iNdEx-5]) << 24
					v |= int64(dAtA[iNdEx-4]) << 32
					v |= int64(dAtA[iNdEx-3]) << 40
					v |= int64(dAtA[iNdEx-2]) << 48
					v |= int64(dAtA[iNdEx-1]) << 56
					m.Timestamps = append(m.Timestamps, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamps", wireType)
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBinary
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBinary
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBinary(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBinary
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SeriesHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBinary
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SeriesHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SeriesHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FieldType", wireType)
			}
			m.FieldType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBinary
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FieldType |= (FieldType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeriesKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBinary
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBinary
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SeriesKey = append(m.SeriesKey[:0], dAtA[iNdEx:postIndex]...)
			if m.SeriesKey == nil {
				m.SeriesKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Field", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBinary
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBinary
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Field = append(m.Field[:0], dAtA[iNdEx:postIndex]...)
			if m.Field == nil {
				m.Field = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBinary(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBinary
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SeriesFooter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBinary
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SeriesFooter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SeriesFooter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipBinary(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBinary
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipBinary(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowBinary
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBinary
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBinary
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthBinary
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowBinary
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipBinary(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthBinary = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowBinary   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("binary.proto", fileDescriptorBinary) }

var fileDescriptorBinary = []byte{
	// 584 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x53, 0xcf, 0x4e, 0xdb, 0x4c,
	0x1c, 0xcc, 0xe2, 0x10, 0x92, 0xdf, 0x67, 0xc2, 0xe2, 0x8f, 0xa2, 0xc8, 0x55, 0x8d, 0x9b, 0x5e,
	0xd2, 0x7f, 0x01, 0xb5, 0x52, 0xef, 0x44, 0x24, 0x21, 0x2a, 0x72, 0xd0, 0x26, 0x70, 0x8d, 0x36,
	0x78, 0x31, 0x16, 0xc1, 0x1b, 0xad, 0xd7, 0x48, 0x7e, 0x83, 0x2a, 0xa7, 0x1e, 0x7b, 0xc9, 0xa9,
	0xaf, 0xd1, 0x07, 0xe0, 0xd8, 0x07, 0xa8, 0xd4, 0x96, 0xbe, 0x48, 0x95, 0x5d, 0xc7, 0xd0, 0x6b,
	0x6e, 0x3b, 0xbf, 0x99, 0x9d, 0xdd, 0xf5, 0x8c, 0xc1, 0x1c, 0x87, 0x11, 0x15, 0x69, 0x73, 0x2a,
	0xb8, 0xe4, 0x56, 0x49, 0x23, 0xfb, 0x6d, 0x10, 0xca, 0xab, 0x64, 0xdc, 0xbc, 0xe0, 0x37, 0xfb,
	0x01, 0x0f, 0xf8, 0xbe, 0xa2, 0xc7, 0xc9, 0xa5, 0x42, 0x0a, 0xa8, 0x95, 0xde, 0x56, 0xff, 0x81,
	0xa0, 0x74, 0xcc, 0xa8, 0xcf, 0x84, 0x75, 0x00, 0x1b, 0xb7, 0x4c, 0xc4, 0x21, 0x8f, 0x6a, 0xc8,
	0x45, 0x8d, 0xea, 0xbb, 0xdd, 0x66, 0x76, 0x82, 0x16, 0x34, 0xcf, 0x35, 0x4b, 0x96, 0x32, 0xcb,
	0x86, 0xb2, 0x4f, 0x25, 0x1d, 0xd3, 0x98, 0xd5, 0xd6, 0x5c, 0xd4, 0xa8, 0x90, 0x1c, 0x5b, 0x2f,
	0x01, 0x0b, 0x26, 0x59, 0x24, 0x43, 0x1e, 0x8d, 0xa6, 0x7c, 0x12, 0x5e, 0xa4, 0x35, 0x43, 0x69,
	0xb6, 0xf2, 0xf9, 0xa9, 0x1a, 0x5b, 0xaf, 0xa1, 0x1a, 0x5f, 0x51, 0xe1, 0x8f, 0xfc, 0x44, 0xd0,
	0xc5, 0xbc, 0x56, 0x74, 0x51, 0xc3, 0x68, 0x15, 0xbf, 0xfc, 0xdc, 0x43, 0x64, 0x53, 0x71, 0x47,
	0x19, 0x55, 0x7f, 0x03, 0x1b, 0xd9, 0x3d, 0xac, 0xa7, 0x50, 0x39, 0x6f, 0x93, 0x41, 0xaf, 0xef,
	0x8d, 0x0e, 0x70, 0xc1, 0x36, 0x67, 0x73, 0xb7, 0x9c, 0x71, 0x07, 0x76, 0xf1, 0xd3, 0x57, 0xa7,
	0x50, 0xff, 0x00, 0x66, 0x2b, 0xb9, 0xb8, 0x66, 0x32, 0x7b, 0xe3, 0x0e, 0xac, 0xc7, 0x92, 0x0a,
	0xa9, 0x5e, 0x88, 0x89, 0x06, 0x16, 0x06, 0x83, 0x45, 0xbe, 0x7a, 0x02, 0x26, 0x8b, 0x65, 0xbd,
	0xba, 0xdc, 0xd7, 0xe1, 0x5c, 0x32, 0x51, 0x6f, 0xc3, 0x7f, 0x9d, 0x09, 0xa7, 0xf2, 0x94, 0x87,
	0x91, 0x8c, 0x2d, 0x07, 0x40, 0x86, 0x37, 0x2c, 0x96, 0xf4, 0x66, 0x1a, 0xd7, 0x90, 0x6b, 0x34,
	0x30, 0x79, 0x34, 0xb1, 0x76, 0xa1, 0x74, 0x4b, 0x27, 0x09, 0x8b, 0x6b, 0x6b, 0xae, 0xd1, 0x40,
	0x24, 0x43, 0xf5, 0x2e, 0x6c, 0xf6, 0x22, 0xc9, 0x02, 0x26, 0x56, 0x32, 0x32, 0x72, 0xa3, 0x63,
	0xa8, 0x9e, 0x45, 0x71, 0x18, 0x44, 0xcc, 0x5f, 0xc9, 0xa9, 0xf8, 0xf8, 0x4a, 0x2d, 0xce, 0x27,
	0x8c, 0x46, 0x2b, 0x19, 0x95, 0x73, 0xa3, 0x0e, 0x98, 0x03, 0x29, 0xc2, 0x28, 0x58, 0xc9, 0xa7,
	0x92, 0xfb, 0x24, 0x60, 0x0e, 0x98, 0x08, 0x59, 0x9c, 0xd7, 0x12, 0x2e, 0x43, 0x36, 0xf1, 0x47,
	0x32, 0x9d, 0xb2, 0xac, 0x99, 0xdb, 0xcb, 0x66, 0x76, 0x16, 0xcc, 0x30, 0x9d, 0x32, 0x52, 0xb9,
	0x5c, 0x2e, 0xad, 0x67, 0x00, 0xb1, 0x72, 0x18, 0x5d, 0xb3, 0x54, 0xa5, 0x6a, 0x92, 0x8a, 0x9e,
	0x7c, 0x64, 0xe9, 0xa2, 0x03, 0x4a, 0xab, 0xea, 0x68, 0x12, 0x0d, 0x16, 0x89, 0xeb, 0x63, 0x75,
	0xe2, 0xaf, 0xbe, 0x21, 0xa8, 0x74, 0x1e, 0x59, 0xae, 0x77, 0x4e, 0xfa, 0x87, 0x43, 0x5c, 0xb0,
	0xad, 0xd9, 0xdc, 0xad, 0xaa, 0x32, 0x3c, 0xd0, 0xcf, 0x61, 0xa3, 0xe7, 0x0d, 0xdb, 0xdd, 0x36,
	0xc1, 0xc8, 0xde, 0x99, 0xcd, 0x5d, 0x9c, 0xc5, 0xfc, 0x20, 0x79, 0x01, 0xe5, 0x33, 0x6f, 0xd0,
	0xeb, 0x7a, 0xed, 0x23, 0xbc, 0x66, 0x3f, 0x99, 0xcd, 0xdd, 0xed, 0x65, 0x82, 0xff, 0xf8, 0xb4,
	0xfa, 0xfd, 0x93, 0xf6, 0xa1, 0x87, 0x0d, 0xed, 0x93, 0x65, 0xf3, 0x20, 0xd9, 0x83, 0xd2, 0x60,
	0x48, 0x7a, 0x5e, 0x17, 0x17, 0xed, 0xff, 0x67, 0x73, 0x77, 0x4b, 0x7f, 0xf4, 0x5c, 0xa0, 0x8b,
	0xdf, 0xda, 0xb9, 0xfb, 0xed, 0x14, 0xee, 0xee, 0x1d, 0xf4, 0xfd, 0xde, 0x41, 0xbf, 0xee, 0x1d,
	0xf4, 0xf9, 0x8f, 0x53, 0x18, 0x97, 0xd4, 0x4f, 0xff, 0xfe, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xd5, 0x6e, 0x9c, 0xfe, 0x3b, 0x04, 0x00, 0x00,
}
