// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package adsense provides access to the AdSense Management API.
//
// For product documentation, see: http://code.google.com/apis/adsense/management/
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/adsense/v2"
//   ...
//   ctx := context.Background()
//   adsenseService, err := adsense.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate. To restrict scopes, use option.WithScopes:
//
//   adsenseService, err := adsense.NewService(ctx, option.WithScopes(adsense.AdsenseReadonlyScope))
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   adsenseService, err := adsense.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   adsenseService, err := adsense.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package adsense // import "google.golang.org/api/adsense/v2"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "adsense:v2"
const apiName = "adsense"
const apiVersion = "v2"
const basePath = "https://adsense.googleapis.com/"
const mtlsBasePath = "https://adsense.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// View and manage your AdSense data
	AdsenseScope = "https://www.googleapis.com/auth/adsense"

	// View your AdSense data
	AdsenseReadonlyScope = "https://www.googleapis.com/auth/adsense.readonly"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/adsense",
		"https://www.googleapis.com/auth/adsense.readonly",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Accounts = NewAccountsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Accounts *AccountsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAccountsService(s *Service) *AccountsService {
	rs := &AccountsService{s: s}
	rs.Adclients = NewAccountsAdclientsService(s)
	rs.Alerts = NewAccountsAlertsService(s)
	rs.Payments = NewAccountsPaymentsService(s)
	rs.Reports = NewAccountsReportsService(s)
	rs.Sites = NewAccountsSitesService(s)
	return rs
}

type AccountsService struct {
	s *Service

	Adclients *AccountsAdclientsService

	Alerts *AccountsAlertsService

	Payments *AccountsPaymentsService

	Reports *AccountsReportsService

	Sites *AccountsSitesService
}

func NewAccountsAdclientsService(s *Service) *AccountsAdclientsService {
	rs := &AccountsAdclientsService{s: s}
	rs.Adunits = NewAccountsAdclientsAdunitsService(s)
	rs.Customchannels = NewAccountsAdclientsCustomchannelsService(s)
	rs.Urlchannels = NewAccountsAdclientsUrlchannelsService(s)
	return rs
}

type AccountsAdclientsService struct {
	s *Service

	Adunits *AccountsAdclientsAdunitsService

	Customchannels *AccountsAdclientsCustomchannelsService

	Urlchannels *AccountsAdclientsUrlchannelsService
}

func NewAccountsAdclientsAdunitsService(s *Service) *AccountsAdclientsAdunitsService {
	rs := &AccountsAdclientsAdunitsService{s: s}
	return rs
}

type AccountsAdclientsAdunitsService struct {
	s *Service
}

func NewAccountsAdclientsCustomchannelsService(s *Service) *AccountsAdclientsCustomchannelsService {
	rs := &AccountsAdclientsCustomchannelsService{s: s}
	return rs
}

type AccountsAdclientsCustomchannelsService struct {
	s *Service
}

func NewAccountsAdclientsUrlchannelsService(s *Service) *AccountsAdclientsUrlchannelsService {
	rs := &AccountsAdclientsUrlchannelsService{s: s}
	return rs
}

type AccountsAdclientsUrlchannelsService struct {
	s *Service
}

func NewAccountsAlertsService(s *Service) *AccountsAlertsService {
	rs := &AccountsAlertsService{s: s}
	return rs
}

type AccountsAlertsService struct {
	s *Service
}

func NewAccountsPaymentsService(s *Service) *AccountsPaymentsService {
	rs := &AccountsPaymentsService{s: s}
	return rs
}

type AccountsPaymentsService struct {
	s *Service
}

func NewAccountsReportsService(s *Service) *AccountsReportsService {
	rs := &AccountsReportsService{s: s}
	rs.Saved = NewAccountsReportsSavedService(s)
	return rs
}

type AccountsReportsService struct {
	s *Service

	Saved *AccountsReportsSavedService
}

func NewAccountsReportsSavedService(s *Service) *AccountsReportsSavedService {
	rs := &AccountsReportsSavedService{s: s}
	return rs
}

type AccountsReportsSavedService struct {
	s *Service
}

func NewAccountsSitesService(s *Service) *AccountsSitesService {
	rs := &AccountsSitesService{s: s}
	return rs
}

type AccountsSitesService struct {
	s *Service
}

// Account: Representation of an account.
type Account struct {
	// CreateTime: Output only. Creation time of the account.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: Output only. Display name of this account.
	DisplayName string `json:"displayName,omitempty"`

	// Name: Resource name of the account. Format: accounts/pub-[0-9]+
	Name string `json:"name,omitempty"`

	// PendingTasks: Output only. Outstanding tasks that need to be
	// completed as part of the sign-up process for a new account. e.g.
	// "billing-profile-creation", "phone-pin-verification".
	PendingTasks []string `json:"pendingTasks,omitempty"`

	// Premium: Output only. Whether this account is premium.
	Premium bool `json:"premium,omitempty"`

	// TimeZone: The account time zone, as used by reporting. For more
	// information, see changing the time zone of your reports
	// (https://support.google.com/adsense/answer/9830725).
	TimeZone *TimeZone `json:"timeZone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Account) MarshalJSON() ([]byte, error) {
	type NoMethod Account
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AdClient: Representation of an ad client. An ad client represents a
// user's subscription with a specific AdSense product.
type AdClient struct {
	// Name: Resource name of the ad client. Format:
	// accounts/{account}/adclient/{adclient}
	Name string `json:"name,omitempty"`

	// ProductCode: Output only. Product code of the ad client. For example,
	// "AFC" for AdSense for Content.
	ProductCode string `json:"productCode,omitempty"`

	// ReportingDimensionId: Output only. Unique ID of the ad client as used
	// in the `AD_CLIENT_ID` reporting dimension. Present only if the ad
	// client supports reporting.
	ReportingDimensionId string `json:"reportingDimensionId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AdClient) MarshalJSON() ([]byte, error) {
	type NoMethod AdClient
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AdClientAdCode: Representation of the AdSense code for a given ad
// client. For more information, see About the AdSense code
// (https://support.google.com/adsense/answer/9274634).
type AdClientAdCode struct {
	// AdCode: Output only. The AdSense code snippet to add to the head of
	// an HTML page.
	AdCode string `json:"adCode,omitempty"`

	// AmpBody: Output only. The AdSense code snippet to add to the body of
	// an AMP page.
	AmpBody string `json:"ampBody,omitempty"`

	// AmpHead: Output only. The AdSense code snippet to add to the head of
	// an AMP page.
	AmpHead string `json:"ampHead,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AdCode") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdCode") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AdClientAdCode) MarshalJSON() ([]byte, error) {
	type NoMethod AdClientAdCode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AdUnit: Representation of an ad unit. An ad unit represents a saved
// ad unit with a specific set of ad settings that have been customized
// within an account.
type AdUnit struct {
	// ContentAdsSettings: Settings specific to content ads (AFC).
	ContentAdsSettings *ContentAdsSettings `json:"contentAdsSettings,omitempty"`

	// DisplayName: Display name of the ad unit, as provided when the ad
	// unit was created.
	DisplayName string `json:"displayName,omitempty"`

	// Name: Resource name of the ad unit. Format:
	// accounts/{account}/adclient/{adclient}/adunits/{adunit}
	Name string `json:"name,omitempty"`

	// ReportingDimensionId: Output only. Unique ID of the ad unit as used
	// in the `AD_UNIT_ID` reporting dimension.
	ReportingDimensionId string `json:"reportingDimensionId,omitempty"`

	// State: State of the ad unit.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State unspecified.
	//   "ACTIVE" - Ad unit has been activated by the user and can serve
	// ads.
	//   "ARCHIVED" - Ad unit has been archived by the user and can no
	// longer serve ads.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ContentAdsSettings")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentAdsSettings") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AdUnit) MarshalJSON() ([]byte, error) {
	type NoMethod AdUnit
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AdUnitAdCode: Representation of the AdSense code for a given ad unit.
type AdUnitAdCode struct {
	// AdCode: Output only. The AdSense code snippet to add to the body of
	// an HTML page.
	AdCode string `json:"adCode,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AdCode") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdCode") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AdUnitAdCode) MarshalJSON() ([]byte, error) {
	type NoMethod AdUnitAdCode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Alert: Representation of an alert.
type Alert struct {
	// Message: Output only. The localized alert message. This may contain
	// HTML markup, such as phrase elements or links.
	Message string `json:"message,omitempty"`

	// Name: Resource name of the alert. Format:
	// accounts/{account}/alerts/{alert}
	Name string `json:"name,omitempty"`

	// Severity: Output only. Severity of this alert.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Unspecified severity.
	//   "INFO" - Info.
	//   "WARNING" - Warning.
	//   "SEVERE" - Severe.
	Severity string `json:"severity,omitempty"`

	// Type: Output only. Type of alert. This identifies the broad type of
	// this alert, and provides a stable machine-readable identifier that
	// will not be translated. For example, "payment-hold".
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Message") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Message") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Alert) MarshalJSON() ([]byte, error) {
	type NoMethod Alert
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Cell: Cell representation.
type Cell struct {
	// Value: Value in the cell. The dimension cells contain strings, and
	// the metric cells contain numbers.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Value") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Cell) MarshalJSON() ([]byte, error) {
	type NoMethod Cell
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ContentAdsSettings: Settings specific to content ads (AFC).
type ContentAdsSettings struct {
	// Size: Size of the ad unit. e.g. "728x90", "1x3" (for responsive ad
	// units).
	Size string `json:"size,omitempty"`

	// Type: Type of the ad unit.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified ad unit type.
	//   "DISPLAY" - Display ad unit.
	//   "FEED" - In-feed ad unit.
	//   "ARTICLE" - In-article ad unit.
	//   "MATCHED_CONTENT" - Matched content unit.
	//   "LINK" - Link ad unit. Note that link ad units are being retired,
	// see https://support.google.com/adsense/answer/9987221.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Size") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Size") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ContentAdsSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ContentAdsSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CustomChannel: Representation of a custom channel.
type CustomChannel struct {
	// DisplayName: Display name of the custom channel.
	DisplayName string `json:"displayName,omitempty"`

	// Name: Resource name of the custom channel. Format:
	// accounts/{account}/adclients/{adclient}/customchannels/{customchannel}
	Name string `json:"name,omitempty"`

	// ReportingDimensionId: Output only. Unique ID of the custom channel as
	// used in the `CUSTOM_CHANNEL_ID` reporting dimension.
	ReportingDimensionId string `json:"reportingDimensionId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomChannel) MarshalJSON() ([]byte, error) {
	type NoMethod CustomChannel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Date: Represents a whole or partial calendar date, such as a
// birthday. The time of day and time zone are either specified
// elsewhere or are insignificant. The date is relative to the Gregorian
// Calendar. This can represent one of the following: * A full date,
// with non-zero year, month, and day values * A month and day value,
// with a zero year, such as an anniversary * A year on its own, with
// zero month and day values * A year and month value, with a zero day,
// such as a credit card expiration date Related types are
// google.type.TimeOfDay and `google.protobuf.Timestamp`.
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and
	// month, or 0 to specify a year by itself or a year and month where the
	// day isn't significant.
	Day int64 `json:"day,omitempty"`

	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year
	// without a month and day.
	Month int64 `json:"month,omitempty"`

	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a
	// date without a year.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Header: The header information of the columns requested in the
// report.
type Header struct {
	// CurrencyCode: The ISO-4217 currency code
	// (https://en.wikipedia.org/wiki/ISO_4217) of this column. Only present
	// if the header type is METRIC_CURRENCY.
	CurrencyCode string `json:"currencyCode,omitempty"`

	// Name: Required. Name of the header.
	Name string `json:"name,omitempty"`

	// Type: Required. Type of the header.
	//
	// Possible values:
	//   "HEADER_TYPE_UNSPECIFIED" - Unspecified header.
	//   "DIMENSION" - Dimension header type.
	//   "METRIC_TALLY" - Tally header type.
	//   "METRIC_RATIO" - Ratio header type.
	//   "METRIC_CURRENCY" - Currency header type.
	//   "METRIC_MILLISECONDS" - Milliseconds header type.
	//   "METRIC_DECIMAL" - Decimal header type.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CurrencyCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Header) MarshalJSON() ([]byte, error) {
	type NoMethod Header
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpBody: Message that represents an arbitrary HTTP body. It should
// only be used for payload formats that can't be represented as JSON,
// such as raw binary or an HTML page. This message can be used both in
// streaming and non-streaming API methods in the request as well as the
// response. It can be used as a top-level request field, which is
// convenient if one wants to extract parameters from either the URL or
// HTTP template into the request fields and also want access to the raw
// HTTP body. Example: message GetResourceRequest { // A unique request
// id. string request_id = 1; // The raw HTTP body is bound to this
// field. google.api.HttpBody http_body = 2; } service ResourceService {
// rpc GetResource(GetResourceRequest) returns (google.api.HttpBody);
// rpc UpdateResource(google.api.HttpBody) returns
// (google.protobuf.Empty); } Example with streaming methods: service
// CaldavService { rpc GetCalendar(stream google.api.HttpBody) returns
// (stream google.api.HttpBody); rpc UpdateCalendar(stream
// google.api.HttpBody) returns (stream google.api.HttpBody); } Use of
// this type only changes how the request and response bodies are
// handled, all other features will continue to work unchanged.
type HttpBody struct {
	// ContentType: The HTTP Content-Type header value specifying the
	// content type of the body.
	ContentType string `json:"contentType,omitempty"`

	// Data: The HTTP request/response body as raw binary.
	Data string `json:"data,omitempty"`

	// Extensions: Application specific response metadata. Must be set in
	// the first response for streaming APIs.
	Extensions []googleapi.RawMessage `json:"extensions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpBody) MarshalJSON() ([]byte, error) {
	type NoMethod HttpBody
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListAccountsResponse: Response definition for the account list rpc.
type ListAccountsResponse struct {
	// Accounts: The accounts returned in this list response.
	Accounts []*Account `json:"accounts,omitempty"`

	// NextPageToken: Continuation token used to page through accounts. To
	// retrieve the next page of the results, set the next request's
	// "page_token" value to this.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Accounts") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Accounts") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListAccountsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAccountsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListAdClientsResponse: Response definition for the ad client list
// rpc.
type ListAdClientsResponse struct {
	// AdClients: The ad clients returned in this list response.
	AdClients []*AdClient `json:"adClients,omitempty"`

	// NextPageToken: Continuation token used to page through ad clients. To
	// retrieve the next page of the results, set the next request's
	// "page_token" value to this.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AdClients") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdClients") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListAdClientsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAdClientsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListAdUnitsResponse: Response definition for the adunit list rpc.
type ListAdUnitsResponse struct {
	// AdUnits: The ad units returned in the list response.
	AdUnits []*AdUnit `json:"adUnits,omitempty"`

	// NextPageToken: Continuation token used to page through ad units. To
	// retrieve the next page of the results, set the next request's
	// "page_token" value to this.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AdUnits") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdUnits") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListAdUnitsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAdUnitsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListAlertsResponse: Response definition for the alerts list rpc.
type ListAlertsResponse struct {
	// Alerts: The alerts returned in this list response.
	Alerts []*Alert `json:"alerts,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Alerts") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alerts") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListAlertsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAlertsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListChildAccountsResponse: Response definition for the child account
// list rpc.
type ListChildAccountsResponse struct {
	// Accounts: The accounts returned in this list response.
	Accounts []*Account `json:"accounts,omitempty"`

	// NextPageToken: Continuation token used to page through accounts. To
	// retrieve the next page of the results, set the next request's
	// "page_token" value to this.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Accounts") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Accounts") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListChildAccountsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListChildAccountsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListCustomChannelsResponse: Response definition for the custom
// channel list rpc.
type ListCustomChannelsResponse struct {
	// CustomChannels: The custom channels returned in this list response.
	CustomChannels []*CustomChannel `json:"customChannels,omitempty"`

	// NextPageToken: Continuation token used to page through alerts. To
	// retrieve the next page of the results, set the next request's
	// "page_token" value to this.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CustomChannels") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomChannels") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListCustomChannelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCustomChannelsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListLinkedAdUnitsResponse: Response definition for the ad units
// linked to a custom channel list rpc.
type ListLinkedAdUnitsResponse struct {
	// AdUnits: The ad units returned in the list response.
	AdUnits []*AdUnit `json:"adUnits,omitempty"`

	// NextPageToken: Continuation token used to page through ad units. To
	// retrieve the next page of the results, set the next request's
	// "page_token" value to this.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AdUnits") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdUnits") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListLinkedAdUnitsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLinkedAdUnitsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListLinkedCustomChannelsResponse: Response definition for the custom
// channels linked to an adunit list rpc.
type ListLinkedCustomChannelsResponse struct {
	// CustomChannels: The custom channels returned in this list response.
	CustomChannels []*CustomChannel `json:"customChannels,omitempty"`

	// NextPageToken: Continuation token used to page through alerts. To
	// retrieve the next page of the results, set the next request's
	// "page_token" value to this.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CustomChannels") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomChannels") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListLinkedCustomChannelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLinkedCustomChannelsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListPaymentsResponse: Response definition for the payments list rpc.
type ListPaymentsResponse struct {
	// Payments: The payments returned in this list response.
	Payments []*Payment `json:"payments,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Payments") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Payments") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListPaymentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPaymentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListSavedReportsResponse: Response definition for the saved reports
// list rpc.
type ListSavedReportsResponse struct {
	// NextPageToken: Continuation token used to page through reports. To
	// retrieve the next page of the results, set the next request's
	// "page_token" value to this.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SavedReports: The reports returned in this list response.
	SavedReports []*SavedReport `json:"savedReports,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListSavedReportsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSavedReportsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListSitesResponse: Response definition for the sites list rpc.
type ListSitesResponse struct {
	// NextPageToken: Continuation token used to page through sites. To
	// retrieve the next page of the results, set the next request's
	// "page_token" value to this.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Sites: The sites returned in this list response.
	Sites []*Site `json:"sites,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListSitesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSitesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListUrlChannelsResponse: Response definition for the url channels
// list rpc.
type ListUrlChannelsResponse struct {
	// NextPageToken: Continuation token used to page through url channels.
	// To retrieve the next page of the results, set the next request's
	// "page_token" value to this.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// UrlChannels: The url channels returned in this list response.
	UrlChannels []*UrlChannel `json:"urlChannels,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListUrlChannelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListUrlChannelsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Payment: Representation of an unpaid or paid payment. See Payment
// timelines for AdSense
// (https://support.google.com/adsense/answer/7164703) for more
// information about payments.
type Payment struct {
	// Amount: Output only. The amount of unpaid or paid earnings, as a
	// formatted string, including the currency. E.g. "¥1,235 JPY",
	// "$1,234.57", "£87.65".
	Amount string `json:"amount,omitempty"`

	// Date: Output only. For paid earnings, the date that the payment was
	// credited. For unpaid earnings, this field is empty. Payment dates are
	// always returned in the billing timezone (America/Los_Angeles).
	Date *Date `json:"date,omitempty"`

	// Name: Resource name of the payment. Format:
	// accounts/{account}/payments/unpaid for unpaid (current) earnings.
	// accounts/{account}/payments/yyyy-MM-dd for paid earnings.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Amount") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Amount") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Payment) MarshalJSON() ([]byte, error) {
	type NoMethod Payment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReportResult: Result of a generated report.
type ReportResult struct {
	// Averages: The averages of the report. This is the same length as any
	// other row in the report; cells corresponding to dimension columns are
	// empty.
	Averages *Row `json:"averages,omitempty"`

	// EndDate: Required. End date of the range (inclusive).
	EndDate *Date `json:"endDate,omitempty"`

	// Headers: The header information; one for each dimension in the
	// request, followed by one for each metric in the request.
	Headers []*Header `json:"headers,omitempty"`

	// Rows: The output rows of the report. Each row is a list of cells; one
	// for each dimension in the request, followed by one for each metric in
	// the request.
	Rows []*Row `json:"rows,omitempty"`

	// StartDate: Required. Start date of the range (inclusive).
	StartDate *Date `json:"startDate,omitempty"`

	// TotalMatchedRows: The total number of rows matched by the report
	// request.
	TotalMatchedRows int64 `json:"totalMatchedRows,omitempty,string"`

	// Totals: The totals of the report. This is the same length as any
	// other row in the report; cells corresponding to dimension columns are
	// empty.
	Totals *Row `json:"totals,omitempty"`

	// Warnings: Any warnings associated with generation of the report.
	// These warnings are always returned in English.
	Warnings []string `json:"warnings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Averages") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Averages") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReportResult) MarshalJSON() ([]byte, error) {
	type NoMethod ReportResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Row: Row representation.
type Row struct {
	// Cells: Cells in the row.
	Cells []*Cell `json:"cells,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cells") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Row) MarshalJSON() ([]byte, error) {
	type NoMethod Row
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SavedReport: Representation of a saved report.
type SavedReport struct {
	// Name: Resource name of the report. Format:
	// accounts/{account}/reports/{report}
	Name string `json:"name,omitempty"`

	// Title: Report title as specified by publisher.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SavedReport) MarshalJSON() ([]byte, error) {
	type NoMethod SavedReport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Site: Representation of a Site.
type Site struct {
	// AutoAdsEnabled: Whether auto ads is turned on for the site.
	AutoAdsEnabled bool `json:"autoAdsEnabled,omitempty"`

	// Domain: Domain (or subdomain) of the site, e.g. "example.com" or
	// "www.example.com". This is used in the `OWNED_SITE_DOMAIN_NAME`
	// reporting dimension.
	Domain string `json:"domain,omitempty"`

	// Name: Resource name of a site. Format:
	// accounts/{account}/sites/{site}
	Name string `json:"name,omitempty"`

	// ReportingDimensionId: Output only. Unique ID of the site as used in
	// the `OWNED_SITE_ID` reporting dimension.
	ReportingDimensionId string `json:"reportingDimensionId,omitempty"`

	// State: Output only. State of a site.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State unspecified.
	//   "REQUIRES_REVIEW" - The site hasn't been checked yet.
	//   "GETTING_READY" - Running some checks on the site. This usually
	// takes a few days, but in some cases can take up to 2 weeks.
	//   "READY" - The site is ready to show ads.
	//   "NEEDS_ATTENTION" - Publisher needs to fix some issues before the
	// site is ready to show ads.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AutoAdsEnabled") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoAdsEnabled") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Site) MarshalJSON() ([]byte, error) {
	type NoMethod Site
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TimeZone: Represents a time zone from the IANA Time Zone Database
// (https://www.iana.org/time-zones).
type TimeZone struct {
	// Id: IANA Time Zone Database time zone, e.g. "America/New_York".
	Id string `json:"id,omitempty"`

	// Version: Optional. IANA Time Zone Database version number, e.g.
	// "2019a".
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TimeZone) MarshalJSON() ([]byte, error) {
	type NoMethod TimeZone
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UrlChannel: Representation of a URL channel. URL channels allow you
// to track the performance of particular pages in your site; see URL
// channels (https://support.google.com/adsense/answer/2923836) for more
// information.
type UrlChannel struct {
	// Name: Resource name of the URL channel. Format:
	// accounts/{account}/adclient/{adclient}/urlchannels/{urlchannel}
	Name string `json:"name,omitempty"`

	// ReportingDimensionId: Output only. Unique ID of the custom channel as
	// used in the `URL_CHANNEL_ID` reporting dimension.
	ReportingDimensionId string `json:"reportingDimensionId,omitempty"`

	// UriPattern: URI pattern of the channel. Does not include "http://" or
	// "https://". Example: www.example.com/home
	UriPattern string `json:"uriPattern,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UrlChannel) MarshalJSON() ([]byte, error) {
	type NoMethod UrlChannel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "adsense.accounts.get":

type AccountsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about the selected AdSense account.
//
// - name: Account to get information about. Format:
//   accounts/{account_id}.
func (r *AccountsService) Get(name string) *AccountsGetCall {
	c := &AccountsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsGetCall) Fields(s ...googleapi.Field) *AccountsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsGetCall) IfNoneMatch(entityTag string) *AccountsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsGetCall) Context(ctx context.Context) *AccountsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.get" call.
// Exactly one of *Account or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Account.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *AccountsGetCall) Do(opts ...googleapi.CallOption) (*Account, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Account{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about the selected AdSense account.",
	//   "flatPath": "v2/accounts/{accountsId}",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Account to get information about. Format: accounts/{account_id}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}",
	//   "response": {
	//     "$ref": "Account"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// method id "adsense.accounts.list":

type AccountsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all accounts available to this user.
func (r *AccountsService) List() *AccountsListCall {
	c := &AccountsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of accounts to include in the response, used for paging. If
// unspecified, at most 10000 accounts will be returned. The maximum
// value is 10000; values above 10000 will be coerced to 10000.
func (c *AccountsListCall) PageSize(pageSize int64) *AccountsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListAccounts` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListAccounts` must match the call that provided the page
// token.
func (c *AccountsListCall) PageToken(pageToken string) *AccountsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsListCall) Fields(s ...googleapi.Field) *AccountsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsListCall) IfNoneMatch(entityTag string) *AccountsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsListCall) Context(ctx context.Context) *AccountsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/accounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.list" call.
// Exactly one of *ListAccountsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListAccountsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsListCall) Do(opts ...googleapi.CallOption) (*ListAccountsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListAccountsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all accounts available to this user.",
	//   "flatPath": "v2/accounts",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.list",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of accounts to include in the response, used for paging. If unspecified, at most 10000 accounts will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListAccounts` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListAccounts` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/accounts",
	//   "response": {
	//     "$ref": "ListAccountsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsListCall) Pages(ctx context.Context, f func(*ListAccountsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "adsense.accounts.listChildAccounts":

type AccountsListChildAccountsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListChildAccounts: Lists all accounts directly managed by the given
// AdSense account.
//
// - parent: The parent account, which owns the child accounts. Format:
//   accounts/{account}.
func (r *AccountsService) ListChildAccounts(parent string) *AccountsListChildAccountsCall {
	c := &AccountsListChildAccountsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of accounts to include in the response, used for paging. If
// unspecified, at most 10000 accounts will be returned. The maximum
// value is 10000; values above 10000 will be coerced to 10000.
func (c *AccountsListChildAccountsCall) PageSize(pageSize int64) *AccountsListChildAccountsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListAccounts` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListAccounts` must match the call that provided the page
// token.
func (c *AccountsListChildAccountsCall) PageToken(pageToken string) *AccountsListChildAccountsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsListChildAccountsCall) Fields(s ...googleapi.Field) *AccountsListChildAccountsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsListChildAccountsCall) IfNoneMatch(entityTag string) *AccountsListChildAccountsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsListChildAccountsCall) Context(ctx context.Context) *AccountsListChildAccountsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsListChildAccountsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsListChildAccountsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}:listChildAccounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.listChildAccounts" call.
// Exactly one of *ListChildAccountsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListChildAccountsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsListChildAccountsCall) Do(opts ...googleapi.CallOption) (*ListChildAccountsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListChildAccountsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all accounts directly managed by the given AdSense account.",
	//   "flatPath": "v2/accounts/{accountsId}:listChildAccounts",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.listChildAccounts",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of accounts to include in the response, used for paging. If unspecified, at most 10000 accounts will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListAccounts` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListAccounts` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent account, which owns the child accounts. Format: accounts/{account}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}:listChildAccounts",
	//   "response": {
	//     "$ref": "ListChildAccountsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsListChildAccountsCall) Pages(ctx context.Context, f func(*ListChildAccountsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "adsense.accounts.adclients.getAdcode":

type AccountsAdclientsGetAdcodeCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetAdcode: Gets the AdSense code for a given ad client. This returns
// what was previously known as the 'auto ad code'. This is only
// supported for ad clients with a product_code of AFC. For more
// information, see About the AdSense code
// (https://support.google.com/adsense/answer/9274634).
//
// - name: Name of the ad client for which to get the adcode. Format:
//   accounts/{account}/adclients/{adclient}.
func (r *AccountsAdclientsService) GetAdcode(name string) *AccountsAdclientsGetAdcodeCall {
	c := &AccountsAdclientsGetAdcodeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAdclientsGetAdcodeCall) Fields(s ...googleapi.Field) *AccountsAdclientsGetAdcodeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsAdclientsGetAdcodeCall) IfNoneMatch(entityTag string) *AccountsAdclientsGetAdcodeCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAdclientsGetAdcodeCall) Context(ctx context.Context) *AccountsAdclientsGetAdcodeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAdclientsGetAdcodeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAdclientsGetAdcodeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/adcode")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.adclients.getAdcode" call.
// Exactly one of *AdClientAdCode or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *AdClientAdCode.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsAdclientsGetAdcodeCall) Do(opts ...googleapi.CallOption) (*AdClientAdCode, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AdClientAdCode{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the AdSense code for a given ad client. This returns what was previously known as the 'auto ad code'. This is only supported for ad clients with a product_code of AFC. For more information, see [About the AdSense code](https://support.google.com/adsense/answer/9274634).",
	//   "flatPath": "v2/accounts/{accountsId}/adclients/{adclientsId}/adcode",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.adclients.getAdcode",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the ad client for which to get the adcode. Format: accounts/{account}/adclients/{adclient}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/adclients/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}/adcode",
	//   "response": {
	//     "$ref": "AdClientAdCode"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// method id "adsense.accounts.adclients.list":

type AccountsAdclientsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the ad clients available in an account.
//
// - parent: The account which owns the collection of ad clients.
//   Format: accounts/{account}.
func (r *AccountsAdclientsService) List(parent string) *AccountsAdclientsListCall {
	c := &AccountsAdclientsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of ad clients to include in the response, used for paging. If
// unspecified, at most 10000 ad clients will be returned. The maximum
// value is 10000; values above 10000 will be coerced to 10000.
func (c *AccountsAdclientsListCall) PageSize(pageSize int64) *AccountsAdclientsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListAdClients` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListAdClients` must match the call that provided the
// page token.
func (c *AccountsAdclientsListCall) PageToken(pageToken string) *AccountsAdclientsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAdclientsListCall) Fields(s ...googleapi.Field) *AccountsAdclientsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsAdclientsListCall) IfNoneMatch(entityTag string) *AccountsAdclientsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAdclientsListCall) Context(ctx context.Context) *AccountsAdclientsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAdclientsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAdclientsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/adclients")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.adclients.list" call.
// Exactly one of *ListAdClientsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListAdClientsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsAdclientsListCall) Do(opts ...googleapi.CallOption) (*ListAdClientsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListAdClientsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all the ad clients available in an account.",
	//   "flatPath": "v2/accounts/{accountsId}/adclients",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.adclients.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of ad clients to include in the response, used for paging. If unspecified, at most 10000 ad clients will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListAdClients` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListAdClients` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The account which owns the collection of ad clients. Format: accounts/{account}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/adclients",
	//   "response": {
	//     "$ref": "ListAdClientsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsAdclientsListCall) Pages(ctx context.Context, f func(*ListAdClientsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "adsense.accounts.adclients.adunits.get":

type AccountsAdclientsAdunitsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an ad unit from a specified account and ad client.
//
// - name: AdUnit to get information about. Format:
//   accounts/{account_id}/adclient/{adclient_id}/adunit/{adunit_id}.
func (r *AccountsAdclientsAdunitsService) Get(name string) *AccountsAdclientsAdunitsGetCall {
	c := &AccountsAdclientsAdunitsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAdclientsAdunitsGetCall) Fields(s ...googleapi.Field) *AccountsAdclientsAdunitsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsAdclientsAdunitsGetCall) IfNoneMatch(entityTag string) *AccountsAdclientsAdunitsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAdclientsAdunitsGetCall) Context(ctx context.Context) *AccountsAdclientsAdunitsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAdclientsAdunitsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAdclientsAdunitsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.adclients.adunits.get" call.
// Exactly one of *AdUnit or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *AdUnit.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *AccountsAdclientsAdunitsGetCall) Do(opts ...googleapi.CallOption) (*AdUnit, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AdUnit{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets an ad unit from a specified account and ad client.",
	//   "flatPath": "v2/accounts/{accountsId}/adclients/{adclientsId}/adunits/{adunitsId}",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.adclients.adunits.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. AdUnit to get information about. Format: accounts/{account_id}/adclient/{adclient_id}/adunit/{adunit_id}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/adclients/[^/]+/adunits/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}",
	//   "response": {
	//     "$ref": "AdUnit"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// method id "adsense.accounts.adclients.adunits.getAdcode":

type AccountsAdclientsAdunitsGetAdcodeCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetAdcode: Gets the AdSense code for a given ad unit.
//
// - name: Name of the adunit for which to get the adcode. Format:
//   accounts/{account}/adclients/{adclient}/adunits/{adunit}.
func (r *AccountsAdclientsAdunitsService) GetAdcode(name string) *AccountsAdclientsAdunitsGetAdcodeCall {
	c := &AccountsAdclientsAdunitsGetAdcodeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAdclientsAdunitsGetAdcodeCall) Fields(s ...googleapi.Field) *AccountsAdclientsAdunitsGetAdcodeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsAdclientsAdunitsGetAdcodeCall) IfNoneMatch(entityTag string) *AccountsAdclientsAdunitsGetAdcodeCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAdclientsAdunitsGetAdcodeCall) Context(ctx context.Context) *AccountsAdclientsAdunitsGetAdcodeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAdclientsAdunitsGetAdcodeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAdclientsAdunitsGetAdcodeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/adcode")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.adclients.adunits.getAdcode" call.
// Exactly one of *AdUnitAdCode or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *AdUnitAdCode.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsAdclientsAdunitsGetAdcodeCall) Do(opts ...googleapi.CallOption) (*AdUnitAdCode, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AdUnitAdCode{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the AdSense code for a given ad unit.",
	//   "flatPath": "v2/accounts/{accountsId}/adclients/{adclientsId}/adunits/{adunitsId}/adcode",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.adclients.adunits.getAdcode",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the adunit for which to get the adcode. Format: accounts/{account}/adclients/{adclient}/adunits/{adunit}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/adclients/[^/]+/adunits/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}/adcode",
	//   "response": {
	//     "$ref": "AdUnitAdCode"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// method id "adsense.accounts.adclients.adunits.list":

type AccountsAdclientsAdunitsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all ad units under a specified account and ad client.
//
// - parent: The ad client which owns the collection of ad units.
//   Format: accounts/{account}/adclients/{adclient}.
func (r *AccountsAdclientsAdunitsService) List(parent string) *AccountsAdclientsAdunitsListCall {
	c := &AccountsAdclientsAdunitsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of ad units to include in the response, used for paging. If
// unspecified, at most 10000 ad units will be returned. The maximum
// value is 10000; values above 10000 will be coerced to 10000.
func (c *AccountsAdclientsAdunitsListCall) PageSize(pageSize int64) *AccountsAdclientsAdunitsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListAdUnits` call. Provide this to retrieve
// the subsequent page. When paginating, all other parameters provided
// to `ListAdUnits` must match the call that provided the page token.
func (c *AccountsAdclientsAdunitsListCall) PageToken(pageToken string) *AccountsAdclientsAdunitsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAdclientsAdunitsListCall) Fields(s ...googleapi.Field) *AccountsAdclientsAdunitsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsAdclientsAdunitsListCall) IfNoneMatch(entityTag string) *AccountsAdclientsAdunitsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAdclientsAdunitsListCall) Context(ctx context.Context) *AccountsAdclientsAdunitsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAdclientsAdunitsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAdclientsAdunitsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/adunits")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.adclients.adunits.list" call.
// Exactly one of *ListAdUnitsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListAdUnitsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsAdclientsAdunitsListCall) Do(opts ...googleapi.CallOption) (*ListAdUnitsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListAdUnitsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all ad units under a specified account and ad client.",
	//   "flatPath": "v2/accounts/{accountsId}/adclients/{adclientsId}/adunits",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.adclients.adunits.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of ad units to include in the response, used for paging. If unspecified, at most 10000 ad units will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListAdUnits` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListAdUnits` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The ad client which owns the collection of ad units. Format: accounts/{account}/adclients/{adclient}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/adclients/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/adunits",
	//   "response": {
	//     "$ref": "ListAdUnitsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsAdclientsAdunitsListCall) Pages(ctx context.Context, f func(*ListAdUnitsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "adsense.accounts.adclients.adunits.listLinkedCustomChannels":

type AccountsAdclientsAdunitsListLinkedCustomChannelsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListLinkedCustomChannels: Lists all the custom channels available for
// an ad unit.
//
// - parent: The ad unit which owns the collection of custom channels.
//   Format: accounts/{account}/adclients/{adclient}/adunits/{adunit}.
func (r *AccountsAdclientsAdunitsService) ListLinkedCustomChannels(parent string) *AccountsAdclientsAdunitsListLinkedCustomChannelsCall {
	c := &AccountsAdclientsAdunitsListLinkedCustomChannelsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of custom channels to include in the response, used for paging. If
// unspecified, at most 10000 custom channels will be returned. The
// maximum value is 10000; values above 10000 will be coerced to 10000.
func (c *AccountsAdclientsAdunitsListLinkedCustomChannelsCall) PageSize(pageSize int64) *AccountsAdclientsAdunitsListLinkedCustomChannelsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListLinkedCustomChannels` call. Provide
// this to retrieve the subsequent page. When paginating, all other
// parameters provided to `ListLinkedCustomChannels` must match the call
// that provided the page token.
func (c *AccountsAdclientsAdunitsListLinkedCustomChannelsCall) PageToken(pageToken string) *AccountsAdclientsAdunitsListLinkedCustomChannelsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAdclientsAdunitsListLinkedCustomChannelsCall) Fields(s ...googleapi.Field) *AccountsAdclientsAdunitsListLinkedCustomChannelsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsAdclientsAdunitsListLinkedCustomChannelsCall) IfNoneMatch(entityTag string) *AccountsAdclientsAdunitsListLinkedCustomChannelsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAdclientsAdunitsListLinkedCustomChannelsCall) Context(ctx context.Context) *AccountsAdclientsAdunitsListLinkedCustomChannelsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAdclientsAdunitsListLinkedCustomChannelsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAdclientsAdunitsListLinkedCustomChannelsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}:listLinkedCustomChannels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.adclients.adunits.listLinkedCustomChannels" call.
// Exactly one of *ListLinkedCustomChannelsResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListLinkedCustomChannelsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsAdclientsAdunitsListLinkedCustomChannelsCall) Do(opts ...googleapi.CallOption) (*ListLinkedCustomChannelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListLinkedCustomChannelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all the custom channels available for an ad unit.",
	//   "flatPath": "v2/accounts/{accountsId}/adclients/{adclientsId}/adunits/{adunitsId}:listLinkedCustomChannels",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.adclients.adunits.listLinkedCustomChannels",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of custom channels to include in the response, used for paging. If unspecified, at most 10000 custom channels will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListLinkedCustomChannels` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListLinkedCustomChannels` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The ad unit which owns the collection of custom channels. Format: accounts/{account}/adclients/{adclient}/adunits/{adunit}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/adclients/[^/]+/adunits/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}:listLinkedCustomChannels",
	//   "response": {
	//     "$ref": "ListLinkedCustomChannelsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsAdclientsAdunitsListLinkedCustomChannelsCall) Pages(ctx context.Context, f func(*ListLinkedCustomChannelsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "adsense.accounts.adclients.customchannels.get":

type AccountsAdclientsCustomchannelsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about the selected custom channel.
//
// - name: Name of the custom channel. Format:
//   accounts/{account}/adclients/{adclient}/customchannels/{customchanne
//   l}.
func (r *AccountsAdclientsCustomchannelsService) Get(name string) *AccountsAdclientsCustomchannelsGetCall {
	c := &AccountsAdclientsCustomchannelsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAdclientsCustomchannelsGetCall) Fields(s ...googleapi.Field) *AccountsAdclientsCustomchannelsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsAdclientsCustomchannelsGetCall) IfNoneMatch(entityTag string) *AccountsAdclientsCustomchannelsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAdclientsCustomchannelsGetCall) Context(ctx context.Context) *AccountsAdclientsCustomchannelsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAdclientsCustomchannelsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAdclientsCustomchannelsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.adclients.customchannels.get" call.
// Exactly one of *CustomChannel or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *CustomChannel.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsAdclientsCustomchannelsGetCall) Do(opts ...googleapi.CallOption) (*CustomChannel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &CustomChannel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about the selected custom channel.",
	//   "flatPath": "v2/accounts/{accountsId}/adclients/{adclientsId}/customchannels/{customchannelsId}",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.adclients.customchannels.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the custom channel. Format: accounts/{account}/adclients/{adclient}/customchannels/{customchannel}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/adclients/[^/]+/customchannels/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}",
	//   "response": {
	//     "$ref": "CustomChannel"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// method id "adsense.accounts.adclients.customchannels.list":

type AccountsAdclientsCustomchannelsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the custom channels available in an ad client.
//
// - parent: The ad client which owns the collection of custom channels.
//   Format: accounts/{account}/adclients/{adclient}.
func (r *AccountsAdclientsCustomchannelsService) List(parent string) *AccountsAdclientsCustomchannelsListCall {
	c := &AccountsAdclientsCustomchannelsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of custom channels to include in the response, used for paging. If
// unspecified, at most 10000 custom channels will be returned. The
// maximum value is 10000; values above 10000 will be coerced to 10000.
func (c *AccountsAdclientsCustomchannelsListCall) PageSize(pageSize int64) *AccountsAdclientsCustomchannelsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListCustomChannels` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListCustomChannels` must match the call that provided
// the page token.
func (c *AccountsAdclientsCustomchannelsListCall) PageToken(pageToken string) *AccountsAdclientsCustomchannelsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAdclientsCustomchannelsListCall) Fields(s ...googleapi.Field) *AccountsAdclientsCustomchannelsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsAdclientsCustomchannelsListCall) IfNoneMatch(entityTag string) *AccountsAdclientsCustomchannelsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAdclientsCustomchannelsListCall) Context(ctx context.Context) *AccountsAdclientsCustomchannelsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAdclientsCustomchannelsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAdclientsCustomchannelsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/customchannels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.adclients.customchannels.list" call.
// Exactly one of *ListCustomChannelsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListCustomChannelsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsAdclientsCustomchannelsListCall) Do(opts ...googleapi.CallOption) (*ListCustomChannelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListCustomChannelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all the custom channels available in an ad client.",
	//   "flatPath": "v2/accounts/{accountsId}/adclients/{adclientsId}/customchannels",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.adclients.customchannels.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of custom channels to include in the response, used for paging. If unspecified, at most 10000 custom channels will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListCustomChannels` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListCustomChannels` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The ad client which owns the collection of custom channels. Format: accounts/{account}/adclients/{adclient}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/adclients/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/customchannels",
	//   "response": {
	//     "$ref": "ListCustomChannelsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsAdclientsCustomchannelsListCall) Pages(ctx context.Context, f func(*ListCustomChannelsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "adsense.accounts.adclients.customchannels.listLinkedAdUnits":

type AccountsAdclientsCustomchannelsListLinkedAdUnitsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListLinkedAdUnits: Lists all the ad units available for a custom
// channel.
//
// - parent: The custom channel which owns the collection of ad units.
//   Format:
//   accounts/{account}/adclients/{adclient}/customchannels/{customchanne
//   l}.
func (r *AccountsAdclientsCustomchannelsService) ListLinkedAdUnits(parent string) *AccountsAdclientsCustomchannelsListLinkedAdUnitsCall {
	c := &AccountsAdclientsCustomchannelsListLinkedAdUnitsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of ad units to include in the response, used for paging. If
// unspecified, at most 10000 ad units will be returned. The maximum
// value is 10000; values above 10000 will be coerced to 10000.
func (c *AccountsAdclientsCustomchannelsListLinkedAdUnitsCall) PageSize(pageSize int64) *AccountsAdclientsCustomchannelsListLinkedAdUnitsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListLinkedAdUnits` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListLinkedAdUnits` must match the call that provided the
// page token.
func (c *AccountsAdclientsCustomchannelsListLinkedAdUnitsCall) PageToken(pageToken string) *AccountsAdclientsCustomchannelsListLinkedAdUnitsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAdclientsCustomchannelsListLinkedAdUnitsCall) Fields(s ...googleapi.Field) *AccountsAdclientsCustomchannelsListLinkedAdUnitsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsAdclientsCustomchannelsListLinkedAdUnitsCall) IfNoneMatch(entityTag string) *AccountsAdclientsCustomchannelsListLinkedAdUnitsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAdclientsCustomchannelsListLinkedAdUnitsCall) Context(ctx context.Context) *AccountsAdclientsCustomchannelsListLinkedAdUnitsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAdclientsCustomchannelsListLinkedAdUnitsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAdclientsCustomchannelsListLinkedAdUnitsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}:listLinkedAdUnits")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.adclients.customchannels.listLinkedAdUnits" call.
// Exactly one of *ListLinkedAdUnitsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListLinkedAdUnitsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsAdclientsCustomchannelsListLinkedAdUnitsCall) Do(opts ...googleapi.CallOption) (*ListLinkedAdUnitsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListLinkedAdUnitsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all the ad units available for a custom channel.",
	//   "flatPath": "v2/accounts/{accountsId}/adclients/{adclientsId}/customchannels/{customchannelsId}:listLinkedAdUnits",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.adclients.customchannels.listLinkedAdUnits",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of ad units to include in the response, used for paging. If unspecified, at most 10000 ad units will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListLinkedAdUnits` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListLinkedAdUnits` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The custom channel which owns the collection of ad units. Format: accounts/{account}/adclients/{adclient}/customchannels/{customchannel}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/adclients/[^/]+/customchannels/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}:listLinkedAdUnits",
	//   "response": {
	//     "$ref": "ListLinkedAdUnitsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsAdclientsCustomchannelsListLinkedAdUnitsCall) Pages(ctx context.Context, f func(*ListLinkedAdUnitsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "adsense.accounts.adclients.urlchannels.list":

type AccountsAdclientsUrlchannelsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists active url channels.
//
// - parent: The ad client which owns the collection of url channels.
//   Format: accounts/{account}/adclients/{adclient}.
func (r *AccountsAdclientsUrlchannelsService) List(parent string) *AccountsAdclientsUrlchannelsListCall {
	c := &AccountsAdclientsUrlchannelsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of url channels to include in the response, used for paging. If
// unspecified, at most 10000 url channels will be returned. The maximum
// value is 10000; values above 10000 will be coerced to 10000.
func (c *AccountsAdclientsUrlchannelsListCall) PageSize(pageSize int64) *AccountsAdclientsUrlchannelsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListUrlChannels` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListUrlChannels` must match the call that provided the
// page token.
func (c *AccountsAdclientsUrlchannelsListCall) PageToken(pageToken string) *AccountsAdclientsUrlchannelsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAdclientsUrlchannelsListCall) Fields(s ...googleapi.Field) *AccountsAdclientsUrlchannelsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsAdclientsUrlchannelsListCall) IfNoneMatch(entityTag string) *AccountsAdclientsUrlchannelsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAdclientsUrlchannelsListCall) Context(ctx context.Context) *AccountsAdclientsUrlchannelsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAdclientsUrlchannelsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAdclientsUrlchannelsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/urlchannels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.adclients.urlchannels.list" call.
// Exactly one of *ListUrlChannelsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListUrlChannelsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsAdclientsUrlchannelsListCall) Do(opts ...googleapi.CallOption) (*ListUrlChannelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListUrlChannelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists active url channels.",
	//   "flatPath": "v2/accounts/{accountsId}/adclients/{adclientsId}/urlchannels",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.adclients.urlchannels.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of url channels to include in the response, used for paging. If unspecified, at most 10000 url channels will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListUrlChannels` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListUrlChannels` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The ad client which owns the collection of url channels. Format: accounts/{account}/adclients/{adclient}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/adclients/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/urlchannels",
	//   "response": {
	//     "$ref": "ListUrlChannelsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsAdclientsUrlchannelsListCall) Pages(ctx context.Context, f func(*ListUrlChannelsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "adsense.accounts.alerts.list":

type AccountsAlertsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the alerts available in an account.
//
// - parent: The account which owns the collection of alerts. Format:
//   accounts/{account}.
func (r *AccountsAlertsService) List(parent string) *AccountsAlertsListCall {
	c := &AccountsAlertsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// LanguageCode sets the optional parameter "languageCode": The language
// to use for translating alert messages. If unspecified, this defaults
// to the user's display language. If the given language is not
// supported, alerts will be returned in English. The language is
// specified as an IETF BCP-47 language code
// (https://en.wikipedia.org/wiki/IETF_language_tag).
func (c *AccountsAlertsListCall) LanguageCode(languageCode string) *AccountsAlertsListCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAlertsListCall) Fields(s ...googleapi.Field) *AccountsAlertsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsAlertsListCall) IfNoneMatch(entityTag string) *AccountsAlertsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAlertsListCall) Context(ctx context.Context) *AccountsAlertsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAlertsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAlertsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/alerts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.alerts.list" call.
// Exactly one of *ListAlertsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListAlertsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsAlertsListCall) Do(opts ...googleapi.CallOption) (*ListAlertsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListAlertsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all the alerts available in an account.",
	//   "flatPath": "v2/accounts/{accountsId}/alerts",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.alerts.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "languageCode": {
	//       "description": "The language to use for translating alert messages. If unspecified, this defaults to the user's display language. If the given language is not supported, alerts will be returned in English. The language is specified as an [IETF BCP-47 language code](https://en.wikipedia.org/wiki/IETF_language_tag).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The account which owns the collection of alerts. Format: accounts/{account}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/alerts",
	//   "response": {
	//     "$ref": "ListAlertsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// method id "adsense.accounts.payments.list":

type AccountsPaymentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the payments available for an account.
//
// - parent: The account which owns the collection of payments. Format:
//   accounts/{account}.
func (r *AccountsPaymentsService) List(parent string) *AccountsPaymentsListCall {
	c := &AccountsPaymentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsPaymentsListCall) Fields(s ...googleapi.Field) *AccountsPaymentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsPaymentsListCall) IfNoneMatch(entityTag string) *AccountsPaymentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsPaymentsListCall) Context(ctx context.Context) *AccountsPaymentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsPaymentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsPaymentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/payments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.payments.list" call.
// Exactly one of *ListPaymentsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListPaymentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsPaymentsListCall) Do(opts ...googleapi.CallOption) (*ListPaymentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListPaymentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all the payments available for an account.",
	//   "flatPath": "v2/accounts/{accountsId}/payments",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.payments.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The account which owns the collection of payments. Format: accounts/{account}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/payments",
	//   "response": {
	//     "$ref": "ListPaymentsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// method id "adsense.accounts.reports.generate":

type AccountsReportsGenerateCall struct {
	s            *Service
	account      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Generate: Generates an ad hoc report.
//
// - account: The account which owns the collection of reports. Format:
//   accounts/{account}.
func (r *AccountsReportsService) Generate(account string) *AccountsReportsGenerateCall {
	c := &AccountsReportsGenerateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.account = account
	return c
}

// CurrencyCode sets the optional parameter "currencyCode": The ISO-4217
// currency code (https://en.wikipedia.org/wiki/ISO_4217) to use when
// reporting on monetary metrics. Defaults to the account's currency if
// not set.
func (c *AccountsReportsGenerateCall) CurrencyCode(currencyCode string) *AccountsReportsGenerateCall {
	c.urlParams_.Set("currencyCode", currencyCode)
	return c
}

// DateRange sets the optional parameter "dateRange": Date range of the
// report, if unset the range will be considered CUSTOM.
//
// Possible values:
//   "REPORTING_DATE_RANGE_UNSPECIFIED" - Unspecified date range.
//   "CUSTOM" - A custom date range specified using the `start_date` and
// `end_date` fields. This is the default if no ReportingDateRange is
// provided.
//   "TODAY" - Current day.
//   "YESTERDAY" - Yesterday.
//   "MONTH_TO_DATE" - From the start of the current month to the
// current day. e.g. if the current date is 2020-03-12 then the range
// will be [2020-03-01, 2020-03-12].
//   "YEAR_TO_DATE" - From the start of the current year to the current
// day. e.g. if the current date is 2020-03-12 then the range will be
// [2020-01-01, 2020-03-12].
//   "LAST_7_DAYS" - Last 7 days, excluding current day.
//   "LAST_30_DAYS" - Last 30 days, excluding current day.
func (c *AccountsReportsGenerateCall) DateRange(dateRange string) *AccountsReportsGenerateCall {
	c.urlParams_.Set("dateRange", dateRange)
	return c
}

// Dimensions sets the optional parameter "dimensions": Dimensions to
// base the report on.
//
// Possible values:
//   "DIMENSION_UNSPECIFIED" - Unspecified dimension.
//   "DATE" - Date dimension in YYYY-MM-DD format (e.g. "2010-02-10").
//   "WEEK" - Week dimension in YYYY-MM-DD format, representing the
// first day of each week (e.g. "2010-02-08"). The first day of the week
// is determined by the language_code specified in a report generation
// request (so e.g. this would be a Monday for "en-GB" or "es", but a
// Sunday for "en" or "fr-CA").
//   "MONTH" - Month dimension in YYYY-MM format (e.g. "2010-02").
//   "ACCOUNT_NAME" - Account name. The members of this dimension match
// the values from Account.display_name.
//   "AD_CLIENT_ID" - Unique ID of an ad client. The members of this
// dimension match the values from AdClient.reporting_dimension_id.
//   "PRODUCT_NAME" - Localized product name (e.g. "AdSense for
// Content", "AdSense for Search").
//   "PRODUCT_CODE" - Product code (e.g. "AFC", "AFS"). The members of
// this dimension match the values from AdClient.product_code.
//   "AD_UNIT_NAME" - Ad unit name (within which an ad was served). The
// members of this dimension match the values from AdUnit.display_name.
//   "AD_UNIT_ID" - Unique ID of an ad unit (within which an ad was
// served). The members of this dimension match the values from
// AdUnit.reporting_dimension_id.
//   "AD_UNIT_SIZE_NAME" - Localized size of an ad unit (e.g. "728x90",
// "Responsive").
//   "AD_UNIT_SIZE_CODE" - The size code of an ad unit (e.g. "728x90",
// "responsive").
//   "CUSTOM_CHANNEL_NAME" - Custom channel name. The members of this
// dimension match the values from CustomChannel.display_name.
//   "CUSTOM_CHANNEL_ID" - Unique ID of a custom channel. The members of
// this dimension match the values from
// CustomChannel.reporting_dimension_id.
//   "OWNED_SITE_DOMAIN_NAME" - Domain name of a verified site (e.g.
// "example.com"). The members of this dimension match the values from
// Site.domain.
//   "OWNED_SITE_ID" - Unique ID of a verified site. The members of this
// dimension match the values from Site.reporting_dimension_id.
//   "URL_CHANNEL_NAME" - Name of a URL channel. The members of this
// dimension match the values from UrlChannel.uri_pattern.
//   "URL_CHANNEL_ID" - Unique ID of a URL channel. The members of this
// dimension match the values from UrlChannel.reporting_dimension_id.
//   "BUYER_NETWORK_NAME" - Name of an ad network that returned the
// winning ads for an ad request (e.g. "Google AdWords"). Note that
// unlike other "NAME" dimensions, the members of this dimensions are
// not localized.
//   "BUYER_NETWORK_ID" - Unique (opaque) ID of an ad network that
// returned the winning ads for an ad request.
//   "BID_TYPE_NAME" - Localized bid type name (e.g. "CPC bids", "CPM
// bids") for a served ad.
//   "BID_TYPE_CODE" - Type of a bid (e.g. "cpc", "cpm") for a served
// ad.
//   "CREATIVE_SIZE_NAME" - Localized creative size name (e.g. "728x90",
// "Dynamic") of a served ad.
//   "CREATIVE_SIZE_CODE" - Creative size code (e.g. "728x90",
// "dynamic") of a served ad.
//   "DOMAIN_NAME" - Localized name of a host on which an ad was served,
// after IDNA decoding (e.g. "www.google.com", "Web caches and other",
// "bücher.example").
//   "DOMAIN_CODE" - Name of a host on which an ad was served (e.g.
// "www.google.com", "webcaches", "xn--bcher-kva.example").
//   "COUNTRY_NAME" - Localized region name of a user viewing an ad
// (e.g. "United States", "France").
//   "COUNTRY_CODE" - CLDR region code of a user viewing an ad (e.g.
// "US", "FR").
//   "PLATFORM_TYPE_NAME" - Localized platform type name (e.g. "High-end
// mobile devices", "Desktop").
//   "PLATFORM_TYPE_CODE" - Platform type code (e.g. "HighEndMobile",
// "Desktop").
//   "TARGETING_TYPE_NAME" - Localized targeting type name (e.g.
// "Contextual", "Personalized", "Run of Network").
//   "TARGETING_TYPE_CODE" - Targeting type code (e.g. "Keyword",
// "UserInterest", "RunOfNetwork").
//   "CONTENT_PLATFORM_NAME" - Localized content platform name an ad
// request was made from (e.g. "AMP", "Web").
//   "CONTENT_PLATFORM_CODE" - Content platform code an ad request was
// made from (e.g. "AMP", "HTML").
//   "AD_PLACEMENT_NAME" - Localized ad placement name (e.g. "Ad unit",
// "Global settings", "Manual").
//   "AD_PLACEMENT_CODE" - Ad placement code (e.g. "AD_UNIT",
// "ca-pub-123456:78910", "OTHER").
//   "REQUESTED_AD_TYPE_NAME" - Localized requested ad type name (e.g.
// "Display", "Link unit", "Other").
//   "REQUESTED_AD_TYPE_CODE" - Requested ad type code (e.g. "IMAGE",
// "RADLINK", "OTHER").
//   "SERVED_AD_TYPE_NAME" - Localized served ad type name (e.g.
// "Display", "Link unit", "Other").
//   "SERVED_AD_TYPE_CODE" - Served ad type code (e.g. "IMAGE",
// "RADLINK", "OTHER").
//   "CUSTOM_SEARCH_STYLE_NAME" - Custom search style name.
//   "CUSTOM_SEARCH_STYLE_ID" - Custom search style id.
//   "DOMAIN_REGISTRANT" - Domain registrants.
//   "WEBSEARCH_QUERY_STRING" - Query strings for web searches.
func (c *AccountsReportsGenerateCall) Dimensions(dimensions ...string) *AccountsReportsGenerateCall {
	c.urlParams_.SetMulti("dimensions", append([]string{}, dimensions...))
	return c
}

// EndDateDay sets the optional parameter "endDate.day": Day of a month.
// Must be from 1 to 31 and valid for the year and month, or 0 to
// specify a year by itself or a year and month where the day isn't
// significant.
func (c *AccountsReportsGenerateCall) EndDateDay(endDateDay int64) *AccountsReportsGenerateCall {
	c.urlParams_.Set("endDate.day", fmt.Sprint(endDateDay))
	return c
}

// EndDateMonth sets the optional parameter "endDate.month": Month of a
// year. Must be from 1 to 12, or 0 to specify a year without a month
// and day.
func (c *AccountsReportsGenerateCall) EndDateMonth(endDateMonth int64) *AccountsReportsGenerateCall {
	c.urlParams_.Set("endDate.month", fmt.Sprint(endDateMonth))
	return c
}

// EndDateYear sets the optional parameter "endDate.year": Year of the
// date. Must be from 1 to 9999, or 0 to specify a date without a year.
func (c *AccountsReportsGenerateCall) EndDateYear(endDateYear int64) *AccountsReportsGenerateCall {
	c.urlParams_.Set("endDate.year", fmt.Sprint(endDateYear))
	return c
}

// Filters sets the optional parameter "filters": Filters to be run on
// the report.
func (c *AccountsReportsGenerateCall) Filters(filters ...string) *AccountsReportsGenerateCall {
	c.urlParams_.SetMulti("filters", append([]string{}, filters...))
	return c
}

// LanguageCode sets the optional parameter "languageCode": The language
// to use for translating report output. If unspecified, this defaults
// to English ("en"). If the given language is not supported, report
// output will be returned in English. The language is specified as an
// IETF BCP-47 language code
// (https://en.wikipedia.org/wiki/IETF_language_tag).
func (c *AccountsReportsGenerateCall) LanguageCode(languageCode string) *AccountsReportsGenerateCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of rows
// of report data to return. Reports producing more rows than the
// requested limit will be truncated. If unset, this defaults to 100,000
// rows for `Reports.GenerateReport` and 1,000,000 rows for
// `Reports.GenerateCsvReport`, which are also the maximum values
// permitted here. Report truncation can be identified (for
// `Reports.GenerateReport` only) by comparing the number of rows
// returned to the value returned in `total_matched_rows`.
func (c *AccountsReportsGenerateCall) Limit(limit int64) *AccountsReportsGenerateCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// Metrics sets the optional parameter "metrics": Required. Reporting
// metrics.
//
// Possible values:
//   "METRIC_UNSPECIFIED" - Unspecified metric.
//   "PAGE_VIEWS" - Number of page views.
//   "AD_REQUESTS" - Number of ad units that requested ads (for content
// ads) or search queries (for search ads). An ad request may result in
// zero, one, or multiple individual ad impressions depending on the
// size of the ad unit and whether any ads were available.
//   "MATCHED_AD_REQUESTS" - Requests that returned at least one ad.
//   "TOTAL_IMPRESSIONS" - Impressions. An impression is counted for
// each ad request where at least one ad has been downloaded to the
// user’s device and has begun to load. It is the number of ad units
// (for content ads) or search queries (for search ads) that showed ads.
//   "IMPRESSIONS" - Impressions. An impression is counted for each ad
// request where at least one ad has been downloaded to the user’s
// device and has begun to load. It is the number of ad units (for
// content ads) or search queries (for search ads) that showed ads.
//   "INDIVIDUAL_AD_IMPRESSIONS" - Ads shown. Different ad formats will
// display varying numbers of ads. For example, a vertical banner may
// consist of 2 or more ads. Also, the number of ads in an ad unit may
// vary depending on whether the ad unit is displaying standard text
// ads, expanded text ads or image ads.
//   "CLICKS" - Number of times a user clicked on a standard content ad.
//   "PAGE_VIEWS_SPAM_RATIO" - Fraction of page views considered to be
// spam. Only available to premium accounts.
//   "AD_REQUESTS_SPAM_RATIO" - Fraction of ad requests considered to be
// spam. Only available to premium accounts.
//   "MATCHED_AD_REQUESTS_SPAM_RATIO" - Fraction of ad requests that
// returned ads considered to be spam. Only available to premium
// accounts.
//   "IMPRESSIONS_SPAM_RATIO" - Fraction of impressions considered to be
// spam. Only available to premium accounts.
//   "INDIVIDUAL_AD_IMPRESSIONS_SPAM_RATIO" - Fraction of ad impressions
// considered to be spam. Only available to premium accounts.
//   "CLICKS_SPAM_RATIO" - Fraction of clicks considered to be spam.
// Only available to premium accounts.
//   "AD_REQUESTS_COVERAGE" - Ratio of requested ad units or queries to
// the number returned to the site.
//   "PAGE_VIEWS_CTR" - Ratio of individual page views that resulted in
// a click.
//   "AD_REQUESTS_CTR" - Ratio of ad requests that resulted in a click.
//   "MATCHED_AD_REQUESTS_CTR" - Ratio of clicks to matched requests.
//   "IMPRESSIONS_CTR" - Ratio of IMPRESSIONS that resulted in a click.
//   "INDIVIDUAL_AD_IMPRESSIONS_CTR" - Ratio of individual ad
// impressions that resulted in a click.
//   "ACTIVE_VIEW_MEASURABILITY" - Ratio of requests that were
// measurable for viewability.
//   "ACTIVE_VIEW_VIEWABILITY" - Ratio of requests that were viewable.
//   "ACTIVE_VIEW_TIME" - Mean time an ad was displayed on screen.
//   "ESTIMATED_EARNINGS" - Estimated earnings of the publisher. Note
// that earnings up to yesterday are accurate, more recent earnings are
// estimated due to the possibility of spam, or exchange rate
// fluctuations.
//   "PAGE_VIEWS_RPM" - Revenue per thousand page views. This is
// calculated by dividing the estimated revenue by the number of page
// views multiplied by 1000.
//   "AD_REQUESTS_RPM" - Revenue per thousand ad requests. This is
// calculated by dividing estimated revenue by the number of ad requests
// multiplied by 1000.
//   "MATCHED_AD_REQUESTS_RPM" - Revenue per thousand matched ad
// requests. This is calculated by dividing estimated revenue by the
// number of matched ad requests multiplied by 1000.
//   "IMPRESSIONS_RPM" - Revenue per thousand ad impressions. This is
// calculated by dividing estimated revenue by the number of ad
// impressions multiplied by 1000.
//   "INDIVIDUAL_AD_IMPRESSIONS_RPM" - Revenue per thousand individual
// ad impressions. This is calculated by dividing estimated revenue by
// the number of individual ad impressions multiplied by 1000.
//   "COST_PER_CLICK" - Amount the publisher earns each time a user
// clicks on an ad. CPC is calculated by dividing the estimated revenue
// by the number of clicks received.
//   "ADS_PER_IMPRESSION" - Number of ad views per impression.
//   "TOTAL_EARNINGS" - Total earnings.
//   "WEBSEARCH_RESULT_PAGES" - Number of results pages.
func (c *AccountsReportsGenerateCall) Metrics(metrics ...string) *AccountsReportsGenerateCall {
	c.urlParams_.SetMulti("metrics", append([]string{}, metrics...))
	return c
}

// OrderBy sets the optional parameter "orderBy": The name of a
// dimension or metric to sort the resulting report on, can be prefixed
// with "+" to sort ascending or "-" to sort descending. If no prefix is
// specified, the column is sorted ascending.
func (c *AccountsReportsGenerateCall) OrderBy(orderBy ...string) *AccountsReportsGenerateCall {
	c.urlParams_.SetMulti("orderBy", append([]string{}, orderBy...))
	return c
}

// ReportingTimeZone sets the optional parameter "reportingTimeZone":
// Timezone in which to generate the report. If unspecified, this
// defaults to the account timezone. For more information, see changing
// the time zone of your reports
// (https://support.google.com/adsense/answer/9830725).
//
// Possible values:
//   "REPORTING_TIME_ZONE_UNSPECIFIED" - Unspecified timezone.
//   "ACCOUNT_TIME_ZONE" - Use the account timezone in the report.
//   "GOOGLE_TIME_ZONE" - Use the Google timezone in the report
// (America/Los_Angeles).
func (c *AccountsReportsGenerateCall) ReportingTimeZone(reportingTimeZone string) *AccountsReportsGenerateCall {
	c.urlParams_.Set("reportingTimeZone", reportingTimeZone)
	return c
}

// StartDateDay sets the optional parameter "startDate.day": Day of a
// month. Must be from 1 to 31 and valid for the year and month, or 0 to
// specify a year by itself or a year and month where the day isn't
// significant.
func (c *AccountsReportsGenerateCall) StartDateDay(startDateDay int64) *AccountsReportsGenerateCall {
	c.urlParams_.Set("startDate.day", fmt.Sprint(startDateDay))
	return c
}

// StartDateMonth sets the optional parameter "startDate.month": Month
// of a year. Must be from 1 to 12, or 0 to specify a year without a
// month and day.
func (c *AccountsReportsGenerateCall) StartDateMonth(startDateMonth int64) *AccountsReportsGenerateCall {
	c.urlParams_.Set("startDate.month", fmt.Sprint(startDateMonth))
	return c
}

// StartDateYear sets the optional parameter "startDate.year": Year of
// the date. Must be from 1 to 9999, or 0 to specify a date without a
// year.
func (c *AccountsReportsGenerateCall) StartDateYear(startDateYear int64) *AccountsReportsGenerateCall {
	c.urlParams_.Set("startDate.year", fmt.Sprint(startDateYear))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsReportsGenerateCall) Fields(s ...googleapi.Field) *AccountsReportsGenerateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsReportsGenerateCall) IfNoneMatch(entityTag string) *AccountsReportsGenerateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsReportsGenerateCall) Context(ctx context.Context) *AccountsReportsGenerateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsReportsGenerateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsReportsGenerateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+account}/reports:generate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"account": c.account,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.reports.generate" call.
// Exactly one of *ReportResult or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *ReportResult.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsReportsGenerateCall) Do(opts ...googleapi.CallOption) (*ReportResult, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ReportResult{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Generates an ad hoc report.",
	//   "flatPath": "v2/accounts/{accountsId}/reports:generate",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.reports.generate",
	//   "parameterOrder": [
	//     "account"
	//   ],
	//   "parameters": {
	//     "account": {
	//       "description": "Required. The account which owns the collection of reports. Format: accounts/{account}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "currencyCode": {
	//       "description": "The [ISO-4217 currency code](https://en.wikipedia.org/wiki/ISO_4217) to use when reporting on monetary metrics. Defaults to the account's currency if not set.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "dateRange": {
	//       "description": "Date range of the report, if unset the range will be considered CUSTOM.",
	//       "enum": [
	//         "REPORTING_DATE_RANGE_UNSPECIFIED",
	//         "CUSTOM",
	//         "TODAY",
	//         "YESTERDAY",
	//         "MONTH_TO_DATE",
	//         "YEAR_TO_DATE",
	//         "LAST_7_DAYS",
	//         "LAST_30_DAYS"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified date range.",
	//         "A custom date range specified using the `start_date` and `end_date` fields. This is the default if no ReportingDateRange is provided.",
	//         "Current day.",
	//         "Yesterday.",
	//         "From the start of the current month to the current day. e.g. if the current date is 2020-03-12 then the range will be [2020-03-01, 2020-03-12].",
	//         "From the start of the current year to the current day. e.g. if the current date is 2020-03-12 then the range will be [2020-01-01, 2020-03-12].",
	//         "Last 7 days, excluding current day.",
	//         "Last 30 days, excluding current day."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "dimensions": {
	//       "description": "Dimensions to base the report on.",
	//       "enum": [
	//         "DIMENSION_UNSPECIFIED",
	//         "DATE",
	//         "WEEK",
	//         "MONTH",
	//         "ACCOUNT_NAME",
	//         "AD_CLIENT_ID",
	//         "PRODUCT_NAME",
	//         "PRODUCT_CODE",
	//         "AD_UNIT_NAME",
	//         "AD_UNIT_ID",
	//         "AD_UNIT_SIZE_NAME",
	//         "AD_UNIT_SIZE_CODE",
	//         "CUSTOM_CHANNEL_NAME",
	//         "CUSTOM_CHANNEL_ID",
	//         "OWNED_SITE_DOMAIN_NAME",
	//         "OWNED_SITE_ID",
	//         "URL_CHANNEL_NAME",
	//         "URL_CHANNEL_ID",
	//         "BUYER_NETWORK_NAME",
	//         "BUYER_NETWORK_ID",
	//         "BID_TYPE_NAME",
	//         "BID_TYPE_CODE",
	//         "CREATIVE_SIZE_NAME",
	//         "CREATIVE_SIZE_CODE",
	//         "DOMAIN_NAME",
	//         "DOMAIN_CODE",
	//         "COUNTRY_NAME",
	//         "COUNTRY_CODE",
	//         "PLATFORM_TYPE_NAME",
	//         "PLATFORM_TYPE_CODE",
	//         "TARGETING_TYPE_NAME",
	//         "TARGETING_TYPE_CODE",
	//         "CONTENT_PLATFORM_NAME",
	//         "CONTENT_PLATFORM_CODE",
	//         "AD_PLACEMENT_NAME",
	//         "AD_PLACEMENT_CODE",
	//         "REQUESTED_AD_TYPE_NAME",
	//         "REQUESTED_AD_TYPE_CODE",
	//         "SERVED_AD_TYPE_NAME",
	//         "SERVED_AD_TYPE_CODE",
	//         "CUSTOM_SEARCH_STYLE_NAME",
	//         "CUSTOM_SEARCH_STYLE_ID",
	//         "DOMAIN_REGISTRANT",
	//         "WEBSEARCH_QUERY_STRING"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified dimension.",
	//         "Date dimension in YYYY-MM-DD format (e.g. \"2010-02-10\").",
	//         "Week dimension in YYYY-MM-DD format, representing the first day of each week (e.g. \"2010-02-08\"). The first day of the week is determined by the language_code specified in a report generation request (so e.g. this would be a Monday for \"en-GB\" or \"es\", but a Sunday for \"en\" or \"fr-CA\").",
	//         "Month dimension in YYYY-MM format (e.g. \"2010-02\").",
	//         "Account name. The members of this dimension match the values from Account.display_name.",
	//         "Unique ID of an ad client. The members of this dimension match the values from AdClient.reporting_dimension_id.",
	//         "Localized product name (e.g. \"AdSense for Content\", \"AdSense for Search\").",
	//         "Product code (e.g. \"AFC\", \"AFS\"). The members of this dimension match the values from AdClient.product_code.",
	//         "Ad unit name (within which an ad was served). The members of this dimension match the values from AdUnit.display_name.",
	//         "Unique ID of an ad unit (within which an ad was served). The members of this dimension match the values from AdUnit.reporting_dimension_id.",
	//         "Localized size of an ad unit (e.g. \"728x90\", \"Responsive\").",
	//         "The size code of an ad unit (e.g. \"728x90\", \"responsive\").",
	//         "Custom channel name. The members of this dimension match the values from CustomChannel.display_name.",
	//         "Unique ID of a custom channel. The members of this dimension match the values from CustomChannel.reporting_dimension_id.",
	//         "Domain name of a verified site (e.g. \"example.com\"). The members of this dimension match the values from Site.domain.",
	//         "Unique ID of a verified site. The members of this dimension match the values from Site.reporting_dimension_id.",
	//         "Name of a URL channel. The members of this dimension match the values from UrlChannel.uri_pattern.",
	//         "Unique ID of a URL channel. The members of this dimension match the values from UrlChannel.reporting_dimension_id.",
	//         "Name of an ad network that returned the winning ads for an ad request (e.g. \"Google AdWords\"). Note that unlike other \"NAME\" dimensions, the members of this dimensions are not localized.",
	//         "Unique (opaque) ID of an ad network that returned the winning ads for an ad request.",
	//         "Localized bid type name (e.g. \"CPC bids\", \"CPM bids\") for a served ad.",
	//         "Type of a bid (e.g. \"cpc\", \"cpm\") for a served ad.",
	//         "Localized creative size name (e.g. \"728x90\", \"Dynamic\") of a served ad.",
	//         "Creative size code (e.g. \"728x90\", \"dynamic\") of a served ad.",
	//         "Localized name of a host on which an ad was served, after IDNA decoding (e.g. \"www.google.com\", \"Web caches and other\", \"bücher.example\").",
	//         "Name of a host on which an ad was served (e.g. \"www.google.com\", \"webcaches\", \"xn--bcher-kva.example\").",
	//         "Localized region name of a user viewing an ad (e.g. \"United States\", \"France\").",
	//         "CLDR region code of a user viewing an ad (e.g. \"US\", \"FR\").",
	//         "Localized platform type name (e.g. \"High-end mobile devices\", \"Desktop\").",
	//         "Platform type code (e.g. \"HighEndMobile\", \"Desktop\").",
	//         "Localized targeting type name (e.g. \"Contextual\", \"Personalized\", \"Run of Network\").",
	//         "Targeting type code (e.g. \"Keyword\", \"UserInterest\", \"RunOfNetwork\").",
	//         "Localized content platform name an ad request was made from (e.g. \"AMP\", \"Web\").",
	//         "Content platform code an ad request was made from (e.g. \"AMP\", \"HTML\").",
	//         "Localized ad placement name (e.g. \"Ad unit\", \"Global settings\", \"Manual\").",
	//         "Ad placement code (e.g. \"AD_UNIT\", \"ca-pub-123456:78910\", \"OTHER\").",
	//         "Localized requested ad type name (e.g. \"Display\", \"Link unit\", \"Other\").",
	//         "Requested ad type code (e.g. \"IMAGE\", \"RADLINK\", \"OTHER\").",
	//         "Localized served ad type name (e.g. \"Display\", \"Link unit\", \"Other\").",
	//         "Served ad type code (e.g. \"IMAGE\", \"RADLINK\", \"OTHER\").",
	//         "Custom search style name.",
	//         "Custom search style id.",
	//         "Domain registrants.",
	//         "Query strings for web searches."
	//       ],
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "endDate.day": {
	//       "description": "Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "endDate.month": {
	//       "description": "Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "endDate.year": {
	//       "description": "Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "filters": {
	//       "description": "Filters to be run on the report.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "languageCode": {
	//       "description": "The language to use for translating report output. If unspecified, this defaults to English (\"en\"). If the given language is not supported, report output will be returned in English. The language is specified as an [IETF BCP-47 language code](https://en.wikipedia.org/wiki/IETF_language_tag).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "limit": {
	//       "description": "The maximum number of rows of report data to return. Reports producing more rows than the requested limit will be truncated. If unset, this defaults to 100,000 rows for `Reports.GenerateReport` and 1,000,000 rows for `Reports.GenerateCsvReport`, which are also the maximum values permitted here. Report truncation can be identified (for `Reports.GenerateReport` only) by comparing the number of rows returned to the value returned in `total_matched_rows`.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "metrics": {
	//       "description": "Required. Reporting metrics.",
	//       "enum": [
	//         "METRIC_UNSPECIFIED",
	//         "PAGE_VIEWS",
	//         "AD_REQUESTS",
	//         "MATCHED_AD_REQUESTS",
	//         "TOTAL_IMPRESSIONS",
	//         "IMPRESSIONS",
	//         "INDIVIDUAL_AD_IMPRESSIONS",
	//         "CLICKS",
	//         "PAGE_VIEWS_SPAM_RATIO",
	//         "AD_REQUESTS_SPAM_RATIO",
	//         "MATCHED_AD_REQUESTS_SPAM_RATIO",
	//         "IMPRESSIONS_SPAM_RATIO",
	//         "INDIVIDUAL_AD_IMPRESSIONS_SPAM_RATIO",
	//         "CLICKS_SPAM_RATIO",
	//         "AD_REQUESTS_COVERAGE",
	//         "PAGE_VIEWS_CTR",
	//         "AD_REQUESTS_CTR",
	//         "MATCHED_AD_REQUESTS_CTR",
	//         "IMPRESSIONS_CTR",
	//         "INDIVIDUAL_AD_IMPRESSIONS_CTR",
	//         "ACTIVE_VIEW_MEASURABILITY",
	//         "ACTIVE_VIEW_VIEWABILITY",
	//         "ACTIVE_VIEW_TIME",
	//         "ESTIMATED_EARNINGS",
	//         "PAGE_VIEWS_RPM",
	//         "AD_REQUESTS_RPM",
	//         "MATCHED_AD_REQUESTS_RPM",
	//         "IMPRESSIONS_RPM",
	//         "INDIVIDUAL_AD_IMPRESSIONS_RPM",
	//         "COST_PER_CLICK",
	//         "ADS_PER_IMPRESSION",
	//         "TOTAL_EARNINGS",
	//         "WEBSEARCH_RESULT_PAGES"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified metric.",
	//         "Number of page views.",
	//         "Number of ad units that requested ads (for content ads) or search queries (for search ads). An ad request may result in zero, one, or multiple individual ad impressions depending on the size of the ad unit and whether any ads were available.",
	//         "Requests that returned at least one ad.",
	//         "Impressions. An impression is counted for each ad request where at least one ad has been downloaded to the user’s device and has begun to load. It is the number of ad units (for content ads) or search queries (for search ads) that showed ads.",
	//         "Impressions. An impression is counted for each ad request where at least one ad has been downloaded to the user’s device and has begun to load. It is the number of ad units (for content ads) or search queries (for search ads) that showed ads.",
	//         "Ads shown. Different ad formats will display varying numbers of ads. For example, a vertical banner may consist of 2 or more ads. Also, the number of ads in an ad unit may vary depending on whether the ad unit is displaying standard text ads, expanded text ads or image ads.",
	//         "Number of times a user clicked on a standard content ad.",
	//         "Fraction of page views considered to be spam. Only available to premium accounts.",
	//         "Fraction of ad requests considered to be spam. Only available to premium accounts.",
	//         "Fraction of ad requests that returned ads considered to be spam. Only available to premium accounts.",
	//         "Fraction of impressions considered to be spam. Only available to premium accounts.",
	//         "Fraction of ad impressions considered to be spam. Only available to premium accounts.",
	//         "Fraction of clicks considered to be spam. Only available to premium accounts.",
	//         "Ratio of requested ad units or queries to the number returned to the site.",
	//         "Ratio of individual page views that resulted in a click.",
	//         "Ratio of ad requests that resulted in a click.",
	//         "Ratio of clicks to matched requests.",
	//         "Ratio of IMPRESSIONS that resulted in a click.",
	//         "Ratio of individual ad impressions that resulted in a click.",
	//         "Ratio of requests that were measurable for viewability.",
	//         "Ratio of requests that were viewable.",
	//         "Mean time an ad was displayed on screen.",
	//         "Estimated earnings of the publisher. Note that earnings up to yesterday are accurate, more recent earnings are estimated due to the possibility of spam, or exchange rate fluctuations.",
	//         "Revenue per thousand page views. This is calculated by dividing the estimated revenue by the number of page views multiplied by 1000.",
	//         "Revenue per thousand ad requests. This is calculated by dividing estimated revenue by the number of ad requests multiplied by 1000.",
	//         "Revenue per thousand matched ad requests. This is calculated by dividing estimated revenue by the number of matched ad requests multiplied by 1000.",
	//         "Revenue per thousand ad impressions. This is calculated by dividing estimated revenue by the number of ad impressions multiplied by 1000.",
	//         "Revenue per thousand individual ad impressions. This is calculated by dividing estimated revenue by the number of individual ad impressions multiplied by 1000.",
	//         "Amount the publisher earns each time a user clicks on an ad. CPC is calculated by dividing the estimated revenue by the number of clicks received.",
	//         "Number of ad views per impression.",
	//         "Total earnings.",
	//         "Number of results pages."
	//       ],
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "The name of a dimension or metric to sort the resulting report on, can be prefixed with \"+\" to sort ascending or \"-\" to sort descending. If no prefix is specified, the column is sorted ascending.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "reportingTimeZone": {
	//       "description": "Timezone in which to generate the report. If unspecified, this defaults to the account timezone. For more information, see [changing the time zone of your reports](https://support.google.com/adsense/answer/9830725).",
	//       "enum": [
	//         "REPORTING_TIME_ZONE_UNSPECIFIED",
	//         "ACCOUNT_TIME_ZONE",
	//         "GOOGLE_TIME_ZONE"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified timezone.",
	//         "Use the account timezone in the report.",
	//         "Use the Google timezone in the report (America/Los_Angeles)."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "startDate.day": {
	//       "description": "Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "startDate.month": {
	//       "description": "Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "startDate.year": {
	//       "description": "Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     }
	//   },
	//   "path": "v2/{+account}/reports:generate",
	//   "response": {
	//     "$ref": "ReportResult"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// method id "adsense.accounts.reports.generateCsv":

type AccountsReportsGenerateCsvCall struct {
	s            *Service
	account      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GenerateCsv: Generates a csv formatted ad hoc report.
//
// - account: The account which owns the collection of reports. Format:
//   accounts/{account}.
func (r *AccountsReportsService) GenerateCsv(account string) *AccountsReportsGenerateCsvCall {
	c := &AccountsReportsGenerateCsvCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.account = account
	return c
}

// CurrencyCode sets the optional parameter "currencyCode": The ISO-4217
// currency code (https://en.wikipedia.org/wiki/ISO_4217) to use when
// reporting on monetary metrics. Defaults to the account's currency if
// not set.
func (c *AccountsReportsGenerateCsvCall) CurrencyCode(currencyCode string) *AccountsReportsGenerateCsvCall {
	c.urlParams_.Set("currencyCode", currencyCode)
	return c
}

// DateRange sets the optional parameter "dateRange": Date range of the
// report, if unset the range will be considered CUSTOM.
//
// Possible values:
//   "REPORTING_DATE_RANGE_UNSPECIFIED" - Unspecified date range.
//   "CUSTOM" - A custom date range specified using the `start_date` and
// `end_date` fields. This is the default if no ReportingDateRange is
// provided.
//   "TODAY" - Current day.
//   "YESTERDAY" - Yesterday.
//   "MONTH_TO_DATE" - From the start of the current month to the
// current day. e.g. if the current date is 2020-03-12 then the range
// will be [2020-03-01, 2020-03-12].
//   "YEAR_TO_DATE" - From the start of the current year to the current
// day. e.g. if the current date is 2020-03-12 then the range will be
// [2020-01-01, 2020-03-12].
//   "LAST_7_DAYS" - Last 7 days, excluding current day.
//   "LAST_30_DAYS" - Last 30 days, excluding current day.
func (c *AccountsReportsGenerateCsvCall) DateRange(dateRange string) *AccountsReportsGenerateCsvCall {
	c.urlParams_.Set("dateRange", dateRange)
	return c
}

// Dimensions sets the optional parameter "dimensions": Dimensions to
// base the report on.
//
// Possible values:
//   "DIMENSION_UNSPECIFIED" - Unspecified dimension.
//   "DATE" - Date dimension in YYYY-MM-DD format (e.g. "2010-02-10").
//   "WEEK" - Week dimension in YYYY-MM-DD format, representing the
// first day of each week (e.g. "2010-02-08"). The first day of the week
// is determined by the language_code specified in a report generation
// request (so e.g. this would be a Monday for "en-GB" or "es", but a
// Sunday for "en" or "fr-CA").
//   "MONTH" - Month dimension in YYYY-MM format (e.g. "2010-02").
//   "ACCOUNT_NAME" - Account name. The members of this dimension match
// the values from Account.display_name.
//   "AD_CLIENT_ID" - Unique ID of an ad client. The members of this
// dimension match the values from AdClient.reporting_dimension_id.
//   "PRODUCT_NAME" - Localized product name (e.g. "AdSense for
// Content", "AdSense for Search").
//   "PRODUCT_CODE" - Product code (e.g. "AFC", "AFS"). The members of
// this dimension match the values from AdClient.product_code.
//   "AD_UNIT_NAME" - Ad unit name (within which an ad was served). The
// members of this dimension match the values from AdUnit.display_name.
//   "AD_UNIT_ID" - Unique ID of an ad unit (within which an ad was
// served). The members of this dimension match the values from
// AdUnit.reporting_dimension_id.
//   "AD_UNIT_SIZE_NAME" - Localized size of an ad unit (e.g. "728x90",
// "Responsive").
//   "AD_UNIT_SIZE_CODE" - The size code of an ad unit (e.g. "728x90",
// "responsive").
//   "CUSTOM_CHANNEL_NAME" - Custom channel name. The members of this
// dimension match the values from CustomChannel.display_name.
//   "CUSTOM_CHANNEL_ID" - Unique ID of a custom channel. The members of
// this dimension match the values from
// CustomChannel.reporting_dimension_id.
//   "OWNED_SITE_DOMAIN_NAME" - Domain name of a verified site (e.g.
// "example.com"). The members of this dimension match the values from
// Site.domain.
//   "OWNED_SITE_ID" - Unique ID of a verified site. The members of this
// dimension match the values from Site.reporting_dimension_id.
//   "URL_CHANNEL_NAME" - Name of a URL channel. The members of this
// dimension match the values from UrlChannel.uri_pattern.
//   "URL_CHANNEL_ID" - Unique ID of a URL channel. The members of this
// dimension match the values from UrlChannel.reporting_dimension_id.
//   "BUYER_NETWORK_NAME" - Name of an ad network that returned the
// winning ads for an ad request (e.g. "Google AdWords"). Note that
// unlike other "NAME" dimensions, the members of this dimensions are
// not localized.
//   "BUYER_NETWORK_ID" - Unique (opaque) ID of an ad network that
// returned the winning ads for an ad request.
//   "BID_TYPE_NAME" - Localized bid type name (e.g. "CPC bids", "CPM
// bids") for a served ad.
//   "BID_TYPE_CODE" - Type of a bid (e.g. "cpc", "cpm") for a served
// ad.
//   "CREATIVE_SIZE_NAME" - Localized creative size name (e.g. "728x90",
// "Dynamic") of a served ad.
//   "CREATIVE_SIZE_CODE" - Creative size code (e.g. "728x90",
// "dynamic") of a served ad.
//   "DOMAIN_NAME" - Localized name of a host on which an ad was served,
// after IDNA decoding (e.g. "www.google.com", "Web caches and other",
// "bücher.example").
//   "DOMAIN_CODE" - Name of a host on which an ad was served (e.g.
// "www.google.com", "webcaches", "xn--bcher-kva.example").
//   "COUNTRY_NAME" - Localized region name of a user viewing an ad
// (e.g. "United States", "France").
//   "COUNTRY_CODE" - CLDR region code of a user viewing an ad (e.g.
// "US", "FR").
//   "PLATFORM_TYPE_NAME" - Localized platform type name (e.g. "High-end
// mobile devices", "Desktop").
//   "PLATFORM_TYPE_CODE" - Platform type code (e.g. "HighEndMobile",
// "Desktop").
//   "TARGETING_TYPE_NAME" - Localized targeting type name (e.g.
// "Contextual", "Personalized", "Run of Network").
//   "TARGETING_TYPE_CODE" - Targeting type code (e.g. "Keyword",
// "UserInterest", "RunOfNetwork").
//   "CONTENT_PLATFORM_NAME" - Localized content platform name an ad
// request was made from (e.g. "AMP", "Web").
//   "CONTENT_PLATFORM_CODE" - Content platform code an ad request was
// made from (e.g. "AMP", "HTML").
//   "AD_PLACEMENT_NAME" - Localized ad placement name (e.g. "Ad unit",
// "Global settings", "Manual").
//   "AD_PLACEMENT_CODE" - Ad placement code (e.g. "AD_UNIT",
// "ca-pub-123456:78910", "OTHER").
//   "REQUESTED_AD_TYPE_NAME" - Localized requested ad type name (e.g.
// "Display", "Link unit", "Other").
//   "REQUESTED_AD_TYPE_CODE" - Requested ad type code (e.g. "IMAGE",
// "RADLINK", "OTHER").
//   "SERVED_AD_TYPE_NAME" - Localized served ad type name (e.g.
// "Display", "Link unit", "Other").
//   "SERVED_AD_TYPE_CODE" - Served ad type code (e.g. "IMAGE",
// "RADLINK", "OTHER").
//   "CUSTOM_SEARCH_STYLE_NAME" - Custom search style name.
//   "CUSTOM_SEARCH_STYLE_ID" - Custom search style id.
//   "DOMAIN_REGISTRANT" - Domain registrants.
//   "WEBSEARCH_QUERY_STRING" - Query strings for web searches.
func (c *AccountsReportsGenerateCsvCall) Dimensions(dimensions ...string) *AccountsReportsGenerateCsvCall {
	c.urlParams_.SetMulti("dimensions", append([]string{}, dimensions...))
	return c
}

// EndDateDay sets the optional parameter "endDate.day": Day of a month.
// Must be from 1 to 31 and valid for the year and month, or 0 to
// specify a year by itself or a year and month where the day isn't
// significant.
func (c *AccountsReportsGenerateCsvCall) EndDateDay(endDateDay int64) *AccountsReportsGenerateCsvCall {
	c.urlParams_.Set("endDate.day", fmt.Sprint(endDateDay))
	return c
}

// EndDateMonth sets the optional parameter "endDate.month": Month of a
// year. Must be from 1 to 12, or 0 to specify a year without a month
// and day.
func (c *AccountsReportsGenerateCsvCall) EndDateMonth(endDateMonth int64) *AccountsReportsGenerateCsvCall {
	c.urlParams_.Set("endDate.month", fmt.Sprint(endDateMonth))
	return c
}

// EndDateYear sets the optional parameter "endDate.year": Year of the
// date. Must be from 1 to 9999, or 0 to specify a date without a year.
func (c *AccountsReportsGenerateCsvCall) EndDateYear(endDateYear int64) *AccountsReportsGenerateCsvCall {
	c.urlParams_.Set("endDate.year", fmt.Sprint(endDateYear))
	return c
}

// Filters sets the optional parameter "filters": Filters to be run on
// the report.
func (c *AccountsReportsGenerateCsvCall) Filters(filters ...string) *AccountsReportsGenerateCsvCall {
	c.urlParams_.SetMulti("filters", append([]string{}, filters...))
	return c
}

// LanguageCode sets the optional parameter "languageCode": The language
// to use for translating report output. If unspecified, this defaults
// to English ("en"). If the given language is not supported, report
// output will be returned in English. The language is specified as an
// IETF BCP-47 language code
// (https://en.wikipedia.org/wiki/IETF_language_tag).
func (c *AccountsReportsGenerateCsvCall) LanguageCode(languageCode string) *AccountsReportsGenerateCsvCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of rows
// of report data to return. Reports producing more rows than the
// requested limit will be truncated. If unset, this defaults to 100,000
// rows for `Reports.GenerateReport` and 1,000,000 rows for
// `Reports.GenerateCsvReport`, which are also the maximum values
// permitted here. Report truncation can be identified (for
// `Reports.GenerateReport` only) by comparing the number of rows
// returned to the value returned in `total_matched_rows`.
func (c *AccountsReportsGenerateCsvCall) Limit(limit int64) *AccountsReportsGenerateCsvCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// Metrics sets the optional parameter "metrics": Required. Reporting
// metrics.
//
// Possible values:
//   "METRIC_UNSPECIFIED" - Unspecified metric.
//   "PAGE_VIEWS" - Number of page views.
//   "AD_REQUESTS" - Number of ad units that requested ads (for content
// ads) or search queries (for search ads). An ad request may result in
// zero, one, or multiple individual ad impressions depending on the
// size of the ad unit and whether any ads were available.
//   "MATCHED_AD_REQUESTS" - Requests that returned at least one ad.
//   "TOTAL_IMPRESSIONS" - Impressions. An impression is counted for
// each ad request where at least one ad has been downloaded to the
// user’s device and has begun to load. It is the number of ad units
// (for content ads) or search queries (for search ads) that showed ads.
//   "IMPRESSIONS" - Impressions. An impression is counted for each ad
// request where at least one ad has been downloaded to the user’s
// device and has begun to load. It is the number of ad units (for
// content ads) or search queries (for search ads) that showed ads.
//   "INDIVIDUAL_AD_IMPRESSIONS" - Ads shown. Different ad formats will
// display varying numbers of ads. For example, a vertical banner may
// consist of 2 or more ads. Also, the number of ads in an ad unit may
// vary depending on whether the ad unit is displaying standard text
// ads, expanded text ads or image ads.
//   "CLICKS" - Number of times a user clicked on a standard content ad.
//   "PAGE_VIEWS_SPAM_RATIO" - Fraction of page views considered to be
// spam. Only available to premium accounts.
//   "AD_REQUESTS_SPAM_RATIO" - Fraction of ad requests considered to be
// spam. Only available to premium accounts.
//   "MATCHED_AD_REQUESTS_SPAM_RATIO" - Fraction of ad requests that
// returned ads considered to be spam. Only available to premium
// accounts.
//   "IMPRESSIONS_SPAM_RATIO" - Fraction of impressions considered to be
// spam. Only available to premium accounts.
//   "INDIVIDUAL_AD_IMPRESSIONS_SPAM_RATIO" - Fraction of ad impressions
// considered to be spam. Only available to premium accounts.
//   "CLICKS_SPAM_RATIO" - Fraction of clicks considered to be spam.
// Only available to premium accounts.
//   "AD_REQUESTS_COVERAGE" - Ratio of requested ad units or queries to
// the number returned to the site.
//   "PAGE_VIEWS_CTR" - Ratio of individual page views that resulted in
// a click.
//   "AD_REQUESTS_CTR" - Ratio of ad requests that resulted in a click.
//   "MATCHED_AD_REQUESTS_CTR" - Ratio of clicks to matched requests.
//   "IMPRESSIONS_CTR" - Ratio of IMPRESSIONS that resulted in a click.
//   "INDIVIDUAL_AD_IMPRESSIONS_CTR" - Ratio of individual ad
// impressions that resulted in a click.
//   "ACTIVE_VIEW_MEASURABILITY" - Ratio of requests that were
// measurable for viewability.
//   "ACTIVE_VIEW_VIEWABILITY" - Ratio of requests that were viewable.
//   "ACTIVE_VIEW_TIME" - Mean time an ad was displayed on screen.
//   "ESTIMATED_EARNINGS" - Estimated earnings of the publisher. Note
// that earnings up to yesterday are accurate, more recent earnings are
// estimated due to the possibility of spam, or exchange rate
// fluctuations.
//   "PAGE_VIEWS_RPM" - Revenue per thousand page views. This is
// calculated by dividing the estimated revenue by the number of page
// views multiplied by 1000.
//   "AD_REQUESTS_RPM" - Revenue per thousand ad requests. This is
// calculated by dividing estimated revenue by the number of ad requests
// multiplied by 1000.
//   "MATCHED_AD_REQUESTS_RPM" - Revenue per thousand matched ad
// requests. This is calculated by dividing estimated revenue by the
// number of matched ad requests multiplied by 1000.
//   "IMPRESSIONS_RPM" - Revenue per thousand ad impressions. This is
// calculated by dividing estimated revenue by the number of ad
// impressions multiplied by 1000.
//   "INDIVIDUAL_AD_IMPRESSIONS_RPM" - Revenue per thousand individual
// ad impressions. This is calculated by dividing estimated revenue by
// the number of individual ad impressions multiplied by 1000.
//   "COST_PER_CLICK" - Amount the publisher earns each time a user
// clicks on an ad. CPC is calculated by dividing the estimated revenue
// by the number of clicks received.
//   "ADS_PER_IMPRESSION" - Number of ad views per impression.
//   "TOTAL_EARNINGS" - Total earnings.
//   "WEBSEARCH_RESULT_PAGES" - Number of results pages.
func (c *AccountsReportsGenerateCsvCall) Metrics(metrics ...string) *AccountsReportsGenerateCsvCall {
	c.urlParams_.SetMulti("metrics", append([]string{}, metrics...))
	return c
}

// OrderBy sets the optional parameter "orderBy": The name of a
// dimension or metric to sort the resulting report on, can be prefixed
// with "+" to sort ascending or "-" to sort descending. If no prefix is
// specified, the column is sorted ascending.
func (c *AccountsReportsGenerateCsvCall) OrderBy(orderBy ...string) *AccountsReportsGenerateCsvCall {
	c.urlParams_.SetMulti("orderBy", append([]string{}, orderBy...))
	return c
}

// ReportingTimeZone sets the optional parameter "reportingTimeZone":
// Timezone in which to generate the report. If unspecified, this
// defaults to the account timezone. For more information, see changing
// the time zone of your reports
// (https://support.google.com/adsense/answer/9830725).
//
// Possible values:
//   "REPORTING_TIME_ZONE_UNSPECIFIED" - Unspecified timezone.
//   "ACCOUNT_TIME_ZONE" - Use the account timezone in the report.
//   "GOOGLE_TIME_ZONE" - Use the Google timezone in the report
// (America/Los_Angeles).
func (c *AccountsReportsGenerateCsvCall) ReportingTimeZone(reportingTimeZone string) *AccountsReportsGenerateCsvCall {
	c.urlParams_.Set("reportingTimeZone", reportingTimeZone)
	return c
}

// StartDateDay sets the optional parameter "startDate.day": Day of a
// month. Must be from 1 to 31 and valid for the year and month, or 0 to
// specify a year by itself or a year and month where the day isn't
// significant.
func (c *AccountsReportsGenerateCsvCall) StartDateDay(startDateDay int64) *AccountsReportsGenerateCsvCall {
	c.urlParams_.Set("startDate.day", fmt.Sprint(startDateDay))
	return c
}

// StartDateMonth sets the optional parameter "startDate.month": Month
// of a year. Must be from 1 to 12, or 0 to specify a year without a
// month and day.
func (c *AccountsReportsGenerateCsvCall) StartDateMonth(startDateMonth int64) *AccountsReportsGenerateCsvCall {
	c.urlParams_.Set("startDate.month", fmt.Sprint(startDateMonth))
	return c
}

// StartDateYear sets the optional parameter "startDate.year": Year of
// the date. Must be from 1 to 9999, or 0 to specify a date without a
// year.
func (c *AccountsReportsGenerateCsvCall) StartDateYear(startDateYear int64) *AccountsReportsGenerateCsvCall {
	c.urlParams_.Set("startDate.year", fmt.Sprint(startDateYear))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsReportsGenerateCsvCall) Fields(s ...googleapi.Field) *AccountsReportsGenerateCsvCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsReportsGenerateCsvCall) IfNoneMatch(entityTag string) *AccountsReportsGenerateCsvCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsReportsGenerateCsvCall) Context(ctx context.Context) *AccountsReportsGenerateCsvCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsReportsGenerateCsvCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsReportsGenerateCsvCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+account}/reports:generateCsv")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"account": c.account,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.reports.generateCsv" call.
// Exactly one of *HttpBody or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *HttpBody.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsReportsGenerateCsvCall) Do(opts ...googleapi.CallOption) (*HttpBody, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &HttpBody{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Generates a csv formatted ad hoc report.",
	//   "flatPath": "v2/accounts/{accountsId}/reports:generateCsv",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.reports.generateCsv",
	//   "parameterOrder": [
	//     "account"
	//   ],
	//   "parameters": {
	//     "account": {
	//       "description": "Required. The account which owns the collection of reports. Format: accounts/{account}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "currencyCode": {
	//       "description": "The [ISO-4217 currency code](https://en.wikipedia.org/wiki/ISO_4217) to use when reporting on monetary metrics. Defaults to the account's currency if not set.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "dateRange": {
	//       "description": "Date range of the report, if unset the range will be considered CUSTOM.",
	//       "enum": [
	//         "REPORTING_DATE_RANGE_UNSPECIFIED",
	//         "CUSTOM",
	//         "TODAY",
	//         "YESTERDAY",
	//         "MONTH_TO_DATE",
	//         "YEAR_TO_DATE",
	//         "LAST_7_DAYS",
	//         "LAST_30_DAYS"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified date range.",
	//         "A custom date range specified using the `start_date` and `end_date` fields. This is the default if no ReportingDateRange is provided.",
	//         "Current day.",
	//         "Yesterday.",
	//         "From the start of the current month to the current day. e.g. if the current date is 2020-03-12 then the range will be [2020-03-01, 2020-03-12].",
	//         "From the start of the current year to the current day. e.g. if the current date is 2020-03-12 then the range will be [2020-01-01, 2020-03-12].",
	//         "Last 7 days, excluding current day.",
	//         "Last 30 days, excluding current day."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "dimensions": {
	//       "description": "Dimensions to base the report on.",
	//       "enum": [
	//         "DIMENSION_UNSPECIFIED",
	//         "DATE",
	//         "WEEK",
	//         "MONTH",
	//         "ACCOUNT_NAME",
	//         "AD_CLIENT_ID",
	//         "PRODUCT_NAME",
	//         "PRODUCT_CODE",
	//         "AD_UNIT_NAME",
	//         "AD_UNIT_ID",
	//         "AD_UNIT_SIZE_NAME",
	//         "AD_UNIT_SIZE_CODE",
	//         "CUSTOM_CHANNEL_NAME",
	//         "CUSTOM_CHANNEL_ID",
	//         "OWNED_SITE_DOMAIN_NAME",
	//         "OWNED_SITE_ID",
	//         "URL_CHANNEL_NAME",
	//         "URL_CHANNEL_ID",
	//         "BUYER_NETWORK_NAME",
	//         "BUYER_NETWORK_ID",
	//         "BID_TYPE_NAME",
	//         "BID_TYPE_CODE",
	//         "CREATIVE_SIZE_NAME",
	//         "CREATIVE_SIZE_CODE",
	//         "DOMAIN_NAME",
	//         "DOMAIN_CODE",
	//         "COUNTRY_NAME",
	//         "COUNTRY_CODE",
	//         "PLATFORM_TYPE_NAME",
	//         "PLATFORM_TYPE_CODE",
	//         "TARGETING_TYPE_NAME",
	//         "TARGETING_TYPE_CODE",
	//         "CONTENT_PLATFORM_NAME",
	//         "CONTENT_PLATFORM_CODE",
	//         "AD_PLACEMENT_NAME",
	//         "AD_PLACEMENT_CODE",
	//         "REQUESTED_AD_TYPE_NAME",
	//         "REQUESTED_AD_TYPE_CODE",
	//         "SERVED_AD_TYPE_NAME",
	//         "SERVED_AD_TYPE_CODE",
	//         "CUSTOM_SEARCH_STYLE_NAME",
	//         "CUSTOM_SEARCH_STYLE_ID",
	//         "DOMAIN_REGISTRANT",
	//         "WEBSEARCH_QUERY_STRING"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified dimension.",
	//         "Date dimension in YYYY-MM-DD format (e.g. \"2010-02-10\").",
	//         "Week dimension in YYYY-MM-DD format, representing the first day of each week (e.g. \"2010-02-08\"). The first day of the week is determined by the language_code specified in a report generation request (so e.g. this would be a Monday for \"en-GB\" or \"es\", but a Sunday for \"en\" or \"fr-CA\").",
	//         "Month dimension in YYYY-MM format (e.g. \"2010-02\").",
	//         "Account name. The members of this dimension match the values from Account.display_name.",
	//         "Unique ID of an ad client. The members of this dimension match the values from AdClient.reporting_dimension_id.",
	//         "Localized product name (e.g. \"AdSense for Content\", \"AdSense for Search\").",
	//         "Product code (e.g. \"AFC\", \"AFS\"). The members of this dimension match the values from AdClient.product_code.",
	//         "Ad unit name (within which an ad was served). The members of this dimension match the values from AdUnit.display_name.",
	//         "Unique ID of an ad unit (within which an ad was served). The members of this dimension match the values from AdUnit.reporting_dimension_id.",
	//         "Localized size of an ad unit (e.g. \"728x90\", \"Responsive\").",
	//         "The size code of an ad unit (e.g. \"728x90\", \"responsive\").",
	//         "Custom channel name. The members of this dimension match the values from CustomChannel.display_name.",
	//         "Unique ID of a custom channel. The members of this dimension match the values from CustomChannel.reporting_dimension_id.",
	//         "Domain name of a verified site (e.g. \"example.com\"). The members of this dimension match the values from Site.domain.",
	//         "Unique ID of a verified site. The members of this dimension match the values from Site.reporting_dimension_id.",
	//         "Name of a URL channel. The members of this dimension match the values from UrlChannel.uri_pattern.",
	//         "Unique ID of a URL channel. The members of this dimension match the values from UrlChannel.reporting_dimension_id.",
	//         "Name of an ad network that returned the winning ads for an ad request (e.g. \"Google AdWords\"). Note that unlike other \"NAME\" dimensions, the members of this dimensions are not localized.",
	//         "Unique (opaque) ID of an ad network that returned the winning ads for an ad request.",
	//         "Localized bid type name (e.g. \"CPC bids\", \"CPM bids\") for a served ad.",
	//         "Type of a bid (e.g. \"cpc\", \"cpm\") for a served ad.",
	//         "Localized creative size name (e.g. \"728x90\", \"Dynamic\") of a served ad.",
	//         "Creative size code (e.g. \"728x90\", \"dynamic\") of a served ad.",
	//         "Localized name of a host on which an ad was served, after IDNA decoding (e.g. \"www.google.com\", \"Web caches and other\", \"bücher.example\").",
	//         "Name of a host on which an ad was served (e.g. \"www.google.com\", \"webcaches\", \"xn--bcher-kva.example\").",
	//         "Localized region name of a user viewing an ad (e.g. \"United States\", \"France\").",
	//         "CLDR region code of a user viewing an ad (e.g. \"US\", \"FR\").",
	//         "Localized platform type name (e.g. \"High-end mobile devices\", \"Desktop\").",
	//         "Platform type code (e.g. \"HighEndMobile\", \"Desktop\").",
	//         "Localized targeting type name (e.g. \"Contextual\", \"Personalized\", \"Run of Network\").",
	//         "Targeting type code (e.g. \"Keyword\", \"UserInterest\", \"RunOfNetwork\").",
	//         "Localized content platform name an ad request was made from (e.g. \"AMP\", \"Web\").",
	//         "Content platform code an ad request was made from (e.g. \"AMP\", \"HTML\").",
	//         "Localized ad placement name (e.g. \"Ad unit\", \"Global settings\", \"Manual\").",
	//         "Ad placement code (e.g. \"AD_UNIT\", \"ca-pub-123456:78910\", \"OTHER\").",
	//         "Localized requested ad type name (e.g. \"Display\", \"Link unit\", \"Other\").",
	//         "Requested ad type code (e.g. \"IMAGE\", \"RADLINK\", \"OTHER\").",
	//         "Localized served ad type name (e.g. \"Display\", \"Link unit\", \"Other\").",
	//         "Served ad type code (e.g. \"IMAGE\", \"RADLINK\", \"OTHER\").",
	//         "Custom search style name.",
	//         "Custom search style id.",
	//         "Domain registrants.",
	//         "Query strings for web searches."
	//       ],
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "endDate.day": {
	//       "description": "Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "endDate.month": {
	//       "description": "Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "endDate.year": {
	//       "description": "Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "filters": {
	//       "description": "Filters to be run on the report.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "languageCode": {
	//       "description": "The language to use for translating report output. If unspecified, this defaults to English (\"en\"). If the given language is not supported, report output will be returned in English. The language is specified as an [IETF BCP-47 language code](https://en.wikipedia.org/wiki/IETF_language_tag).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "limit": {
	//       "description": "The maximum number of rows of report data to return. Reports producing more rows than the requested limit will be truncated. If unset, this defaults to 100,000 rows for `Reports.GenerateReport` and 1,000,000 rows for `Reports.GenerateCsvReport`, which are also the maximum values permitted here. Report truncation can be identified (for `Reports.GenerateReport` only) by comparing the number of rows returned to the value returned in `total_matched_rows`.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "metrics": {
	//       "description": "Required. Reporting metrics.",
	//       "enum": [
	//         "METRIC_UNSPECIFIED",
	//         "PAGE_VIEWS",
	//         "AD_REQUESTS",
	//         "MATCHED_AD_REQUESTS",
	//         "TOTAL_IMPRESSIONS",
	//         "IMPRESSIONS",
	//         "INDIVIDUAL_AD_IMPRESSIONS",
	//         "CLICKS",
	//         "PAGE_VIEWS_SPAM_RATIO",
	//         "AD_REQUESTS_SPAM_RATIO",
	//         "MATCHED_AD_REQUESTS_SPAM_RATIO",
	//         "IMPRESSIONS_SPAM_RATIO",
	//         "INDIVIDUAL_AD_IMPRESSIONS_SPAM_RATIO",
	//         "CLICKS_SPAM_RATIO",
	//         "AD_REQUESTS_COVERAGE",
	//         "PAGE_VIEWS_CTR",
	//         "AD_REQUESTS_CTR",
	//         "MATCHED_AD_REQUESTS_CTR",
	//         "IMPRESSIONS_CTR",
	//         "INDIVIDUAL_AD_IMPRESSIONS_CTR",
	//         "ACTIVE_VIEW_MEASURABILITY",
	//         "ACTIVE_VIEW_VIEWABILITY",
	//         "ACTIVE_VIEW_TIME",
	//         "ESTIMATED_EARNINGS",
	//         "PAGE_VIEWS_RPM",
	//         "AD_REQUESTS_RPM",
	//         "MATCHED_AD_REQUESTS_RPM",
	//         "IMPRESSIONS_RPM",
	//         "INDIVIDUAL_AD_IMPRESSIONS_RPM",
	//         "COST_PER_CLICK",
	//         "ADS_PER_IMPRESSION",
	//         "TOTAL_EARNINGS",
	//         "WEBSEARCH_RESULT_PAGES"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified metric.",
	//         "Number of page views.",
	//         "Number of ad units that requested ads (for content ads) or search queries (for search ads). An ad request may result in zero, one, or multiple individual ad impressions depending on the size of the ad unit and whether any ads were available.",
	//         "Requests that returned at least one ad.",
	//         "Impressions. An impression is counted for each ad request where at least one ad has been downloaded to the user’s device and has begun to load. It is the number of ad units (for content ads) or search queries (for search ads) that showed ads.",
	//         "Impressions. An impression is counted for each ad request where at least one ad has been downloaded to the user’s device and has begun to load. It is the number of ad units (for content ads) or search queries (for search ads) that showed ads.",
	//         "Ads shown. Different ad formats will display varying numbers of ads. For example, a vertical banner may consist of 2 or more ads. Also, the number of ads in an ad unit may vary depending on whether the ad unit is displaying standard text ads, expanded text ads or image ads.",
	//         "Number of times a user clicked on a standard content ad.",
	//         "Fraction of page views considered to be spam. Only available to premium accounts.",
	//         "Fraction of ad requests considered to be spam. Only available to premium accounts.",
	//         "Fraction of ad requests that returned ads considered to be spam. Only available to premium accounts.",
	//         "Fraction of impressions considered to be spam. Only available to premium accounts.",
	//         "Fraction of ad impressions considered to be spam. Only available to premium accounts.",
	//         "Fraction of clicks considered to be spam. Only available to premium accounts.",
	//         "Ratio of requested ad units or queries to the number returned to the site.",
	//         "Ratio of individual page views that resulted in a click.",
	//         "Ratio of ad requests that resulted in a click.",
	//         "Ratio of clicks to matched requests.",
	//         "Ratio of IMPRESSIONS that resulted in a click.",
	//         "Ratio of individual ad impressions that resulted in a click.",
	//         "Ratio of requests that were measurable for viewability.",
	//         "Ratio of requests that were viewable.",
	//         "Mean time an ad was displayed on screen.",
	//         "Estimated earnings of the publisher. Note that earnings up to yesterday are accurate, more recent earnings are estimated due to the possibility of spam, or exchange rate fluctuations.",
	//         "Revenue per thousand page views. This is calculated by dividing the estimated revenue by the number of page views multiplied by 1000.",
	//         "Revenue per thousand ad requests. This is calculated by dividing estimated revenue by the number of ad requests multiplied by 1000.",
	//         "Revenue per thousand matched ad requests. This is calculated by dividing estimated revenue by the number of matched ad requests multiplied by 1000.",
	//         "Revenue per thousand ad impressions. This is calculated by dividing estimated revenue by the number of ad impressions multiplied by 1000.",
	//         "Revenue per thousand individual ad impressions. This is calculated by dividing estimated revenue by the number of individual ad impressions multiplied by 1000.",
	//         "Amount the publisher earns each time a user clicks on an ad. CPC is calculated by dividing the estimated revenue by the number of clicks received.",
	//         "Number of ad views per impression.",
	//         "Total earnings.",
	//         "Number of results pages."
	//       ],
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "The name of a dimension or metric to sort the resulting report on, can be prefixed with \"+\" to sort ascending or \"-\" to sort descending. If no prefix is specified, the column is sorted ascending.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "reportingTimeZone": {
	//       "description": "Timezone in which to generate the report. If unspecified, this defaults to the account timezone. For more information, see [changing the time zone of your reports](https://support.google.com/adsense/answer/9830725).",
	//       "enum": [
	//         "REPORTING_TIME_ZONE_UNSPECIFIED",
	//         "ACCOUNT_TIME_ZONE",
	//         "GOOGLE_TIME_ZONE"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified timezone.",
	//         "Use the account timezone in the report.",
	//         "Use the Google timezone in the report (America/Los_Angeles)."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "startDate.day": {
	//       "description": "Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "startDate.month": {
	//       "description": "Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "startDate.year": {
	//       "description": "Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     }
	//   },
	//   "path": "v2/{+account}/reports:generateCsv",
	//   "response": {
	//     "$ref": "HttpBody"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// method id "adsense.accounts.reports.saved.generate":

type AccountsReportsSavedGenerateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Generate: Generates a saved report.
//
// - name: Name of the saved report. Format:
//   accounts/{account}/reports/{report}.
func (r *AccountsReportsSavedService) Generate(name string) *AccountsReportsSavedGenerateCall {
	c := &AccountsReportsSavedGenerateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// CurrencyCode sets the optional parameter "currencyCode": The ISO-4217
// currency code (https://en.wikipedia.org/wiki/ISO_4217) to use when
// reporting on monetary metrics. Defaults to the account's currency if
// not set.
func (c *AccountsReportsSavedGenerateCall) CurrencyCode(currencyCode string) *AccountsReportsSavedGenerateCall {
	c.urlParams_.Set("currencyCode", currencyCode)
	return c
}

// DateRange sets the optional parameter "dateRange": Date range of the
// report, if unset the range will be considered CUSTOM.
//
// Possible values:
//   "REPORTING_DATE_RANGE_UNSPECIFIED" - Unspecified date range.
//   "CUSTOM" - A custom date range specified using the `start_date` and
// `end_date` fields. This is the default if no ReportingDateRange is
// provided.
//   "TODAY" - Current day.
//   "YESTERDAY" - Yesterday.
//   "MONTH_TO_DATE" - From the start of the current month to the
// current day. e.g. if the current date is 2020-03-12 then the range
// will be [2020-03-01, 2020-03-12].
//   "YEAR_TO_DATE" - From the start of the current year to the current
// day. e.g. if the current date is 2020-03-12 then the range will be
// [2020-01-01, 2020-03-12].
//   "LAST_7_DAYS" - Last 7 days, excluding current day.
//   "LAST_30_DAYS" - Last 30 days, excluding current day.
func (c *AccountsReportsSavedGenerateCall) DateRange(dateRange string) *AccountsReportsSavedGenerateCall {
	c.urlParams_.Set("dateRange", dateRange)
	return c
}

// EndDateDay sets the optional parameter "endDate.day": Day of a month.
// Must be from 1 to 31 and valid for the year and month, or 0 to
// specify a year by itself or a year and month where the day isn't
// significant.
func (c *AccountsReportsSavedGenerateCall) EndDateDay(endDateDay int64) *AccountsReportsSavedGenerateCall {
	c.urlParams_.Set("endDate.day", fmt.Sprint(endDateDay))
	return c
}

// EndDateMonth sets the optional parameter "endDate.month": Month of a
// year. Must be from 1 to 12, or 0 to specify a year without a month
// and day.
func (c *AccountsReportsSavedGenerateCall) EndDateMonth(endDateMonth int64) *AccountsReportsSavedGenerateCall {
	c.urlParams_.Set("endDate.month", fmt.Sprint(endDateMonth))
	return c
}

// EndDateYear sets the optional parameter "endDate.year": Year of the
// date. Must be from 1 to 9999, or 0 to specify a date without a year.
func (c *AccountsReportsSavedGenerateCall) EndDateYear(endDateYear int64) *AccountsReportsSavedGenerateCall {
	c.urlParams_.Set("endDate.year", fmt.Sprint(endDateYear))
	return c
}

// LanguageCode sets the optional parameter "languageCode": The language
// to use for translating report output. If unspecified, this defaults
// to English ("en"). If the given language is not supported, report
// output will be returned in English. The language is specified as an
// IETF BCP-47 language code
// (https://en.wikipedia.org/wiki/IETF_language_tag).
func (c *AccountsReportsSavedGenerateCall) LanguageCode(languageCode string) *AccountsReportsSavedGenerateCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// ReportingTimeZone sets the optional parameter "reportingTimeZone":
// Timezone in which to generate the report. If unspecified, this
// defaults to the account timezone. For more information, see changing
// the time zone of your reports
// (https://support.google.com/adsense/answer/9830725).
//
// Possible values:
//   "REPORTING_TIME_ZONE_UNSPECIFIED" - Unspecified timezone.
//   "ACCOUNT_TIME_ZONE" - Use the account timezone in the report.
//   "GOOGLE_TIME_ZONE" - Use the Google timezone in the report
// (America/Los_Angeles).
func (c *AccountsReportsSavedGenerateCall) ReportingTimeZone(reportingTimeZone string) *AccountsReportsSavedGenerateCall {
	c.urlParams_.Set("reportingTimeZone", reportingTimeZone)
	return c
}

// StartDateDay sets the optional parameter "startDate.day": Day of a
// month. Must be from 1 to 31 and valid for the year and month, or 0 to
// specify a year by itself or a year and month where the day isn't
// significant.
func (c *AccountsReportsSavedGenerateCall) StartDateDay(startDateDay int64) *AccountsReportsSavedGenerateCall {
	c.urlParams_.Set("startDate.day", fmt.Sprint(startDateDay))
	return c
}

// StartDateMonth sets the optional parameter "startDate.month": Month
// of a year. Must be from 1 to 12, or 0 to specify a year without a
// month and day.
func (c *AccountsReportsSavedGenerateCall) StartDateMonth(startDateMonth int64) *AccountsReportsSavedGenerateCall {
	c.urlParams_.Set("startDate.month", fmt.Sprint(startDateMonth))
	return c
}

// StartDateYear sets the optional parameter "startDate.year": Year of
// the date. Must be from 1 to 9999, or 0 to specify a date without a
// year.
func (c *AccountsReportsSavedGenerateCall) StartDateYear(startDateYear int64) *AccountsReportsSavedGenerateCall {
	c.urlParams_.Set("startDate.year", fmt.Sprint(startDateYear))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsReportsSavedGenerateCall) Fields(s ...googleapi.Field) *AccountsReportsSavedGenerateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsReportsSavedGenerateCall) IfNoneMatch(entityTag string) *AccountsReportsSavedGenerateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsReportsSavedGenerateCall) Context(ctx context.Context) *AccountsReportsSavedGenerateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsReportsSavedGenerateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsReportsSavedGenerateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/saved:generate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.reports.saved.generate" call.
// Exactly one of *ReportResult or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *ReportResult.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsReportsSavedGenerateCall) Do(opts ...googleapi.CallOption) (*ReportResult, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ReportResult{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Generates a saved report.",
	//   "flatPath": "v2/accounts/{accountsId}/reports/{reportsId}/saved:generate",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.reports.saved.generate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "currencyCode": {
	//       "description": "The [ISO-4217 currency code](https://en.wikipedia.org/wiki/ISO_4217) to use when reporting on monetary metrics. Defaults to the account's currency if not set.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "dateRange": {
	//       "description": "Date range of the report, if unset the range will be considered CUSTOM.",
	//       "enum": [
	//         "REPORTING_DATE_RANGE_UNSPECIFIED",
	//         "CUSTOM",
	//         "TODAY",
	//         "YESTERDAY",
	//         "MONTH_TO_DATE",
	//         "YEAR_TO_DATE",
	//         "LAST_7_DAYS",
	//         "LAST_30_DAYS"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified date range.",
	//         "A custom date range specified using the `start_date` and `end_date` fields. This is the default if no ReportingDateRange is provided.",
	//         "Current day.",
	//         "Yesterday.",
	//         "From the start of the current month to the current day. e.g. if the current date is 2020-03-12 then the range will be [2020-03-01, 2020-03-12].",
	//         "From the start of the current year to the current day. e.g. if the current date is 2020-03-12 then the range will be [2020-01-01, 2020-03-12].",
	//         "Last 7 days, excluding current day.",
	//         "Last 30 days, excluding current day."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "endDate.day": {
	//       "description": "Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "endDate.month": {
	//       "description": "Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "endDate.year": {
	//       "description": "Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "languageCode": {
	//       "description": "The language to use for translating report output. If unspecified, this defaults to English (\"en\"). If the given language is not supported, report output will be returned in English. The language is specified as an [IETF BCP-47 language code](https://en.wikipedia.org/wiki/IETF_language_tag).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. Name of the saved report. Format: accounts/{account}/reports/{report}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/reports/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "reportingTimeZone": {
	//       "description": "Timezone in which to generate the report. If unspecified, this defaults to the account timezone. For more information, see [changing the time zone of your reports](https://support.google.com/adsense/answer/9830725).",
	//       "enum": [
	//         "REPORTING_TIME_ZONE_UNSPECIFIED",
	//         "ACCOUNT_TIME_ZONE",
	//         "GOOGLE_TIME_ZONE"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified timezone.",
	//         "Use the account timezone in the report.",
	//         "Use the Google timezone in the report (America/Los_Angeles)."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "startDate.day": {
	//       "description": "Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "startDate.month": {
	//       "description": "Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "startDate.year": {
	//       "description": "Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     }
	//   },
	//   "path": "v2/{+name}/saved:generate",
	//   "response": {
	//     "$ref": "ReportResult"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// method id "adsense.accounts.reports.saved.generateCsv":

type AccountsReportsSavedGenerateCsvCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GenerateCsv: Generates a csv formatted saved report.
//
// - name: Name of the saved report. Format:
//   accounts/{account}/reports/{report}.
func (r *AccountsReportsSavedService) GenerateCsv(name string) *AccountsReportsSavedGenerateCsvCall {
	c := &AccountsReportsSavedGenerateCsvCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// CurrencyCode sets the optional parameter "currencyCode": The ISO-4217
// currency code (https://en.wikipedia.org/wiki/ISO_4217) to use when
// reporting on monetary metrics. Defaults to the account's currency if
// not set.
func (c *AccountsReportsSavedGenerateCsvCall) CurrencyCode(currencyCode string) *AccountsReportsSavedGenerateCsvCall {
	c.urlParams_.Set("currencyCode", currencyCode)
	return c
}

// DateRange sets the optional parameter "dateRange": Date range of the
// report, if unset the range will be considered CUSTOM.
//
// Possible values:
//   "REPORTING_DATE_RANGE_UNSPECIFIED" - Unspecified date range.
//   "CUSTOM" - A custom date range specified using the `start_date` and
// `end_date` fields. This is the default if no ReportingDateRange is
// provided.
//   "TODAY" - Current day.
//   "YESTERDAY" - Yesterday.
//   "MONTH_TO_DATE" - From the start of the current month to the
// current day. e.g. if the current date is 2020-03-12 then the range
// will be [2020-03-01, 2020-03-12].
//   "YEAR_TO_DATE" - From the start of the current year to the current
// day. e.g. if the current date is 2020-03-12 then the range will be
// [2020-01-01, 2020-03-12].
//   "LAST_7_DAYS" - Last 7 days, excluding current day.
//   "LAST_30_DAYS" - Last 30 days, excluding current day.
func (c *AccountsReportsSavedGenerateCsvCall) DateRange(dateRange string) *AccountsReportsSavedGenerateCsvCall {
	c.urlParams_.Set("dateRange", dateRange)
	return c
}

// EndDateDay sets the optional parameter "endDate.day": Day of a month.
// Must be from 1 to 31 and valid for the year and month, or 0 to
// specify a year by itself or a year and month where the day isn't
// significant.
func (c *AccountsReportsSavedGenerateCsvCall) EndDateDay(endDateDay int64) *AccountsReportsSavedGenerateCsvCall {
	c.urlParams_.Set("endDate.day", fmt.Sprint(endDateDay))
	return c
}

// EndDateMonth sets the optional parameter "endDate.month": Month of a
// year. Must be from 1 to 12, or 0 to specify a year without a month
// and day.
func (c *AccountsReportsSavedGenerateCsvCall) EndDateMonth(endDateMonth int64) *AccountsReportsSavedGenerateCsvCall {
	c.urlParams_.Set("endDate.month", fmt.Sprint(endDateMonth))
	return c
}

// EndDateYear sets the optional parameter "endDate.year": Year of the
// date. Must be from 1 to 9999, or 0 to specify a date without a year.
func (c *AccountsReportsSavedGenerateCsvCall) EndDateYear(endDateYear int64) *AccountsReportsSavedGenerateCsvCall {
	c.urlParams_.Set("endDate.year", fmt.Sprint(endDateYear))
	return c
}

// LanguageCode sets the optional parameter "languageCode": The language
// to use for translating report output. If unspecified, this defaults
// to English ("en"). If the given language is not supported, report
// output will be returned in English. The language is specified as an
// IETF BCP-47 language code
// (https://en.wikipedia.org/wiki/IETF_language_tag).
func (c *AccountsReportsSavedGenerateCsvCall) LanguageCode(languageCode string) *AccountsReportsSavedGenerateCsvCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// ReportingTimeZone sets the optional parameter "reportingTimeZone":
// Timezone in which to generate the report. If unspecified, this
// defaults to the account timezone. For more information, see changing
// the time zone of your reports
// (https://support.google.com/adsense/answer/9830725).
//
// Possible values:
//   "REPORTING_TIME_ZONE_UNSPECIFIED" - Unspecified timezone.
//   "ACCOUNT_TIME_ZONE" - Use the account timezone in the report.
//   "GOOGLE_TIME_ZONE" - Use the Google timezone in the report
// (America/Los_Angeles).
func (c *AccountsReportsSavedGenerateCsvCall) ReportingTimeZone(reportingTimeZone string) *AccountsReportsSavedGenerateCsvCall {
	c.urlParams_.Set("reportingTimeZone", reportingTimeZone)
	return c
}

// StartDateDay sets the optional parameter "startDate.day": Day of a
// month. Must be from 1 to 31 and valid for the year and month, or 0 to
// specify a year by itself or a year and month where the day isn't
// significant.
func (c *AccountsReportsSavedGenerateCsvCall) StartDateDay(startDateDay int64) *AccountsReportsSavedGenerateCsvCall {
	c.urlParams_.Set("startDate.day", fmt.Sprint(startDateDay))
	return c
}

// StartDateMonth sets the optional parameter "startDate.month": Month
// of a year. Must be from 1 to 12, or 0 to specify a year without a
// month and day.
func (c *AccountsReportsSavedGenerateCsvCall) StartDateMonth(startDateMonth int64) *AccountsReportsSavedGenerateCsvCall {
	c.urlParams_.Set("startDate.month", fmt.Sprint(startDateMonth))
	return c
}

// StartDateYear sets the optional parameter "startDate.year": Year of
// the date. Must be from 1 to 9999, or 0 to specify a date without a
// year.
func (c *AccountsReportsSavedGenerateCsvCall) StartDateYear(startDateYear int64) *AccountsReportsSavedGenerateCsvCall {
	c.urlParams_.Set("startDate.year", fmt.Sprint(startDateYear))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsReportsSavedGenerateCsvCall) Fields(s ...googleapi.Field) *AccountsReportsSavedGenerateCsvCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsReportsSavedGenerateCsvCall) IfNoneMatch(entityTag string) *AccountsReportsSavedGenerateCsvCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsReportsSavedGenerateCsvCall) Context(ctx context.Context) *AccountsReportsSavedGenerateCsvCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsReportsSavedGenerateCsvCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsReportsSavedGenerateCsvCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/saved:generateCsv")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.reports.saved.generateCsv" call.
// Exactly one of *HttpBody or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *HttpBody.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsReportsSavedGenerateCsvCall) Do(opts ...googleapi.CallOption) (*HttpBody, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &HttpBody{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Generates a csv formatted saved report.",
	//   "flatPath": "v2/accounts/{accountsId}/reports/{reportsId}/saved:generateCsv",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.reports.saved.generateCsv",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "currencyCode": {
	//       "description": "The [ISO-4217 currency code](https://en.wikipedia.org/wiki/ISO_4217) to use when reporting on monetary metrics. Defaults to the account's currency if not set.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "dateRange": {
	//       "description": "Date range of the report, if unset the range will be considered CUSTOM.",
	//       "enum": [
	//         "REPORTING_DATE_RANGE_UNSPECIFIED",
	//         "CUSTOM",
	//         "TODAY",
	//         "YESTERDAY",
	//         "MONTH_TO_DATE",
	//         "YEAR_TO_DATE",
	//         "LAST_7_DAYS",
	//         "LAST_30_DAYS"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified date range.",
	//         "A custom date range specified using the `start_date` and `end_date` fields. This is the default if no ReportingDateRange is provided.",
	//         "Current day.",
	//         "Yesterday.",
	//         "From the start of the current month to the current day. e.g. if the current date is 2020-03-12 then the range will be [2020-03-01, 2020-03-12].",
	//         "From the start of the current year to the current day. e.g. if the current date is 2020-03-12 then the range will be [2020-01-01, 2020-03-12].",
	//         "Last 7 days, excluding current day.",
	//         "Last 30 days, excluding current day."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "endDate.day": {
	//       "description": "Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "endDate.month": {
	//       "description": "Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "endDate.year": {
	//       "description": "Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "languageCode": {
	//       "description": "The language to use for translating report output. If unspecified, this defaults to English (\"en\"). If the given language is not supported, report output will be returned in English. The language is specified as an [IETF BCP-47 language code](https://en.wikipedia.org/wiki/IETF_language_tag).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. Name of the saved report. Format: accounts/{account}/reports/{report}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/reports/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "reportingTimeZone": {
	//       "description": "Timezone in which to generate the report. If unspecified, this defaults to the account timezone. For more information, see [changing the time zone of your reports](https://support.google.com/adsense/answer/9830725).",
	//       "enum": [
	//         "REPORTING_TIME_ZONE_UNSPECIFIED",
	//         "ACCOUNT_TIME_ZONE",
	//         "GOOGLE_TIME_ZONE"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified timezone.",
	//         "Use the account timezone in the report.",
	//         "Use the Google timezone in the report (America/Los_Angeles)."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "startDate.day": {
	//       "description": "Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "startDate.month": {
	//       "description": "Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "startDate.year": {
	//       "description": "Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     }
	//   },
	//   "path": "v2/{+name}/saved:generateCsv",
	//   "response": {
	//     "$ref": "HttpBody"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// method id "adsense.accounts.reports.saved.list":

type AccountsReportsSavedListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists saved reports.
//
// - parent: The account which owns the collection of reports. Format:
//   accounts/{account}.
func (r *AccountsReportsSavedService) List(parent string) *AccountsReportsSavedListCall {
	c := &AccountsReportsSavedListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of reports to include in the response, used for paging. If
// unspecified, at most 10000 reports will be returned. The maximum
// value is 10000; values above 10000 will be coerced to 10000.
func (c *AccountsReportsSavedListCall) PageSize(pageSize int64) *AccountsReportsSavedListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListPayments` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListPayments` must match the call that provided the page
// token.
func (c *AccountsReportsSavedListCall) PageToken(pageToken string) *AccountsReportsSavedListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsReportsSavedListCall) Fields(s ...googleapi.Field) *AccountsReportsSavedListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsReportsSavedListCall) IfNoneMatch(entityTag string) *AccountsReportsSavedListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsReportsSavedListCall) Context(ctx context.Context) *AccountsReportsSavedListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsReportsSavedListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsReportsSavedListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/reports/saved")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.reports.saved.list" call.
// Exactly one of *ListSavedReportsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListSavedReportsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsReportsSavedListCall) Do(opts ...googleapi.CallOption) (*ListSavedReportsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListSavedReportsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists saved reports.",
	//   "flatPath": "v2/accounts/{accountsId}/reports/saved",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.reports.saved.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of reports to include in the response, used for paging. If unspecified, at most 10000 reports will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListPayments` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListPayments` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The account which owns the collection of reports. Format: accounts/{account}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/reports/saved",
	//   "response": {
	//     "$ref": "ListSavedReportsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsReportsSavedListCall) Pages(ctx context.Context, f func(*ListSavedReportsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "adsense.accounts.sites.get":

type AccountsSitesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about the selected site.
//
// - name: Name of the site. Format: accounts/{account}/sites/{site}.
func (r *AccountsSitesService) Get(name string) *AccountsSitesGetCall {
	c := &AccountsSitesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsSitesGetCall) Fields(s ...googleapi.Field) *AccountsSitesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsSitesGetCall) IfNoneMatch(entityTag string) *AccountsSitesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsSitesGetCall) Context(ctx context.Context) *AccountsSitesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsSitesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsSitesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.sites.get" call.
// Exactly one of *Site or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Site.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsSitesGetCall) Do(opts ...googleapi.CallOption) (*Site, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Site{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about the selected site.",
	//   "flatPath": "v2/accounts/{accountsId}/sites/{sitesId}",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.sites.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the site. Format: accounts/{account}/sites/{site}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/sites/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}",
	//   "response": {
	//     "$ref": "Site"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// method id "adsense.accounts.sites.list":

type AccountsSitesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the sites available in an account.
//
// - parent: The account which owns the collection of sites. Format:
//   accounts/{account}.
func (r *AccountsSitesService) List(parent string) *AccountsSitesListCall {
	c := &AccountsSitesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of sites to include in the response, used for paging. If unspecified,
// at most 10000 sites will be returned. The maximum value is 10000;
// values above 10000 will be coerced to 10000.
func (c *AccountsSitesListCall) PageSize(pageSize int64) *AccountsSitesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListSites` call. Provide this to retrieve
// the subsequent page. When paginating, all other parameters provided
// to `ListSites` must match the call that provided the page token.
func (c *AccountsSitesListCall) PageToken(pageToken string) *AccountsSitesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsSitesListCall) Fields(s ...googleapi.Field) *AccountsSitesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsSitesListCall) IfNoneMatch(entityTag string) *AccountsSitesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsSitesListCall) Context(ctx context.Context) *AccountsSitesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsSitesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsSitesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210606")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/sites")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "adsense.accounts.sites.list" call.
// Exactly one of *ListSitesResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListSitesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsSitesListCall) Do(opts ...googleapi.CallOption) (*ListSitesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListSitesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all the sites available in an account.",
	//   "flatPath": "v2/accounts/{accountsId}/sites",
	//   "httpMethod": "GET",
	//   "id": "adsense.accounts.sites.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of sites to include in the response, used for paging. If unspecified, at most 10000 sites will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListSites` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListSites` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The account which owns the collection of sites. Format: accounts/{account}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/sites",
	//   "response": {
	//     "$ref": "ListSitesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/adsense",
	//     "https://www.googleapis.com/auth/adsense.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsSitesListCall) Pages(ctx context.Context, f func(*ListSitesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
