// DO NOT EDIT: This file is autogenerated via the builtin command.

package tickscript

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   74,
				},
				File:   "alert_test.flux",
				Source: "package tickscript_test\n\nimport \"testing\"\nimport \"csv\"\nimport \"contrib/bonitoo-io/tickscript\"\nimport \"influxdata/influxdb/monitor\"\nimport \"influxdata/influxdb/schema\"\n\noption now = () => (2020-11-25T14:05:30Z)\n\n// overwrite as buckets are not avail in Flux tests\noption monitor.write = (tables=<-) => tables\noption monitor.log = (tables=<-) => tables\n\ninData = \"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"\n\noutData = \"\n#group,false,false,false,true,true,true,true,false,true,false,true,false,true,false,true\n#datatype,string,long,double,string,string,string,string,string,string,long,string,string,string,string,string\n#default,_result,,,,,,,,,,,,,,\n,result,table,KafkaMsgRate,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,details,host,id,realm\n,,0,1.819231109049999,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.819231109049999,testm,1606313103477635916,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,0,1.635878190200181,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.635878190200181,testm,1606313104541635074,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,0,1.33716449678206,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.33716449678206,testm,1606313108868317091,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,1,39.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 39.33716449678206,testm,1606313105623191313,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,1,26.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 26.33716449678206,testm,1606313106696061106,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,2,8.33716449678206,rate-check,Rate Check,warn,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: warn - 8.33716449678206,testm,1606313107768317097,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n\"\n\ncheck = {\n  _check_id: \"rate-check\",\n  _check_name: \"Rate Check\",\n  _type: \"custom\", // tickscript?\n  tags: {},\n}\n\nmetric_type = \"kafka_message_in_rate\"\ntier = \"ft\"\nh_threshold = 10\nw_threshold = 5\nl_threshold = .002\n\ntickscript_alert = (table=<-) => table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold\n    )\n    |> drop(columns: [\"_time\"])\n\ntest _tickscript_alert = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_alert,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   9,
						},
						File:   "alert_test.flux",
						Source: "now = () => (2020-11-25T14:05:30Z)",
						Start: ast.Position{
							Column: 8,
							Line:   9,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   9,
							},
							File:   "alert_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   9,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   9,
							},
							File:   "alert_test.flux",
							Source: "() => (2020-11-25T14:05:30Z)",
							Start: ast.Position{
								Column: 14,
								Line:   9,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   9,
								},
								File:   "alert_test.flux",
								Source: "(2020-11-25T14:05:30Z)",
								Start: ast.Position{
									Column: 20,
									Line:   9,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   9,
									},
									File:   "alert_test.flux",
									Source: "2020-11-25T14:05:30Z",
									Start: ast.Position{
										Column: 21,
										Line:   9,
									},
								},
							},
							Value: parser.MustParseTime("2020-11-25T14:05:30Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   9,
					},
					File:   "alert_test.flux",
					Source: "option now = () => (2020-11-25T14:05:30Z)",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 45,
							Line:   12,
						},
						File:   "alert_test.flux",
						Source: "monitor.write = (tables=<-) => tables",
						Start: ast.Position{
							Column: 8,
							Line:   12,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   12,
							},
							File:   "alert_test.flux",
							Source: "(tables=<-) => tables",
							Start: ast.Position{
								Column: 24,
								Line:   12,
							},
						},
					},
					Body: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   12,
								},
								File:   "alert_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 39,
									Line:   12,
								},
							},
						},
						Name: "tables",
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   12,
								},
								File:   "alert_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 25,
									Line:   12,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   12,
									},
									File:   "alert_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   12,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   12,
								},
								File:   "alert_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 32,
									Line:   12,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   12,
							},
							File:   "alert_test.flux",
							Source: "monitor.write",
							Start: ast.Position{
								Column: 8,
								Line:   12,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   12,
								},
								File:   "alert_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   12,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   12,
								},
								File:   "alert_test.flux",
								Source: "write",
								Start: ast.Position{
									Column: 16,
									Line:   12,
								},
							},
						},
						Name: "write",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// overwrite as buckets are not avail in Flux tests\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 45,
						Line:   12,
					},
					File:   "alert_test.flux",
					Source: "option monitor.write = (tables=<-) => tables",
					Start: ast.Position{
						Column: 1,
						Line:   12,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 43,
							Line:   13,
						},
						File:   "alert_test.flux",
						Source: "monitor.log = (tables=<-) => tables",
						Start: ast.Position{
							Column: 8,
							Line:   13,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   13,
							},
							File:   "alert_test.flux",
							Source: "(tables=<-) => tables",
							Start: ast.Position{
								Column: 22,
								Line:   13,
							},
						},
					},
					Body: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   13,
								},
								File:   "alert_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 37,
									Line:   13,
								},
							},
						},
						Name: "tables",
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   13,
								},
								File:   "alert_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 23,
									Line:   13,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   13,
									},
									File:   "alert_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   13,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   13,
								},
								File:   "alert_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 30,
									Line:   13,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   13,
							},
							File:   "alert_test.flux",
							Source: "monitor.log",
							Start: ast.Position{
								Column: 8,
								Line:   13,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   13,
								},
								File:   "alert_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   13,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   13,
								},
								File:   "alert_test.flux",
								Source: "log",
								Start: ast.Position{
									Column: 16,
									Line:   13,
								},
							},
						},
						Name: "log",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 43,
						Line:   13,
					},
					File:   "alert_test.flux",
					Source: "option monitor.log = (tables=<-) => tables",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   26,
					},
					File:   "alert_test.flux",
					Source: "inData = \"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   15,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   15,
						},
						File:   "alert_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   15,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   26,
						},
						File:   "alert_test.flux",
						Source: "\"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   15,
						},
					},
				},
				Value: "\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   39,
					},
					File:   "alert_test.flux",
					Source: "outData = \"\n#group,false,false,false,true,true,true,true,false,true,false,true,false,true,false,true\n#datatype,string,long,double,string,string,string,string,string,string,long,string,string,string,string,string\n#default,_result,,,,,,,,,,,,,,\n,result,table,KafkaMsgRate,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,details,host,id,realm\n,,0,1.819231109049999,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.819231109049999,testm,1606313103477635916,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,0,1.635878190200181,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.635878190200181,testm,1606313104541635074,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,0,1.33716449678206,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.33716449678206,testm,1606313108868317091,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,1,39.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 39.33716449678206,testm,1606313105623191313,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,1,26.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 26.33716449678206,testm,1606313106696061106,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,2,8.33716449678206,rate-check,Rate Check,warn,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: warn - 8.33716449678206,testm,1606313107768317097,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   28,
						},
						File:   "alert_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   28,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   39,
						},
						File:   "alert_test.flux",
						Source: "\"\n#group,false,false,false,true,true,true,true,false,true,false,true,false,true,false,true\n#datatype,string,long,double,string,string,string,string,string,string,long,string,string,string,string,string\n#default,_result,,,,,,,,,,,,,,\n,result,table,KafkaMsgRate,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,details,host,id,realm\n,,0,1.819231109049999,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.819231109049999,testm,1606313103477635916,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,0,1.635878190200181,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.635878190200181,testm,1606313104541635074,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,0,1.33716449678206,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.33716449678206,testm,1606313108868317091,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,1,39.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 39.33716449678206,testm,1606313105623191313,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,1,26.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 26.33716449678206,testm,1606313106696061106,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,2,8.33716449678206,rate-check,Rate Check,warn,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: warn - 8.33716449678206,testm,1606313107768317097,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   28,
						},
					},
				},
				Value: "\n#group,false,false,false,true,true,true,true,false,true,false,true,false,true,false,true\n#datatype,string,long,double,string,string,string,string,string,string,long,string,string,string,string,string\n#default,_result,,,,,,,,,,,,,,\n,result,table,KafkaMsgRate,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,details,host,id,realm\n,,0,1.819231109049999,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.819231109049999,testm,1606313103477635916,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,0,1.635878190200181,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.635878190200181,testm,1606313104541635074,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,0,1.33716449678206,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.33716449678206,testm,1606313108868317091,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,1,39.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 39.33716449678206,testm,1606313105623191313,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,1,26.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 26.33716449678206,testm,1606313106696061106,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,2,8.33716449678206,rate-check,Rate Check,warn,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: warn - 8.33716449678206,testm,1606313107768317097,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   46,
					},
					File:   "alert_test.flux",
					Source: "check = {\n  _check_id: \"rate-check\",\n  _check_name: \"Rate Check\",\n  _type: \"custom\", // tickscript?\n  tags: {},\n}",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   41,
						},
						File:   "alert_test.flux",
						Source: "check",
						Start: ast.Position{
							Column: 1,
							Line:   41,
						},
					},
				},
				Name: "check",
			},
			Init: &ast.ObjectExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   46,
						},
						File:   "alert_test.flux",
						Source: "{\n  _check_id: \"rate-check\",\n  _check_name: \"Rate Check\",\n  _type: \"custom\", // tickscript?\n  tags: {},\n}",
						Start: ast.Position{
							Column: 9,
							Line:   41,
						},
					},
				},
				Lbrace: nil,
				Properties: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   42,
							},
							File:   "alert_test.flux",
							Source: "_check_id: \"rate-check\"",
							Start: ast.Position{
								Column: 3,
								Line:   42,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   42,
								},
								File:   "alert_test.flux",
								Source: "_check_id",
								Start: ast.Position{
									Column: 3,
									Line:   42,
								},
							},
						},
						Name: "_check_id",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   42,
								},
								File:   "alert_test.flux",
								Source: "\"rate-check\"",
								Start: ast.Position{
									Column: 14,
									Line:   42,
								},
							},
						},
						Value: "rate-check",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   43,
							},
							File:   "alert_test.flux",
							Source: "_check_name: \"Rate Check\"",
							Start: ast.Position{
								Column: 3,
								Line:   43,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   43,
								},
								File:   "alert_test.flux",
								Source: "_check_name",
								Start: ast.Position{
									Column: 3,
									Line:   43,
								},
							},
						},
						Name: "_check_name",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   43,
								},
								File:   "alert_test.flux",
								Source: "\"Rate Check\"",
								Start: ast.Position{
									Column: 16,
									Line:   43,
								},
							},
						},
						Value: "Rate Check",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   44,
							},
							File:   "alert_test.flux",
							Source: "_type: \"custom\"",
							Start: ast.Position{
								Column: 3,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 8,
									Line:   44,
								},
								File:   "alert_test.flux",
								Source: "_type",
								Start: ast.Position{
									Column: 3,
									Line:   44,
								},
							},
						},
						Name: "_type",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   44,
								},
								File:   "alert_test.flux",
								Source: "\"custom\"",
								Start: ast.Position{
									Column: 10,
									Line:   44,
								},
							},
						},
						Value: "custom",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   45,
							},
							File:   "alert_test.flux",
							Source: "tags: {}",
							Start: ast.Position{
								Column: 3,
								Line:   45,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: []ast.Comment{ast.Comment{Text: "// tickscript?\n"}},
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 7,
									Line:   45,
								},
								File:   "alert_test.flux",
								Source: "tags",
								Start: ast.Position{
									Column: 3,
									Line:   45,
								},
							},
						},
						Name: "tags",
					},
					Separator: nil,
					Value: &ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   45,
								},
								File:   "alert_test.flux",
								Source: "{}",
								Start: ast.Position{
									Column: 9,
									Line:   45,
								},
							},
						},
						Lbrace:     nil,
						Properties: []*ast.Property{},
						Rbrace:     nil,
						With:       nil,
					},
				}},
				Rbrace: nil,
				With:   nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 38,
						Line:   48,
					},
					File:   "alert_test.flux",
					Source: "metric_type = \"kafka_message_in_rate\"",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   48,
						},
						File:   "alert_test.flux",
						Source: "metric_type",
						Start: ast.Position{
							Column: 1,
							Line:   48,
						},
					},
				},
				Name: "metric_type",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   48,
						},
						File:   "alert_test.flux",
						Source: "\"kafka_message_in_rate\"",
						Start: ast.Position{
							Column: 15,
							Line:   48,
						},
					},
				},
				Value: "kafka_message_in_rate",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   49,
					},
					File:   "alert_test.flux",
					Source: "tier = \"ft\"",
					Start: ast.Position{
						Column: 1,
						Line:   49,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   49,
						},
						File:   "alert_test.flux",
						Source: "tier",
						Start: ast.Position{
							Column: 1,
							Line:   49,
						},
					},
				},
				Name: "tier",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   49,
						},
						File:   "alert_test.flux",
						Source: "\"ft\"",
						Start: ast.Position{
							Column: 8,
							Line:   49,
						},
					},
				},
				Value: "ft",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   50,
					},
					File:   "alert_test.flux",
					Source: "h_threshold = 10",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   50,
						},
						File:   "alert_test.flux",
						Source: "h_threshold",
						Start: ast.Position{
							Column: 1,
							Line:   50,
						},
					},
				},
				Name: "h_threshold",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   50,
						},
						File:   "alert_test.flux",
						Source: "10",
						Start: ast.Position{
							Column: 15,
							Line:   50,
						},
					},
				},
				Value: int64(10),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   51,
					},
					File:   "alert_test.flux",
					Source: "w_threshold = 5",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   51,
						},
						File:   "alert_test.flux",
						Source: "w_threshold",
						Start: ast.Position{
							Column: 1,
							Line:   51,
						},
					},
				},
				Name: "w_threshold",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   51,
						},
						File:   "alert_test.flux",
						Source: "5",
						Start: ast.Position{
							Column: 15,
							Line:   51,
						},
					},
				},
				Value: int64(5),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   52,
					},
					File:   "alert_test.flux",
					Source: "l_threshold = .002",
					Start: ast.Position{
						Column: 1,
						Line:   52,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   52,
						},
						File:   "alert_test.flux",
						Source: "l_threshold",
						Start: ast.Position{
							Column: 1,
							Line:   52,
						},
					},
				},
				Name: "l_threshold",
			},
			Init: &ast.FloatLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   52,
						},
						File:   "alert_test.flux",
						Source: ".002",
						Start: ast.Position{
							Column: 15,
							Line:   52,
						},
					},
				},
				Value: 0.002,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   68,
					},
					File:   "alert_test.flux",
					Source: "tickscript_alert = (table=<-) => table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold\n    )\n    |> drop(columns: [\"_time\"])",
					Start: ast.Position{
						Column: 1,
						Line:   54,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   54,
						},
						File:   "alert_test.flux",
						Source: "tickscript_alert",
						Start: ast.Position{
							Column: 1,
							Line:   54,
						},
					},
				},
				Name: "tickscript_alert",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   68,
						},
						File:   "alert_test.flux",
						Source: "(table=<-) => table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold\n    )\n    |> drop(columns: [\"_time\"])",
						Start: ast.Position{
							Column: 20,
							Line:   54,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   54,
														},
														File:   "alert_test.flux",
														Source: "table",
														Start: ast.Position{
															Column: 34,
															Line:   54,
														},
													},
												},
												Name: "table",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   55,
													},
													File:   "alert_test.flux",
													Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)",
													Start: ast.Position{
														Column: 34,
														Line:   54,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   55,
															},
															File:   "alert_test.flux",
															Source: "start: 2020-11-25T14:05:00Z",
															Start: ast.Position{
																Column: 11,
																Line:   55,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   55,
																},
																File:   "alert_test.flux",
																Source: "start: 2020-11-25T14:05:00Z",
																Start: ast.Position{
																	Column: 11,
																	Line:   55,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 16,
																		Line:   55,
																	},
																	File:   "alert_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 11,
																		Line:   55,
																	},
																},
															},
															Name: "start",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   55,
																	},
																	File:   "alert_test.flux",
																	Source: "2020-11-25T14:05:00Z",
																	Start: ast.Position{
																		Column: 18,
																		Line:   55,
																	},
																},
															},
															Value: parser.MustParseTime("2020-11-25T14:05:00Z"),
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   55,
														},
														File:   "alert_test.flux",
														Source: "range(start: 2020-11-25T14:05:00Z)",
														Start: ast.Position{
															Column: 5,
															Line:   55,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 10,
																Line:   55,
															},
															File:   "alert_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 5,
																Line:   55,
															},
														},
													},
													Name: "range",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   56,
												},
												File:   "alert_test.flux",
												Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)",
												Start: ast.Position{
													Column: 34,
													Line:   54,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   56,
														},
														File:   "alert_test.flux",
														Source: "fn: (r) => r._field == metric_type and r.realm == tier",
														Start: ast.Position{
															Column: 15,
															Line:   56,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   56,
															},
															File:   "alert_test.flux",
															Source: "fn: (r) => r._field == metric_type and r.realm == tier",
															Start: ast.Position{
																Column: 15,
																Line:   56,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   56,
																},
																File:   "alert_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 15,
																	Line:   56,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.FunctionExpression{
														Arrow: nil,
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   56,
																},
																File:   "alert_test.flux",
																Source: "(r) => r._field == metric_type and r.realm == tier",
																Start: ast.Position{
																	Column: 19,
																	Line:   56,
																},
															},
														},
														Body: &ast.LogicalExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 69,
																		Line:   56,
																	},
																	File:   "alert_test.flux",
																	Source: "r._field == metric_type and r.realm == tier",
																	Start: ast.Position{
																		Column: 26,
																		Line:   56,
																	},
																},
															},
															Left: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   56,
																		},
																		File:   "alert_test.flux",
																		Source: "r._field == metric_type",
																		Start: ast.Position{
																			Column: 26,
																			Line:   56,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 34,
																				Line:   56,
																			},
																			File:   "alert_test.flux",
																			Source: "r._field",
																			Start: ast.Position{
																				Column: 26,
																				Line:   56,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 27,
																					Line:   56,
																				},
																				File:   "alert_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 26,
																					Line:   56,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 34,
																					Line:   56,
																				},
																				File:   "alert_test.flux",
																				Source: "_field",
																				Start: ast.Position{
																					Column: 28,
																					Line:   56,
																				},
																			},
																		},
																		Name: "_field",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 49,
																				Line:   56,
																			},
																			File:   "alert_test.flux",
																			Source: "metric_type",
																			Start: ast.Position{
																				Column: 38,
																				Line:   56,
																			},
																		},
																	},
																	Name: "metric_type",
																},
															},
															Operator: 1,
															Right: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 69,
																			Line:   56,
																		},
																		File:   "alert_test.flux",
																		Source: "r.realm == tier",
																		Start: ast.Position{
																			Column: 54,
																			Line:   56,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 61,
																				Line:   56,
																			},
																			File:   "alert_test.flux",
																			Source: "r.realm",
																			Start: ast.Position{
																				Column: 54,
																				Line:   56,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 55,
																					Line:   56,
																				},
																				File:   "alert_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 54,
																					Line:   56,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 61,
																					Line:   56,
																				},
																				File:   "alert_test.flux",
																				Source: "realm",
																				Start: ast.Position{
																					Column: 56,
																					Line:   56,
																				},
																			},
																		},
																		Name: "realm",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 69,
																				Line:   56,
																			},
																			File:   "alert_test.flux",
																			Source: "tier",
																			Start: ast.Position{
																				Column: 65,
																				Line:   56,
																			},
																		},
																	},
																	Name: "tier",
																},
															},
														},
														Lparen: nil,
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   56,
																	},
																	File:   "alert_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 20,
																		Line:   56,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   56,
																		},
																		File:   "alert_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 20,
																			Line:   56,
																		},
																	},
																},
																Name: "r",
															},
															Separator: nil,
															Value:     nil,
														}},
														Rparan: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   56,
													},
													File:   "alert_test.flux",
													Source: "filter(fn: (r) => r._field == metric_type and r.realm == tier)",
													Start: ast.Position{
														Column: 8,
														Line:   56,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   56,
														},
														File:   "alert_test.flux",
														Source: "filter",
														Start: ast.Position{
															Column: 8,
															Line:   56,
														},
													},
												},
												Name: "filter",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   57,
											},
											File:   "alert_test.flux",
											Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()",
											Start: ast.Position{
												Column: 34,
												Line:   54,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   57,
												},
												File:   "alert_test.flux",
												Source: "schema.fieldsAsCols()",
												Start: ast.Position{
													Column: 8,
													Line:   57,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   57,
													},
													File:   "alert_test.flux",
													Source: "schema.fieldsAsCols",
													Start: ast.Position{
														Column: 8,
														Line:   57,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   57,
														},
														File:   "alert_test.flux",
														Source: "schema",
														Start: ast.Position{
															Column: 8,
															Line:   57,
														},
													},
												},
												Name: "schema",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   57,
														},
														File:   "alert_test.flux",
														Source: "fieldsAsCols",
														Start: ast.Position{
															Column: 15,
															Line:   57,
														},
													},
												},
												Name: "fieldsAsCols",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   58,
										},
										File:   "alert_test.flux",
										Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")",
										Start: ast.Position{
											Column: 34,
											Line:   54,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   58,
												},
												File:   "alert_test.flux",
												Source: "column: metric_type, as: \"KafkaMsgRate\"",
												Start: ast.Position{
													Column: 26,
													Line:   58,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   58,
													},
													File:   "alert_test.flux",
													Source: "column: metric_type",
													Start: ast.Position{
														Column: 26,
														Line:   58,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   58,
														},
														File:   "alert_test.flux",
														Source: "column",
														Start: ast.Position{
															Column: 26,
															Line:   58,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   58,
														},
														File:   "alert_test.flux",
														Source: "metric_type",
														Start: ast.Position{
															Column: 34,
															Line:   58,
														},
													},
												},
												Name: "metric_type",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 65,
														Line:   58,
													},
													File:   "alert_test.flux",
													Source: "as: \"KafkaMsgRate\"",
													Start: ast.Position{
														Column: 47,
														Line:   58,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   58,
														},
														File:   "alert_test.flux",
														Source: "as",
														Start: ast.Position{
															Column: 47,
															Line:   58,
														},
													},
												},
												Name: "as",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   58,
														},
														File:   "alert_test.flux",
														Source: "\"KafkaMsgRate\"",
														Start: ast.Position{
															Column: 51,
															Line:   58,
														},
													},
												},
												Value: "KafkaMsgRate",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   58,
											},
											File:   "alert_test.flux",
											Source: "tickscript.select(column: metric_type, as: \"KafkaMsgRate\")",
											Start: ast.Position{
												Column: 8,
												Line:   58,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   58,
												},
												File:   "alert_test.flux",
												Source: "tickscript.select",
												Start: ast.Position{
													Column: 8,
													Line:   58,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   58,
													},
													File:   "alert_test.flux",
													Source: "tickscript",
													Start: ast.Position{
														Column: 8,
														Line:   58,
													},
												},
											},
											Name: "tickscript",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   58,
													},
													File:   "alert_test.flux",
													Source: "select",
													Start: ast.Position{
														Column: 19,
														Line:   58,
													},
												},
											},
											Name: "select",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   59,
									},
									File:   "alert_test.flux",
									Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])",
									Start: ast.Position{
										Column: 34,
										Line:   54,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   59,
											},
											File:   "alert_test.flux",
											Source: "columns: [\"host\", \"realm\"]",
											Start: ast.Position{
												Column: 27,
												Line:   59,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   59,
												},
												File:   "alert_test.flux",
												Source: "columns: [\"host\", \"realm\"]",
												Start: ast.Position{
													Column: 27,
													Line:   59,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   59,
													},
													File:   "alert_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 27,
														Line:   59,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   59,
													},
													File:   "alert_test.flux",
													Source: "[\"host\", \"realm\"]",
													Start: ast.Position{
														Column: 36,
														Line:   59,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   59,
														},
														File:   "alert_test.flux",
														Source: "\"host\"",
														Start: ast.Position{
															Column: 37,
															Line:   59,
														},
													},
												},
												Value: "host",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   59,
														},
														File:   "alert_test.flux",
														Source: "\"realm\"",
														Start: ast.Position{
															Column: 45,
															Line:   59,
														},
													},
												},
												Value: "realm",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   59,
										},
										File:   "alert_test.flux",
										Source: "tickscript.groupBy(columns: [\"host\", \"realm\"])",
										Start: ast.Position{
											Column: 8,
											Line:   59,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   59,
											},
											File:   "alert_test.flux",
											Source: "tickscript.groupBy",
											Start: ast.Position{
												Column: 8,
												Line:   59,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   59,
												},
												File:   "alert_test.flux",
												Source: "tickscript",
												Start: ast.Position{
													Column: 8,
													Line:   59,
												},
											},
										},
										Name: "tickscript",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   59,
												},
												File:   "alert_test.flux",
												Source: "groupBy",
												Start: ast.Position{
													Column: 19,
													Line:   59,
												},
											},
										},
										Name: "groupBy",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   67,
								},
								File:   "alert_test.flux",
								Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold\n    )",
								Start: ast.Position{
									Column: 34,
									Line:   54,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 82,
											Line:   66,
										},
										File:   "alert_test.flux",
										Source: "check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold",
										Start: ast.Position{
											Column: 9,
											Line:   61,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   61,
											},
											File:   "alert_test.flux",
											Source: "check: check",
											Start: ast.Position{
												Column: 9,
												Line:   61,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   61,
												},
												File:   "alert_test.flux",
												Source: "check",
												Start: ast.Position{
													Column: 9,
													Line:   61,
												},
											},
										},
										Name: "check",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   61,
												},
												File:   "alert_test.flux",
												Source: "check",
												Start: ast.Position{
													Column: 16,
													Line:   61,
												},
											},
										},
										Name: "check",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 102,
												Line:   62,
											},
											File:   "alert_test.flux",
											Source: "id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\"",
											Start: ast.Position{
												Column: 9,
												Line:   62,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   62,
												},
												File:   "alert_test.flux",
												Source: "id",
												Start: ast.Position{
													Column: 9,
													Line:   62,
												},
											},
										},
										Name: "id",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 102,
													Line:   62,
												},
												File:   "alert_test.flux",
												Source: "(r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\"",
												Start: ast.Position{
													Column: 13,
													Line:   62,
												},
											},
										},
										Body: &ast.StringExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 102,
														Line:   62,
													},
													File:   "alert_test.flux",
													Source: "\"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\"",
													Start: ast.Position{
														Column: 20,
														Line:   62,
													},
												},
											},
											Parts: []ast.StringExpressionPart{&ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   62,
														},
														File:   "alert_test.flux",
														Source: "Realm: ",
														Start: ast.Position{
															Column: 21,
															Line:   62,
														},
													},
												},
												Value: "Realm: ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   62,
														},
														File:   "alert_test.flux",
														Source: "${r.realm}",
														Start: ast.Position{
															Column: 28,
															Line:   62,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   62,
															},
															File:   "alert_test.flux",
															Source: "r.realm",
															Start: ast.Position{
																Column: 30,
																Line:   62,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   62,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 30,
																	Line:   62,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   62,
																},
																File:   "alert_test.flux",
																Source: "realm",
																Start: ast.Position{
																	Column: 32,
																	Line:   62,
																},
															},
														},
														Name: "realm",
													},
													Rbrack: nil,
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 51,
															Line:   62,
														},
														File:   "alert_test.flux",
														Source: " - Hostname: ",
														Start: ast.Position{
															Column: 38,
															Line:   62,
														},
													},
												},
												Value: " - Hostname: ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   62,
														},
														File:   "alert_test.flux",
														Source: "${r.host}",
														Start: ast.Position{
															Column: 51,
															Line:   62,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 59,
																Line:   62,
															},
															File:   "alert_test.flux",
															Source: "r.host",
															Start: ast.Position{
																Column: 53,
																Line:   62,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 54,
																	Line:   62,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 53,
																	Line:   62,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 59,
																	Line:   62,
																},
																File:   "alert_test.flux",
																Source: "host",
																Start: ast.Position{
																	Column: 55,
																	Line:   62,
																},
															},
														},
														Name: "host",
													},
													Rbrack: nil,
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   62,
														},
														File:   "alert_test.flux",
														Source: " / Metric: ",
														Start: ast.Position{
															Column: 60,
															Line:   62,
														},
													},
												},
												Value: " / Metric: ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 85,
															Line:   62,
														},
														File:   "alert_test.flux",
														Source: "${metric_type}",
														Start: ast.Position{
															Column: 71,
															Line:   62,
														},
													},
												},
												Expression: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 84,
																Line:   62,
															},
															File:   "alert_test.flux",
															Source: "metric_type",
															Start: ast.Position{
																Column: 73,
																Line:   62,
															},
														},
													},
													Name: "metric_type",
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 101,
															Line:   62,
														},
														File:   "alert_test.flux",
														Source: " threshold alert",
														Start: ast.Position{
															Column: 85,
															Line:   62,
														},
													},
												},
												Value: " threshold alert",
											}},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   62,
													},
													File:   "alert_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 14,
														Line:   62,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   62,
														},
														File:   "alert_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   62,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   63,
											},
											File:   "alert_test.flux",
											Source: "message: (r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\"",
											Start: ast.Position{
												Column: 9,
												Line:   63,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   63,
												},
												File:   "alert_test.flux",
												Source: "message",
												Start: ast.Position{
													Column: 9,
													Line:   63,
												},
											},
										},
										Name: "message",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 77,
													Line:   63,
												},
												File:   "alert_test.flux",
												Source: "(r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\"",
												Start: ast.Position{
													Column: 18,
													Line:   63,
												},
											},
										},
										Body: &ast.StringExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 77,
														Line:   63,
													},
													File:   "alert_test.flux",
													Source: "\"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\"",
													Start: ast.Position{
														Column: 25,
														Line:   63,
													},
												},
											},
											Parts: []ast.StringExpressionPart{&ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   63,
														},
														File:   "alert_test.flux",
														Source: "${r.id}",
														Start: ast.Position{
															Column: 26,
															Line:   63,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 32,
																Line:   63,
															},
															File:   "alert_test.flux",
															Source: "r.id",
															Start: ast.Position{
																Column: 28,
																Line:   63,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 29,
																	Line:   63,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 28,
																	Line:   63,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 32,
																	Line:   63,
																},
																File:   "alert_test.flux",
																Source: "id",
																Start: ast.Position{
																	Column: 30,
																	Line:   63,
																},
															},
														},
														Name: "id",
													},
													Rbrack: nil,
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   63,
														},
														File:   "alert_test.flux",
														Source: ": ",
														Start: ast.Position{
															Column: 33,
															Line:   63,
														},
													},
												},
												Value: ": ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   63,
														},
														File:   "alert_test.flux",
														Source: "${r._level}",
														Start: ast.Position{
															Column: 35,
															Line:   63,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   63,
															},
															File:   "alert_test.flux",
															Source: "r._level",
															Start: ast.Position{
																Column: 37,
																Line:   63,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   63,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 37,
																	Line:   63,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   63,
																},
																File:   "alert_test.flux",
																Source: "_level",
																Start: ast.Position{
																	Column: 39,
																	Line:   63,
																},
															},
														},
														Name: "_level",
													},
													Rbrack: nil,
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   63,
														},
														File:   "alert_test.flux",
														Source: " - ",
														Start: ast.Position{
															Column: 46,
															Line:   63,
														},
													},
												},
												Value: " - ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 76,
															Line:   63,
														},
														File:   "alert_test.flux",
														Source: "${string(v:r.KafkaMsgRate)}",
														Start: ast.Position{
															Column: 49,
															Line:   63,
														},
													},
												},
												Expression: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 74,
																	Line:   63,
																},
																File:   "alert_test.flux",
																Source: "v:r.KafkaMsgRate",
																Start: ast.Position{
																	Column: 58,
																	Line:   63,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 74,
																		Line:   63,
																	},
																	File:   "alert_test.flux",
																	Source: "v:r.KafkaMsgRate",
																	Start: ast.Position{
																		Column: 58,
																		Line:   63,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   63,
																		},
																		File:   "alert_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 58,
																			Line:   63,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 74,
																			Line:   63,
																		},
																		File:   "alert_test.flux",
																		Source: "r.KafkaMsgRate",
																		Start: ast.Position{
																			Column: 60,
																			Line:   63,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 61,
																				Line:   63,
																			},
																			File:   "alert_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 60,
																				Line:   63,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 74,
																				Line:   63,
																			},
																			File:   "alert_test.flux",
																			Source: "KafkaMsgRate",
																			Start: ast.Position{
																				Column: 62,
																				Line:   63,
																			},
																		},
																	},
																	Name: "KafkaMsgRate",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 75,
																Line:   63,
															},
															File:   "alert_test.flux",
															Source: "string(v:r.KafkaMsgRate)",
															Start: ast.Position{
																Column: 51,
																Line:   63,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   63,
																},
																File:   "alert_test.flux",
																Source: "string",
																Start: ast.Position{
																	Column: 51,
																	Line:   63,
																},
															},
														},
														Name: "string",
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   63,
													},
													File:   "alert_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 19,
														Line:   63,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   63,
														},
														File:   "alert_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 19,
															Line:   63,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   64,
											},
											File:   "alert_test.flux",
											Source: "details: (r) => \"some detail: myrealm=${r.realm}\"",
											Start: ast.Position{
												Column: 9,
												Line:   64,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   64,
												},
												File:   "alert_test.flux",
												Source: "details",
												Start: ast.Position{
													Column: 9,
													Line:   64,
												},
											},
										},
										Name: "details",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   64,
												},
												File:   "alert_test.flux",
												Source: "(r) => \"some detail: myrealm=${r.realm}\"",
												Start: ast.Position{
													Column: 18,
													Line:   64,
												},
											},
										},
										Body: &ast.StringExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   64,
													},
													File:   "alert_test.flux",
													Source: "\"some detail: myrealm=${r.realm}\"",
													Start: ast.Position{
														Column: 25,
														Line:   64,
													},
												},
											},
											Parts: []ast.StringExpressionPart{&ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   64,
														},
														File:   "alert_test.flux",
														Source: "some detail: myrealm=",
														Start: ast.Position{
															Column: 26,
															Line:   64,
														},
													},
												},
												Value: "some detail: myrealm=",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 57,
															Line:   64,
														},
														File:   "alert_test.flux",
														Source: "${r.realm}",
														Start: ast.Position{
															Column: 47,
															Line:   64,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   64,
															},
															File:   "alert_test.flux",
															Source: "r.realm",
															Start: ast.Position{
																Column: 49,
																Line:   64,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 50,
																	Line:   64,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 49,
																	Line:   64,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   64,
																},
																File:   "alert_test.flux",
																Source: "realm",
																Start: ast.Position{
																	Column: 51,
																	Line:   64,
																},
															},
														},
														Name: "realm",
													},
													Rbrack: nil,
												},
											}},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   64,
													},
													File:   "alert_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 19,
														Line:   64,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   64,
														},
														File:   "alert_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 19,
															Line:   64,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 82,
												Line:   65,
											},
											File:   "alert_test.flux",
											Source: "crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold",
											Start: ast.Position{
												Column: 9,
												Line:   65,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   65,
												},
												File:   "alert_test.flux",
												Source: "crit",
												Start: ast.Position{
													Column: 9,
													Line:   65,
												},
											},
										},
										Name: "crit",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 82,
													Line:   65,
												},
												File:   "alert_test.flux",
												Source: "(r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold",
												Start: ast.Position{
													Column: 15,
													Line:   65,
												},
											},
										},
										Body: &ast.LogicalExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   65,
													},
													File:   "alert_test.flux",
													Source: "r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold",
													Start: ast.Position{
														Column: 22,
														Line:   65,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   65,
														},
														File:   "alert_test.flux",
														Source: "r.KafkaMsgRate > h_threshold",
														Start: ast.Position{
															Column: 22,
															Line:   65,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   65,
															},
															File:   "alert_test.flux",
															Source: "r.KafkaMsgRate",
															Start: ast.Position{
																Column: 22,
																Line:   65,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   65,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 22,
																	Line:   65,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   65,
																},
																File:   "alert_test.flux",
																Source: "KafkaMsgRate",
																Start: ast.Position{
																	Column: 24,
																	Line:   65,
																},
															},
														},
														Name: "KafkaMsgRate",
													},
													Rbrack: nil,
												},
												Operator: 10,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   65,
															},
															File:   "alert_test.flux",
															Source: "h_threshold",
															Start: ast.Position{
																Column: 39,
																Line:   65,
															},
														},
													},
													Name: "h_threshold",
												},
											},
											Operator: 2,
											Right: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   65,
														},
														File:   "alert_test.flux",
														Source: "r.KafkaMsgRate < l_threshold",
														Start: ast.Position{
															Column: 54,
															Line:   65,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   65,
															},
															File:   "alert_test.flux",
															Source: "r.KafkaMsgRate",
															Start: ast.Position{
																Column: 54,
																Line:   65,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   65,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 54,
																	Line:   65,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   65,
																},
																File:   "alert_test.flux",
																Source: "KafkaMsgRate",
																Start: ast.Position{
																	Column: 56,
																	Line:   65,
																},
															},
														},
														Name: "KafkaMsgRate",
													},
													Rbrack: nil,
												},
												Operator: 8,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 82,
																Line:   65,
															},
															File:   "alert_test.flux",
															Source: "l_threshold",
															Start: ast.Position{
																Column: 71,
																Line:   65,
															},
														},
													},
													Name: "l_threshold",
												},
											},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   65,
													},
													File:   "alert_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 16,
														Line:   65,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   65,
														},
														File:   "alert_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 16,
															Line:   65,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 82,
												Line:   66,
											},
											File:   "alert_test.flux",
											Source: "warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold",
											Start: ast.Position{
												Column: 9,
												Line:   66,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   66,
												},
												File:   "alert_test.flux",
												Source: "warn",
												Start: ast.Position{
													Column: 9,
													Line:   66,
												},
											},
										},
										Name: "warn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 82,
													Line:   66,
												},
												File:   "alert_test.flux",
												Source: "(r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold",
												Start: ast.Position{
													Column: 15,
													Line:   66,
												},
											},
										},
										Body: &ast.LogicalExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   66,
													},
													File:   "alert_test.flux",
													Source: "r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold",
													Start: ast.Position{
														Column: 22,
														Line:   66,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   66,
														},
														File:   "alert_test.flux",
														Source: "r.KafkaMsgRate > w_threshold",
														Start: ast.Position{
															Column: 22,
															Line:   66,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   66,
															},
															File:   "alert_test.flux",
															Source: "r.KafkaMsgRate",
															Start: ast.Position{
																Column: 22,
																Line:   66,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   66,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 22,
																	Line:   66,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   66,
																},
																File:   "alert_test.flux",
																Source: "KafkaMsgRate",
																Start: ast.Position{
																	Column: 24,
																	Line:   66,
																},
															},
														},
														Name: "KafkaMsgRate",
													},
													Rbrack: nil,
												},
												Operator: 10,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   66,
															},
															File:   "alert_test.flux",
															Source: "w_threshold",
															Start: ast.Position{
																Column: 39,
																Line:   66,
															},
														},
													},
													Name: "w_threshold",
												},
											},
											Operator: 2,
											Right: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   66,
														},
														File:   "alert_test.flux",
														Source: "r.KafkaMsgRate < l_threshold",
														Start: ast.Position{
															Column: 54,
															Line:   66,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   66,
															},
															File:   "alert_test.flux",
															Source: "r.KafkaMsgRate",
															Start: ast.Position{
																Column: 54,
																Line:   66,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   66,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 54,
																	Line:   66,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   66,
																},
																File:   "alert_test.flux",
																Source: "KafkaMsgRate",
																Start: ast.Position{
																	Column: 56,
																	Line:   66,
																},
															},
														},
														Name: "KafkaMsgRate",
													},
													Rbrack: nil,
												},
												Operator: 8,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 82,
																Line:   66,
															},
															File:   "alert_test.flux",
															Source: "l_threshold",
															Start: ast.Position{
																Column: 71,
																Line:   66,
															},
														},
													},
													Name: "l_threshold",
												},
											},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   66,
													},
													File:   "alert_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 16,
														Line:   66,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   66,
														},
														File:   "alert_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 16,
															Line:   66,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   67,
									},
									File:   "alert_test.flux",
									Source: "tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold\n    )",
									Start: ast.Position{
										Column: 8,
										Line:   60,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   60,
										},
										File:   "alert_test.flux",
										Source: "tickscript.alert",
										Start: ast.Position{
											Column: 8,
											Line:   60,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   60,
											},
											File:   "alert_test.flux",
											Source: "tickscript",
											Start: ast.Position{
												Column: 8,
												Line:   60,
											},
										},
									},
									Name: "tickscript",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   60,
											},
											File:   "alert_test.flux",
											Source: "alert",
											Start: ast.Position{
												Column: 19,
												Line:   60,
											},
										},
									},
									Name: "alert",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   68,
							},
							File:   "alert_test.flux",
							Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold\n    )\n    |> drop(columns: [\"_time\"])",
							Start: ast.Position{
								Column: 34,
								Line:   54,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   68,
									},
									File:   "alert_test.flux",
									Source: "columns: [\"_time\"]",
									Start: ast.Position{
										Column: 13,
										Line:   68,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   68,
										},
										File:   "alert_test.flux",
										Source: "columns: [\"_time\"]",
										Start: ast.Position{
											Column: 13,
											Line:   68,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   68,
											},
											File:   "alert_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   68,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   68,
											},
											File:   "alert_test.flux",
											Source: "[\"_time\"]",
											Start: ast.Position{
												Column: 22,
												Line:   68,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   68,
												},
												File:   "alert_test.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 23,
													Line:   68,
												},
											},
										},
										Value: "_time",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   68,
								},
								File:   "alert_test.flux",
								Source: "drop(columns: [\"_time\"])",
								Start: ast.Position{
									Column: 8,
									Line:   68,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   68,
									},
									File:   "alert_test.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 8,
										Line:   68,
									},
								},
							},
							Name: "drop",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   54,
							},
							File:   "alert_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   54,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   54,
								},
								File:   "alert_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   54,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   54,
							},
							File:   "alert_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   54,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   74,
						},
						File:   "alert_test.flux",
						Source: "_tickscript_alert = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_alert,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   70,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   70,
							},
							File:   "alert_test.flux",
							Source: "_tickscript_alert",
							Start: ast.Position{
								Column: 6,
								Line:   70,
							},
						},
					},
					Name: "_tickscript_alert",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   74,
							},
							File:   "alert_test.flux",
							Source: "() => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_alert,\n})",
							Start: ast.Position{
								Column: 26,
								Line:   70,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   74,
								},
								File:   "alert_test.flux",
								Source: "({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_alert,\n})",
								Start: ast.Position{
									Column: 32,
									Line:   70,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   74,
									},
									File:   "alert_test.flux",
									Source: "{\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_alert,\n}",
									Start: ast.Position{
										Column: 33,
										Line:   70,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   71,
										},
										File:   "alert_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 2,
											Line:   71,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   71,
											},
											File:   "alert_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 2,
												Line:   71,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   71,
												},
												File:   "alert_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 29,
													Line:   71,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   71,
													},
													File:   "alert_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 29,
														Line:   71,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   71,
														},
														File:   "alert_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 29,
															Line:   71,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   71,
														},
														File:   "alert_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 34,
															Line:   71,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   71,
											},
											File:   "alert_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 9,
												Line:   71,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   71,
												},
												File:   "alert_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 9,
													Line:   71,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   71,
													},
													File:   "alert_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   71,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   71,
													},
													File:   "alert_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 17,
														Line:   71,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   72,
										},
										File:   "alert_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 2,
											Line:   72,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   72,
											},
											File:   "alert_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 2,
												Line:   72,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   72,
												},
												File:   "alert_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 24,
													Line:   72,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   72,
													},
													File:   "alert_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 24,
														Line:   72,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   72,
														},
														File:   "alert_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 24,
															Line:   72,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   72,
														},
														File:   "alert_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 29,
															Line:   72,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   72,
											},
											File:   "alert_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 8,
												Line:   72,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   72,
												},
												File:   "alert_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 8,
													Line:   72,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   72,
													},
													File:   "alert_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 8,
														Line:   72,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   72,
													},
													File:   "alert_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 16,
														Line:   72,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   73,
										},
										File:   "alert_test.flux",
										Source: "fn: tickscript_alert",
										Start: ast.Position{
											Column: 2,
											Line:   73,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 4,
												Line:   73,
											},
											File:   "alert_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 2,
												Line:   73,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   73,
											},
											File:   "alert_test.flux",
											Source: "tickscript_alert",
											Start: ast.Position{
												Column: 6,
												Line:   73,
											},
										},
									},
									Name: "tickscript_alert",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   74,
					},
					File:   "alert_test.flux",
					Source: "test _tickscript_alert = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_alert,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   70,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "alert_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "alert_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   4,
					},
					File:   "alert_test.flux",
					Source: "import \"csv\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   4,
						},
						File:   "alert_test.flux",
						Source: "\"csv\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "csv",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 39,
						Line:   5,
					},
					File:   "alert_test.flux",
					Source: "import \"contrib/bonitoo-io/tickscript\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 39,
							Line:   5,
						},
						File:   "alert_test.flux",
						Source: "\"contrib/bonitoo-io/tickscript\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "contrib/bonitoo-io/tickscript",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   6,
					},
					File:   "alert_test.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   6,
						},
						File:   "alert_test.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 36,
						Line:   7,
					},
					File:   "alert_test.flux",
					Source: "import \"influxdata/influxdb/schema\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   7,
						},
						File:   "alert_test.flux",
						Source: "\"influxdata/influxdb/schema\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "influxdata/influxdb/schema",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "alert_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   1,
					},
					File:   "alert_test.flux",
					Source: "package tickscript_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   1,
						},
						File:   "alert_test.flux",
						Source: "tickscript_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "tickscript_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   75,
				},
				File:   "alert_with_topic_test.flux",
				Source: "package tickscript_test\n\nimport \"testing\"\nimport \"csv\"\nimport \"contrib/bonitoo-io/tickscript\"\nimport \"influxdata/influxdb/monitor\"\nimport \"influxdata/influxdb/schema\"\n\noption now = () => (2020-11-25T14:05:30Z)\n\n// overwrite as buckets are not avail in Flux tests\noption monitor.write = (tables=<-) => tables\noption monitor.log = (tables=<-) => tables\n\ninData = \"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"\n\noutData = \"\n#group,false,false,false,true,true,true,true,false,true,false,true,false,true,false,true,true\n#datatype,string,long,double,string,string,string,string,string,string,long,string,string,string,string,string,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,KafkaMsgRate,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,details,host,id,realm,_topic\n,,0,1.819231109049999,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.819231109049999,testm,1606313103477635916,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,0,1.635878190200181,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.635878190200181,testm,1606313104541635074,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,0,1.33716449678206,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.33716449678206,testm,1606313108868317091,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,1,39.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 39.33716449678206,testm,1606313105623191313,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,1,26.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 26.33716449678206,testm,1606313106696061106,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,2,8.33716449678206,rate-check,Rate Check,warn,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: warn - 8.33716449678206,testm,1606313107768317097,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n\"\n\ncheck = {\n  _check_id: \"rate-check\",\n  _check_name: \"Rate Check\",\n  _type: \"custom\", // tickscript?\n  tags: {},\n}\n\nmetric_type = \"kafka_message_in_rate\"\ntier = \"ft\"\nh_threshold = 10\nw_threshold = 5\nl_threshold = .002\n\ntickscript_alert = (table=<-) => table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n        topic: \"TESTING\"\n    )\n    |> drop(columns: [\"_time\"])\n\ntest _tickscript_alert = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_alert,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   9,
						},
						File:   "alert_with_topic_test.flux",
						Source: "now = () => (2020-11-25T14:05:30Z)",
						Start: ast.Position{
							Column: 8,
							Line:   9,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   9,
							},
							File:   "alert_with_topic_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   9,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   9,
							},
							File:   "alert_with_topic_test.flux",
							Source: "() => (2020-11-25T14:05:30Z)",
							Start: ast.Position{
								Column: 14,
								Line:   9,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   9,
								},
								File:   "alert_with_topic_test.flux",
								Source: "(2020-11-25T14:05:30Z)",
								Start: ast.Position{
									Column: 20,
									Line:   9,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   9,
									},
									File:   "alert_with_topic_test.flux",
									Source: "2020-11-25T14:05:30Z",
									Start: ast.Position{
										Column: 21,
										Line:   9,
									},
								},
							},
							Value: parser.MustParseTime("2020-11-25T14:05:30Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   9,
					},
					File:   "alert_with_topic_test.flux",
					Source: "option now = () => (2020-11-25T14:05:30Z)",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 45,
							Line:   12,
						},
						File:   "alert_with_topic_test.flux",
						Source: "monitor.write = (tables=<-) => tables",
						Start: ast.Position{
							Column: 8,
							Line:   12,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   12,
							},
							File:   "alert_with_topic_test.flux",
							Source: "(tables=<-) => tables",
							Start: ast.Position{
								Column: 24,
								Line:   12,
							},
						},
					},
					Body: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   12,
								},
								File:   "alert_with_topic_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 39,
									Line:   12,
								},
							},
						},
						Name: "tables",
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   12,
								},
								File:   "alert_with_topic_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 25,
									Line:   12,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   12,
									},
									File:   "alert_with_topic_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   12,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   12,
								},
								File:   "alert_with_topic_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 32,
									Line:   12,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   12,
							},
							File:   "alert_with_topic_test.flux",
							Source: "monitor.write",
							Start: ast.Position{
								Column: 8,
								Line:   12,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   12,
								},
								File:   "alert_with_topic_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   12,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   12,
								},
								File:   "alert_with_topic_test.flux",
								Source: "write",
								Start: ast.Position{
									Column: 16,
									Line:   12,
								},
							},
						},
						Name: "write",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// overwrite as buckets are not avail in Flux tests\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 45,
						Line:   12,
					},
					File:   "alert_with_topic_test.flux",
					Source: "option monitor.write = (tables=<-) => tables",
					Start: ast.Position{
						Column: 1,
						Line:   12,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 43,
							Line:   13,
						},
						File:   "alert_with_topic_test.flux",
						Source: "monitor.log = (tables=<-) => tables",
						Start: ast.Position{
							Column: 8,
							Line:   13,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   13,
							},
							File:   "alert_with_topic_test.flux",
							Source: "(tables=<-) => tables",
							Start: ast.Position{
								Column: 22,
								Line:   13,
							},
						},
					},
					Body: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   13,
								},
								File:   "alert_with_topic_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 37,
									Line:   13,
								},
							},
						},
						Name: "tables",
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   13,
								},
								File:   "alert_with_topic_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 23,
									Line:   13,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   13,
									},
									File:   "alert_with_topic_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   13,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   13,
								},
								File:   "alert_with_topic_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 30,
									Line:   13,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   13,
							},
							File:   "alert_with_topic_test.flux",
							Source: "monitor.log",
							Start: ast.Position{
								Column: 8,
								Line:   13,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   13,
								},
								File:   "alert_with_topic_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   13,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   13,
								},
								File:   "alert_with_topic_test.flux",
								Source: "log",
								Start: ast.Position{
									Column: 16,
									Line:   13,
								},
							},
						},
						Name: "log",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 43,
						Line:   13,
					},
					File:   "alert_with_topic_test.flux",
					Source: "option monitor.log = (tables=<-) => tables",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   26,
					},
					File:   "alert_with_topic_test.flux",
					Source: "inData = \"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   15,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   15,
						},
						File:   "alert_with_topic_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   15,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   26,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   15,
						},
					},
				},
				Value: "\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   39,
					},
					File:   "alert_with_topic_test.flux",
					Source: "outData = \"\n#group,false,false,false,true,true,true,true,false,true,false,true,false,true,false,true,true\n#datatype,string,long,double,string,string,string,string,string,string,long,string,string,string,string,string,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,KafkaMsgRate,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,details,host,id,realm,_topic\n,,0,1.819231109049999,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.819231109049999,testm,1606313103477635916,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,0,1.635878190200181,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.635878190200181,testm,1606313104541635074,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,0,1.33716449678206,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.33716449678206,testm,1606313108868317091,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,1,39.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 39.33716449678206,testm,1606313105623191313,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,1,26.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 26.33716449678206,testm,1606313106696061106,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,2,8.33716449678206,rate-check,Rate Check,warn,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: warn - 8.33716449678206,testm,1606313107768317097,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   28,
						},
						File:   "alert_with_topic_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   28,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   39,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"\n#group,false,false,false,true,true,true,true,false,true,false,true,false,true,false,true,true\n#datatype,string,long,double,string,string,string,string,string,string,long,string,string,string,string,string,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,KafkaMsgRate,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,details,host,id,realm,_topic\n,,0,1.819231109049999,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.819231109049999,testm,1606313103477635916,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,0,1.635878190200181,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.635878190200181,testm,1606313104541635074,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,0,1.33716449678206,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.33716449678206,testm,1606313108868317091,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,1,39.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 39.33716449678206,testm,1606313105623191313,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,1,26.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 26.33716449678206,testm,1606313106696061106,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,2,8.33716449678206,rate-check,Rate Check,warn,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: warn - 8.33716449678206,testm,1606313107768317097,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   28,
						},
					},
				},
				Value: "\n#group,false,false,false,true,true,true,true,false,true,false,true,false,true,false,true,true\n#datatype,string,long,double,string,string,string,string,string,string,long,string,string,string,string,string,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,KafkaMsgRate,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,details,host,id,realm,_topic\n,,0,1.819231109049999,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.819231109049999,testm,1606313103477635916,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,0,1.635878190200181,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.635878190200181,testm,1606313104541635074,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,0,1.33716449678206,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.33716449678206,testm,1606313108868317091,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,1,39.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 39.33716449678206,testm,1606313105623191313,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,1,26.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 26.33716449678206,testm,1606313106696061106,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,2,8.33716449678206,rate-check,Rate Check,warn,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: warn - 8.33716449678206,testm,1606313107768317097,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   46,
					},
					File:   "alert_with_topic_test.flux",
					Source: "check = {\n  _check_id: \"rate-check\",\n  _check_name: \"Rate Check\",\n  _type: \"custom\", // tickscript?\n  tags: {},\n}",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   41,
						},
						File:   "alert_with_topic_test.flux",
						Source: "check",
						Start: ast.Position{
							Column: 1,
							Line:   41,
						},
					},
				},
				Name: "check",
			},
			Init: &ast.ObjectExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   46,
						},
						File:   "alert_with_topic_test.flux",
						Source: "{\n  _check_id: \"rate-check\",\n  _check_name: \"Rate Check\",\n  _type: \"custom\", // tickscript?\n  tags: {},\n}",
						Start: ast.Position{
							Column: 9,
							Line:   41,
						},
					},
				},
				Lbrace: nil,
				Properties: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   42,
							},
							File:   "alert_with_topic_test.flux",
							Source: "_check_id: \"rate-check\"",
							Start: ast.Position{
								Column: 3,
								Line:   42,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   42,
								},
								File:   "alert_with_topic_test.flux",
								Source: "_check_id",
								Start: ast.Position{
									Column: 3,
									Line:   42,
								},
							},
						},
						Name: "_check_id",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   42,
								},
								File:   "alert_with_topic_test.flux",
								Source: "\"rate-check\"",
								Start: ast.Position{
									Column: 14,
									Line:   42,
								},
							},
						},
						Value: "rate-check",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   43,
							},
							File:   "alert_with_topic_test.flux",
							Source: "_check_name: \"Rate Check\"",
							Start: ast.Position{
								Column: 3,
								Line:   43,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   43,
								},
								File:   "alert_with_topic_test.flux",
								Source: "_check_name",
								Start: ast.Position{
									Column: 3,
									Line:   43,
								},
							},
						},
						Name: "_check_name",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   43,
								},
								File:   "alert_with_topic_test.flux",
								Source: "\"Rate Check\"",
								Start: ast.Position{
									Column: 16,
									Line:   43,
								},
							},
						},
						Value: "Rate Check",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   44,
							},
							File:   "alert_with_topic_test.flux",
							Source: "_type: \"custom\"",
							Start: ast.Position{
								Column: 3,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 8,
									Line:   44,
								},
								File:   "alert_with_topic_test.flux",
								Source: "_type",
								Start: ast.Position{
									Column: 3,
									Line:   44,
								},
							},
						},
						Name: "_type",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   44,
								},
								File:   "alert_with_topic_test.flux",
								Source: "\"custom\"",
								Start: ast.Position{
									Column: 10,
									Line:   44,
								},
							},
						},
						Value: "custom",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   45,
							},
							File:   "alert_with_topic_test.flux",
							Source: "tags: {}",
							Start: ast.Position{
								Column: 3,
								Line:   45,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: []ast.Comment{ast.Comment{Text: "// tickscript?\n"}},
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 7,
									Line:   45,
								},
								File:   "alert_with_topic_test.flux",
								Source: "tags",
								Start: ast.Position{
									Column: 3,
									Line:   45,
								},
							},
						},
						Name: "tags",
					},
					Separator: nil,
					Value: &ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   45,
								},
								File:   "alert_with_topic_test.flux",
								Source: "{}",
								Start: ast.Position{
									Column: 9,
									Line:   45,
								},
							},
						},
						Lbrace:     nil,
						Properties: []*ast.Property{},
						Rbrace:     nil,
						With:       nil,
					},
				}},
				Rbrace: nil,
				With:   nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 38,
						Line:   48,
					},
					File:   "alert_with_topic_test.flux",
					Source: "metric_type = \"kafka_message_in_rate\"",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   48,
						},
						File:   "alert_with_topic_test.flux",
						Source: "metric_type",
						Start: ast.Position{
							Column: 1,
							Line:   48,
						},
					},
				},
				Name: "metric_type",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   48,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"kafka_message_in_rate\"",
						Start: ast.Position{
							Column: 15,
							Line:   48,
						},
					},
				},
				Value: "kafka_message_in_rate",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   49,
					},
					File:   "alert_with_topic_test.flux",
					Source: "tier = \"ft\"",
					Start: ast.Position{
						Column: 1,
						Line:   49,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   49,
						},
						File:   "alert_with_topic_test.flux",
						Source: "tier",
						Start: ast.Position{
							Column: 1,
							Line:   49,
						},
					},
				},
				Name: "tier",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   49,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"ft\"",
						Start: ast.Position{
							Column: 8,
							Line:   49,
						},
					},
				},
				Value: "ft",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   50,
					},
					File:   "alert_with_topic_test.flux",
					Source: "h_threshold = 10",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   50,
						},
						File:   "alert_with_topic_test.flux",
						Source: "h_threshold",
						Start: ast.Position{
							Column: 1,
							Line:   50,
						},
					},
				},
				Name: "h_threshold",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   50,
						},
						File:   "alert_with_topic_test.flux",
						Source: "10",
						Start: ast.Position{
							Column: 15,
							Line:   50,
						},
					},
				},
				Value: int64(10),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   51,
					},
					File:   "alert_with_topic_test.flux",
					Source: "w_threshold = 5",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   51,
						},
						File:   "alert_with_topic_test.flux",
						Source: "w_threshold",
						Start: ast.Position{
							Column: 1,
							Line:   51,
						},
					},
				},
				Name: "w_threshold",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   51,
						},
						File:   "alert_with_topic_test.flux",
						Source: "5",
						Start: ast.Position{
							Column: 15,
							Line:   51,
						},
					},
				},
				Value: int64(5),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   52,
					},
					File:   "alert_with_topic_test.flux",
					Source: "l_threshold = .002",
					Start: ast.Position{
						Column: 1,
						Line:   52,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   52,
						},
						File:   "alert_with_topic_test.flux",
						Source: "l_threshold",
						Start: ast.Position{
							Column: 1,
							Line:   52,
						},
					},
				},
				Name: "l_threshold",
			},
			Init: &ast.FloatLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   52,
						},
						File:   "alert_with_topic_test.flux",
						Source: ".002",
						Start: ast.Position{
							Column: 15,
							Line:   52,
						},
					},
				},
				Value: 0.002,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   69,
					},
					File:   "alert_with_topic_test.flux",
					Source: "tickscript_alert = (table=<-) => table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n        topic: \"TESTING\"\n    )\n    |> drop(columns: [\"_time\"])",
					Start: ast.Position{
						Column: 1,
						Line:   54,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   54,
						},
						File:   "alert_with_topic_test.flux",
						Source: "tickscript_alert",
						Start: ast.Position{
							Column: 1,
							Line:   54,
						},
					},
				},
				Name: "tickscript_alert",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   69,
						},
						File:   "alert_with_topic_test.flux",
						Source: "(table=<-) => table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n        topic: \"TESTING\"\n    )\n    |> drop(columns: [\"_time\"])",
						Start: ast.Position{
							Column: 20,
							Line:   54,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   54,
														},
														File:   "alert_with_topic_test.flux",
														Source: "table",
														Start: ast.Position{
															Column: 34,
															Line:   54,
														},
													},
												},
												Name: "table",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   55,
													},
													File:   "alert_with_topic_test.flux",
													Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)",
													Start: ast.Position{
														Column: 34,
														Line:   54,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   55,
															},
															File:   "alert_with_topic_test.flux",
															Source: "start: 2020-11-25T14:05:00Z",
															Start: ast.Position{
																Column: 11,
																Line:   55,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   55,
																},
																File:   "alert_with_topic_test.flux",
																Source: "start: 2020-11-25T14:05:00Z",
																Start: ast.Position{
																	Column: 11,
																	Line:   55,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 16,
																		Line:   55,
																	},
																	File:   "alert_with_topic_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 11,
																		Line:   55,
																	},
																},
															},
															Name: "start",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   55,
																	},
																	File:   "alert_with_topic_test.flux",
																	Source: "2020-11-25T14:05:00Z",
																	Start: ast.Position{
																		Column: 18,
																		Line:   55,
																	},
																},
															},
															Value: parser.MustParseTime("2020-11-25T14:05:00Z"),
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   55,
														},
														File:   "alert_with_topic_test.flux",
														Source: "range(start: 2020-11-25T14:05:00Z)",
														Start: ast.Position{
															Column: 5,
															Line:   55,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 10,
																Line:   55,
															},
															File:   "alert_with_topic_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 5,
																Line:   55,
															},
														},
													},
													Name: "range",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   56,
												},
												File:   "alert_with_topic_test.flux",
												Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)",
												Start: ast.Position{
													Column: 34,
													Line:   54,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   56,
														},
														File:   "alert_with_topic_test.flux",
														Source: "fn: (r) => r._field == metric_type and r.realm == tier",
														Start: ast.Position{
															Column: 15,
															Line:   56,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   56,
															},
															File:   "alert_with_topic_test.flux",
															Source: "fn: (r) => r._field == metric_type and r.realm == tier",
															Start: ast.Position{
																Column: 15,
																Line:   56,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   56,
																},
																File:   "alert_with_topic_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 15,
																	Line:   56,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.FunctionExpression{
														Arrow: nil,
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   56,
																},
																File:   "alert_with_topic_test.flux",
																Source: "(r) => r._field == metric_type and r.realm == tier",
																Start: ast.Position{
																	Column: 19,
																	Line:   56,
																},
															},
														},
														Body: &ast.LogicalExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 69,
																		Line:   56,
																	},
																	File:   "alert_with_topic_test.flux",
																	Source: "r._field == metric_type and r.realm == tier",
																	Start: ast.Position{
																		Column: 26,
																		Line:   56,
																	},
																},
															},
															Left: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   56,
																		},
																		File:   "alert_with_topic_test.flux",
																		Source: "r._field == metric_type",
																		Start: ast.Position{
																			Column: 26,
																			Line:   56,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 34,
																				Line:   56,
																			},
																			File:   "alert_with_topic_test.flux",
																			Source: "r._field",
																			Start: ast.Position{
																				Column: 26,
																				Line:   56,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 27,
																					Line:   56,
																				},
																				File:   "alert_with_topic_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 26,
																					Line:   56,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 34,
																					Line:   56,
																				},
																				File:   "alert_with_topic_test.flux",
																				Source: "_field",
																				Start: ast.Position{
																					Column: 28,
																					Line:   56,
																				},
																			},
																		},
																		Name: "_field",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 49,
																				Line:   56,
																			},
																			File:   "alert_with_topic_test.flux",
																			Source: "metric_type",
																			Start: ast.Position{
																				Column: 38,
																				Line:   56,
																			},
																		},
																	},
																	Name: "metric_type",
																},
															},
															Operator: 1,
															Right: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 69,
																			Line:   56,
																		},
																		File:   "alert_with_topic_test.flux",
																		Source: "r.realm == tier",
																		Start: ast.Position{
																			Column: 54,
																			Line:   56,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 61,
																				Line:   56,
																			},
																			File:   "alert_with_topic_test.flux",
																			Source: "r.realm",
																			Start: ast.Position{
																				Column: 54,
																				Line:   56,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 55,
																					Line:   56,
																				},
																				File:   "alert_with_topic_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 54,
																					Line:   56,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 61,
																					Line:   56,
																				},
																				File:   "alert_with_topic_test.flux",
																				Source: "realm",
																				Start: ast.Position{
																					Column: 56,
																					Line:   56,
																				},
																			},
																		},
																		Name: "realm",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 69,
																				Line:   56,
																			},
																			File:   "alert_with_topic_test.flux",
																			Source: "tier",
																			Start: ast.Position{
																				Column: 65,
																				Line:   56,
																			},
																		},
																	},
																	Name: "tier",
																},
															},
														},
														Lparen: nil,
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   56,
																	},
																	File:   "alert_with_topic_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 20,
																		Line:   56,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   56,
																		},
																		File:   "alert_with_topic_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 20,
																			Line:   56,
																		},
																	},
																},
																Name: "r",
															},
															Separator: nil,
															Value:     nil,
														}},
														Rparan: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   56,
													},
													File:   "alert_with_topic_test.flux",
													Source: "filter(fn: (r) => r._field == metric_type and r.realm == tier)",
													Start: ast.Position{
														Column: 8,
														Line:   56,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   56,
														},
														File:   "alert_with_topic_test.flux",
														Source: "filter",
														Start: ast.Position{
															Column: 8,
															Line:   56,
														},
													},
												},
												Name: "filter",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   57,
											},
											File:   "alert_with_topic_test.flux",
											Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()",
											Start: ast.Position{
												Column: 34,
												Line:   54,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   57,
												},
												File:   "alert_with_topic_test.flux",
												Source: "schema.fieldsAsCols()",
												Start: ast.Position{
													Column: 8,
													Line:   57,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   57,
													},
													File:   "alert_with_topic_test.flux",
													Source: "schema.fieldsAsCols",
													Start: ast.Position{
														Column: 8,
														Line:   57,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   57,
														},
														File:   "alert_with_topic_test.flux",
														Source: "schema",
														Start: ast.Position{
															Column: 8,
															Line:   57,
														},
													},
												},
												Name: "schema",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   57,
														},
														File:   "alert_with_topic_test.flux",
														Source: "fieldsAsCols",
														Start: ast.Position{
															Column: 15,
															Line:   57,
														},
													},
												},
												Name: "fieldsAsCols",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   58,
										},
										File:   "alert_with_topic_test.flux",
										Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")",
										Start: ast.Position{
											Column: 34,
											Line:   54,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   58,
												},
												File:   "alert_with_topic_test.flux",
												Source: "column: metric_type, as: \"KafkaMsgRate\"",
												Start: ast.Position{
													Column: 26,
													Line:   58,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   58,
													},
													File:   "alert_with_topic_test.flux",
													Source: "column: metric_type",
													Start: ast.Position{
														Column: 26,
														Line:   58,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   58,
														},
														File:   "alert_with_topic_test.flux",
														Source: "column",
														Start: ast.Position{
															Column: 26,
															Line:   58,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   58,
														},
														File:   "alert_with_topic_test.flux",
														Source: "metric_type",
														Start: ast.Position{
															Column: 34,
															Line:   58,
														},
													},
												},
												Name: "metric_type",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 65,
														Line:   58,
													},
													File:   "alert_with_topic_test.flux",
													Source: "as: \"KafkaMsgRate\"",
													Start: ast.Position{
														Column: 47,
														Line:   58,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   58,
														},
														File:   "alert_with_topic_test.flux",
														Source: "as",
														Start: ast.Position{
															Column: 47,
															Line:   58,
														},
													},
												},
												Name: "as",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   58,
														},
														File:   "alert_with_topic_test.flux",
														Source: "\"KafkaMsgRate\"",
														Start: ast.Position{
															Column: 51,
															Line:   58,
														},
													},
												},
												Value: "KafkaMsgRate",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   58,
											},
											File:   "alert_with_topic_test.flux",
											Source: "tickscript.select(column: metric_type, as: \"KafkaMsgRate\")",
											Start: ast.Position{
												Column: 8,
												Line:   58,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   58,
												},
												File:   "alert_with_topic_test.flux",
												Source: "tickscript.select",
												Start: ast.Position{
													Column: 8,
													Line:   58,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   58,
													},
													File:   "alert_with_topic_test.flux",
													Source: "tickscript",
													Start: ast.Position{
														Column: 8,
														Line:   58,
													},
												},
											},
											Name: "tickscript",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   58,
													},
													File:   "alert_with_topic_test.flux",
													Source: "select",
													Start: ast.Position{
														Column: 19,
														Line:   58,
													},
												},
											},
											Name: "select",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   59,
									},
									File:   "alert_with_topic_test.flux",
									Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])",
									Start: ast.Position{
										Column: 34,
										Line:   54,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   59,
											},
											File:   "alert_with_topic_test.flux",
											Source: "columns: [\"host\", \"realm\"]",
											Start: ast.Position{
												Column: 27,
												Line:   59,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   59,
												},
												File:   "alert_with_topic_test.flux",
												Source: "columns: [\"host\", \"realm\"]",
												Start: ast.Position{
													Column: 27,
													Line:   59,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   59,
													},
													File:   "alert_with_topic_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 27,
														Line:   59,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   59,
													},
													File:   "alert_with_topic_test.flux",
													Source: "[\"host\", \"realm\"]",
													Start: ast.Position{
														Column: 36,
														Line:   59,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   59,
														},
														File:   "alert_with_topic_test.flux",
														Source: "\"host\"",
														Start: ast.Position{
															Column: 37,
															Line:   59,
														},
													},
												},
												Value: "host",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   59,
														},
														File:   "alert_with_topic_test.flux",
														Source: "\"realm\"",
														Start: ast.Position{
															Column: 45,
															Line:   59,
														},
													},
												},
												Value: "realm",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   59,
										},
										File:   "alert_with_topic_test.flux",
										Source: "tickscript.groupBy(columns: [\"host\", \"realm\"])",
										Start: ast.Position{
											Column: 8,
											Line:   59,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   59,
											},
											File:   "alert_with_topic_test.flux",
											Source: "tickscript.groupBy",
											Start: ast.Position{
												Column: 8,
												Line:   59,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   59,
												},
												File:   "alert_with_topic_test.flux",
												Source: "tickscript",
												Start: ast.Position{
													Column: 8,
													Line:   59,
												},
											},
										},
										Name: "tickscript",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   59,
												},
												File:   "alert_with_topic_test.flux",
												Source: "groupBy",
												Start: ast.Position{
													Column: 19,
													Line:   59,
												},
											},
										},
										Name: "groupBy",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   68,
								},
								File:   "alert_with_topic_test.flux",
								Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n        topic: \"TESTING\"\n    )",
								Start: ast.Position{
									Column: 34,
									Line:   54,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   67,
										},
										File:   "alert_with_topic_test.flux",
										Source: "check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n        topic: \"TESTING\"",
										Start: ast.Position{
											Column: 9,
											Line:   61,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   61,
											},
											File:   "alert_with_topic_test.flux",
											Source: "check: check",
											Start: ast.Position{
												Column: 9,
												Line:   61,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   61,
												},
												File:   "alert_with_topic_test.flux",
												Source: "check",
												Start: ast.Position{
													Column: 9,
													Line:   61,
												},
											},
										},
										Name: "check",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   61,
												},
												File:   "alert_with_topic_test.flux",
												Source: "check",
												Start: ast.Position{
													Column: 16,
													Line:   61,
												},
											},
										},
										Name: "check",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 102,
												Line:   62,
											},
											File:   "alert_with_topic_test.flux",
											Source: "id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\"",
											Start: ast.Position{
												Column: 9,
												Line:   62,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   62,
												},
												File:   "alert_with_topic_test.flux",
												Source: "id",
												Start: ast.Position{
													Column: 9,
													Line:   62,
												},
											},
										},
										Name: "id",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 102,
													Line:   62,
												},
												File:   "alert_with_topic_test.flux",
												Source: "(r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\"",
												Start: ast.Position{
													Column: 13,
													Line:   62,
												},
											},
										},
										Body: &ast.StringExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 102,
														Line:   62,
													},
													File:   "alert_with_topic_test.flux",
													Source: "\"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\"",
													Start: ast.Position{
														Column: 20,
														Line:   62,
													},
												},
											},
											Parts: []ast.StringExpressionPart{&ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   62,
														},
														File:   "alert_with_topic_test.flux",
														Source: "Realm: ",
														Start: ast.Position{
															Column: 21,
															Line:   62,
														},
													},
												},
												Value: "Realm: ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   62,
														},
														File:   "alert_with_topic_test.flux",
														Source: "${r.realm}",
														Start: ast.Position{
															Column: 28,
															Line:   62,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   62,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r.realm",
															Start: ast.Position{
																Column: 30,
																Line:   62,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   62,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 30,
																	Line:   62,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   62,
																},
																File:   "alert_with_topic_test.flux",
																Source: "realm",
																Start: ast.Position{
																	Column: 32,
																	Line:   62,
																},
															},
														},
														Name: "realm",
													},
													Rbrack: nil,
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 51,
															Line:   62,
														},
														File:   "alert_with_topic_test.flux",
														Source: " - Hostname: ",
														Start: ast.Position{
															Column: 38,
															Line:   62,
														},
													},
												},
												Value: " - Hostname: ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   62,
														},
														File:   "alert_with_topic_test.flux",
														Source: "${r.host}",
														Start: ast.Position{
															Column: 51,
															Line:   62,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 59,
																Line:   62,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r.host",
															Start: ast.Position{
																Column: 53,
																Line:   62,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 54,
																	Line:   62,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 53,
																	Line:   62,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 59,
																	Line:   62,
																},
																File:   "alert_with_topic_test.flux",
																Source: "host",
																Start: ast.Position{
																	Column: 55,
																	Line:   62,
																},
															},
														},
														Name: "host",
													},
													Rbrack: nil,
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   62,
														},
														File:   "alert_with_topic_test.flux",
														Source: " / Metric: ",
														Start: ast.Position{
															Column: 60,
															Line:   62,
														},
													},
												},
												Value: " / Metric: ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 85,
															Line:   62,
														},
														File:   "alert_with_topic_test.flux",
														Source: "${metric_type}",
														Start: ast.Position{
															Column: 71,
															Line:   62,
														},
													},
												},
												Expression: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 84,
																Line:   62,
															},
															File:   "alert_with_topic_test.flux",
															Source: "metric_type",
															Start: ast.Position{
																Column: 73,
																Line:   62,
															},
														},
													},
													Name: "metric_type",
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 101,
															Line:   62,
														},
														File:   "alert_with_topic_test.flux",
														Source: " threshold alert",
														Start: ast.Position{
															Column: 85,
															Line:   62,
														},
													},
												},
												Value: " threshold alert",
											}},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   62,
													},
													File:   "alert_with_topic_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 14,
														Line:   62,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   62,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   62,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   63,
											},
											File:   "alert_with_topic_test.flux",
											Source: "message: (r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\"",
											Start: ast.Position{
												Column: 9,
												Line:   63,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   63,
												},
												File:   "alert_with_topic_test.flux",
												Source: "message",
												Start: ast.Position{
													Column: 9,
													Line:   63,
												},
											},
										},
										Name: "message",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 77,
													Line:   63,
												},
												File:   "alert_with_topic_test.flux",
												Source: "(r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\"",
												Start: ast.Position{
													Column: 18,
													Line:   63,
												},
											},
										},
										Body: &ast.StringExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 77,
														Line:   63,
													},
													File:   "alert_with_topic_test.flux",
													Source: "\"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\"",
													Start: ast.Position{
														Column: 25,
														Line:   63,
													},
												},
											},
											Parts: []ast.StringExpressionPart{&ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   63,
														},
														File:   "alert_with_topic_test.flux",
														Source: "${r.id}",
														Start: ast.Position{
															Column: 26,
															Line:   63,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 32,
																Line:   63,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r.id",
															Start: ast.Position{
																Column: 28,
																Line:   63,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 29,
																	Line:   63,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 28,
																	Line:   63,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 32,
																	Line:   63,
																},
																File:   "alert_with_topic_test.flux",
																Source: "id",
																Start: ast.Position{
																	Column: 30,
																	Line:   63,
																},
															},
														},
														Name: "id",
													},
													Rbrack: nil,
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   63,
														},
														File:   "alert_with_topic_test.flux",
														Source: ": ",
														Start: ast.Position{
															Column: 33,
															Line:   63,
														},
													},
												},
												Value: ": ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   63,
														},
														File:   "alert_with_topic_test.flux",
														Source: "${r._level}",
														Start: ast.Position{
															Column: 35,
															Line:   63,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   63,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r._level",
															Start: ast.Position{
																Column: 37,
																Line:   63,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   63,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 37,
																	Line:   63,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   63,
																},
																File:   "alert_with_topic_test.flux",
																Source: "_level",
																Start: ast.Position{
																	Column: 39,
																	Line:   63,
																},
															},
														},
														Name: "_level",
													},
													Rbrack: nil,
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   63,
														},
														File:   "alert_with_topic_test.flux",
														Source: " - ",
														Start: ast.Position{
															Column: 46,
															Line:   63,
														},
													},
												},
												Value: " - ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 76,
															Line:   63,
														},
														File:   "alert_with_topic_test.flux",
														Source: "${string(v:r.KafkaMsgRate)}",
														Start: ast.Position{
															Column: 49,
															Line:   63,
														},
													},
												},
												Expression: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 74,
																	Line:   63,
																},
																File:   "alert_with_topic_test.flux",
																Source: "v:r.KafkaMsgRate",
																Start: ast.Position{
																	Column: 58,
																	Line:   63,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 74,
																		Line:   63,
																	},
																	File:   "alert_with_topic_test.flux",
																	Source: "v:r.KafkaMsgRate",
																	Start: ast.Position{
																		Column: 58,
																		Line:   63,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   63,
																		},
																		File:   "alert_with_topic_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 58,
																			Line:   63,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 74,
																			Line:   63,
																		},
																		File:   "alert_with_topic_test.flux",
																		Source: "r.KafkaMsgRate",
																		Start: ast.Position{
																			Column: 60,
																			Line:   63,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 61,
																				Line:   63,
																			},
																			File:   "alert_with_topic_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 60,
																				Line:   63,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 74,
																				Line:   63,
																			},
																			File:   "alert_with_topic_test.flux",
																			Source: "KafkaMsgRate",
																			Start: ast.Position{
																				Column: 62,
																				Line:   63,
																			},
																		},
																	},
																	Name: "KafkaMsgRate",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 75,
																Line:   63,
															},
															File:   "alert_with_topic_test.flux",
															Source: "string(v:r.KafkaMsgRate)",
															Start: ast.Position{
																Column: 51,
																Line:   63,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   63,
																},
																File:   "alert_with_topic_test.flux",
																Source: "string",
																Start: ast.Position{
																	Column: 51,
																	Line:   63,
																},
															},
														},
														Name: "string",
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   63,
													},
													File:   "alert_with_topic_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 19,
														Line:   63,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   63,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 19,
															Line:   63,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   64,
											},
											File:   "alert_with_topic_test.flux",
											Source: "details: (r) => \"some detail: myrealm=${r.realm}\"",
											Start: ast.Position{
												Column: 9,
												Line:   64,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   64,
												},
												File:   "alert_with_topic_test.flux",
												Source: "details",
												Start: ast.Position{
													Column: 9,
													Line:   64,
												},
											},
										},
										Name: "details",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   64,
												},
												File:   "alert_with_topic_test.flux",
												Source: "(r) => \"some detail: myrealm=${r.realm}\"",
												Start: ast.Position{
													Column: 18,
													Line:   64,
												},
											},
										},
										Body: &ast.StringExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   64,
													},
													File:   "alert_with_topic_test.flux",
													Source: "\"some detail: myrealm=${r.realm}\"",
													Start: ast.Position{
														Column: 25,
														Line:   64,
													},
												},
											},
											Parts: []ast.StringExpressionPart{&ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   64,
														},
														File:   "alert_with_topic_test.flux",
														Source: "some detail: myrealm=",
														Start: ast.Position{
															Column: 26,
															Line:   64,
														},
													},
												},
												Value: "some detail: myrealm=",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 57,
															Line:   64,
														},
														File:   "alert_with_topic_test.flux",
														Source: "${r.realm}",
														Start: ast.Position{
															Column: 47,
															Line:   64,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   64,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r.realm",
															Start: ast.Position{
																Column: 49,
																Line:   64,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 50,
																	Line:   64,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 49,
																	Line:   64,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   64,
																},
																File:   "alert_with_topic_test.flux",
																Source: "realm",
																Start: ast.Position{
																	Column: 51,
																	Line:   64,
																},
															},
														},
														Name: "realm",
													},
													Rbrack: nil,
												},
											}},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   64,
													},
													File:   "alert_with_topic_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 19,
														Line:   64,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   64,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 19,
															Line:   64,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 82,
												Line:   65,
											},
											File:   "alert_with_topic_test.flux",
											Source: "crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold",
											Start: ast.Position{
												Column: 9,
												Line:   65,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   65,
												},
												File:   "alert_with_topic_test.flux",
												Source: "crit",
												Start: ast.Position{
													Column: 9,
													Line:   65,
												},
											},
										},
										Name: "crit",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 82,
													Line:   65,
												},
												File:   "alert_with_topic_test.flux",
												Source: "(r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold",
												Start: ast.Position{
													Column: 15,
													Line:   65,
												},
											},
										},
										Body: &ast.LogicalExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   65,
													},
													File:   "alert_with_topic_test.flux",
													Source: "r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold",
													Start: ast.Position{
														Column: 22,
														Line:   65,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   65,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r.KafkaMsgRate > h_threshold",
														Start: ast.Position{
															Column: 22,
															Line:   65,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   65,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r.KafkaMsgRate",
															Start: ast.Position{
																Column: 22,
																Line:   65,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   65,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 22,
																	Line:   65,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   65,
																},
																File:   "alert_with_topic_test.flux",
																Source: "KafkaMsgRate",
																Start: ast.Position{
																	Column: 24,
																	Line:   65,
																},
															},
														},
														Name: "KafkaMsgRate",
													},
													Rbrack: nil,
												},
												Operator: 10,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   65,
															},
															File:   "alert_with_topic_test.flux",
															Source: "h_threshold",
															Start: ast.Position{
																Column: 39,
																Line:   65,
															},
														},
													},
													Name: "h_threshold",
												},
											},
											Operator: 2,
											Right: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   65,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r.KafkaMsgRate < l_threshold",
														Start: ast.Position{
															Column: 54,
															Line:   65,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   65,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r.KafkaMsgRate",
															Start: ast.Position{
																Column: 54,
																Line:   65,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   65,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 54,
																	Line:   65,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   65,
																},
																File:   "alert_with_topic_test.flux",
																Source: "KafkaMsgRate",
																Start: ast.Position{
																	Column: 56,
																	Line:   65,
																},
															},
														},
														Name: "KafkaMsgRate",
													},
													Rbrack: nil,
												},
												Operator: 8,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 82,
																Line:   65,
															},
															File:   "alert_with_topic_test.flux",
															Source: "l_threshold",
															Start: ast.Position{
																Column: 71,
																Line:   65,
															},
														},
													},
													Name: "l_threshold",
												},
											},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   65,
													},
													File:   "alert_with_topic_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 16,
														Line:   65,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   65,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 16,
															Line:   65,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 82,
												Line:   66,
											},
											File:   "alert_with_topic_test.flux",
											Source: "warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold",
											Start: ast.Position{
												Column: 9,
												Line:   66,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   66,
												},
												File:   "alert_with_topic_test.flux",
												Source: "warn",
												Start: ast.Position{
													Column: 9,
													Line:   66,
												},
											},
										},
										Name: "warn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 82,
													Line:   66,
												},
												File:   "alert_with_topic_test.flux",
												Source: "(r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold",
												Start: ast.Position{
													Column: 15,
													Line:   66,
												},
											},
										},
										Body: &ast.LogicalExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   66,
													},
													File:   "alert_with_topic_test.flux",
													Source: "r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold",
													Start: ast.Position{
														Column: 22,
														Line:   66,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   66,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r.KafkaMsgRate > w_threshold",
														Start: ast.Position{
															Column: 22,
															Line:   66,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   66,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r.KafkaMsgRate",
															Start: ast.Position{
																Column: 22,
																Line:   66,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   66,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 22,
																	Line:   66,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   66,
																},
																File:   "alert_with_topic_test.flux",
																Source: "KafkaMsgRate",
																Start: ast.Position{
																	Column: 24,
																	Line:   66,
																},
															},
														},
														Name: "KafkaMsgRate",
													},
													Rbrack: nil,
												},
												Operator: 10,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   66,
															},
															File:   "alert_with_topic_test.flux",
															Source: "w_threshold",
															Start: ast.Position{
																Column: 39,
																Line:   66,
															},
														},
													},
													Name: "w_threshold",
												},
											},
											Operator: 2,
											Right: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   66,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r.KafkaMsgRate < l_threshold",
														Start: ast.Position{
															Column: 54,
															Line:   66,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   66,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r.KafkaMsgRate",
															Start: ast.Position{
																Column: 54,
																Line:   66,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   66,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 54,
																	Line:   66,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   66,
																},
																File:   "alert_with_topic_test.flux",
																Source: "KafkaMsgRate",
																Start: ast.Position{
																	Column: 56,
																	Line:   66,
																},
															},
														},
														Name: "KafkaMsgRate",
													},
													Rbrack: nil,
												},
												Operator: 8,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 82,
																Line:   66,
															},
															File:   "alert_with_topic_test.flux",
															Source: "l_threshold",
															Start: ast.Position{
																Column: 71,
																Line:   66,
															},
														},
													},
													Name: "l_threshold",
												},
											},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   66,
													},
													File:   "alert_with_topic_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 16,
														Line:   66,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   66,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 16,
															Line:   66,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   67,
											},
											File:   "alert_with_topic_test.flux",
											Source: "topic: \"TESTING\"",
											Start: ast.Position{
												Column: 9,
												Line:   67,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   67,
												},
												File:   "alert_with_topic_test.flux",
												Source: "topic",
												Start: ast.Position{
													Column: 9,
													Line:   67,
												},
											},
										},
										Name: "topic",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   67,
												},
												File:   "alert_with_topic_test.flux",
												Source: "\"TESTING\"",
												Start: ast.Position{
													Column: 16,
													Line:   67,
												},
											},
										},
										Value: "TESTING",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   68,
									},
									File:   "alert_with_topic_test.flux",
									Source: "tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n        topic: \"TESTING\"\n    )",
									Start: ast.Position{
										Column: 8,
										Line:   60,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   60,
										},
										File:   "alert_with_topic_test.flux",
										Source: "tickscript.alert",
										Start: ast.Position{
											Column: 8,
											Line:   60,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   60,
											},
											File:   "alert_with_topic_test.flux",
											Source: "tickscript",
											Start: ast.Position{
												Column: 8,
												Line:   60,
											},
										},
									},
									Name: "tickscript",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   60,
											},
											File:   "alert_with_topic_test.flux",
											Source: "alert",
											Start: ast.Position{
												Column: 19,
												Line:   60,
											},
										},
									},
									Name: "alert",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   69,
							},
							File:   "alert_with_topic_test.flux",
							Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v:r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n        topic: \"TESTING\"\n    )\n    |> drop(columns: [\"_time\"])",
							Start: ast.Position{
								Column: 34,
								Line:   54,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   69,
									},
									File:   "alert_with_topic_test.flux",
									Source: "columns: [\"_time\"]",
									Start: ast.Position{
										Column: 13,
										Line:   69,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   69,
										},
										File:   "alert_with_topic_test.flux",
										Source: "columns: [\"_time\"]",
										Start: ast.Position{
											Column: 13,
											Line:   69,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   69,
											},
											File:   "alert_with_topic_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   69,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   69,
											},
											File:   "alert_with_topic_test.flux",
											Source: "[\"_time\"]",
											Start: ast.Position{
												Column: 22,
												Line:   69,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   69,
												},
												File:   "alert_with_topic_test.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 23,
													Line:   69,
												},
											},
										},
										Value: "_time",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   69,
								},
								File:   "alert_with_topic_test.flux",
								Source: "drop(columns: [\"_time\"])",
								Start: ast.Position{
									Column: 8,
									Line:   69,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   69,
									},
									File:   "alert_with_topic_test.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 8,
										Line:   69,
									},
								},
							},
							Name: "drop",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   54,
							},
							File:   "alert_with_topic_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   54,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   54,
								},
								File:   "alert_with_topic_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   54,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   54,
							},
							File:   "alert_with_topic_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   54,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   75,
						},
						File:   "alert_with_topic_test.flux",
						Source: "_tickscript_alert = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_alert,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   71,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   71,
							},
							File:   "alert_with_topic_test.flux",
							Source: "_tickscript_alert",
							Start: ast.Position{
								Column: 6,
								Line:   71,
							},
						},
					},
					Name: "_tickscript_alert",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   75,
							},
							File:   "alert_with_topic_test.flux",
							Source: "() => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_alert,\n})",
							Start: ast.Position{
								Column: 26,
								Line:   71,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   75,
								},
								File:   "alert_with_topic_test.flux",
								Source: "({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_alert,\n})",
								Start: ast.Position{
									Column: 32,
									Line:   71,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   75,
									},
									File:   "alert_with_topic_test.flux",
									Source: "{\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_alert,\n}",
									Start: ast.Position{
										Column: 33,
										Line:   71,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   72,
										},
										File:   "alert_with_topic_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 2,
											Line:   72,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   72,
											},
											File:   "alert_with_topic_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 2,
												Line:   72,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   72,
												},
												File:   "alert_with_topic_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 29,
													Line:   72,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   72,
													},
													File:   "alert_with_topic_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 29,
														Line:   72,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   72,
														},
														File:   "alert_with_topic_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 29,
															Line:   72,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   72,
														},
														File:   "alert_with_topic_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 34,
															Line:   72,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   72,
											},
											File:   "alert_with_topic_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 9,
												Line:   72,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   72,
												},
												File:   "alert_with_topic_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 9,
													Line:   72,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   72,
													},
													File:   "alert_with_topic_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   72,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   72,
													},
													File:   "alert_with_topic_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 17,
														Line:   72,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   73,
										},
										File:   "alert_with_topic_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 2,
											Line:   73,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   73,
											},
											File:   "alert_with_topic_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 2,
												Line:   73,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   73,
												},
												File:   "alert_with_topic_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 24,
													Line:   73,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   73,
													},
													File:   "alert_with_topic_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 24,
														Line:   73,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   73,
														},
														File:   "alert_with_topic_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 24,
															Line:   73,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   73,
														},
														File:   "alert_with_topic_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 29,
															Line:   73,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   73,
											},
											File:   "alert_with_topic_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 8,
												Line:   73,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   73,
												},
												File:   "alert_with_topic_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 8,
													Line:   73,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   73,
													},
													File:   "alert_with_topic_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 8,
														Line:   73,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   73,
													},
													File:   "alert_with_topic_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 16,
														Line:   73,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   74,
										},
										File:   "alert_with_topic_test.flux",
										Source: "fn: tickscript_alert",
										Start: ast.Position{
											Column: 2,
											Line:   74,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 4,
												Line:   74,
											},
											File:   "alert_with_topic_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 2,
												Line:   74,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   74,
											},
											File:   "alert_with_topic_test.flux",
											Source: "tickscript_alert",
											Start: ast.Position{
												Column: 6,
												Line:   74,
											},
										},
									},
									Name: "tickscript_alert",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   75,
					},
					File:   "alert_with_topic_test.flux",
					Source: "test _tickscript_alert = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_alert,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   71,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "alert_with_topic_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   4,
					},
					File:   "alert_with_topic_test.flux",
					Source: "import \"csv\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   4,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"csv\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "csv",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 39,
						Line:   5,
					},
					File:   "alert_with_topic_test.flux",
					Source: "import \"contrib/bonitoo-io/tickscript\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 39,
							Line:   5,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"contrib/bonitoo-io/tickscript\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "contrib/bonitoo-io/tickscript",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   6,
					},
					File:   "alert_with_topic_test.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   6,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 36,
						Line:   7,
					},
					File:   "alert_with_topic_test.flux",
					Source: "import \"influxdata/influxdb/schema\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   7,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"influxdata/influxdb/schema\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "influxdata/influxdb/schema",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "alert_with_topic_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   1,
					},
					File:   "alert_with_topic_test.flux",
					Source: "package tickscript_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   1,
						},
						File:   "alert_with_topic_test.flux",
						Source: "tickscript_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "tickscript_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   64,
				},
				File:   "deadman_empty_test.flux",
				Source: "package tickscript_test\n\nimport \"testing\"\nimport \"csv\"\nimport \"contrib/bonitoo-io/tickscript\"\nimport \"influxdata/influxdb/monitor\"\nimport \"influxdata/influxdb/schema\"\n\noption now = () => (2020-11-25T14:05:30Z)\n\n// overwrite as buckets are not avail in Flux tests\noption monitor.write = (tables=<-) => tables\noption monitor.log = (tables=<-) => tables\n\ninData = \"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,true,false,true,false,false\n#datatype,string,long,string,string,string,string,string,string,long,string,boolean,string\n#default,_result,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,dead,id\n,,0,rate-check,Rate Check,crit,statuses,Deadman Check: Rate Check is: dead,testm,1606313130000000000,deadman,true,Realm: ft - Hostname: unknown / Metric: kafka_message_in_rate deadman alert\n\"\n\ncheck = {\n  _check_id: \"rate-check\",\n  _check_name: \"Rate Check\",\n  _type: \"deadman\", // tickscript?\n  tags: {},\n}\n\nmetric_type = \"kafka_message_in_rate\"\ntier = \"ft\"\n\ntickscript_deadman = (table=<-) => table\n\t|> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\",\n    )\n    |> drop(columns: [\"details\"]) // to avoid issue with validation\n    |> drop(columns: [\"_time\"])\n\ntest _tickscript_deadman = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_deadman,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   9,
						},
						File:   "deadman_empty_test.flux",
						Source: "now = () => (2020-11-25T14:05:30Z)",
						Start: ast.Position{
							Column: 8,
							Line:   9,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   9,
							},
							File:   "deadman_empty_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   9,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   9,
							},
							File:   "deadman_empty_test.flux",
							Source: "() => (2020-11-25T14:05:30Z)",
							Start: ast.Position{
								Column: 14,
								Line:   9,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   9,
								},
								File:   "deadman_empty_test.flux",
								Source: "(2020-11-25T14:05:30Z)",
								Start: ast.Position{
									Column: 20,
									Line:   9,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   9,
									},
									File:   "deadman_empty_test.flux",
									Source: "2020-11-25T14:05:30Z",
									Start: ast.Position{
										Column: 21,
										Line:   9,
									},
								},
							},
							Value: parser.MustParseTime("2020-11-25T14:05:30Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   9,
					},
					File:   "deadman_empty_test.flux",
					Source: "option now = () => (2020-11-25T14:05:30Z)",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 45,
							Line:   12,
						},
						File:   "deadman_empty_test.flux",
						Source: "monitor.write = (tables=<-) => tables",
						Start: ast.Position{
							Column: 8,
							Line:   12,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   12,
							},
							File:   "deadman_empty_test.flux",
							Source: "(tables=<-) => tables",
							Start: ast.Position{
								Column: 24,
								Line:   12,
							},
						},
					},
					Body: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   12,
								},
								File:   "deadman_empty_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 39,
									Line:   12,
								},
							},
						},
						Name: "tables",
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   12,
								},
								File:   "deadman_empty_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 25,
									Line:   12,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   12,
									},
									File:   "deadman_empty_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   12,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   12,
								},
								File:   "deadman_empty_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 32,
									Line:   12,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   12,
							},
							File:   "deadman_empty_test.flux",
							Source: "monitor.write",
							Start: ast.Position{
								Column: 8,
								Line:   12,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   12,
								},
								File:   "deadman_empty_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   12,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   12,
								},
								File:   "deadman_empty_test.flux",
								Source: "write",
								Start: ast.Position{
									Column: 16,
									Line:   12,
								},
							},
						},
						Name: "write",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// overwrite as buckets are not avail in Flux tests\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 45,
						Line:   12,
					},
					File:   "deadman_empty_test.flux",
					Source: "option monitor.write = (tables=<-) => tables",
					Start: ast.Position{
						Column: 1,
						Line:   12,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 43,
							Line:   13,
						},
						File:   "deadman_empty_test.flux",
						Source: "monitor.log = (tables=<-) => tables",
						Start: ast.Position{
							Column: 8,
							Line:   13,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   13,
							},
							File:   "deadman_empty_test.flux",
							Source: "(tables=<-) => tables",
							Start: ast.Position{
								Column: 22,
								Line:   13,
							},
						},
					},
					Body: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   13,
								},
								File:   "deadman_empty_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 37,
									Line:   13,
								},
							},
						},
						Name: "tables",
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   13,
								},
								File:   "deadman_empty_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 23,
									Line:   13,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   13,
									},
									File:   "deadman_empty_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   13,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   13,
								},
								File:   "deadman_empty_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 30,
									Line:   13,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   13,
							},
							File:   "deadman_empty_test.flux",
							Source: "monitor.log",
							Start: ast.Position{
								Column: 8,
								Line:   13,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   13,
								},
								File:   "deadman_empty_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   13,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   13,
								},
								File:   "deadman_empty_test.flux",
								Source: "log",
								Start: ast.Position{
									Column: 16,
									Line:   13,
								},
							},
						},
						Name: "log",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 43,
						Line:   13,
					},
					File:   "deadman_empty_test.flux",
					Source: "option monitor.log = (tables=<-) => tables",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   26,
					},
					File:   "deadman_empty_test.flux",
					Source: "inData = \"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   15,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   15,
						},
						File:   "deadman_empty_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   15,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   26,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   15,
						},
					},
				},
				Value: "\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   34,
					},
					File:   "deadman_empty_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,true,false,true,false,false\n#datatype,string,long,string,string,string,string,string,string,long,string,boolean,string\n#default,_result,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,dead,id\n,,0,rate-check,Rate Check,crit,statuses,Deadman Check: Rate Check is: dead,testm,1606313130000000000,deadman,true,Realm: ft - Hostname: unknown / Metric: kafka_message_in_rate deadman alert\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   28,
						},
						File:   "deadman_empty_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   28,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   34,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,true,false,true,false,false\n#datatype,string,long,string,string,string,string,string,string,long,string,boolean,string\n#default,_result,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,dead,id\n,,0,rate-check,Rate Check,crit,statuses,Deadman Check: Rate Check is: dead,testm,1606313130000000000,deadman,true,Realm: ft - Hostname: unknown / Metric: kafka_message_in_rate deadman alert\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   28,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,true,false,true,false,false\n#datatype,string,long,string,string,string,string,string,string,long,string,boolean,string\n#default,_result,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,dead,id\n,,0,rate-check,Rate Check,crit,statuses,Deadman Check: Rate Check is: dead,testm,1606313130000000000,deadman,true,Realm: ft - Hostname: unknown / Metric: kafka_message_in_rate deadman alert\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   41,
					},
					File:   "deadman_empty_test.flux",
					Source: "check = {\n  _check_id: \"rate-check\",\n  _check_name: \"Rate Check\",\n  _type: \"deadman\", // tickscript?\n  tags: {},\n}",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   36,
						},
						File:   "deadman_empty_test.flux",
						Source: "check",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "check",
			},
			Init: &ast.ObjectExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   41,
						},
						File:   "deadman_empty_test.flux",
						Source: "{\n  _check_id: \"rate-check\",\n  _check_name: \"Rate Check\",\n  _type: \"deadman\", // tickscript?\n  tags: {},\n}",
						Start: ast.Position{
							Column: 9,
							Line:   36,
						},
					},
				},
				Lbrace: nil,
				Properties: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   37,
							},
							File:   "deadman_empty_test.flux",
							Source: "_check_id: \"rate-check\"",
							Start: ast.Position{
								Column: 3,
								Line:   37,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   37,
								},
								File:   "deadman_empty_test.flux",
								Source: "_check_id",
								Start: ast.Position{
									Column: 3,
									Line:   37,
								},
							},
						},
						Name: "_check_id",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   37,
								},
								File:   "deadman_empty_test.flux",
								Source: "\"rate-check\"",
								Start: ast.Position{
									Column: 14,
									Line:   37,
								},
							},
						},
						Value: "rate-check",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   38,
							},
							File:   "deadman_empty_test.flux",
							Source: "_check_name: \"Rate Check\"",
							Start: ast.Position{
								Column: 3,
								Line:   38,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   38,
								},
								File:   "deadman_empty_test.flux",
								Source: "_check_name",
								Start: ast.Position{
									Column: 3,
									Line:   38,
								},
							},
						},
						Name: "_check_name",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   38,
								},
								File:   "deadman_empty_test.flux",
								Source: "\"Rate Check\"",
								Start: ast.Position{
									Column: 16,
									Line:   38,
								},
							},
						},
						Value: "Rate Check",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   39,
							},
							File:   "deadman_empty_test.flux",
							Source: "_type: \"deadman\"",
							Start: ast.Position{
								Column: 3,
								Line:   39,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 8,
									Line:   39,
								},
								File:   "deadman_empty_test.flux",
								Source: "_type",
								Start: ast.Position{
									Column: 3,
									Line:   39,
								},
							},
						},
						Name: "_type",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   39,
								},
								File:   "deadman_empty_test.flux",
								Source: "\"deadman\"",
								Start: ast.Position{
									Column: 10,
									Line:   39,
								},
							},
						},
						Value: "deadman",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   40,
							},
							File:   "deadman_empty_test.flux",
							Source: "tags: {}",
							Start: ast.Position{
								Column: 3,
								Line:   40,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: []ast.Comment{ast.Comment{Text: "// tickscript?\n"}},
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 7,
									Line:   40,
								},
								File:   "deadman_empty_test.flux",
								Source: "tags",
								Start: ast.Position{
									Column: 3,
									Line:   40,
								},
							},
						},
						Name: "tags",
					},
					Separator: nil,
					Value: &ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   40,
								},
								File:   "deadman_empty_test.flux",
								Source: "{}",
								Start: ast.Position{
									Column: 9,
									Line:   40,
								},
							},
						},
						Lbrace:     nil,
						Properties: []*ast.Property{},
						Rbrace:     nil,
						With:       nil,
					},
				}},
				Rbrace: nil,
				With:   nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 38,
						Line:   43,
					},
					File:   "deadman_empty_test.flux",
					Source: "metric_type = \"kafka_message_in_rate\"",
					Start: ast.Position{
						Column: 1,
						Line:   43,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   43,
						},
						File:   "deadman_empty_test.flux",
						Source: "metric_type",
						Start: ast.Position{
							Column: 1,
							Line:   43,
						},
					},
				},
				Name: "metric_type",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   43,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"kafka_message_in_rate\"",
						Start: ast.Position{
							Column: 15,
							Line:   43,
						},
					},
				},
				Value: "kafka_message_in_rate",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   44,
					},
					File:   "deadman_empty_test.flux",
					Source: "tier = \"ft\"",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   44,
						},
						File:   "deadman_empty_test.flux",
						Source: "tier",
						Start: ast.Position{
							Column: 1,
							Line:   44,
						},
					},
				},
				Name: "tier",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   44,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"ft\"",
						Start: ast.Position{
							Column: 8,
							Line:   44,
						},
					},
				},
				Value: "ft",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   58,
					},
					File:   "deadman_empty_test.flux",
					Source: "tickscript_deadman = (table=<-) => table\n\t|> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\",\n    )\n    |> drop(columns: [\"details\"]) // to avoid issue with validation\n    |> drop(columns: [\"_time\"])",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   46,
						},
						File:   "deadman_empty_test.flux",
						Source: "tickscript_deadman",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "tickscript_deadman",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   58,
						},
						File:   "deadman_empty_test.flux",
						Source: "(table=<-) => table\n\t|> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\",\n    )\n    |> drop(columns: [\"details\"]) // to avoid issue with validation\n    |> drop(columns: [\"_time\"])",
						Start: ast.Position{
							Column: 22,
							Line:   46,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   46,
														},
														File:   "deadman_empty_test.flux",
														Source: "table",
														Start: ast.Position{
															Column: 36,
															Line:   46,
														},
													},
												},
												Name: "table",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   47,
													},
													File:   "deadman_empty_test.flux",
													Source: "table\n\t|> range(start: 2020-11-25T14:05:15Z)",
													Start: ast.Position{
														Column: 36,
														Line:   46,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   47,
															},
															File:   "deadman_empty_test.flux",
															Source: "start: 2020-11-25T14:05:15Z",
															Start: ast.Position{
																Column: 11,
																Line:   47,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   47,
																},
																File:   "deadman_empty_test.flux",
																Source: "start: 2020-11-25T14:05:15Z",
																Start: ast.Position{
																	Column: 11,
																	Line:   47,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 16,
																		Line:   47,
																	},
																	File:   "deadman_empty_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 11,
																		Line:   47,
																	},
																},
															},
															Name: "start",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   47,
																	},
																	File:   "deadman_empty_test.flux",
																	Source: "2020-11-25T14:05:15Z",
																	Start: ast.Position{
																		Column: 18,
																		Line:   47,
																	},
																},
															},
															Value: parser.MustParseTime("2020-11-25T14:05:15Z"),
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   47,
														},
														File:   "deadman_empty_test.flux",
														Source: "range(start: 2020-11-25T14:05:15Z)",
														Start: ast.Position{
															Column: 5,
															Line:   47,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 10,
																Line:   47,
															},
															File:   "deadman_empty_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 5,
																Line:   47,
															},
														},
													},
													Name: "range",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 100,
													Line:   48,
												},
												File:   "deadman_empty_test.flux",
												Source: "table\n\t|> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)",
												Start: ast.Position{
													Column: 36,
													Line:   46,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 99,
															Line:   48,
														},
														File:   "deadman_empty_test.flux",
														Source: "fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier",
														Start: ast.Position{
															Column: 15,
															Line:   48,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 99,
																Line:   48,
															},
															File:   "deadman_empty_test.flux",
															Source: "fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier",
															Start: ast.Position{
																Column: 15,
																Line:   48,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   48,
																},
																File:   "deadman_empty_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 15,
																	Line:   48,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.FunctionExpression{
														Arrow: nil,
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 99,
																	Line:   48,
																},
																File:   "deadman_empty_test.flux",
																Source: "(r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier",
																Start: ast.Position{
																	Column: 19,
																	Line:   48,
																},
															},
														},
														Body: &ast.LogicalExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 99,
																		Line:   48,
																	},
																	File:   "deadman_empty_test.flux",
																	Source: "r._measurement == \"testm\" and r._field == metric_type and r.realm == tier",
																	Start: ast.Position{
																		Column: 26,
																		Line:   48,
																	},
																},
															},
															Left: &ast.LogicalExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 79,
																			Line:   48,
																		},
																		File:   "deadman_empty_test.flux",
																		Source: "r._measurement == \"testm\" and r._field == metric_type",
																		Start: ast.Position{
																			Column: 26,
																			Line:   48,
																		},
																	},
																},
																Left: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 51,
																				Line:   48,
																			},
																			File:   "deadman_empty_test.flux",
																			Source: "r._measurement == \"testm\"",
																			Start: ast.Position{
																				Column: 26,
																				Line:   48,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 40,
																					Line:   48,
																				},
																				File:   "deadman_empty_test.flux",
																				Source: "r._measurement",
																				Start: ast.Position{
																					Column: 26,
																					Line:   48,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 27,
																						Line:   48,
																					},
																					File:   "deadman_empty_test.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 26,
																						Line:   48,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 40,
																						Line:   48,
																					},
																					File:   "deadman_empty_test.flux",
																					Source: "_measurement",
																					Start: ast.Position{
																						Column: 28,
																						Line:   48,
																					},
																				},
																			},
																			Name: "_measurement",
																		},
																		Rbrack: nil,
																	},
																	Operator: 17,
																	Right: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 51,
																					Line:   48,
																				},
																				File:   "deadman_empty_test.flux",
																				Source: "\"testm\"",
																				Start: ast.Position{
																					Column: 44,
																					Line:   48,
																				},
																			},
																		},
																		Value: "testm",
																	},
																},
																Operator: 1,
																Right: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 79,
																				Line:   48,
																			},
																			File:   "deadman_empty_test.flux",
																			Source: "r._field == metric_type",
																			Start: ast.Position{
																				Column: 56,
																				Line:   48,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 64,
																					Line:   48,
																				},
																				File:   "deadman_empty_test.flux",
																				Source: "r._field",
																				Start: ast.Position{
																					Column: 56,
																					Line:   48,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 57,
																						Line:   48,
																					},
																					File:   "deadman_empty_test.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 56,
																						Line:   48,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 64,
																						Line:   48,
																					},
																					File:   "deadman_empty_test.flux",
																					Source: "_field",
																					Start: ast.Position{
																						Column: 58,
																						Line:   48,
																					},
																				},
																			},
																			Name: "_field",
																		},
																		Rbrack: nil,
																	},
																	Operator: 17,
																	Right: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 79,
																					Line:   48,
																				},
																				File:   "deadman_empty_test.flux",
																				Source: "metric_type",
																				Start: ast.Position{
																					Column: 68,
																					Line:   48,
																				},
																			},
																		},
																		Name: "metric_type",
																	},
																},
															},
															Operator: 1,
															Right: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 99,
																			Line:   48,
																		},
																		File:   "deadman_empty_test.flux",
																		Source: "r.realm == tier",
																		Start: ast.Position{
																			Column: 84,
																			Line:   48,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 91,
																				Line:   48,
																			},
																			File:   "deadman_empty_test.flux",
																			Source: "r.realm",
																			Start: ast.Position{
																				Column: 84,
																				Line:   48,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 85,
																					Line:   48,
																				},
																				File:   "deadman_empty_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 84,
																					Line:   48,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 91,
																					Line:   48,
																				},
																				File:   "deadman_empty_test.flux",
																				Source: "realm",
																				Start: ast.Position{
																					Column: 86,
																					Line:   48,
																				},
																			},
																		},
																		Name: "realm",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 99,
																				Line:   48,
																			},
																			File:   "deadman_empty_test.flux",
																			Source: "tier",
																			Start: ast.Position{
																				Column: 95,
																				Line:   48,
																			},
																		},
																	},
																	Name: "tier",
																},
															},
														},
														Lparen: nil,
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   48,
																	},
																	File:   "deadman_empty_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 20,
																		Line:   48,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   48,
																		},
																		File:   "deadman_empty_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 20,
																			Line:   48,
																		},
																	},
																},
																Name: "r",
															},
															Separator: nil,
															Value:     nil,
														}},
														Rparan: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 100,
														Line:   48,
													},
													File:   "deadman_empty_test.flux",
													Source: "filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)",
													Start: ast.Position{
														Column: 8,
														Line:   48,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   48,
														},
														File:   "deadman_empty_test.flux",
														Source: "filter",
														Start: ast.Position{
															Column: 8,
															Line:   48,
														},
													},
												},
												Name: "filter",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   49,
											},
											File:   "deadman_empty_test.flux",
											Source: "table\n\t|> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()",
											Start: ast.Position{
												Column: 36,
												Line:   46,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   49,
												},
												File:   "deadman_empty_test.flux",
												Source: "schema.fieldsAsCols()",
												Start: ast.Position{
													Column: 8,
													Line:   49,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   49,
													},
													File:   "deadman_empty_test.flux",
													Source: "schema.fieldsAsCols",
													Start: ast.Position{
														Column: 8,
														Line:   49,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   49,
														},
														File:   "deadman_empty_test.flux",
														Source: "schema",
														Start: ast.Position{
															Column: 8,
															Line:   49,
														},
													},
												},
												Name: "schema",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   49,
														},
														File:   "deadman_empty_test.flux",
														Source: "fieldsAsCols",
														Start: ast.Position{
															Column: 15,
															Line:   49,
														},
													},
												},
												Name: "fieldsAsCols",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   50,
										},
										File:   "deadman_empty_test.flux",
										Source: "table\n\t|> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])",
										Start: ast.Position{
											Column: 36,
											Line:   46,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   50,
												},
												File:   "deadman_empty_test.flux",
												Source: "columns: [\"host\", \"realm\"]",
												Start: ast.Position{
													Column: 27,
													Line:   50,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   50,
													},
													File:   "deadman_empty_test.flux",
													Source: "columns: [\"host\", \"realm\"]",
													Start: ast.Position{
														Column: 27,
														Line:   50,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   50,
														},
														File:   "deadman_empty_test.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 27,
															Line:   50,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 53,
															Line:   50,
														},
														File:   "deadman_empty_test.flux",
														Source: "[\"host\", \"realm\"]",
														Start: ast.Position{
															Column: 36,
															Line:   50,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 43,
																Line:   50,
															},
															File:   "deadman_empty_test.flux",
															Source: "\"host\"",
															Start: ast.Position{
																Column: 37,
																Line:   50,
															},
														},
													},
													Value: "host",
												}, &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 52,
																Line:   50,
															},
															File:   "deadman_empty_test.flux",
															Source: "\"realm\"",
															Start: ast.Position{
																Column: 45,
																Line:   50,
															},
														},
													},
													Value: "realm",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   50,
											},
											File:   "deadman_empty_test.flux",
											Source: "tickscript.groupBy(columns: [\"host\", \"realm\"])",
											Start: ast.Position{
												Column: 8,
												Line:   50,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   50,
												},
												File:   "deadman_empty_test.flux",
												Source: "tickscript.groupBy",
												Start: ast.Position{
													Column: 8,
													Line:   50,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   50,
													},
													File:   "deadman_empty_test.flux",
													Source: "tickscript",
													Start: ast.Position{
														Column: 8,
														Line:   50,
													},
												},
											},
											Name: "tickscript",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   50,
													},
													File:   "deadman_empty_test.flux",
													Source: "groupBy",
													Start: ast.Position{
														Column: 19,
														Line:   50,
													},
												},
											},
											Name: "groupBy",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   56,
									},
									File:   "deadman_empty_test.flux",
									Source: "table\n\t|> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\",\n    )",
									Start: ast.Position{
										Column: 36,
										Line:   46,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 95,
												Line:   55,
											},
											File:   "deadman_empty_test.flux",
											Source: "check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\"",
											Start: ast.Position{
												Column: 9,
												Line:   52,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   52,
												},
												File:   "deadman_empty_test.flux",
												Source: "check: check",
												Start: ast.Position{
													Column: 9,
													Line:   52,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   52,
													},
													File:   "deadman_empty_test.flux",
													Source: "check",
													Start: ast.Position{
														Column: 9,
														Line:   52,
													},
												},
											},
											Name: "check",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   52,
													},
													File:   "deadman_empty_test.flux",
													Source: "check",
													Start: ast.Position{
														Column: 16,
														Line:   52,
													},
												},
											},
											Name: "check",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   53,
												},
												File:   "deadman_empty_test.flux",
												Source: "measurement: \"testm\"",
												Start: ast.Position{
													Column: 9,
													Line:   53,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   53,
													},
													File:   "deadman_empty_test.flux",
													Source: "measurement",
													Start: ast.Position{
														Column: 9,
														Line:   53,
													},
												},
											},
											Name: "measurement",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   53,
													},
													File:   "deadman_empty_test.flux",
													Source: "\"testm\"",
													Start: ast.Position{
														Column: 22,
														Line:   53,
													},
												},
											},
											Value: "testm",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   54,
												},
												File:   "deadman_empty_test.flux",
												Source: "threshold: 10",
												Start: ast.Position{
													Column: 9,
													Line:   54,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   54,
													},
													File:   "deadman_empty_test.flux",
													Source: "threshold",
													Start: ast.Position{
														Column: 9,
														Line:   54,
													},
												},
											},
											Name: "threshold",
										},
										Separator: nil,
										Value: &ast.IntegerLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   54,
													},
													File:   "deadman_empty_test.flux",
													Source: "10",
													Start: ast.Position{
														Column: 20,
														Line:   54,
													},
												},
											},
											Value: int64(10),
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 95,
													Line:   55,
												},
												File:   "deadman_empty_test.flux",
												Source: "id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\"",
												Start: ast.Position{
													Column: 9,
													Line:   55,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   55,
													},
													File:   "deadman_empty_test.flux",
													Source: "id",
													Start: ast.Position{
														Column: 9,
														Line:   55,
													},
												},
											},
											Name: "id",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 95,
														Line:   55,
													},
													File:   "deadman_empty_test.flux",
													Source: "(r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\"",
													Start: ast.Position{
														Column: 13,
														Line:   55,
													},
												},
											},
											Body: &ast.StringExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 95,
															Line:   55,
														},
														File:   "deadman_empty_test.flux",
														Source: "\"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\"",
														Start: ast.Position{
															Column: 20,
															Line:   55,
														},
													},
												},
												Parts: []ast.StringExpressionPart{&ast.TextPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   55,
															},
															File:   "deadman_empty_test.flux",
															Source: "Realm: ",
															Start: ast.Position{
																Column: 21,
																Line:   55,
															},
														},
													},
													Value: "Realm: ",
												}, &ast.InterpolatedPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   55,
															},
															File:   "deadman_empty_test.flux",
															Source: "${tier}",
															Start: ast.Position{
																Column: 28,
																Line:   55,
															},
														},
													},
													Expression: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   55,
																},
																File:   "deadman_empty_test.flux",
																Source: "tier",
																Start: ast.Position{
																	Column: 30,
																	Line:   55,
																},
															},
														},
														Name: "tier",
													},
												}, &ast.TextPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 66,
																Line:   55,
															},
															File:   "deadman_empty_test.flux",
															Source: " - Hostname: unknown / Metric: ",
															Start: ast.Position{
																Column: 35,
																Line:   55,
															},
														},
													},
													Value: " - Hostname: unknown / Metric: ",
												}, &ast.InterpolatedPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 80,
																Line:   55,
															},
															File:   "deadman_empty_test.flux",
															Source: "${metric_type}",
															Start: ast.Position{
																Column: 66,
																Line:   55,
															},
														},
													},
													Expression: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 79,
																	Line:   55,
																},
																File:   "deadman_empty_test.flux",
																Source: "metric_type",
																Start: ast.Position{
																	Column: 68,
																	Line:   55,
																},
															},
														},
														Name: "metric_type",
													},
												}, &ast.TextPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 94,
																Line:   55,
															},
															File:   "deadman_empty_test.flux",
															Source: " deadman alert",
															Start: ast.Position{
																Column: 80,
																Line:   55,
															},
														},
													},
													Value: " deadman alert",
												}},
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   55,
														},
														File:   "deadman_empty_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   55,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   55,
															},
															File:   "deadman_empty_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   55,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   56,
										},
										File:   "deadman_empty_test.flux",
										Source: "tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\",\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   51,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   51,
											},
											File:   "deadman_empty_test.flux",
											Source: "tickscript.deadman",
											Start: ast.Position{
												Column: 8,
												Line:   51,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   51,
												},
												File:   "deadman_empty_test.flux",
												Source: "tickscript",
												Start: ast.Position{
													Column: 8,
													Line:   51,
												},
											},
										},
										Name: "tickscript",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   51,
												},
												File:   "deadman_empty_test.flux",
												Source: "deadman",
												Start: ast.Position{
													Column: 19,
													Line:   51,
												},
											},
										},
										Name: "deadman",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   57,
								},
								File:   "deadman_empty_test.flux",
								Source: "table\n\t|> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\",\n    )\n    |> drop(columns: [\"details\"])",
								Start: ast.Position{
									Column: 36,
									Line:   46,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   57,
										},
										File:   "deadman_empty_test.flux",
										Source: "columns: [\"details\"]",
										Start: ast.Position{
											Column: 13,
											Line:   57,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   57,
											},
											File:   "deadman_empty_test.flux",
											Source: "columns: [\"details\"]",
											Start: ast.Position{
												Column: 13,
												Line:   57,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   57,
												},
												File:   "deadman_empty_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 13,
													Line:   57,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   57,
												},
												File:   "deadman_empty_test.flux",
												Source: "[\"details\"]",
												Start: ast.Position{
													Column: 22,
													Line:   57,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   57,
													},
													File:   "deadman_empty_test.flux",
													Source: "\"details\"",
													Start: ast.Position{
														Column: 23,
														Line:   57,
													},
												},
											},
											Value: "details",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   57,
									},
									File:   "deadman_empty_test.flux",
									Source: "drop(columns: [\"details\"])",
									Start: ast.Position{
										Column: 8,
										Line:   57,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   57,
										},
										File:   "deadman_empty_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 8,
											Line:   57,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: []ast.Comment{ast.Comment{Text: "// to avoid issue with validation\n"}},
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   58,
							},
							File:   "deadman_empty_test.flux",
							Source: "table\n\t|> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\",\n    )\n    |> drop(columns: [\"details\"]) // to avoid issue with validation\n    |> drop(columns: [\"_time\"])",
							Start: ast.Position{
								Column: 36,
								Line:   46,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   58,
									},
									File:   "deadman_empty_test.flux",
									Source: "columns: [\"_time\"]",
									Start: ast.Position{
										Column: 13,
										Line:   58,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   58,
										},
										File:   "deadman_empty_test.flux",
										Source: "columns: [\"_time\"]",
										Start: ast.Position{
											Column: 13,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   58,
											},
											File:   "deadman_empty_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   58,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   58,
											},
											File:   "deadman_empty_test.flux",
											Source: "[\"_time\"]",
											Start: ast.Position{
												Column: 22,
												Line:   58,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   58,
												},
												File:   "deadman_empty_test.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 23,
													Line:   58,
												},
											},
										},
										Value: "_time",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   58,
								},
								File:   "deadman_empty_test.flux",
								Source: "drop(columns: [\"_time\"])",
								Start: ast.Position{
									Column: 8,
									Line:   58,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   58,
									},
									File:   "deadman_empty_test.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 8,
										Line:   58,
									},
								},
							},
							Name: "drop",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   46,
							},
							File:   "deadman_empty_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 23,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   46,
								},
								File:   "deadman_empty_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 23,
									Line:   46,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   46,
							},
							File:   "deadman_empty_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 29,
								Line:   46,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   64,
						},
						File:   "deadman_empty_test.flux",
						Source: "_tickscript_deadman = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_deadman,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   60,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   60,
							},
							File:   "deadman_empty_test.flux",
							Source: "_tickscript_deadman",
							Start: ast.Position{
								Column: 6,
								Line:   60,
							},
						},
					},
					Name: "_tickscript_deadman",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   64,
							},
							File:   "deadman_empty_test.flux",
							Source: "() => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_deadman,\n})",
							Start: ast.Position{
								Column: 28,
								Line:   60,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   64,
								},
								File:   "deadman_empty_test.flux",
								Source: "({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_deadman,\n})",
								Start: ast.Position{
									Column: 34,
									Line:   60,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   64,
									},
									File:   "deadman_empty_test.flux",
									Source: "{\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_deadman,\n}",
									Start: ast.Position{
										Column: 35,
										Line:   60,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   61,
										},
										File:   "deadman_empty_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 2,
											Line:   61,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   61,
											},
											File:   "deadman_empty_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 2,
												Line:   61,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   61,
												},
												File:   "deadman_empty_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 29,
													Line:   61,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   61,
													},
													File:   "deadman_empty_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 29,
														Line:   61,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   61,
														},
														File:   "deadman_empty_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 29,
															Line:   61,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   61,
														},
														File:   "deadman_empty_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 34,
															Line:   61,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   61,
											},
											File:   "deadman_empty_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 9,
												Line:   61,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   61,
												},
												File:   "deadman_empty_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 9,
													Line:   61,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   61,
													},
													File:   "deadman_empty_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   61,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   61,
													},
													File:   "deadman_empty_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 17,
														Line:   61,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   62,
										},
										File:   "deadman_empty_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 2,
											Line:   62,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   62,
											},
											File:   "deadman_empty_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 2,
												Line:   62,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   62,
												},
												File:   "deadman_empty_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 24,
													Line:   62,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   62,
													},
													File:   "deadman_empty_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 24,
														Line:   62,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   62,
														},
														File:   "deadman_empty_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 24,
															Line:   62,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   62,
														},
														File:   "deadman_empty_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 29,
															Line:   62,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   62,
											},
											File:   "deadman_empty_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 8,
												Line:   62,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   62,
												},
												File:   "deadman_empty_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 8,
													Line:   62,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   62,
													},
													File:   "deadman_empty_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 8,
														Line:   62,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   62,
													},
													File:   "deadman_empty_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 16,
														Line:   62,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   63,
										},
										File:   "deadman_empty_test.flux",
										Source: "fn: tickscript_deadman",
										Start: ast.Position{
											Column: 2,
											Line:   63,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 4,
												Line:   63,
											},
											File:   "deadman_empty_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 2,
												Line:   63,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   63,
											},
											File:   "deadman_empty_test.flux",
											Source: "tickscript_deadman",
											Start: ast.Position{
												Column: 6,
												Line:   63,
											},
										},
									},
									Name: "tickscript_deadman",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   64,
					},
					File:   "deadman_empty_test.flux",
					Source: "test _tickscript_deadman = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_deadman,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   60,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "deadman_empty_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   4,
					},
					File:   "deadman_empty_test.flux",
					Source: "import \"csv\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   4,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"csv\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "csv",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 39,
						Line:   5,
					},
					File:   "deadman_empty_test.flux",
					Source: "import \"contrib/bonitoo-io/tickscript\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 39,
							Line:   5,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"contrib/bonitoo-io/tickscript\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "contrib/bonitoo-io/tickscript",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   6,
					},
					File:   "deadman_empty_test.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   6,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 36,
						Line:   7,
					},
					File:   "deadman_empty_test.flux",
					Source: "import \"influxdata/influxdb/schema\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   7,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"influxdata/influxdb/schema\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "influxdata/influxdb/schema",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "deadman_empty_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   1,
					},
					File:   "deadman_empty_test.flux",
					Source: "package tickscript_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   1,
						},
						File:   "deadman_empty_test.flux",
						Source: "tickscript_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "tickscript_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   64,
				},
				File:   "deadman_threshold_test.flux",
				Source: "package tickscript_test\n\nimport \"testing\"\nimport \"csv\"\nimport \"contrib/bonitoo-io/tickscript\"\nimport \"influxdata/influxdb/monitor\"\nimport \"influxdata/influxdb/schema\"\n\noption now = () => (2020-11-25T14:05:30Z)\n\n// overwrite as buckets are not avail in Flux tests\noption monitor.write = (tables=<-) => tables\noption monitor.log = (tables=<-) => tables\n\ninData = \"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"\n\noutData = \"\n#group,false,false,true,true,true,true,false,true,false,true,false,true,false,true\n#datatype,string,long,string,string,string,string,string,string,long,string,boolean,string,string,string\n#default,_result,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,dead,host,id,realm\n,,0,rate-check,Rate Check,crit,statuses,Deadman Check: Rate Check is: dead,testm,1606313130000000000,deadman,true,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate deadman alert,ft\n\"\n\ncheck = {\n  _check_id: \"rate-check\",\n  _check_name: \"Rate Check\",\n  _type: \"deadman\", // tickscript?\n  tags: {},\n}\n\nmetric_type = \"kafka_message_in_rate\"\ntier = \"ft\"\n\ntickscript_deadman = (table=<-) => table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\",\n    )\n    |> drop(columns: [\"details\"]) // to avoid issue with validation\n    |> drop(columns: [\"_time\"])\n\ntest _tickscript_deadman = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_deadman,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   9,
						},
						File:   "deadman_threshold_test.flux",
						Source: "now = () => (2020-11-25T14:05:30Z)",
						Start: ast.Position{
							Column: 8,
							Line:   9,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   9,
							},
							File:   "deadman_threshold_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   9,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   9,
							},
							File:   "deadman_threshold_test.flux",
							Source: "() => (2020-11-25T14:05:30Z)",
							Start: ast.Position{
								Column: 14,
								Line:   9,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   9,
								},
								File:   "deadman_threshold_test.flux",
								Source: "(2020-11-25T14:05:30Z)",
								Start: ast.Position{
									Column: 20,
									Line:   9,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   9,
									},
									File:   "deadman_threshold_test.flux",
									Source: "2020-11-25T14:05:30Z",
									Start: ast.Position{
										Column: 21,
										Line:   9,
									},
								},
							},
							Value: parser.MustParseTime("2020-11-25T14:05:30Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   9,
					},
					File:   "deadman_threshold_test.flux",
					Source: "option now = () => (2020-11-25T14:05:30Z)",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 45,
							Line:   12,
						},
						File:   "deadman_threshold_test.flux",
						Source: "monitor.write = (tables=<-) => tables",
						Start: ast.Position{
							Column: 8,
							Line:   12,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   12,
							},
							File:   "deadman_threshold_test.flux",
							Source: "(tables=<-) => tables",
							Start: ast.Position{
								Column: 24,
								Line:   12,
							},
						},
					},
					Body: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   12,
								},
								File:   "deadman_threshold_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 39,
									Line:   12,
								},
							},
						},
						Name: "tables",
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   12,
								},
								File:   "deadman_threshold_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 25,
									Line:   12,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   12,
									},
									File:   "deadman_threshold_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   12,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   12,
								},
								File:   "deadman_threshold_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 32,
									Line:   12,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   12,
							},
							File:   "deadman_threshold_test.flux",
							Source: "monitor.write",
							Start: ast.Position{
								Column: 8,
								Line:   12,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   12,
								},
								File:   "deadman_threshold_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   12,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   12,
								},
								File:   "deadman_threshold_test.flux",
								Source: "write",
								Start: ast.Position{
									Column: 16,
									Line:   12,
								},
							},
						},
						Name: "write",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// overwrite as buckets are not avail in Flux tests\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 45,
						Line:   12,
					},
					File:   "deadman_threshold_test.flux",
					Source: "option monitor.write = (tables=<-) => tables",
					Start: ast.Position{
						Column: 1,
						Line:   12,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 43,
							Line:   13,
						},
						File:   "deadman_threshold_test.flux",
						Source: "monitor.log = (tables=<-) => tables",
						Start: ast.Position{
							Column: 8,
							Line:   13,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   13,
							},
							File:   "deadman_threshold_test.flux",
							Source: "(tables=<-) => tables",
							Start: ast.Position{
								Column: 22,
								Line:   13,
							},
						},
					},
					Body: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   13,
								},
								File:   "deadman_threshold_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 37,
									Line:   13,
								},
							},
						},
						Name: "tables",
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   13,
								},
								File:   "deadman_threshold_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 23,
									Line:   13,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   13,
									},
									File:   "deadman_threshold_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   13,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   13,
								},
								File:   "deadman_threshold_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 30,
									Line:   13,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   13,
							},
							File:   "deadman_threshold_test.flux",
							Source: "monitor.log",
							Start: ast.Position{
								Column: 8,
								Line:   13,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   13,
								},
								File:   "deadman_threshold_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   13,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   13,
								},
								File:   "deadman_threshold_test.flux",
								Source: "log",
								Start: ast.Position{
									Column: 16,
									Line:   13,
								},
							},
						},
						Name: "log",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 43,
						Line:   13,
					},
					File:   "deadman_threshold_test.flux",
					Source: "option monitor.log = (tables=<-) => tables",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   26,
					},
					File:   "deadman_threshold_test.flux",
					Source: "inData = \"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   15,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   15,
						},
						File:   "deadman_threshold_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   15,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   26,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   15,
						},
					},
				},
				Value: "\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   34,
					},
					File:   "deadman_threshold_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,true,false,true,false,true,false,true\n#datatype,string,long,string,string,string,string,string,string,long,string,boolean,string,string,string\n#default,_result,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,dead,host,id,realm\n,,0,rate-check,Rate Check,crit,statuses,Deadman Check: Rate Check is: dead,testm,1606313130000000000,deadman,true,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate deadman alert,ft\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   28,
						},
						File:   "deadman_threshold_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   28,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   34,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,true,false,true,false,true,false,true\n#datatype,string,long,string,string,string,string,string,string,long,string,boolean,string,string,string\n#default,_result,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,dead,host,id,realm\n,,0,rate-check,Rate Check,crit,statuses,Deadman Check: Rate Check is: dead,testm,1606313130000000000,deadman,true,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate deadman alert,ft\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   28,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,true,false,true,false,true,false,true\n#datatype,string,long,string,string,string,string,string,string,long,string,boolean,string,string,string\n#default,_result,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,dead,host,id,realm\n,,0,rate-check,Rate Check,crit,statuses,Deadman Check: Rate Check is: dead,testm,1606313130000000000,deadman,true,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate deadman alert,ft\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   41,
					},
					File:   "deadman_threshold_test.flux",
					Source: "check = {\n  _check_id: \"rate-check\",\n  _check_name: \"Rate Check\",\n  _type: \"deadman\", // tickscript?\n  tags: {},\n}",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   36,
						},
						File:   "deadman_threshold_test.flux",
						Source: "check",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "check",
			},
			Init: &ast.ObjectExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   41,
						},
						File:   "deadman_threshold_test.flux",
						Source: "{\n  _check_id: \"rate-check\",\n  _check_name: \"Rate Check\",\n  _type: \"deadman\", // tickscript?\n  tags: {},\n}",
						Start: ast.Position{
							Column: 9,
							Line:   36,
						},
					},
				},
				Lbrace: nil,
				Properties: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   37,
							},
							File:   "deadman_threshold_test.flux",
							Source: "_check_id: \"rate-check\"",
							Start: ast.Position{
								Column: 3,
								Line:   37,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   37,
								},
								File:   "deadman_threshold_test.flux",
								Source: "_check_id",
								Start: ast.Position{
									Column: 3,
									Line:   37,
								},
							},
						},
						Name: "_check_id",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   37,
								},
								File:   "deadman_threshold_test.flux",
								Source: "\"rate-check\"",
								Start: ast.Position{
									Column: 14,
									Line:   37,
								},
							},
						},
						Value: "rate-check",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   38,
							},
							File:   "deadman_threshold_test.flux",
							Source: "_check_name: \"Rate Check\"",
							Start: ast.Position{
								Column: 3,
								Line:   38,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   38,
								},
								File:   "deadman_threshold_test.flux",
								Source: "_check_name",
								Start: ast.Position{
									Column: 3,
									Line:   38,
								},
							},
						},
						Name: "_check_name",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   38,
								},
								File:   "deadman_threshold_test.flux",
								Source: "\"Rate Check\"",
								Start: ast.Position{
									Column: 16,
									Line:   38,
								},
							},
						},
						Value: "Rate Check",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   39,
							},
							File:   "deadman_threshold_test.flux",
							Source: "_type: \"deadman\"",
							Start: ast.Position{
								Column: 3,
								Line:   39,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 8,
									Line:   39,
								},
								File:   "deadman_threshold_test.flux",
								Source: "_type",
								Start: ast.Position{
									Column: 3,
									Line:   39,
								},
							},
						},
						Name: "_type",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   39,
								},
								File:   "deadman_threshold_test.flux",
								Source: "\"deadman\"",
								Start: ast.Position{
									Column: 10,
									Line:   39,
								},
							},
						},
						Value: "deadman",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   40,
							},
							File:   "deadman_threshold_test.flux",
							Source: "tags: {}",
							Start: ast.Position{
								Column: 3,
								Line:   40,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: []ast.Comment{ast.Comment{Text: "// tickscript?\n"}},
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 7,
									Line:   40,
								},
								File:   "deadman_threshold_test.flux",
								Source: "tags",
								Start: ast.Position{
									Column: 3,
									Line:   40,
								},
							},
						},
						Name: "tags",
					},
					Separator: nil,
					Value: &ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   40,
								},
								File:   "deadman_threshold_test.flux",
								Source: "{}",
								Start: ast.Position{
									Column: 9,
									Line:   40,
								},
							},
						},
						Lbrace:     nil,
						Properties: []*ast.Property{},
						Rbrace:     nil,
						With:       nil,
					},
				}},
				Rbrace: nil,
				With:   nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 38,
						Line:   43,
					},
					File:   "deadman_threshold_test.flux",
					Source: "metric_type = \"kafka_message_in_rate\"",
					Start: ast.Position{
						Column: 1,
						Line:   43,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   43,
						},
						File:   "deadman_threshold_test.flux",
						Source: "metric_type",
						Start: ast.Position{
							Column: 1,
							Line:   43,
						},
					},
				},
				Name: "metric_type",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   43,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"kafka_message_in_rate\"",
						Start: ast.Position{
							Column: 15,
							Line:   43,
						},
					},
				},
				Value: "kafka_message_in_rate",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   44,
					},
					File:   "deadman_threshold_test.flux",
					Source: "tier = \"ft\"",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   44,
						},
						File:   "deadman_threshold_test.flux",
						Source: "tier",
						Start: ast.Position{
							Column: 1,
							Line:   44,
						},
					},
				},
				Name: "tier",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   44,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"ft\"",
						Start: ast.Position{
							Column: 8,
							Line:   44,
						},
					},
				},
				Value: "ft",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   58,
					},
					File:   "deadman_threshold_test.flux",
					Source: "tickscript_deadman = (table=<-) => table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\",\n    )\n    |> drop(columns: [\"details\"]) // to avoid issue with validation\n    |> drop(columns: [\"_time\"])",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   46,
						},
						File:   "deadman_threshold_test.flux",
						Source: "tickscript_deadman",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "tickscript_deadman",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   58,
						},
						File:   "deadman_threshold_test.flux",
						Source: "(table=<-) => table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\",\n    )\n    |> drop(columns: [\"details\"]) // to avoid issue with validation\n    |> drop(columns: [\"_time\"])",
						Start: ast.Position{
							Column: 22,
							Line:   46,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   46,
														},
														File:   "deadman_threshold_test.flux",
														Source: "table",
														Start: ast.Position{
															Column: 36,
															Line:   46,
														},
													},
												},
												Name: "table",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   47,
													},
													File:   "deadman_threshold_test.flux",
													Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)",
													Start: ast.Position{
														Column: 36,
														Line:   46,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   47,
															},
															File:   "deadman_threshold_test.flux",
															Source: "start: 2020-11-25T14:05:00Z",
															Start: ast.Position{
																Column: 11,
																Line:   47,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   47,
																},
																File:   "deadman_threshold_test.flux",
																Source: "start: 2020-11-25T14:05:00Z",
																Start: ast.Position{
																	Column: 11,
																	Line:   47,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 16,
																		Line:   47,
																	},
																	File:   "deadman_threshold_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 11,
																		Line:   47,
																	},
																},
															},
															Name: "start",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   47,
																	},
																	File:   "deadman_threshold_test.flux",
																	Source: "2020-11-25T14:05:00Z",
																	Start: ast.Position{
																		Column: 18,
																		Line:   47,
																	},
																},
															},
															Value: parser.MustParseTime("2020-11-25T14:05:00Z"),
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   47,
														},
														File:   "deadman_threshold_test.flux",
														Source: "range(start: 2020-11-25T14:05:00Z)",
														Start: ast.Position{
															Column: 5,
															Line:   47,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 10,
																Line:   47,
															},
															File:   "deadman_threshold_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 5,
																Line:   47,
															},
														},
													},
													Name: "range",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 100,
													Line:   48,
												},
												File:   "deadman_threshold_test.flux",
												Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)",
												Start: ast.Position{
													Column: 36,
													Line:   46,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 99,
															Line:   48,
														},
														File:   "deadman_threshold_test.flux",
														Source: "fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier",
														Start: ast.Position{
															Column: 15,
															Line:   48,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 99,
																Line:   48,
															},
															File:   "deadman_threshold_test.flux",
															Source: "fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier",
															Start: ast.Position{
																Column: 15,
																Line:   48,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   48,
																},
																File:   "deadman_threshold_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 15,
																	Line:   48,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.FunctionExpression{
														Arrow: nil,
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 99,
																	Line:   48,
																},
																File:   "deadman_threshold_test.flux",
																Source: "(r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier",
																Start: ast.Position{
																	Column: 19,
																	Line:   48,
																},
															},
														},
														Body: &ast.LogicalExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 99,
																		Line:   48,
																	},
																	File:   "deadman_threshold_test.flux",
																	Source: "r._measurement == \"testm\" and r._field == metric_type and r.realm == tier",
																	Start: ast.Position{
																		Column: 26,
																		Line:   48,
																	},
																},
															},
															Left: &ast.LogicalExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 79,
																			Line:   48,
																		},
																		File:   "deadman_threshold_test.flux",
																		Source: "r._measurement == \"testm\" and r._field == metric_type",
																		Start: ast.Position{
																			Column: 26,
																			Line:   48,
																		},
																	},
																},
																Left: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 51,
																				Line:   48,
																			},
																			File:   "deadman_threshold_test.flux",
																			Source: "r._measurement == \"testm\"",
																			Start: ast.Position{
																				Column: 26,
																				Line:   48,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 40,
																					Line:   48,
																				},
																				File:   "deadman_threshold_test.flux",
																				Source: "r._measurement",
																				Start: ast.Position{
																					Column: 26,
																					Line:   48,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 27,
																						Line:   48,
																					},
																					File:   "deadman_threshold_test.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 26,
																						Line:   48,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 40,
																						Line:   48,
																					},
																					File:   "deadman_threshold_test.flux",
																					Source: "_measurement",
																					Start: ast.Position{
																						Column: 28,
																						Line:   48,
																					},
																				},
																			},
																			Name: "_measurement",
																		},
																		Rbrack: nil,
																	},
																	Operator: 17,
																	Right: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 51,
																					Line:   48,
																				},
																				File:   "deadman_threshold_test.flux",
																				Source: "\"testm\"",
																				Start: ast.Position{
																					Column: 44,
																					Line:   48,
																				},
																			},
																		},
																		Value: "testm",
																	},
																},
																Operator: 1,
																Right: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 79,
																				Line:   48,
																			},
																			File:   "deadman_threshold_test.flux",
																			Source: "r._field == metric_type",
																			Start: ast.Position{
																				Column: 56,
																				Line:   48,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 64,
																					Line:   48,
																				},
																				File:   "deadman_threshold_test.flux",
																				Source: "r._field",
																				Start: ast.Position{
																					Column: 56,
																					Line:   48,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 57,
																						Line:   48,
																					},
																					File:   "deadman_threshold_test.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 56,
																						Line:   48,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 64,
																						Line:   48,
																					},
																					File:   "deadman_threshold_test.flux",
																					Source: "_field",
																					Start: ast.Position{
																						Column: 58,
																						Line:   48,
																					},
																				},
																			},
																			Name: "_field",
																		},
																		Rbrack: nil,
																	},
																	Operator: 17,
																	Right: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 79,
																					Line:   48,
																				},
																				File:   "deadman_threshold_test.flux",
																				Source: "metric_type",
																				Start: ast.Position{
																					Column: 68,
																					Line:   48,
																				},
																			},
																		},
																		Name: "metric_type",
																	},
																},
															},
															Operator: 1,
															Right: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 99,
																			Line:   48,
																		},
																		File:   "deadman_threshold_test.flux",
																		Source: "r.realm == tier",
																		Start: ast.Position{
																			Column: 84,
																			Line:   48,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 91,
																				Line:   48,
																			},
																			File:   "deadman_threshold_test.flux",
																			Source: "r.realm",
																			Start: ast.Position{
																				Column: 84,
																				Line:   48,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 85,
																					Line:   48,
																				},
																				File:   "deadman_threshold_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 84,
																					Line:   48,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 91,
																					Line:   48,
																				},
																				File:   "deadman_threshold_test.flux",
																				Source: "realm",
																				Start: ast.Position{
																					Column: 86,
																					Line:   48,
																				},
																			},
																		},
																		Name: "realm",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 99,
																				Line:   48,
																			},
																			File:   "deadman_threshold_test.flux",
																			Source: "tier",
																			Start: ast.Position{
																				Column: 95,
																				Line:   48,
																			},
																		},
																	},
																	Name: "tier",
																},
															},
														},
														Lparen: nil,
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   48,
																	},
																	File:   "deadman_threshold_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 20,
																		Line:   48,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   48,
																		},
																		File:   "deadman_threshold_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 20,
																			Line:   48,
																		},
																	},
																},
																Name: "r",
															},
															Separator: nil,
															Value:     nil,
														}},
														Rparan: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 100,
														Line:   48,
													},
													File:   "deadman_threshold_test.flux",
													Source: "filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)",
													Start: ast.Position{
														Column: 8,
														Line:   48,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   48,
														},
														File:   "deadman_threshold_test.flux",
														Source: "filter",
														Start: ast.Position{
															Column: 8,
															Line:   48,
														},
													},
												},
												Name: "filter",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   49,
											},
											File:   "deadman_threshold_test.flux",
											Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()",
											Start: ast.Position{
												Column: 36,
												Line:   46,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   49,
												},
												File:   "deadman_threshold_test.flux",
												Source: "schema.fieldsAsCols()",
												Start: ast.Position{
													Column: 8,
													Line:   49,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   49,
													},
													File:   "deadman_threshold_test.flux",
													Source: "schema.fieldsAsCols",
													Start: ast.Position{
														Column: 8,
														Line:   49,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   49,
														},
														File:   "deadman_threshold_test.flux",
														Source: "schema",
														Start: ast.Position{
															Column: 8,
															Line:   49,
														},
													},
												},
												Name: "schema",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   49,
														},
														File:   "deadman_threshold_test.flux",
														Source: "fieldsAsCols",
														Start: ast.Position{
															Column: 15,
															Line:   49,
														},
													},
												},
												Name: "fieldsAsCols",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   50,
										},
										File:   "deadman_threshold_test.flux",
										Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])",
										Start: ast.Position{
											Column: 36,
											Line:   46,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   50,
												},
												File:   "deadman_threshold_test.flux",
												Source: "columns: [\"host\", \"realm\"]",
												Start: ast.Position{
													Column: 27,
													Line:   50,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   50,
													},
													File:   "deadman_threshold_test.flux",
													Source: "columns: [\"host\", \"realm\"]",
													Start: ast.Position{
														Column: 27,
														Line:   50,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   50,
														},
														File:   "deadman_threshold_test.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 27,
															Line:   50,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 53,
															Line:   50,
														},
														File:   "deadman_threshold_test.flux",
														Source: "[\"host\", \"realm\"]",
														Start: ast.Position{
															Column: 36,
															Line:   50,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 43,
																Line:   50,
															},
															File:   "deadman_threshold_test.flux",
															Source: "\"host\"",
															Start: ast.Position{
																Column: 37,
																Line:   50,
															},
														},
													},
													Value: "host",
												}, &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 52,
																Line:   50,
															},
															File:   "deadman_threshold_test.flux",
															Source: "\"realm\"",
															Start: ast.Position{
																Column: 45,
																Line:   50,
															},
														},
													},
													Value: "realm",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   50,
											},
											File:   "deadman_threshold_test.flux",
											Source: "tickscript.groupBy(columns: [\"host\", \"realm\"])",
											Start: ast.Position{
												Column: 8,
												Line:   50,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   50,
												},
												File:   "deadman_threshold_test.flux",
												Source: "tickscript.groupBy",
												Start: ast.Position{
													Column: 8,
													Line:   50,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   50,
													},
													File:   "deadman_threshold_test.flux",
													Source: "tickscript",
													Start: ast.Position{
														Column: 8,
														Line:   50,
													},
												},
											},
											Name: "tickscript",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   50,
													},
													File:   "deadman_threshold_test.flux",
													Source: "groupBy",
													Start: ast.Position{
														Column: 19,
														Line:   50,
													},
												},
											},
											Name: "groupBy",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   56,
									},
									File:   "deadman_threshold_test.flux",
									Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\",\n    )",
									Start: ast.Position{
										Column: 36,
										Line:   46,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 100,
												Line:   55,
											},
											File:   "deadman_threshold_test.flux",
											Source: "check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\"",
											Start: ast.Position{
												Column: 9,
												Line:   52,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   52,
												},
												File:   "deadman_threshold_test.flux",
												Source: "check: check",
												Start: ast.Position{
													Column: 9,
													Line:   52,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   52,
													},
													File:   "deadman_threshold_test.flux",
													Source: "check",
													Start: ast.Position{
														Column: 9,
														Line:   52,
													},
												},
											},
											Name: "check",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   52,
													},
													File:   "deadman_threshold_test.flux",
													Source: "check",
													Start: ast.Position{
														Column: 16,
														Line:   52,
													},
												},
											},
											Name: "check",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   53,
												},
												File:   "deadman_threshold_test.flux",
												Source: "measurement: \"testm\"",
												Start: ast.Position{
													Column: 9,
													Line:   53,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   53,
													},
													File:   "deadman_threshold_test.flux",
													Source: "measurement",
													Start: ast.Position{
														Column: 9,
														Line:   53,
													},
												},
											},
											Name: "measurement",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   53,
													},
													File:   "deadman_threshold_test.flux",
													Source: "\"testm\"",
													Start: ast.Position{
														Column: 22,
														Line:   53,
													},
												},
											},
											Value: "testm",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   54,
												},
												File:   "deadman_threshold_test.flux",
												Source: "threshold: 10",
												Start: ast.Position{
													Column: 9,
													Line:   54,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   54,
													},
													File:   "deadman_threshold_test.flux",
													Source: "threshold",
													Start: ast.Position{
														Column: 9,
														Line:   54,
													},
												},
											},
											Name: "threshold",
										},
										Separator: nil,
										Value: &ast.IntegerLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   54,
													},
													File:   "deadman_threshold_test.flux",
													Source: "10",
													Start: ast.Position{
														Column: 20,
														Line:   54,
													},
												},
											},
											Value: int64(10),
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 100,
													Line:   55,
												},
												File:   "deadman_threshold_test.flux",
												Source: "id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\"",
												Start: ast.Position{
													Column: 9,
													Line:   55,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   55,
													},
													File:   "deadman_threshold_test.flux",
													Source: "id",
													Start: ast.Position{
														Column: 9,
														Line:   55,
													},
												},
											},
											Name: "id",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 100,
														Line:   55,
													},
													File:   "deadman_threshold_test.flux",
													Source: "(r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\"",
													Start: ast.Position{
														Column: 13,
														Line:   55,
													},
												},
											},
											Body: &ast.StringExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 100,
															Line:   55,
														},
														File:   "deadman_threshold_test.flux",
														Source: "\"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\"",
														Start: ast.Position{
															Column: 20,
															Line:   55,
														},
													},
												},
												Parts: []ast.StringExpressionPart{&ast.TextPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   55,
															},
															File:   "deadman_threshold_test.flux",
															Source: "Realm: ",
															Start: ast.Position{
																Column: 21,
																Line:   55,
															},
														},
													},
													Value: "Realm: ",
												}, &ast.InterpolatedPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   55,
															},
															File:   "deadman_threshold_test.flux",
															Source: "${r.realm}",
															Start: ast.Position{
																Column: 28,
																Line:   55,
															},
														},
													},
													Expression: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   55,
																},
																File:   "deadman_threshold_test.flux",
																Source: "r.realm",
																Start: ast.Position{
																	Column: 30,
																	Line:   55,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 31,
																		Line:   55,
																	},
																	File:   "deadman_threshold_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 30,
																		Line:   55,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   55,
																	},
																	File:   "deadman_threshold_test.flux",
																	Source: "realm",
																	Start: ast.Position{
																		Column: 32,
																		Line:   55,
																	},
																},
															},
															Name: "realm",
														},
														Rbrack: nil,
													},
												}, &ast.TextPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 51,
																Line:   55,
															},
															File:   "deadman_threshold_test.flux",
															Source: " - Hostname: ",
															Start: ast.Position{
																Column: 38,
																Line:   55,
															},
														},
													},
													Value: " - Hostname: ",
												}, &ast.InterpolatedPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 60,
																Line:   55,
															},
															File:   "deadman_threshold_test.flux",
															Source: "${r.host}",
															Start: ast.Position{
																Column: 51,
																Line:   55,
															},
														},
													},
													Expression: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 59,
																	Line:   55,
																},
																File:   "deadman_threshold_test.flux",
																Source: "r.host",
																Start: ast.Position{
																	Column: 53,
																	Line:   55,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 54,
																		Line:   55,
																	},
																	File:   "deadman_threshold_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 53,
																		Line:   55,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 59,
																		Line:   55,
																	},
																	File:   "deadman_threshold_test.flux",
																	Source: "host",
																	Start: ast.Position{
																		Column: 55,
																		Line:   55,
																	},
																},
															},
															Name: "host",
														},
														Rbrack: nil,
													},
												}, &ast.TextPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 71,
																Line:   55,
															},
															File:   "deadman_threshold_test.flux",
															Source: " / Metric: ",
															Start: ast.Position{
																Column: 60,
																Line:   55,
															},
														},
													},
													Value: " / Metric: ",
												}, &ast.InterpolatedPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 85,
																Line:   55,
															},
															File:   "deadman_threshold_test.flux",
															Source: "${metric_type}",
															Start: ast.Position{
																Column: 71,
																Line:   55,
															},
														},
													},
													Expression: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 84,
																	Line:   55,
																},
																File:   "deadman_threshold_test.flux",
																Source: "metric_type",
																Start: ast.Position{
																	Column: 73,
																	Line:   55,
																},
															},
														},
														Name: "metric_type",
													},
												}, &ast.TextPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 99,
																Line:   55,
															},
															File:   "deadman_threshold_test.flux",
															Source: " deadman alert",
															Start: ast.Position{
																Column: 85,
																Line:   55,
															},
														},
													},
													Value: " deadman alert",
												}},
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   55,
														},
														File:   "deadman_threshold_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   55,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   55,
															},
															File:   "deadman_threshold_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   55,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   56,
										},
										File:   "deadman_threshold_test.flux",
										Source: "tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\",\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   51,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   51,
											},
											File:   "deadman_threshold_test.flux",
											Source: "tickscript.deadman",
											Start: ast.Position{
												Column: 8,
												Line:   51,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   51,
												},
												File:   "deadman_threshold_test.flux",
												Source: "tickscript",
												Start: ast.Position{
													Column: 8,
													Line:   51,
												},
											},
										},
										Name: "tickscript",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   51,
												},
												File:   "deadman_threshold_test.flux",
												Source: "deadman",
												Start: ast.Position{
													Column: 19,
													Line:   51,
												},
											},
										},
										Name: "deadman",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   57,
								},
								File:   "deadman_threshold_test.flux",
								Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\",\n    )\n    |> drop(columns: [\"details\"])",
								Start: ast.Position{
									Column: 36,
									Line:   46,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   57,
										},
										File:   "deadman_threshold_test.flux",
										Source: "columns: [\"details\"]",
										Start: ast.Position{
											Column: 13,
											Line:   57,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   57,
											},
											File:   "deadman_threshold_test.flux",
											Source: "columns: [\"details\"]",
											Start: ast.Position{
												Column: 13,
												Line:   57,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   57,
												},
												File:   "deadman_threshold_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 13,
													Line:   57,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   57,
												},
												File:   "deadman_threshold_test.flux",
												Source: "[\"details\"]",
												Start: ast.Position{
													Column: 22,
													Line:   57,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   57,
													},
													File:   "deadman_threshold_test.flux",
													Source: "\"details\"",
													Start: ast.Position{
														Column: 23,
														Line:   57,
													},
												},
											},
											Value: "details",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   57,
									},
									File:   "deadman_threshold_test.flux",
									Source: "drop(columns: [\"details\"])",
									Start: ast.Position{
										Column: 8,
										Line:   57,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   57,
										},
										File:   "deadman_threshold_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 8,
											Line:   57,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: []ast.Comment{ast.Comment{Text: "// to avoid issue with validation\n"}},
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   58,
							},
							File:   "deadman_threshold_test.flux",
							Source: "table\n\t|> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\",\n    )\n    |> drop(columns: [\"details\"]) // to avoid issue with validation\n    |> drop(columns: [\"_time\"])",
							Start: ast.Position{
								Column: 36,
								Line:   46,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   58,
									},
									File:   "deadman_threshold_test.flux",
									Source: "columns: [\"_time\"]",
									Start: ast.Position{
										Column: 13,
										Line:   58,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   58,
										},
										File:   "deadman_threshold_test.flux",
										Source: "columns: [\"_time\"]",
										Start: ast.Position{
											Column: 13,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   58,
											},
											File:   "deadman_threshold_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   58,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   58,
											},
											File:   "deadman_threshold_test.flux",
											Source: "[\"_time\"]",
											Start: ast.Position{
												Column: 22,
												Line:   58,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   58,
												},
												File:   "deadman_threshold_test.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 23,
													Line:   58,
												},
											},
										},
										Value: "_time",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   58,
								},
								File:   "deadman_threshold_test.flux",
								Source: "drop(columns: [\"_time\"])",
								Start: ast.Position{
									Column: 8,
									Line:   58,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   58,
									},
									File:   "deadman_threshold_test.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 8,
										Line:   58,
									},
								},
							},
							Name: "drop",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   46,
							},
							File:   "deadman_threshold_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 23,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   46,
								},
								File:   "deadman_threshold_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 23,
									Line:   46,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   46,
							},
							File:   "deadman_threshold_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 29,
								Line:   46,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   64,
						},
						File:   "deadman_threshold_test.flux",
						Source: "_tickscript_deadman = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_deadman,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   60,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   60,
							},
							File:   "deadman_threshold_test.flux",
							Source: "_tickscript_deadman",
							Start: ast.Position{
								Column: 6,
								Line:   60,
							},
						},
					},
					Name: "_tickscript_deadman",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   64,
							},
							File:   "deadman_threshold_test.flux",
							Source: "() => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_deadman,\n})",
							Start: ast.Position{
								Column: 28,
								Line:   60,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   64,
								},
								File:   "deadman_threshold_test.flux",
								Source: "({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_deadman,\n})",
								Start: ast.Position{
									Column: 34,
									Line:   60,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   64,
									},
									File:   "deadman_threshold_test.flux",
									Source: "{\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_deadman,\n}",
									Start: ast.Position{
										Column: 35,
										Line:   60,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   61,
										},
										File:   "deadman_threshold_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 2,
											Line:   61,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   61,
											},
											File:   "deadman_threshold_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 2,
												Line:   61,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   61,
												},
												File:   "deadman_threshold_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 29,
													Line:   61,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   61,
													},
													File:   "deadman_threshold_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 29,
														Line:   61,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   61,
														},
														File:   "deadman_threshold_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 29,
															Line:   61,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   61,
														},
														File:   "deadman_threshold_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 34,
															Line:   61,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   61,
											},
											File:   "deadman_threshold_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 9,
												Line:   61,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   61,
												},
												File:   "deadman_threshold_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 9,
													Line:   61,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   61,
													},
													File:   "deadman_threshold_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   61,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   61,
													},
													File:   "deadman_threshold_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 17,
														Line:   61,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   62,
										},
										File:   "deadman_threshold_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 2,
											Line:   62,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   62,
											},
											File:   "deadman_threshold_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 2,
												Line:   62,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   62,
												},
												File:   "deadman_threshold_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 24,
													Line:   62,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   62,
													},
													File:   "deadman_threshold_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 24,
														Line:   62,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   62,
														},
														File:   "deadman_threshold_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 24,
															Line:   62,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   62,
														},
														File:   "deadman_threshold_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 29,
															Line:   62,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   62,
											},
											File:   "deadman_threshold_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 8,
												Line:   62,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   62,
												},
												File:   "deadman_threshold_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 8,
													Line:   62,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   62,
													},
													File:   "deadman_threshold_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 8,
														Line:   62,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   62,
													},
													File:   "deadman_threshold_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 16,
														Line:   62,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   63,
										},
										File:   "deadman_threshold_test.flux",
										Source: "fn: tickscript_deadman",
										Start: ast.Position{
											Column: 2,
											Line:   63,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 4,
												Line:   63,
											},
											File:   "deadman_threshold_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 2,
												Line:   63,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   63,
											},
											File:   "deadman_threshold_test.flux",
											Source: "tickscript_deadman",
											Start: ast.Position{
												Column: 6,
												Line:   63,
											},
										},
									},
									Name: "tickscript_deadman",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   64,
					},
					File:   "deadman_threshold_test.flux",
					Source: "test _tickscript_deadman = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: tickscript_deadman,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   60,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "deadman_threshold_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   4,
					},
					File:   "deadman_threshold_test.flux",
					Source: "import \"csv\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   4,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"csv\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "csv",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 39,
						Line:   5,
					},
					File:   "deadman_threshold_test.flux",
					Source: "import \"contrib/bonitoo-io/tickscript\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 39,
							Line:   5,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"contrib/bonitoo-io/tickscript\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "contrib/bonitoo-io/tickscript",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   6,
					},
					File:   "deadman_threshold_test.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   6,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 36,
						Line:   7,
					},
					File:   "deadman_threshold_test.flux",
					Source: "import \"influxdata/influxdb/schema\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   7,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"influxdata/influxdb/schema\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "influxdata/influxdb/schema",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "deadman_threshold_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   1,
					},
					File:   "deadman_threshold_test.flux",
					Source: "package tickscript_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   1,
						},
						File:   "deadman_threshold_test.flux",
						Source: "tickscript_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "tickscript_test",
			},
		},
	}},
	Package: "tickscript_test",
	Path:    "contrib/bonitoo-io/tickscript",
}}
