// DO NOT EDIT: This file is autogenerated via the builtin command.

package aggregate

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 2,
					Line:   130,
				},
				File:   "aggregate.flux",
				Source: "package aggregate\n\nimport \"contrib/jsternberg/math\"\n\n// table will aggregate columns and create tables with a single\n// row containing the aggregated value.\n//\n// This function takes a single parameter of `columns`. The parameter\n// is an object with the output column name as the key and the aggregate\n// object as the value.\n//\n// The aggregate object is composed of at least the following required attributes:\n//     column = string\n//         The column name for the input.\n//     init = (values) -> state\n//         An initial function to compute the initial state of the\n//         output. This can return either the final aggregate or a\n//         temporary state object that can be used to compute the\n//         final aggregate. The values parameter will always be a\n//         non-empty array of values from the specified column.\n//     reduce = (values, state) -> state\n//         A function that takes in another buffer of values\n//         and the current state of the aggregate and computes\n//         the updated state.\n//     compute = (state) -> value\n//         A function that takes the state and computes the final\n//         aggregate.\n//     fill = value\n//         The value passed to fill, if present, will determine what\n//         the aggregate does when there are no values.\n//         This can either be a value or one of the predefined\n//         identifiers of null or none.\n//         This value must be the same type as the value return from\n//         compute.\n//\n// An example of usage is:\n//     tables |> aggregate.table(columns: {\n//         \"min_bottom_degrees\": aggregate.min(column: \"bottom_degrees\"),\n//     ])\nbuiltin table : (<-tables: [A], columns: C) => [B] where A: Record, B: Record, C: Record\n\n// window will aggregate columns and create tables by\n// organizing incoming points into windows.\n//\n// Each table will have two additional columns: start and stop.\n// These are the start and stop times for each interval.\n// It is not possible to use start or stop as destination column\n// names with this function. The start and stop columns are not\n// added to the group key.\n//\n// The same options as for table apply to window.\n// In addition to those options, window requires one\n// additional parameter.\n//     every = duration\n//         The duration between the start of each interval.\n//\n// Along with the above required option, there are a few additional\n// optional parameters.\n//     time = string\n//         The column name for the time input.\n//         This defaults to _time or time, whichever is earlier in\n//         the list of columns.\n//     period = duration\n//         The length of the interval. This defaults to the\n//         every duration.\nbuiltin window : (<-tables: [A], ?time: string, every: duration, ?period: duration, columns: C) => [B] where A: Record, B: Record, C: Record\n\n// null is a sentinel value for fill that will fill\n// in a null value if there were no values for an interval.\nbuiltin null : A\n\n// none is a sentinel value for fill that will skip\n// emitting a row if there are no values for an interval.\nbuiltin none : A\n\n// define will define an aggregate function.\ndefine = (init, reduce, compute, fill=null) => (column=\"_value\", fill=fill) => ({\n\tcolumn: column,\n\tinit: init,\n\treduce: reduce,\n\tcompute: compute,\n\tfill: fill,\n})\n\n_make_selector = (fn) => define(\n\tinit: (values) => fn(values),\n\treduce: (values, state) => {\n\t\tv = fn(values)\n\t\treturn fn(values: [state, v])\n\t},\n\tcompute: (state) => state,\n)\n\n// min constructs a min aggregate or selector for the column.\nmin = _make_selector(fn: math.min)\n\n// max constructs a max aggregate or selector for the column.\nmax = _make_selector(fn: math.max)\n\n// sum constructs a sum aggregate for the column.\nsum = define(\n\tinit: (values) => math.sum(values),\n\treduce: (values, state) => {\n\t\treturn state + math.sum(values)\n\t},\n\tcompute: (state) => state,\n)\n\n// count constructs a count aggregate for the column.\ncount = define(\n\tinit: (values) => length(arr: values),\n\treduce: (values, state) => {\n\t\treturn state + length(arr: values)\n\t},\n\tcompute: (state) => state,\n\tfill: 0,\n)\n\n// mean constructs a mean aggregate for the column.\nmean = define(\n\tinit: (values) => ({\n\t\tsum: math.sum(values),\n\t\tcount: length(arr: values),\n\t}),\n\treduce: (values, state) => ({\n\t\tsum: state.sum + math.sum(values),\n\t\tcount: state.count + length(arr: values),\n\t}),\n\tcompute: (state) => float(v: state.sum) / float(v: state.count),\n)",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// table will aggregate columns and create tables with a single\n"}, ast.Comment{Text: "// row containing the aggregated value.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// This function takes a single parameter of `columns`. The parameter\n"}, ast.Comment{Text: "// is an object with the output column name as the key and the aggregate\n"}, ast.Comment{Text: "// object as the value.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// The aggregate object is composed of at least the following required attributes:\n"}, ast.Comment{Text: "//     column = string\n"}, ast.Comment{Text: "//         The column name for the input.\n"}, ast.Comment{Text: "//     init = (values) -> state\n"}, ast.Comment{Text: "//         An initial function to compute the initial state of the\n"}, ast.Comment{Text: "//         output. This can return either the final aggregate or a\n"}, ast.Comment{Text: "//         temporary state object that can be used to compute the\n"}, ast.Comment{Text: "//         final aggregate. The values parameter will always be a\n"}, ast.Comment{Text: "//         non-empty array of values from the specified column.\n"}, ast.Comment{Text: "//     reduce = (values, state) -> state\n"}, ast.Comment{Text: "//         A function that takes in another buffer of values\n"}, ast.Comment{Text: "//         and the current state of the aggregate and computes\n"}, ast.Comment{Text: "//         the updated state.\n"}, ast.Comment{Text: "//     compute = (state) -> value\n"}, ast.Comment{Text: "//         A function that takes the state and computes the final\n"}, ast.Comment{Text: "//         aggregate.\n"}, ast.Comment{Text: "//     fill = value\n"}, ast.Comment{Text: "//         The value passed to fill, if present, will determine what\n"}, ast.Comment{Text: "//         the aggregate does when there are no values.\n"}, ast.Comment{Text: "//         This can either be a value or one of the predefined\n"}, ast.Comment{Text: "//         identifiers of null or none.\n"}, ast.Comment{Text: "//         This value must be the same type as the value return from\n"}, ast.Comment{Text: "//         compute.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// An example of usage is:\n"}, ast.Comment{Text: "//     tables |> aggregate.table(columns: {\n"}, ast.Comment{Text: "//         \"min_bottom_degrees\": aggregate.min(column: \"bottom_degrees\"),\n"}, ast.Comment{Text: "//     ])\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   40,
					},
					File:   "aggregate.flux",
					Source: "builtin table",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   40,
						},
						File:   "aggregate.flux",
						Source: "table",
						Start: ast.Position{
							Column: 9,
							Line:   40,
						},
					},
				},
				Name: "table",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 89,
							Line:   40,
						},
						File:   "aggregate.flux",
						Source: "(<-tables: [A], columns: C) => [B] where A: Record, B: Record, C: Record",
						Start: ast.Position{
							Column: 17,
							Line:   40,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 67,
								Line:   40,
							},
							File:   "aggregate.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 58,
								Line:   40,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   40,
								},
								File:   "aggregate.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 61,
									Line:   40,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   40,
								},
								File:   "aggregate.flux",
								Source: "A",
								Start: ast.Position{
									Column: 58,
									Line:   40,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 78,
								Line:   40,
							},
							File:   "aggregate.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 69,
								Line:   40,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   40,
								},
								File:   "aggregate.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 72,
									Line:   40,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   40,
								},
								File:   "aggregate.flux",
								Source: "B",
								Start: ast.Position{
									Column: 69,
									Line:   40,
								},
							},
						},
						Name: "B",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 89,
								Line:   40,
							},
							File:   "aggregate.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 80,
								Line:   40,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   40,
								},
								File:   "aggregate.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 83,
									Line:   40,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   40,
								},
								File:   "aggregate.flux",
								Source: "C",
								Start: ast.Position{
									Column: 80,
									Line:   40,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 51,
								Line:   40,
							},
							File:   "aggregate.flux",
							Source: "(<-tables: [A], columns: C) => [B]",
							Start: ast.Position{
								Column: 17,
								Line:   40,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   40,
								},
								File:   "aggregate.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   40,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   40,
									},
									File:   "aggregate.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   40,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   40,
									},
									File:   "aggregate.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   40,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   40,
										},
										File:   "aggregate.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   40,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   40,
											},
											File:   "aggregate.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   40,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   40,
								},
								File:   "aggregate.flux",
								Source: "columns: C",
								Start: ast.Position{
									Column: 33,
									Line:   40,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   40,
									},
									File:   "aggregate.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 33,
										Line:   40,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   40,
									},
									File:   "aggregate.flux",
									Source: "C",
									Start: ast.Position{
										Column: 42,
										Line:   40,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "aggregate.flux",
										Source: "C",
										Start: ast.Position{
											Column: 42,
											Line:   40,
										},
									},
								},
								Name: "C",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   40,
								},
								File:   "aggregate.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 48,
									Line:   40,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   40,
									},
									File:   "aggregate.flux",
									Source: "B",
									Start: ast.Position{
										Column: 49,
										Line:   40,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   40,
										},
										File:   "aggregate.flux",
										Source: "B",
										Start: ast.Position{
											Column: 49,
											Line:   40,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// window will aggregate columns and create tables by\n"}, ast.Comment{Text: "// organizing incoming points into windows.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Each table will have two additional columns: start and stop.\n"}, ast.Comment{Text: "// These are the start and stop times for each interval.\n"}, ast.Comment{Text: "// It is not possible to use start or stop as destination column\n"}, ast.Comment{Text: "// names with this function. The start and stop columns are not\n"}, ast.Comment{Text: "// added to the group key.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// The same options as for table apply to window.\n"}, ast.Comment{Text: "// In addition to those options, window requires one\n"}, ast.Comment{Text: "// additional parameter.\n"}, ast.Comment{Text: "//     every = duration\n"}, ast.Comment{Text: "//         The duration between the start of each interval.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Along with the above required option, there are a few additional\n"}, ast.Comment{Text: "// optional parameters.\n"}, ast.Comment{Text: "//     time = string\n"}, ast.Comment{Text: "//         The column name for the time input.\n"}, ast.Comment{Text: "//         This defaults to _time or time, whichever is earlier in\n"}, ast.Comment{Text: "//         the list of columns.\n"}, ast.Comment{Text: "//     period = duration\n"}, ast.Comment{Text: "//         The length of the interval. This defaults to the\n"}, ast.Comment{Text: "//         every duration.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   66,
					},
					File:   "aggregate.flux",
					Source: "builtin window",
					Start: ast.Position{
						Column: 1,
						Line:   66,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   66,
						},
						File:   "aggregate.flux",
						Source: "window",
						Start: ast.Position{
							Column: 9,
							Line:   66,
						},
					},
				},
				Name: "window",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 141,
							Line:   66,
						},
						File:   "aggregate.flux",
						Source: "(<-tables: [A], ?time: string, every: duration, ?period: duration, columns: C) => [B] where A: Record, B: Record, C: Record",
						Start: ast.Position{
							Column: 18,
							Line:   66,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 119,
								Line:   66,
							},
							File:   "aggregate.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 110,
								Line:   66,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 119,
									Line:   66,
								},
								File:   "aggregate.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 113,
									Line:   66,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 111,
									Line:   66,
								},
								File:   "aggregate.flux",
								Source: "A",
								Start: ast.Position{
									Column: 110,
									Line:   66,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 130,
								Line:   66,
							},
							File:   "aggregate.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 121,
								Line:   66,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 130,
									Line:   66,
								},
								File:   "aggregate.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 124,
									Line:   66,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 122,
									Line:   66,
								},
								File:   "aggregate.flux",
								Source: "B",
								Start: ast.Position{
									Column: 121,
									Line:   66,
								},
							},
						},
						Name: "B",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 141,
								Line:   66,
							},
							File:   "aggregate.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 132,
								Line:   66,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 141,
									Line:   66,
								},
								File:   "aggregate.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 135,
									Line:   66,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 133,
									Line:   66,
								},
								File:   "aggregate.flux",
								Source: "C",
								Start: ast.Position{
									Column: 132,
									Line:   66,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 103,
								Line:   66,
							},
							File:   "aggregate.flux",
							Source: "(<-tables: [A], ?time: string, every: duration, ?period: duration, columns: C) => [B]",
							Start: ast.Position{
								Column: 18,
								Line:   66,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   66,
								},
								File:   "aggregate.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   66,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   66,
									},
									File:   "aggregate.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   66,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   66,
									},
									File:   "aggregate.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   66,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   66,
										},
										File:   "aggregate.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   66,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   66,
											},
											File:   "aggregate.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   66,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   66,
								},
								File:   "aggregate.flux",
								Source: "?time: string",
								Start: ast.Position{
									Column: 34,
									Line:   66,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   66,
									},
									File:   "aggregate.flux",
									Source: "time",
									Start: ast.Position{
										Column: 35,
										Line:   66,
									},
								},
							},
							Name: "time",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   66,
									},
									File:   "aggregate.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   66,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   66,
										},
										File:   "aggregate.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   66,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   66,
								},
								File:   "aggregate.flux",
								Source: "every: duration",
								Start: ast.Position{
									Column: 49,
									Line:   66,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   66,
									},
									File:   "aggregate.flux",
									Source: "every",
									Start: ast.Position{
										Column: 49,
										Line:   66,
									},
								},
							},
							Name: "every",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   66,
									},
									File:   "aggregate.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 56,
										Line:   66,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   66,
										},
										File:   "aggregate.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 56,
											Line:   66,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   66,
								},
								File:   "aggregate.flux",
								Source: "?period: duration",
								Start: ast.Position{
									Column: 66,
									Line:   66,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 73,
										Line:   66,
									},
									File:   "aggregate.flux",
									Source: "period",
									Start: ast.Position{
										Column: 67,
										Line:   66,
									},
								},
							},
							Name: "period",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 83,
										Line:   66,
									},
									File:   "aggregate.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 75,
										Line:   66,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 83,
											Line:   66,
										},
										File:   "aggregate.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 75,
											Line:   66,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 95,
									Line:   66,
								},
								File:   "aggregate.flux",
								Source: "columns: C",
								Start: ast.Position{
									Column: 85,
									Line:   66,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 92,
										Line:   66,
									},
									File:   "aggregate.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 85,
										Line:   66,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 95,
										Line:   66,
									},
									File:   "aggregate.flux",
									Source: "C",
									Start: ast.Position{
										Column: 94,
										Line:   66,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 95,
											Line:   66,
										},
										File:   "aggregate.flux",
										Source: "C",
										Start: ast.Position{
											Column: 94,
											Line:   66,
										},
									},
								},
								Name: "C",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 103,
									Line:   66,
								},
								File:   "aggregate.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 100,
									Line:   66,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 102,
										Line:   66,
									},
									File:   "aggregate.flux",
									Source: "B",
									Start: ast.Position{
										Column: 101,
										Line:   66,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 102,
											Line:   66,
										},
										File:   "aggregate.flux",
										Source: "B",
										Start: ast.Position{
											Column: 101,
											Line:   66,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// null is a sentinel value for fill that will fill\n"}, ast.Comment{Text: "// in a null value if there were no values for an interval.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   70,
					},
					File:   "aggregate.flux",
					Source: "builtin null",
					Start: ast.Position{
						Column: 1,
						Line:   70,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   70,
						},
						File:   "aggregate.flux",
						Source: "null",
						Start: ast.Position{
							Column: 9,
							Line:   70,
						},
					},
				},
				Name: "null",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   70,
						},
						File:   "aggregate.flux",
						Source: "A",
						Start: ast.Position{
							Column: 16,
							Line:   70,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.TvarType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   70,
							},
							File:   "aggregate.flux",
							Source: "A",
							Start: ast.Position{
								Column: 16,
								Line:   70,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   70,
								},
								File:   "aggregate.flux",
								Source: "A",
								Start: ast.Position{
									Column: 16,
									Line:   70,
								},
							},
						},
						Name: "A",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// none is a sentinel value for fill that will skip\n"}, ast.Comment{Text: "// emitting a row if there are no values for an interval.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   74,
					},
					File:   "aggregate.flux",
					Source: "builtin none",
					Start: ast.Position{
						Column: 1,
						Line:   74,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   74,
						},
						File:   "aggregate.flux",
						Source: "none",
						Start: ast.Position{
							Column: 9,
							Line:   74,
						},
					},
				},
				Name: "none",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   74,
						},
						File:   "aggregate.flux",
						Source: "A",
						Start: ast.Position{
							Column: 16,
							Line:   74,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.TvarType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   74,
							},
							File:   "aggregate.flux",
							Source: "A",
							Start: ast.Position{
								Column: 16,
								Line:   74,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   74,
								},
								File:   "aggregate.flux",
								Source: "A",
								Start: ast.Position{
									Column: 16,
									Line:   74,
								},
							},
						},
						Name: "A",
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   83,
					},
					File:   "aggregate.flux",
					Source: "define = (init, reduce, compute, fill=null) => (column=\"_value\", fill=fill) => ({\n\tcolumn: column,\n\tinit: init,\n\treduce: reduce,\n\tcompute: compute,\n\tfill: fill,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   77,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// define will define an aggregate function.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   77,
						},
						File:   "aggregate.flux",
						Source: "define",
						Start: ast.Position{
							Column: 1,
							Line:   77,
						},
					},
				},
				Name: "define",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   83,
						},
						File:   "aggregate.flux",
						Source: "(init, reduce, compute, fill=null) => (column=\"_value\", fill=fill) => ({\n\tcolumn: column,\n\tinit: init,\n\treduce: reduce,\n\tcompute: compute,\n\tfill: fill,\n})",
						Start: ast.Position{
							Column: 10,
							Line:   77,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   83,
							},
							File:   "aggregate.flux",
							Source: "(column=\"_value\", fill=fill) => ({\n\tcolumn: column,\n\tinit: init,\n\treduce: reduce,\n\tcompute: compute,\n\tfill: fill,\n})",
							Start: ast.Position{
								Column: 48,
								Line:   77,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   83,
								},
								File:   "aggregate.flux",
								Source: "({\n\tcolumn: column,\n\tinit: init,\n\treduce: reduce,\n\tcompute: compute,\n\tfill: fill,\n})",
								Start: ast.Position{
									Column: 80,
									Line:   77,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   83,
									},
									File:   "aggregate.flux",
									Source: "{\n\tcolumn: column,\n\tinit: init,\n\treduce: reduce,\n\tcompute: compute,\n\tfill: fill,\n}",
									Start: ast.Position{
										Column: 81,
										Line:   77,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   78,
										},
										File:   "aggregate.flux",
										Source: "column: column",
										Start: ast.Position{
											Column: 2,
											Line:   78,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   78,
											},
											File:   "aggregate.flux",
											Source: "column",
											Start: ast.Position{
												Column: 2,
												Line:   78,
											},
										},
									},
									Name: "column",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   78,
											},
											File:   "aggregate.flux",
											Source: "column",
											Start: ast.Position{
												Column: 10,
												Line:   78,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   79,
										},
										File:   "aggregate.flux",
										Source: "init: init",
										Start: ast.Position{
											Column: 2,
											Line:   79,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   79,
											},
											File:   "aggregate.flux",
											Source: "init",
											Start: ast.Position{
												Column: 2,
												Line:   79,
											},
										},
									},
									Name: "init",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   79,
											},
											File:   "aggregate.flux",
											Source: "init",
											Start: ast.Position{
												Column: 8,
												Line:   79,
											},
										},
									},
									Name: "init",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   80,
										},
										File:   "aggregate.flux",
										Source: "reduce: reduce",
										Start: ast.Position{
											Column: 2,
											Line:   80,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   80,
											},
											File:   "aggregate.flux",
											Source: "reduce",
											Start: ast.Position{
												Column: 2,
												Line:   80,
											},
										},
									},
									Name: "reduce",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   80,
											},
											File:   "aggregate.flux",
											Source: "reduce",
											Start: ast.Position{
												Column: 10,
												Line:   80,
											},
										},
									},
									Name: "reduce",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   81,
										},
										File:   "aggregate.flux",
										Source: "compute: compute",
										Start: ast.Position{
											Column: 2,
											Line:   81,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   81,
											},
											File:   "aggregate.flux",
											Source: "compute",
											Start: ast.Position{
												Column: 2,
												Line:   81,
											},
										},
									},
									Name: "compute",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   81,
											},
											File:   "aggregate.flux",
											Source: "compute",
											Start: ast.Position{
												Column: 11,
												Line:   81,
											},
										},
									},
									Name: "compute",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   82,
										},
										File:   "aggregate.flux",
										Source: "fill: fill",
										Start: ast.Position{
											Column: 2,
											Line:   82,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   82,
											},
											File:   "aggregate.flux",
											Source: "fill",
											Start: ast.Position{
												Column: 2,
												Line:   82,
											},
										},
									},
									Name: "fill",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   82,
											},
											File:   "aggregate.flux",
											Source: "fill",
											Start: ast.Position{
												Column: 8,
												Line:   82,
											},
										},
									},
									Name: "fill",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   77,
								},
								File:   "aggregate.flux",
								Source: "column=\"_value\"",
								Start: ast.Position{
									Column: 49,
									Line:   77,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   77,
									},
									File:   "aggregate.flux",
									Source: "column",
									Start: ast.Position{
										Column: 49,
										Line:   77,
									},
								},
							},
							Name: "column",
						},
						Separator: nil,
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   77,
									},
									File:   "aggregate.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 56,
										Line:   77,
									},
								},
							},
							Value: "_value",
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   77,
								},
								File:   "aggregate.flux",
								Source: "fill=fill",
								Start: ast.Position{
									Column: 66,
									Line:   77,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   77,
									},
									File:   "aggregate.flux",
									Source: "fill",
									Start: ast.Position{
										Column: 66,
										Line:   77,
									},
								},
							},
							Name: "fill",
						},
						Separator: nil,
						Value: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   77,
									},
									File:   "aggregate.flux",
									Source: "fill",
									Start: ast.Position{
										Column: 71,
										Line:   77,
									},
								},
							},
							Name: "fill",
						},
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   77,
							},
							File:   "aggregate.flux",
							Source: "init",
							Start: ast.Position{
								Column: 11,
								Line:   77,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   77,
								},
								File:   "aggregate.flux",
								Source: "init",
								Start: ast.Position{
									Column: 11,
									Line:   77,
								},
							},
						},
						Name: "init",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   77,
							},
							File:   "aggregate.flux",
							Source: "reduce",
							Start: ast.Position{
								Column: 17,
								Line:   77,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   77,
								},
								File:   "aggregate.flux",
								Source: "reduce",
								Start: ast.Position{
									Column: 17,
									Line:   77,
								},
							},
						},
						Name: "reduce",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   77,
							},
							File:   "aggregate.flux",
							Source: "compute",
							Start: ast.Position{
								Column: 25,
								Line:   77,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   77,
								},
								File:   "aggregate.flux",
								Source: "compute",
								Start: ast.Position{
									Column: 25,
									Line:   77,
								},
							},
						},
						Name: "compute",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   77,
							},
							File:   "aggregate.flux",
							Source: "fill=null",
							Start: ast.Position{
								Column: 34,
								Line:   77,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   77,
								},
								File:   "aggregate.flux",
								Source: "fill",
								Start: ast.Position{
									Column: 34,
									Line:   77,
								},
							},
						},
						Name: "fill",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   77,
								},
								File:   "aggregate.flux",
								Source: "null",
								Start: ast.Position{
									Column: 39,
									Line:   77,
								},
							},
						},
						Name: "null",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   92,
					},
					File:   "aggregate.flux",
					Source: "_make_selector = (fn) => define(\n\tinit: (values) => fn(values),\n\treduce: (values, state) => {\n\t\tv = fn(values)\n\t\treturn fn(values: [state, v])\n\t},\n\tcompute: (state) => state,\n)",
					Start: ast.Position{
						Column: 1,
						Line:   85,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   85,
						},
						File:   "aggregate.flux",
						Source: "_make_selector",
						Start: ast.Position{
							Column: 1,
							Line:   85,
						},
					},
				},
				Name: "_make_selector",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   92,
						},
						File:   "aggregate.flux",
						Source: "(fn) => define(\n\tinit: (values) => fn(values),\n\treduce: (values, state) => {\n\t\tv = fn(values)\n\t\treturn fn(values: [state, v])\n\t},\n\tcompute: (state) => state,\n)",
						Start: ast.Position{
							Column: 18,
							Line:   85,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   91,
								},
								File:   "aggregate.flux",
								Source: "init: (values) => fn(values),\n\treduce: (values, state) => {\n\t\tv = fn(values)\n\t\treturn fn(values: [state, v])\n\t},\n\tcompute: (state) => state",
								Start: ast.Position{
									Column: 2,
									Line:   86,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   86,
									},
									File:   "aggregate.flux",
									Source: "init: (values) => fn(values)",
									Start: ast.Position{
										Column: 2,
										Line:   86,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   86,
										},
										File:   "aggregate.flux",
										Source: "init",
										Start: ast.Position{
											Column: 2,
											Line:   86,
										},
									},
								},
								Name: "init",
							},
							Separator: nil,
							Value: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   86,
										},
										File:   "aggregate.flux",
										Source: "(values) => fn(values)",
										Start: ast.Position{
											Column: 8,
											Line:   86,
										},
									},
								},
								Body: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   86,
												},
												File:   "aggregate.flux",
												Source: "values",
												Start: ast.Position{
													Column: 23,
													Line:   86,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   86,
													},
													File:   "aggregate.flux",
													Source: "values",
													Start: ast.Position{
														Column: 23,
														Line:   86,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   86,
														},
														File:   "aggregate.flux",
														Source: "values",
														Start: ast.Position{
															Column: 23,
															Line:   86,
														},
													},
												},
												Name: "values",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   86,
											},
											File:   "aggregate.flux",
											Source: "fn(values)",
											Start: ast.Position{
												Column: 20,
												Line:   86,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   86,
												},
												File:   "aggregate.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 20,
													Line:   86,
												},
											},
										},
										Name: "fn",
									},
									Lparen: nil,
									Rparen: nil,
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   86,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 9,
												Line:   86,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   86,
												},
												File:   "aggregate.flux",
												Source: "values",
												Start: ast.Position{
													Column: 9,
													Line:   86,
												},
											},
										},
										Name: "values",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 3,
										Line:   90,
									},
									File:   "aggregate.flux",
									Source: "reduce: (values, state) => {\n\t\tv = fn(values)\n\t\treturn fn(values: [state, v])\n\t}",
									Start: ast.Position{
										Column: 2,
										Line:   87,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   87,
										},
										File:   "aggregate.flux",
										Source: "reduce",
										Start: ast.Position{
											Column: 2,
											Line:   87,
										},
									},
								},
								Name: "reduce",
							},
							Separator: nil,
							Value: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 3,
											Line:   90,
										},
										File:   "aggregate.flux",
										Source: "(values, state) => {\n\t\tv = fn(values)\n\t\treturn fn(values: [state, v])\n\t}",
										Start: ast.Position{
											Column: 10,
											Line:   87,
										},
									},
								},
								Body: &ast.Block{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 3,
												Line:   90,
											},
											File:   "aggregate.flux",
											Source: "{\n\t\tv = fn(values)\n\t\treturn fn(values: [state, v])\n\t}",
											Start: ast.Position{
												Column: 29,
												Line:   87,
											},
										},
									},
									Body: []ast.Statement{&ast.VariableAssignment{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   88,
												},
												File:   "aggregate.flux",
												Source: "v = fn(values)",
												Start: ast.Position{
													Column: 3,
													Line:   88,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 4,
														Line:   88,
													},
													File:   "aggregate.flux",
													Source: "v",
													Start: ast.Position{
														Column: 3,
														Line:   88,
													},
												},
											},
											Name: "v",
										},
										Init: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   88,
														},
														File:   "aggregate.flux",
														Source: "values",
														Start: ast.Position{
															Column: 10,
															Line:   88,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 16,
																Line:   88,
															},
															File:   "aggregate.flux",
															Source: "values",
															Start: ast.Position{
																Column: 10,
																Line:   88,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 16,
																	Line:   88,
																},
																File:   "aggregate.flux",
																Source: "values",
																Start: ast.Position{
																	Column: 10,
																	Line:   88,
																},
															},
														},
														Name: "values",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   88,
													},
													File:   "aggregate.flux",
													Source: "fn(values)",
													Start: ast.Position{
														Column: 7,
														Line:   88,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 9,
															Line:   88,
														},
														File:   "aggregate.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 7,
															Line:   88,
														},
													},
												},
												Name: "fn",
											},
											Lparen: nil,
											Rparen: nil,
										},
									}, &ast.ReturnStatement{
										Argument: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   89,
														},
														File:   "aggregate.flux",
														Source: "values: [state, v]",
														Start: ast.Position{
															Column: 13,
															Line:   89,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   89,
															},
															File:   "aggregate.flux",
															Source: "values: [state, v]",
															Start: ast.Position{
																Column: 13,
																Line:   89,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   89,
																},
																File:   "aggregate.flux",
																Source: "values",
																Start: ast.Position{
																	Column: 13,
																	Line:   89,
																},
															},
														},
														Name: "values",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   89,
																},
																File:   "aggregate.flux",
																Source: "[state, v]",
																Start: ast.Position{
																	Column: 21,
																	Line:   89,
																},
															},
														},
														Elements: []ast.Expression{&ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 27,
																		Line:   89,
																	},
																	File:   "aggregate.flux",
																	Source: "state",
																	Start: ast.Position{
																		Column: 22,
																		Line:   89,
																	},
																},
															},
															Name: "state",
														}, &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   89,
																	},
																	File:   "aggregate.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 29,
																		Line:   89,
																	},
																},
															},
															Name: "v",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   89,
													},
													File:   "aggregate.flux",
													Source: "fn(values: [state, v])",
													Start: ast.Position{
														Column: 10,
														Line:   89,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 12,
															Line:   89,
														},
														File:   "aggregate.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 10,
															Line:   89,
														},
													},
												},
												Name: "fn",
											},
											Lparen: nil,
											Rparen: nil,
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   89,
												},
												File:   "aggregate.flux",
												Source: "return fn(values: [state, v])",
												Start: ast.Position{
													Column: 3,
													Line:   89,
												},
											},
										},
									}},
									Lbrace: nil,
									Rbrace: nil,
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   87,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 11,
												Line:   87,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   87,
												},
												File:   "aggregate.flux",
												Source: "values",
												Start: ast.Position{
													Column: 11,
													Line:   87,
												},
											},
										},
										Name: "values",
									},
									Separator: nil,
									Value:     nil,
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   87,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 19,
												Line:   87,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   87,
												},
												File:   "aggregate.flux",
												Source: "state",
												Start: ast.Position{
													Column: 19,
													Line:   87,
												},
											},
										},
										Name: "state",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   91,
									},
									File:   "aggregate.flux",
									Source: "compute: (state) => state",
									Start: ast.Position{
										Column: 2,
										Line:   91,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   91,
										},
										File:   "aggregate.flux",
										Source: "compute",
										Start: ast.Position{
											Column: 2,
											Line:   91,
										},
									},
								},
								Name: "compute",
							},
							Separator: nil,
							Value: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   91,
										},
										File:   "aggregate.flux",
										Source: "(state) => state",
										Start: ast.Position{
											Column: 11,
											Line:   91,
										},
									},
								},
								Body: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   91,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 22,
												Line:   91,
											},
										},
									},
									Name: "state",
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   91,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 12,
												Line:   91,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   91,
												},
												File:   "aggregate.flux",
												Source: "state",
												Start: ast.Position{
													Column: 12,
													Line:   91,
												},
											},
										},
										Name: "state",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   92,
							},
							File:   "aggregate.flux",
							Source: "define(\n\tinit: (values) => fn(values),\n\treduce: (values, state) => {\n\t\tv = fn(values)\n\t\treturn fn(values: [state, v])\n\t},\n\tcompute: (state) => state,\n)",
							Start: ast.Position{
								Column: 26,
								Line:   85,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   85,
								},
								File:   "aggregate.flux",
								Source: "define",
								Start: ast.Position{
									Column: 26,
									Line:   85,
								},
							},
						},
						Name: "define",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   85,
							},
							File:   "aggregate.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 19,
								Line:   85,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   85,
								},
								File:   "aggregate.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 19,
									Line:   85,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 35,
						Line:   95,
					},
					File:   "aggregate.flux",
					Source: "min = _make_selector(fn: math.min)",
					Start: ast.Position{
						Column: 1,
						Line:   95,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// min constructs a min aggregate or selector for the column.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   95,
						},
						File:   "aggregate.flux",
						Source: "min",
						Start: ast.Position{
							Column: 1,
							Line:   95,
						},
					},
				},
				Name: "min",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   95,
							},
							File:   "aggregate.flux",
							Source: "fn: math.min",
							Start: ast.Position{
								Column: 22,
								Line:   95,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   95,
								},
								File:   "aggregate.flux",
								Source: "fn: math.min",
								Start: ast.Position{
									Column: 22,
									Line:   95,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   95,
									},
									File:   "aggregate.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 22,
										Line:   95,
									},
								},
							},
							Name: "fn",
						},
						Separator: nil,
						Value: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   95,
									},
									File:   "aggregate.flux",
									Source: "math.min",
									Start: ast.Position{
										Column: 26,
										Line:   95,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   95,
										},
										File:   "aggregate.flux",
										Source: "math",
										Start: ast.Position{
											Column: 26,
											Line:   95,
										},
									},
								},
								Name: "math",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   95,
										},
										File:   "aggregate.flux",
										Source: "min",
										Start: ast.Position{
											Column: 31,
											Line:   95,
										},
									},
								},
								Name: "min",
							},
							Rbrack: nil,
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   95,
						},
						File:   "aggregate.flux",
						Source: "_make_selector(fn: math.min)",
						Start: ast.Position{
							Column: 7,
							Line:   95,
						},
					},
				},
				Callee: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   95,
							},
							File:   "aggregate.flux",
							Source: "_make_selector",
							Start: ast.Position{
								Column: 7,
								Line:   95,
							},
						},
					},
					Name: "_make_selector",
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 35,
						Line:   98,
					},
					File:   "aggregate.flux",
					Source: "max = _make_selector(fn: math.max)",
					Start: ast.Position{
						Column: 1,
						Line:   98,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// max constructs a max aggregate or selector for the column.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   98,
						},
						File:   "aggregate.flux",
						Source: "max",
						Start: ast.Position{
							Column: 1,
							Line:   98,
						},
					},
				},
				Name: "max",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   98,
							},
							File:   "aggregate.flux",
							Source: "fn: math.max",
							Start: ast.Position{
								Column: 22,
								Line:   98,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   98,
								},
								File:   "aggregate.flux",
								Source: "fn: math.max",
								Start: ast.Position{
									Column: 22,
									Line:   98,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   98,
									},
									File:   "aggregate.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 22,
										Line:   98,
									},
								},
							},
							Name: "fn",
						},
						Separator: nil,
						Value: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   98,
									},
									File:   "aggregate.flux",
									Source: "math.max",
									Start: ast.Position{
										Column: 26,
										Line:   98,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   98,
										},
										File:   "aggregate.flux",
										Source: "math",
										Start: ast.Position{
											Column: 26,
											Line:   98,
										},
									},
								},
								Name: "math",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   98,
										},
										File:   "aggregate.flux",
										Source: "max",
										Start: ast.Position{
											Column: 31,
											Line:   98,
										},
									},
								},
								Name: "max",
							},
							Rbrack: nil,
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   98,
						},
						File:   "aggregate.flux",
						Source: "_make_selector(fn: math.max)",
						Start: ast.Position{
							Column: 7,
							Line:   98,
						},
					},
				},
				Callee: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   98,
							},
							File:   "aggregate.flux",
							Source: "_make_selector",
							Start: ast.Position{
								Column: 7,
								Line:   98,
							},
						},
					},
					Name: "_make_selector",
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   107,
					},
					File:   "aggregate.flux",
					Source: "sum = define(\n\tinit: (values) => math.sum(values),\n\treduce: (values, state) => {\n\t\treturn state + math.sum(values)\n\t},\n\tcompute: (state) => state,\n)",
					Start: ast.Position{
						Column: 1,
						Line:   101,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// sum constructs a sum aggregate for the column.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   101,
						},
						File:   "aggregate.flux",
						Source: "sum",
						Start: ast.Position{
							Column: 1,
							Line:   101,
						},
					},
				},
				Name: "sum",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   106,
							},
							File:   "aggregate.flux",
							Source: "init: (values) => math.sum(values),\n\treduce: (values, state) => {\n\t\treturn state + math.sum(values)\n\t},\n\tcompute: (state) => state",
							Start: ast.Position{
								Column: 2,
								Line:   102,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   102,
								},
								File:   "aggregate.flux",
								Source: "init: (values) => math.sum(values)",
								Start: ast.Position{
									Column: 2,
									Line:   102,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   102,
									},
									File:   "aggregate.flux",
									Source: "init",
									Start: ast.Position{
										Column: 2,
										Line:   102,
									},
								},
							},
							Name: "init",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   102,
									},
									File:   "aggregate.flux",
									Source: "(values) => math.sum(values)",
									Start: ast.Position{
										Column: 8,
										Line:   102,
									},
								},
							},
							Body: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   102,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 29,
												Line:   102,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   102,
												},
												File:   "aggregate.flux",
												Source: "values",
												Start: ast.Position{
													Column: 29,
													Line:   102,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   102,
													},
													File:   "aggregate.flux",
													Source: "values",
													Start: ast.Position{
														Column: 29,
														Line:   102,
													},
												},
											},
											Name: "values",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   102,
										},
										File:   "aggregate.flux",
										Source: "math.sum(values)",
										Start: ast.Position{
											Column: 20,
											Line:   102,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   102,
											},
											File:   "aggregate.flux",
											Source: "math.sum",
											Start: ast.Position{
												Column: 20,
												Line:   102,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   102,
												},
												File:   "aggregate.flux",
												Source: "math",
												Start: ast.Position{
													Column: 20,
													Line:   102,
												},
											},
										},
										Name: "math",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   102,
												},
												File:   "aggregate.flux",
												Source: "sum",
												Start: ast.Position{
													Column: 25,
													Line:   102,
												},
											},
										},
										Name: "sum",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   102,
										},
										File:   "aggregate.flux",
										Source: "values",
										Start: ast.Position{
											Column: 9,
											Line:   102,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   102,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 9,
												Line:   102,
											},
										},
									},
									Name: "values",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   105,
								},
								File:   "aggregate.flux",
								Source: "reduce: (values, state) => {\n\t\treturn state + math.sum(values)\n\t}",
								Start: ast.Position{
									Column: 2,
									Line:   103,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   103,
									},
									File:   "aggregate.flux",
									Source: "reduce",
									Start: ast.Position{
										Column: 2,
										Line:   103,
									},
								},
							},
							Name: "reduce",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 3,
										Line:   105,
									},
									File:   "aggregate.flux",
									Source: "(values, state) => {\n\t\treturn state + math.sum(values)\n\t}",
									Start: ast.Position{
										Column: 10,
										Line:   103,
									},
								},
							},
							Body: &ast.Block{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 3,
											Line:   105,
										},
										File:   "aggregate.flux",
										Source: "{\n\t\treturn state + math.sum(values)\n\t}",
										Start: ast.Position{
											Column: 29,
											Line:   103,
										},
									},
								},
								Body: []ast.Statement{&ast.ReturnStatement{
									Argument: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   104,
												},
												File:   "aggregate.flux",
												Source: "state + math.sum(values)",
												Start: ast.Position{
													Column: 10,
													Line:   104,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   104,
													},
													File:   "aggregate.flux",
													Source: "state",
													Start: ast.Position{
														Column: 10,
														Line:   104,
													},
												},
											},
											Name: "state",
										},
										Operator: 5,
										Right: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   104,
														},
														File:   "aggregate.flux",
														Source: "values",
														Start: ast.Position{
															Column: 27,
															Line:   104,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 33,
																Line:   104,
															},
															File:   "aggregate.flux",
															Source: "values",
															Start: ast.Position{
																Column: 27,
																Line:   104,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 33,
																	Line:   104,
																},
																File:   "aggregate.flux",
																Source: "values",
																Start: ast.Position{
																	Column: 27,
																	Line:   104,
																},
															},
														},
														Name: "values",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   104,
													},
													File:   "aggregate.flux",
													Source: "math.sum(values)",
													Start: ast.Position{
														Column: 18,
														Line:   104,
													},
												},
											},
											Callee: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   104,
														},
														File:   "aggregate.flux",
														Source: "math.sum",
														Start: ast.Position{
															Column: 18,
															Line:   104,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   104,
															},
															File:   "aggregate.flux",
															Source: "math",
															Start: ast.Position{
																Column: 18,
																Line:   104,
															},
														},
													},
													Name: "math",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   104,
															},
															File:   "aggregate.flux",
															Source: "sum",
															Start: ast.Position{
																Column: 23,
																Line:   104,
															},
														},
													},
													Name: "sum",
												},
												Rbrack: nil,
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   104,
											},
											File:   "aggregate.flux",
											Source: "return state + math.sum(values)",
											Start: ast.Position{
												Column: 3,
												Line:   104,
											},
										},
									},
								}},
								Lbrace: nil,
								Rbrace: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   103,
										},
										File:   "aggregate.flux",
										Source: "values",
										Start: ast.Position{
											Column: 11,
											Line:   103,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   103,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 11,
												Line:   103,
											},
										},
									},
									Name: "values",
								},
								Separator: nil,
								Value:     nil,
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   103,
										},
										File:   "aggregate.flux",
										Source: "state",
										Start: ast.Position{
											Column: 19,
											Line:   103,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   103,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 19,
												Line:   103,
											},
										},
									},
									Name: "state",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   106,
								},
								File:   "aggregate.flux",
								Source: "compute: (state) => state",
								Start: ast.Position{
									Column: 2,
									Line:   106,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   106,
									},
									File:   "aggregate.flux",
									Source: "compute",
									Start: ast.Position{
										Column: 2,
										Line:   106,
									},
								},
							},
							Name: "compute",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   106,
									},
									File:   "aggregate.flux",
									Source: "(state) => state",
									Start: ast.Position{
										Column: 11,
										Line:   106,
									},
								},
							},
							Body: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   106,
										},
										File:   "aggregate.flux",
										Source: "state",
										Start: ast.Position{
											Column: 22,
											Line:   106,
										},
									},
								},
								Name: "state",
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   106,
										},
										File:   "aggregate.flux",
										Source: "state",
										Start: ast.Position{
											Column: 12,
											Line:   106,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   106,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 12,
												Line:   106,
											},
										},
									},
									Name: "state",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   107,
						},
						File:   "aggregate.flux",
						Source: "define(\n\tinit: (values) => math.sum(values),\n\treduce: (values, state) => {\n\t\treturn state + math.sum(values)\n\t},\n\tcompute: (state) => state,\n)",
						Start: ast.Position{
							Column: 7,
							Line:   101,
						},
					},
				},
				Callee: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   101,
							},
							File:   "aggregate.flux",
							Source: "define",
							Start: ast.Position{
								Column: 7,
								Line:   101,
							},
						},
					},
					Name: "define",
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   117,
					},
					File:   "aggregate.flux",
					Source: "count = define(\n\tinit: (values) => length(arr: values),\n\treduce: (values, state) => {\n\t\treturn state + length(arr: values)\n\t},\n\tcompute: (state) => state,\n\tfill: 0,\n)",
					Start: ast.Position{
						Column: 1,
						Line:   110,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// count constructs a count aggregate for the column.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   110,
						},
						File:   "aggregate.flux",
						Source: "count",
						Start: ast.Position{
							Column: 1,
							Line:   110,
						},
					},
				},
				Name: "count",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   116,
							},
							File:   "aggregate.flux",
							Source: "init: (values) => length(arr: values),\n\treduce: (values, state) => {\n\t\treturn state + length(arr: values)\n\t},\n\tcompute: (state) => state,\n\tfill: 0",
							Start: ast.Position{
								Column: 2,
								Line:   111,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   111,
								},
								File:   "aggregate.flux",
								Source: "init: (values) => length(arr: values)",
								Start: ast.Position{
									Column: 2,
									Line:   111,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   111,
									},
									File:   "aggregate.flux",
									Source: "init",
									Start: ast.Position{
										Column: 2,
										Line:   111,
									},
								},
							},
							Name: "init",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   111,
									},
									File:   "aggregate.flux",
									Source: "(values) => length(arr: values)",
									Start: ast.Position{
										Column: 8,
										Line:   111,
									},
								},
							},
							Body: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   111,
											},
											File:   "aggregate.flux",
											Source: "arr: values",
											Start: ast.Position{
												Column: 27,
												Line:   111,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   111,
												},
												File:   "aggregate.flux",
												Source: "arr: values",
												Start: ast.Position{
													Column: 27,
													Line:   111,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   111,
													},
													File:   "aggregate.flux",
													Source: "arr",
													Start: ast.Position{
														Column: 27,
														Line:   111,
													},
												},
											},
											Name: "arr",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   111,
													},
													File:   "aggregate.flux",
													Source: "values",
													Start: ast.Position{
														Column: 32,
														Line:   111,
													},
												},
											},
											Name: "values",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   111,
										},
										File:   "aggregate.flux",
										Source: "length(arr: values)",
										Start: ast.Position{
											Column: 20,
											Line:   111,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   111,
											},
											File:   "aggregate.flux",
											Source: "length",
											Start: ast.Position{
												Column: 20,
												Line:   111,
											},
										},
									},
									Name: "length",
								},
								Lparen: nil,
								Rparen: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   111,
										},
										File:   "aggregate.flux",
										Source: "values",
										Start: ast.Position{
											Column: 9,
											Line:   111,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   111,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 9,
												Line:   111,
											},
										},
									},
									Name: "values",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   114,
								},
								File:   "aggregate.flux",
								Source: "reduce: (values, state) => {\n\t\treturn state + length(arr: values)\n\t}",
								Start: ast.Position{
									Column: 2,
									Line:   112,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   112,
									},
									File:   "aggregate.flux",
									Source: "reduce",
									Start: ast.Position{
										Column: 2,
										Line:   112,
									},
								},
							},
							Name: "reduce",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 3,
										Line:   114,
									},
									File:   "aggregate.flux",
									Source: "(values, state) => {\n\t\treturn state + length(arr: values)\n\t}",
									Start: ast.Position{
										Column: 10,
										Line:   112,
									},
								},
							},
							Body: &ast.Block{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 3,
											Line:   114,
										},
										File:   "aggregate.flux",
										Source: "{\n\t\treturn state + length(arr: values)\n\t}",
										Start: ast.Position{
											Column: 29,
											Line:   112,
										},
									},
								},
								Body: []ast.Statement{&ast.ReturnStatement{
									Argument: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   113,
												},
												File:   "aggregate.flux",
												Source: "state + length(arr: values)",
												Start: ast.Position{
													Column: 10,
													Line:   113,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   113,
													},
													File:   "aggregate.flux",
													Source: "state",
													Start: ast.Position{
														Column: 10,
														Line:   113,
													},
												},
											},
											Name: "state",
										},
										Operator: 5,
										Right: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   113,
														},
														File:   "aggregate.flux",
														Source: "arr: values",
														Start: ast.Position{
															Column: 25,
															Line:   113,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   113,
															},
															File:   "aggregate.flux",
															Source: "arr: values",
															Start: ast.Position{
																Column: 25,
																Line:   113,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 28,
																	Line:   113,
																},
																File:   "aggregate.flux",
																Source: "arr",
																Start: ast.Position{
																	Column: 25,
																	Line:   113,
																},
															},
														},
														Name: "arr",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   113,
																},
																File:   "aggregate.flux",
																Source: "values",
																Start: ast.Position{
																	Column: 30,
																	Line:   113,
																},
															},
														},
														Name: "values",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   113,
													},
													File:   "aggregate.flux",
													Source: "length(arr: values)",
													Start: ast.Position{
														Column: 18,
														Line:   113,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   113,
														},
														File:   "aggregate.flux",
														Source: "length",
														Start: ast.Position{
															Column: 18,
															Line:   113,
														},
													},
												},
												Name: "length",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   113,
											},
											File:   "aggregate.flux",
											Source: "return state + length(arr: values)",
											Start: ast.Position{
												Column: 3,
												Line:   113,
											},
										},
									},
								}},
								Lbrace: nil,
								Rbrace: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   112,
										},
										File:   "aggregate.flux",
										Source: "values",
										Start: ast.Position{
											Column: 11,
											Line:   112,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   112,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 11,
												Line:   112,
											},
										},
									},
									Name: "values",
								},
								Separator: nil,
								Value:     nil,
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   112,
										},
										File:   "aggregate.flux",
										Source: "state",
										Start: ast.Position{
											Column: 19,
											Line:   112,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   112,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 19,
												Line:   112,
											},
										},
									},
									Name: "state",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   115,
								},
								File:   "aggregate.flux",
								Source: "compute: (state) => state",
								Start: ast.Position{
									Column: 2,
									Line:   115,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   115,
									},
									File:   "aggregate.flux",
									Source: "compute",
									Start: ast.Position{
										Column: 2,
										Line:   115,
									},
								},
							},
							Name: "compute",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   115,
									},
									File:   "aggregate.flux",
									Source: "(state) => state",
									Start: ast.Position{
										Column: 11,
										Line:   115,
									},
								},
							},
							Body: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   115,
										},
										File:   "aggregate.flux",
										Source: "state",
										Start: ast.Position{
											Column: 22,
											Line:   115,
										},
									},
								},
								Name: "state",
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   115,
										},
										File:   "aggregate.flux",
										Source: "state",
										Start: ast.Position{
											Column: 12,
											Line:   115,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   115,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 12,
												Line:   115,
											},
										},
									},
									Name: "state",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   116,
								},
								File:   "aggregate.flux",
								Source: "fill: 0",
								Start: ast.Position{
									Column: 2,
									Line:   116,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   116,
									},
									File:   "aggregate.flux",
									Source: "fill",
									Start: ast.Position{
										Column: 2,
										Line:   116,
									},
								},
							},
							Name: "fill",
						},
						Separator: nil,
						Value: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   116,
									},
									File:   "aggregate.flux",
									Source: "0",
									Start: ast.Position{
										Column: 8,
										Line:   116,
									},
								},
							},
							Value: int64(0),
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   117,
						},
						File:   "aggregate.flux",
						Source: "define(\n\tinit: (values) => length(arr: values),\n\treduce: (values, state) => {\n\t\treturn state + length(arr: values)\n\t},\n\tcompute: (state) => state,\n\tfill: 0,\n)",
						Start: ast.Position{
							Column: 9,
							Line:   110,
						},
					},
				},
				Callee: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   110,
							},
							File:   "aggregate.flux",
							Source: "define",
							Start: ast.Position{
								Column: 9,
								Line:   110,
							},
						},
					},
					Name: "define",
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   130,
					},
					File:   "aggregate.flux",
					Source: "mean = define(\n\tinit: (values) => ({\n\t\tsum: math.sum(values),\n\t\tcount: length(arr: values),\n\t}),\n\treduce: (values, state) => ({\n\t\tsum: state.sum + math.sum(values),\n\t\tcount: state.count + length(arr: values),\n\t}),\n\tcompute: (state) => float(v: state.sum) / float(v: state.count),\n)",
					Start: ast.Position{
						Column: 1,
						Line:   120,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// mean constructs a mean aggregate for the column.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   120,
						},
						File:   "aggregate.flux",
						Source: "mean",
						Start: ast.Position{
							Column: 1,
							Line:   120,
						},
					},
				},
				Name: "mean",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   129,
							},
							File:   "aggregate.flux",
							Source: "init: (values) => ({\n\t\tsum: math.sum(values),\n\t\tcount: length(arr: values),\n\t}),\n\treduce: (values, state) => ({\n\t\tsum: state.sum + math.sum(values),\n\t\tcount: state.count + length(arr: values),\n\t}),\n\tcompute: (state) => float(v: state.sum) / float(v: state.count)",
							Start: ast.Position{
								Column: 2,
								Line:   121,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 4,
									Line:   124,
								},
								File:   "aggregate.flux",
								Source: "init: (values) => ({\n\t\tsum: math.sum(values),\n\t\tcount: length(arr: values),\n\t})",
								Start: ast.Position{
									Column: 2,
									Line:   121,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   121,
									},
									File:   "aggregate.flux",
									Source: "init",
									Start: ast.Position{
										Column: 2,
										Line:   121,
									},
								},
							},
							Name: "init",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 4,
										Line:   124,
									},
									File:   "aggregate.flux",
									Source: "(values) => ({\n\t\tsum: math.sum(values),\n\t\tcount: length(arr: values),\n\t})",
									Start: ast.Position{
										Column: 8,
										Line:   121,
									},
								},
							},
							Body: &ast.ParenExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 4,
											Line:   124,
										},
										File:   "aggregate.flux",
										Source: "({\n\t\tsum: math.sum(values),\n\t\tcount: length(arr: values),\n\t})",
										Start: ast.Position{
											Column: 20,
											Line:   121,
										},
									},
								},
								Expression: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 3,
												Line:   124,
											},
											File:   "aggregate.flux",
											Source: "{\n\t\tsum: math.sum(values),\n\t\tcount: length(arr: values),\n\t}",
											Start: ast.Position{
												Column: 21,
												Line:   121,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   122,
												},
												File:   "aggregate.flux",
												Source: "sum: math.sum(values)",
												Start: ast.Position{
													Column: 3,
													Line:   122,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 6,
														Line:   122,
													},
													File:   "aggregate.flux",
													Source: "sum",
													Start: ast.Position{
														Column: 3,
														Line:   122,
													},
												},
											},
											Name: "sum",
										},
										Separator: nil,
										Value: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 23,
															Line:   122,
														},
														File:   "aggregate.flux",
														Source: "values",
														Start: ast.Position{
															Column: 17,
															Line:   122,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   122,
															},
															File:   "aggregate.flux",
															Source: "values",
															Start: ast.Position{
																Column: 17,
																Line:   122,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   122,
																},
																File:   "aggregate.flux",
																Source: "values",
																Start: ast.Position{
																	Column: 17,
																	Line:   122,
																},
															},
														},
														Name: "values",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   122,
													},
													File:   "aggregate.flux",
													Source: "math.sum(values)",
													Start: ast.Position{
														Column: 8,
														Line:   122,
													},
												},
											},
											Callee: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   122,
														},
														File:   "aggregate.flux",
														Source: "math.sum",
														Start: ast.Position{
															Column: 8,
															Line:   122,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 12,
																Line:   122,
															},
															File:   "aggregate.flux",
															Source: "math",
															Start: ast.Position{
																Column: 8,
																Line:   122,
															},
														},
													},
													Name: "math",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 16,
																Line:   122,
															},
															File:   "aggregate.flux",
															Source: "sum",
															Start: ast.Position{
																Column: 13,
																Line:   122,
															},
														},
													},
													Name: "sum",
												},
												Rbrack: nil,
											},
											Lparen: nil,
											Rparen: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   123,
												},
												File:   "aggregate.flux",
												Source: "count: length(arr: values)",
												Start: ast.Position{
													Column: 3,
													Line:   123,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 8,
														Line:   123,
													},
													File:   "aggregate.flux",
													Source: "count",
													Start: ast.Position{
														Column: 3,
														Line:   123,
													},
												},
											},
											Name: "count",
										},
										Separator: nil,
										Value: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   123,
														},
														File:   "aggregate.flux",
														Source: "arr: values",
														Start: ast.Position{
															Column: 17,
															Line:   123,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   123,
															},
															File:   "aggregate.flux",
															Source: "arr: values",
															Start: ast.Position{
																Column: 17,
																Line:   123,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 20,
																	Line:   123,
																},
																File:   "aggregate.flux",
																Source: "arr",
																Start: ast.Position{
																	Column: 17,
																	Line:   123,
																},
															},
														},
														Name: "arr",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 28,
																	Line:   123,
																},
																File:   "aggregate.flux",
																Source: "values",
																Start: ast.Position{
																	Column: 22,
																	Line:   123,
																},
															},
														},
														Name: "values",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   123,
													},
													File:   "aggregate.flux",
													Source: "length(arr: values)",
													Start: ast.Position{
														Column: 10,
														Line:   123,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   123,
														},
														File:   "aggregate.flux",
														Source: "length",
														Start: ast.Position{
															Column: 10,
															Line:   123,
														},
													},
												},
												Name: "length",
											},
											Lparen: nil,
											Rparen: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   121,
										},
										File:   "aggregate.flux",
										Source: "values",
										Start: ast.Position{
											Column: 9,
											Line:   121,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   121,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 9,
												Line:   121,
											},
										},
									},
									Name: "values",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 4,
									Line:   128,
								},
								File:   "aggregate.flux",
								Source: "reduce: (values, state) => ({\n\t\tsum: state.sum + math.sum(values),\n\t\tcount: state.count + length(arr: values),\n\t})",
								Start: ast.Position{
									Column: 2,
									Line:   125,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   125,
									},
									File:   "aggregate.flux",
									Source: "reduce",
									Start: ast.Position{
										Column: 2,
										Line:   125,
									},
								},
							},
							Name: "reduce",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 4,
										Line:   128,
									},
									File:   "aggregate.flux",
									Source: "(values, state) => ({\n\t\tsum: state.sum + math.sum(values),\n\t\tcount: state.count + length(arr: values),\n\t})",
									Start: ast.Position{
										Column: 10,
										Line:   125,
									},
								},
							},
							Body: &ast.ParenExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 4,
											Line:   128,
										},
										File:   "aggregate.flux",
										Source: "({\n\t\tsum: state.sum + math.sum(values),\n\t\tcount: state.count + length(arr: values),\n\t})",
										Start: ast.Position{
											Column: 29,
											Line:   125,
										},
									},
								},
								Expression: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 3,
												Line:   128,
											},
											File:   "aggregate.flux",
											Source: "{\n\t\tsum: state.sum + math.sum(values),\n\t\tcount: state.count + length(arr: values),\n\t}",
											Start: ast.Position{
												Column: 30,
												Line:   125,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   126,
												},
												File:   "aggregate.flux",
												Source: "sum: state.sum + math.sum(values)",
												Start: ast.Position{
													Column: 3,
													Line:   126,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 6,
														Line:   126,
													},
													File:   "aggregate.flux",
													Source: "sum",
													Start: ast.Position{
														Column: 3,
														Line:   126,
													},
												},
											},
											Name: "sum",
										},
										Separator: nil,
										Value: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   126,
													},
													File:   "aggregate.flux",
													Source: "state.sum + math.sum(values)",
													Start: ast.Position{
														Column: 8,
														Line:   126,
													},
												},
											},
											Left: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   126,
														},
														File:   "aggregate.flux",
														Source: "state.sum",
														Start: ast.Position{
															Column: 8,
															Line:   126,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 13,
																Line:   126,
															},
															File:   "aggregate.flux",
															Source: "state",
															Start: ast.Position{
																Column: 8,
																Line:   126,
															},
														},
													},
													Name: "state",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 17,
																Line:   126,
															},
															File:   "aggregate.flux",
															Source: "sum",
															Start: ast.Position{
																Column: 14,
																Line:   126,
															},
														},
													},
													Name: "sum",
												},
												Rbrack: nil,
											},
											Operator: 5,
											Right: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   126,
															},
															File:   "aggregate.flux",
															Source: "values",
															Start: ast.Position{
																Column: 29,
																Line:   126,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 35,
																	Line:   126,
																},
																File:   "aggregate.flux",
																Source: "values",
																Start: ast.Position{
																	Column: 29,
																	Line:   126,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 35,
																		Line:   126,
																	},
																	File:   "aggregate.flux",
																	Source: "values",
																	Start: ast.Position{
																		Column: 29,
																		Line:   126,
																	},
																},
															},
															Name: "values",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   126,
														},
														File:   "aggregate.flux",
														Source: "math.sum(values)",
														Start: ast.Position{
															Column: 20,
															Line:   126,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   126,
															},
															File:   "aggregate.flux",
															Source: "math.sum",
															Start: ast.Position{
																Column: 20,
																Line:   126,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 24,
																	Line:   126,
																},
																File:   "aggregate.flux",
																Source: "math",
																Start: ast.Position{
																	Column: 20,
																	Line:   126,
																},
															},
														},
														Name: "math",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 28,
																	Line:   126,
																},
																File:   "aggregate.flux",
																Source: "sum",
																Start: ast.Position{
																	Column: 25,
																	Line:   126,
																},
															},
														},
														Name: "sum",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   127,
												},
												File:   "aggregate.flux",
												Source: "count: state.count + length(arr: values)",
												Start: ast.Position{
													Column: 3,
													Line:   127,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 8,
														Line:   127,
													},
													File:   "aggregate.flux",
													Source: "count",
													Start: ast.Position{
														Column: 3,
														Line:   127,
													},
												},
											},
											Name: "count",
										},
										Separator: nil,
										Value: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   127,
													},
													File:   "aggregate.flux",
													Source: "state.count + length(arr: values)",
													Start: ast.Position{
														Column: 10,
														Line:   127,
													},
												},
											},
											Left: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   127,
														},
														File:   "aggregate.flux",
														Source: "state.count",
														Start: ast.Position{
															Column: 10,
															Line:   127,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   127,
															},
															File:   "aggregate.flux",
															Source: "state",
															Start: ast.Position{
																Column: 10,
																Line:   127,
															},
														},
													},
													Name: "state",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   127,
															},
															File:   "aggregate.flux",
															Source: "count",
															Start: ast.Position{
																Column: 16,
																Line:   127,
															},
														},
													},
													Name: "count",
												},
												Rbrack: nil,
											},
											Operator: 5,
											Right: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 42,
																Line:   127,
															},
															File:   "aggregate.flux",
															Source: "arr: values",
															Start: ast.Position{
																Column: 31,
																Line:   127,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   127,
																},
																File:   "aggregate.flux",
																Source: "arr: values",
																Start: ast.Position{
																	Column: 31,
																	Line:   127,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   127,
																	},
																	File:   "aggregate.flux",
																	Source: "arr",
																	Start: ast.Position{
																		Column: 31,
																		Line:   127,
																	},
																},
															},
															Name: "arr",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 42,
																		Line:   127,
																	},
																	File:   "aggregate.flux",
																	Source: "values",
																	Start: ast.Position{
																		Column: 36,
																		Line:   127,
																	},
																},
															},
															Name: "values",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   127,
														},
														File:   "aggregate.flux",
														Source: "length(arr: values)",
														Start: ast.Position{
															Column: 24,
															Line:   127,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   127,
															},
															File:   "aggregate.flux",
															Source: "length",
															Start: ast.Position{
																Column: 24,
																Line:   127,
															},
														},
													},
													Name: "length",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
									}},
									Rbrace: nil,
									With:   nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   125,
										},
										File:   "aggregate.flux",
										Source: "values",
										Start: ast.Position{
											Column: 11,
											Line:   125,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   125,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 11,
												Line:   125,
											},
										},
									},
									Name: "values",
								},
								Separator: nil,
								Value:     nil,
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   125,
										},
										File:   "aggregate.flux",
										Source: "state",
										Start: ast.Position{
											Column: 19,
											Line:   125,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   125,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 19,
												Line:   125,
											},
										},
									},
									Name: "state",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   129,
								},
								File:   "aggregate.flux",
								Source: "compute: (state) => float(v: state.sum) / float(v: state.count)",
								Start: ast.Position{
									Column: 2,
									Line:   129,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   129,
									},
									File:   "aggregate.flux",
									Source: "compute",
									Start: ast.Position{
										Column: 2,
										Line:   129,
									},
								},
							},
							Name: "compute",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   129,
									},
									File:   "aggregate.flux",
									Source: "(state) => float(v: state.sum) / float(v: state.count)",
									Start: ast.Position{
										Column: 11,
										Line:   129,
									},
								},
							},
							Body: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   129,
										},
										File:   "aggregate.flux",
										Source: "float(v: state.sum) / float(v: state.count)",
										Start: ast.Position{
											Column: 22,
											Line:   129,
										},
									},
								},
								Left: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   129,
												},
												File:   "aggregate.flux",
												Source: "v: state.sum",
												Start: ast.Position{
													Column: 28,
													Line:   129,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   129,
													},
													File:   "aggregate.flux",
													Source: "v: state.sum",
													Start: ast.Position{
														Column: 28,
														Line:   129,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   129,
														},
														File:   "aggregate.flux",
														Source: "v",
														Start: ast.Position{
															Column: 28,
															Line:   129,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   129,
														},
														File:   "aggregate.flux",
														Source: "state.sum",
														Start: ast.Position{
															Column: 31,
															Line:   129,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   129,
															},
															File:   "aggregate.flux",
															Source: "state",
															Start: ast.Position{
																Column: 31,
																Line:   129,
															},
														},
													},
													Name: "state",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   129,
															},
															File:   "aggregate.flux",
															Source: "sum",
															Start: ast.Position{
																Column: 37,
																Line:   129,
															},
														},
													},
													Name: "sum",
												},
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   129,
											},
											File:   "aggregate.flux",
											Source: "float(v: state.sum)",
											Start: ast.Position{
												Column: 22,
												Line:   129,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   129,
												},
												File:   "aggregate.flux",
												Source: "float",
												Start: ast.Position{
													Column: 22,
													Line:   129,
												},
											},
										},
										Name: "float",
									},
									Lparen: nil,
									Rparen: nil,
								},
								Operator: 2,
								Right: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 64,
													Line:   129,
												},
												File:   "aggregate.flux",
												Source: "v: state.count",
												Start: ast.Position{
													Column: 50,
													Line:   129,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   129,
													},
													File:   "aggregate.flux",
													Source: "v: state.count",
													Start: ast.Position{
														Column: 50,
														Line:   129,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 51,
															Line:   129,
														},
														File:   "aggregate.flux",
														Source: "v",
														Start: ast.Position{
															Column: 50,
															Line:   129,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   129,
														},
														File:   "aggregate.flux",
														Source: "state.count",
														Start: ast.Position{
															Column: 53,
															Line:   129,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 58,
																Line:   129,
															},
															File:   "aggregate.flux",
															Source: "state",
															Start: ast.Position{
																Column: 53,
																Line:   129,
															},
														},
													},
													Name: "state",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 64,
																Line:   129,
															},
															File:   "aggregate.flux",
															Source: "count",
															Start: ast.Position{
																Column: 59,
																Line:   129,
															},
														},
													},
													Name: "count",
												},
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   129,
											},
											File:   "aggregate.flux",
											Source: "float(v: state.count)",
											Start: ast.Position{
												Column: 44,
												Line:   129,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   129,
												},
												File:   "aggregate.flux",
												Source: "float",
												Start: ast.Position{
													Column: 44,
													Line:   129,
												},
											},
										},
										Name: "float",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   129,
										},
										File:   "aggregate.flux",
										Source: "state",
										Start: ast.Position{
											Column: 12,
											Line:   129,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   129,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 12,
												Line:   129,
											},
										},
									},
									Name: "state",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   130,
						},
						File:   "aggregate.flux",
						Source: "define(\n\tinit: (values) => ({\n\t\tsum: math.sum(values),\n\t\tcount: length(arr: values),\n\t}),\n\treduce: (values, state) => ({\n\t\tsum: state.sum + math.sum(values),\n\t\tcount: state.count + length(arr: values),\n\t}),\n\tcompute: (state) => float(v: state.sum) / float(v: state.count),\n)",
						Start: ast.Position{
							Column: 8,
							Line:   120,
						},
					},
				},
				Callee: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   120,
							},
							File:   "aggregate.flux",
							Source: "define",
							Start: ast.Position{
								Column: 8,
								Line:   120,
							},
						},
					},
					Name: "define",
				},
				Lparen: nil,
				Rparen: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 33,
						Line:   3,
					},
					File:   "aggregate.flux",
					Source: "import \"contrib/jsternberg/math\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   3,
						},
						File:   "aggregate.flux",
						Source: "\"contrib/jsternberg/math\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "contrib/jsternberg/math",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "aggregate.flux",
					Source: "package aggregate",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "aggregate.flux",
						Source: "aggregate",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "aggregate",
			},
		},
	}},
	Package: "aggregate",
	Path:    "contrib/jsternberg/aggregate",
}
